//[okhttp-tls](../../../../index.md)/[okhttp3.tls](../../index.md)/[HeldCertificate](../index.md)/[Companion](index.md)/[decode](decode.md)

# decode

[jvm]\

@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)

fun [decode](decode.md)(certificateAndPrivateKeyPem: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HeldCertificate](../index.md)

Decodes a multiline string that contains both a [certificate](../certificate-pem.md) and a [private key](../private-key-pkcs8-pem.md), both [PEM-encoded](https://tools.ietf.org/html/rfc7468). A typical input string looks like this:

-----BEGIN CERTIFICATE-----\
MIIBYTCCAQegAwIBAgIBKjAKBggqhkjOPQQDAjApMRQwEgYDVQQLEwtlbmdpbmVl\
cmluZzERMA8GA1UEAxMIY2FzaC5hcHAwHhcNNzAwMTAxMDAwMDA1WhcNNzAwMTAx\
MDAwMDEwWjApMRQwEgYDVQQLEwtlbmdpbmVlcmluZzERMA8GA1UEAxMIY2FzaC5h\
cHAwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAASda8ChkQXxGELnrV/oBnIAx3dD\
ocUOJfdz4pOJTP6dVQB9U3UBiW5uSX/MoOD0LL5zG3bVyL3Y6pDwKuYvfLNhoyAw\
HjAcBgNVHREBAf8EEjAQhwQBAQEBgghjYXNoLmFwcDAKBggqhkjOPQQDAgNIADBF\
AiAyHHg1N6YDDQiY920+cnI5XSZwEGhAtb9PYWO8bLmkcQIhAI2CfEZf3V/obmdT\
yyaoEufLKVXhrTQhRfodTeigi4RX\
-----END CERTIFICATE-----\
-----BEGIN PRIVATE KEY-----\
MEECAQAwEwYHKoZIzj0CAQYIKoZIzj0DAQcEJzAlAgEBBCA7ODT0xhGSNn4ESj6J\
lu/GJQZoU9lDrCPeUcQ28tzOWw==\
-----END PRIVATE KEY-----

The string should contain exactly one certificate and one private key in [PKCS #8](https://tools.ietf.org/html/rfc5208) format. It should not contain any other PEM-encoded blocks, but it may contain other text which will be ignored.

Encode a held certificate into this format by concatenating the results of [certificatePem()](../certificate-pem.md) and [privateKeyPkcs8Pem()](../private-key-pkcs8-pem.md).
