//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[CertificatePinner](../index.md)/[Pin](index.md)

# Pin

[jvm]\
class [Pin](index.md)(pattern: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), pin: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))

A hostname pattern and certificate hash for Certificate Pinning.

## Constructors

| | |
|---|---|
| [Pin](-pin.md) | [jvm]<br>fun [Pin](-pin.md)(pattern: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), pin: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) |

## Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | [jvm]<br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | [jvm]<br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [matchesCertificate](matches-certificate.md) | [jvm]<br>fun [matchesCertificate](matches-certificate.md)(certificate: [X509Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/X509Certificate.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [matchesHostname](matches-hostname.md) | [jvm]<br>fun [matchesHostname](matches-hostname.md)(hostname: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [hash](hash.md) | [jvm]<br>val [hash](hash.md): [ByteString](https://square.github.io/okio/2.x/okio/okio/-byte-string/index.html)<br>The hash of the pinned certificate using [hashAlgorithm](hash-algorithm.md). |
| [hashAlgorithm](hash-algorithm.md) | [jvm]<br>val [hashAlgorithm](hash-algorithm.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Either sha1 or sha256. |
| [pattern](pattern.md) | [jvm]<br>val [pattern](pattern.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>A hostname like example.com or a pattern like *.example.com (canonical form). |
