/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.internal.tls.CertificateChainCleaner;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001e\u001f B\u001f\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0087\b\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J%\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0018J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u000bH\u00d6\u0001J\u0017\u0010\u001c\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u001dR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lokhttp3/CertificatePinner;", "", "pins", "", "Lokhttp3/CertificatePinner$Pin;", "certificateChainCleaner", "Lokhttp3/internal/tls/CertificateChainCleaner;", "(Ljava/util/Set;Lokhttp3/internal/tls/CertificateChainCleaner;)V", "check", "", "hostname", "", "peerCertificates", "", "Ljava/security/cert/Certificate;", "(Ljava/lang/String;[Ljava/security/cert/Certificate;)V", "", "component1", "component2", "copy", "equals", "", "other", "findMatchingPins", "findMatchingPins$okhttp", "hashCode", "", "toString", "withCertificateChainCleaner", "withCertificateChainCleaner$okhttp", "Builder", "Companion", "Pin", "okhttp"})
public final class CertificatePinner {
    private final Set<Pin> pins;
    private final CertificateChainCleaner certificateChainCleaner;
    @NotNull
    public static final String WILDCARD = "*.";
    @JvmField
    @NotNull
    public static final CertificatePinner DEFAULT;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void check(@NotNull String hostname, @NotNull List<? extends Certificate> peerCertificates) throws SSLPeerUnverifiedException {
        Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
        Intrinsics.checkParameterIsNotNull(peerCertificates, (String)"peerCertificates");
        List<? extends Certificate> peerCertificates2 = peerCertificates;
        List<Pin> pins = this.findMatchingPins$okhttp(hostname);
        if (pins.isEmpty()) {
            return;
        }
        if (this.certificateChainCleaner != null) {
            peerCertificates2 = this.certificateChainCleaner.clean(peerCertificates2, hostname);
        }
        Iterator<? extends Certificate> iterator = peerCertificates2.iterator();
        while (iterator.hasNext()) {
            Certificate peerCertificate;
            Certificate certificate = peerCertificate = iterator.next();
            if (certificate == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            X509Certificate x509Certificate = (X509Certificate)certificate;
            ByteString sha1 = null;
            ByteString sha256 = null;
            block9: for (Pin pin : pins) {
                switch (pin.getHashAlgorithm()) {
                    case "sha256/": {
                        if (sha256 == null) {
                            sha256 = Companion.sha256$okhttp(x509Certificate);
                        }
                        if (!Intrinsics.areEqual((Object)pin.getHash(), (Object)sha256)) continue block9;
                        return;
                    }
                    case "sha1/": {
                        if (sha1 == null) {
                            sha1 = Companion.sha1$okhttp(x509Certificate);
                        }
                        if (!Intrinsics.areEqual((Object)pin.getHash(), (Object)sha1)) continue block9;
                        return;
                    }
                }
                throw (Throwable)((Object)new AssertionError((Object)("unsupported hashAlgorithm: " + pin.getHashAlgorithm())));
            }
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("Certificate pinning failure!");
        $this$buildString.append("\n  Peer certificate chain:");
        int n = 0;
        int n2 = peerCertificates2.size();
        while (n < n2) {
            void c;
            Certificate certificate = peerCertificates2.get((int)c);
            if (certificate == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            X509Certificate x509Certificate = (X509Certificate)certificate;
            $this$buildString.append("\n    ");
            $this$buildString.append(Companion.pin(x509Certificate));
            $this$buildString.append(": ");
            Principal principal = x509Certificate.getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"x509Certificate.subjectDN");
            $this$buildString.append(principal.getName());
            ++c;
        }
        $this$buildString.append("\n  Pinned certificates for ");
        $this$buildString.append(hostname);
        $this$buildString.append(":");
        for (Pin pin : pins) {
            $this$buildString.append("\n    ");
            $this$buildString.append(pin);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String message = string;
        throw (Throwable)new SSLPeerUnverifiedException(message);
    }

    @Deprecated(message="replaced with {@link #check(String, List)}.", replaceWith=@ReplaceWith(imports={}, expression="check(hostname, peerCertificates.toList())"))
    public final void check(@NotNull String hostname, Certificate ... peerCertificates) throws SSLPeerUnverifiedException {
        int $i$f$check = 0;
        Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
        Intrinsics.checkParameterIsNotNull((Object)peerCertificates, (String)"peerCertificates");
        this.check(hostname, ArraysKt.toList((Object[])peerCertificates));
    }

    @NotNull
    public final List<Pin> findMatchingPins$okhttp(@NotNull String hostname) {
        Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
        List result = CollectionsKt.emptyList();
        for (Pin pin : this.pins) {
            if (!pin.matches(hostname)) continue;
            if (result.isEmpty()) {
                boolean bl = false;
                result = new ArrayList();
            }
            List list = result;
            if (list == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<okhttp3.CertificatePinner.Pin>");
            }
            TypeIntrinsics.asMutableList((Object)list).add(pin);
        }
        return result;
    }

    @NotNull
    public final CertificatePinner withCertificateChainCleaner$okhttp(@Nullable CertificateChainCleaner certificateChainCleaner) {
        return Intrinsics.areEqual((Object)this.certificateChainCleaner, (Object)certificateChainCleaner) ? this : new CertificatePinner(this.pins, certificateChainCleaner);
    }

    public CertificatePinner(@NotNull Set<Pin> pins, @Nullable CertificateChainCleaner certificateChainCleaner) {
        Intrinsics.checkParameterIsNotNull(pins, (String)"pins");
        this.pins = pins;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    static {
        Companion = new Companion(null);
        DEFAULT = new Builder().build();
    }

    private final Set<Pin> component1() {
        return this.pins;
    }

    private final CertificateChainCleaner component2() {
        return this.certificateChainCleaner;
    }

    @NotNull
    public final CertificatePinner copy(@NotNull Set<Pin> pins, @Nullable CertificateChainCleaner certificateChainCleaner) {
        Intrinsics.checkParameterIsNotNull(pins, (String)"pins");
        return new CertificatePinner(pins, certificateChainCleaner);
    }

    @NotNull
    public static /* synthetic */ CertificatePinner copy$default(CertificatePinner certificatePinner, Set set, CertificateChainCleaner certificateChainCleaner, int n, Object object) {
        if ((n & 1) != 0) {
            set = certificatePinner.pins;
        }
        if ((n & 2) != 0) {
            certificateChainCleaner = certificatePinner.certificateChainCleaner;
        }
        return certificatePinner.copy(set, certificateChainCleaner);
    }

    @NotNull
    public String toString() {
        return "CertificatePinner(pins=" + this.pins + ", certificateChainCleaner=" + this.certificateChainCleaner + ")";
    }

    public int hashCode() {
        Set<Pin> set = this.pins;
        CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
        return (set != null ? ((Object)set).hashCode() : 0) * 31 + (certificateChainCleaner != null ? certificateChainCleaner.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CertificatePinner)) break block3;
                CertificatePinner certificatePinner = (CertificatePinner)object;
                if (!Intrinsics.areEqual(this.pins, certificatePinner.pins) || !Intrinsics.areEqual((Object)this.certificateChainCleaner, (Object)certificatePinner.certificateChainCleaner)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final String pin(@NotNull Certificate certificate) {
        return Companion.pin(certificate);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001b"}, d2={"Lokhttp3/CertificatePinner$Pin;", "", "pattern", "", "canonicalHostname", "hashAlgorithm", "hash", "Lokio/ByteString;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lokio/ByteString;)V", "getHash", "()Lokio/ByteString;", "getHashAlgorithm", "()Ljava/lang/String;", "getPattern", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "matches", "hostname", "toString", "okhttp"})
    public static final class Pin {
        @NotNull
        private final String pattern;
        private final String canonicalHostname;
        @NotNull
        private final String hashAlgorithm;
        @NotNull
        private final ByteString hash;

        public final boolean matches(@NotNull String hostname) {
            Intrinsics.checkParameterIsNotNull((Object)hostname, (String)"hostname");
            if (StringsKt.startsWith$default((String)this.pattern, (String)CertificatePinner.WILDCARD, (boolean)false, (int)2, null)) {
                int firstDot = StringsKt.indexOf$default((CharSequence)hostname, (char)'.', (int)0, (boolean)false, (int)6, null);
                return hostname.length() - firstDot - 1 == this.canonicalHostname.length() && StringsKt.regionMatches((String)hostname, (int)(firstDot + 1), (String)this.canonicalHostname, (int)0, (int)this.canonicalHostname.length(), (boolean)false);
            }
            return Intrinsics.areEqual((Object)hostname, (Object)this.canonicalHostname);
        }

        @NotNull
        public String toString() {
            return this.hashAlgorithm + this.hash.base64();
        }

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        @NotNull
        public final String getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        @NotNull
        public final ByteString getHash() {
            return this.hash;
        }

        public Pin(@NotNull String pattern, @NotNull String canonicalHostname, @NotNull String hashAlgorithm, @NotNull ByteString hash) {
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            Intrinsics.checkParameterIsNotNull((Object)canonicalHostname, (String)"canonicalHostname");
            Intrinsics.checkParameterIsNotNull((Object)hashAlgorithm, (String)"hashAlgorithm");
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            this.pattern = pattern;
            this.canonicalHostname = canonicalHostname;
            this.hashAlgorithm = hashAlgorithm;
            this.hash = hash;
        }

        @NotNull
        public final String component1() {
            return this.pattern;
        }

        private final String component2() {
            return this.canonicalHostname;
        }

        @NotNull
        public final String component3() {
            return this.hashAlgorithm;
        }

        @NotNull
        public final ByteString component4() {
            return this.hash;
        }

        @NotNull
        public final Pin copy(@NotNull String pattern, @NotNull String canonicalHostname, @NotNull String hashAlgorithm, @NotNull ByteString hash) {
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            Intrinsics.checkParameterIsNotNull((Object)canonicalHostname, (String)"canonicalHostname");
            Intrinsics.checkParameterIsNotNull((Object)hashAlgorithm, (String)"hashAlgorithm");
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            return new Pin(pattern, canonicalHostname, hashAlgorithm, hash);
        }

        @NotNull
        public static /* synthetic */ Pin copy$default(Pin pin, String string, String string2, String string3, ByteString byteString, int n, Object object) {
            if ((n & 1) != 0) {
                string = pin.pattern;
            }
            if ((n & 2) != 0) {
                string2 = pin.canonicalHostname;
            }
            if ((n & 4) != 0) {
                string3 = pin.hashAlgorithm;
            }
            if ((n & 8) != 0) {
                byteString = pin.hash;
            }
            return pin.copy(string, string2, string3, byteString);
        }

        public int hashCode() {
            String string = this.pattern;
            String string2 = this.canonicalHostname;
            String string3 = this.hashAlgorithm;
            ByteString byteString = this.hash;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (byteString != null ? byteString.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Pin)) break block3;
                    Pin pin = (Pin)object;
                    if (!Intrinsics.areEqual((Object)this.pattern, (Object)pin.pattern) || !Intrinsics.areEqual((Object)this.canonicalHostname, (Object)pin.canonicalHostname) || !Intrinsics.areEqual((Object)this.hashAlgorithm, (Object)pin.hashAlgorithm) || !Intrinsics.areEqual((Object)this.hash, (Object)pin.hash)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\t\"\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/CertificatePinner$Builder;", "", "()V", "pins", "", "Lokhttp3/CertificatePinner$Pin;", "add", "pattern", "", "", "(Ljava/lang/String;[Ljava/lang/String;)Lokhttp3/CertificatePinner$Builder;", "build", "Lokhttp3/CertificatePinner;", "okhttp"})
    public static final class Builder {
        private final List<Pin> pins;

        @NotNull
        public final Builder add(@NotNull String pattern, String ... pins) {
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            Intrinsics.checkParameterIsNotNull((Object)pins, (String)"pins");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            for (String pin : pins) {
                $this$apply.pins.add(Companion.newPin$okhttp(pattern, pin));
            }
            return builder;
        }

        @NotNull
        public final CertificatePinner build() {
            return new CertificatePinner(CollectionsKt.toSet((Iterable)this.pins), null);
        }

        public Builder() {
            List list;
            Builder builder = this;
            boolean bl = false;
            builder.pins = list = (List)new ArrayList();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000bJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0014R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lokhttp3/CertificatePinner$Companion;", "", "()V", "DEFAULT", "Lokhttp3/CertificatePinner;", "WILDCARD", "", "newPin", "Lokhttp3/CertificatePinner$Pin;", "pattern", "pin", "newPin$okhttp", "certificate", "Ljava/security/cert/Certificate;", "sha1", "Lokio/ByteString;", "x509Certificate", "Ljava/security/cert/X509Certificate;", "sha1$okhttp", "sha256", "sha256$okhttp", "okhttp"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String pin(@NotNull Certificate certificate) {
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            boolean bl = certificate instanceof X509Certificate;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Certificate pinning requires X509 certificates";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return "sha256/" + this.sha256$okhttp((X509Certificate)certificate).base64();
        }

        @NotNull
        public final ByteString sha1$okhttp(@NotNull X509Certificate x509Certificate) {
            Intrinsics.checkParameterIsNotNull((Object)x509Certificate, (String)"x509Certificate");
            PublicKey publicKey = x509Certificate.getPublicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"x509Certificate.publicKey");
            byte[] byArray = publicKey.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"x509Certificate.publicKey.encoded");
            return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null).sha1();
        }

        @NotNull
        public final ByteString sha256$okhttp(@NotNull X509Certificate x509Certificate) {
            Intrinsics.checkParameterIsNotNull((Object)x509Certificate, (String)"x509Certificate");
            PublicKey publicKey = x509Certificate.getPublicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"x509Certificate.publicKey");
            byte[] byArray = publicKey.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"x509Certificate.publicKey.encoded");
            return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null).sha256();
        }

        @NotNull
        public final Pin newPin$okhttp(@NotNull String pattern, @NotNull String pin) {
            Pin pin2;
            ByteString hash;
            String string;
            int n;
            HttpUrl.Companion companion;
            CharSequence charSequence;
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            Intrinsics.checkParameterIsNotNull((Object)pin, (String)"pin");
            if (StringsKt.startsWith$default((String)pattern, (String)CertificatePinner.WILDCARD, (boolean)false, (int)2, null)) {
                String string2 = pattern;
                int n2 = CertificatePinner.WILDCARD.length();
                charSequence = new StringBuilder().append("http://");
                companion = HttpUrl.Companion;
                n = 0;
                String string3 = string2.substring(n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String string4 = string3;
                string = companion.get(charSequence.append(string4).toString()).host();
            } else {
                string = HttpUrl.Companion.get("http://" + pattern).host();
            }
            String canonicalHostname = string;
            if (StringsKt.startsWith$default((String)pin, (String)"sha1/", (boolean)false, (int)2, null)) {
                String string5 = pin;
                n = "sha1/".length();
                companion = ByteString.Companion;
                boolean bl = false;
                String string6 = string5.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                charSequence = string6;
                ByteString byteString = companion.decodeBase64((String)charSequence);
                if (byteString == null) {
                    Intrinsics.throwNpe();
                }
                hash = byteString;
                pin2 = new Pin(pattern, canonicalHostname, "sha1/", hash);
            } else if (StringsKt.startsWith$default((String)pin, (String)"sha256/", (boolean)false, (int)2, null)) {
                String string7 = pin;
                n = "sha256/".length();
                companion = ByteString.Companion;
                boolean bl = false;
                String string8 = string7.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                charSequence = string8;
                ByteString byteString = companion.decodeBase64((String)charSequence);
                if (byteString == null) {
                    Intrinsics.throwNpe();
                }
                hash = byteString;
                pin2 = new Pin(pattern, canonicalHostname, "sha256/", hash);
            } else {
                throw (Throwable)new IllegalArgumentException("pins must start with 'sha256/' or 'sha1/': " + pin);
            }
            return pin2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

