/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocket;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CipherSuite;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0002#$B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0017J\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018J\u0013\u0010\u001a\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0015J\u0018\u0010 \u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u0018J\b\u0010\"\u001a\u00020\u0007H\u0016R\u001e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u0011\u0010\t\u00a8\u0006%"}, d2={"Lokhttp3/ConnectionSpec;", "", "builder", "Lokhttp3/ConnectionSpec$Builder;", "(Lokhttp3/ConnectionSpec$Builder;)V", "cipherSuites", "", "", "getCipherSuites$okhttp", "()[Ljava/lang/String;", "[Ljava/lang/String;", "isTls", "", "()Z", "supportsTlsExtensions", "getSupportsTlsExtensions$okhttp", "tlsVersions", "getTlsVersions$okhttp", "apply", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "isFallback", "apply$okhttp", "", "Lokhttp3/CipherSuite;", "equals", "other", "hashCode", "", "isCompatible", "socket", "supportedSpec", "Lokhttp3/TlsVersion;", "toString", "Builder", "Companion", "okhttp"})
public final class ConnectionSpec {
    private final boolean isTls;
    private final boolean supportsTlsExtensions;
    @Nullable
    private final String[] cipherSuites;
    @Nullable
    private final String[] tlsVersions;
    private static final CipherSuite[] RESTRICTED_CIPHER_SUITES;
    private static final CipherSuite[] APPROVED_CIPHER_SUITES;
    @JvmField
    @NotNull
    public static final ConnectionSpec RESTRICTED_TLS;
    @JvmField
    @NotNull
    public static final ConnectionSpec MODERN_TLS;
    @JvmField
    @NotNull
    public static final ConnectionSpec COMPATIBLE_TLS;
    @JvmField
    @NotNull
    public static final ConnectionSpec CLEARTEXT;
    public static final Companion Companion;

    public final boolean isTls() {
        return this.isTls;
    }

    public final boolean getSupportsTlsExtensions$okhttp() {
        return this.supportsTlsExtensions;
    }

    @Nullable
    public final String[] getCipherSuites$okhttp() {
        return this.cipherSuites;
    }

    @Nullable
    public final String[] getTlsVersions$okhttp() {
        return this.tlsVersions;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<CipherSuite> cipherSuites() {
        List list;
        if (this.cipherSuites != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String[] stringArray = this.cipherSuites;
            CipherSuite.Companion companion = CipherSuite.Companion;
            boolean $i$f$map = false;
            void var4_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var7_7 = $this$mapTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int i = 0; i < n; ++i) {
                void p1;
                void item$iv$iv;
                void var11_11 = item$iv$iv = var7_7[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                CipherSuite cipherSuite = companion.forJavaName((String)p1);
                collection.add(cipherSuite);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<TlsVersion> tlsVersions() {
        List list;
        if (this.tlsVersions != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String[] stringArray = this.tlsVersions;
            TlsVersion.Companion companion = TlsVersion.Companion;
            boolean $i$f$map = false;
            void var4_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var7_7 = $this$mapTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int i = 0; i < n; ++i) {
                void p1;
                void item$iv$iv;
                void var11_11 = item$iv$iv = var7_7[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TlsVersion tlsVersion = companion.forJavaName((String)p1);
                collection.add(tlsVersion);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    public final boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    public final void apply$okhttp(@NotNull SSLSocket sslSocket, boolean isFallback) {
        Intrinsics.checkParameterIsNotNull((Object)sslSocket, (String)"sslSocket");
        ConnectionSpec specToApply = this.supportedSpec(sslSocket, isFallback);
        if (specToApply.tlsVersions != null) {
            sslSocket.setEnabledProtocols(specToApply.tlsVersions);
        }
        if (specToApply.cipherSuites != null) {
            sslSocket.setEnabledCipherSuites(specToApply.cipherSuites);
        }
    }

    private final ConnectionSpec supportedSpec(SSLSocket sslSocket, boolean isFallback) {
        String[] cipherSuitesIntersection = this.cipherSuites != null ? Util.intersect(CipherSuite.Companion.getORDER_BY_NAME$okhttp(), sslSocket.getEnabledCipherSuites(), this.cipherSuites) : sslSocket.getEnabledCipherSuites();
        String[] tlsVersionsIntersection = this.tlsVersions != null ? Util.intersect(Util.NATURAL_ORDER, sslSocket.getEnabledProtocols(), this.tlsVersions) : sslSocket.getEnabledProtocols();
        String[] supportedCipherSuites = sslSocket.getSupportedCipherSuites();
        int indexOfFallbackScsv = Util.indexOf(CipherSuite.Companion.getORDER_BY_NAME$okhttp(), supportedCipherSuites, "TLS_FALLBACK_SCSV");
        if (isFallback && indexOfFallbackScsv != -1) {
            cipherSuitesIntersection = Util.concat(cipherSuitesIntersection, supportedCipherSuites[indexOfFallbackScsv]);
        }
        Builder builder = new Builder(this);
        Intrinsics.checkExpressionValueIsNotNull((Object)cipherSuitesIntersection, (String)"cipherSuitesIntersection");
        Builder builder2 = builder.cipherSuites(Arrays.copyOf(cipherSuitesIntersection, cipherSuitesIntersection.length));
        String[] stringArray = tlsVersionsIntersection;
        Intrinsics.checkExpressionValueIsNotNull((Object)tlsVersionsIntersection, (String)"tlsVersionsIntersection");
        return builder2.tlsVersions(Arrays.copyOf(stringArray, stringArray.length)).build();
    }

    public final boolean isCompatible(@NotNull SSLSocket socket) {
        Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
        if (!this.isTls) {
            return false;
        }
        if (this.tlsVersions != null && !Util.nonEmptyIntersection(Util.NATURAL_ORDER, this.tlsVersions, socket.getEnabledProtocols())) {
            return false;
        }
        return this.cipherSuites == null || Util.nonEmptyIntersection(CipherSuite.Companion.getORDER_BY_NAME$okhttp(), this.cipherSuites, socket.getEnabledCipherSuites());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConnectionSpec)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        ConnectionSpec that = (ConnectionSpec)other;
        if (this.isTls != that.isTls) {
            return false;
        }
        if (this.isTls) {
            if (!Arrays.equals(this.cipherSuites, that.cipherSuites)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersions, that.tlsVersions)) {
                return false;
            }
            if (this.supportsTlsExtensions != that.supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        if (this.isTls) {
            if (this.cipherSuites == null) {
                Intrinsics.throwNpe();
            }
            Object[] objectArray = this.cipherSuites;
            int n = 31 * result;
            boolean bl = false;
            int n2 = Arrays.hashCode(objectArray);
            result = n + n2;
            if (this.tlsVersions == null) {
                Intrinsics.throwNpe();
            }
            objectArray = this.tlsVersions;
            n = 31 * result;
            bl = false;
            n2 = Arrays.hashCode(objectArray);
            result = n + n2;
            result = 31 * result + (this.supportsTlsExtensions ? 0 : 1);
        }
        return result;
    }

    @NotNull
    public String toString() {
        if (!this.isTls) {
            return "ConnectionSpec()";
        }
        return "ConnectionSpec(" + "cipherSuites=" + Objects.toString(this.cipherSuites(), "[all enabled]") + ", " + "tlsVersions=" + Objects.toString(this.tlsVersions(), "[all enabled]") + ", " + "supportsTlsExtensions=" + this.supportsTlsExtensions + ')';
    }

    public ConnectionSpec(@NotNull Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.isTls = builder.getTls$okhttp();
        this.supportsTlsExtensions = builder.getSupportsTlsExtensions$okhttp();
        this.cipherSuites = builder.getCipherSuites$okhttp();
        this.tlsVersions = builder.getTlsVersions$okhttp();
    }

    static {
        Companion = new Companion(null);
        RESTRICTED_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_AES_128_GCM_SHA256, CipherSuite.TLS_AES_256_GCM_SHA384, CipherSuite.TLS_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256};
        APPROVED_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_AES_128_GCM_SHA256, CipherSuite.TLS_AES_256_GCM_SHA384, CipherSuite.TLS_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA};
        RESTRICTED_TLS = new Builder(true).cipherSuites(Arrays.copyOf(RESTRICTED_CIPHER_SUITES, RESTRICTED_CIPHER_SUITES.length)).tlsVersions(TlsVersion.TLS_1_3, TlsVersion.TLS_1_2).supportsTlsExtensions(true).build();
        MODERN_TLS = new Builder(true).cipherSuites(Arrays.copyOf(APPROVED_CIPHER_SUITES, APPROVED_CIPHER_SUITES.length)).tlsVersions(TlsVersion.TLS_1_3, TlsVersion.TLS_1_2).supportsTlsExtensions(true).build();
        COMPATIBLE_TLS = new Builder(true).cipherSuites(Arrays.copyOf(APPROVED_CIPHER_SUITES, APPROVED_CIPHER_SUITES.length)).tlsVersions(TlsVersion.TLS_1_3, TlsVersion.TLS_1_2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
        CLEARTEXT = new Builder(false).build();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0019\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0006J\u001f\u0010\b\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\b\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\t\"\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003H\u0007J\u001f\u0010\u0016\u001a\u00020\u00002\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u0016\u001a\u00020\u00002\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\t\"\u00020\u001f\u00a2\u0006\u0002\u0010 R$\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0004R$\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u0017\u0010\f\"\u0004\b\u0018\u0010\u000e\u00a8\u0006!"}, d2={"Lokhttp3/ConnectionSpec$Builder;", "", "tls", "", "(Z)V", "connectionSpec", "Lokhttp3/ConnectionSpec;", "(Lokhttp3/ConnectionSpec;)V", "cipherSuites", "", "", "getCipherSuites$okhttp", "()[Ljava/lang/String;", "setCipherSuites$okhttp", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "supportsTlsExtensions", "getSupportsTlsExtensions$okhttp", "()Z", "setSupportsTlsExtensions$okhttp", "getTls$okhttp", "setTls$okhttp", "tlsVersions", "getTlsVersions$okhttp", "setTlsVersions$okhttp", "allEnabledCipherSuites", "allEnabledTlsVersions", "build", "([Ljava/lang/String;)Lokhttp3/ConnectionSpec$Builder;", "Lokhttp3/CipherSuite;", "([Lokhttp3/CipherSuite;)Lokhttp3/ConnectionSpec$Builder;", "Lokhttp3/TlsVersion;", "([Lokhttp3/TlsVersion;)Lokhttp3/ConnectionSpec$Builder;", "okhttp"})
    public static final class Builder {
        private boolean tls;
        @Nullable
        private String[] cipherSuites;
        @Nullable
        private String[] tlsVersions;
        private boolean supportsTlsExtensions;

        public final boolean getTls$okhttp() {
            return this.tls;
        }

        public final void setTls$okhttp(boolean bl) {
            this.tls = bl;
        }

        @Nullable
        public final String[] getCipherSuites$okhttp() {
            return this.cipherSuites;
        }

        public final void setCipherSuites$okhttp(@Nullable String[] stringArray) {
            this.cipherSuites = stringArray;
        }

        @Nullable
        public final String[] getTlsVersions$okhttp() {
            return this.tlsVersions;
        }

        public final void setTlsVersions$okhttp(@Nullable String[] stringArray) {
            this.tlsVersions = stringArray;
        }

        public final boolean getSupportsTlsExtensions$okhttp() {
            return this.supportsTlsExtensions;
        }

        public final void setSupportsTlsExtensions$okhttp(boolean bl) {
            this.supportsTlsExtensions = bl;
        }

        @NotNull
        public final Builder allEnabledCipherSuites() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = $this$apply.tls;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "no cipher suites for cleartext connections";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.cipherSuites = null;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder cipherSuites(CipherSuite ... cipherSuites) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)cipherSuites, (String)"cipherSuites");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = $this$apply.tls;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "no cipher suites for cleartext connections";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            CipherSuite[] $this$map$iv = cipherSuites;
            boolean $i$f$map = false;
            CipherSuite[] bl7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var13_17 = $this$mapTo$iv$iv;
            int n = ((void)var13_17).length;
            for (int i = 0; i < n; ++i) {
                void p1;
                void item$iv$iv;
                void var17_21 = item$iv$iv = var13_17[i];
                Collection collection = destination$iv$iv;
                boolean bl8 = false;
                String string = p1.javaName();
                collection.add(string);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] strings = stringArray;
            return $this$apply.cipherSuites(Arrays.copyOf(strings, strings.length));
        }

        @NotNull
        public final Builder cipherSuites(String ... cipherSuites) {
            Intrinsics.checkParameterIsNotNull((Object)cipherSuites, (String)"cipherSuites");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = $this$apply.tls;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "no cipher suites for cleartext connections";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String[] stringArray = cipherSuites;
            bl5 = false;
            String[] stringArray2 = stringArray;
            boolean bl7 = false;
            boolean bl8 = !(stringArray2.length == 0);
            bl5 = false;
            boolean bl9 = false;
            if (!bl8) {
                boolean bl10 = false;
                String string = "At least one cipher suite is required";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Object object = cipherSuites.clone();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
            }
            $this$apply.cipherSuites = (String[])object;
            return builder;
        }

        @NotNull
        public final Builder allEnabledTlsVersions() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = $this$apply.tls;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "no TLS versions for cleartext connections";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.tlsVersions = null;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder tlsVersions(TlsVersion ... tlsVersions) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)tlsVersions, (String)"tlsVersions");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = $this$apply.tls;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "no TLS versions for cleartext connections";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            TlsVersion[] $this$map$iv = tlsVersions;
            boolean $i$f$map = false;
            TlsVersion[] bl7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var13_17 = $this$mapTo$iv$iv;
            int n = ((void)var13_17).length;
            for (int i = 0; i < n; ++i) {
                void p1;
                void item$iv$iv;
                void var17_21 = item$iv$iv = var13_17[i];
                Collection collection = destination$iv$iv;
                boolean bl8 = false;
                String string = p1.javaName();
                collection.add(string);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] strings = stringArray;
            return $this$apply.tlsVersions(Arrays.copyOf(strings, strings.length));
        }

        @NotNull
        public final Builder tlsVersions(String ... tlsVersions) {
            Intrinsics.checkParameterIsNotNull((Object)tlsVersions, (String)"tlsVersions");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = $this$apply.tls;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "no TLS versions for cleartext connections";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String[] stringArray = tlsVersions;
            bl5 = false;
            String[] stringArray2 = stringArray;
            boolean bl7 = false;
            boolean bl8 = !(stringArray2.length == 0);
            bl5 = false;
            boolean bl9 = false;
            if (!bl8) {
                boolean bl10 = false;
                String string = "At least one TLS version is required";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Object object = tlsVersions.clone();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<kotlin.String>");
            }
            $this$apply.tlsVersions = (String[])object;
            return builder;
        }

        @Deprecated(message="since OkHttp 3.13 all TLS-connections are expected to support TLS extensions.\nIn a future release setting this to true will be unnecessary and setting it to false\nwill have no effect.")
        @NotNull
        public final Builder supportsTlsExtensions(boolean supportsTlsExtensions) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = $this$apply.tls;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "no TLS extensions for cleartext connections";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.supportsTlsExtensions = supportsTlsExtensions;
            return builder;
        }

        @NotNull
        public final ConnectionSpec build() {
            return new ConnectionSpec(this);
        }

        public Builder(boolean tls) {
            this.tls = tls;
        }

        public Builder(@NotNull ConnectionSpec connectionSpec) {
            Intrinsics.checkParameterIsNotNull((Object)connectionSpec, (String)"connectionSpec");
            this.tls = connectionSpec.isTls();
            this.cipherSuites = connectionSpec.getCipherSuites$okhttp();
            this.tlsVersions = connectionSpec.getTlsVersions$okhttp();
            this.supportsTlsExtensions = connectionSpec.getSupportsTlsExtensions$okhttp();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/ConnectionSpec$Companion;", "", "()V", "APPROVED_CIPHER_SUITES", "", "Lokhttp3/CipherSuite;", "[Lokhttp3/CipherSuite;", "CLEARTEXT", "Lokhttp3/ConnectionSpec;", "COMPATIBLE_TLS", "MODERN_TLS", "RESTRICTED_CIPHER_SUITES", "RESTRICTED_TLS", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

