/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001(B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020\u0015J\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00150!2\u0006\u0010 \u001a\u00020\u0015J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\"\u001a\u00020\u0005J\b\u0010#\u001a\u0004\u0018\u00010\u0001J#\u0010#\u001a\u0004\u0018\u0001H$\"\u0004\b\u0000\u0010$2\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u0002H$0\u001a\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u0015H\u0016J\u0006\u0010\u0002\u001a\u00020\u0003R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a\u0012\u0004\u0012\u00020\u00010\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Lokhttp3/Request;", "", "url", "Lokhttp3/HttpUrl;", "builder", "Lokhttp3/Request$Builder;", "(Lokhttp3/HttpUrl;Lokhttp3/Request$Builder;)V", "body", "Lokhttp3/RequestBody;", "getBody$okhttp", "()Lokhttp3/RequestBody;", "cacheControl", "Lokhttp3/CacheControl;", "headers", "Lokhttp3/Headers;", "getHeaders$okhttp", "()Lokhttp3/Headers;", "isHttps", "", "()Z", "method", "", "getMethod$okhttp", "()Ljava/lang/String;", "tags", "", "Ljava/lang/Class;", "getTags$okhttp", "()Ljava/util/Map;", "getUrl$okhttp", "()Lokhttp3/HttpUrl;", "header", "name", "", "newBuilder", "tag", "T", "type", "(Ljava/lang/Class;)Ljava/lang/Object;", "toString", "Builder", "okhttp"})
public final class Request {
    @NotNull
    private final String method;
    @NotNull
    private final Headers headers;
    @Nullable
    private final RequestBody body;
    @NotNull
    private final Map<Class<?>, Object> tags;
    private volatile CacheControl cacheControl;
    @NotNull
    private final HttpUrl url;

    @NotNull
    public final String getMethod$okhttp() {
        return this.method;
    }

    @NotNull
    public final Headers getHeaders$okhttp() {
        return this.headers;
    }

    @Nullable
    public final RequestBody getBody$okhttp() {
        return this.body;
    }

    @NotNull
    public final Map<Class<?>, Object> getTags$okhttp() {
        return this.tags;
    }

    public final boolean isHttps() {
        return this.url.isHttps();
    }

    @NotNull
    public final HttpUrl url() {
        return this.url;
    }

    @NotNull
    public final String method() {
        return this.method;
    }

    @NotNull
    public final Headers headers() {
        return this.headers;
    }

    @Nullable
    public final String header(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.headers.get(name);
    }

    @NotNull
    public final List<String> headers(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.headers.values(name);
    }

    @Nullable
    public final RequestBody body() {
        return this.body;
    }

    @Nullable
    public final Object tag() {
        return this.tag(Object.class);
    }

    @Nullable
    public final <T> T tag(@NotNull Class<? extends T> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return type.cast(this.tags.get(type));
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder(this);
    }

    @NotNull
    public final CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        if (cacheControl == null) {
            CacheControl cacheControl2 = CacheControl.Companion.parse(this.headers);
            boolean bl = false;
            boolean bl2 = false;
            CacheControl it = cacheControl2;
            boolean bl3 = false;
            this.cacheControl = it;
            cacheControl = cacheControl2;
        }
        return cacheControl;
    }

    @NotNull
    public String toString() {
        return "Request{method=" + this.method + ", url=" + this.url + ", tags=" + this.tags + '}';
    }

    @NotNull
    public final HttpUrl getUrl$okhttp() {
        return this.url;
    }

    public Request(@NotNull HttpUrl url, @NotNull Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.url = url;
        this.method = builder.getMethod$okhttp();
        this.headers = builder.getHeaders$okhttp().build();
        this.body = builder.getBody$okhttp();
        Map<Class<?>, Object> map = Util.immutableMap(builder.getTags$okhttp());
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Util.immutableMap(builder.tags)");
        this.tags = map;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013H\u0016J\b\u0010(\u001a\u00020\u0004H\u0016J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*H\u0016J\u0014\u0010+\u001a\u00020\u00002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0017J\b\u0010,\u001a\u00020\u0000H\u0016J\b\u0010-\u001a\u00020\u0000H\u0016J\u0018\u0010.\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013H\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020/H\u0016J\u001a\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u00100\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u00101\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u00102\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u00103\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0013H\u0016J-\u00104\u001a\u00020\u0000\"\u0004\b\u0000\u001052\u000e\u00106\u001a\n\u0012\u0006\b\u0000\u0012\u0002H50\u001a2\b\u00104\u001a\u0004\u0018\u0001H5H\u0016\u00a2\u0006\u0002\u00107J\u0012\u00104\u001a\u00020\u00002\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u000208H\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R*\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a\u0012\u0004\u0012\u00020\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00069"}, d2={"Lokhttp3/Request$Builder;", "", "()V", "request", "Lokhttp3/Request;", "(Lokhttp3/Request;)V", "body", "Lokhttp3/RequestBody;", "getBody$okhttp", "()Lokhttp3/RequestBody;", "setBody$okhttp", "(Lokhttp3/RequestBody;)V", "headers", "Lokhttp3/Headers$Builder;", "getHeaders$okhttp", "()Lokhttp3/Headers$Builder;", "setHeaders$okhttp", "(Lokhttp3/Headers$Builder;)V", "method", "", "getMethod$okhttp", "()Ljava/lang/String;", "setMethod$okhttp", "(Ljava/lang/String;)V", "tags", "", "Ljava/lang/Class;", "getTags$okhttp", "()Ljava/util/Map;", "setTags$okhttp", "(Ljava/util/Map;)V", "url", "Lokhttp3/HttpUrl;", "getUrl$okhttp", "()Lokhttp3/HttpUrl;", "setUrl$okhttp", "(Lokhttp3/HttpUrl;)V", "addHeader", "name", "value", "build", "cacheControl", "Lokhttp3/CacheControl;", "delete", "get", "head", "header", "Lokhttp3/Headers;", "patch", "post", "put", "removeHeader", "tag", "T", "type", "(Ljava/lang/Class;Ljava/lang/Object;)Lokhttp3/Request$Builder;", "Ljava/net/URL;", "okhttp"})
    public static class Builder {
        @Nullable
        private HttpUrl url;
        @NotNull
        private String method;
        @NotNull
        private Headers.Builder headers;
        @Nullable
        private RequestBody body;
        @NotNull
        private Map<Class<?>, Object> tags;

        @Nullable
        public final HttpUrl getUrl$okhttp() {
            return this.url;
        }

        public final void setUrl$okhttp(@Nullable HttpUrl httpUrl) {
            this.url = httpUrl;
        }

        @NotNull
        public final String getMethod$okhttp() {
            return this.method;
        }

        public final void setMethod$okhttp(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.method = string;
        }

        @NotNull
        public final Headers.Builder getHeaders$okhttp() {
            return this.headers;
        }

        public final void setHeaders$okhttp(@NotNull Headers.Builder builder) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"<set-?>");
            this.headers = builder;
        }

        @Nullable
        public final RequestBody getBody$okhttp() {
            return this.body;
        }

        public final void setBody$okhttp(@Nullable RequestBody requestBody) {
            this.body = requestBody;
        }

        @NotNull
        public final Map<Class<?>, Object> getTags$okhttp() {
            return this.tags;
        }

        public final void setTags$okhttp(@NotNull Map<Class<?>, Object> map) {
            Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
            this.tags = map;
        }

        @NotNull
        public Builder url(@NotNull HttpUrl url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.url = url;
            return builder;
        }

        @NotNull
        public Builder url(@NotNull String url) {
            String string;
            String string2;
            boolean bl;
            StringBuilder stringBuilder;
            int n;
            String string3;
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            if (StringsKt.regionMatches((String)url, (int)0, (String)"ws:", (int)0, (int)3, (boolean)true)) {
                string3 = url;
                n = 3;
                stringBuilder = new StringBuilder().append("http:");
                bl = false;
                String string4 = string3.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                string2 = string4;
                string = stringBuilder.append(string2).toString();
            } else if (StringsKt.regionMatches((String)url, (int)0, (String)"wss:", (int)0, (int)4, (boolean)true)) {
                string3 = url;
                n = 4;
                stringBuilder = new StringBuilder().append("https:");
                bl = false;
                String string5 = string3.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                string2 = string5;
                string = stringBuilder.append(string2).toString();
            } else {
                string = url;
            }
            String finalUrl = string;
            return this.url(HttpUrl.Companion.get(finalUrl));
        }

        @NotNull
        public Builder url(@NotNull URL url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            return this.url(HttpUrl.Companion.get(string));
        }

        @NotNull
        public Builder header(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.headers.set(name, value);
            return builder;
        }

        @NotNull
        public Builder addHeader(@NotNull String name, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.headers.add(name, value);
            return builder;
        }

        @NotNull
        public Builder removeHeader(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.headers.removeAll(name);
            return builder;
        }

        @NotNull
        public Builder headers(@NotNull Headers headers) {
            Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.headers = headers.newBuilder();
            return builder;
        }

        @NotNull
        public Builder cacheControl(@NotNull CacheControl cacheControl) {
            Intrinsics.checkParameterIsNotNull((Object)cacheControl, (String)"cacheControl");
            String value = cacheControl.toString();
            CharSequence charSequence = value;
            boolean bl = false;
            return charSequence.length() == 0 ? this.removeHeader("Cache-Control") : this.header("Cache-Control", value);
        }

        @NotNull
        public Builder get() {
            return this.method("GET", null);
        }

        @NotNull
        public Builder head() {
            return this.method("HEAD", null);
        }

        @NotNull
        public Builder post(@NotNull RequestBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            return this.method("POST", body);
        }

        @JvmOverloads
        @NotNull
        public Builder delete(@Nullable RequestBody body) {
            return this.method("DELETE", body);
        }

        @JvmOverloads
        @NotNull
        public static /* synthetic */ Builder delete$default(Builder builder, RequestBody requestBody, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: delete");
            }
            if ((n & 1) != 0) {
                requestBody = Util.EMPTY_REQUEST;
            }
            return builder.delete(requestBody);
        }

        @JvmOverloads
        @NotNull
        public Builder delete() {
            return Builder.delete$default(this, null, 1, null);
        }

        @NotNull
        public Builder put(@NotNull RequestBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            return this.method("PUT", body);
        }

        @NotNull
        public Builder patch(@NotNull RequestBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            return this.method("PATCH", body);
        }

        @NotNull
        public Builder method(@NotNull String method, @Nullable RequestBody body) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            CharSequence charSequence = method;
            boolean bl4 = false;
            boolean bl5 = charSequence.length() > 0;
            bl4 = false;
            boolean bl6 = false;
            if (!bl5) {
                boolean bl7 = false;
                String string = "method.isEmpty() == true";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (body == null) {
                bl5 = !HttpMethod.requiresRequestBody(method);
                bl4 = false;
                bl6 = false;
                if (!bl5) {
                    boolean bl8 = false;
                    String string = "method " + method + " must have a request body.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            } else {
                bl5 = HttpMethod.permitsRequestBody(method);
                bl4 = false;
                bl6 = false;
                if (!bl5) {
                    boolean bl9 = false;
                    String string = "method " + method + " must not have a request body.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
            $this$apply.method = method;
            $this$apply.body = body;
            return builder;
        }

        @NotNull
        public Builder tag(@Nullable Object tag) {
            return this.tag(Object.class, tag);
        }

        @NotNull
        public <T> Builder tag(@NotNull Class<? super T> type, @Nullable T tag) {
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            if (tag == null) {
                $this$apply.tags.remove(type);
            } else {
                if ($this$apply.tags.isEmpty()) {
                    Map map;
                    Builder builder2 = $this$apply;
                    boolean bl4 = false;
                    builder2.tags = map = (Map)new LinkedHashMap();
                }
                Map<Class<?>, Object> map = $this$apply.tags;
                T t = type.cast(tag);
                if (t == null) {
                    Intrinsics.throwNpe();
                }
                map.put(type, t);
            }
            return builder;
        }

        @NotNull
        public Request build() {
            HttpUrl httpUrl = this.url;
            boolean bl = false;
            boolean bl2 = false;
            if (httpUrl == null) {
                boolean bl3 = false;
                String string = "url == null";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            HttpUrl httpUrl2 = httpUrl;
            Builder builder = this;
            HttpUrl httpUrl3 = httpUrl2;
            return new Request(httpUrl3, builder);
        }

        public Builder() {
            Map map;
            Builder builder = this;
            boolean bl = false;
            builder.tags = map = (Map)new LinkedHashMap();
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        public Builder(@NotNull Request request) {
            Map map;
            Map map2;
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Builder builder = this;
            boolean bl = false;
            builder.tags = map2 = (Map)new LinkedHashMap();
            this.url = request.getUrl$okhttp();
            this.method = request.getMethod$okhttp();
            this.body = request.getBody$okhttp();
            Builder builder2 = this;
            if (request.getTags$okhttp().isEmpty()) {
                builder = builder2;
                bl = false;
                map2 = new LinkedHashMap();
                builder2 = builder;
                map = map2;
            } else {
                map = MapsKt.toMutableMap(request.getTags$okhttp());
            }
            builder2.tags = map;
            this.headers = request.getHeaders$okhttp().newBuilder();
        }
    }
}

