/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.security.Provider;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Protocol;
import okhttp3.internal.platform.ConscryptPlatform;
import okhttp3.internal.platform.Platform;
import org.conscrypt.Conscrypt;
import org.conscrypt.ConscryptHostnameVerifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0012\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lokhttp3/internal/platform/ConscryptPlatform;", "Lokhttp3/internal/platform/Platform;", "()V", "provider", "Ljava/security/Provider;", "getProvider", "()Ljava/security/Provider;", "configureSslSocketFactory", "", "socketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "configureTlsExtensions", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "hostname", "", "protocols", "", "Lokhttp3/Protocol;", "configureTrustManager", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "getSelectedProtocol", "socket", "newSSLContext", "Ljavax/net/ssl/SSLContext;", "platformTrustManager", "sslSocketFactory", "Companion", "okhttp"})
public final class ConscryptPlatform
extends Platform {
    public static final Companion Companion = new Companion(null);

    private final Provider getProvider() {
        Provider provider = Conscrypt.newProviderBuilder().provideTrustManager(true).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"Conscrypt.newProviderBui\u2026rustManager(true).build()");
        return provider;
    }

    @Override
    @NotNull
    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS", this.getProvider());
        Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext, (String)"SSLContext.getInstance(\"TLS\", provider)");
        return sSLContext;
    }

    @Override
    @NotNull
    public X509TrustManager platformTrustManager() {
        X509TrustManager x509TrustManager = Conscrypt.getDefaultX509TrustManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)x509TrustManager, (String)"Conscrypt.getDefaultX509TrustManager()");
        return x509TrustManager;
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        X509TrustManager x509TrustManager;
        Intrinsics.checkParameterIsNotNull((Object)sslSocketFactory, (String)"sslSocketFactory");
        if (!Conscrypt.isConscrypt((SSLSocketFactory)sslSocketFactory)) {
            x509TrustManager = super.trustManager(sslSocketFactory);
        } else {
            X509TrustManager x509TrustManager2;
            try {
                Object sp = Platform.Companion.readFieldOrNull(sslSocketFactory, Object.class, "sslParameters");
                x509TrustManager2 = sp != null ? Platform.Companion.readFieldOrNull(sp, X509TrustManager.class, "x509TrustManager") : null;
            }
            catch (Exception e) {
                throw (Throwable)new UnsupportedOperationException("clientBuilder.sslSocketFactory(SSLSocketFactory) not supported on Conscrypt", e);
            }
            x509TrustManager = x509TrustManager2;
        }
        return x509TrustManager;
    }

    /*
     * WARNING - void declaration
     */
    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkParameterIsNotNull((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkParameterIsNotNull(protocols, (String)"protocols");
        if (Conscrypt.isConscrypt((SSLSocket)sslSocket)) {
            void $this$toTypedArray$iv;
            if (hostname != null) {
                Conscrypt.setUseSessionTickets((SSLSocket)sslSocket, (boolean)true);
                Conscrypt.setHostname((SSLSocket)sslSocket, (String)hostname);
            }
            List<String> names = Platform.Companion.alpnProtocolNames(protocols);
            Collection collection = names;
            SSLSocket sSLSocket = sslSocket;
            boolean $i$f$toTypedArray = false;
            void v0 = $this$toTypedArray$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v0;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            Conscrypt.setApplicationProtocols((SSLSocket)sSLSocket, (String[])stringArray2);
        } else {
            super.configureTlsExtensions(sslSocket, hostname, protocols);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket socket) {
        Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
        return Conscrypt.isConscrypt((SSLSocket)socket) ? Conscrypt.getApplicationProtocol((SSLSocket)socket) : super.getSelectedProtocol(socket);
    }

    @Override
    public void configureSslSocketFactory(@NotNull SSLSocketFactory socketFactory) {
        Intrinsics.checkParameterIsNotNull((Object)socketFactory, (String)"socketFactory");
        if (Conscrypt.isConscrypt((SSLSocketFactory)socketFactory)) {
            Conscrypt.setUseEngineSocket((SSLSocketFactory)socketFactory, (boolean)true);
        }
    }

    @Override
    public void configureTrustManager(@Nullable X509TrustManager trustManager) {
        if (Conscrypt.isConscrypt((TrustManager)trustManager)) {
            Conscrypt.setHostnameVerifier((TrustManager)trustManager, (ConscryptHostnameVerifier)configureTrustManager.1.INSTANCE);
        }
    }

    private ConscryptPlatform() {
    }

    public /* synthetic */ ConscryptPlatform(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @Nullable
    public static final ConscryptPlatform buildIfSupported() {
        return Companion.buildIfSupported();
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean atLeastVersion(int major, int minor, int patch) {
        return Companion.atLeastVersion(major, minor, patch);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean atLeastVersion(int major, int minor) {
        return okhttp3.internal.platform.ConscryptPlatform$Companion.atLeastVersion$default(Companion, major, minor, 0, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean atLeastVersion(int major) {
        return okhttp3.internal.platform.ConscryptPlatform$Companion.atLeastVersion$default(Companion, major, 0, 0, 6, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u0007J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u00a8\u0006\u000b"}, d2={"Lokhttp3/internal/platform/ConscryptPlatform$Companion;", "", "()V", "atLeastVersion", "", "major", "", "minor", "patch", "buildIfSupported", "Lokhttp3/internal/platform/ConscryptPlatform;", "okhttp"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final ConscryptPlatform buildIfSupported() {
            ConscryptPlatform conscryptPlatform;
            try {
                Class.forName("org.conscrypt.Conscrypt$Version");
                conscryptPlatform = Conscrypt.isAvailable() && this.atLeastVersion(2, 1, 0) ? new ConscryptPlatform(null) : null;
            }
            catch (ClassNotFoundException e) {
                conscryptPlatform = null;
            }
            return conscryptPlatform;
        }

        @JvmStatic
        @JvmOverloads
        public final boolean atLeastVersion(int major, int minor, int patch) {
            Conscrypt.Version conscryptVersion = Conscrypt.version();
            if (conscryptVersion.major() != major) {
                return conscryptVersion.major() > major;
            }
            if (conscryptVersion.minor() != minor) {
                return conscryptVersion.minor() > minor;
            }
            return conscryptVersion.patch() >= patch;
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ boolean atLeastVersion$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            return companion.atLeastVersion(n, n2, n3);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean atLeastVersion(int major, int minor) {
            return okhttp3.internal.platform.ConscryptPlatform$Companion.atLeastVersion$default(this, major, minor, 0, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean atLeastVersion(int major) {
            return okhttp3.internal.platform.ConscryptPlatform$Companion.atLeastVersion$default(this, major, 0, 0, 6, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

