/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.Address;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.StreamResetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ0\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0002J8\u0010&\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020%H\u0002J\u0006\u0010(\u001a\u00020%J\b\u0010)\u001a\u00020%H\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lokhttp3/internal/connection/ExchangeFinder;", "", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "address", "Lokhttp3/Address;", "call", "Lokhttp3/internal/connection/RealCall;", "eventListener", "Lokhttp3/EventListener;", "(Lokhttp3/internal/connection/RealConnectionPool;Lokhttp3/Address;Lokhttp3/internal/connection/RealCall;Lokhttp3/EventListener;)V", "getAddress$okhttp", "()Lokhttp3/Address;", "connectingConnection", "Lokhttp3/internal/connection/RealConnection;", "connectionShutdownCount", "", "nextRouteToTry", "Lokhttp3/Route;", "otherFailureCount", "refusedStreamCount", "routeSelection", "Lokhttp3/internal/connection/RouteSelector$Selection;", "routeSelector", "Lokhttp3/internal/connection/RouteSelector;", "find", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "findConnection", "connectTimeout", "readTimeout", "writeTimeout", "pingIntervalMillis", "connectionRetryEnabled", "", "findHealthyConnection", "doExtensiveHealthChecks", "retryAfterFailure", "retryCurrentRoute", "trackFailure", "", "e", "Ljava/io/IOException;", "okhttp"})
public final class ExchangeFinder {
    private RouteSelector.Selection routeSelection;
    private RouteSelector routeSelector;
    private RealConnection connectingConnection;
    private int refusedStreamCount;
    private int connectionShutdownCount;
    private int otherFailureCount;
    private Route nextRouteToTry;
    private final RealConnectionPool connectionPool;
    @NotNull
    private final Address address;
    private final RealCall call;
    private final EventListener eventListener;

    @NotNull
    public final ExchangeCodec find(@NotNull OkHttpClient client, @NotNull RealInterceptorChain chain) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        try {
            RealConnection resultConnection = this.findHealthyConnection(chain.getConnectTimeoutMillis$okhttp(), chain.getReadTimeoutMillis$okhttp(), chain.getWriteTimeoutMillis$okhttp(), client.pingIntervalMillis(), client.retryOnConnectionFailure(), Intrinsics.areEqual((Object)chain.getRequest$okhttp().method(), (Object)"GET") ^ true);
            return resultConnection.newCodec$okhttp(client, chain);
        }
        catch (RouteException e) {
            this.trackFailure(e.getLastConnectException());
            throw (Throwable)e;
        }
        catch (IOException e) {
            this.trackFailure(e);
            throw (Throwable)new RouteException(e);
        }
    }

    private final RealConnection findHealthyConnection(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled, boolean doExtensiveHealthChecks) throws IOException {
        RealConnection candidate;
        while (!(candidate = this.findConnection(connectTimeout, readTimeout, writeTimeout, pingIntervalMillis, connectionRetryEnabled)).isHealthy(doExtensiveHealthChecks)) {
            candidate.noNewExchanges();
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final RealConnection findConnection(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled) throws IOException {
        block53: {
            block54: {
                foundPooledConnection = false;
                result = null;
                selectedRoute = null;
                releasedConnection = new Ref.ObjectRef();
                toClose = null;
                var11_11 = this.connectionPool;
                var12_13 = false;
                var13_16 = false;
                synchronized (var11_11) {
                    $i$a$-synchronized-ExchangeFinder$findConnection$1 = false;
                    if (this.call.isCanceled()) {
                        throw (Throwable)new IOException("Canceled");
                    }
                    releasedConnection.element = this.call.getConnection();
                    if (this.call.getConnection() == null) ** GOTO lbl-1000
                    v0 = this.call.getConnection();
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (v0.getNoNewExchanges()) ** GOTO lbl-1000
                    v1 = this.call.getConnection();
                    if (v1 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!v1.supportsUrl(this.address.url())) lbl-1000:
                    // 2 sources

                    {
                        v2 = this.call.releaseConnectionNoEvents$okhttp();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = toClose = null;
                    }
                    if (this.call.getConnection() != null) {
                        result = this.call.getConnection();
                        releasedConnection.element = null;
                    }
                    if (result == null) {
                        this.refusedStreamCount = 0;
                        this.connectionShutdownCount = 0;
                        this.otherFailureCount = 0;
                        if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, null, false)) {
                            foundPooledConnection = true;
                            result = this.call.getConnection();
                        } else if (this.nextRouteToTry != null) {
                            selectedRoute = this.nextRouteToTry;
                            this.nextRouteToTry = null;
                        }
                    }
                    var13_17 /* !! */  = Unit.INSTANCE;
                }
                v3 = toClose;
                if (v3 != null) {
                    Util.closeQuietly(v3);
                }
                if ((RealConnection)releasedConnection.element != null) {
                    v4 = this.call;
                    v5 = (RealConnection)releasedConnection.element;
                    if (v5 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.eventListener.connectionReleased(v4, v5);
                }
                if (foundPooledConnection) {
                    v6 = this.call;
                    v7 = result;
                    if (v7 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.eventListener.connectionAcquired(v6, v7);
                }
                if (result != null) {
                    v8 = result;
                    if (v8 == null) {
                        Intrinsics.throwNpe();
                    }
                    return v8;
                }
                newRouteSelection = false;
                if (selectedRoute != null) break block53;
                if (this.routeSelection == null) break block54;
                v9 = this.routeSelection;
                if (v9 == null) {
                    Intrinsics.throwNpe();
                }
                if (v9.hasNext()) break block53;
            }
            if ((localRouteSelector = this.routeSelector) == null) {
                this.routeSelector = localRouteSelector = new RouteSelector(this.address, this.call.getClient().getRouteDatabase(), this.call, this.eventListener);
            }
            newRouteSelection = true;
            this.routeSelection = localRouteSelector.next();
        }
        routes = null;
        var13_17 /* !! */  = this.connectionPool;
        var14_19 = false;
        var15_21 = false;
        synchronized (var13_17 /* !! */ ) {
            $i$a$-synchronized-ExchangeFinder$findConnection$2 = false;
            if (this.call.isCanceled()) {
                throw (Throwable)new IOException("Canceled");
            }
            if (newRouteSelection) {
                v10 = this.routeSelection;
                if (v10 == null) {
                    Intrinsics.throwNpe();
                }
                if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, routes = v10.getRoutes(), false)) {
                    foundPooledConnection = true;
                    result = this.call.getConnection();
                }
            }
            if (!foundPooledConnection) {
                if (selectedRoute == null) {
                    v11 = this.routeSelection;
                    if (v11 == null) {
                        Intrinsics.throwNpe();
                    }
                    selectedRoute = v11.next();
                }
                v12 = selectedRoute;
                if (v12 == null) {
                    Intrinsics.throwNpe();
                }
                this.connectingConnection = result = new RealConnection(this.connectionPool, v12);
            }
            var15_22 = Unit.INSTANCE;
        }
        if (foundPooledConnection) {
            v13 = this.call;
            v14 = result;
            if (v14 == null) {
                Intrinsics.throwNpe();
            }
            this.eventListener.connectionAcquired(v13, v14);
            v15 = result;
            if (v15 == null) {
                Intrinsics.throwNpe();
            }
            return v15;
        }
        v16 = result;
        if (v16 == null) {
            Intrinsics.throwNpe();
        }
        v16.connect(connectTimeout, readTimeout, writeTimeout, pingIntervalMillis, connectionRetryEnabled, this.call, this.eventListener);
        v17 = this.call.getClient().getRouteDatabase();
        v18 = result;
        if (v18 == null) {
            Intrinsics.throwNpe();
        }
        v17.connected(v18.route());
        socket = null;
        var14_20 = this.connectionPool;
        var15_24 = false;
        var16_25 = false;
        synchronized (var14_20) {
            $i$a$-synchronized-ExchangeFinder$findConnection$3 = false;
            this.connectingConnection = null;
            if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, routes, true)) {
                v19 = result;
                if (v19 == null) {
                    Intrinsics.throwNpe();
                }
                v19.setNoNewExchanges(true);
                v20 = result;
                if (v20 == null) {
                    Intrinsics.throwNpe();
                }
                socket = v20.socket();
                result = this.call.getConnection();
                this.nextRouteToTry = selectedRoute;
            } else {
                v21 = result;
                if (v21 == null) {
                    Intrinsics.throwNpe();
                }
                this.connectionPool.put(v21);
                v22 = result;
                if (v22 == null) {
                    Intrinsics.throwNpe();
                }
                this.call.acquireConnectionNoEvents(v22);
            }
            var16_26 = Unit.INSTANCE;
        }
        v23 = socket;
        if (v23 != null) {
            Util.closeQuietly(v23);
        }
        v24 = this.call;
        v25 = result;
        if (v25 == null) {
            Intrinsics.throwNpe();
        }
        this.eventListener.connectionAcquired(v24, v25);
        v26 = result;
        if (v26 == null) {
            Intrinsics.throwNpe();
        }
        return v26;
    }

    @Nullable
    public final RealConnection connectingConnection() {
        RealConnectionPool $this$assertThreadHoldsLock$iv = this.connectionPool;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread.getName()).append(" MUST hold lock on ").append($this$assertThreadHoldsLock$iv).toString()));
        }
        return this.connectingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trackFailure(@NotNull IOException e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        RealConnectionPool $this$assertThreadDoesntHoldLock$iv = this.connectionPool;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread.getName()).append(" MUST NOT hold lock on ").append($this$assertThreadDoesntHoldLock$iv).toString()));
        }
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        int n = 0;
        synchronized (realConnectionPool) {
            int n2;
            boolean bl2 = false;
            this.nextRouteToTry = null;
            if (e instanceof StreamResetException && ((StreamResetException)e).errorCode == ErrorCode.REFUSED_STREAM) {
                int n3 = this.refusedStreamCount;
                this.refusedStreamCount = n3 + 1;
                n2 = n3;
            } else if (e instanceof ConnectionShutdownException) {
                int n4 = this.connectionShutdownCount;
                this.connectionShutdownCount = n4 + 1;
                n2 = n4;
            } else {
                int n5 = this.otherFailureCount;
                this.otherFailureCount = n5 + 1;
                n2 = n5;
            }
            n = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean retryAfterFailure() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            RouteSelector routeSelector;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                boolean bl3 = false;
                                if (this.refusedStreamCount != 0 || this.connectionShutdownCount != 0 || this.otherFailureCount != 0) break block9;
                                boolean bl4 = false;
                                return bl4;
                            }
                            if (this.nextRouteToTry == null) break block10;
                            boolean bl5 = true;
                            return bl5;
                        }
                        if (!this.retryCurrentRoute()) break block11;
                        RealConnection realConnection = this.call.getConnection();
                        if (realConnection == null) {
                            Intrinsics.throwNpe();
                        }
                        this.nextRouteToTry = realConnection.route();
                        boolean bl6 = true;
                        return bl6;
                    }
                    RouteSelector.Selection selection = this.routeSelection;
                    if (selection == null) break block12;
                    if (!selection.hasNext()) break block12;
                    boolean bl7 = true;
                    return bl7;
                }
                if (this.routeSelector != null) break block13;
                boolean bl8 = true;
                return bl8;
            }
            RouteSelector localRouteSelector = routeSelector;
            boolean bl9 = localRouteSelector.hasNext();
            return bl9;
        }
    }

    private final boolean retryCurrentRoute() {
        if (this.refusedStreamCount > 1 || this.connectionShutdownCount > 1 || this.otherFailureCount > 0) {
            return false;
        }
        RealConnection connection = this.call.getConnection();
        return connection != null && connection.getRouteFailureCount$okhttp() == 0 && Util.canReuseConnectionFor(connection.route().address().url(), this.address.url());
    }

    @NotNull
    public final Address getAddress$okhttp() {
        return this.address;
    }

    public ExchangeFinder(@NotNull RealConnectionPool connectionPool, @NotNull Address address, @NotNull RealCall call, @NotNull EventListener eventListener) {
        Intrinsics.checkParameterIsNotNull((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)eventListener, (String)"eventListener");
        this.connectionPool = connectionPool;
        this.address = address;
        this.call = call;
        this.eventListener = eventListener;
    }
}

