/*
 * Decompiled with CFR 0.152.
 */
package okio.fakefilesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import okio.Buffer;
import okio.ByteString;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Path;
import okio.Sink;
import okio.Source;
import okio.fakefilesystem.-Time;
import okio.fakefilesystem.FakeFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0005defghB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\nH\u0016J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007H\u0016J\u0010\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0016J\u0010\u00107\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0002J\u0006\u00108\u001a\u000202J \u00109\u001a\u0002022\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020;H\u0002J\u0018\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\nH\u0016J\u0018\u0010A\u001a\u0002022\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007H\u0016J\u0018\u0010B\u001a\u0002022\u0006\u00106\u001a\u00020\u00072\u0006\u00100\u001a\u00020\nH\u0016J\u0006\u0010C\u001a\u000202J\u0006\u0010D\u001a\u000202J\u001e\u0010E\u001a\u0004\u0018\u00010 2\u0006\u0010F\u001a\u00020\u00072\n\b\u0002\u0010G\u001a\u0004\u0018\u00010HH\u0002J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00070\"2\u0006\u0010?\u001a\u00020\u0007H\u0016J \u0010I\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\"2\u0006\u0010?\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\nH\u0002J\u0018\u0010K\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\"2\u0006\u0010?\u001a\u00020\u0007H\u0016J0\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010F\u001a\u00020\u00072\b\b\u0002\u0010N\u001a\u00020O2\b\b\u0002\u0010P\u001a\u00020\n2\b\b\u0002\u0010Q\u001a\u00020\nH\u0002J\u0012\u0010R\u001a\u0004\u0018\u00010S2\u0006\u00106\u001a\u00020\u0007H\u0016J,\u0010T\u001a\u00020U2\u0006\u0010/\u001a\u00020\u00072\u0006\u0010V\u001a\u00020\n2\b\b\u0002\u0010@\u001a\u00020\n2\b\b\u0002\u00100\u001a\u00020\nH\u0002J\u0010\u0010W\u001a\u00020U2\u0006\u0010/\u001a\u00020\u0007H\u0016J \u0010X\u001a\u00020U2\u0006\u0010/\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0016J7\u0010Y\u001a\u000202\"\b\b\u0000\u0010Z*\u00020[2\u0006\u00106\u001a\u00020\u00072\u000e\u0010\\\u001a\n\u0012\u0006\b\u0001\u0012\u0002HZ0]2\b\u0010'\u001a\u0004\u0018\u0001HZ\u00a2\u0006\u0002\u0010^J\u0018\u0010_\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\nH\u0016J\u0010\u00103\u001a\u00020`2\u0006\u0010/\u001a\u00020\u0007H\u0016J\b\u0010a\u001a\u00020bH\u0016J\u000e\u0010c\u001a\u00020&*\u0004\u0018\u00010MH\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\"8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006i"}, d2={"Lokio/fakefilesystem/FakeFileSystem;", "Lokio/FileSystem;", "clock", "Lkotlinx/datetime/Clock;", "(Lkotlinx/datetime/Clock;)V", "allPaths", "", "Lokio/Path;", "()Ljava/util/Set;", "allowClobberingEmptyDirectories", "", "getAllowClobberingEmptyDirectories", "()Z", "setAllowClobberingEmptyDirectories", "(Z)V", "allowDeletingOpenFiles", "getAllowDeletingOpenFiles", "setAllowDeletingOpenFiles", "allowMovingOpenFiles", "getAllowMovingOpenFiles", "setAllowMovingOpenFiles", "allowReadsWhileWriting", "getAllowReadsWhileWriting", "setAllowReadsWhileWriting", "allowSymlinks", "getAllowSymlinks", "setAllowSymlinks", "allowWritesWhileWriting", "getAllowWritesWhileWriting", "setAllowWritesWhileWriting", "openFiles", "", "Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "openPaths", "", "()Ljava/util/List;", "roots", "", "Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "value", "workingDirectory", "getWorkingDirectory", "()Lokio/Path;", "setWorkingDirectory", "(Lokio/Path;)V", "appendingSink", "Lokio/Sink;", "file", "mustExist", "atomicMove", "", "source", "target", "canonicalize", "path", "canonicalizeInternal", "checkNoOpenFiles", "checkOffsetAndCount", "size", "", "offset", "byteCount", "createDirectory", "dir", "mustCreate", "createSymlink", "delete", "emulateUnix", "emulateWindows", "findOpenFile", "canonicalPath", "operation", "Lokio/fakefilesystem/FakeFileSystem$Operation;", "list", "throwOnFailure", "listOrNull", "lookupPath", "Lokio/fakefilesystem/FakeFileSystem$PathLookupResult;", "recurseCount", "", "resolveLastSymlink", "createRootOnDemand", "metadataOrNull", "Lokio/FileMetadata;", "open", "Lokio/FileHandle;", "readWrite", "openReadOnly", "openReadWrite", "setExtra", "T", "", "type", "Lkotlin/reflect/KClass;", "(Lokio/Path;Lkotlin/reflect/KClass;Ljava/lang/Object;)V", "sink", "Lokio/Source;", "toString", "", "requireParent", "Element", "FakeFileHandle", "OpenFile", "Operation", "PathLookupResult", "okio-fakefilesystem"})
public final class FakeFileSystem
extends FileSystem {
    @JvmField
    @NotNull
    public final Clock clock;
    @NotNull
    private final Map<Path, Element.Directory> roots;
    @NotNull
    private final List<OpenFile> openFiles;
    @NotNull
    private Path workingDirectory;
    private boolean allowMovingOpenFiles;
    private boolean allowDeletingOpenFiles;
    private boolean allowClobberingEmptyDirectories;
    private boolean allowWritesWhileWriting;
    private boolean allowReadsWhileWriting;
    private boolean allowSymlinks;

    public FakeFileSystem(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        boolean bl = false;
        this.roots = new LinkedHashMap();
        bl = false;
        this.openFiles = new ArrayList();
        this.workingDirectory = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/", (boolean)false, (int)1, null);
    }

    public /* synthetic */ FakeFileSystem(Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clock = (Clock)Clock.System.INSTANCE;
        }
        this(clock);
    }

    @NotNull
    public final Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull Path value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean bl = value.isAbsolute();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"expected an absolute path but was ", (Object)value);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.workingDirectory = value;
    }

    public final boolean getAllowMovingOpenFiles() {
        return this.allowMovingOpenFiles;
    }

    public final void setAllowMovingOpenFiles(boolean bl) {
        this.allowMovingOpenFiles = bl;
    }

    public final boolean getAllowDeletingOpenFiles() {
        return this.allowDeletingOpenFiles;
    }

    public final void setAllowDeletingOpenFiles(boolean bl) {
        this.allowDeletingOpenFiles = bl;
    }

    public final boolean getAllowClobberingEmptyDirectories() {
        return this.allowClobberingEmptyDirectories;
    }

    public final void setAllowClobberingEmptyDirectories(boolean bl) {
        this.allowClobberingEmptyDirectories = bl;
    }

    public final boolean getAllowWritesWhileWriting() {
        return this.allowWritesWhileWriting;
    }

    public final void setAllowWritesWhileWriting(boolean bl) {
        this.allowWritesWhileWriting = bl;
    }

    public final boolean getAllowReadsWhileWriting() {
        return this.allowReadsWhileWriting;
    }

    public final void setAllowReadsWhileWriting(boolean bl) {
        this.allowReadsWhileWriting = bl;
    }

    public final boolean getAllowSymlinks() {
        return this.allowSymlinks;
    }

    public final void setAllowSymlinks(boolean bl) {
        this.allowSymlinks = bl;
    }

    @JvmName(name="allPaths")
    @NotNull
    public final Set<Path> allPaths() {
        boolean bl = false;
        List result = new ArrayList();
        for (Path path : this.roots.keySet()) {
            Collection collection = result;
            Sequence sequence = this.listRecursively(path);
            boolean bl2 = false;
            CollectionsKt.addAll((Collection)collection, (Sequence)sequence);
        }
        CollectionsKt.sort((List)result);
        return CollectionsKt.toSet((Iterable)result);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="openPaths")
    @NotNull
    public final List<Path> openPaths() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.openFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OpenFile openFile = (OpenFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = it.getCanonicalPath();
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    public final void checkNoOpenFiles() {
        OpenFile openFile = (OpenFile)CollectionsKt.firstOrNull(this.openFiles);
        if (openFile == null) {
            return;
        }
        OpenFile firstOpenFile = openFile;
        throw new IllegalStateException(StringsKt.trimMargin$default((String)("\n      |expected 0 open files, but found:\n      |    " + CollectionsKt.joinToString$default((Iterable)this.openFiles, (CharSequence)"\n    ", null, null, (int)0, null, (Function1)checkNoOpenFiles.1.INSTANCE, (int)30, null) + "\n      "), null, (int)1, null), firstOpenFile.getBacktrace());
    }

    public final void emulateWindows() {
        if (!StringsKt.contains$default((CharSequence)this.workingDirectory.toString(), (CharSequence)"\\", (boolean)false, (int)2, null)) {
            this.setWorkingDirectory(Path.Companion.get$default((Path.Companion)Path.Companion, (String)"F:\\", (boolean)false, (int)1, null));
        }
        this.allowMovingOpenFiles = false;
        this.allowDeletingOpenFiles = false;
        this.allowClobberingEmptyDirectories = true;
        this.allowWritesWhileWriting = true;
        this.allowReadsWhileWriting = true;
    }

    public final void emulateUnix() {
        if (!StringsKt.contains$default((CharSequence)this.workingDirectory.toString(), (CharSequence)"/", (boolean)false, (int)2, null)) {
            this.setWorkingDirectory(Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/", (boolean)false, (int)1, null));
        }
        this.allowMovingOpenFiles = true;
        this.allowDeletingOpenFiles = true;
        this.allowClobberingEmptyDirectories = false;
        this.allowWritesWhileWriting = true;
        this.allowReadsWhileWriting = true;
        this.allowSymlinks = true;
    }

    @NotNull
    public Path canonicalize(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.canonicalizeInternal(path);
        PathLookupResult pathLookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, false, 14, null);
        if ((pathLookupResult == null ? null : pathLookupResult.getElement()) == null) {
            throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such file: ", (Object)path));
        }
        return canonicalPath;
    }

    private final Path canonicalizeInternal(Path path) {
        return this.workingDirectory.resolve(path, true);
    }

    public final <T> void setExtra(@NotNull Path path, @NotNull KClass<? extends T> type, @Nullable T value) throws IOException {
        Object object;
        PathLookupResult lookupResult;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Path canonicalPath = this.canonicalizeInternal(path);
        boolean bl = canonicalPath.isRoot();
        PathLookupResult pathLookupResult = lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, bl, 2, null);
        Object object2 = object = pathLookupResult == null ? null : pathLookupResult.getElement();
        if (object == null) {
            throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such file: ", (Object)path));
        }
        Element element = object;
        if (value == null) {
            element.getExtras().remove(type);
        } else {
            object = element.getExtras();
            boolean bl2 = false;
            object.put(type, value);
        }
    }

    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Element element;
        PathLookupResult lookupResult;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.canonicalizeInternal(path);
        boolean bl = canonicalPath.isRoot();
        PathLookupResult pathLookupResult = lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, bl, 2, null);
        return pathLookupResult == null ? null : ((element = pathLookupResult.getElement()) == null ? null : element.getMetadata());
    }

    @NotNull
    public List<Path> list(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        List<Path> list = this.list(dir, true);
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Nullable
    public List<Path> listOrNull(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.list(dir, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> list(Path dir, boolean throwOnFailure) {
        void $this$mapTo$iv$iv;
        Element.Directory directory;
        Path canonicalPath = this.canonicalizeInternal(dir);
        PathLookupResult lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, false, 14, null);
        PathLookupResult pathLookupResult = lookupResult;
        if ((pathLookupResult == null ? null : pathLookupResult.getElement()) == null) {
            if (throwOnFailure) {
                throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such directory: ", (Object)dir));
            }
            return null;
        }
        Element element = lookupResult.getElement();
        Element.Directory directory2 = directory = element instanceof Element.Directory ? (Element.Directory)element : null;
        if (directory == null) {
            if (throwOnFailure) {
                throw new IOException(Intrinsics.stringPlus((String)"not a directory: ", (Object)dir));
            }
            return null;
        }
        Element.Directory element2 = directory;
        Element.access$default(element2, this.clock.now(), false, 2, null);
        Iterable $this$map$iv = element2.getChildren().keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ByteString byteString = (ByteString)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = dir.resolve((ByteString)it);
            collection.add(path);
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Source source(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileHandle fileHandle = this.openReadOnly(file);
        Source source = FileHandle.source$default((FileHandle)fileHandle, (long)0L, (int)1, null);
        boolean bl = false;
        boolean bl2 = false;
        Source it = source;
        boolean bl3 = false;
        fileHandle.close();
        return source;
    }

    @NotNull
    public Sink sink(@NotNull Path file, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileHandle fileHandle = FakeFileSystem.open$default(this, file, true, mustCreate, false, 8, null);
        fileHandle.resize(0L);
        Sink sink = FileHandle.sink$default((FileHandle)fileHandle, (long)0L, (int)1, null);
        boolean bl = false;
        boolean bl2 = false;
        Sink it = sink;
        boolean bl3 = false;
        fileHandle.close();
        return sink;
    }

    @NotNull
    public Sink appendingSink(@NotNull Path file, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileHandle fileHandle = FakeFileSystem.open$default(this, file, true, false, mustExist, 4, null);
        Sink sink = fileHandle.appendingSink();
        boolean bl = false;
        boolean bl2 = false;
        Sink it = sink;
        boolean bl3 = false;
        fileHandle.close();
        return sink;
    }

    @NotNull
    public FileHandle openReadOnly(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FakeFileSystem.open$default(this, file, false, false, false, 12, null);
    }

    @NotNull
    public FileHandle openReadWrite(@NotNull Path file, boolean mustCreate, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.open(file, true, mustCreate, mustExist);
    }

    private final FileHandle open(Path file, boolean readWrite, boolean mustCreate, boolean mustExist) {
        Object object;
        Object object2;
        boolean bl = !mustCreate || !mustExist;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot require mustCreate and mustExist at the same time.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path canonicalPath = this.canonicalizeInternal(file);
        PathLookupResult lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, readWrite, 6, null);
        Instant now = this.clock.now();
        Element element = null;
        Operation operation = null;
        Object object3 = lookupResult;
        if ((object3 == null ? null : ((PathLookupResult)object3).getElement()) == null && mustExist) {
            throw new IOException(file + " doesn't exist.");
        }
        object3 = lookupResult;
        if ((object3 == null ? null : ((PathLookupResult)object3).getElement()) != null && mustCreate) {
            throw new IOException(file + " already exists.");
        }
        if (readWrite) {
            object3 = lookupResult;
            if ((object3 == null ? null : ((PathLookupResult)object3).getElement()) instanceof Element.Directory) {
                throw new IOException(Intrinsics.stringPlus((String)"destination is a directory: ", (Object)file));
            }
            if (!this.allowWritesWhileWriting && (object3 = this.findOpenFile(canonicalPath, Operation.WRITE)) != null) {
                Object object4 = object3;
                boolean bl5 = false;
                boolean bl6 = false;
                Object it = object4;
                boolean bl7 = false;
                throw new IOException(Intrinsics.stringPlus((String)"file is already open for writing ", (Object)file), ((OpenFile)it).getBacktrace());
            }
            if (!this.allowReadsWhileWriting && (object3 = this.findOpenFile(canonicalPath, Operation.READ)) != null) {
                Object object5 = object3;
                boolean bl8 = false;
                boolean bl9 = false;
                Object it = object5;
                boolean bl10 = false;
                throw new IOException(Intrinsics.stringPlus((String)"file is already open for reading ", (Object)file), ((OpenFile)it).getBacktrace());
            }
            object2 = lookupResult;
            Object object6 = object = object2 == null ? null : ((PathLookupResult)object2).getParent();
            if (object == null) {
                throw new FileNotFoundException("parent directory does not exist");
            }
            Element parent = object;
            parent.access(now, true);
            Element existing = lookupResult.getElement();
            object2 = existing;
            element = new Element.File(object2 == null ? now : ((Element)object2).getCreatedAt());
            object2 = ((Element.Directory)parent).getChildren();
            ByteString byteString = lookupResult.getSegment();
            Intrinsics.checkNotNull((Object)byteString);
            ByteString byteString2 = byteString;
            boolean bl11 = false;
            object2.put((ByteString)byteString2, (Element)element);
            operation = Operation.WRITE;
            if (existing instanceof Element.File) {
                ((Element.File)element).setData(((Element.File)existing).getData());
            }
        } else {
            object2 = lookupResult;
            Object object7 = object = object2 == null ? null : ((PathLookupResult)object2).getElement();
            if (object == null) {
                throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such file: ", (Object)file));
            }
            Object existing = object;
            Object object8 = object = existing instanceof Element.File ? (Element.File)existing : null;
            if (object == null) {
                throw new IOException(Intrinsics.stringPlus((String)"not a file: ", (Object)file));
            }
            element = object;
            operation = Operation.READ;
            if (!this.allowReadsWhileWriting && (object = this.findOpenFile(canonicalPath, Operation.WRITE)) != null) {
                object2 = object;
                boolean bl12 = false;
                boolean bl13 = false;
                Map<ByteString, Element> it = object2;
                boolean bl14 = false;
                throw new IOException(Intrinsics.stringPlus((String)"file is already open for writing ", (Object)file), ((OpenFile)((Object)it)).getBacktrace());
            }
        }
        element.access(this.clock.now(), readWrite);
        OpenFile openFile = new OpenFile(canonicalPath, operation, new Exception("file opened for " + (Object)((Object)operation) + " here"));
        object = this;
        object2 = ((FakeFileSystem)((Object)object)).openFiles;
        boolean bl15 = false;
        object2.add(openFile);
        return new FakeFileHandle(readWrite, openFile, (Element.File)element);
    }

    static /* synthetic */ FileHandle open$default(FakeFileSystem fakeFileSystem, Path path, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return fakeFileSystem.open(path, bl, bl2, bl3);
    }

    public void createDirectory(@NotNull Path dir, boolean mustCreate) {
        PathLookupResult pathLookupResult;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Path canonicalPath = this.canonicalizeInternal(dir);
        PathLookupResult lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, true, 6, null);
        if (canonicalPath.isRoot()) {
            return;
        }
        if (mustCreate && ((pathLookupResult = lookupResult) == null ? null : pathLookupResult.getElement()) != null) {
            throw new IOException(Intrinsics.stringPlus((String)"already exists: ", (Object)dir));
        }
        Element.Directory parentDirectory = this.requireParent(lookupResult);
        Map<ByteString, Element> map = parentDirectory.getChildren();
        ByteString byteString = canonicalPath.nameBytes();
        Element.Directory directory = new Element.Directory(this.clock.now());
        boolean bl = false;
        map.put(byteString, directory);
    }

    public void atomicMove(@NotNull Path source, @NotNull Path target) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path canonicalSource = this.canonicalizeInternal(source);
        Path canonicalTarget = this.canonicalizeInternal(target);
        PathLookupResult targetLookupResult = FakeFileSystem.lookupPath$default(this, canonicalTarget, 0, false, true, 6, null);
        PathLookupResult sourceLookupResult = FakeFileSystem.lookupPath$default(this, canonicalSource, 0, false, false, 10, null);
        PathLookupResult pathLookupResult = targetLookupResult;
        if ((pathLookupResult == null ? null : pathLookupResult.getElement()) instanceof Element.Directory) {
            throw new IOException(Intrinsics.stringPlus((String)"target is a directory: ", (Object)target));
        }
        Element.Directory targetParent = this.requireParent(targetLookupResult);
        if (!this.allowMovingOpenFiles) {
            object = FakeFileSystem.findOpenFile$default(this, canonicalSource, null, 2, null);
            if (object != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                throw new IOException(Intrinsics.stringPlus((String)"source is open ", (Object)source), ((OpenFile)it).getBacktrace());
            }
            object = FakeFileSystem.findOpenFile$default(this, canonicalTarget, null, 2, null);
            if (object != null) {
                Object object3 = object;
                boolean bl = false;
                boolean bl4 = false;
                Object it = object3;
                boolean bl5 = false;
                throw new IOException(Intrinsics.stringPlus((String)"target is open ", (Object)target), ((OpenFile)it).getBacktrace());
            }
        }
        if (!this.allowClobberingEmptyDirectories && ((object = sourceLookupResult) == null ? null : ((PathLookupResult)object).getElement()) instanceof Element.Directory && ((object = targetLookupResult) == null ? null : ((PathLookupResult)object).getElement()) instanceof Element.File) {
            throw new IOException("source is a directory and target is a file");
        }
        Element.Directory sourceParent = this.requireParent(sourceLookupResult);
        Object object4 = sourceParent.getChildren().remove(canonicalSource.nameBytes());
        if (object4 == null) {
            throw new FileNotFoundException(Intrinsics.stringPlus((String)"source doesn't exist: ", (Object)source));
        }
        Element removed = object4;
        object4 = targetParent.getChildren();
        ByteString byteString = canonicalTarget.nameBytes();
        boolean bl = false;
        object4.put(byteString, removed);
    }

    public void delete(@NotNull Path path, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.canonicalizeInternal(path);
        PathLookupResult lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, true, 2, null);
        Object object = lookupResult;
        if ((object == null ? null : ((PathLookupResult)object).getElement()) == null) {
            if (mustExist) {
                throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such file: ", (Object)path));
            }
            return;
        }
        if (lookupResult.getElement() instanceof Element.Directory) {
            object = ((Element.Directory)lookupResult.getElement()).getChildren();
            boolean bl = false;
            if (!object.isEmpty()) {
                throw new IOException("non-empty directory");
            }
        }
        if (!this.allowDeletingOpenFiles && (object = FakeFileSystem.findOpenFile$default(this, canonicalPath, null, 2, null)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            throw new IOException(Intrinsics.stringPlus((String)"file is open ", (Object)path), ((OpenFile)it).getBacktrace());
        }
        Element.Directory directory = this.requireParent(lookupResult);
        directory.getChildren().remove(canonicalPath.nameBytes());
    }

    public void createSymlink(@NotNull Path source, @NotNull Path target) {
        PathLookupResult existingLookupResult;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path canonicalSource = this.canonicalizeInternal(source);
        PathLookupResult pathLookupResult = existingLookupResult = FakeFileSystem.lookupPath$default(this, canonicalSource, 0, false, true, 6, null);
        if ((pathLookupResult == null ? null : pathLookupResult.getElement()) != null) {
            throw new IOException(Intrinsics.stringPlus((String)"already exists: ", (Object)source));
        }
        Element.Directory parent = this.requireParent(existingLookupResult);
        if (!this.allowSymlinks) {
            throw new IOException("symlinks are not supported");
        }
        Map<ByteString, Element> map = parent.getChildren();
        ByteString byteString = canonicalSource.nameBytes();
        Element.Symlink symlink = new Element.Symlink(this.clock.now(), target);
        boolean bl = false;
        map.put(byteString, symlink);
    }

    private final PathLookupResult lookupPath(Path canonicalPath, int recurseCount, boolean resolveLastSymlink, boolean createRootOnDemand) {
        int n;
        if (recurseCount > 40) {
            throw new IOException("symlink cycle?");
        }
        Path path = canonicalPath.getRoot();
        Intrinsics.checkNotNull((Object)path);
        Path rootPath = path;
        Element.Directory root = this.roots.get(rootPath);
        if (root == null) {
            if (!createRootOnDemand) {
                return null;
            }
            root = new Element.Directory(this.clock.now());
            Map<Path, Element.Directory> map = this.roots;
            boolean bl = false;
            map.put(rootPath, root);
        }
        Element.Directory parent = null;
        ByteString lastSegment = null;
        Object current = root;
        Path currentPath = rootPath;
        int segmentsTraversed = 0;
        List segments = canonicalPath.getSegmentsBytes();
        Iterator iterator = segments.iterator();
        while (iterator.hasNext()) {
            boolean followSymlinks;
            ByteString segment;
            lastSegment = segment = (ByteString)iterator.next();
            if (!(current instanceof Element.Directory)) {
                throw new IOException(Intrinsics.stringPlus((String)"not a directory: ", (Object)currentPath));
            }
            parent = (Element.Directory)current;
            Element element = ((Element.Directory)current).getChildren().get(segment);
            if (element == null) break;
            current = element;
            currentPath = currentPath.resolve(segment);
            int n2 = segmentsTraversed;
            boolean isLastSegment = (segmentsTraversed = n2 + 1) == segments.size();
            boolean bl = followSymlinks = !isLastSegment || resolveLastSymlink;
            if (!(current instanceof Element.Symlink) || !followSymlinks) continue;
            Element.access$default((Element)current, this.clock.now(), false, 2, null);
            Path path2 = currentPath.parent();
            Intrinsics.checkNotNull((Object)path2);
            currentPath = path2.resolve(((Element.Symlink)current).getTarget(), true);
            Object object = FakeFileSystem.lookupPath$default(this, currentPath, recurseCount + 1, false, createRootOnDemand, 4, null);
            if (object == null) break;
            PathLookupResult symlinkLookupResult = object;
            parent = symlinkLookupResult.getParent();
            lastSegment = symlinkLookupResult.getSegment();
            object = symlinkLookupResult.getElement();
            if (object == null) break;
            current = object;
        }
        return (n = segmentsTraversed) == segments.size() ? new PathLookupResult(parent, lastSegment, (Element)current) : (n == segments.size() - 1 ? new PathLookupResult(parent, lastSegment, null) : null);
    }

    static /* synthetic */ PathLookupResult lookupPath$default(FakeFileSystem fakeFileSystem, Path path, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return fakeFileSystem.lookupPath(path, n, bl, bl2);
    }

    private final Element.Directory requireParent(PathLookupResult $this$requireParent) {
        Element.Directory directory;
        PathLookupResult pathLookupResult = $this$requireParent;
        Element.Directory directory2 = directory = pathLookupResult == null ? null : pathLookupResult.getParent();
        if (directory == null) {
            throw new IOException("parent directory does not exist");
        }
        return directory;
    }

    private final OpenFile findOpenFile(Path canonicalPath, Operation operation) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.openFiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OpenFile it = (OpenFile)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getCanonicalPath(), (Object)canonicalPath) && (operation == null || operation == it.getOperation()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    static /* synthetic */ OpenFile findOpenFile$default(FakeFileSystem fakeFileSystem, Path path, Operation operation, int n, Object object) {
        if ((n & 2) != 0) {
            operation = null;
        }
        return fakeFileSystem.findOpenFile(path, operation);
    }

    private final void checkOffsetAndCount(long size, long offset, long byteCount) {
        if ((offset | byteCount) < 0L || offset > size || size - offset < byteCount) {
            throw new ArrayIndexOutOfBoundsException("size=" + size + " offset=" + offset + " byteCount=" + byteCount);
        }
    }

    @NotNull
    public String toString() {
        return "FakeFileSystem";
    }

    public FakeFileSystem() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lokio/fakefilesystem/FakeFileSystem$PathLookupResult;", "", "parent", "Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "segment", "Lokio/ByteString;", "element", "Lokio/fakefilesystem/FakeFileSystem$Element;", "(Lokio/fakefilesystem/FakeFileSystem$Element$Directory;Lokio/ByteString;Lokio/fakefilesystem/FakeFileSystem$Element;)V", "getElement", "()Lokio/fakefilesystem/FakeFileSystem$Element;", "getParent", "()Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "getSegment", "()Lokio/ByteString;", "okio-fakefilesystem"})
    private static final class PathLookupResult {
        @Nullable
        private final Element.Directory parent;
        @Nullable
        private final ByteString segment;
        @Nullable
        private final Element element;

        public PathLookupResult(@Nullable Element.Directory parent, @Nullable ByteString segment, @Nullable Element element) {
            this.parent = parent;
            this.segment = segment;
            this.element = element;
        }

        @Nullable
        public final Element.Directory getParent() {
            return this.parent;
        }

        @Nullable
        public final ByteString getSegment() {
            return this.segment;
        }

        @Nullable
        public final Element getElement() {
            return this.element;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\u0004R\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\u0004R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u0003\u001e\u001f \u00a8\u0006!"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element;", "", "createdAt", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)V", "getCreatedAt", "()Lkotlinx/datetime/Instant;", "extras", "", "Lkotlin/reflect/KClass;", "getExtras", "()Ljava/util/Map;", "lastAccessedAt", "getLastAccessedAt", "setLastAccessedAt", "lastModifiedAt", "getLastModifiedAt", "setLastModifiedAt", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "access", "", "now", "modified", "", "Directory", "File", "Symlink", "Lokio/fakefilesystem/FakeFileSystem$Element$File;", "Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "Lokio/fakefilesystem/FakeFileSystem$Element$Symlink;", "okio-fakefilesystem"})
    private static abstract class Element {
        @NotNull
        private final Instant createdAt;
        @NotNull
        private Instant lastModifiedAt;
        @NotNull
        private Instant lastAccessedAt;
        @NotNull
        private final Map<KClass<?>, Object> extras;

        private Element(Instant createdAt) {
            this.lastModifiedAt = this.createdAt = createdAt;
            this.lastAccessedAt = this.createdAt;
            boolean bl = false;
            this.extras = new LinkedHashMap();
        }

        @NotNull
        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastModifiedAt = instant;
        }

        @NotNull
        public final Instant getLastAccessedAt() {
            return this.lastAccessedAt;
        }

        public final void setLastAccessedAt(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastAccessedAt = instant;
        }

        @NotNull
        public final Map<KClass<?>, Object> getExtras() {
            return this.extras;
        }

        public final void access(@NotNull Instant now, boolean modified) {
            Intrinsics.checkNotNullParameter((Object)now, (String)"now");
            this.lastAccessedAt = now;
            if (modified) {
                this.lastModifiedAt = now;
            }
        }

        public static /* synthetic */ void access$default(Element element, Instant instant, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: access");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            element.access(instant, bl);
        }

        @NotNull
        public abstract FileMetadata getMetadata();

        public /* synthetic */ Element(Instant createdAt, DefaultConstructorMarker $constructor_marker) {
            this(createdAt);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element$File;", "Lokio/fakefilesystem/FakeFileSystem$Element;", "createdAt", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)V", "data", "Lokio/ByteString;", "getData", "()Lokio/ByteString;", "setData", "(Lokio/ByteString;)V", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "okio-fakefilesystem"})
        public static final class File
        extends Element {
            @NotNull
            private ByteString data;

            public File(@NotNull Instant createdAt) {
                Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
                super(createdAt, null);
                this.data = ByteString.EMPTY;
            }

            @NotNull
            public final ByteString getData() {
                return this.data;
            }

            public final void setData(@NotNull ByteString byteString) {
                Intrinsics.checkNotNullParameter((Object)byteString, (String)"<set-?>");
                this.data = byteString;
            }

            @Override
            @NotNull
            public FileMetadata getMetadata() {
                return -Time.newFileMetadata$default(true, false, null, Long.valueOf(this.data.size()), this.getCreatedAt(), this.getLastModifiedAt(), this.getLastAccessedAt(), this.getExtras(), 6, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "Lokio/fakefilesystem/FakeFileSystem$Element;", "createdAt", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)V", "children", "", "Lokio/ByteString;", "getChildren", "()Ljava/util/Map;", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "okio-fakefilesystem"})
        public static final class Directory
        extends Element {
            @NotNull
            private final Map<ByteString, Element> children;

            public Directory(@NotNull Instant createdAt) {
                Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
                super(createdAt, null);
                boolean bl = false;
                this.children = new LinkedHashMap();
            }

            @NotNull
            public final Map<ByteString, Element> getChildren() {
                return this.children;
            }

            @Override
            @NotNull
            public FileMetadata getMetadata() {
                return -Time.newFileMetadata$default(false, true, null, null, this.getCreatedAt(), this.getLastModifiedAt(), this.getLastAccessedAt(), this.getExtras(), 13, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element$Symlink;", "Lokio/fakefilesystem/FakeFileSystem$Element;", "createdAt", "Lkotlinx/datetime/Instant;", "target", "Lokio/Path;", "(Lkotlinx/datetime/Instant;Lokio/Path;)V", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "getTarget", "()Lokio/Path;", "okio-fakefilesystem"})
        public static final class Symlink
        extends Element {
            @NotNull
            private final Path target;

            public Symlink(@NotNull Instant createdAt, @NotNull Path target) {
                Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super(createdAt, null);
                this.target = target;
            }

            @NotNull
            public final Path getTarget() {
                return this.target;
            }

            @Override
            @NotNull
            public FileMetadata getMetadata() {
                return -Time.newFileMetadata$default(false, false, this.target, null, this.getCreatedAt(), this.getLastModifiedAt(), this.getLastAccessedAt(), this.getExtras(), 11, null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "", "canonicalPath", "Lokio/Path;", "operation", "Lokio/fakefilesystem/FakeFileSystem$Operation;", "backtrace", "", "(Lokio/Path;Lokio/fakefilesystem/FakeFileSystem$Operation;Ljava/lang/Throwable;)V", "getBacktrace", "()Ljava/lang/Throwable;", "getCanonicalPath", "()Lokio/Path;", "getOperation", "()Lokio/fakefilesystem/FakeFileSystem$Operation;", "okio-fakefilesystem"})
    private static final class OpenFile {
        @NotNull
        private final Path canonicalPath;
        @NotNull
        private final Operation operation;
        @NotNull
        private final Throwable backtrace;

        public OpenFile(@NotNull Path canonicalPath, @NotNull Operation operation, @NotNull Throwable backtrace) {
            Intrinsics.checkNotNullParameter((Object)canonicalPath, (String)"canonicalPath");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            Intrinsics.checkNotNullParameter((Object)backtrace, (String)"backtrace");
            this.canonicalPath = canonicalPath;
            this.operation = operation;
            this.backtrace = backtrace;
        }

        @NotNull
        public final Path getCanonicalPath() {
            return this.canonicalPath;
        }

        @NotNull
        public final Operation getOperation() {
            return this.operation;
        }

        @NotNull
        public final Throwable getBacktrace() {
            return this.backtrace;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Operation;", "", "(Ljava/lang/String;I)V", "READ", "WRITE", "okio-fakefilesystem"})
    private static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation READ = new Operation();
        public static final /* enum */ Operation WRITE = new Operation();
        private static final /* synthetic */ Operation[] $VALUES;

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String value) {
            return Enum.valueOf(Operation.class, value);
        }

        static {
            $VALUES = operationArray = new Operation[]{Operation.READ, Operation.WRITE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0014J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0010H\u0014J\b\u0010\u0017\u001a\u00020\u0010H\u0014J(\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lokio/fakefilesystem/FakeFileSystem$FakeFileHandle;", "Lokio/FileHandle;", "readWrite", "", "openFile", "Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "file", "Lokio/fakefilesystem/FakeFileSystem$Element$File;", "(Lokio/fakefilesystem/FakeFileSystem;ZLokio/fakefilesystem/FakeFileSystem$OpenFile;Lokio/fakefilesystem/FakeFileSystem$Element$File;)V", "closed", "protectedClose", "", "protectedFlush", "protectedRead", "", "fileOffset", "", "array", "", "arrayOffset", "byteCount", "protectedResize", "size", "protectedSize", "protectedWrite", "toString", "", "okio-fakefilesystem"})
    private final class FakeFileHandle
    extends FileHandle {
        @NotNull
        private final OpenFile openFile;
        @NotNull
        private final Element.File file;
        private boolean closed;

        public FakeFileHandle(@NotNull boolean readWrite, @NotNull OpenFile openFile, Element.File file) {
            Intrinsics.checkNotNullParameter((Object)((Object)FakeFileSystem.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)openFile, (String)"openFile");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(readWrite);
            this.openFile = openFile;
            this.file = file;
        }

        protected void protectedResize(long size) {
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            long delta = size - (long)this.file.getData().size();
            if (delta > 0L) {
                this.file.setData(new Buffer().write(this.file.getData()).write(new byte[(int)delta]).readByteString());
            } else {
                this.file.setData(this.file.getData().substring(0, (int)size));
            }
            this.file.access(FakeFileSystem.this.clock.now(), true);
        }

        protected long protectedSize() {
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return this.file.getData().size();
        }

        protected int protectedRead(long fileOffset, @NotNull byte[] array, int arrayOffset, int byteCount) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            boolean bl = !this.closed;
            boolean bl2 = false;
            int n = 0;
            if (!bl) {
                boolean bl3 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            FakeFileSystem.this.checkOffsetAndCount(array.length, arrayOffset, byteCount);
            int fileOffsetInt = (int)fileOffset;
            n = this.file.getData().size() - fileOffsetInt;
            boolean bl3 = false;
            int toCopy = Math.min(n, byteCount);
            if (toCopy <= 0) {
                return -1;
            }
            n = 0;
            if (n < toCopy) {
                do {
                    int i = n++;
                    array[i + arrayOffset] = this.file.getData().getByte(i + fileOffsetInt);
                } while (n < toCopy);
            }
            return toCopy;
        }

        protected void protectedWrite(long fileOffset, @NotNull byte[] array, int arrayOffset, int byteCount) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            boolean bl = !this.closed;
            int n = 0;
            int n2 = 0;
            if (!bl) {
                boolean bl2 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            FakeFileSystem.this.checkOffsetAndCount(array.length, arrayOffset, byteCount);
            Buffer buffer = new Buffer();
            n = (int)fileOffset;
            n2 = this.file.getData().size();
            boolean bl3 = false;
            buffer.write(this.file.getData(), 0, Math.min(n, n2));
            while (buffer.size() < fileOffset) {
                buffer.writeByte(0);
            }
            buffer.write(array, arrayOffset, byteCount);
            if (buffer.size() < (long)this.file.getData().size()) {
                buffer.write(this.file.getData(), (int)buffer.size(), this.file.getData().size() - (int)buffer.size());
            }
            this.file.setData(buffer.snapshot());
            this.file.access(FakeFileSystem.this.clock.now(), true);
        }

        protected void protectedFlush() {
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        protected void protectedClose() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.file.access(FakeFileSystem.this.clock.now(), this.getReadWrite());
            FakeFileSystem fakeFileSystem = FakeFileSystem.this;
            Collection collection = fakeFileSystem.openFiles;
            OpenFile openFile = this.openFile;
            boolean bl = false;
            collection.remove(openFile);
        }

        @NotNull
        public String toString() {
            return "FileHandler(" + this.openFile.getCanonicalPath() + ')';
        }
    }
}

