/*
 * Decompiled with CFR 0.152.
 */
package okio.fakefilesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.Instant;
import kotlinx.datetime.Clock;
import okio.Buffer;
import okio.ByteString;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Path;
import okio.Sink;
import okio.Source;
import okio.fakefilesystem.-Time;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005opqrsB\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007B\u0013\b\u0016\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0005\u0010\nB\u0013\b\u0017\u0012\b\b\u0002\u0010\b\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0006\u00108\u001a\u000209J\u0006\u0010:\u001a\u000209J\u0006\u0010;\u001a\u000209J\u0010\u0010<\u001a\u00020\u00112\u0006\u0010=\u001a\u00020\u0011H\u0016J\u0010\u0010>\u001a\u00020\u00112\u0006\u0010=\u001a\u00020\u0011H\u0002J7\u0010?\u001a\u000209\"\b\b\u0000\u0010@*\u00020A2\u0006\u0010=\u001a\u00020\u00112\u000e\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u0002H@0C2\b\u0010\u0018\u001a\u0004\u0018\u0001H@\u00a2\u0006\u0002\u0010DJ\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010=\u001a\u00020\u0011H\u0016J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\u0011062\u0006\u0010H\u001a\u00020\u0011H\u0016J\u0018\u0010I\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u0001062\u0006\u0010H\u001a\u00020\u0011H\u0016J \u0010G\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u0001062\u0006\u0010H\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u0017H\u0002J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u0011H\u0016J\u0018\u0010N\u001a\u00020O2\u0006\u0010M\u001a\u00020\u00112\u0006\u0010P\u001a\u00020\u0017H\u0016J\u0018\u0010Q\u001a\u00020O2\u0006\u0010M\u001a\u00020\u00112\u0006\u0010R\u001a\u00020\u0017H\u0016J\u0010\u0010S\u001a\u00020T2\u0006\u0010M\u001a\u00020\u0011H\u0016J \u0010U\u001a\u00020T2\u0006\u0010M\u001a\u00020\u00112\u0006\u0010P\u001a\u00020\u00172\u0006\u0010R\u001a\u00020\u0017H\u0016J,\u0010V\u001a\u00020T2\u0006\u0010M\u001a\u00020\u00112\u0006\u0010W\u001a\u00020\u00172\b\b\u0002\u0010P\u001a\u00020\u00172\b\b\u0002\u0010R\u001a\u00020\u0017H\u0002J\u0018\u0010X\u001a\u0002092\u0006\u0010H\u001a\u00020\u00112\u0006\u0010P\u001a\u00020\u0017H\u0016J\u0018\u0010Y\u001a\u0002092\u0006\u0010K\u001a\u00020\u00112\u0006\u0010Z\u001a\u00020\u0011H\u0016J\u0018\u0010[\u001a\u0002092\u0006\u0010=\u001a\u00020\u00112\u0006\u0010R\u001a\u00020\u0017H\u0016J\u0018\u0010\\\u001a\u0002092\u0006\u0010K\u001a\u00020\u00112\u0006\u0010Z\u001a\u00020\u0011H\u0016J0\u0010]\u001a\u0004\u0018\u00010^2\u0006\u0010_\u001a\u00020\u00112\b\b\u0002\u0010`\u001a\u00020a2\b\b\u0002\u0010b\u001a\u00020\u00172\b\b\u0002\u0010c\u001a\u00020\u0017H\u0002J\u000e\u0010d\u001a\u00020\u0012*\u0004\u0018\u00010^H\u0002J\u001e\u0010e\u001a\u0004\u0018\u00010\u00152\u0006\u0010_\u001a\u00020\u00112\n\b\u0002\u0010f\u001a\u0004\u0018\u00010gH\u0002J \u0010h\u001a\u0002092\u0006\u0010i\u001a\u00020\u00042\u0006\u0010j\u001a\u00020\u00042\u0006\u0010k\u001a\u00020\u0004H\u0002J\b\u0010l\u001a\u000209H\u0016J\b\u0010m\u001a\u00020nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\u001a\u0010&\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\u001a\u0010)\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010 \"\u0004\b+\u0010\"R\u001a\u0010,\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010 \"\u0004\b.\u0010\"R\u001a\u0010/\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010 \"\u0004\b1\u0010\"R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u0011038G\u00a2\u0006\u0006\u001a\u0004\b2\u00104R\u0017\u00105\u001a\b\u0012\u0004\u0012\u00020\u0011068G\u00a2\u0006\u0006\u001a\u0004\b5\u00107\u00a8\u0006t"}, d2={"Lokio/fakefilesystem/FakeFileSystem;", "Lokio/FileSystem;", "clockNowMillis", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "()V", "clock", "Lkotlin/time/Clock;", "(Lkotlin/time/Clock;)V", "Lkotlinx/datetime/Clock;", "(Lkotlinx/datetime/Clock;)V", "getClock", "()Lkotlin/time/Clock;", "roots", "", "Lokio/Path;", "Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "openFiles", "", "Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "closed", "", "value", "workingDirectory", "getWorkingDirectory", "()Lokio/Path;", "setWorkingDirectory", "(Lokio/Path;)V", "allowMovingOpenFiles", "getAllowMovingOpenFiles", "()Z", "setAllowMovingOpenFiles", "(Z)V", "allowDeletingOpenFiles", "getAllowDeletingOpenFiles", "setAllowDeletingOpenFiles", "allowClobberingEmptyDirectories", "getAllowClobberingEmptyDirectories", "setAllowClobberingEmptyDirectories", "allowWritesWhileWriting", "getAllowWritesWhileWriting", "setAllowWritesWhileWriting", "allowReadsWhileWriting", "getAllowReadsWhileWriting", "setAllowReadsWhileWriting", "allowSymlinks", "getAllowSymlinks", "setAllowSymlinks", "allPaths", "", "()Ljava/util/Set;", "openPaths", "", "()Ljava/util/List;", "checkNoOpenFiles", "", "emulateWindows", "emulateUnix", "canonicalize", "path", "canonicalizeInternal", "setExtra", "T", "", "type", "Lkotlin/reflect/KClass;", "(Lokio/Path;Lkotlin/reflect/KClass;Ljava/lang/Object;)V", "metadataOrNull", "Lokio/FileMetadata;", "list", "dir", "listOrNull", "throwOnFailure", "source", "Lokio/Source;", "file", "sink", "Lokio/Sink;", "mustCreate", "appendingSink", "mustExist", "openReadOnly", "Lokio/FileHandle;", "openReadWrite", "open", "readWrite", "createDirectory", "atomicMove", "target", "delete", "createSymlink", "lookupPath", "Lokio/fakefilesystem/FakeFileSystem$PathLookupResult;", "canonicalPath", "recurseCount", "", "resolveLastSymlink", "createRootOnDemand", "requireParent", "findOpenFile", "operation", "Lokio/fakefilesystem/FakeFileSystem$Operation;", "checkOffsetAndCount", "size", "offset", "byteCount", "close", "toString", "", "PathLookupResult", "Element", "OpenFile", "Operation", "FakeFileHandle", "okio-fakefilesystem"})
@SourceDebugExtension(value={"SMAP\nFakeFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeFileSystem.kt\nokio/fakefilesystem/FakeFileSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,808:1\n1563#2:809\n1634#2,3:810\n1563#2:814\n1634#2,3:815\n295#2,2:818\n1#3:813\n*S KotlinDebug\n*F\n+ 1 FakeFileSystem.kt\nokio/fakefilesystem/FakeFileSystem\n*L\n184#1:809\n184#1:810,3\n308#1:814\n308#1:815,3\n696#1:818,2\n*E\n"})
public final class FakeFileSystem
extends FileSystem {
    @NotNull
    private final Function0<Long> clockNowMillis;
    @NotNull
    private final Map<Path, Element.Directory> roots;
    @NotNull
    private final List<OpenFile> openFiles;
    private boolean closed;
    @NotNull
    private Path workingDirectory;
    private boolean allowMovingOpenFiles;
    private boolean allowDeletingOpenFiles;
    private boolean allowClobberingEmptyDirectories;
    private boolean allowWritesWhileWriting;
    private boolean allowReadsWhileWriting;
    private boolean allowSymlinks;

    private FakeFileSystem(Function0<Long> clockNowMillis) {
        this.clockNowMillis = clockNowMillis;
        this.roots = new LinkedHashMap();
        this.openFiles = new ArrayList();
        this.workingDirectory = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/", (boolean)false, (int)1, null);
    }

    public FakeFileSystem() {
        this(-Time.getDefaultClockNowMillis());
    }

    public FakeFileSystem(@NotNull Clock clock2) {
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        this((Function0<Long>)((Function0)() -> FakeFileSystem._init_$lambda$0(clock2)));
    }

    public /* synthetic */ FakeFileSystem(Clock clock2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clock2 = (Clock)Clock.System.INSTANCE;
        }
        this(clock2);
    }

    @Deprecated(message="Use the constructor that accepts a kotlin.time.Clock, or the no-args constructor", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ FakeFileSystem(kotlinx.datetime.Clock clock2) {
        Intrinsics.checkNotNullParameter((Object)clock2, (String)"clock");
        this((Function0<Long>)(clock2 == Clock.System.INSTANCE ? -Time.getDefaultClockNowMillis() : () -> FakeFileSystem._init_$lambda$1(clock2)));
    }

    public /* synthetic */ FakeFileSystem(kotlinx.datetime.Clock clock2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clock2 = (kotlinx.datetime.Clock)Clock.System.INSTANCE;
        }
        this(clock2);
    }

    @NotNull
    public final Clock getClock() {
        return new Clock(this){
            final /* synthetic */ FakeFileSystem this$0;
            {
                this.this$0 = $receiver;
            }

            public Instant now() {
                return Instant.Companion.fromEpochMilliseconds(((Number)FakeFileSystem.access$getClockNowMillis$p(this.this$0).invoke()).longValue());
            }
        };
    }

    @NotNull
    public final Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull Path value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!value.isAbsolute()) {
            boolean bl = false;
            String string = "expected an absolute path but was " + value;
            throw new IllegalArgumentException(string.toString());
        }
        this.workingDirectory = value;
    }

    public final boolean getAllowMovingOpenFiles() {
        return this.allowMovingOpenFiles;
    }

    public final void setAllowMovingOpenFiles(boolean bl) {
        this.allowMovingOpenFiles = bl;
    }

    public final boolean getAllowDeletingOpenFiles() {
        return this.allowDeletingOpenFiles;
    }

    public final void setAllowDeletingOpenFiles(boolean bl) {
        this.allowDeletingOpenFiles = bl;
    }

    public final boolean getAllowClobberingEmptyDirectories() {
        return this.allowClobberingEmptyDirectories;
    }

    public final void setAllowClobberingEmptyDirectories(boolean bl) {
        this.allowClobberingEmptyDirectories = bl;
    }

    public final boolean getAllowWritesWhileWriting() {
        return this.allowWritesWhileWriting;
    }

    public final void setAllowWritesWhileWriting(boolean bl) {
        this.allowWritesWhileWriting = bl;
    }

    public final boolean getAllowReadsWhileWriting() {
        return this.allowReadsWhileWriting;
    }

    public final void setAllowReadsWhileWriting(boolean bl) {
        this.allowReadsWhileWriting = bl;
    }

    public final boolean getAllowSymlinks() {
        return this.allowSymlinks;
    }

    public final void setAllowSymlinks(boolean bl) {
        this.allowSymlinks = bl;
    }

    @JvmName(name="allPaths")
    @NotNull
    public final Set<Path> allPaths() {
        List result = new ArrayList();
        for (Path path : this.roots.keySet()) {
            CollectionsKt.addAll((Collection)result, (Sequence)this.listRecursively(path));
        }
        CollectionsKt.sort((List)result);
        return CollectionsKt.toSet((Iterable)result);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="openPaths")
    @NotNull
    public final List<Path> openPaths() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.openFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OpenFile openFile = (OpenFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCanonicalPath());
        }
        return (List)destination$iv$iv;
    }

    public final void checkNoOpenFiles() {
        OpenFile openFile = (OpenFile)CollectionsKt.firstOrNull(this.openFiles);
        if (openFile == null) {
            return;
        }
        OpenFile firstOpenFile = openFile;
        throw new IllegalStateException(StringsKt.trimMargin$default((String)("\n      |expected 0 open files, but found:\n      |    " + CollectionsKt.joinToString$default((Iterable)this.openFiles, (CharSequence)"\n    ", null, null, (int)0, null, FakeFileSystem::checkNoOpenFiles$lambda$4, (int)30, null) + "\n      "), null, (int)1, null), firstOpenFile.getBacktrace());
    }

    public final void emulateWindows() {
        if (!StringsKt.contains$default((CharSequence)this.workingDirectory.toString(), (CharSequence)"\\", (boolean)false, (int)2, null)) {
            this.setWorkingDirectory(Path.Companion.get$default((Path.Companion)Path.Companion, (String)"F:\\", (boolean)false, (int)1, null));
        }
        this.allowMovingOpenFiles = false;
        this.allowDeletingOpenFiles = false;
        this.allowClobberingEmptyDirectories = true;
        this.allowWritesWhileWriting = true;
        this.allowReadsWhileWriting = true;
    }

    public final void emulateUnix() {
        if (!StringsKt.contains$default((CharSequence)this.workingDirectory.toString(), (CharSequence)"/", (boolean)false, (int)2, null)) {
            this.setWorkingDirectory(Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/", (boolean)false, (int)1, null));
        }
        this.allowMovingOpenFiles = true;
        this.allowDeletingOpenFiles = true;
        this.allowClobberingEmptyDirectories = false;
        this.allowWritesWhileWriting = true;
        this.allowReadsWhileWriting = true;
        this.allowSymlinks = true;
    }

    @NotNull
    public Path canonicalize(@NotNull Path path) {
        PathLookupResult lookupResult;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.canonicalizeInternal(path);
        PathLookupResult pathLookupResult = lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, false, 14, null);
        if ((pathLookupResult != null ? pathLookupResult.getElement() : null) == null) {
            throw new FileNotFoundException("no such file: " + path);
        }
        return lookupResult.getPath();
    }

    private final Path canonicalizeInternal(Path path) {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        return this.workingDirectory.resolve(path, true);
    }

    public final <T> void setExtra(@NotNull Path path, @NotNull KClass<? extends T> type, @Nullable T value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Path canonicalPath = this.canonicalizeInternal(path);
        boolean bl = canonicalPath.isRoot();
        PathLookupResult lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, bl, 2, null);
        Object object = lookupResult;
        if (object == null || (object = ((PathLookupResult)object).getElement()) == null) {
            throw new FileNotFoundException("no such file: " + path);
        }
        Object element = object;
        if (value == null) {
            ((Element)element).getExtras().remove(type);
        } else {
            ((Element)element).getExtras().put(type, value);
        }
    }

    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.canonicalizeInternal(path);
        boolean bl = canonicalPath.isRoot();
        PathLookupResult lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, bl, 2, null);
        Object object = lookupResult;
        return object != null && (object = ((PathLookupResult)object).getElement()) != null ? ((Element)object).getMetadata() : null;
    }

    @NotNull
    public List<Path> list(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        List<Path> list = this.list(dir, true);
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Nullable
    public List<Path> listOrNull(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.list(dir, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> list(Path dir, boolean throwOnFailure) {
        void $this$mapTo$iv$iv;
        PathLookupResult lookupResult;
        Path canonicalPath = this.canonicalizeInternal(dir);
        PathLookupResult pathLookupResult = lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, false, 14, null);
        if ((pathLookupResult != null ? pathLookupResult.getElement() : null) == null) {
            if (throwOnFailure) {
                throw new FileNotFoundException("no such directory: " + dir);
            }
            return null;
        }
        Element element = lookupResult.getElement();
        Element.Directory directory = element instanceof Element.Directory ? (Element.Directory)element : null;
        if (directory == null) {
            if (throwOnFailure) {
                throw new IOException("not a directory: " + dir);
            }
            return null;
        }
        Element.Directory element2 = directory;
        Element.access$default(element2, ((Number)this.clockNowMillis.invoke()).longValue(), false, 2, null);
        Iterable $this$map$iv = element2.getChildren().keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ByteString byteString = (ByteString)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(dir.resolve((ByteString)it));
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Source source(@NotNull Path file) {
        Source source;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileHandle fileHandle = this.openReadOnly(file);
        Source it = source = FileHandle.source$default((FileHandle)fileHandle, (long)0L, (int)1, null);
        boolean bl = false;
        fileHandle.close();
        return source;
    }

    @NotNull
    public Sink sink(@NotNull Path file, boolean mustCreate) {
        Sink sink;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileHandle fileHandle = FakeFileSystem.open$default(this, file, true, mustCreate, false, 8, null);
        fileHandle.resize(0L);
        Sink it = sink = FileHandle.sink$default((FileHandle)fileHandle, (long)0L, (int)1, null);
        boolean bl = false;
        fileHandle.close();
        return sink;
    }

    @NotNull
    public Sink appendingSink(@NotNull Path file, boolean mustExist) {
        Sink sink;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileHandle fileHandle = FakeFileSystem.open$default(this, file, true, false, mustExist, 4, null);
        Sink it = sink = fileHandle.appendingSink();
        boolean bl = false;
        fileHandle.close();
        return sink;
    }

    @NotNull
    public FileHandle openReadOnly(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FakeFileSystem.open$default(this, file, false, false, false, 12, null);
    }

    @NotNull
    public FileHandle openReadWrite(@NotNull Path file, boolean mustCreate, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.open(file, true, mustCreate, mustExist);
    }

    private final FileHandle open(Path file, boolean readWrite, boolean mustCreate, boolean mustExist) {
        if (!(!mustCreate || !mustExist)) {
            boolean $i$a$-require-FakeFileSystem$open$22 = false;
            String $i$a$-require-FakeFileSystem$open$22 = "Cannot require mustCreate and mustExist at the same time.";
            throw new IllegalArgumentException($i$a$-require-FakeFileSystem$open$22.toString());
        }
        Path canonicalPath = this.canonicalizeInternal(file);
        PathLookupResult lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, readWrite, 6, null);
        long nowMillis = ((Number)this.clockNowMillis.invoke()).longValue();
        Element.File element = null;
        Operation operation = null;
        PathLookupResult pathLookupResult = lookupResult;
        if ((pathLookupResult != null ? pathLookupResult.getElement() : null) == null && mustExist) {
            throw new IOException(file + " doesn't exist.");
        }
        PathLookupResult pathLookupResult2 = lookupResult;
        if ((pathLookupResult2 != null ? pathLookupResult2.getElement() : null) != null && mustCreate) {
            throw new IOException(file + " already exists.");
        }
        if (readWrite) {
            Element existing;
            OpenFile openFile;
            PathLookupResult pathLookupResult3 = lookupResult;
            if ((pathLookupResult3 != null ? pathLookupResult3.getElement() : null) instanceof Element.Directory) {
                throw new IOException("destination is a directory: " + file);
            }
            if (!this.allowWritesWhileWriting && (openFile = this.findOpenFile(canonicalPath, Operation.WRITE)) != null) {
                OpenFile it = openFile;
                boolean bl = false;
                throw new IOException("file is already open for writing " + file, it.getBacktrace());
            }
            if (!this.allowReadsWhileWriting && (openFile = this.findOpenFile(canonicalPath, Operation.READ)) != null) {
                OpenFile it = openFile;
                boolean bl = false;
                throw new IOException("file is already open for reading " + file, it.getBacktrace());
            }
            Object object = lookupResult;
            if (object == null || (object = ((PathLookupResult)object).getParent()) == null) {
                throw new FileNotFoundException("parent directory does not exist");
            }
            Object parent = object;
            ((Element)parent).access(nowMillis, true);
            Element element2 = existing = lookupResult.getElement();
            element = new Element.File(element2 != null ? element2.getCreatedAtMillis() : nowMillis);
            Map<ByteString, Element> map = ((Element.Directory)parent).getChildren();
            ByteString byteString = lookupResult.getSegment();
            Intrinsics.checkNotNull((Object)byteString);
            map.put(byteString, element);
            operation = Operation.WRITE;
            if (existing instanceof Element.File) {
                element.setData(((Element.File)existing).getData());
            }
        } else {
            OpenFile openFile;
            Object object = lookupResult;
            if (object == null || (object = ((PathLookupResult)object).getElement()) == null) {
                throw new FileNotFoundException("no such file: " + file);
            }
            Object existing = object;
            Element.File file2 = existing instanceof Element.File ? (Element.File)existing : null;
            if (file2 == null) {
                throw new IOException("not a file: " + file);
            }
            element = file2;
            operation = Operation.READ;
            if (!this.allowReadsWhileWriting && (openFile = this.findOpenFile(canonicalPath, Operation.WRITE)) != null) {
                OpenFile it = openFile;
                boolean bl = false;
                throw new IOException("file is already open for writing " + file, it.getBacktrace());
            }
        }
        element.access(((Number)this.clockNowMillis.invoke()).longValue(), readWrite);
        OpenFile openFile = new OpenFile(canonicalPath, operation, new Exception("file opened for " + (Object)((Object)operation) + " here"));
        ((Collection)this.openFiles).add(openFile);
        return new FakeFileHandle(readWrite, openFile, element);
    }

    static /* synthetic */ FileHandle open$default(FakeFileSystem fakeFileSystem, Path path, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return fakeFileSystem.open(path, bl, bl2, bl3);
    }

    public void createDirectory(@NotNull Path dir, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Path canonicalPath = this.canonicalizeInternal(dir);
        PathLookupResult lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, true, 6, null);
        if (canonicalPath.isRoot()) {
            return;
        }
        if (mustCreate) {
            PathLookupResult pathLookupResult = lookupResult;
            if ((pathLookupResult != null ? pathLookupResult.getElement() : null) != null) {
                throw new IOException("already exists: " + dir);
            }
        }
        Element.Directory parentDirectory = this.requireParent(lookupResult);
        parentDirectory.getChildren().put(canonicalPath.nameBytes(), new Element.Directory(((Number)this.clockNowMillis.invoke()).longValue()));
    }

    public void atomicMove(@NotNull Path source, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path canonicalSource = this.canonicalizeInternal(source);
        Path canonicalTarget = this.canonicalizeInternal(target);
        PathLookupResult targetLookupResult = FakeFileSystem.lookupPath$default(this, canonicalTarget, 0, false, true, 6, null);
        PathLookupResult sourceLookupResult = FakeFileSystem.lookupPath$default(this, canonicalSource, 0, false, false, 10, null);
        PathLookupResult pathLookupResult = targetLookupResult;
        if ((pathLookupResult != null ? pathLookupResult.getElement() : null) instanceof Element.Directory) {
            throw new IOException("target is a directory: " + target);
        }
        Element.Directory targetParent = this.requireParent(targetLookupResult);
        if (!this.allowMovingOpenFiles) {
            OpenFile openFile = FakeFileSystem.findOpenFile$default(this, canonicalSource, null, 2, null);
            if (openFile != null) {
                OpenFile it = openFile;
                boolean bl = false;
                throw new IOException("source is open " + source, it.getBacktrace());
            }
            openFile = FakeFileSystem.findOpenFile$default(this, canonicalTarget, null, 2, null);
            if (openFile != null) {
                OpenFile it = openFile;
                boolean bl = false;
                throw new IOException("target is open " + target, it.getBacktrace());
            }
        }
        if (!this.allowClobberingEmptyDirectories) {
            PathLookupResult pathLookupResult2 = sourceLookupResult;
            if ((pathLookupResult2 != null ? pathLookupResult2.getElement() : null) instanceof Element.Directory) {
                PathLookupResult pathLookupResult3 = targetLookupResult;
                if ((pathLookupResult3 != null ? pathLookupResult3.getElement() : null) instanceof Element.File) {
                    throw new IOException("source is a directory and target is a file");
                }
            }
        }
        Element.Directory sourceParent = this.requireParent(sourceLookupResult);
        Element element = sourceParent.getChildren().remove(canonicalSource.nameBytes());
        if (element == null) {
            throw new FileNotFoundException("source doesn't exist: " + source);
        }
        Element removed = element;
        targetParent.getChildren().put(canonicalTarget.nameBytes(), removed);
    }

    public void delete(@NotNull Path path, boolean mustExist) {
        OpenFile openFile;
        PathLookupResult lookupResult;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.canonicalizeInternal(path);
        PathLookupResult pathLookupResult = lookupResult = FakeFileSystem.lookupPath$default(this, canonicalPath, 0, false, true, 2, null);
        if ((pathLookupResult != null ? pathLookupResult.getElement() : null) == null) {
            if (mustExist) {
                throw new FileNotFoundException("no such file: " + path);
            }
            return;
        }
        if (lookupResult.getElement() instanceof Element.Directory && !((Element.Directory)lookupResult.getElement()).getChildren().isEmpty()) {
            throw new IOException("non-empty directory");
        }
        if (!this.allowDeletingOpenFiles && (openFile = FakeFileSystem.findOpenFile$default(this, canonicalPath, null, 2, null)) != null) {
            OpenFile it = openFile;
            boolean bl = false;
            throw new IOException("file is open " + path, it.getBacktrace());
        }
        Element.Directory directory = this.requireParent(lookupResult);
        directory.getChildren().remove(canonicalPath.nameBytes());
    }

    public void createSymlink(@NotNull Path source, @NotNull Path target) {
        PathLookupResult existingLookupResult;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path canonicalSource = this.canonicalizeInternal(source);
        PathLookupResult pathLookupResult = existingLookupResult = FakeFileSystem.lookupPath$default(this, canonicalSource, 0, false, true, 6, null);
        if ((pathLookupResult != null ? pathLookupResult.getElement() : null) != null) {
            throw new IOException("already exists: " + source);
        }
        Element.Directory parent = this.requireParent(existingLookupResult);
        if (!this.allowSymlinks) {
            throw new IOException("symlinks are not supported");
        }
        parent.getChildren().put(canonicalSource.nameBytes(), new Element.Symlink(((Number)this.clockNowMillis.invoke()).longValue(), target));
    }

    private final PathLookupResult lookupPath(Path canonicalPath, int recurseCount, boolean resolveLastSymlink, boolean createRootOnDemand) {
        int n;
        if (recurseCount > 40) {
            throw new IOException("symlink cycle?");
        }
        Path path = canonicalPath.getRoot();
        Intrinsics.checkNotNull((Object)path);
        Path rootPath = path;
        Element.Directory root = this.roots.get(rootPath);
        if (root == null) {
            if (!createRootOnDemand) {
                return null;
            }
            root = new Element.Directory(((Number)this.clockNowMillis.invoke()).longValue());
            this.roots.put(rootPath, root);
        }
        Element.Directory parent = null;
        ByteString lastSegment = null;
        Element current = root;
        Path currentPath = rootPath;
        int segmentsTraversed = 0;
        List segments = canonicalPath.getSegmentsBytes();
        Iterator iterator = segments.iterator();
        while (iterator.hasNext()) {
            PathLookupResult symlinkLookupResult;
            boolean followSymlinks;
            ByteString segment;
            lastSegment = segment = (ByteString)iterator.next();
            if (!(current instanceof Element.Directory)) {
                throw new IOException("not a directory: " + currentPath);
            }
            parent = (Element.Directory)current;
            if (((Element.Directory)current).getChildren().get(segment) == null) break;
            currentPath = currentPath.resolve(segment);
            boolean isLastSegment = ++segmentsTraversed == segments.size();
            boolean bl = followSymlinks = !isLastSegment || resolveLastSymlink;
            if (!(current instanceof Element.Symlink) || !followSymlinks) continue;
            Element.access$default(current, ((Number)this.clockNowMillis.invoke()).longValue(), false, 2, null);
            Path path2 = currentPath.parent();
            Intrinsics.checkNotNull((Object)path2);
            currentPath = path2.resolve(((Element.Symlink)current).getTarget(), true);
            if (FakeFileSystem.lookupPath$default(this, currentPath, recurseCount + 1, false, createRootOnDemand, 4, null) == null) break;
            parent = symlinkLookupResult.getParent();
            lastSegment = symlinkLookupResult.getSegment();
            Element element = symlinkLookupResult.getElement();
            if (element == null) break;
            current = element;
            currentPath = symlinkLookupResult.getPath();
        }
        return (n = segmentsTraversed) == segments.size() ? new PathLookupResult(currentPath, parent, lastSegment, current) : (n == segments.size() - 1 ? new PathLookupResult(currentPath, parent, lastSegment, null) : null);
    }

    static /* synthetic */ PathLookupResult lookupPath$default(FakeFileSystem fakeFileSystem, Path path, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return fakeFileSystem.lookupPath(path, n, bl, bl2);
    }

    private final Element.Directory requireParent(PathLookupResult $this$requireParent) {
        Object object = $this$requireParent;
        if (object == null || (object = ((PathLookupResult)object).getParent()) == null) {
            throw new IOException("parent directory does not exist");
        }
        return object;
    }

    private final OpenFile findOpenFile(Path canonicalPath, Operation operation) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.openFiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OpenFile it = (OpenFile)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getCanonicalPath(), (Object)canonicalPath) && (operation == null || operation == it.getOperation()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    static /* synthetic */ OpenFile findOpenFile$default(FakeFileSystem fakeFileSystem, Path path, Operation operation, int n, Object object) {
        if ((n & 2) != 0) {
            operation = null;
        }
        return fakeFileSystem.findOpenFile(path, operation);
    }

    private final void checkOffsetAndCount(long size, long offset, long byteCount) {
        if ((offset | byteCount) < 0L || offset > size || size - offset < byteCount) {
            throw new ArrayIndexOutOfBoundsException("size=" + size + " offset=" + offset + " byteCount=" + byteCount);
        }
    }

    public void close() {
        this.closed = true;
    }

    @NotNull
    public String toString() {
        return "FakeFileSystem";
    }

    private static final long _init_$lambda$0(Clock $clock) {
        return $clock.now().toEpochMilliseconds();
    }

    private static final long _init_$lambda$1(kotlinx.datetime.Clock $clock) {
        return $clock.now().toEpochMilliseconds();
    }

    private static final CharSequence checkNoOpenFiles$lambda$4(OpenFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCanonicalPath().toString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\b\b\u0002\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\u0005R!\u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u0082\u0001\u0003\u001f !\u00a8\u0006\""}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element;", "", "createdAtMillis", "", "<init>", "(J)V", "getCreatedAtMillis", "()J", "lastModifiedAtMillis", "getLastModifiedAtMillis", "setLastModifiedAtMillis", "lastAccessedAtMillis", "getLastAccessedAtMillis", "setLastAccessedAtMillis", "extras", "", "Lkotlin/reflect/KClass;", "getExtras", "()Ljava/util/Map;", "access", "", "nowMillis", "modified", "", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "File", "Directory", "Symlink", "Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "Lokio/fakefilesystem/FakeFileSystem$Element$File;", "Lokio/fakefilesystem/FakeFileSystem$Element$Symlink;", "okio-fakefilesystem"})
    private static abstract class Element {
        private final long createdAtMillis;
        private long lastModifiedAtMillis;
        private long lastAccessedAtMillis;
        @NotNull
        private final Map<KClass<?>, Object> extras;

        private Element(long createdAtMillis) {
            this.lastModifiedAtMillis = this.createdAtMillis = createdAtMillis;
            this.lastAccessedAtMillis = this.createdAtMillis;
            this.extras = new LinkedHashMap();
        }

        public final long getCreatedAtMillis() {
            return this.createdAtMillis;
        }

        public final long getLastModifiedAtMillis() {
            return this.lastModifiedAtMillis;
        }

        public final void setLastModifiedAtMillis(long l) {
            this.lastModifiedAtMillis = l;
        }

        public final long getLastAccessedAtMillis() {
            return this.lastAccessedAtMillis;
        }

        public final void setLastAccessedAtMillis(long l) {
            this.lastAccessedAtMillis = l;
        }

        @NotNull
        public final Map<KClass<?>, Object> getExtras() {
            return this.extras;
        }

        public final void access(long nowMillis, boolean modified) {
            this.lastAccessedAtMillis = nowMillis;
            if (modified) {
                this.lastModifiedAtMillis = nowMillis;
            }
        }

        public static /* synthetic */ void access$default(Element element, long l, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: access");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            element.access(l, bl);
        }

        @NotNull
        public abstract FileMetadata getMetadata();

        public /* synthetic */ Element(long createdAtMillis, DefaultConstructorMarker $constructor_marker) {
            this(createdAtMillis);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "Lokio/fakefilesystem/FakeFileSystem$Element;", "createdAtMillis", "", "<init>", "(J)V", "children", "", "Lokio/ByteString;", "getChildren", "()Ljava/util/Map;", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "okio-fakefilesystem"})
        public static final class Directory
        extends Element {
            @NotNull
            private final Map<ByteString, Element> children = new LinkedHashMap();

            public Directory(long createdAtMillis) {
                super(createdAtMillis, null);
            }

            @NotNull
            public final Map<ByteString, Element> getChildren() {
                return this.children;
            }

            @Override
            @NotNull
            public FileMetadata getMetadata() {
                return new FileMetadata(false, true, null, null, Long.valueOf(this.getCreatedAtMillis()), Long.valueOf(this.getLastModifiedAtMillis()), Long.valueOf(this.getLastAccessedAtMillis()), this.getExtras(), 13, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element$File;", "Lokio/fakefilesystem/FakeFileSystem$Element;", "createdAtMillis", "", "<init>", "(J)V", "data", "Lokio/ByteString;", "getData", "()Lokio/ByteString;", "setData", "(Lokio/ByteString;)V", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "okio-fakefilesystem"})
        public static final class File
        extends Element {
            @NotNull
            private ByteString data = ByteString.EMPTY;

            public File(long createdAtMillis) {
                super(createdAtMillis, null);
            }

            @NotNull
            public final ByteString getData() {
                return this.data;
            }

            public final void setData(@NotNull ByteString byteString) {
                Intrinsics.checkNotNullParameter((Object)byteString, (String)"<set-?>");
                this.data = byteString;
            }

            @Override
            @NotNull
            public FileMetadata getMetadata() {
                return new FileMetadata(true, false, null, Long.valueOf(this.data.size()), Long.valueOf(this.getCreatedAtMillis()), Long.valueOf(this.getLastModifiedAtMillis()), Long.valueOf(this.getLastAccessedAtMillis()), this.getExtras(), 6, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element$Symlink;", "Lokio/fakefilesystem/FakeFileSystem$Element;", "createdAtMillis", "", "target", "Lokio/Path;", "<init>", "(JLokio/Path;)V", "getTarget", "()Lokio/Path;", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "okio-fakefilesystem"})
        public static final class Symlink
        extends Element {
            @NotNull
            private final Path target;

            public Symlink(long createdAtMillis, @NotNull Path target) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super(createdAtMillis, null);
                this.target = target;
            }

            @NotNull
            public final Path getTarget() {
                return this.target;
            }

            @Override
            @NotNull
            public FileMetadata getMetadata() {
                return new FileMetadata(false, false, this.target, null, Long.valueOf(this.getCreatedAtMillis()), Long.valueOf(this.getLastModifiedAtMillis()), Long.valueOf(this.getLastAccessedAtMillis()), this.getExtras(), 11, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000eH\u0014J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0014J(\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0014J\b\u0010\u0018\u001a\u00020\fH\u0014J\b\u0010\u0019\u001a\u00020\fH\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lokio/fakefilesystem/FakeFileSystem$FakeFileHandle;", "Lokio/FileHandle;", "readWrite", "", "openFile", "Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "file", "Lokio/fakefilesystem/FakeFileSystem$Element$File;", "<init>", "(Lokio/fakefilesystem/FakeFileSystem;ZLokio/fakefilesystem/FakeFileSystem$OpenFile;Lokio/fakefilesystem/FakeFileSystem$Element$File;)V", "closed", "protectedResize", "", "size", "", "protectedSize", "protectedRead", "", "fileOffset", "array", "", "arrayOffset", "byteCount", "protectedWrite", "protectedFlush", "protectedClose", "toString", "", "okio-fakefilesystem"})
    @SourceDebugExtension(value={"SMAP\nFakeFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeFileSystem.kt\nokio/fakefilesystem/FakeFileSystem$FakeFileHandle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,808:1\n1#2:809\n*E\n"})
    private final class FakeFileHandle
    extends FileHandle {
        @NotNull
        private final OpenFile openFile;
        @NotNull
        private final Element.File file;
        private boolean closed;

        public FakeFileHandle(@NotNull boolean readWrite, @NotNull OpenFile openFile, Element.File file) {
            Intrinsics.checkNotNullParameter((Object)openFile, (String)"openFile");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(readWrite);
            this.openFile = openFile;
            this.file = file;
        }

        protected void protectedResize(long size) {
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            long delta = size - (long)this.file.getData().size();
            if (delta > 0L) {
                this.file.setData(new Buffer().write(this.file.getData()).write(new byte[(int)delta]).readByteString());
            } else {
                this.file.setData(this.file.getData().substring(0, (int)size));
            }
            this.file.access(((Number)FakeFileSystem.this.clockNowMillis.invoke()).longValue(), true);
        }

        protected long protectedSize() {
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            return this.file.getData().size();
        }

        protected int protectedRead(long fileOffset, @NotNull byte[] array, int arrayOffset, int byteCount) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (!(!this.closed)) {
                boolean $i$a$-check-FakeFileSystem$FakeFileHandle$protectedRead$22 = false;
                String $i$a$-check-FakeFileSystem$FakeFileHandle$protectedRead$22 = "closed";
                throw new IllegalStateException($i$a$-check-FakeFileSystem$FakeFileHandle$protectedRead$22.toString());
            }
            FakeFileSystem.this.checkOffsetAndCount(array.length, arrayOffset, byteCount);
            int fileOffsetInt = (int)fileOffset;
            int toCopy = Math.min(this.file.getData().size() - fileOffsetInt, byteCount);
            if (toCopy <= 0) {
                return -1;
            }
            this.file.getData().copyInto(fileOffsetInt, array, arrayOffset, toCopy);
            return toCopy;
        }

        protected void protectedWrite(long fileOffset, @NotNull byte[] array, int arrayOffset, int byteCount) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            FakeFileSystem.this.checkOffsetAndCount(array.length, arrayOffset, byteCount);
            Buffer buffer = new Buffer();
            buffer.write(this.file.getData(), 0, Math.min((int)fileOffset, this.file.getData().size()));
            while (buffer.size() < fileOffset) {
                buffer.writeByte(0);
            }
            buffer.write(array, arrayOffset, byteCount);
            if (buffer.size() < (long)this.file.getData().size()) {
                buffer.write(this.file.getData(), (int)buffer.size(), this.file.getData().size() - (int)buffer.size());
            }
            this.file.setData(buffer.snapshot());
            this.file.access(((Number)FakeFileSystem.this.clockNowMillis.invoke()).longValue(), true);
        }

        protected void protectedFlush() {
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
        }

        protected void protectedClose() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.file.access(((Number)FakeFileSystem.this.clockNowMillis.invoke()).longValue(), this.getReadWrite());
            ((Collection)FakeFileSystem.this.openFiles).remove(this.openFile);
        }

        @NotNull
        public String toString() {
            return "FileHandler(" + this.openFile.getCanonicalPath() + ')';
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "", "canonicalPath", "Lokio/Path;", "operation", "Lokio/fakefilesystem/FakeFileSystem$Operation;", "backtrace", "", "<init>", "(Lokio/Path;Lokio/fakefilesystem/FakeFileSystem$Operation;Ljava/lang/Throwable;)V", "getCanonicalPath", "()Lokio/Path;", "getOperation", "()Lokio/fakefilesystem/FakeFileSystem$Operation;", "getBacktrace", "()Ljava/lang/Throwable;", "okio-fakefilesystem"})
    private static final class OpenFile {
        @NotNull
        private final Path canonicalPath;
        @NotNull
        private final Operation operation;
        @NotNull
        private final Throwable backtrace;

        public OpenFile(@NotNull Path canonicalPath, @NotNull Operation operation, @NotNull Throwable backtrace) {
            Intrinsics.checkNotNullParameter((Object)canonicalPath, (String)"canonicalPath");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            Intrinsics.checkNotNullParameter((Object)backtrace, (String)"backtrace");
            this.canonicalPath = canonicalPath;
            this.operation = operation;
            this.backtrace = backtrace;
        }

        @NotNull
        public final Path getCanonicalPath() {
            return this.canonicalPath;
        }

        @NotNull
        public final Operation getOperation() {
            return this.operation;
        }

        @NotNull
        public final Throwable getBacktrace() {
            return this.backtrace;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Operation;", "", "<init>", "(Ljava/lang/String;I)V", "READ", "WRITE", "okio-fakefilesystem"})
    private static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation READ = new Operation();
        public static final /* enum */ Operation WRITE = new Operation();
        private static final /* synthetic */ Operation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String value) {
            return Enum.valueOf(Operation.class, value);
        }

        @NotNull
        public static EnumEntries<Operation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operationArray = new Operation[]{Operation.READ, Operation.WRITE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lokio/fakefilesystem/FakeFileSystem$PathLookupResult;", "", "path", "Lokio/Path;", "parent", "Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "segment", "Lokio/ByteString;", "element", "Lokio/fakefilesystem/FakeFileSystem$Element;", "<init>", "(Lokio/Path;Lokio/fakefilesystem/FakeFileSystem$Element$Directory;Lokio/ByteString;Lokio/fakefilesystem/FakeFileSystem$Element;)V", "getPath", "()Lokio/Path;", "getParent", "()Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "getSegment", "()Lokio/ByteString;", "getElement", "()Lokio/fakefilesystem/FakeFileSystem$Element;", "okio-fakefilesystem"})
    private static final class PathLookupResult {
        @NotNull
        private final Path path;
        @Nullable
        private final Element.Directory parent;
        @Nullable
        private final ByteString segment;
        @Nullable
        private final Element element;

        public PathLookupResult(@NotNull Path path, @Nullable Element.Directory parent, @Nullable ByteString segment, @Nullable Element element) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
            this.parent = parent;
            this.segment = segment;
            this.element = element;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @Nullable
        public final Element.Directory getParent() {
            return this.parent;
        }

        @Nullable
        public final ByteString getSegment() {
            return this.segment;
        }

        @Nullable
        public final Element getElement() {
            return this.element;
        }
    }
}

