/*
 * Decompiled with CFR 0.152.
 */
package okio.fakefilesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import okio.Buffer;
import okio.ByteString;
import okio.ExperimentalFileSystem;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Path;
import okio.Sink;
import okio.Source;
import okio.fakefilesystem.-Time;
import okio.fakefilesystem.FakeFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0004PQRSB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0007H\u0016J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007H\u0016J\u0010\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0016J\u0006\u00103\u001a\u00020.J \u00104\u001a\u00020.2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u00108\u001a\u000206H\u0002J\u0010\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020\u0007H\u0016J\u0010\u0010;\u001a\u00020.2\u0006\u00102\u001a\u00020\u0007H\u0016J\u0006\u0010<\u001a\u00020.J\u0006\u0010=\u001a\u00020.J\u001e\u0010>\u001a\u0004\u0018\u00010 2\u0006\u0010?\u001a\u00020\u00072\n\b\u0002\u0010@\u001a\u0004\u0018\u00010AH\u0002J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00070\"2\u0006\u0010:\u001a\u00020\u0007H\u0016J\u0012\u0010C\u001a\u0004\u0018\u00010D2\u0006\u00102\u001a\u00020\u0007H\u0016J\u0018\u0010E\u001a\u00020F2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\nH\u0002J\u0010\u0010H\u001a\u00020F2\u0006\u0010,\u001a\u00020\u0007H\u0016J\u0010\u0010I\u001a\u00020F2\u0006\u0010,\u001a\u00020\u0007H\u0016J\u0012\u0010J\u001a\u00020K2\b\u00102\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010L\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0007H\u0016J\u0010\u0010/\u001a\u00020M2\u0006\u0010,\u001a\u00020\u0007H\u0016J\b\u0010N\u001a\u00020OH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\"8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R$\u0010%\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006T"}, d2={"Lokio/fakefilesystem/FakeFileSystem;", "Lokio/FileSystem;", "clock", "Lkotlinx/datetime/Clock;", "(Lkotlinx/datetime/Clock;)V", "allPaths", "", "Lokio/Path;", "()Ljava/util/Set;", "allowClobberingEmptyDirectories", "", "getAllowClobberingEmptyDirectories", "()Z", "setAllowClobberingEmptyDirectories", "(Z)V", "allowDeletingOpenFiles", "getAllowDeletingOpenFiles", "setAllowDeletingOpenFiles", "allowMovingOpenFiles", "getAllowMovingOpenFiles", "setAllowMovingOpenFiles", "allowReadsWhileWriting", "getAllowReadsWhileWriting", "setAllowReadsWhileWriting", "allowWritesWhileWriting", "getAllowWritesWhileWriting", "setAllowWritesWhileWriting", "elements", "", "Lokio/fakefilesystem/FakeFileSystem$Element;", "openFiles", "", "Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "openPaths", "", "()Ljava/util/List;", "value", "workingDirectory", "getWorkingDirectory", "()Lokio/Path;", "setWorkingDirectory", "(Lokio/Path;)V", "appendingSink", "Lokio/Sink;", "file", "atomicMove", "", "source", "target", "canonicalize", "path", "checkNoOpenFiles", "checkOffsetAndCount", "size", "", "offset", "byteCount", "createDirectory", "dir", "delete", "emulateUnix", "emulateWindows", "findOpenFile", "canonicalPath", "operation", "Lokio/fakefilesystem/FakeFileSystem$Operation;", "list", "metadataOrNull", "Lokio/FileMetadata;", "open", "Lokio/FileHandle;", "readWrite", "openReadOnly", "openReadWrite", "requireDirectory", "Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "sink", "Lokio/Source;", "toString", "", "Element", "FakeFileHandle", "OpenFile", "Operation", "okio-fakefilesystem"})
@ExperimentalFileSystem
public final class FakeFileSystem
extends FileSystem {
    @JvmField
    @NotNull
    public final Clock clock;
    @NotNull
    private final Map<Path, Element> elements;
    @NotNull
    private final List<OpenFile> openFiles;
    @NotNull
    private Path workingDirectory;
    private boolean allowMovingOpenFiles;
    private boolean allowDeletingOpenFiles;
    private boolean allowClobberingEmptyDirectories;
    private boolean allowWritesWhileWriting;
    private boolean allowReadsWhileWriting;

    public FakeFileSystem(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        boolean bl = false;
        this.elements = new LinkedHashMap();
        bl = false;
        this.openFiles = new ArrayList();
        this.workingDirectory = Path.Companion.get("/");
    }

    public /* synthetic */ FakeFileSystem(Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clock = (Clock)Clock.System.INSTANCE;
        }
        this(clock);
    }

    @NotNull
    public final Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull Path value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean bl = value.isAbsolute();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"expected an absolute path but was ", (Object)value);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.workingDirectory = value;
    }

    public final boolean getAllowMovingOpenFiles() {
        return this.allowMovingOpenFiles;
    }

    public final void setAllowMovingOpenFiles(boolean bl) {
        this.allowMovingOpenFiles = bl;
    }

    public final boolean getAllowDeletingOpenFiles() {
        return this.allowDeletingOpenFiles;
    }

    public final void setAllowDeletingOpenFiles(boolean bl) {
        this.allowDeletingOpenFiles = bl;
    }

    public final boolean getAllowClobberingEmptyDirectories() {
        return this.allowClobberingEmptyDirectories;
    }

    public final void setAllowClobberingEmptyDirectories(boolean bl) {
        this.allowClobberingEmptyDirectories = bl;
    }

    public final boolean getAllowWritesWhileWriting() {
        return this.allowWritesWhileWriting;
    }

    public final void setAllowWritesWhileWriting(boolean bl) {
        this.allowWritesWhileWriting = bl;
    }

    public final boolean getAllowReadsWhileWriting() {
        return this.allowReadsWhileWriting;
    }

    public final void setAllowReadsWhileWriting(boolean bl) {
        this.allowReadsWhileWriting = bl;
    }

    @JvmName(name="allPaths")
    @NotNull
    public final Set<Path> allPaths() {
        boolean bl = false;
        List result = new ArrayList();
        for (Path path : this.elements.keySet()) {
            if (path.isRoot()) continue;
            Collection collection = result;
            boolean bl2 = false;
            collection.add(path);
        }
        CollectionsKt.sort((List)result);
        return CollectionsKt.toSet((Iterable)result);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="openPaths")
    @NotNull
    public final List<Path> openPaths() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.openFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OpenFile openFile = (OpenFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = it.getCanonicalPath();
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    public final void checkNoOpenFiles() {
        OpenFile openFile = (OpenFile)CollectionsKt.firstOrNull(this.openFiles);
        if (openFile == null) {
            return;
        }
        OpenFile firstOpenFile = openFile;
        throw new IllegalStateException(StringsKt.trimMargin$default((String)("\n      |expected 0 open files, but found:\n      |    " + CollectionsKt.joinToString$default((Iterable)this.openFiles, (CharSequence)"\n    ", null, null, (int)0, null, (Function1)checkNoOpenFiles.1.INSTANCE, (int)30, null) + "\n      "), null, (int)1, null), firstOpenFile.getBacktrace());
    }

    public final void emulateWindows() {
        if (!StringsKt.contains$default((CharSequence)this.workingDirectory.toString(), (CharSequence)"\\", (boolean)false, (int)2, null)) {
            this.setWorkingDirectory(Path.Companion.get("F:\\"));
        }
        this.allowMovingOpenFiles = false;
        this.allowDeletingOpenFiles = false;
        this.allowClobberingEmptyDirectories = true;
        this.allowWritesWhileWriting = true;
        this.allowReadsWhileWriting = true;
    }

    public final void emulateUnix() {
        if (!StringsKt.contains$default((CharSequence)this.workingDirectory.toString(), (CharSequence)"/", (boolean)false, (int)2, null)) {
            this.setWorkingDirectory(Path.Companion.get("/"));
        }
        this.allowMovingOpenFiles = true;
        this.allowDeletingOpenFiles = true;
        this.allowClobberingEmptyDirectories = false;
        this.allowWritesWhileWriting = true;
        this.allowReadsWhileWriting = true;
    }

    @NotNull
    public Path canonicalize(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.workingDirectory.resolve(path);
        Map<Path, Element> map = this.elements;
        boolean bl = false;
        Map<Path, Element> map2 = map;
        boolean bl2 = false;
        if (!map2.containsKey(canonicalPath)) {
            throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such file: ", (Object)path));
        }
        return canonicalPath;
    }

    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.workingDirectory.resolve(path);
        Element element = this.elements.get(canonicalPath);
        if (element == null && canonicalPath.isRoot()) {
            element = new Element.Directory(this.clock.now());
            object = this.elements;
            boolean bl = false;
            object.put(canonicalPath, element);
        }
        return (object = element) == null ? null : ((Element)object).getMetadata();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Path> list(@NotNull Path dir) {
        int n;
        int n2;
        void destination$iv;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Path canonicalPath = this.workingDirectory.resolve(dir);
        Element.Directory element = this.requireDirectory(canonicalPath);
        Element.access$default(element, this.clock.now(), false, 2, null);
        Iterable iterable = this.elements.keySet();
        boolean bl = false;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            Path it = (Path)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it.parent(), (Object)canonicalPath)) continue;
            destination$iv.add(element$iv);
        }
        List paths = (List)destination$iv;
        if (dir.isRelative() && (n2 = 0) <= (n = paths.size() + -1)) {
            do {
                int i = n2++;
                paths.set(i, dir.resolve(((Path)paths.get(i)).name()));
            } while (n2 <= n);
        }
        CollectionsKt.sort((List)paths);
        return paths;
    }

    @NotNull
    public Source source(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileHandle fileHandle = this.openReadOnly(file);
        Source source = FileHandle.source$default((FileHandle)fileHandle, (long)0L, (int)1, null);
        boolean bl = false;
        boolean bl2 = false;
        Source it = source;
        boolean bl3 = false;
        fileHandle.close();
        return source;
    }

    @NotNull
    public Sink sink(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileHandle fileHandle = this.open(file, true);
        fileHandle.resize(0L);
        Sink sink = FileHandle.sink$default((FileHandle)fileHandle, (long)0L, (int)1, null);
        boolean bl = false;
        boolean bl2 = false;
        Sink it = sink;
        boolean bl3 = false;
        fileHandle.close();
        return sink;
    }

    @NotNull
    public Sink appendingSink(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileHandle fileHandle = this.open(file, true);
        Sink sink = fileHandle.appendingSink();
        boolean bl = false;
        boolean bl2 = false;
        Sink it = sink;
        boolean bl3 = false;
        fileHandle.close();
        return sink;
    }

    @NotNull
    public FileHandle openReadOnly(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.open(file, false);
    }

    @NotNull
    public FileHandle openReadWrite(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.open(file, true);
    }

    private final FileHandle open(Path file, boolean readWrite) {
        Object object;
        Object parent;
        Path canonicalPath = this.workingDirectory.resolve(file);
        Element existing = this.elements.get(canonicalPath);
        Instant now = this.clock.now();
        Element.File element = null;
        Operation operation = null;
        if (readWrite) {
            OpenFile openFile;
            if (existing instanceof Element.Directory) {
                throw new IOException(Intrinsics.stringPlus((String)"destination is a directory: ", (Object)file));
            }
            if (!this.allowWritesWhileWriting && (openFile = this.findOpenFile(canonicalPath, Operation.WRITE)) != null) {
                OpenFile openFile2 = openFile;
                boolean bl = false;
                boolean bl2 = false;
                OpenFile it = openFile2;
                boolean bl3 = false;
                throw new IOException(Intrinsics.stringPlus((String)"file is already open for writing ", (Object)file), it.getBacktrace());
            }
            if (!this.allowReadsWhileWriting && (openFile = this.findOpenFile(canonicalPath, Operation.READ)) != null) {
                OpenFile openFile3 = openFile;
                boolean bl = false;
                boolean bl4 = false;
                OpenFile it = openFile3;
                boolean bl5 = false;
                throw new IOException(Intrinsics.stringPlus((String)"file is already open for reading ", (Object)file), it.getBacktrace());
            }
            parent = this.requireDirectory(canonicalPath.parent());
            ((Element)parent).access(now, true);
            object = existing;
            element = new Element.File(object == null ? now : ((Element)object).getCreatedAt());
            object = this.elements;
            boolean bl = false;
            object.put(canonicalPath, element);
            operation = Operation.WRITE;
            if (existing instanceof Element.File) {
                element.setData(((Element.File)existing).getData());
            }
        } else {
            if (existing == null) {
                throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such file: ", (Object)file));
            }
            Object object2 = parent = existing instanceof Element.File ? (Element.File)existing : null;
            if (parent == null) {
                throw new IOException(Intrinsics.stringPlus((String)"not a file: ", (Object)file));
            }
            element = parent;
            operation = Operation.READ;
            if (!this.allowReadsWhileWriting && (parent = this.findOpenFile(canonicalPath, Operation.WRITE)) != null) {
                Object object3 = parent;
                boolean bl = false;
                boolean bl6 = false;
                Object it = object3;
                boolean bl7 = false;
                throw new IOException(Intrinsics.stringPlus((String)"file is already open for writing ", (Object)file), ((OpenFile)it).getBacktrace());
            }
        }
        element.access(this.clock.now(), readWrite);
        OpenFile openFile = new OpenFile(canonicalPath, operation, new Exception("file opened for " + (Object)((Object)operation) + " here"));
        object = this;
        Collection collection = ((FakeFileSystem)((Object)object)).openFiles;
        boolean bl = false;
        collection.add(openFile);
        return new FakeFileHandle(readWrite, openFile, element);
    }

    public void createDirectory(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Path canonicalPath = this.workingDirectory.resolve(dir);
        if (this.elements.get(canonicalPath) != null) {
            throw new IOException(Intrinsics.stringPlus((String)"already exists: ", (Object)dir));
        }
        this.requireDirectory(canonicalPath.parent());
        Map<Path, Element> map = this.elements;
        Element.Directory directory = new Element.Directory(this.clock.now());
        boolean bl = false;
        map.put(canonicalPath, directory);
    }

    public void atomicMove(@NotNull Path source, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path canonicalSource = this.workingDirectory.resolve(source);
        Path canonicalTarget = this.workingDirectory.resolve(target);
        Element targetElement = this.elements.get(canonicalTarget);
        Element sourceElement = this.elements.get(canonicalSource);
        if (targetElement instanceof Element.Directory) {
            throw new IOException(Intrinsics.stringPlus((String)"target is a directory: ", (Object)target));
        }
        this.requireDirectory(canonicalTarget.parent());
        if (!this.allowMovingOpenFiles) {
            OpenFile openFile = FakeFileSystem.findOpenFile$default(this, canonicalSource, null, 2, null);
            if (openFile != null) {
                OpenFile openFile2 = openFile;
                boolean bl = false;
                boolean bl2 = false;
                OpenFile it = openFile2;
                boolean bl3 = false;
                throw new IOException(Intrinsics.stringPlus((String)"source is open ", (Object)source), it.getBacktrace());
            }
            openFile = FakeFileSystem.findOpenFile$default(this, canonicalTarget, null, 2, null);
            if (openFile != null) {
                OpenFile openFile3 = openFile;
                boolean bl = false;
                boolean bl4 = false;
                OpenFile it = openFile3;
                boolean bl5 = false;
                throw new IOException(Intrinsics.stringPlus((String)"target is open ", (Object)target), it.getBacktrace());
            }
        }
        if (!this.allowClobberingEmptyDirectories && sourceElement instanceof Element.Directory && targetElement instanceof Element.File) {
            throw new IOException("source is a directory and target is a file");
        }
        Object object = this.elements.remove(canonicalSource);
        if (object == null) {
            throw new FileNotFoundException(Intrinsics.stringPlus((String)"source doesn't exist: ", (Object)source));
        }
        Element removed = object;
        object = this.elements;
        boolean bl = false;
        object.put(canonicalTarget, removed);
    }

    public void delete(@NotNull Path path) {
        OpenFile openFile;
        Object it;
        boolean bl;
        Path canonicalPath;
        block6: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            canonicalPath = this.workingDirectory.resolve(path);
            Iterable $this$any$iv = this.elements.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Path)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.parent(), (Object)canonicalPath)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IOException("non-empty directory");
        }
        if (!this.allowDeletingOpenFiles && (openFile = FakeFileSystem.findOpenFile$default(this, canonicalPath, null, 2, null)) != null) {
            OpenFile openFile2 = openFile;
            boolean bl3 = false;
            boolean bl4 = false;
            it = openFile2;
            boolean bl5 = false;
            throw new IOException(Intrinsics.stringPlus((String)"file is open ", (Object)path), ((OpenFile)it).getBacktrace());
        }
        if (this.elements.remove(canonicalPath) == null) {
            throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such file: ", (Object)path));
        }
    }

    private final Element.Directory requireDirectory(Path path) {
        if (path == null) {
            throw new IOException("directory does not exist");
        }
        Element element = this.elements.get(path);
        if (element instanceof Element.Directory) {
            return (Element.Directory)element;
        }
        if (path.isRoot()) {
            Element.Directory root = new Element.Directory(this.clock.now());
            Map<Path, Element> map = this.elements;
            boolean bl = false;
            map.put(path, root);
            return root;
        }
        if (element == null) {
            throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such directory: ", (Object)path));
        }
        throw new IOException(Intrinsics.stringPlus((String)"not a directory: ", (Object)path));
    }

    private final OpenFile findOpenFile(Path canonicalPath, Operation operation) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.openFiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OpenFile it = (OpenFile)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getCanonicalPath(), (Object)canonicalPath) && (operation == null || operation == it.getOperation()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    static /* synthetic */ OpenFile findOpenFile$default(FakeFileSystem fakeFileSystem, Path path, Operation operation, int n, Object object) {
        if ((n & 2) != 0) {
            operation = null;
        }
        return fakeFileSystem.findOpenFile(path, operation);
    }

    private final void checkOffsetAndCount(long size, long offset, long byteCount) {
        if ((offset | byteCount) < 0L || offset > size || size - offset < byteCount) {
            throw new ArrayIndexOutOfBoundsException("size=" + size + " offset=" + offset + " byteCount=" + byteCount);
        }
    }

    @NotNull
    public String toString() {
        return "FakeFileSystem";
    }

    public FakeFileSystem() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\u0004R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0006\"\u0004\b\f\u0010\u0004R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element;", "", "createdAt", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)V", "getCreatedAt", "()Lkotlinx/datetime/Instant;", "lastAccessedAt", "getLastAccessedAt", "setLastAccessedAt", "lastModifiedAt", "getLastModifiedAt", "setLastModifiedAt", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "access", "", "now", "modified", "", "Directory", "File", "Lokio/fakefilesystem/FakeFileSystem$Element$File;", "Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "okio-fakefilesystem"})
    private static abstract class Element {
        @NotNull
        private final Instant createdAt;
        @NotNull
        private Instant lastModifiedAt;
        @NotNull
        private Instant lastAccessedAt;

        private Element(Instant createdAt) {
            this.lastModifiedAt = this.createdAt = createdAt;
            this.lastAccessedAt = this.createdAt;
        }

        @NotNull
        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastModifiedAt = instant;
        }

        @NotNull
        public final Instant getLastAccessedAt() {
            return this.lastAccessedAt;
        }

        public final void setLastAccessedAt(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastAccessedAt = instant;
        }

        public final void access(@NotNull Instant now, boolean modified) {
            Intrinsics.checkNotNullParameter((Object)now, (String)"now");
            this.lastAccessedAt = now;
            if (modified) {
                this.lastModifiedAt = now;
            }
        }

        public static /* synthetic */ void access$default(Element element, Instant instant, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: access");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            element.access(instant, bl);
        }

        @NotNull
        public abstract FileMetadata getMetadata();

        public /* synthetic */ Element(Instant createdAt, DefaultConstructorMarker $constructor_marker) {
            this(createdAt);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element$File;", "Lokio/fakefilesystem/FakeFileSystem$Element;", "createdAt", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)V", "data", "Lokio/ByteString;", "getData", "()Lokio/ByteString;", "setData", "(Lokio/ByteString;)V", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "okio-fakefilesystem"})
        public static final class File
        extends Element {
            @NotNull
            private ByteString data;

            public File(@NotNull Instant createdAt) {
                Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
                super(createdAt, null);
                this.data = ByteString.EMPTY;
            }

            @NotNull
            public final ByteString getData() {
                return this.data;
            }

            public final void setData(@NotNull ByteString byteString) {
                Intrinsics.checkNotNullParameter((Object)byteString, (String)"<set-?>");
                this.data = byteString;
            }

            @Override
            @NotNull
            public FileMetadata getMetadata() {
                return -Time.newFileMetadata$default(true, false, Long.valueOf(this.data.size()), this.getCreatedAt(), this.getLastModifiedAt(), this.getLastAccessedAt(), 2, null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Element$Directory;", "Lokio/fakefilesystem/FakeFileSystem$Element;", "createdAt", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)V", "metadata", "Lokio/FileMetadata;", "getMetadata", "()Lokio/FileMetadata;", "okio-fakefilesystem"})
        public static final class Directory
        extends Element {
            public Directory(@NotNull Instant createdAt) {
                Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
                super(createdAt, null);
            }

            @Override
            @NotNull
            public FileMetadata getMetadata() {
                return -Time.newFileMetadata$default(false, true, null, this.getCreatedAt(), this.getLastModifiedAt(), this.getLastAccessedAt(), 5, null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "", "canonicalPath", "Lokio/Path;", "operation", "Lokio/fakefilesystem/FakeFileSystem$Operation;", "backtrace", "", "(Lokio/Path;Lokio/fakefilesystem/FakeFileSystem$Operation;Ljava/lang/Throwable;)V", "getBacktrace", "()Ljava/lang/Throwable;", "getCanonicalPath", "()Lokio/Path;", "getOperation", "()Lokio/fakefilesystem/FakeFileSystem$Operation;", "okio-fakefilesystem"})
    private static final class OpenFile {
        @NotNull
        private final Path canonicalPath;
        @NotNull
        private final Operation operation;
        @NotNull
        private final Throwable backtrace;

        public OpenFile(@NotNull Path canonicalPath, @NotNull Operation operation, @NotNull Throwable backtrace) {
            Intrinsics.checkNotNullParameter((Object)canonicalPath, (String)"canonicalPath");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            Intrinsics.checkNotNullParameter((Object)backtrace, (String)"backtrace");
            this.canonicalPath = canonicalPath;
            this.operation = operation;
            this.backtrace = backtrace;
        }

        @NotNull
        public final Path getCanonicalPath() {
            return this.canonicalPath;
        }

        @NotNull
        public final Operation getOperation() {
            return this.operation;
        }

        @NotNull
        public final Throwable getBacktrace() {
            return this.backtrace;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lokio/fakefilesystem/FakeFileSystem$Operation;", "", "(Ljava/lang/String;I)V", "READ", "WRITE", "okio-fakefilesystem"})
    private static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation READ = new Operation();
        public static final /* enum */ Operation WRITE = new Operation();
        private static final /* synthetic */ Operation[] $VALUES;

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String value) {
            return Enum.valueOf(Operation.class, value);
        }

        static {
            $VALUES = operationArray = new Operation[]{Operation.READ, Operation.WRITE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0014J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0010H\u0014J\b\u0010\u0017\u001a\u00020\u0010H\u0014J(\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lokio/fakefilesystem/FakeFileSystem$FakeFileHandle;", "Lokio/FileHandle;", "readWrite", "", "openFile", "Lokio/fakefilesystem/FakeFileSystem$OpenFile;", "file", "Lokio/fakefilesystem/FakeFileSystem$Element$File;", "(Lokio/fakefilesystem/FakeFileSystem;ZLokio/fakefilesystem/FakeFileSystem$OpenFile;Lokio/fakefilesystem/FakeFileSystem$Element$File;)V", "closed", "protectedClose", "", "protectedFlush", "protectedRead", "", "fileOffset", "", "array", "", "arrayOffset", "byteCount", "protectedResize", "size", "protectedSize", "protectedWrite", "toString", "", "okio-fakefilesystem"})
    private final class FakeFileHandle
    extends FileHandle {
        @NotNull
        private final OpenFile openFile;
        @NotNull
        private final Element.File file;
        private boolean closed;

        public FakeFileHandle(@NotNull boolean readWrite, @NotNull OpenFile openFile, Element.File file) {
            Intrinsics.checkNotNullParameter((Object)((Object)FakeFileSystem.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)openFile, (String)"openFile");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(readWrite);
            this.openFile = openFile;
            this.file = file;
        }

        protected void protectedResize(long size) {
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            long delta = size - (long)this.file.getData().size();
            if (delta > 0L) {
                this.file.setData(new Buffer().write(this.file.getData()).write(new byte[(int)delta]).readByteString());
            } else {
                this.file.setData(this.file.getData().substring(0, (int)size));
            }
            this.file.access(FakeFileSystem.this.clock.now(), true);
        }

        protected long protectedSize() {
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return this.file.getData().size();
        }

        protected int protectedRead(long fileOffset, @NotNull byte[] array, int arrayOffset, int byteCount) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            boolean bl = !this.closed;
            boolean bl2 = false;
            int n = 0;
            if (!bl) {
                boolean bl3 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            FakeFileSystem.this.checkOffsetAndCount(array.length, arrayOffset, byteCount);
            int fileOffsetInt = (int)fileOffset;
            n = this.file.getData().size() - fileOffsetInt;
            boolean bl3 = false;
            int toCopy = Math.min(n, byteCount);
            if (toCopy <= 0) {
                return -1;
            }
            n = 0;
            if (n < toCopy) {
                do {
                    int i = n++;
                    array[i + arrayOffset] = this.file.getData().getByte(i + fileOffsetInt);
                } while (n < toCopy);
            }
            return toCopy;
        }

        protected void protectedWrite(long fileOffset, @NotNull byte[] array, int arrayOffset, int byteCount) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            boolean bl = !this.closed;
            int n = 0;
            int n2 = 0;
            if (!bl) {
                boolean bl2 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            FakeFileSystem.this.checkOffsetAndCount(array.length, arrayOffset, byteCount);
            Buffer buffer = new Buffer();
            n = (int)fileOffset;
            n2 = this.file.getData().size();
            boolean bl3 = false;
            buffer.write(this.file.getData(), 0, Math.min(n, n2));
            while (buffer.size() < fileOffset) {
                buffer.writeByte(0);
            }
            buffer.write(array, arrayOffset, byteCount);
            if (buffer.size() < (long)this.file.getData().size()) {
                buffer.write(this.file.getData(), (int)buffer.size(), this.file.getData().size() - (int)buffer.size());
            }
            this.file.setData(buffer.snapshot());
            this.file.access(FakeFileSystem.this.clock.now(), true);
        }

        protected void protectedFlush() {
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        protected void protectedClose() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.file.access(FakeFileSystem.this.clock.now(), this.getReadWrite());
            FakeFileSystem fakeFileSystem = FakeFileSystem.this;
            Collection collection = fakeFileSystem.openFiles;
            OpenFile openFile = this.openFile;
            boolean bl = false;
            collection.remove(openFile);
        }

        @NotNull
        public String toString() {
            return "FileHandler(" + this.openFile.getCanonicalPath() + ')';
        }
    }
}

