//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[readLong](read-long.md)

# readLong

[common]\
abstract fun [readLong](read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)

Removes eight bytes from this source and returns a big-endian long.

Buffer buffer = new Buffer()\
    .writeByte(0x7f)\
    .writeByte(0xff)\
    .writeByte(0xff)\
    .writeByte(0xff)\
    .writeByte(0xff)\
    .writeByte(0xff)\
    .writeByte(0xff)\
    .writeByte(0xff)\
    .writeByte(0x00)\
    .writeByte(0x00)\
    .writeByte(0x00)\
    .writeByte(0x00)\
    .writeByte(0x00)\
    .writeByte(0x00)\
    .writeByte(0x00)\
    .writeByte(0x0f);\
assertEquals(16, buffer.size());\
\
assertEquals(9223372036854775807L, buffer.readLong());\
assertEquals(8, buffer.size());\
\
assertEquals(15, buffer.readLong());\
assertEquals(0, buffer.size());

[jvm]\
abstract fun [readLong](read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)
