//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[rangeEquals](range-equals.md)

# rangeEquals

[common]\
expect abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

Returns true if the bytes at `offset` in this source equal `bytes`. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match.

```kotlin
ByteString simonSays = ByteString.encodeUtf8("Simon says:");

Buffer standOnOneLeg = new Buffer().writeUtf8("Simon says: Stand on one leg.");
assertTrue(standOnOneLeg.rangeEquals(0, simonSays));

Buffer payMeMoney = new Buffer().writeUtf8("Pay me $1,000,000.");
assertFalse(payMeMoney.rangeEquals(0, simonSays));
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

[jvm, nonJvm]\
actual abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

[common]\
expect abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

Returns true if `byteCount` bytes at `offset` in this source equal `bytes` at `bytesOffset`. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match.
