(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'okio-parent-okio-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'okio-parent-okio-js-legacy'.");
    }root['okio-parent-okio-js-legacy'] = factory(typeof this['okio-parent-okio-js-legacy'] === 'undefined' ? {} : this['okio-parent-okio-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var L6 = Kotlin.Long.fromInt(6);
  var L8 = Kotlin.Long.fromInt(8);
  var CharRange = Kotlin.kotlin.ranges.CharRange;
  var toByte = Kotlin.toByte;
  var copyOf = Kotlin.kotlin.collections.copyOf_mrm5p$;
  var toShort = Kotlin.toShort;
  var L_72057594037927936 = new Kotlin.Long(0, -16777216);
  var L71776119061217280 = new Kotlin.Long(0, 16711680);
  var L280375465082880 = new Kotlin.Long(0, 65280);
  var L1095216660480 = new Kotlin.Long(0, 255);
  var L4278190080 = new Kotlin.Long(-16777216, 0);
  var L16711680 = Kotlin.Long.fromInt(16711680);
  var L65280 = Kotlin.Long.fromInt(65280);
  var L255 = Kotlin.Long.fromInt(255);
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var concatToString = Kotlin.kotlin.text.concatToString_355ntz$;
  var concatToString_0 = Kotlin.kotlin.text.concatToString_wlitf7$;
  var L0 = Kotlin.Long.ZERO;
  var equals = Kotlin.equals;
  var L15 = Kotlin.Long.fromInt(15);
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Annotation = Kotlin.kotlin.Annotation;
  var L_1 = Kotlin.Long.NEG_ONE;
  var ensureNotNull = Kotlin.ensureNotNull;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var cast = Kotlin.kotlin.reflect.cast_o6trj3$;
  var toString = Kotlin.toString;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var toMap = Kotlin.kotlin.collections.toMap_abgq59$;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var sort = Kotlin.kotlin.collections.sort_4wi501$;
  var map = Kotlin.kotlin.sequences.map_z5avom$;
  var toMutableList = Kotlin.kotlin.collections.toMutableList_us0mfu$;
  var mutableListOf = Kotlin.kotlin.collections.mutableListOf_i5x0yv$;
  var binarySearch = Kotlin.kotlin.collections.binarySearch_jhx6be$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var AbstractList = Kotlin.kotlin.collections.AbstractList;
  var RandomAccess = Kotlin.kotlin.collections.RandomAccess;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  var JsMath = Math;
  var IllegalArgumentException_init_0 = Kotlin.kotlin.IllegalArgumentException_init;
  var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var L1 = Kotlin.Long.ONE;
  var L2 = Kotlin.Long.fromInt(2);
  var L_922337203685477580 = new Kotlin.Long(858993460, -214748365);
  var L_7 = Kotlin.Long.fromInt(-7);
  var ArrayDeque_init = Kotlin.kotlin.collections.ArrayDeque_init_287e2$;
  var Unit = Kotlin.kotlin.Unit;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var sequence = Kotlin.kotlin.sequences.sequence_o0x0bg$;
  var Throwable = Error;
  var addSuppressed = Kotlin.kotlin.addSuppressed_oh0dqn$;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var toChar = Kotlin.toChar;
  var unboxChar = Kotlin.unboxChar;
  var L3 = Kotlin.Long.fromInt(3);
  var last = Kotlin.kotlin.collections.last_2p1efm$;
  var removeLastOrNull = Kotlin.kotlin.collections.removeLastOrNull_vvxzk3$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var fill = Kotlin.kotlin.collections.fill_6mk3ue$;
  var fill_0 = Kotlin.kotlin.collections.fill_tpuxuu$;
  var fill_1 = Kotlin.kotlin.collections.fill_wp4zxy$;
  var L7640891576956012808 = new Kotlin.Long(-205731576, 1779033703);
  var L_4942790177534073029 = new Kotlin.Long(-2067093701, -1150833019);
  var L4354685564936845355 = new Kotlin.Long(-23791573, 1013904242);
  var L_6534734903238641935 = new Kotlin.Long(1595750129, -1521486534);
  var L5840696475078001361 = new Kotlin.Long(-1377402159, 1359893119);
  var L_7276294671716946913 = new Kotlin.Long(725511199, -1694144372);
  var L2270897969802886507 = new Kotlin.Long(-79577749, 528734635);
  var L6620516959819538809 = new Kotlin.Long(327033209, 1541459225);
  var L4794697086780616226 = new Kotlin.Long(-685199838, 1116352408);
  var L8158064640168781261 = new Kotlin.Long(602891725, 1899447441);
  var L_5349999486874862801 = new Kotlin.Long(-330482897, -1245643825);
  var L_1606136188198331460 = new Kotlin.Long(-2121671748, -373957723);
  var L4131703408338449720 = new Kotlin.Long(-213338824, 961987163);
  var L6480981068601479193 = new Kotlin.Long(-1241133031, 1508970993);
  var L_7908458776815382629 = new Kotlin.Long(-1357295717, -1841331548);
  var L_6116909921290321640 = new Kotlin.Long(-630357736, -1424204075);
  var L_2880145864133508542 = new Kotlin.Long(-1560083902, -670586216);
  var L1334009975649890238 = new Kotlin.Long(1164996542, 310598401);
  var L2608012711638119052 = new Kotlin.Long(1323610764, 607225278);
  var L6128411473006802146 = new Kotlin.Long(-704662302, 1426881987);
  var L8268148722764581231 = new Kotlin.Long(-226784913, 1925078388);
  var L_9160688886553864527 = new Kotlin.Long(991336113, -2132889090);
  var L_7215885187991268811 = new Kotlin.Long(633803317, -1680079193);
  var L_4495734319001033068 = new Kotlin.Long(-815192428, -1046744716);
  var L_1973867731355612462 = new Kotlin.Long(-1628353838, -459576895);
  var L_1171420211273849373 = new Kotlin.Long(944711139, -272742522);
  var L1135362057144423861 = new Kotlin.Long(-1953704523, 264347078);
  var L2597628984639134821 = new Kotlin.Long(2007800933, 604807628);
  var L3308224258029322869 = new Kotlin.Long(1495990901, 770255983);
  var L5365058923640841347 = new Kotlin.Long(1856431235, 1249150122);
  var L6679025012923562964 = new Kotlin.Long(-1119749164, 1555081692);
  var L8573033837759648693 = new Kotlin.Long(-2096016459, 1996064986);
  var L_7476448914759557205 = new Kotlin.Long(-295247957, -1740746414);
  var L_6327057829258317296 = new Kotlin.Long(766784016, -1473132947);
  var L_5763719355590565569 = new Kotlin.Long(-1728372417, -1341970488);
  var L_4658551843659510044 = new Kotlin.Long(-1091629340, -1084653625);
  var L_4116276920077217854 = new Kotlin.Long(1034457026, -958395405);
  var L_3051310485924567259 = new Kotlin.Long(-1828018395, -710438585);
  var L489312712824947311 = new Kotlin.Long(-536640913, 113926993);
  var L1452737877330783856 = new Kotlin.Long(168717936, 338241895);
  var L2861767655752347644 = new Kotlin.Long(1188179964, 666307205);
  var L3322285676063803686 = new Kotlin.Long(1546045734, 773529912);
  var L5560940570517711597 = new Kotlin.Long(1522805485, 1294757372);
  var L5996557281743188959 = new Kotlin.Long(-1651133473, 1396182291);
  var L7280758554555802590 = new Kotlin.Long(-1951439906, 1695183700);
  var L8532644243296465576 = new Kotlin.Long(1014477480, 1986661051);
  var L_9096487096722542874 = new Kotlin.Long(1206759142, -2117940946);
  var L_7894198246740708037 = new Kotlin.Long(344077627, -1838011259);
  var L_6719396339535248540 = new Kotlin.Long(1290863460, -1564481375);
  var L_6333637450476146687 = new Kotlin.Long(-1136513023, -1474664885);
  var L_4446306890439682159 = new Kotlin.Long(-789014639, -1035236496);
  var L_4076793802049405392 = new Kotlin.Long(106217008, -949202525);
  var L_3345356375505022440 = new Kotlin.Long(-688958952, -778901479);
  var L_2983346525034927856 = new Kotlin.Long(1432725776, -694614492);
  var L_860691631967231958 = new Kotlin.Long(1467031594, -200395387);
  var L1182934255886127544 = new Kotlin.Long(851169720, 275423344);
  var L1847814050463011016 = new Kotlin.Long(-1194143544, 430227734);
  var L2177327727835720531 = new Kotlin.Long(1363258195, 506948616);
  var L2830643537854262169 = new Kotlin.Long(-544281703, 659060556);
  var L3796741975233480872 = new Kotlin.Long(-509917016, 883997877);
  var L4115178125766777443 = new Kotlin.Long(-976659869, 958139571);
  var L5681478168544905931 = new Kotlin.Long(-482243893, 1322822218);
  var L6601373596472566643 = new Kotlin.Long(2003034995, 1537002063);
  var L7507060721942968483 = new Kotlin.Long(-692930397, 1747873779);
  var L8399075790359081724 = new Kotlin.Long(1575990012, 1955562222);
  var L8693463985226723168 = new Kotlin.Long(1125592928, 2024104815);
  var L_8878714635349349518 = new Kotlin.Long(-1578062990, -2067236844);
  var L_8302665154208450068 = new Kotlin.Long(442776044, -1933114872);
  var L_8016688836872298968 = new Kotlin.Long(593698344, -1866530822);
  var L_6606660893046293015 = new Kotlin.Long(-561857047, -1538233109);
  var L_4685533653050689259 = new Kotlin.Long(-1295615723, -1090935817);
  var L_4147400797238176981 = new Kotlin.Long(-479046869, -965641998);
  var L_3880063495543823972 = new Kotlin.Long(-366583396, -903397682);
  var L_3348786107499101689 = new Kotlin.Long(566280711, -779700025);
  var L_1523767162380948706 = new Kotlin.Long(-840897762, -354779690);
  var L_757361751448694408 = new Kotlin.Long(-294727304, -176337025);
  var L500013540394364858 = new Kotlin.Long(1914138554, 116418474);
  var L748580250866718886 = new Kotlin.Long(-1563912026, 174292421);
  var L1242879168328830382 = new Kotlin.Long(-1090974290, 289380356);
  var L1977374033974150939 = new Kotlin.Long(320620315, 460393269);
  var L2944078676154940804 = new Kotlin.Long(587496836, 685471733);
  var L3659926193048069267 = new Kotlin.Long(1086792851, 852142971);
  var L4368137639120453308 = new Kotlin.Long(365543100, 1017036298);
  var L4836135668995329356 = new Kotlin.Long(-1676669620, 1126000580);
  var L5532061633213252278 = new Kotlin.Long(-885112138, 1288033470);
  var L6448918945643986474 = new Kotlin.Long(-60457430, 1501505948);
  var L6902733635092675308 = new Kotlin.Long(987167468, 1607167915);
  var L7801388544844847127 = new Kotlin.Long(1246189591, 1816402316);
  var IndexOutOfBoundsException = Kotlin.kotlin.IndexOutOfBoundsException;
  var Exception = Kotlin.kotlin.Exception;
  var Long$Companion$MAX_VALUE = Kotlin.Long.MAX_VALUE;
  var L4 = Kotlin.Long.fromInt(4);
  var L4294967295 = new Kotlin.Long(-1, 0);
  var NumberFormatException_init = Kotlin.kotlin.NumberFormatException;
  var L10 = Kotlin.Long.fromInt(10);
  var L_1152921504606846976 = new Kotlin.Long(0, -268435456);
  var L8192 = Kotlin.Long.fromInt(8192);
  var L100000000 = Kotlin.Long.fromInt(100000000);
  var L10000 = Kotlin.Long.fromInt(10000);
  var L100 = Kotlin.Long.fromInt(100);
  var L1000 = Kotlin.Long.fromInt(1000);
  var L1000000 = Kotlin.Long.fromInt(1000000);
  var L100000 = Kotlin.Long.fromInt(100000);
  var L10000000 = Kotlin.Long.fromInt(10000000);
  var L1000000000000 = new Kotlin.Long(-727379968, 232);
  var L10000000000 = new Kotlin.Long(1410065408, 2);
  var L1000000000 = Kotlin.Long.fromInt(1000000000);
  var L100000000000 = new Kotlin.Long(1215752192, 23);
  var L1000000000000000 = new Kotlin.Long(-1530494976, 232830);
  var L10000000000000 = new Kotlin.Long(1316134912, 2328);
  var L100000000000000 = new Kotlin.Long(276447232, 23283);
  var L100000000000000000 = new Kotlin.Long(1569325056, 23283064);
  var L10000000000000000 = new Kotlin.Long(1874919424, 2328306);
  var L1000000000000000000 = new Kotlin.Long(-1486618624, 232830643);
  var L6148914691236517205 = new Kotlin.Long(1431655765, 1431655765);
  var L3689348814741910323 = new Kotlin.Long(858993459, 858993459);
  var L1085102592571150095 = new Kotlin.Long(252645135, 252645135);
  var L63 = Kotlin.Long.fromInt(63);
  var until = Kotlin.kotlin.ranges.until_2p08ub$;
  var AssertionError_init = Kotlin.kotlin.AssertionError_init_pdl1vj$;
  var throwCCE = Kotlin.throwCCE;
  var Comparable = Kotlin.kotlin.Comparable;
  var copyOfRange = Kotlin.kotlin.collections.copyOfRange_ietg8x$;
  var contentHashCode = Kotlin.arrayHashCode;
  var replace = Kotlin.kotlin.text.replace_680rmw$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var AssertionError_init_0 = Kotlin.kotlin.AssertionError_init;
  var toString_0 = Kotlin.kotlin.text.toString_dqglrj$;
  var copyOfRange_0 = Kotlin.kotlin.collections.copyOfRange_5f8l3u$;
  ForwardingFileSystem.prototype = Object.create(FileSystem.prototype);
  ForwardingFileSystem.prototype.constructor = ForwardingFileSystem;
  Options.prototype = Object.create(AbstractList.prototype);
  Options.prototype.constructor = Options;
  ArrayIndexOutOfBoundsException.prototype = Object.create(IndexOutOfBoundsException.prototype);
  ArrayIndexOutOfBoundsException.prototype.constructor = ArrayIndexOutOfBoundsException;
  IOException.prototype = Object.create(Exception.prototype);
  IOException.prototype.constructor = IOException;
  EOFException.prototype = Object.create(IOException.prototype);
  EOFException.prototype.constructor = EOFException;
  FileNotFoundException.prototype = Object.create(IOException.prototype);
  FileNotFoundException.prototype.constructor = FileNotFoundException;
  SegmentedByteString.prototype = Object.create(ByteString.prototype);
  SegmentedByteString.prototype.constructor = SegmentedByteString;
  var BASE64;
  var BASE64_URL_SAFE;
  function decodeBase64ToArray($receiver) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5;
    var limit = $receiver.length;
    while (limit > 0) {
      var c = $receiver.charCodeAt(limit - 1 | 0);
      if (c !== 61 && c !== 10 && c !== 13 && c !== 32 && c !== 9) {
        break;
      }limit = limit - 1 | 0;
    }
    var out = new Int8Array(Kotlin.Long.fromInt(limit).multiply(L6).div(L8).toInt());
    var outCount = 0;
    var inCount = 0;
    var word = 0;
    tmp$ = limit;
    for (var pos = 0; pos < tmp$; pos++) {
      var c_0 = $receiver.charCodeAt(pos);
      var bits;
      if ((new CharRange(65, 90)).contains_mef7kx$(c_0)) {
        bits = (c_0 | 0) - 65 | 0;
      } else if ((new CharRange(97, 122)).contains_mef7kx$(c_0)) {
        bits = (c_0 | 0) - 71 | 0;
      } else if ((new CharRange(48, 57)).contains_mef7kx$(c_0)) {
        bits = (c_0 | 0) + 4 | 0;
      } else if (c_0 === 43 || c_0 === 45) {
        bits = 62;
      } else if (c_0 === 47 || c_0 === 95) {
        bits = 63;
      } else if (c_0 === 10 || c_0 === 13 || c_0 === 32 || c_0 === 9) {
        continue;
      } else {
        return null;
      }
      word = word << 6 | bits;
      inCount = inCount + 1 | 0;
      if (inCount % 4 === 0) {
        out[tmp$_0 = outCount, outCount = tmp$_0 + 1 | 0, tmp$_0] = toByte(word >> 16);
        out[tmp$_1 = outCount, outCount = tmp$_1 + 1 | 0, tmp$_1] = toByte(word >> 8);
        out[tmp$_2 = outCount, outCount = tmp$_2 + 1 | 0, tmp$_2] = toByte(word);
      }}
    var lastWordChars = inCount % 4;
    switch (lastWordChars) {
      case 1:
        return null;
      case 2:
        word = word << 12;
        out[tmp$_3 = outCount, outCount = tmp$_3 + 1 | 0, tmp$_3] = toByte(word >> 16);
        break;
      case 3:
        word = word << 6;
        out[tmp$_4 = outCount, outCount = tmp$_4 + 1 | 0, tmp$_4] = toByte(word >> 16);
        out[tmp$_5 = outCount, outCount = tmp$_5 + 1 | 0, tmp$_5] = toByte(word >> 8);
        break;
    }
    if (outCount === out.length)
      return out;
    return copyOf(out, outCount);
  }
  function encodeBase64($receiver, map) {
    if (map === void 0)
      map = BASE64;
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8, tmp$_9, tmp$_10, tmp$_11, tmp$_12;
    var length = (($receiver.length + 2 | 0) / 3 | 0) * 4 | 0;
    var out = new Int8Array(length);
    var index = 0;
    var end = $receiver.length - $receiver.length % 3 | 0;
    var i = 0;
    while (i < end) {
      var b0 = $receiver[tmp$ = i, i = tmp$ + 1 | 0, tmp$];
      var b1 = $receiver[tmp$_0 = i, i = tmp$_0 + 1 | 0, tmp$_0];
      var b2 = $receiver[tmp$_1 = i, i = tmp$_1 + 1 | 0, tmp$_1];
      out[tmp$_2 = index, index = tmp$_2 + 1 | 0, tmp$_2] = map[(b0 & 255) >> 2];
      out[tmp$_3 = index, index = tmp$_3 + 1 | 0, tmp$_3] = map[(b0 & 3) << 4 | (b1 & 255) >> 4];
      out[tmp$_4 = index, index = tmp$_4 + 1 | 0, tmp$_4] = map[(b1 & 15) << 2 | (b2 & 255) >> 6];
      out[tmp$_5 = index, index = tmp$_5 + 1 | 0, tmp$_5] = map[b2 & 63];
    }
    switch ($receiver.length - end | 0) {
      case 1:
        var b0_0 = $receiver[i];
        out[tmp$_6 = index, index = tmp$_6 + 1 | 0, tmp$_6] = map[(b0_0 & 255) >> 2];
        out[tmp$_7 = index, index = tmp$_7 + 1 | 0, tmp$_7] = map[(b0_0 & 3) << 4];
        out[tmp$_8 = index, index = tmp$_8 + 1 | 0, tmp$_8] = toByte(61);
        out[index] = toByte(61);
        break;
      case 2:
        var b0_1 = $receiver[tmp$_9 = i, i = tmp$_9 + 1 | 0, tmp$_9];
        var b1_0 = $receiver[i];
        out[tmp$_10 = index, index = tmp$_10 + 1 | 0, tmp$_10] = map[(b0_1 & 255) >> 2];
        out[tmp$_11 = index, index = tmp$_11 + 1 | 0, tmp$_11] = map[(b0_1 & 3) << 4 | (b1_0 & 255) >> 4];
        out[tmp$_12 = index, index = tmp$_12 + 1 | 0, tmp$_12] = map[(b1_0 & 15) << 2];
        out[index] = toByte(61);
        break;
    }
    return toUtf8String(out);
  }
  function checkOffsetAndCount(size, offset, byteCount) {
    if (offset.or(byteCount).toNumber() < 0 || offset.compareTo_11rb$(size) > 0 || size.subtract(offset).compareTo_11rb$(byteCount) < 0) {
      throw new ArrayIndexOutOfBoundsException('size=' + size.toString() + ' offset=' + offset.toString() + ' byteCount=' + byteCount.toString());
    }}
  function reverseBytes($receiver) {
    var i = $receiver & 65535;
    var reversed = (i & 65280) >>> 8 | (i & 255) << 8;
    return toShort(reversed);
  }
  function reverseBytes_0($receiver) {
    return ($receiver & -16777216) >>> 24 | ($receiver & 16711680) >>> 8 | ($receiver & 65280) << 8 | ($receiver & 255) << 24;
  }
  function reverseBytes_1($receiver) {
    return $receiver.and(L_72057594037927936).shiftRightUnsigned(56).or($receiver.and(L71776119061217280).shiftRightUnsigned(40)).or($receiver.and(L280375465082880).shiftRightUnsigned(24)).or($receiver.and(L1095216660480).shiftRightUnsigned(8)).or($receiver.and(L4278190080).shiftLeft(8)).or($receiver.and(L16711680).shiftLeft(24)).or($receiver.and(L65280).shiftLeft(40)).or($receiver.and(L255).shiftLeft(56));
  }
  var leftRotate = defineInlineFunction('okio-parent-okio-js-legacy.okio.leftRotate_b6l1hq$', function ($receiver, bitCount) {
    return $receiver << bitCount | $receiver >>> 32 - bitCount;
  });
  var rightRotate = defineInlineFunction('okio-parent-okio-js-legacy.okio.rightRotate_raukh1$', function ($receiver, bitCount) {
    return $receiver.shiftRightUnsigned(bitCount).or($receiver.shiftLeft(64 - bitCount | 0));
  });
  var shr = defineInlineFunction('okio-parent-okio-js-legacy.okio.shr_g525uh$', function ($receiver, other) {
    return $receiver >> other;
  });
  var shl = defineInlineFunction('okio-parent-okio-js-legacy.okio.shl_g525uh$', function ($receiver, other) {
    return $receiver << other;
  });
  var and = defineInlineFunction('okio-parent-okio-js-legacy.okio.and_g525uh$', function ($receiver, other) {
    return $receiver & other;
  });
  var and_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.and_354l1u$', function ($receiver, other) {
    return Kotlin.Long.fromInt($receiver).and(other);
  });
  var xor = defineInlineFunction('okio-parent-okio-js-legacy.okio.xor_34yeqm$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    return function ($receiver, other) {
      return toByte($receiver ^ other);
    };
  }));
  var and_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.and_8hhx95$', function ($receiver, other) {
    return Kotlin.Long.fromInt($receiver).and(other);
  });
  var minOf = defineInlineFunction('okio-parent-okio-js-legacy.okio.minOf_plstum$', function (a, b) {
    var b_0 = Kotlin.Long.fromInt(b);
    return a.compareTo_11rb$(b_0) <= 0 ? a : b_0;
  });
  var minOf_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.minOf_22xunw$', function (a, b) {
    var a_0 = Kotlin.Long.fromInt(a);
    return a_0.compareTo_11rb$(b) <= 0 ? a_0 : b;
  });
  function arrayRangeEquals(a, aOffset, b, bOffset, byteCount) {
    for (var i = 0; i < byteCount; i++) {
      if (a[i + aOffset | 0] !== b[i + bOffset | 0])
        return false;
    }
    return true;
  }
  function toHexString($receiver) {
    var result = Kotlin.charArray(2);
    result[0] = HEX_DIGIT_CHARS[$receiver >> 4 & 15];
    result[1] = HEX_DIGIT_CHARS[$receiver & 15];
    return concatToString(result);
  }
  function toHexString_0($receiver) {
    if ($receiver === 0)
      return '0';
    var result = Kotlin.charArray(8);
    result[0] = HEX_DIGIT_CHARS[$receiver >> 28 & 15];
    result[1] = HEX_DIGIT_CHARS[$receiver >> 24 & 15];
    result[2] = HEX_DIGIT_CHARS[$receiver >> 20 & 15];
    result[3] = HEX_DIGIT_CHARS[$receiver >> 16 & 15];
    result[4] = HEX_DIGIT_CHARS[$receiver >> 12 & 15];
    result[5] = HEX_DIGIT_CHARS[$receiver >> 8 & 15];
    result[6] = HEX_DIGIT_CHARS[$receiver >> 4 & 15];
    result[7] = HEX_DIGIT_CHARS[$receiver & 15];
    var i = 0;
    while (i < result.length && result[i] === 48) {
      i = i + 1 | 0;
    }
    return concatToString_0(result, i, result.length);
  }
  function toHexString_1($receiver) {
    if (equals($receiver, L0))
      return '0';
    var result = Kotlin.charArray(16);
    result[0] = HEX_DIGIT_CHARS[$receiver.shiftRight(60).and(L15).toInt()];
    result[1] = HEX_DIGIT_CHARS[$receiver.shiftRight(56).and(L15).toInt()];
    result[2] = HEX_DIGIT_CHARS[$receiver.shiftRight(52).and(L15).toInt()];
    result[3] = HEX_DIGIT_CHARS[$receiver.shiftRight(48).and(L15).toInt()];
    result[4] = HEX_DIGIT_CHARS[$receiver.shiftRight(44).and(L15).toInt()];
    result[5] = HEX_DIGIT_CHARS[$receiver.shiftRight(40).and(L15).toInt()];
    result[6] = HEX_DIGIT_CHARS[$receiver.shiftRight(36).and(L15).toInt()];
    result[7] = HEX_DIGIT_CHARS[$receiver.shiftRight(32).and(L15).toInt()];
    result[8] = HEX_DIGIT_CHARS[$receiver.shiftRight(28).and(L15).toInt()];
    result[9] = HEX_DIGIT_CHARS[$receiver.shiftRight(24).and(L15).toInt()];
    result[10] = HEX_DIGIT_CHARS[$receiver.shiftRight(20).and(L15).toInt()];
    result[11] = HEX_DIGIT_CHARS[$receiver.shiftRight(16).and(L15).toInt()];
    result[12] = HEX_DIGIT_CHARS[$receiver.shiftRight(12).and(L15).toInt()];
    result[13] = HEX_DIGIT_CHARS[$receiver.shiftRight(8).and(L15).toInt()];
    result[14] = HEX_DIGIT_CHARS[$receiver.shiftRight(4).and(L15).toInt()];
    result[15] = HEX_DIGIT_CHARS[$receiver.and(L15).toInt()];
    var i = 0;
    while (i < result.length && result[i] === 48) {
      i = i + 1 | 0;
    }
    return concatToString_0(result, i, result.length);
  }
  var DEFAULT__new_UnsafeCursor;
  function resolveDefaultParameter(unsafeCursor) {
    if (unsafeCursor === DEFAULT__new_UnsafeCursor)
      return new Buffer$UnsafeCursor();
    return unsafeCursor;
  }
  var DEFAULT__ByteString_size;
  function resolveDefaultParameter_0($receiver, position) {
    if (position === DEFAULT__ByteString_size)
      return $receiver.size;
    return position;
  }
  function ExperimentalFileSystem() {
  }
  ExperimentalFileSystem.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExperimentalFileSystem',
    interfaces: [Annotation]
  };
  function FileHandle(readWrite) {
    this.readWrite = readWrite;
    this.closed_df7d0w$_0 = false;
    this.openStreamCount_j4wwst$_0 = 0;
  }
  FileHandle.prototype.read_4m9kcn$ = function (fileOffset, array, arrayOffset, byteCount) {
    if (!!this.closed_df7d0w$_0) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }return this.protectedRead_4m9kcn$(fileOffset, array, arrayOffset, byteCount);
  };
  FileHandle.prototype.read_mig0g6$ = function (fileOffset, sink, byteCount) {
    if (!!this.closed_df7d0w$_0) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }return this.readNoCloseCheck_84gacx$_0(fileOffset, sink, byteCount);
  };
  FileHandle.prototype.size = function () {
    if (!!this.closed_df7d0w$_0) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }return this.protectedSize();
  };
  FileHandle.prototype.resize_s8cxhz$ = function (size) {
    if (!this.readWrite) {
      var message = 'file handle is read-only';
      throw IllegalStateException_init(message.toString());
    }if (!!this.closed_df7d0w$_0) {
      var message_0 = 'closed';
      throw IllegalStateException_init(message_0.toString());
    }return this.protectedResize_s8cxhz$(size);
  };
  FileHandle.prototype.write_4m9kcn$ = function (fileOffset, array, arrayOffset, byteCount) {
    if (!this.readWrite) {
      var message = 'file handle is read-only';
      throw IllegalStateException_init(message.toString());
    }if (!!this.closed_df7d0w$_0) {
      var message_0 = 'closed';
      throw IllegalStateException_init(message_0.toString());
    }return this.protectedWrite_4m9kcn$(fileOffset, array, arrayOffset, byteCount);
  };
  FileHandle.prototype.write_mig0g6$ = function (fileOffset, source, byteCount) {
    if (!this.readWrite) {
      var message = 'file handle is read-only';
      throw IllegalStateException_init(message.toString());
    }if (!!this.closed_df7d0w$_0) {
      var message_0 = 'closed';
      throw IllegalStateException_init(message_0.toString());
    }this.writeNoCloseCheck_mtjvem$_0(fileOffset, source, byteCount);
  };
  FileHandle.prototype.flush = function () {
    if (!this.readWrite) {
      var message = 'file handle is read-only';
      throw IllegalStateException_init(message.toString());
    }if (!!this.closed_df7d0w$_0) {
      var message_0 = 'closed';
      throw IllegalStateException_init(message_0.toString());
    }return this.protectedFlush();
  };
  FileHandle.prototype.source_s8cxhz$ = function (fileOffset) {
    if (fileOffset === void 0)
      fileOffset = L0;
    var tmp$;
    if (!!this.closed_df7d0w$_0) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }tmp$ = this.openStreamCount_j4wwst$_0, this.openStreamCount_j4wwst$_0 = tmp$ + 1 | 0;
    return new FileHandle$FileHandleSource(this, fileOffset);
  };
  FileHandle.prototype.position_sby9nd$ = function (source) {
    var source_0 = source;
    var bufferSize = L0;
    if (Kotlin.isType(source_0, RealBufferedSource)) {
      bufferSize = source_0.buffer.size;
      source_0 = source_0.source;
    }if (!(Kotlin.isType(source_0, FileHandle$FileHandleSource) && source_0.fileHandle === this)) {
      var message = 'source was not created by this FileHandle';
      throw IllegalArgumentException_init(message.toString());
    }if (!!source_0.closed) {
      var message_0 = 'closed';
      throw IllegalStateException_init(message_0.toString());
    }return source_0.position.subtract(bufferSize);
  };
  FileHandle.prototype.reposition_9ujt9g$ = function (source, position) {
    if (Kotlin.isType(source, RealBufferedSource)) {
      var fileHandleSource = source.source;
      if (!(Kotlin.isType(fileHandleSource, FileHandle$FileHandleSource) && fileHandleSource.fileHandle === this)) {
        var message = 'source was not created by this FileHandle';
        throw IllegalArgumentException_init(message.toString());
      }if (!!fileHandleSource.closed) {
        var message_0 = 'closed';
        throw IllegalStateException_init(message_0.toString());
      }var bufferSize = source.buffer.size;
      var toSkip = position.subtract(fileHandleSource.position.subtract(bufferSize));
      if (L0.lessThanOrEqual(toSkip) && toSkip.lessThan(bufferSize)) {
        source.skip_s8cxhz$(toSkip);
      } else {
        source.buffer.clear();
        fileHandleSource.position = position;
      }
    } else {
      if (!(Kotlin.isType(source, FileHandle$FileHandleSource) && source.fileHandle === this)) {
        var message_1 = 'source was not created by this FileHandle';
        throw IllegalArgumentException_init(message_1.toString());
      }if (!!source.closed) {
        var message_2 = 'closed';
        throw IllegalStateException_init(message_2.toString());
      }source.position = position;
    }
  };
  FileHandle.prototype.sink_s8cxhz$ = function (fileOffset) {
    if (fileOffset === void 0)
      fileOffset = L0;
    if (!this.readWrite) {
      var message = 'file handle is read-only';
      throw IllegalStateException_init(message.toString());
    }var tmp$;
    if (!!this.closed_df7d0w$_0) {
      var message_0 = 'closed';
      throw IllegalStateException_init(message_0.toString());
    }tmp$ = this.openStreamCount_j4wwst$_0, this.openStreamCount_j4wwst$_0 = tmp$ + 1 | 0;
    return new FileHandle$FileHandleSink(this, fileOffset);
  };
  FileHandle.prototype.appendingSink = function () {
    return this.sink_s8cxhz$(this.size());
  };
  FileHandle.prototype.position_awqvbz$ = function (sink) {
    var sink_0 = sink;
    var bufferSize = L0;
    if (Kotlin.isType(sink_0, RealBufferedSink)) {
      bufferSize = sink_0.buffer.size;
      sink_0 = sink_0.sink;
    }if (!(Kotlin.isType(sink_0, FileHandle$FileHandleSink) && sink_0.fileHandle === this)) {
      var message = 'sink was not created by this FileHandle';
      throw IllegalArgumentException_init(message.toString());
    }if (!!sink_0.closed) {
      var message_0 = 'closed';
      throw IllegalStateException_init(message_0.toString());
    }return sink_0.position.add(bufferSize);
  };
  FileHandle.prototype.reposition_11jk9o$ = function (sink, position) {
    if (Kotlin.isType(sink, RealBufferedSink)) {
      var fileHandleSink = sink.sink;
      if (!(Kotlin.isType(fileHandleSink, FileHandle$FileHandleSink) && fileHandleSink.fileHandle === this)) {
        var message = 'sink was not created by this FileHandle';
        throw IllegalArgumentException_init(message.toString());
      }if (!!fileHandleSink.closed) {
        var message_0 = 'closed';
        throw IllegalStateException_init(message_0.toString());
      }sink.emit();
      fileHandleSink.position = position;
    } else {
      if (!(Kotlin.isType(sink, FileHandle$FileHandleSink) && sink.fileHandle === this)) {
        var message_1 = 'sink was not created by this FileHandle';
        throw IllegalArgumentException_init(message_1.toString());
      }if (!!sink.closed) {
        var message_2 = 'closed';
        throw IllegalStateException_init(message_2.toString());
      }sink.position = position;
    }
  };
  FileHandle.prototype.close = function () {
    if (this.closed_df7d0w$_0)
      return;
    this.closed_df7d0w$_0 = true;
    if (this.openStreamCount_j4wwst$_0 !== 0)
      return;
    this.protectedClose();
  };
  FileHandle.prototype.readNoCloseCheck_84gacx$_0 = function (fileOffset, sink, byteCount) {
    if (!(byteCount.compareTo_11rb$(L0) >= 0)) {
      var message = 'byteCount < 0: ' + byteCount.toString();
      throw IllegalArgumentException_init(message.toString());
    }var currentOffset = fileOffset;
    var targetOffset = fileOffset.add(byteCount);
    while (currentOffset.compareTo_11rb$(targetOffset) < 0) {
      var tail = sink.writableSegment_kcn2v3$(1);
      var tmp$ = currentOffset;
      var tmp$_0 = tail.data;
      var tmp$_1 = tail.limit;
      var a = targetOffset.subtract(currentOffset);
      var b = Kotlin.Long.fromInt(8192 - tail.limit | 0);
      var readByteCount = this.protectedRead_4m9kcn$(tmp$, tmp$_0, tmp$_1, (a.compareTo_11rb$(b) <= 0 ? a : b).toInt());
      if (readByteCount === -1) {
        if (tail.pos === tail.limit) {
          sink.head_8be2vx$ = tail.pop();
          SegmentPool_getInstance().recycle_uve4t5$(tail);
        }if (equals(fileOffset, currentOffset))
          return L_1;
        break;
      }tail.limit = tail.limit + readByteCount | 0;
      currentOffset = currentOffset.add(Kotlin.Long.fromInt(readByteCount));
      sink.size = sink.size.add(Kotlin.Long.fromInt(readByteCount));
    }
    return currentOffset.subtract(fileOffset);
  };
  FileHandle.prototype.writeNoCloseCheck_mtjvem$_0 = function (fileOffset, source, byteCount) {
    checkOffsetAndCount(source.size, L0, byteCount);
    var currentOffset = fileOffset;
    var targetOffset = fileOffset.add(byteCount);
    while (currentOffset.compareTo_11rb$(targetOffset) < 0) {
      var head = ensureNotNull(source.head_8be2vx$);
      var a = targetOffset.subtract(currentOffset);
      var b = Kotlin.Long.fromInt(head.limit - head.pos | 0);
      var toCopy = (a.compareTo_11rb$(b) <= 0 ? a : b).toInt();
      this.protectedWrite_4m9kcn$(currentOffset, head.data, head.pos, toCopy);
      head.pos = head.pos + toCopy | 0;
      currentOffset = currentOffset.add(Kotlin.Long.fromInt(toCopy));
      source.size = source.size.subtract(Kotlin.Long.fromInt(toCopy));
      if (head.pos === head.limit) {
        source.head_8be2vx$ = head.pop();
        SegmentPool_getInstance().recycle_uve4t5$(head);
      }}
  };
  function FileHandle$FileHandleSink(fileHandle, position) {
    this.fileHandle = fileHandle;
    this.position = position;
    this.closed = false;
  }
  FileHandle$FileHandleSink.prototype.write_u27jpl$ = function (source, byteCount) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.fileHandle.writeNoCloseCheck_mtjvem$_0(this.position, source, byteCount);
    this.position = this.position.add(byteCount);
  };
  FileHandle$FileHandleSink.prototype.flush = function () {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.fileHandle.protectedFlush();
  };
  FileHandle$FileHandleSink.prototype.timeout = function () {
    return Timeout$Companion_getInstance().NONE;
  };
  FileHandle$FileHandleSink.prototype.close = function () {
    if (this.closed)
      return;
    this.closed = true;
    var tmp$;
    tmp$ = this.fileHandle;
    tmp$.openStreamCount_j4wwst$_0 = tmp$.openStreamCount_j4wwst$_0 - 1 | 0;
    if (this.fileHandle.openStreamCount_j4wwst$_0 !== 0 || !this.fileHandle.closed_df7d0w$_0)
      return;
    this.fileHandle.protectedClose();
  };
  FileHandle$FileHandleSink.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileHandleSink',
    interfaces: [Sink]
  };
  function FileHandle$FileHandleSource(fileHandle, position) {
    this.fileHandle = fileHandle;
    this.position = position;
    this.closed = false;
  }
  FileHandle$FileHandleSource.prototype.read_u27jpl$ = function (sink, byteCount) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }var result = this.fileHandle.readNoCloseCheck_84gacx$_0(this.position, sink, byteCount);
    if (!equals(result, L_1))
      this.position = this.position.add(result);
    return result;
  };
  FileHandle$FileHandleSource.prototype.timeout = function () {
    return Timeout$Companion_getInstance().NONE;
  };
  FileHandle$FileHandleSource.prototype.close = function () {
    if (this.closed)
      return;
    this.closed = true;
    var tmp$;
    tmp$ = this.fileHandle;
    tmp$.openStreamCount_j4wwst$_0 = tmp$.openStreamCount_j4wwst$_0 - 1 | 0;
    if (this.fileHandle.openStreamCount_j4wwst$_0 !== 0 || !this.fileHandle.closed_df7d0w$_0)
      return;
    this.fileHandle.protectedClose();
  };
  FileHandle$FileHandleSource.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileHandleSource',
    interfaces: [Source]
  };
  FileHandle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileHandle',
    interfaces: [Closeable]
  };
  function FileMetadata(isRegularFile, isDirectory, symlinkTarget, size, createdAtMillis, lastModifiedAtMillis, lastAccessedAtMillis, extras) {
    if (isRegularFile === void 0)
      isRegularFile = false;
    if (isDirectory === void 0)
      isDirectory = false;
    if (symlinkTarget === void 0)
      symlinkTarget = null;
    if (size === void 0)
      size = null;
    if (createdAtMillis === void 0)
      createdAtMillis = null;
    if (lastModifiedAtMillis === void 0)
      lastModifiedAtMillis = null;
    if (lastAccessedAtMillis === void 0)
      lastAccessedAtMillis = null;
    if (extras === void 0) {
      extras = emptyMap();
    }this.isRegularFile = isRegularFile;
    this.isDirectory = isDirectory;
    this.symlinkTarget = symlinkTarget;
    this.size = size;
    this.createdAtMillis = createdAtMillis;
    this.lastModifiedAtMillis = lastModifiedAtMillis;
    this.lastAccessedAtMillis = lastAccessedAtMillis;
    this.extras = toMap(extras);
  }
  FileMetadata.prototype.extra_m49zxj$ = function (type) {
    var tmp$;
    tmp$ = this.extras.get_11rb$(type);
    if (tmp$ == null) {
      return null;
    }var value = tmp$;
    return cast(type, value);
  };
  FileMetadata.prototype.copy_mlpyr7$ = function (isRegularFile, isDirectory, symlinkTarget, size, createdAtMillis, lastModifiedAtMillis, lastAccessedAtMillis, extras) {
    if (isRegularFile === void 0)
      isRegularFile = this.isRegularFile;
    if (isDirectory === void 0)
      isDirectory = this.isDirectory;
    if (symlinkTarget === void 0)
      symlinkTarget = this.symlinkTarget;
    if (size === void 0)
      size = this.size;
    if (createdAtMillis === void 0)
      createdAtMillis = this.createdAtMillis;
    if (lastModifiedAtMillis === void 0)
      lastModifiedAtMillis = this.lastModifiedAtMillis;
    if (lastAccessedAtMillis === void 0)
      lastAccessedAtMillis = this.lastAccessedAtMillis;
    if (extras === void 0)
      extras = this.extras;
    return new FileMetadata(isRegularFile, isDirectory, symlinkTarget, size, createdAtMillis, lastModifiedAtMillis, lastAccessedAtMillis, extras);
  };
  FileMetadata.prototype.toString = function () {
    var fields = ArrayList_init();
    if (this.isRegularFile) {
      var element = 'isRegularFile';
      fields.add_11rb$(element);
    }if (this.isDirectory) {
      var element_0 = 'isDirectory';
      fields.add_11rb$(element_0);
    }if (this.size != null) {
      var element_1 = 'byteCount=' + toString(this.size);
      fields.add_11rb$(element_1);
    }if (this.createdAtMillis != null) {
      var element_2 = 'createdAt=' + toString(this.createdAtMillis);
      fields.add_11rb$(element_2);
    }if (this.lastModifiedAtMillis != null) {
      var element_3 = 'lastModifiedAt=' + toString(this.lastModifiedAtMillis);
      fields.add_11rb$(element_3);
    }if (this.lastAccessedAtMillis != null) {
      var element_4 = 'lastAccessedAt=' + toString(this.lastAccessedAtMillis);
      fields.add_11rb$(element_4);
    }if (!this.extras.isEmpty()) {
      var element_5 = 'extras=' + this.extras;
      fields.add_11rb$(element_5);
    }return joinToString(fields, ', ', 'FileMetadata(', ')');
  };
  FileMetadata.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileMetadata',
    interfaces: []
  };
  function ForwardingFileSystem(delegate) {
    FileSystem.call(this);
    this.delegate = delegate;
  }
  ForwardingFileSystem.prototype.onPathParameter_iy9yqz$ = function (path, functionName, parameterName) {
    return path;
  };
  ForwardingFileSystem.prototype.onPathResult_us7oxp$ = function (path, functionName) {
    return path;
  };
  ForwardingFileSystem.prototype.canonicalize_awoskx$ = function (path) {
    var path_0 = this.onPathParameter_iy9yqz$(path, 'canonicalize', 'path');
    var result = this.delegate.canonicalize_awoskx$(path_0);
    return this.onPathResult_us7oxp$(result, 'canonicalize');
  };
  ForwardingFileSystem.prototype.metadataOrNull_awoskx$ = function (path) {
    var tmp$;
    var path_0 = this.onPathParameter_iy9yqz$(path, 'metadataOrNull', 'path');
    tmp$ = this.delegate.metadataOrNull_awoskx$(path_0);
    if (tmp$ == null) {
      return null;
    }var metadataOrNull = tmp$;
    if (metadataOrNull.symlinkTarget == null)
      return metadataOrNull;
    var symlinkTarget = this.onPathResult_us7oxp$(metadataOrNull.symlinkTarget, 'metadataOrNull');
    return metadataOrNull.copy_mlpyr7$(void 0, void 0, symlinkTarget);
  };
  ForwardingFileSystem.prototype.list_awoskx$ = function (dir) {
    var dir_0 = this.onPathParameter_iy9yqz$(dir, 'list', 'dir');
    var result = this.delegate.list_awoskx$(dir_0);
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = result.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(this.onPathResult_us7oxp$(item, 'list'));
    }
    var paths = destination;
    sort(paths);
    return paths;
  };
  ForwardingFileSystem.prototype.listOrNull_awoskx$ = function (dir) {
    var tmp$;
    var dir_0 = this.onPathParameter_iy9yqz$(dir, 'listOrNull', 'dir');
    tmp$ = this.delegate.listOrNull_awoskx$(dir_0);
    if (tmp$ == null) {
      return null;
    }var result = tmp$;
    var destination = ArrayList_init();
    var tmp$_0;
    tmp$_0 = result.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      destination.add_11rb$(this.onPathResult_us7oxp$(item, 'listOrNull'));
    }
    var paths = destination;
    sort(paths);
    return paths;
  };
  function ForwardingFileSystem$listRecursively$lambda(this$ForwardingFileSystem) {
    return function (it) {
      return this$ForwardingFileSystem.onPathResult_us7oxp$(it, 'listRecursively');
    };
  }
  ForwardingFileSystem.prototype.listRecursively_1apv92$$default = function (dir, followSymlinks) {
    var dir_0 = this.onPathParameter_iy9yqz$(dir, 'listRecursively', 'dir');
    var result = this.delegate.listRecursively_1apv92$(dir_0, followSymlinks);
    return map(result, ForwardingFileSystem$listRecursively$lambda(this));
  };
  ForwardingFileSystem.prototype.openReadOnly_awoskx$ = function (file) {
    var file_0 = this.onPathParameter_iy9yqz$(file, 'openReadOnly', 'file');
    return this.delegate.openReadOnly_awoskx$(file_0);
  };
  ForwardingFileSystem.prototype.openReadWrite_5ehyq9$$default = function (file, mustCreate, mustExist) {
    var file_0 = this.onPathParameter_iy9yqz$(file, 'openReadWrite', 'file');
    return this.delegate.openReadWrite_5ehyq9$(file_0, mustCreate, mustExist);
  };
  ForwardingFileSystem.prototype.source_awoskx$ = function (file) {
    var file_0 = this.onPathParameter_iy9yqz$(file, 'source', 'file');
    return this.delegate.source_awoskx$(file_0);
  };
  ForwardingFileSystem.prototype.sink_1apv92$$default = function (file, mustCreate) {
    var file_0 = this.onPathParameter_iy9yqz$(file, 'sink', 'file');
    return this.delegate.sink_1apv92$(file_0, mustCreate);
  };
  ForwardingFileSystem.prototype.appendingSink_1apv92$$default = function (file, mustExist) {
    var file_0 = this.onPathParameter_iy9yqz$(file, 'appendingSink', 'file');
    return this.delegate.appendingSink_1apv92$(file_0, mustExist);
  };
  ForwardingFileSystem.prototype.createDirectory_1apv92$$default = function (dir, mustCreate) {
    var dir_0 = this.onPathParameter_iy9yqz$(dir, 'createDirectory', 'dir');
    this.delegate.createDirectory_1apv92$(dir_0, mustCreate);
  };
  ForwardingFileSystem.prototype.atomicMove_vhmyk6$ = function (source, target) {
    var source_0 = this.onPathParameter_iy9yqz$(source, 'atomicMove', 'source');
    var target_0 = this.onPathParameter_iy9yqz$(target, 'atomicMove', 'target');
    this.delegate.atomicMove_vhmyk6$(source_0, target_0);
  };
  ForwardingFileSystem.prototype.delete_1apv92$$default = function (path, mustExist) {
    var path_0 = this.onPathParameter_iy9yqz$(path, 'delete', 'path');
    this.delegate.delete_1apv92$(path_0, mustExist);
  };
  ForwardingFileSystem.prototype.createSymlink_vhmyk6$ = function (source, target) {
    var source_0 = this.onPathParameter_iy9yqz$(source, 'createSymlink', 'source');
    var target_0 = this.onPathParameter_iy9yqz$(target, 'createSymlink', 'target');
    this.delegate.createSymlink_vhmyk6$(source_0, target_0);
  };
  ForwardingFileSystem.prototype.toString = function () {
    return toString(Kotlin.getKClassFromExpression(this).simpleName) + '(' + this.delegate + ')';
  };
  ForwardingFileSystem.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ForwardingFileSystem',
    interfaces: [FileSystem]
  };
  function buffer($receiver) {
    return new RealBufferedSource($receiver);
  }
  function buffer_0($receiver) {
    return new RealBufferedSink($receiver);
  }
  function blackholeSink() {
    return new BlackholeSink();
  }
  function BlackholeSink() {
  }
  BlackholeSink.prototype.write_u27jpl$ = function (source, byteCount) {
    source.skip_s8cxhz$(byteCount);
  };
  BlackholeSink.prototype.flush = function () {
  };
  BlackholeSink.prototype.timeout = function () {
    return Timeout$Companion_getInstance().NONE;
  };
  BlackholeSink.prototype.close = function () {
  };
  BlackholeSink.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BlackholeSink',
    interfaces: [Sink]
  };
  var use = defineInlineFunction('okio-parent-okio-js-legacy.okio.use_iztsfq$', wrapFunction(function () {
    var Throwable = Error;
    var Unit = Kotlin.kotlin.Unit;
    var addSuppressed = Kotlin.kotlin.addSuppressed_oh0dqn$;
    var ensureNotNull = Kotlin.ensureNotNull;
    return function ($receiver, block) {
      var result = null;
      var thrown = null;
      try {
        result = block($receiver);
      } catch (t) {
        if (Kotlin.isType(t, Throwable)) {
          thrown = t;
        } else
          throw t;
      }
      try {
        $receiver != null ? ($receiver.close(), Unit) : null;
      } catch (t) {
        if (Kotlin.isType(t, Throwable)) {
          if (thrown == null)
            thrown = t;
          else
            addSuppressed(thrown, t);
        } else
          throw t;
      }
      if (thrown != null)
        throw thrown;
      return ensureNotNull(result);
    };
  }));
  function Options(byteStrings, trie) {
    Options$Companion_getInstance();
    AbstractList.call(this);
    this.byteStrings_8be2vx$ = byteStrings;
    this.trie_8be2vx$ = trie;
  }
  Object.defineProperty(Options.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.byteStrings_8be2vx$.length;
    }
  });
  Options.prototype.get_za3lpa$ = function (index) {
    return this.byteStrings_8be2vx$[index];
  };
  function Options$Companion() {
    Options$Companion_instance = this;
  }
  Options$Companion.prototype.of_yg83lq$ = function (byteStrings) {
    var tmp$;
    if (byteStrings.length === 0) {
      return new Options([], new Int32Array([0, -1]));
    }var list = toMutableList(byteStrings);
    sort(list);
    var destination = ArrayList_init_0(byteStrings.length);
    var tmp$_0;
    for (tmp$_0 = 0; tmp$_0 !== byteStrings.length; ++tmp$_0) {
      var item = byteStrings[tmp$_0];
      destination.add_11rb$(-1);
    }
    var indexes = mutableListOf(copyToArray(destination).slice());
    var tmp$_1, tmp$_0_0;
    var index = 0;
    for (tmp$_1 = 0; tmp$_1 !== byteStrings.length; ++tmp$_1) {
      var item_0 = byteStrings[tmp$_1];
      var callerIndex = (tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0);
      var sortedIndex = binarySearch(list, item_0);
      indexes.set_wxm5ur$(sortedIndex, callerIndex);
    }
    if (!(list.get_za3lpa$(0).size > 0)) {
      var message = 'the empty byte string is not a supported option';
      throw IllegalArgumentException_init(message.toString());
    }var a = 0;
    while (a < list.size) {
      var prefix = list.get_za3lpa$(a);
      var b = a + 1 | 0;
      while (b < list.size) {
        var byteString = list.get_za3lpa$(b);
        if (!byteString.startsWith_9ovubf$(prefix))
          break;
        if (!(byteString.size !== prefix.size)) {
          var message_0 = 'duplicate option: ' + byteString;
          throw IllegalArgumentException_init(message_0.toString());
        }if (indexes.get_za3lpa$(b) > indexes.get_za3lpa$(a)) {
          list.removeAt_za3lpa$(b);
          indexes.removeAt_za3lpa$(b);
        } else {
          b = b + 1 | 0;
        }
      }
      a = a + 1 | 0;
    }
    var trieBytes = new Buffer();
    this.buildTrieRecursive_0(void 0, trieBytes, void 0, list, void 0, void 0, indexes);
    var trie = new Int32Array(this.get_intCount_0(trieBytes).toInt());
    var i = 0;
    while (!trieBytes.exhausted()) {
      trie[tmp$ = i, i = tmp$ + 1 | 0, tmp$] = trieBytes.readInt();
    }
    return new Options(byteStrings.slice(), trie);
  };
  Options$Companion.prototype.buildTrieRecursive_0 = function (nodeOffset, node, byteStringOffset, byteStrings, fromIndex, toIndex, indexes) {
    if (nodeOffset === void 0)
      nodeOffset = L0;
    if (byteStringOffset === void 0)
      byteStringOffset = 0;
    if (fromIndex === void 0)
      fromIndex = 0;
    if (toIndex === void 0)
      toIndex = byteStrings.size;
    var tmp$, tmp$_0;
    if (!(fromIndex < toIndex)) {
      var message = 'Failed requirement.';
      throw IllegalArgumentException_init(message.toString());
    }for (var i = fromIndex; i < toIndex; i++) {
      if (!(byteStrings.get_za3lpa$(i).size >= byteStringOffset)) {
        var message_0 = 'Failed requirement.';
        throw IllegalArgumentException_init(message_0.toString());
      }}
    var fromIndex_0 = fromIndex;
    var from = byteStrings.get_za3lpa$(fromIndex_0);
    var to = byteStrings.get_za3lpa$(toIndex - 1 | 0);
    var prefixIndex = -1;
    if (byteStringOffset === from.size) {
      prefixIndex = indexes.get_za3lpa$(fromIndex_0);
      fromIndex_0 = fromIndex_0 + 1 | 0;
      from = byteStrings.get_za3lpa$(fromIndex_0);
    }if (from.get_za3lpa$(byteStringOffset) !== to.get_za3lpa$(byteStringOffset)) {
      var selectChoiceCount = 1;
      for (var i_0 = fromIndex_0 + 1 | 0; i_0 < toIndex; i_0++) {
        if (byteStrings.get_za3lpa$(i_0 - 1 | 0).get_za3lpa$(byteStringOffset) !== byteStrings.get_za3lpa$(i_0).get_za3lpa$(byteStringOffset)) {
          selectChoiceCount = selectChoiceCount + 1 | 0;
        }}
      var childNodesOffset = nodeOffset.add(this.get_intCount_0(node)).add(Kotlin.Long.fromInt(2)).add(Kotlin.Long.fromInt(selectChoiceCount * 2 | 0));
      node.writeInt_za3lpa$(selectChoiceCount);
      node.writeInt_za3lpa$(prefixIndex);
      for (var i_1 = fromIndex_0; i_1 < toIndex; i_1++) {
        var rangeByte = byteStrings.get_za3lpa$(i_1).get_za3lpa$(byteStringOffset);
        if (i_1 === fromIndex_0 || rangeByte !== byteStrings.get_za3lpa$(i_1 - 1 | 0).get_za3lpa$(byteStringOffset)) {
          node.writeInt_za3lpa$(rangeByte & 255);
        }}
      var childNodes = new Buffer();
      var rangeStart = fromIndex_0;
      while (rangeStart < toIndex) {
        var rangeByte_0 = byteStrings.get_za3lpa$(rangeStart).get_za3lpa$(byteStringOffset);
        var rangeEnd = toIndex;
        for (var i_2 = rangeStart + 1 | 0; i_2 < toIndex; i_2++) {
          if (rangeByte_0 !== byteStrings.get_za3lpa$(i_2).get_za3lpa$(byteStringOffset)) {
            rangeEnd = i_2;
            break;
          }}
        if ((rangeStart + 1 | 0) === rangeEnd && (byteStringOffset + 1 | 0) === byteStrings.get_za3lpa$(rangeStart).size) {
          node.writeInt_za3lpa$(indexes.get_za3lpa$(rangeStart));
        } else {
          node.writeInt_za3lpa$(-1 * childNodesOffset.add(this.get_intCount_0(childNodes)).toInt() | 0);
          this.buildTrieRecursive_0(childNodesOffset, childNodes, byteStringOffset + 1 | 0, byteStrings, rangeStart, rangeEnd, indexes);
        }
        rangeStart = rangeEnd;
      }
      node.writeAll_sby9nd$(childNodes);
    } else {
      var scanByteCount = 0;
      var a = from.size;
      var b = to.size;
      tmp$ = JsMath.min(a, b);
      for (var i_3 = byteStringOffset; i_3 < tmp$; i_3++) {
        if (from.get_za3lpa$(i_3) === to.get_za3lpa$(i_3)) {
          scanByteCount = scanByteCount + 1 | 0;
        } else {
          break;
        }
      }
      var childNodesOffset_0 = nodeOffset.add(this.get_intCount_0(node)).add(Kotlin.Long.fromInt(2)).add(Kotlin.Long.fromInt(scanByteCount)).add(Kotlin.Long.fromInt(1));
      node.writeInt_za3lpa$(-scanByteCount | 0);
      node.writeInt_za3lpa$(prefixIndex);
      tmp$_0 = byteStringOffset + scanByteCount | 0;
      for (var i_4 = byteStringOffset; i_4 < tmp$_0; i_4++) {
        node.writeInt_za3lpa$(from.get_za3lpa$(i_4) & 255);
      }
      if ((fromIndex_0 + 1 | 0) === toIndex) {
        if (!((byteStringOffset + scanByteCount | 0) === byteStrings.get_za3lpa$(fromIndex_0).size)) {
          var message_1 = 'Check failed.';
          throw IllegalStateException_init(message_1.toString());
        }node.writeInt_za3lpa$(indexes.get_za3lpa$(fromIndex_0));
      } else {
        var childNodes_0 = new Buffer();
        node.writeInt_za3lpa$(-1 * childNodesOffset_0.add(this.get_intCount_0(childNodes_0)).toInt() | 0);
        this.buildTrieRecursive_0(childNodesOffset_0, childNodes_0, byteStringOffset + scanByteCount | 0, byteStrings, fromIndex_0, toIndex, indexes);
        node.writeAll_sby9nd$(childNodes_0);
      }
    }
  };
  Options$Companion.prototype.get_intCount_0 = function ($receiver) {
    return $receiver.size.div(Kotlin.Long.fromInt(4));
  };
  Options$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Options$Companion_instance = null;
  function Options$Companion_getInstance() {
    if (Options$Companion_instance === null) {
      new Options$Companion();
    }return Options$Companion_instance;
  }
  Options.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Options',
    interfaces: [RandomAccess, AbstractList]
  };
  function PeekSource(upstream) {
    this.upstream_0 = upstream;
    this.buffer_0 = this.upstream_0.buffer;
    this.expectedSegment_0 = this.buffer_0.head_8be2vx$;
    var tmp$, tmp$_0;
    this.expectedPos_0 = (tmp$_0 = (tmp$ = this.buffer_0.head_8be2vx$) != null ? tmp$.pos : null) != null ? tmp$_0 : -1;
    this.closed_0 = false;
    this.pos_0 = L0;
  }
  PeekSource.prototype.read_u27jpl$ = function (sink, byteCount) {
    if (!(byteCount.compareTo_11rb$(L0) >= 0)) {
      var message = 'byteCount < 0: ' + byteCount.toString();
      throw IllegalArgumentException_init(message.toString());
    }if (!!this.closed_0) {
      var message_0 = 'closed';
      throw IllegalStateException_init(message_0.toString());
    }if (!(this.expectedSegment_0 == null || (this.expectedSegment_0 === this.buffer_0.head_8be2vx$ && this.expectedPos_0 === ensureNotNull(this.buffer_0.head_8be2vx$).pos))) {
      var message_1 = 'Peek source is invalid because upstream source was used';
      throw IllegalStateException_init(message_1.toString());
    }if (equals(byteCount, L0))
      return L0;
    if (!this.upstream_0.request_s8cxhz$(this.pos_0.add(Kotlin.Long.fromInt(1))))
      return L_1;
    if (this.expectedSegment_0 == null && this.buffer_0.head_8be2vx$ != null) {
      this.expectedSegment_0 = this.buffer_0.head_8be2vx$;
      this.expectedPos_0 = ensureNotNull(this.buffer_0.head_8be2vx$).pos;
    }var b = this.buffer_0.size.subtract(this.pos_0);
    var toCopy = byteCount.compareTo_11rb$(b) <= 0 ? byteCount : b;
    this.buffer_0.copyTo_ins7gm$(sink, this.pos_0, toCopy);
    this.pos_0 = this.pos_0.add(toCopy);
    return toCopy;
  };
  PeekSource.prototype.timeout = function () {
    return this.upstream_0.timeout();
  };
  PeekSource.prototype.close = function () {
    this.closed_0 = true;
  };
  PeekSource.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PeekSource',
    interfaces: [Source]
  };
  function Segment() {
    Segment$Companion_getInstance();
    this.data = null;
    this.pos = 0;
    this.limit = 0;
    this.shared = false;
    this.owner = false;
    this.next = null;
    this.prev = null;
  }
  Segment.prototype.sharedCopy = function () {
    this.shared = true;
    return Segment_init_0(this.data, this.pos, this.limit, true, false);
  };
  Segment.prototype.unsharedCopy = function () {
    return Segment_init_0(this.data.slice(), this.pos, this.limit, false, true);
  };
  Segment.prototype.pop = function () {
    var result = this.next !== this ? this.next : null;
    ensureNotNull(this.prev).next = this.next;
    ensureNotNull(this.next).prev = this.prev;
    this.next = null;
    this.prev = null;
    return result;
  };
  Segment.prototype.push_uve4t5$ = function (segment) {
    segment.prev = this;
    segment.next = this.next;
    ensureNotNull(this.next).prev = segment;
    this.next = segment;
    return segment;
  };
  Segment.prototype.split_za3lpa$ = function (byteCount) {
    if (!(byteCount > 0 && byteCount <= (this.limit - this.pos | 0))) {
      var message = 'byteCount out of range';
      throw IllegalArgumentException_init(message.toString());
    }var prefix;
    if (byteCount >= 1024) {
      prefix = this.sharedCopy();
    } else {
      prefix = SegmentPool_getInstance().take();
      arrayCopy(this.data, prefix.data, 0, this.pos, this.pos + byteCount | 0);
    }
    prefix.limit = prefix.pos + byteCount | 0;
    this.pos = this.pos + byteCount | 0;
    ensureNotNull(this.prev).push_uve4t5$(prefix);
    return prefix;
  };
  Segment.prototype.compact = function () {
    if (!(this.prev !== this)) {
      var message = 'cannot compact';
      throw IllegalStateException_init(message.toString());
    }if (!ensureNotNull(this.prev).owner)
      return;
    var byteCount = this.limit - this.pos | 0;
    var availableByteCount = 8192 - ensureNotNull(this.prev).limit + (ensureNotNull(this.prev).shared ? 0 : ensureNotNull(this.prev).pos) | 0;
    if (byteCount > availableByteCount)
      return;
    this.writeTo_l53ny1$(ensureNotNull(this.prev), byteCount);
    this.pop();
    SegmentPool_getInstance().recycle_uve4t5$(this);
  };
  Segment.prototype.writeTo_l53ny1$ = function (sink, byteCount) {
    if (!sink.owner) {
      var message = 'only owner can write';
      throw IllegalStateException_init(message.toString());
    }if ((sink.limit + byteCount | 0) > 8192) {
      if (sink.shared)
        throw IllegalArgumentException_init_0();
      if ((sink.limit + byteCount - sink.pos | 0) > 8192)
        throw IllegalArgumentException_init_0();
      arrayCopy(sink.data, sink.data, 0, sink.pos, sink.limit);
      sink.limit = sink.limit - sink.pos | 0;
      sink.pos = 0;
    }arrayCopy(this.data, sink.data, sink.limit, this.pos, this.pos + byteCount | 0);
    sink.limit = sink.limit + byteCount | 0;
    this.pos = this.pos + byteCount | 0;
  };
  function Segment$Companion() {
    Segment$Companion_instance = this;
    this.SIZE = 8192;
    this.SHARE_MINIMUM = 1024;
  }
  Segment$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Segment$Companion_instance = null;
  function Segment$Companion_getInstance() {
    if (Segment$Companion_instance === null) {
      new Segment$Companion();
    }return Segment$Companion_instance;
  }
  Segment.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Segment',
    interfaces: []
  };
  function Segment_init($this) {
    $this = $this || Object.create(Segment.prototype);
    Segment.call($this);
    $this.data = new Int8Array(8192);
    $this.owner = true;
    $this.shared = false;
    return $this;
  }
  function Segment_init_0(data, pos, limit, shared, owner, $this) {
    $this = $this || Object.create(Segment.prototype);
    Segment.call($this);
    $this.data = data;
    $this.pos = pos;
    $this.limit = limit;
    $this.shared = shared;
    $this.owner = owner;
    return $this;
  }
  function Source() {
  }
  Source.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Source',
    interfaces: [Closeable]
  };
  function utf8Size($receiver, beginIndex, endIndex) {
    if (beginIndex === void 0)
      beginIndex = 0;
    if (endIndex === void 0)
      endIndex = $receiver.length;
    if (!(beginIndex >= 0)) {
      var message = 'beginIndex < 0: ' + beginIndex;
      throw IllegalArgumentException_init(message.toString());
    }if (!(endIndex >= beginIndex)) {
      var message_0 = 'endIndex < beginIndex: ' + endIndex + ' < ' + beginIndex;
      throw IllegalArgumentException_init(message_0.toString());
    }if (!(endIndex <= $receiver.length)) {
      var message_1 = 'endIndex > string.length: ' + endIndex + ' > ' + $receiver.length;
      throw IllegalArgumentException_init(message_1.toString());
    }var result = L0;
    var i = beginIndex;
    while (i < endIndex) {
      var c = $receiver.charCodeAt(i) | 0;
      if (c < 128) {
        result = result.inc();
        i = i + 1 | 0;
      } else if (c < 2048) {
        result = result.add(Kotlin.Long.fromInt(2));
        i = i + 1 | 0;
      } else if (c < 55296 || c > 57343) {
        result = result.add(Kotlin.Long.fromInt(3));
        i = i + 1 | 0;
      } else {
        var low = (i + 1 | 0) < endIndex ? $receiver.charCodeAt(i + 1 | 0) | 0 : 0;
        if (c > 56319 || low < 56320 || low > 57343) {
          result = result.inc();
          i = i + 1 | 0;
        } else {
          result = result.add(Kotlin.Long.fromInt(4));
          i = i + 2 | 0;
        }
      }
    }
    return result;
  }
  var REPLACEMENT_BYTE;
  var REPLACEMENT_CHARACTER;
  var REPLACEMENT_CODE_POINT;
  var isIsoControl = defineInlineFunction('okio-parent-okio-js-legacy.okio.isIsoControl_kcn2v3$', function (codePoint) {
    return 0 <= codePoint && codePoint <= 31 || (127 <= codePoint && codePoint <= 159);
  });
  var isUtf8Continuation = defineInlineFunction('okio-parent-okio-js-legacy.okio.isUtf8Continuation_8e99oo$', function (byte) {
    return (byte & 192) === 128;
  });
  var processUtf8Bytes = defineInlineFunction('okio-parent-okio-js-legacy.okio.processUtf8Bytes_cepy5y$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var CharRange = Kotlin.kotlin.ranges.CharRange;
    var okio = _.okio;
    return function ($receiver, beginIndex, endIndex, yield_0) {
      var tmp$;
      var index = beginIndex;
      while (index < endIndex) {
        var c = $receiver.charCodeAt(index);
        if (c < 128) {
          yield_0(toByte(c | 0));
          index = index + 1 | 0;
          while (index < endIndex && $receiver.charCodeAt(index) < 128) {
            yield_0(toByte($receiver.charCodeAt((tmp$ = index, index = tmp$ + 1 | 0, tmp$)) | 0));
          }
        } else if (c < 2048) {
          yield_0(toByte((c | 0) >> 6 | 192));
          yield_0(toByte((c | 0) & 63 | 128));
          index = index + 1 | 0;
        } else if (!(new CharRange(55296, 57343)).contains_mef7kx$(c)) {
          yield_0(toByte((c | 0) >> 12 | 224));
          yield_0(toByte((c | 0) >> 6 & 63 | 128));
          yield_0(toByte((c | 0) & 63 | 128));
          index = index + 1 | 0;
        } else {
          if (c > 56319 || endIndex <= (index + 1 | 0) || !(new CharRange(56320, 57343)).contains_mef7kx$($receiver.charCodeAt(index + 1 | 0))) {
            yield_0(okio.REPLACEMENT_BYTE_8be2vx$);
            index = index + 1 | 0;
          } else {
            var codePoint = ((c | 0) << 10) + ($receiver.charCodeAt(index + 1 | 0) | 0) + -56613888 | 0;
            yield_0(toByte(codePoint >> 18 | 240));
            yield_0(toByte(codePoint >> 12 & 63 | 128));
            yield_0(toByte(codePoint >> 6 & 63 | 128));
            yield_0(toByte(codePoint & 63 | 128));
            index = index + 2 | 0;
          }
        }
      }
    };
  }));
  var processUtf8CodePoints = defineInlineFunction('okio-parent-okio-js-legacy.okio.processUtf8CodePoints_nbe8nt$', function ($receiver, beginIndex, endIndex, yield_0) {
    var tmp$;
    var index = beginIndex;
    loop_label: while (index < endIndex) {
      var b0 = $receiver[index];
      if (b0 >= 0) {
        yield_0(b0);
        index = index + 1 | 0;
        while (index < endIndex && $receiver[index] >= 0) {
          yield_0($receiver[tmp$ = index, index = tmp$ + 1 | 0, tmp$]);
        }
      } else {
        if (b0 >> 5 === -2) {
          var tmp$_0 = index;
          var beginIndex_0 = index;
          var process2Utf8Bytes$result;
          process2Utf8Bytes$break: do {
            if (endIndex <= (beginIndex_0 + 1 | 0)) {
              yield_0(65533);
              process2Utf8Bytes$result = 1;
              break process2Utf8Bytes$break;
            }var b0_0 = $receiver[beginIndex_0];
            var b1 = $receiver[beginIndex_0 + 1 | 0];
            if (!((b1 & 192) === 128)) {
              yield_0(65533);
              process2Utf8Bytes$result = 1;
              break process2Utf8Bytes$break;
            }var codePoint = 3968 ^ b1 ^ b0_0 << 6;
            if (codePoint < 128) {
              yield_0(65533);
            } else {
              yield_0(codePoint);
            }
            process2Utf8Bytes$result = 2;
          }
           while (false);
          index = tmp$_0 + process2Utf8Bytes$result | 0;
        } else {
          if (b0 >> 4 === -2) {
            var tmp$_1 = index;
            var beginIndex_1 = index;
            var process3Utf8Bytes$result;
            process3Utf8Bytes$break: do {
              if (endIndex <= (beginIndex_1 + 2 | 0)) {
                yield_0(65533);
                var tmp$_2 = endIndex <= (beginIndex_1 + 1 | 0);
                if (!tmp$_2) {
                  tmp$_2 = !(($receiver[beginIndex_1 + 1 | 0] & 192) === 128);
                }if (tmp$_2) {
                  process3Utf8Bytes$result = 1;
                  break process3Utf8Bytes$break;
                } else {
                  process3Utf8Bytes$result = 2;
                  break process3Utf8Bytes$break;
                }
              }var b0_1 = $receiver[beginIndex_1];
              var b1_0 = $receiver[beginIndex_1 + 1 | 0];
              if (!((b1_0 & 192) === 128)) {
                yield_0(65533);
                process3Utf8Bytes$result = 1;
                break process3Utf8Bytes$break;
              }var b2 = $receiver[beginIndex_1 + 2 | 0];
              if (!((b2 & 192) === 128)) {
                yield_0(65533);
                process3Utf8Bytes$result = 2;
                break process3Utf8Bytes$break;
              }var codePoint_0 = -123008 ^ b2 ^ b1_0 << 6 ^ b0_1 << 12;
              if (codePoint_0 < 2048) {
                yield_0(65533);
              } else if (55296 <= codePoint_0 && codePoint_0 <= 57343) {
                yield_0(65533);
              } else {
                yield_0(codePoint_0);
              }
              process3Utf8Bytes$result = 3;
            }
             while (false);
            index = tmp$_1 + process3Utf8Bytes$result | 0;
          } else {
            if (b0 >> 3 === -2) {
              var tmp$_3 = index;
              var beginIndex_2 = index;
              var process4Utf8Bytes$result;
              process4Utf8Bytes$break: do {
                if (endIndex <= (beginIndex_2 + 3 | 0)) {
                  yield_0(65533);
                  var tmp$_4 = endIndex <= (beginIndex_2 + 1 | 0);
                  if (!tmp$_4) {
                    tmp$_4 = !(($receiver[beginIndex_2 + 1 | 0] & 192) === 128);
                  }if (tmp$_4) {
                    process4Utf8Bytes$result = 1;
                    break process4Utf8Bytes$break;
                  } else {
                    var tmp$_5 = endIndex <= (beginIndex_2 + 2 | 0);
                    if (!tmp$_5) {
                      tmp$_5 = !(($receiver[beginIndex_2 + 2 | 0] & 192) === 128);
                    }if (tmp$_5) {
                      process4Utf8Bytes$result = 2;
                      break process4Utf8Bytes$break;
                    } else {
                      process4Utf8Bytes$result = 3;
                      break process4Utf8Bytes$break;
                    }
                  }
                }var b0_2 = $receiver[beginIndex_2];
                var b1_1 = $receiver[beginIndex_2 + 1 | 0];
                if (!((b1_1 & 192) === 128)) {
                  yield_0(65533);
                  process4Utf8Bytes$result = 1;
                  break process4Utf8Bytes$break;
                }var b2_0 = $receiver[beginIndex_2 + 2 | 0];
                if (!((b2_0 & 192) === 128)) {
                  yield_0(65533);
                  process4Utf8Bytes$result = 2;
                  break process4Utf8Bytes$break;
                }var b3 = $receiver[beginIndex_2 + 3 | 0];
                if (!((b3 & 192) === 128)) {
                  yield_0(65533);
                  process4Utf8Bytes$result = 3;
                  break process4Utf8Bytes$break;
                }var codePoint_1 = 3678080 ^ b3 ^ b2_0 << 6 ^ b1_1 << 12 ^ b0_2 << 18;
                if (codePoint_1 > 1114111) {
                  yield_0(65533);
                } else if (55296 <= codePoint_1 && codePoint_1 <= 57343) {
                  yield_0(65533);
                } else if (codePoint_1 < 65536) {
                  yield_0(65533);
                } else {
                  yield_0(codePoint_1);
                }
                process4Utf8Bytes$result = 4;
              }
               while (false);
              index = tmp$_3 + process4Utf8Bytes$result | 0;
            } else {
              yield_0(65533);
              index = index + 1 | 0;
            }
          }
        }
      }
    }
  });
  var HIGH_SURROGATE_HEADER;
  var LOG_SURROGATE_HEADER;
  var processUtf16Chars = defineInlineFunction('okio-parent-okio-js-legacy.okio.processUtf16Chars_2iasp0$', wrapFunction(function () {
    var toChar = Kotlin.toChar;
    var toBoxedChar = Kotlin.toBoxedChar;
    var okio = _.okio;
    return function ($receiver, beginIndex, endIndex, yield_0) {
      var tmp$;
      var index = beginIndex;
      loop_label: while (index < endIndex) {
        var b0 = $receiver[index];
        if (b0 >= 0) {
          yield_0(toBoxedChar(toChar(b0)));
          index = index + 1 | 0;
          while (index < endIndex && $receiver[index] >= 0) {
            yield_0(toBoxedChar(toChar($receiver[tmp$ = index, index = tmp$ + 1 | 0, tmp$])));
          }
        } else {
          if (b0 >> 5 === -2) {
            var tmp$_0 = index;
            var beginIndex_0 = index;
            var process2Utf8Bytes$result;
            process2Utf8Bytes$break: do {
              if (endIndex <= (beginIndex_0 + 1 | 0)) {
                yield_0(toBoxedChar(toChar(65533)));
                process2Utf8Bytes$result = 1;
                break process2Utf8Bytes$break;
              }var b0_0 = $receiver[beginIndex_0];
              var b1 = $receiver[beginIndex_0 + 1 | 0];
              if (!((b1 & 192) === 128)) {
                yield_0(toBoxedChar(toChar(65533)));
                process2Utf8Bytes$result = 1;
                break process2Utf8Bytes$break;
              }var codePoint = 3968 ^ b1 ^ b0_0 << 6;
              if (codePoint < 128) {
                yield_0(toBoxedChar(toChar(65533)));
              } else {
                yield_0(toBoxedChar(toChar(codePoint)));
              }
              process2Utf8Bytes$result = 2;
            }
             while (false);
            index = tmp$_0 + process2Utf8Bytes$result | 0;
          } else {
            if (b0 >> 4 === -2) {
              var tmp$_1 = index;
              var beginIndex_1 = index;
              var process3Utf8Bytes$result;
              process3Utf8Bytes$break: do {
                if (endIndex <= (beginIndex_1 + 2 | 0)) {
                  yield_0(toBoxedChar(toChar(65533)));
                  var tmp$_2 = endIndex <= (beginIndex_1 + 1 | 0);
                  if (!tmp$_2) {
                    tmp$_2 = !(($receiver[beginIndex_1 + 1 | 0] & 192) === 128);
                  }if (tmp$_2) {
                    process3Utf8Bytes$result = 1;
                    break process3Utf8Bytes$break;
                  } else {
                    process3Utf8Bytes$result = 2;
                    break process3Utf8Bytes$break;
                  }
                }var b0_1 = $receiver[beginIndex_1];
                var b1_0 = $receiver[beginIndex_1 + 1 | 0];
                if (!((b1_0 & 192) === 128)) {
                  yield_0(toBoxedChar(toChar(65533)));
                  process3Utf8Bytes$result = 1;
                  break process3Utf8Bytes$break;
                }var b2 = $receiver[beginIndex_1 + 2 | 0];
                if (!((b2 & 192) === 128)) {
                  yield_0(toBoxedChar(toChar(65533)));
                  process3Utf8Bytes$result = 2;
                  break process3Utf8Bytes$break;
                }var codePoint_0 = -123008 ^ b2 ^ b1_0 << 6 ^ b0_1 << 12;
                if (codePoint_0 < 2048) {
                  yield_0(toBoxedChar(toChar(65533)));
                } else if (55296 <= codePoint_0 && codePoint_0 <= 57343) {
                  yield_0(toBoxedChar(toChar(65533)));
                } else {
                  yield_0(toBoxedChar(toChar(codePoint_0)));
                }
                process3Utf8Bytes$result = 3;
              }
               while (false);
              index = tmp$_1 + process3Utf8Bytes$result | 0;
            } else {
              if (b0 >> 3 === -2) {
                var tmp$_3 = index;
                var beginIndex_2 = index;
                var process4Utf8Bytes$result;
                process4Utf8Bytes$break: do {
                  if (endIndex <= (beginIndex_2 + 3 | 0)) {
                    if (65533 !== 65533) {
                      yield_0(toBoxedChar(toChar((65533 >>> 10) + 55232 | 0)));
                      yield_0(toBoxedChar(toChar((65533 & 1023) + 56320 | 0)));
                    } else {
                      yield_0(toBoxedChar(okio.REPLACEMENT_CHARACTER_8be2vx$));
                    }
                    var tmp$_4 = endIndex <= (beginIndex_2 + 1 | 0);
                    if (!tmp$_4) {
                      tmp$_4 = !(($receiver[beginIndex_2 + 1 | 0] & 192) === 128);
                    }if (tmp$_4) {
                      process4Utf8Bytes$result = 1;
                      break process4Utf8Bytes$break;
                    } else {
                      var tmp$_5 = endIndex <= (beginIndex_2 + 2 | 0);
                      if (!tmp$_5) {
                        tmp$_5 = !(($receiver[beginIndex_2 + 2 | 0] & 192) === 128);
                      }if (tmp$_5) {
                        process4Utf8Bytes$result = 2;
                        break process4Utf8Bytes$break;
                      } else {
                        process4Utf8Bytes$result = 3;
                        break process4Utf8Bytes$break;
                      }
                    }
                  }var b0_2 = $receiver[beginIndex_2];
                  var b1_1 = $receiver[beginIndex_2 + 1 | 0];
                  if (!((b1_1 & 192) === 128)) {
                    if (65533 !== 65533) {
                      yield_0(toBoxedChar(toChar((65533 >>> 10) + 55232 | 0)));
                      yield_0(toBoxedChar(toChar((65533 & 1023) + 56320 | 0)));
                    } else {
                      yield_0(toBoxedChar(okio.REPLACEMENT_CHARACTER_8be2vx$));
                    }
                    process4Utf8Bytes$result = 1;
                    break process4Utf8Bytes$break;
                  }var b2_0 = $receiver[beginIndex_2 + 2 | 0];
                  if (!((b2_0 & 192) === 128)) {
                    if (65533 !== 65533) {
                      yield_0(toBoxedChar(toChar((65533 >>> 10) + 55232 | 0)));
                      yield_0(toBoxedChar(toChar((65533 & 1023) + 56320 | 0)));
                    } else {
                      yield_0(toBoxedChar(okio.REPLACEMENT_CHARACTER_8be2vx$));
                    }
                    process4Utf8Bytes$result = 2;
                    break process4Utf8Bytes$break;
                  }var b3 = $receiver[beginIndex_2 + 3 | 0];
                  if (!((b3 & 192) === 128)) {
                    if (65533 !== 65533) {
                      yield_0(toBoxedChar(toChar((65533 >>> 10) + 55232 | 0)));
                      yield_0(toBoxedChar(toChar((65533 & 1023) + 56320 | 0)));
                    } else {
                      yield_0(toBoxedChar(okio.REPLACEMENT_CHARACTER_8be2vx$));
                    }
                    process4Utf8Bytes$result = 3;
                    break process4Utf8Bytes$break;
                  }var codePoint_1 = 3678080 ^ b3 ^ b2_0 << 6 ^ b1_1 << 12 ^ b0_2 << 18;
                  if (codePoint_1 > 1114111) {
                    if (65533 !== 65533) {
                      yield_0(toBoxedChar(toChar((65533 >>> 10) + 55232 | 0)));
                      yield_0(toBoxedChar(toChar((65533 & 1023) + 56320 | 0)));
                    } else {
                      yield_0(toBoxedChar(okio.REPLACEMENT_CHARACTER_8be2vx$));
                    }
                  } else if (55296 <= codePoint_1 && codePoint_1 <= 57343) {
                    if (65533 !== 65533) {
                      yield_0(toBoxedChar(toChar((65533 >>> 10) + 55232 | 0)));
                      yield_0(toBoxedChar(toChar((65533 & 1023) + 56320 | 0)));
                    } else {
                      yield_0(toBoxedChar(okio.REPLACEMENT_CHARACTER_8be2vx$));
                    }
                  } else if (codePoint_1 < 65536) {
                    if (65533 !== 65533) {
                      yield_0(toBoxedChar(toChar((65533 >>> 10) + 55232 | 0)));
                      yield_0(toBoxedChar(toChar((65533 & 1023) + 56320 | 0)));
                    } else {
                      yield_0(toBoxedChar(okio.REPLACEMENT_CHARACTER_8be2vx$));
                    }
                  } else {
                    if (codePoint_1 !== 65533) {
                      yield_0(toBoxedChar(toChar((codePoint_1 >>> 10) + 55232 | 0)));
                      yield_0(toBoxedChar(toChar((codePoint_1 & 1023) + 56320 | 0)));
                    } else {
                      yield_0(toBoxedChar(okio.REPLACEMENT_CHARACTER_8be2vx$));
                    }
                  }
                  process4Utf8Bytes$result = 4;
                }
                 while (false);
                index = tmp$_3 + process4Utf8Bytes$result | 0;
              } else {
                yield_0(toBoxedChar(okio.REPLACEMENT_CHARACTER_8be2vx$));
                index = index + 1 | 0;
              }
            }
          }
        }
      }
    };
  }));
  var MASK_2BYTES;
  var process2Utf8Bytes = defineInlineFunction('okio-parent-okio-js-legacy.okio.process2Utf8Bytes_nbe8nt$', function ($receiver, beginIndex, endIndex, yield_0) {
    if (endIndex <= (beginIndex + 1 | 0)) {
      yield_0(65533);
      return 1;
    }var b0 = $receiver[beginIndex];
    var b1 = $receiver[beginIndex + 1 | 0];
    if (!((b1 & 192) === 128)) {
      yield_0(65533);
      return 1;
    }var codePoint = 3968 ^ b1 ^ b0 << 6;
    if (codePoint < 128)
      yield_0(65533);
    else {
      yield_0(codePoint);
    }
    return 2;
  });
  var MASK_3BYTES;
  var process3Utf8Bytes = defineInlineFunction('okio-parent-okio-js-legacy.okio.process3Utf8Bytes_nbe8nt$', function ($receiver, beginIndex, endIndex, yield_0) {
    if (endIndex <= (beginIndex + 2 | 0)) {
      yield_0(65533);
      var tmp$ = endIndex <= (beginIndex + 1 | 0);
      if (!tmp$) {
        tmp$ = !(($receiver[beginIndex + 1 | 0] & 192) === 128);
      }if (tmp$) {
        return 1;
      } else {
        return 2;
      }
    }var b0 = $receiver[beginIndex];
    var b1 = $receiver[beginIndex + 1 | 0];
    if (!((b1 & 192) === 128)) {
      yield_0(65533);
      return 1;
    }var b2 = $receiver[beginIndex + 2 | 0];
    if (!((b2 & 192) === 128)) {
      yield_0(65533);
      return 2;
    }var codePoint = -123008 ^ b2 ^ b1 << 6 ^ b0 << 12;
    if (codePoint < 2048)
      yield_0(65533);
    else if (55296 <= codePoint && codePoint <= 57343)
      yield_0(65533);
    else {
      yield_0(codePoint);
    }
    return 3;
  });
  var MASK_4BYTES;
  var process4Utf8Bytes = defineInlineFunction('okio-parent-okio-js-legacy.okio.process4Utf8Bytes_nbe8nt$', function ($receiver, beginIndex, endIndex, yield_0) {
    if (endIndex <= (beginIndex + 3 | 0)) {
      yield_0(65533);
      var tmp$ = endIndex <= (beginIndex + 1 | 0);
      if (!tmp$) {
        tmp$ = !(($receiver[beginIndex + 1 | 0] & 192) === 128);
      }if (tmp$) {
        return 1;
      } else {
        var tmp$_0 = endIndex <= (beginIndex + 2 | 0);
        if (!tmp$_0) {
          tmp$_0 = !(($receiver[beginIndex + 2 | 0] & 192) === 128);
        }if (tmp$_0) {
          return 2;
        } else {
          return 3;
        }
      }
    }var b0 = $receiver[beginIndex];
    var b1 = $receiver[beginIndex + 1 | 0];
    if (!((b1 & 192) === 128)) {
      yield_0(65533);
      return 1;
    }var b2 = $receiver[beginIndex + 2 | 0];
    if (!((b2 & 192) === 128)) {
      yield_0(65533);
      return 2;
    }var b3 = $receiver[beginIndex + 3 | 0];
    if (!((b3 & 192) === 128)) {
      yield_0(65533);
      return 3;
    }var codePoint = 3678080 ^ b3 ^ b2 << 6 ^ b1 << 12 ^ b0 << 18;
    if (codePoint > 1114111)
      yield_0(65533);
    else if (55296 <= codePoint && codePoint <= 57343)
      yield_0(65533);
    else if (codePoint < 65536)
      yield_0(65533);
    else {
      yield_0(codePoint);
    }
    return 4;
  });
  var HEX_DIGIT_BYTES;
  var SEGMENTING_THRESHOLD;
  function rangeEquals(segment, segmentPos, bytes, bytesOffset, bytesLimit) {
    var segment_0 = segment;
    var segmentPos_0 = segmentPos;
    var segmentLimit = segment_0.limit;
    var data = segment_0.data;
    var i = bytesOffset;
    while (i < bytesLimit) {
      if (segmentPos_0 === segmentLimit) {
        segment_0 = ensureNotNull(segment_0.next);
        data = segment_0.data;
        segmentPos_0 = segment_0.pos;
        segmentLimit = segment_0.limit;
      }if (data[segmentPos_0] !== bytes[i]) {
        return false;
      }segmentPos_0 = segmentPos_0 + 1 | 0;
      i = i + 1 | 0;
    }
    return true;
  }
  function readUtf8Line($receiver, newline) {
    var tmp$;
    if (newline.toNumber() > 0 && $receiver.get_s8cxhz$(newline.subtract(Kotlin.Long.fromInt(1))) === toByte(13)) {
      var result = $receiver.readUtf8_s8cxhz$(newline.subtract(L1));
      $receiver.skip_s8cxhz$(L2);
      tmp$ = result;
    } else {
      var result_0 = $receiver.readUtf8_s8cxhz$(newline);
      $receiver.skip_s8cxhz$(L1);
      tmp$ = result_0;
    }
    return tmp$;
  }
  var seek = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.seek_r6jk9a$', wrapFunction(function () {
    var L_1 = Kotlin.Long.NEG_ONE;
    var ensureNotNull = Kotlin.ensureNotNull;
    var L0 = Kotlin.Long.ZERO;
    return function ($receiver, fromIndex, lambda) {
      var tmp$;
      tmp$ = $receiver.head_8be2vx$;
      if (tmp$ == null) {
        return lambda(null, L_1);
      }var s = tmp$;
      if ($receiver.size.subtract(fromIndex).compareTo_11rb$(fromIndex) < 0) {
        var offset = $receiver.size;
        while (offset.compareTo_11rb$(fromIndex) > 0) {
          s = ensureNotNull(s.prev);
          offset = offset.subtract(Kotlin.Long.fromInt(s.limit - s.pos | 0));
        }
        return lambda(s, offset);
      } else {
        var offset_0 = L0;
        while (true) {
          var nextOffset = offset_0.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
          if (nextOffset.compareTo_11rb$(fromIndex) > 0)
            break;
          s = ensureNotNull(s.next);
          offset_0 = nextOffset;
        }
        return lambda(s, offset_0);
      }
    };
  }));
  function selectPrefix($receiver, options, selectTruncated) {
    if (selectTruncated === void 0)
      selectTruncated = false;
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    tmp$ = $receiver.head_8be2vx$;
    if (tmp$ == null) {
      return selectTruncated ? -2 : -1;
    }var head = tmp$;
    var s = head;
    var data = head.data;
    var pos = head.pos;
    var limit = head.limit;
    var trie = options.trie_8be2vx$;
    var triePos = 0;
    var prefixIndex = -1;
    navigateTrie: while (true) {
      var scanOrSelect = trie[tmp$_0 = triePos, triePos = tmp$_0 + 1 | 0, tmp$_0];
      var possiblePrefixIndex = trie[tmp$_1 = triePos, triePos = tmp$_1 + 1 | 0, tmp$_1];
      if (possiblePrefixIndex !== -1) {
        prefixIndex = possiblePrefixIndex;
      }var nextStep;
      if (s == null) {
        break navigateTrie;
      } else if (scanOrSelect < 0) {
        var scanByteCount = -1 * scanOrSelect | 0;
        var trieLimit = triePos + scanByteCount | 0;
        while (true) {
          var byte = data[tmp$_2 = pos, pos = tmp$_2 + 1 | 0, tmp$_2] & 255;
          if (byte !== trie[tmp$_3 = triePos, triePos = tmp$_3 + 1 | 0, tmp$_3])
            return prefixIndex;
          var scanComplete = triePos === trieLimit;
          if (pos === limit) {
            s = ensureNotNull(ensureNotNull(s).next);
            pos = s.pos;
            data = s.data;
            limit = s.limit;
            if (s === head) {
              if (!scanComplete)
                break navigateTrie;
              s = null;
            }}if (scanComplete) {
            nextStep = trie[triePos];
            break;
          }}
      } else {
        var selectChoiceCount = scanOrSelect;
        var byte_0 = data[tmp$_4 = pos, pos = tmp$_4 + 1 | 0, tmp$_4] & 255;
        var selectLimit = triePos + selectChoiceCount | 0;
        while (true) {
          if (triePos === selectLimit)
            return prefixIndex;
          if (byte_0 === trie[triePos]) {
            nextStep = trie[triePos + selectChoiceCount | 0];
            break;
          }triePos = triePos + 1 | 0;
        }
        if (pos === limit) {
          s = ensureNotNull(s.next);
          pos = s.pos;
          data = s.data;
          limit = s.limit;
          if (s === head) {
            s = null;
          }}}
      if (nextStep >= 0)
        return nextStep;
      triePos = -nextStep | 0;
    }
    if (selectTruncated)
      return -2;
    return prefixIndex;
  }
  var commonCopyTo = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonCopyTo_23acee$', wrapFunction(function () {
    var checkOffsetAndCount = _.okio.checkOffsetAndCount_e84ct6$;
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var ensureNotNull = Kotlin.ensureNotNull;
    var JsMath = Math;
    return function ($receiver, out, offset, byteCount) {
      var offset_0 = offset;
      var byteCount_0 = byteCount;
      checkOffsetAndCount($receiver.size, offset_0, byteCount_0);
      if (equals(byteCount_0, L0))
        return $receiver;
      out.size = out.size.add(byteCount_0);
      var s = $receiver.head_8be2vx$;
      while (offset_0.toNumber() >= (ensureNotNull(s).limit - s.pos | 0)) {
        offset_0 = offset_0.subtract(Kotlin.Long.fromInt(s.limit - s.pos | 0));
        s = s.next;
      }
      while (byteCount_0.compareTo_11rb$(L0) > 0) {
        var copy = ensureNotNull(s).sharedCopy();
        copy.pos = copy.pos + offset_0.toInt() | 0;
        var a = copy.pos + byteCount_0.toInt() | 0;
        var b = copy.limit;
        copy.limit = JsMath.min(a, b);
        if (out.head_8be2vx$ == null) {
          copy.prev = copy;
          copy.next = copy.prev;
          out.head_8be2vx$ = copy.next;
        } else {
          ensureNotNull(ensureNotNull(out.head_8be2vx$).prev).push_uve4t5$(copy);
        }
        byteCount_0 = byteCount_0.subtract(Kotlin.Long.fromInt(copy.limit - copy.pos | 0));
        offset_0 = L0;
        s = s.next;
      }
      return $receiver;
    };
  }));
  var commonCompleteSegmentByteCount = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonCompleteSegmentByteCount_cx6lq8$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var ensureNotNull = Kotlin.ensureNotNull;
    return function ($receiver) {
      var result = $receiver.size;
      if (equals(result, L0))
        return L0;
      var tail = ensureNotNull(ensureNotNull($receiver.head_8be2vx$).prev);
      if (tail.limit < 8192 && tail.owner) {
        result = result.subtract(Kotlin.Long.fromInt(tail.limit - tail.pos | 0));
      }return result;
    };
  }));
  var commonReadByte = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadByte_cx6lq8$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var EOFException_init = _.okio.EOFException;
    var ensureNotNull = Kotlin.ensureNotNull;
    var L1 = Kotlin.Long.ONE;
    var okio = _.okio;
    return function ($receiver) {
      var tmp$;
      if (equals($receiver.size, L0))
        throw new EOFException_init();
      var segment = ensureNotNull($receiver.head_8be2vx$);
      var pos = segment.pos;
      var limit = segment.limit;
      var data = segment.data;
      var b = data[tmp$ = pos, pos = tmp$ + 1 | 0, tmp$];
      $receiver.size = $receiver.size.subtract(L1);
      if (pos === limit) {
        $receiver.head_8be2vx$ = segment.pop();
        okio.SegmentPool.recycle_uve4t5$(segment);
      } else {
        segment.pos = pos;
      }
      return b;
    };
  }));
  var commonReadShort = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadShort_cx6lq8$', wrapFunction(function () {
    var L2 = Kotlin.Long.fromInt(2);
    var EOFException_init = _.okio.EOFException;
    var ensureNotNull = Kotlin.ensureNotNull;
    var toShort = Kotlin.toShort;
    var okio = _.okio;
    return function ($receiver) {
      var tmp$, tmp$_0;
      if ($receiver.size.compareTo_11rb$(L2) < 0)
        throw new EOFException_init();
      var segment = ensureNotNull($receiver.head_8be2vx$);
      var pos = segment.pos;
      var limit = segment.limit;
      if ((limit - pos | 0) < 2) {
        var s = ($receiver.readByte() & 255) << 8 | $receiver.readByte() & 255;
        return toShort(s);
      }var data = segment.data;
      var s_0 = (data[tmp$ = pos, pos = tmp$ + 1 | 0, tmp$] & 255) << 8 | data[tmp$_0 = pos, pos = tmp$_0 + 1 | 0, tmp$_0] & 255;
      $receiver.size = $receiver.size.subtract(L2);
      if (pos === limit) {
        $receiver.head_8be2vx$ = segment.pop();
        okio.SegmentPool.recycle_uve4t5$(segment);
      } else {
        segment.pos = pos;
      }
      return toShort(s_0);
    };
  }));
  var commonReadInt = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadInt_cx6lq8$', wrapFunction(function () {
    var L4 = Kotlin.Long.fromInt(4);
    var EOFException_init = _.okio.EOFException;
    var ensureNotNull = Kotlin.ensureNotNull;
    var okio = _.okio;
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      if ($receiver.size.compareTo_11rb$(L4) < 0)
        throw new EOFException_init();
      var segment = ensureNotNull($receiver.head_8be2vx$);
      var pos = segment.pos;
      var limit = segment.limit;
      if ((limit - pos | 0) < L4.toNumber()) {
        return ($receiver.readByte() & 255) << 24 | ($receiver.readByte() & 255) << 16 | ($receiver.readByte() & 255) << 8 | $receiver.readByte() & 255;
      }var data = segment.data;
      var i = (data[tmp$ = pos, pos = tmp$ + 1 | 0, tmp$] & 255) << 24 | (data[tmp$_0 = pos, pos = tmp$_0 + 1 | 0, tmp$_0] & 255) << 16 | (data[tmp$_1 = pos, pos = tmp$_1 + 1 | 0, tmp$_1] & 255) << 8 | data[tmp$_2 = pos, pos = tmp$_2 + 1 | 0, tmp$_2] & 255;
      $receiver.size = $receiver.size.subtract(L4);
      if (pos === limit) {
        $receiver.head_8be2vx$ = segment.pop();
        okio.SegmentPool.recycle_uve4t5$(segment);
      } else {
        segment.pos = pos;
      }
      return i;
    };
  }));
  var commonReadLong = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadLong_cx6lq8$', wrapFunction(function () {
    var L8 = Kotlin.Long.fromInt(8);
    var EOFException_init = _.okio.EOFException;
    var ensureNotNull = Kotlin.ensureNotNull;
    var L4294967295 = new Kotlin.Long(-1, 0);
    var L255 = Kotlin.Long.fromInt(255);
    var okio = _.okio;
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8, tmp$_9, tmp$_10, tmp$_11, tmp$_12, tmp$_13;
      if ($receiver.size.compareTo_11rb$(L8) < 0)
        throw new EOFException_init();
      var segment = ensureNotNull($receiver.head_8be2vx$);
      var pos = segment.pos;
      var limit = segment.limit;
      if ((limit - pos | 0) < L8.toNumber()) {
        var $receiver_0 = $receiver.readInt();
        var other = L4294967295;
        var tmp$_14 = Kotlin.Long.fromInt($receiver_0).and(other).shiftLeft(32);
        var $receiver_1 = $receiver.readInt();
        var other_0 = L4294967295;
        return tmp$_14.or(Kotlin.Long.fromInt($receiver_1).and(other_0));
      }var data = segment.data;
      var $receiver_2 = data[tmp$ = pos, pos = tmp$ + 1 | 0, tmp$];
      var other_1 = L255;
      tmp$_1 = Kotlin.Long.fromInt($receiver_2).and(other_1).shiftLeft(56);
      var $receiver_3 = data[tmp$_0 = pos, pos = tmp$_0 + 1 | 0, tmp$_0];
      var other_2 = L255;
      tmp$_3 = tmp$_1.or(Kotlin.Long.fromInt($receiver_3).and(other_2).shiftLeft(48));
      var $receiver_4 = data[tmp$_2 = pos, pos = tmp$_2 + 1 | 0, tmp$_2];
      var other_3 = L255;
      tmp$_5 = tmp$_3.or(Kotlin.Long.fromInt($receiver_4).and(other_3).shiftLeft(40));
      var $receiver_5 = data[tmp$_4 = pos, pos = tmp$_4 + 1 | 0, tmp$_4];
      var other_4 = L255;
      tmp$_7 = tmp$_5.or(Kotlin.Long.fromInt($receiver_5).and(other_4).shiftLeft(32));
      var $receiver_6 = data[tmp$_6 = pos, pos = tmp$_6 + 1 | 0, tmp$_6];
      var other_5 = L255;
      tmp$_9 = tmp$_7.or(Kotlin.Long.fromInt($receiver_6).and(other_5).shiftLeft(24));
      var $receiver_7 = data[tmp$_8 = pos, pos = tmp$_8 + 1 | 0, tmp$_8];
      var other_6 = L255;
      tmp$_11 = tmp$_9.or(Kotlin.Long.fromInt($receiver_7).and(other_6).shiftLeft(16));
      var $receiver_8 = data[tmp$_10 = pos, pos = tmp$_10 + 1 | 0, tmp$_10];
      var other_7 = L255;
      tmp$_13 = tmp$_11.or(Kotlin.Long.fromInt($receiver_8).and(other_7).shiftLeft(8));
      var $receiver_9 = data[tmp$_12 = pos, pos = tmp$_12 + 1 | 0, tmp$_12];
      var other_8 = L255;
      var v = tmp$_13.or(Kotlin.Long.fromInt($receiver_9).and(other_8));
      $receiver.size = $receiver.size.subtract(L8);
      if (pos === limit) {
        $receiver.head_8be2vx$ = segment.pop();
        okio.SegmentPool.recycle_uve4t5$(segment);
      } else {
        segment.pos = pos;
      }
      return v;
    };
  }));
  var commonGet = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonGet_rqsa21$', wrapFunction(function () {
    var L1 = Kotlin.Long.ONE;
    var checkOffsetAndCount = _.okio.checkOffsetAndCount_e84ct6$;
    var ensureNotNull = Kotlin.ensureNotNull;
    var L_1 = Kotlin.Long.NEG_ONE;
    var L0 = Kotlin.Long.ZERO;
    return function ($receiver, pos) {
      checkOffsetAndCount($receiver.size, pos, L1);
      var tmp$;
      tmp$ = $receiver.head_8be2vx$;
      if (tmp$ == null) {
        var offset = L_1;
        return ensureNotNull(null).data[Kotlin.Long.fromInt(null.pos).add(pos).subtract(offset).toInt()];
      }var s = tmp$;
      if ($receiver.size.subtract(pos).compareTo_11rb$(pos) < 0) {
        var offset_0 = $receiver.size;
        while (offset_0.compareTo_11rb$(pos) > 0) {
          s = ensureNotNull(s.prev);
          offset_0 = offset_0.subtract(Kotlin.Long.fromInt(s.limit - s.pos | 0));
        }
        var s_0 = s;
        var offset_1 = offset_0;
        return ensureNotNull(s_0).data[Kotlin.Long.fromInt(s_0.pos).add(pos).subtract(offset_1).toInt()];
      } else {
        var offset_2 = L0;
        while (true) {
          var nextOffset = offset_2.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
          if (nextOffset.compareTo_11rb$(pos) > 0)
            break;
          s = ensureNotNull(s.next);
          offset_2 = nextOffset;
        }
        var s_1 = s;
        var offset_3 = offset_2;
        return ensureNotNull(s_1).data[Kotlin.Long.fromInt(s_1.pos).add(pos).subtract(offset_3).toInt()];
      }
    };
  }));
  var commonClear = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonClear_cx6lq8$', function ($receiver) {
    $receiver.skip_s8cxhz$($receiver.size);
  });
  var commonSkip = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonSkip_rqsa21$', wrapFunction(function () {
    var EOFException_init = _.okio.EOFException;
    var okio = _.okio;
    return function ($receiver, byteCount) {
      var tmp$;
      var byteCount_0 = byteCount;
      while (byteCount_0.toNumber() > 0) {
        tmp$ = $receiver.head_8be2vx$;
        if (tmp$ == null) {
          throw new EOFException_init();
        }var head = tmp$;
        var a = byteCount_0;
        var b = Kotlin.Long.fromInt(head.limit - head.pos | 0);
        var toSkip = (a.compareTo_11rb$(b) <= 0 ? a : b).toInt();
        $receiver.size = $receiver.size.subtract(Kotlin.Long.fromInt(toSkip));
        byteCount_0 = byteCount_0.subtract(Kotlin.Long.fromInt(toSkip));
        head.pos = head.pos + toSkip | 0;
        if (head.pos === head.limit) {
          $receiver.head_8be2vx$ = head.pop();
          okio.SegmentPool.recycle_uve4t5$(head);
        }}
    };
  }));
  var commonWrite = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_q97ol7$', function ($receiver, byteString, offset, byteCount) {
    if (offset === void 0)
      offset = 0;
    if (byteCount === void 0)
      byteCount = byteString.size;
    byteString.write_zfhfyk$($receiver, offset, byteCount);
    return $receiver;
  });
  var commonWriteDecimalLong = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteDecimalLong_rqsa21$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var L100000000 = Kotlin.Long.fromInt(100000000);
    var L10000 = Kotlin.Long.fromInt(10000);
    var L100 = Kotlin.Long.fromInt(100);
    var L10 = Kotlin.Long.fromInt(10);
    var L1000 = Kotlin.Long.fromInt(1000);
    var L1000000 = Kotlin.Long.fromInt(1000000);
    var L100000 = Kotlin.Long.fromInt(100000);
    var L10000000 = Kotlin.Long.fromInt(10000000);
    var L1000000000000 = new Kotlin.Long(-727379968, 232);
    var L10000000000 = new Kotlin.Long(1410065408, 2);
    var L1000000000 = Kotlin.Long.fromInt(1000000000);
    var L100000000000 = new Kotlin.Long(1215752192, 23);
    var L1000000000000000 = new Kotlin.Long(-1530494976, 232830);
    var L10000000000000 = new Kotlin.Long(1316134912, 2328);
    var L100000000000000 = new Kotlin.Long(276447232, 23283);
    var L100000000000000000 = new Kotlin.Long(1569325056, 23283064);
    var L10000000000000000 = new Kotlin.Long(1874919424, 2328306);
    var L1000000000000000000 = new Kotlin.Long(-1486618624, 232830643);
    var internal = _.okio.internal;
    var toByte = Kotlin.toByte;
    return function ($receiver, v) {
      var v_0 = v;
      if (equals(v_0, L0)) {
        return $receiver.writeByte_za3lpa$(48);
      }var negative = false;
      if (v_0.compareTo_11rb$(L0) < 0) {
        v_0 = v_0.unaryMinus();
        if (v_0.compareTo_11rb$(L0) < 0) {
          return $receiver.writeUtf8_61zpoe$('-9223372036854775808');
        }negative = true;
      }var width = v_0.compareTo_11rb$(L100000000) < 0 ? v_0.compareTo_11rb$(L10000) < 0 ? v_0.compareTo_11rb$(L100) < 0 ? v_0.compareTo_11rb$(L10) < 0 ? 1 : 2 : v_0.compareTo_11rb$(L1000) < 0 ? 3 : 4 : v_0.compareTo_11rb$(L1000000) < 0 ? v_0.compareTo_11rb$(L100000) < 0 ? 5 : 6 : v_0.compareTo_11rb$(L10000000) < 0 ? 7 : 8 : v_0.compareTo_11rb$(L1000000000000) < 0 ? v_0.compareTo_11rb$(L10000000000) < 0 ? v_0.compareTo_11rb$(L1000000000) < 0 ? 9 : 10 : v_0.compareTo_11rb$(L100000000000) < 0 ? 11 : 12 : v_0.compareTo_11rb$(L1000000000000000) < 0 ? v_0.compareTo_11rb$(L10000000000000) < 0 ? 13 : v_0.compareTo_11rb$(L100000000000000) < 0 ? 14 : 15 : v_0.compareTo_11rb$(L100000000000000000) < 0 ? v_0.compareTo_11rb$(L10000000000000000) < 0 ? 16 : 17 : v_0.compareTo_11rb$(L1000000000000000000) < 0 ? 18 : 19;
      if (negative) {
        width = width + 1 | 0;
      }var tail = $receiver.writableSegment_kcn2v3$(width);
      var data = tail.data;
      var pos = tail.limit + width | 0;
      while (!equals(v_0, L0)) {
        var digit = v_0.modulo(Kotlin.Long.fromInt(10)).toInt();
        data[pos = pos - 1 | 0, pos] = internal.HEX_DIGIT_BYTES_8be2vx$[digit];
        v_0 = v_0.div(Kotlin.Long.fromInt(10));
      }
      if (negative) {
        data[pos = pos - 1 | 0, pos] = toByte(45);
      }tail.limit = tail.limit + width | 0;
      $receiver.size = $receiver.size.add(Kotlin.Long.fromInt(width));
      return $receiver;
    };
  }));
  var commonWriteHexadecimalUnsignedLong = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteHexadecimalUnsignedLong_rqsa21$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var L6148914691236517205 = new Kotlin.Long(1431655765, 1431655765);
    var L3689348814741910323 = new Kotlin.Long(858993459, 858993459);
    var L1085102592571150095 = new Kotlin.Long(252645135, 252645135);
    var L63 = Kotlin.Long.fromInt(63);
    var internal = _.okio.internal;
    var L15 = Kotlin.Long.fromInt(15);
    return function ($receiver, v) {
      var v_0 = v;
      if (equals(v_0, L0)) {
        return $receiver.writeByte_za3lpa$(48);
      }var x = v_0;
      x = x.or(x.shiftRightUnsigned(1));
      x = x.or(x.shiftRightUnsigned(2));
      x = x.or(x.shiftRightUnsigned(4));
      x = x.or(x.shiftRightUnsigned(8));
      x = x.or(x.shiftRightUnsigned(16));
      x = x.or(x.shiftRightUnsigned(32));
      x = x.subtract(x.shiftRightUnsigned(1).and(L6148914691236517205));
      x = x.shiftRightUnsigned(2).and(L3689348814741910323).add(x.and(L3689348814741910323));
      x = x.shiftRightUnsigned(4).add(x).and(L1085102592571150095);
      x = x.add(x.shiftRightUnsigned(8));
      x = x.add(x.shiftRightUnsigned(16));
      x = x.and(L63).add(x.shiftRightUnsigned(32).and(L63));
      var width = x.add(Kotlin.Long.fromInt(3)).div(Kotlin.Long.fromInt(4)).toInt();
      var tail = $receiver.writableSegment_kcn2v3$(width);
      var data = tail.data;
      var pos = tail.limit + width - 1 | 0;
      var start = tail.limit;
      while (pos >= start) {
        data[pos] = internal.HEX_DIGIT_BYTES_8be2vx$[v_0.and(L15).toInt()];
        v_0 = v_0.shiftRightUnsigned(4);
        pos = pos - 1 | 0;
      }
      tail.limit = tail.limit + width | 0;
      $receiver.size = $receiver.size.add(Kotlin.Long.fromInt(width));
      return $receiver;
    };
  }));
  var commonWritableSegment = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWritableSegment_j847vm$', wrapFunction(function () {
    var okio = _.okio;
    var ensureNotNull = Kotlin.ensureNotNull;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, minimumCapacity) {
      if (!(minimumCapacity >= 1 && minimumCapacity <= 8192)) {
        var message = 'unexpected capacity';
        throw IllegalArgumentException_init(message.toString());
      }if ($receiver.head_8be2vx$ == null) {
        var result = okio.SegmentPool.take();
        $receiver.head_8be2vx$ = result;
        result.prev = result;
        result.next = result;
        return result;
      }var tail = ensureNotNull($receiver.head_8be2vx$).prev;
      if ((ensureNotNull(tail).limit + minimumCapacity | 0) > 8192 || !tail.owner) {
        tail = tail.push_uve4t5$(okio.SegmentPool.take());
      }return tail;
    };
  }));
  var commonWrite_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_ezk82s$', function ($receiver, source) {
    return $receiver.write_mj6st8$(source, 0, source.length);
  });
  var commonWrite_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_p3n3ms$', wrapFunction(function () {
    var checkOffsetAndCount = _.okio.checkOffsetAndCount_e84ct6$;
    var JsMath = Math;
    var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
    return function ($receiver, source, offset, byteCount) {
      var offset_0 = offset;
      checkOffsetAndCount(Kotlin.Long.fromInt(source.length), Kotlin.Long.fromInt(offset_0), Kotlin.Long.fromInt(byteCount));
      var limit = offset_0 + byteCount | 0;
      while (offset_0 < limit) {
        var tail = $receiver.writableSegment_kcn2v3$(1);
        var a = limit - offset_0 | 0;
        var b = 8192 - tail.limit | 0;
        var toCopy = JsMath.min(a, b);
        arrayCopy(source, tail.data, tail.limit, offset_0, offset_0 + toCopy | 0);
        offset_0 = offset_0 + toCopy | 0;
        tail.limit = tail.limit + toCopy | 0;
      }
      $receiver.size = $receiver.size.add(Kotlin.Long.fromInt(byteCount));
      return $receiver;
    };
  }));
  var commonReadByteArray = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadByteArray_cx6lq8$', function ($receiver) {
    return $receiver.readByteArray_s8cxhz$($receiver.size);
  });
  var commonReadByteArray_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadByteArray_rqsa21$', wrapFunction(function () {
    var EOFException_init = _.okio.EOFException;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, byteCount) {
      if (!(byteCount.toNumber() >= 0 && byteCount.toNumber() <= 2147483647)) {
        var message = 'byteCount: ' + byteCount.toString();
        throw IllegalArgumentException_init(message.toString());
      }if ($receiver.size.compareTo_11rb$(byteCount) < 0)
        throw new EOFException_init();
      var result = new Int8Array(byteCount.toInt());
      $receiver.readFully_fqrh44$(result);
      return result;
    };
  }));
  var commonRead = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRead_ezk82s$', function ($receiver, sink) {
    return $receiver.read_mj6st8$(sink, 0, sink.length);
  });
  var commonReadFully = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadFully_ezk82s$', wrapFunction(function () {
    var EOFException_init = _.okio.EOFException;
    return function ($receiver, sink) {
      var offset = 0;
      while (offset < sink.length) {
        var read = $receiver.read_mj6st8$(sink, offset, sink.length - offset | 0);
        if (read === -1)
          throw new EOFException_init();
        offset = offset + read | 0;
      }
    };
  }));
  var commonRead_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRead_p3n3ms$', wrapFunction(function () {
    var checkOffsetAndCount = _.okio.checkOffsetAndCount_e84ct6$;
    var okio = _.okio;
    var JsMath = Math;
    var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
    return function ($receiver, sink, offset, byteCount) {
      var tmp$;
      checkOffsetAndCount(Kotlin.Long.fromInt(sink.length), Kotlin.Long.fromInt(offset), Kotlin.Long.fromInt(byteCount));
      tmp$ = $receiver.head_8be2vx$;
      if (tmp$ == null) {
        return -1;
      }var s = tmp$;
      var b = s.limit - s.pos | 0;
      var toCopy = JsMath.min(byteCount, b);
      arrayCopy(s.data, sink, offset, s.pos, s.pos + toCopy | 0);
      s.pos = s.pos + toCopy | 0;
      $receiver.size = $receiver.size.subtract(Kotlin.Long.fromInt(toCopy));
      if (s.pos === s.limit) {
        $receiver.head_8be2vx$ = s.pop();
        okio.SegmentPool.recycle_uve4t5$(s);
      }return toCopy;
    };
  }));
  var OVERFLOW_ZONE;
  var OVERFLOW_DIGIT_START;
  var commonReadDecimalLong = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadDecimalLong_cx6lq8$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var EOFException_init = _.okio.EOFException;
    var OVERFLOW_DIGIT_START = Kotlin.Long.fromInt(-7);
    var ensureNotNull = Kotlin.ensureNotNull;
    var toByte = Kotlin.toByte;
    var OVERFLOW_ZONE = new Kotlin.Long(858993460, -214748365);
    var Buffer_init = _.okio.Buffer;
    var NumberFormatException_init = Kotlin.kotlin.NumberFormatException;
    var L10 = Kotlin.Long.fromInt(10);
    var okio = _.okio;
    var toHexString = _.okio.toHexString_nugvp3$;
    return function ($receiver) {
      if (equals($receiver.size, L0))
        throw new EOFException_init();
      var value = L0;
      var seen = 0;
      var negative = false;
      var done = false;
      var overflowDigit = OVERFLOW_DIGIT_START;
      do {
        var segment = ensureNotNull($receiver.head_8be2vx$);
        var data = segment.data;
        var pos = segment.pos;
        var limit = segment.limit;
        while (pos < limit) {
          var b = data[pos];
          if (b >= toByte(48) && b <= toByte(57)) {
            var digit = toByte(48) - b;
            if (value.compareTo_11rb$(OVERFLOW_ZONE) < 0 || (equals(value, OVERFLOW_ZONE) && digit < overflowDigit.toNumber())) {
              var buffer = (new Buffer_init()).writeDecimalLong_s8cxhz$(value).writeByte_za3lpa$(b);
              if (!negative)
                buffer.readByte();
              throw new NumberFormatException_init('Number too large: ' + buffer.readUtf8());
            }value = value.multiply(L10);
            value = value.add(Kotlin.Long.fromInt(digit));
          } else if (b === toByte(45) && seen === 0) {
            negative = true;
            overflowDigit = overflowDigit.subtract(Kotlin.Long.fromInt(1));
          } else {
            done = true;
            break;
          }
          pos = pos + 1 | 0;
          seen = seen + 1 | 0;
        }
        if (pos === limit) {
          $receiver.head_8be2vx$ = segment.pop();
          okio.SegmentPool.recycle_uve4t5$(segment);
        } else {
          segment.pos = pos;
        }
      }
       while (!done && $receiver.head_8be2vx$ != null);
      $receiver.size = $receiver.size.subtract(Kotlin.Long.fromInt(seen));
      var minimumSeen = negative ? 2 : 1;
      if (seen < minimumSeen) {
        if (equals($receiver.size, L0))
          throw new EOFException_init();
        var expected = negative ? 'Expected a digit' : "Expected a digit or '-'";
        throw new NumberFormatException_init(expected + ' but was 0x' + toHexString($receiver.get_s8cxhz$(L0)));
      }return negative ? value : value.unaryMinus();
    };
  }));
  var commonReadHexadecimalUnsignedLong = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadHexadecimalUnsignedLong_cx6lq8$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var EOFException_init = _.okio.EOFException;
    var ensureNotNull = Kotlin.ensureNotNull;
    var toByte = Kotlin.toByte;
    var toHexString = _.okio.toHexString_nugvp3$;
    var NumberFormatException_init = Kotlin.kotlin.NumberFormatException;
    var L_1152921504606846976 = new Kotlin.Long(0, -268435456);
    var Buffer_init = _.okio.Buffer;
    var okio = _.okio;
    return function ($receiver) {
      if (equals($receiver.size, L0))
        throw new EOFException_init();
      var value = L0;
      var seen = 0;
      var done = false;
      do {
        var segment = ensureNotNull($receiver.head_8be2vx$);
        var data = segment.data;
        var pos = segment.pos;
        var limit = segment.limit;
        while (pos < limit) {
          var digit;
          var b = data[pos];
          if (b >= toByte(48) && b <= toByte(57)) {
            digit = b - toByte(48);
          } else if (b >= toByte(97) && b <= toByte(102)) {
            digit = b - toByte(97) + 10 | 0;
          } else if (b >= toByte(65) && b <= toByte(70)) {
            digit = b - toByte(65) + 10 | 0;
          } else {
            if (seen === 0) {
              throw new NumberFormatException_init('Expected leading [0-9a-fA-F] character but was 0x' + toHexString(b));
            }done = true;
            break;
          }
          if (!equals(value.and(L_1152921504606846976), L0)) {
            var buffer = (new Buffer_init()).writeHexadecimalUnsignedLong_s8cxhz$(value).writeByte_za3lpa$(b);
            throw new NumberFormatException_init('Number too large: ' + buffer.readUtf8());
          }value = value.shiftLeft(4);
          value = value.or(Kotlin.Long.fromInt(digit));
          pos = pos + 1 | 0;
          seen = seen + 1 | 0;
        }
        if (pos === limit) {
          $receiver.head_8be2vx$ = segment.pop();
          okio.SegmentPool.recycle_uve4t5$(segment);
        } else {
          segment.pos = pos;
        }
      }
       while (!done && $receiver.head_8be2vx$ != null);
      $receiver.size = $receiver.size.subtract(Kotlin.Long.fromInt(seen));
      return value;
    };
  }));
  var commonReadByteString = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadByteString_cx6lq8$', function ($receiver) {
    return $receiver.readByteString_s8cxhz$($receiver.size);
  });
  var commonReadByteString_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadByteString_rqsa21$', wrapFunction(function () {
    var EOFException_init = _.okio.EOFException;
    var ByteString_init = _.okio.ByteString;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, byteCount) {
      if (!(byteCount.toNumber() >= 0 && byteCount.toNumber() <= 2147483647)) {
        var message = 'byteCount: ' + byteCount.toString();
        throw IllegalArgumentException_init(message.toString());
      }if ($receiver.size.compareTo_11rb$(byteCount) < 0)
        throw new EOFException_init();
      if (byteCount.toNumber() >= 4096) {
        var $receiver_0 = $receiver.snapshot_za3lpa$(byteCount.toInt());
        $receiver.skip_s8cxhz$(byteCount);
        return $receiver_0;
      } else {
        return new ByteString_init($receiver.readByteArray_s8cxhz$(byteCount));
      }
    };
  }));
  var commonSelect = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonSelect_hdhslu$', wrapFunction(function () {
    var selectPrefix = _.okio.internal.selectPrefix_x1lq7p$;
    return function ($receiver, options) {
      var index = selectPrefix($receiver, options);
      if (index === -1)
        return -1;
      var selectedSize = options.byteStrings_8be2vx$[index].size;
      $receiver.skip_s8cxhz$(Kotlin.Long.fromInt(selectedSize));
      return index;
    };
  }));
  var commonReadFully_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadFully_ow212v$', wrapFunction(function () {
    var EOFException_init = _.okio.EOFException;
    return function ($receiver, sink, byteCount) {
      if ($receiver.size.compareTo_11rb$(byteCount) < 0) {
        sink.write_u27jpl$($receiver, $receiver.size);
        throw new EOFException_init();
      }sink.write_u27jpl$($receiver, byteCount);
    };
  }));
  var commonReadAll = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadAll_skqbtt$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    return function ($receiver, sink) {
      var byteCount = $receiver.size;
      if (byteCount.compareTo_11rb$(L0) > 0) {
        sink.write_u27jpl$($receiver, byteCount);
      }return byteCount;
    };
  }));
  var commonReadUtf8 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadUtf8_rqsa21$', wrapFunction(function () {
    var EOFException_init = _.okio.EOFException;
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var ensureNotNull = Kotlin.ensureNotNull;
    var commonToUtf8String = _.okio.internal.commonToUtf8String_ietg8x$;
    var okio = _.okio;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, byteCount) {
      if (!(byteCount.toNumber() >= 0 && byteCount.toNumber() <= 2147483647)) {
        var message = 'byteCount: ' + byteCount.toString();
        throw IllegalArgumentException_init(message.toString());
      }if ($receiver.size.compareTo_11rb$(byteCount) < 0)
        throw new EOFException_init();
      if (equals(byteCount, L0))
        return '';
      var s = ensureNotNull($receiver.head_8be2vx$);
      if (Kotlin.Long.fromInt(s.pos).add(byteCount).toNumber() > s.limit) {
        return commonToUtf8String($receiver.readByteArray_s8cxhz$(byteCount));
      }var result = commonToUtf8String(s.data, s.pos, s.pos + byteCount.toInt() | 0);
      s.pos = s.pos + byteCount.toInt() | 0;
      $receiver.size = $receiver.size.subtract(byteCount);
      if (s.pos === s.limit) {
        $receiver.head_8be2vx$ = s.pop();
        okio.SegmentPool.recycle_uve4t5$(s);
      }return result;
    };
  }));
  var commonReadUtf8Line = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadUtf8Line_cx6lq8$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var readUtf8Line = _.okio.internal.readUtf8Line_rqsa21$;
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    var L0 = Kotlin.Long.ZERO;
    return function ($receiver) {
      var tmp$;
      var newline = $receiver.indexOf_s8j3t7$(toByte(10));
      if (!equals(newline, L_1))
        tmp$ = readUtf8Line($receiver, newline);
      else if (!equals($receiver.size, L0))
        tmp$ = $receiver.readUtf8_s8cxhz$($receiver.size);
      else
        tmp$ = null;
      return tmp$;
    };
  }));
  var commonReadUtf8LineStrict = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadUtf8LineStrict_rqsa21$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var Long$Companion$MAX_VALUE = Kotlin.Long.MAX_VALUE;
    var equals = Kotlin.equals;
    var L1 = Kotlin.Long.ONE;
    var toByte = Kotlin.toByte;
    var L_1 = Kotlin.Long.NEG_ONE;
    var readUtf8Line = _.okio.internal.readUtf8Line_rqsa21$;
    var Buffer_init = _.okio.Buffer;
    var EOFException_init = _.okio.EOFException;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, limit) {
      if (!(limit.compareTo_11rb$(L0) >= 0)) {
        var message = 'limit < 0: ' + limit.toString();
        throw IllegalArgumentException_init(message.toString());
      }var scanLength = equals(limit, Long$Companion$MAX_VALUE) ? Long$Companion$MAX_VALUE : limit.add(L1);
      var newline = $receiver.indexOf_mfonpt$(toByte(10), L0, scanLength);
      if (!equals(newline, L_1))
        return readUtf8Line($receiver, newline);
      if (scanLength.compareTo_11rb$($receiver.size) < 0 && $receiver.get_s8cxhz$(scanLength.subtract(Kotlin.Long.fromInt(1))) === toByte(13) && $receiver.get_s8cxhz$(scanLength) === toByte(10)) {
        return readUtf8Line($receiver, scanLength);
      }var data = new Buffer_init();
      var tmp$ = L0;
      var b = $receiver.size;
      var a = Kotlin.Long.fromInt(32);
      $receiver.copyTo_ins7gm$(data, tmp$, a.compareTo_11rb$(b) <= 0 ? a : b);
      var a_0 = $receiver.size;
      throw new EOFException_init('\\' + 'n not found: limit=' + (a_0.compareTo_11rb$(limit) <= 0 ? a_0 : limit).toString() + ' content=' + data.readByteString().hex() + String.fromCharCode(8230));
    };
  }));
  var commonReadUtf8CodePoint = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadUtf8CodePoint_cx6lq8$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var EOFException_init = _.okio.EOFException;
    var L1 = Kotlin.Long.ONE;
    var toHexString = _.okio.toHexString_nugvp3$;
    return function ($receiver) {
      var tmp$, tmp$_0;
      if (equals($receiver.size, L0))
        throw new EOFException_init();
      var b0 = $receiver.get_s8cxhz$(L0);
      var codePoint;
      var byteCount;
      var min;
      if ((b0 & 128) === 0) {
        codePoint = b0 & 127;
        byteCount = 1;
        min = 0;
      } else {
        if ((b0 & 224) === 192) {
          codePoint = b0 & 31;
          byteCount = 2;
          min = 128;
        } else {
          if ((b0 & 240) === 224) {
            codePoint = b0 & 15;
            byteCount = 3;
            min = 2048;
          } else {
            if ((b0 & 248) === 240) {
              codePoint = b0 & 7;
              byteCount = 4;
              min = 65536;
            } else {
              $receiver.skip_s8cxhz$(L1);
              return 65533;
            }
          }
        }
      }
      if ($receiver.size.toNumber() < byteCount) {
        throw new EOFException_init('size < ' + byteCount + ': ' + $receiver.size.toString() + ' (to read code point prefixed 0x' + toHexString(b0) + ')');
      }tmp$ = byteCount;
      for (var i = 1; i < tmp$; i++) {
        var b = $receiver.get_s8cxhz$(Kotlin.Long.fromInt(i));
        if ((b & 192) === 128) {
          codePoint = codePoint << 6;
          codePoint = codePoint | b & 63;
        } else {
          $receiver.skip_s8cxhz$(Kotlin.Long.fromInt(i));
          return 65533;
        }
      }
      $receiver.skip_s8cxhz$(Kotlin.Long.fromInt(byteCount));
      if (codePoint > 1114111)
        tmp$_0 = 65533;
      else if (55296 <= codePoint && codePoint <= 57343)
        tmp$_0 = 65533;
      else if (codePoint < min)
        tmp$_0 = 65533;
      else
        tmp$_0 = codePoint;
      return tmp$_0;
    };
  }));
  var commonWriteUtf8 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteUtf8_cycsg2$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var L2 = Kotlin.Long.fromInt(2);
    var L3 = Kotlin.Long.fromInt(3);
    var L4 = Kotlin.Long.fromInt(4);
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    var JsMath = Math;
    return function ($receiver, string, beginIndex, endIndex) {
      var tmp$, tmp$_0;
      if (!(beginIndex >= 0)) {
        var message = 'beginIndex < 0: ' + beginIndex;
        throw IllegalArgumentException_init(message.toString());
      }if (!(endIndex >= beginIndex)) {
        var message_0 = 'endIndex < beginIndex: ' + endIndex + ' < ' + beginIndex;
        throw IllegalArgumentException_init(message_0.toString());
      }if (!(endIndex <= string.length)) {
        var message_1 = 'endIndex > string.length: ' + endIndex + ' > ' + string.length;
        throw IllegalArgumentException_init(message_1.toString());
      }var i = beginIndex;
      while (i < endIndex) {
        var c = string.charCodeAt(i) | 0;
        if (c < 128) {
          var tail = $receiver.writableSegment_kcn2v3$(1);
          var data = tail.data;
          var segmentOffset = tail.limit - i | 0;
          var b = 8192 - segmentOffset | 0;
          var runLimit = JsMath.min(endIndex, b);
          data[segmentOffset + (tmp$ = i, i = tmp$ + 1 | 0, tmp$) | 0] = toByte(c);
          while (i < runLimit) {
            c = string.charCodeAt(i) | 0;
            if (c >= 128)
              break;
            data[segmentOffset + (tmp$_0 = i, i = tmp$_0 + 1 | 0, tmp$_0) | 0] = toByte(c);
          }
          var runSize = i + segmentOffset - tail.limit | 0;
          tail.limit = tail.limit + runSize | 0;
          $receiver.size = $receiver.size.add(Kotlin.Long.fromInt(runSize));
        } else if (c < 2048) {
          var tail_0 = $receiver.writableSegment_kcn2v3$(2);
          tail_0.data[tail_0.limit] = toByte(c >> 6 | 192);
          tail_0.data[tail_0.limit + 1 | 0] = toByte(c & 63 | 128);
          tail_0.limit = tail_0.limit + 2 | 0;
          $receiver.size = $receiver.size.add(L2);
          i = i + 1 | 0;
        } else if (c < 55296 || c > 57343) {
          var tail_1 = $receiver.writableSegment_kcn2v3$(3);
          tail_1.data[tail_1.limit] = toByte(c >> 12 | 224);
          tail_1.data[tail_1.limit + 1 | 0] = toByte(c >> 6 & 63 | 128);
          tail_1.data[tail_1.limit + 2 | 0] = toByte(c & 63 | 128);
          tail_1.limit = tail_1.limit + 3 | 0;
          $receiver.size = $receiver.size.add(L3);
          i = i + 1 | 0;
        } else {
          var low = (i + 1 | 0) < endIndex ? string.charCodeAt(i + 1 | 0) | 0 : 0;
          if (c > 56319 || !(56320 <= low && low <= 57343)) {
            $receiver.writeByte_za3lpa$(63);
            i = i + 1 | 0;
          } else {
            var codePoint = 65536 + ((c & 1023) << 10 | low & 1023) | 0;
            var tail_2 = $receiver.writableSegment_kcn2v3$(4);
            tail_2.data[tail_2.limit] = toByte(codePoint >> 18 | 240);
            tail_2.data[tail_2.limit + 1 | 0] = toByte(codePoint >> 12 & 63 | 128);
            tail_2.data[tail_2.limit + 2 | 0] = toByte(codePoint >> 6 & 63 | 128);
            tail_2.data[tail_2.limit + 3 | 0] = toByte(codePoint & 63 | 128);
            tail_2.limit = tail_2.limit + 4 | 0;
            $receiver.size = $receiver.size.add(L4);
            i = i + 2 | 0;
          }
        }
      }
      return $receiver;
    };
  }));
  var commonWriteUtf8CodePoint = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteUtf8CodePoint_j847vm$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var L2 = Kotlin.Long.fromInt(2);
    var L3 = Kotlin.Long.fromInt(3);
    var L4 = Kotlin.Long.fromInt(4);
    var toHexString = _.okio.toHexString_8e50z4$;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, codePoint) {
      if (codePoint < 128)
        $receiver.writeByte_za3lpa$(codePoint);
      else if (codePoint < 2048) {
        var tail = $receiver.writableSegment_kcn2v3$(2);
        tail.data[tail.limit] = toByte(codePoint >> 6 | 192);
        tail.data[tail.limit + 1 | 0] = toByte(codePoint & 63 | 128);
        tail.limit = tail.limit + 2 | 0;
        $receiver.size = $receiver.size.add(L2);
      } else if (55296 <= codePoint && codePoint <= 57343)
        $receiver.writeByte_za3lpa$(63);
      else if (codePoint < 65536) {
        var tail_0 = $receiver.writableSegment_kcn2v3$(3);
        tail_0.data[tail_0.limit] = toByte(codePoint >> 12 | 224);
        tail_0.data[tail_0.limit + 1 | 0] = toByte(codePoint >> 6 & 63 | 128);
        tail_0.data[tail_0.limit + 2 | 0] = toByte(codePoint & 63 | 128);
        tail_0.limit = tail_0.limit + 3 | 0;
        $receiver.size = $receiver.size.add(L3);
      } else if (codePoint <= 1114111) {
        var tail_1 = $receiver.writableSegment_kcn2v3$(4);
        tail_1.data[tail_1.limit] = toByte(codePoint >> 18 | 240);
        tail_1.data[tail_1.limit + 1 | 0] = toByte(codePoint >> 12 & 63 | 128);
        tail_1.data[tail_1.limit + 2 | 0] = toByte(codePoint >> 6 & 63 | 128);
        tail_1.data[tail_1.limit + 3 | 0] = toByte(codePoint & 63 | 128);
        tail_1.limit = tail_1.limit + 4 | 0;
        $receiver.size = $receiver.size.add(L4);
      } else {
        throw IllegalArgumentException_init('Unexpected code point: 0x' + toHexString(codePoint));
      }
      return $receiver;
    };
  }));
  var commonWriteAll = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteAll_rn6xwn$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var L8192 = Kotlin.Long.fromInt(8192);
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    return function ($receiver, source) {
      var totalBytesRead = L0;
      while (true) {
        var readCount = source.read_u27jpl$($receiver, L8192);
        if (equals(readCount, L_1))
          break;
        totalBytesRead = totalBytesRead.add(readCount);
      }
      return totalBytesRead;
    };
  }));
  var commonWrite_2 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_pxeag4$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    var EOFException_init = _.okio.EOFException;
    return function ($receiver, source, byteCount) {
      var byteCount_0 = byteCount;
      while (byteCount_0.compareTo_11rb$(L0) > 0) {
        var read = source.read_u27jpl$($receiver, byteCount_0);
        if (equals(read, L_1))
          throw new EOFException_init();
        byteCount_0 = byteCount_0.subtract(read);
      }
      return $receiver;
    };
  }));
  var commonWriteByte = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteByte_j847vm$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var L1 = Kotlin.Long.ONE;
    return function ($receiver, b) {
      var tmp$;
      var tail = $receiver.writableSegment_kcn2v3$(1);
      tail.data[tmp$ = tail.limit, tail.limit = tmp$ + 1 | 0, tmp$] = toByte(b);
      $receiver.size = $receiver.size.add(L1);
      return $receiver;
    };
  }));
  var commonWriteShort = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteShort_j847vm$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var L2 = Kotlin.Long.fromInt(2);
    return function ($receiver, s) {
      var tmp$, tmp$_0;
      var tail = $receiver.writableSegment_kcn2v3$(2);
      var data = tail.data;
      var limit = tail.limit;
      data[tmp$ = limit, limit = tmp$ + 1 | 0, tmp$] = toByte(s >>> 8 & 255);
      data[tmp$_0 = limit, limit = tmp$_0 + 1 | 0, tmp$_0] = toByte(s & 255);
      tail.limit = limit;
      $receiver.size = $receiver.size.add(L2);
      return $receiver;
    };
  }));
  var commonWriteInt = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteInt_j847vm$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var L4 = Kotlin.Long.fromInt(4);
    return function ($receiver, i) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      var tail = $receiver.writableSegment_kcn2v3$(4);
      var data = tail.data;
      var limit = tail.limit;
      data[tmp$ = limit, limit = tmp$ + 1 | 0, tmp$] = toByte(i >>> 24 & 255);
      data[tmp$_0 = limit, limit = tmp$_0 + 1 | 0, tmp$_0] = toByte(i >>> 16 & 255);
      data[tmp$_1 = limit, limit = tmp$_1 + 1 | 0, tmp$_1] = toByte(i >>> 8 & 255);
      data[tmp$_2 = limit, limit = tmp$_2 + 1 | 0, tmp$_2] = toByte(i & 255);
      tail.limit = limit;
      $receiver.size = $receiver.size.add(L4);
      return $receiver;
    };
  }));
  var commonWriteLong = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteLong_rqsa21$', wrapFunction(function () {
    var L255 = Kotlin.Long.fromInt(255);
    var toByte = Kotlin.toByte;
    var L8 = Kotlin.Long.fromInt(8);
    return function ($receiver, v) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6;
      var tail = $receiver.writableSegment_kcn2v3$(8);
      var data = tail.data;
      var limit = tail.limit;
      data[tmp$ = limit, limit = tmp$ + 1 | 0, tmp$] = toByte(v.shiftRightUnsigned(56).and(L255).toInt());
      data[tmp$_0 = limit, limit = tmp$_0 + 1 | 0, tmp$_0] = toByte(v.shiftRightUnsigned(48).and(L255).toInt());
      data[tmp$_1 = limit, limit = tmp$_1 + 1 | 0, tmp$_1] = toByte(v.shiftRightUnsigned(40).and(L255).toInt());
      data[tmp$_2 = limit, limit = tmp$_2 + 1 | 0, tmp$_2] = toByte(v.shiftRightUnsigned(32).and(L255).toInt());
      data[tmp$_3 = limit, limit = tmp$_3 + 1 | 0, tmp$_3] = toByte(v.shiftRightUnsigned(24).and(L255).toInt());
      data[tmp$_4 = limit, limit = tmp$_4 + 1 | 0, tmp$_4] = toByte(v.shiftRightUnsigned(16).and(L255).toInt());
      data[tmp$_5 = limit, limit = tmp$_5 + 1 | 0, tmp$_5] = toByte(v.shiftRightUnsigned(8).and(L255).toInt());
      data[tmp$_6 = limit, limit = tmp$_6 + 1 | 0, tmp$_6] = toByte(v.and(L255).toInt());
      tail.limit = limit;
      $receiver.size = $receiver.size.add(L8);
      return $receiver;
    };
  }));
  var commonWrite_3 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_ow212v$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var checkOffsetAndCount = _.okio.checkOffsetAndCount_e84ct6$;
    var ensureNotNull = Kotlin.ensureNotNull;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, source, byteCount) {
      var byteCount_0 = byteCount;
      if (!(source !== $receiver)) {
        var message = 'source == this';
        throw IllegalArgumentException_init(message.toString());
      }checkOffsetAndCount(source.size, L0, byteCount_0);
      while (byteCount_0.compareTo_11rb$(L0) > 0) {
        if (byteCount_0.toNumber() < (ensureNotNull(source.head_8be2vx$).limit - ensureNotNull(source.head_8be2vx$).pos | 0)) {
          var tail = $receiver.head_8be2vx$ != null ? ensureNotNull($receiver.head_8be2vx$).prev : null;
          if (tail != null && tail.owner && byteCount_0.add(Kotlin.Long.fromInt(tail.limit)).subtract(Kotlin.Long.fromInt(tail.shared ? 0 : tail.pos)).toNumber() <= 8192) {
            ensureNotNull(source.head_8be2vx$).writeTo_l53ny1$(tail, byteCount_0.toInt());
            source.size = source.size.subtract(byteCount_0);
            $receiver.size = $receiver.size.add(byteCount_0);
            return;
          } else {
            source.head_8be2vx$ = ensureNotNull(source.head_8be2vx$).split_za3lpa$(byteCount_0.toInt());
          }
        }var segmentToMove = source.head_8be2vx$;
        var movedByteCount = Kotlin.Long.fromInt(ensureNotNull(segmentToMove).limit - segmentToMove.pos | 0);
        source.head_8be2vx$ = segmentToMove.pop();
        if ($receiver.head_8be2vx$ == null) {
          $receiver.head_8be2vx$ = segmentToMove;
          segmentToMove.prev = segmentToMove;
          segmentToMove.next = segmentToMove.prev;
        } else {
          var tail_0 = ensureNotNull($receiver.head_8be2vx$).prev;
          tail_0 = ensureNotNull(tail_0).push_uve4t5$(segmentToMove);
          tail_0.compact();
        }
        source.size = source.size.subtract(movedByteCount);
        $receiver.size = $receiver.size.add(movedByteCount);
        byteCount_0 = byteCount_0.subtract(movedByteCount);
      }
    };
  }));
  var commonRead_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRead_ow212v$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var L_1 = Kotlin.Long.NEG_ONE;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, sink, byteCount) {
      var byteCount_0 = {v: byteCount};
      if (!(byteCount_0.v.compareTo_11rb$(L0) >= 0)) {
        var message = 'byteCount < 0: ' + byteCount_0.v.toString();
        throw IllegalArgumentException_init(message.toString());
      }if (equals($receiver.size, L0))
        return L_1;
      if (byteCount_0.v.compareTo_11rb$($receiver.size) > 0)
        byteCount_0.v = $receiver.size;
      sink.write_u27jpl$($receiver, byteCount_0.v);
      return byteCount_0.v;
    };
  }));
  var commonIndexOf = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonIndexOf_w0xj73$', wrapFunction(function () {
    var equals = Kotlin.equals;
    var L_1 = Kotlin.Long.NEG_ONE;
    var ensureNotNull = Kotlin.ensureNotNull;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    var L0 = Kotlin.Long.ZERO;
    return function ($receiver, b, fromIndex, toIndex) {
      var fromIndex_0 = {v: fromIndex};
      var toIndex_0 = {v: toIndex};
      if (!Kotlin.Long.fromInt(0).rangeTo(toIndex_0.v).contains_mef7kx$(fromIndex_0.v)) {
        var message = 'size=' + $receiver.size.toString() + ' fromIndex=' + fromIndex_0.v.toString() + ' toIndex=' + toIndex_0.v.toString();
        throw IllegalArgumentException_init(message.toString());
      }if (toIndex_0.v.compareTo_11rb$($receiver.size) > 0)
        toIndex_0.v = $receiver.size;
      if (equals(fromIndex_0.v, toIndex_0.v))
        return L_1;
      var fromIndex_1 = fromIndex_0.v;
      var tmp$;
      tmp$ = $receiver.head_8be2vx$;
      if (tmp$ == null) {
        var offset = L_1;
        if (null == null) {
          return L_1;
        }var s = null;
        var offset_0 = offset;
        while (offset_0.compareTo_11rb$(toIndex_0.v) < 0) {
          var data = s.data;
          var a = Kotlin.Long.fromInt(s.limit);
          var b_0 = Kotlin.Long.fromInt(s.pos).add(toIndex_0.v).subtract(offset_0);
          var limit = (a.compareTo_11rb$(b_0) <= 0 ? a : b_0).toInt();
          var pos = Kotlin.Long.fromInt(s.pos).add(fromIndex_0.v).subtract(offset_0).toInt();
          while (pos < limit) {
            if (data[pos] === b) {
              return Kotlin.Long.fromInt(pos - s.pos | 0).add(offset_0);
            }pos = pos + 1 | 0;
          }
          offset_0 = offset_0.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
          fromIndex_0.v = offset_0;
          s = ensureNotNull(s.next);
        }
        return L_1;
      }var s_0 = tmp$;
      if ($receiver.size.subtract(fromIndex_1).compareTo_11rb$(fromIndex_1) < 0) {
        var offset_1 = $receiver.size;
        while (offset_1.compareTo_11rb$(fromIndex_1) > 0) {
          s_0 = ensureNotNull(s_0.prev);
          offset_1 = offset_1.subtract(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
        }
        var s_1 = s_0;
        var offset_2 = offset_1;
        if (s_1 == null) {
          return L_1;
        }var s_2 = s_1;
        var offset_3 = offset_2;
        while (offset_3.compareTo_11rb$(toIndex_0.v) < 0) {
          var data_0 = s_2.data;
          var a_0 = Kotlin.Long.fromInt(s_2.limit);
          var b_1 = Kotlin.Long.fromInt(s_2.pos).add(toIndex_0.v).subtract(offset_3);
          var limit_0 = (a_0.compareTo_11rb$(b_1) <= 0 ? a_0 : b_1).toInt();
          var pos_0 = Kotlin.Long.fromInt(s_2.pos).add(fromIndex_0.v).subtract(offset_3).toInt();
          while (pos_0 < limit_0) {
            if (data_0[pos_0] === b) {
              return Kotlin.Long.fromInt(pos_0 - s_2.pos | 0).add(offset_3);
            }pos_0 = pos_0 + 1 | 0;
          }
          offset_3 = offset_3.add(Kotlin.Long.fromInt(s_2.limit - s_2.pos | 0));
          fromIndex_0.v = offset_3;
          s_2 = ensureNotNull(s_2.next);
        }
        return L_1;
      } else {
        var offset_4 = L0;
        while (true) {
          var nextOffset = offset_4.add(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
          if (nextOffset.compareTo_11rb$(fromIndex_1) > 0)
            break;
          s_0 = ensureNotNull(s_0.next);
          offset_4 = nextOffset;
        }
        var s_3 = s_0;
        var offset_5 = offset_4;
        if (s_3 == null) {
          return L_1;
        }var s_4 = s_3;
        var offset_6 = offset_5;
        while (offset_6.compareTo_11rb$(toIndex_0.v) < 0) {
          var data_1 = s_4.data;
          var a_1 = Kotlin.Long.fromInt(s_4.limit);
          var b_2 = Kotlin.Long.fromInt(s_4.pos).add(toIndex_0.v).subtract(offset_6);
          var limit_1 = (a_1.compareTo_11rb$(b_2) <= 0 ? a_1 : b_2).toInt();
          var pos_1 = Kotlin.Long.fromInt(s_4.pos).add(fromIndex_0.v).subtract(offset_6).toInt();
          while (pos_1 < limit_1) {
            if (data_1[pos_1] === b) {
              return Kotlin.Long.fromInt(pos_1 - s_4.pos | 0).add(offset_6);
            }pos_1 = pos_1 + 1 | 0;
          }
          offset_6 = offset_6.add(Kotlin.Long.fromInt(s_4.limit - s_4.pos | 0));
          fromIndex_0.v = offset_6;
          s_4 = ensureNotNull(s_4.next);
        }
        return L_1;
      }
    };
  }));
  var commonIndexOf_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonIndexOf_qcxvni$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var L_1 = Kotlin.Long.NEG_ONE;
    var L1 = Kotlin.Long.ONE;
    var rangeEquals = _.okio.internal.rangeEquals_kfbcqu$;
    var ensureNotNull = Kotlin.ensureNotNull;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, bytes, fromIndex) {
      var fromIndex_0 = {v: fromIndex};
      if (!(bytes.size > 0)) {
        var message = 'bytes is empty';
        throw IllegalArgumentException_init(message.toString());
      }if (!(fromIndex_0.v.compareTo_11rb$(L0) >= 0)) {
        var message_0 = 'fromIndex < 0: ' + fromIndex_0.v.toString();
        throw IllegalArgumentException_init(message_0.toString());
      }var fromIndex_1 = fromIndex_0.v;
      var tmp$;
      tmp$ = $receiver.head_8be2vx$;
      if (tmp$ == null) {
        var offset = L_1;
        if (null == null) {
          return L_1;
        }var s = null;
        var offset_0 = offset;
        var targetByteArray = bytes.internalArray();
        var b0 = targetByteArray[0];
        var bytesSize = bytes.size;
        var resultLimit = $receiver.size.subtract(Kotlin.Long.fromInt(bytesSize)).add(L1);
        while (offset_0.compareTo_11rb$(resultLimit) < 0) {
          var data = s.data;
          var a = s.limit;
          var b = Kotlin.Long.fromInt(s.pos).add(resultLimit).subtract(offset_0);
          var a_0 = Kotlin.Long.fromInt(a);
          var segmentLimit = (a_0.compareTo_11rb$(b) <= 0 ? a_0 : b).toInt();
          for (var pos = Kotlin.Long.fromInt(s.pos).add(fromIndex_0.v).subtract(offset_0).toInt(); pos < segmentLimit; pos++) {
            if (data[pos] === b0 && rangeEquals(s, pos + 1 | 0, targetByteArray, 1, bytesSize)) {
              return Kotlin.Long.fromInt(pos - s.pos | 0).add(offset_0);
            }}
          offset_0 = offset_0.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
          fromIndex_0.v = offset_0;
          s = ensureNotNull(s.next);
        }
        return L_1;
      }var s_0 = tmp$;
      if ($receiver.size.subtract(fromIndex_1).compareTo_11rb$(fromIndex_1) < 0) {
        var offset_1 = $receiver.size;
        while (offset_1.compareTo_11rb$(fromIndex_1) > 0) {
          s_0 = ensureNotNull(s_0.prev);
          offset_1 = offset_1.subtract(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
        }
        var s_1 = s_0;
        var offset_2 = offset_1;
        if (s_1 == null) {
          return L_1;
        }var s_2 = s_1;
        var offset_3 = offset_2;
        var targetByteArray_0 = bytes.internalArray();
        var b0_0 = targetByteArray_0[0];
        var bytesSize_0 = bytes.size;
        var resultLimit_0 = $receiver.size.subtract(Kotlin.Long.fromInt(bytesSize_0)).add(L1);
        while (offset_3.compareTo_11rb$(resultLimit_0) < 0) {
          var data_0 = s_2.data;
          var a_1 = s_2.limit;
          var b_0 = Kotlin.Long.fromInt(s_2.pos).add(resultLimit_0).subtract(offset_3);
          var a_2 = Kotlin.Long.fromInt(a_1);
          var segmentLimit_0 = (a_2.compareTo_11rb$(b_0) <= 0 ? a_2 : b_0).toInt();
          for (var pos_0 = Kotlin.Long.fromInt(s_2.pos).add(fromIndex_0.v).subtract(offset_3).toInt(); pos_0 < segmentLimit_0; pos_0++) {
            if (data_0[pos_0] === b0_0 && rangeEquals(s_2, pos_0 + 1 | 0, targetByteArray_0, 1, bytesSize_0)) {
              return Kotlin.Long.fromInt(pos_0 - s_2.pos | 0).add(offset_3);
            }}
          offset_3 = offset_3.add(Kotlin.Long.fromInt(s_2.limit - s_2.pos | 0));
          fromIndex_0.v = offset_3;
          s_2 = ensureNotNull(s_2.next);
        }
        return L_1;
      } else {
        var offset_4 = L0;
        while (true) {
          var nextOffset = offset_4.add(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
          if (nextOffset.compareTo_11rb$(fromIndex_1) > 0)
            break;
          s_0 = ensureNotNull(s_0.next);
          offset_4 = nextOffset;
        }
        var s_3 = s_0;
        var offset_5 = offset_4;
        if (s_3 == null) {
          return L_1;
        }var s_4 = s_3;
        var offset_6 = offset_5;
        var targetByteArray_1 = bytes.internalArray();
        var b0_1 = targetByteArray_1[0];
        var bytesSize_1 = bytes.size;
        var resultLimit_1 = $receiver.size.subtract(Kotlin.Long.fromInt(bytesSize_1)).add(L1);
        while (offset_6.compareTo_11rb$(resultLimit_1) < 0) {
          var data_1 = s_4.data;
          var a_3 = s_4.limit;
          var b_1 = Kotlin.Long.fromInt(s_4.pos).add(resultLimit_1).subtract(offset_6);
          var a_4 = Kotlin.Long.fromInt(a_3);
          var segmentLimit_1 = (a_4.compareTo_11rb$(b_1) <= 0 ? a_4 : b_1).toInt();
          for (var pos_1 = Kotlin.Long.fromInt(s_4.pos).add(fromIndex_0.v).subtract(offset_6).toInt(); pos_1 < segmentLimit_1; pos_1++) {
            if (data_1[pos_1] === b0_1 && rangeEquals(s_4, pos_1 + 1 | 0, targetByteArray_1, 1, bytesSize_1)) {
              return Kotlin.Long.fromInt(pos_1 - s_4.pos | 0).add(offset_6);
            }}
          offset_6 = offset_6.add(Kotlin.Long.fromInt(s_4.limit - s_4.pos | 0));
          fromIndex_0.v = offset_6;
          s_4 = ensureNotNull(s_4.next);
        }
        return L_1;
      }
    };
  }));
  var commonIndexOfElement = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonIndexOfElement_qcxvni$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var L_1 = Kotlin.Long.NEG_ONE;
    var ensureNotNull = Kotlin.ensureNotNull;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, targetBytes, fromIndex) {
      var fromIndex_0 = {v: fromIndex};
      if (!(fromIndex_0.v.compareTo_11rb$(L0) >= 0)) {
        var message = 'fromIndex < 0: ' + fromIndex_0.v.toString();
        throw IllegalArgumentException_init(message.toString());
      }var fromIndex_1 = fromIndex_0.v;
      var tmp$;
      tmp$ = $receiver.head_8be2vx$;
      if (tmp$ == null) {
        var offset = L_1;
        var tmp$_0;
        if (null == null) {
          return L_1;
        }var s = null;
        var offset_0 = offset;
        if (targetBytes.size === 2) {
          var b0 = targetBytes.get_za3lpa$(0);
          var b1 = targetBytes.get_za3lpa$(1);
          while (offset_0.compareTo_11rb$($receiver.size) < 0) {
            var data = s.data;
            var pos = Kotlin.Long.fromInt(s.pos).add(fromIndex_0.v).subtract(offset_0).toInt();
            var limit = s.limit;
            while (pos < limit) {
              var b = data[pos];
              if (b === b0 || b === b1) {
                return Kotlin.Long.fromInt(pos - s.pos | 0).add(offset_0);
              }pos = pos + 1 | 0;
            }
            offset_0 = offset_0.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
            fromIndex_0.v = offset_0;
            s = ensureNotNull(s.next);
          }
        } else {
          var targetByteArray = targetBytes.internalArray();
          while (offset_0.compareTo_11rb$($receiver.size) < 0) {
            var data_0 = s.data;
            var pos_0 = Kotlin.Long.fromInt(s.pos).add(fromIndex_0.v).subtract(offset_0).toInt();
            var limit_0 = s.limit;
            while (pos_0 < limit_0) {
              var b_0 = data_0[pos_0];
              for (tmp$_0 = 0; tmp$_0 !== targetByteArray.length; ++tmp$_0) {
                var t = targetByteArray[tmp$_0];
                if (b_0 === t)
                  return Kotlin.Long.fromInt(pos_0 - s.pos | 0).add(offset_0);
              }
              pos_0 = pos_0 + 1 | 0;
            }
            offset_0 = offset_0.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
            fromIndex_0.v = offset_0;
            s = ensureNotNull(s.next);
          }
        }
        return L_1;
      }var s_0 = tmp$;
      if ($receiver.size.subtract(fromIndex_1).compareTo_11rb$(fromIndex_1) < 0) {
        var offset_1 = $receiver.size;
        while (offset_1.compareTo_11rb$(fromIndex_1) > 0) {
          s_0 = ensureNotNull(s_0.prev);
          offset_1 = offset_1.subtract(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
        }
        var s_1 = s_0;
        var offset_2 = offset_1;
        var tmp$_1;
        if (s_1 == null) {
          return L_1;
        }var s_2 = s_1;
        var offset_3 = offset_2;
        if (targetBytes.size === 2) {
          var b0_0 = targetBytes.get_za3lpa$(0);
          var b1_0 = targetBytes.get_za3lpa$(1);
          while (offset_3.compareTo_11rb$($receiver.size) < 0) {
            var data_1 = s_2.data;
            var pos_1 = Kotlin.Long.fromInt(s_2.pos).add(fromIndex_0.v).subtract(offset_3).toInt();
            var limit_1 = s_2.limit;
            while (pos_1 < limit_1) {
              var b_1 = data_1[pos_1];
              if (b_1 === b0_0 || b_1 === b1_0) {
                return Kotlin.Long.fromInt(pos_1 - s_2.pos | 0).add(offset_3);
              }pos_1 = pos_1 + 1 | 0;
            }
            offset_3 = offset_3.add(Kotlin.Long.fromInt(s_2.limit - s_2.pos | 0));
            fromIndex_0.v = offset_3;
            s_2 = ensureNotNull(s_2.next);
          }
        } else {
          var targetByteArray_0 = targetBytes.internalArray();
          while (offset_3.compareTo_11rb$($receiver.size) < 0) {
            var data_2 = s_2.data;
            var pos_2 = Kotlin.Long.fromInt(s_2.pos).add(fromIndex_0.v).subtract(offset_3).toInt();
            var limit_2 = s_2.limit;
            while (pos_2 < limit_2) {
              var b_2 = data_2[pos_2];
              for (tmp$_1 = 0; tmp$_1 !== targetByteArray_0.length; ++tmp$_1) {
                var t_0 = targetByteArray_0[tmp$_1];
                if (b_2 === t_0)
                  return Kotlin.Long.fromInt(pos_2 - s_2.pos | 0).add(offset_3);
              }
              pos_2 = pos_2 + 1 | 0;
            }
            offset_3 = offset_3.add(Kotlin.Long.fromInt(s_2.limit - s_2.pos | 0));
            fromIndex_0.v = offset_3;
            s_2 = ensureNotNull(s_2.next);
          }
        }
        return L_1;
      } else {
        var offset_4 = L0;
        while (true) {
          var nextOffset = offset_4.add(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
          if (nextOffset.compareTo_11rb$(fromIndex_1) > 0)
            break;
          s_0 = ensureNotNull(s_0.next);
          offset_4 = nextOffset;
        }
        var s_3 = s_0;
        var offset_5 = offset_4;
        var tmp$_2;
        if (s_3 == null) {
          return L_1;
        }var s_4 = s_3;
        var offset_6 = offset_5;
        if (targetBytes.size === 2) {
          var b0_1 = targetBytes.get_za3lpa$(0);
          var b1_1 = targetBytes.get_za3lpa$(1);
          while (offset_6.compareTo_11rb$($receiver.size) < 0) {
            var data_3 = s_4.data;
            var pos_3 = Kotlin.Long.fromInt(s_4.pos).add(fromIndex_0.v).subtract(offset_6).toInt();
            var limit_3 = s_4.limit;
            while (pos_3 < limit_3) {
              var b_3 = data_3[pos_3];
              if (b_3 === b0_1 || b_3 === b1_1) {
                return Kotlin.Long.fromInt(pos_3 - s_4.pos | 0).add(offset_6);
              }pos_3 = pos_3 + 1 | 0;
            }
            offset_6 = offset_6.add(Kotlin.Long.fromInt(s_4.limit - s_4.pos | 0));
            fromIndex_0.v = offset_6;
            s_4 = ensureNotNull(s_4.next);
          }
        } else {
          var targetByteArray_1 = targetBytes.internalArray();
          while (offset_6.compareTo_11rb$($receiver.size) < 0) {
            var data_4 = s_4.data;
            var pos_4 = Kotlin.Long.fromInt(s_4.pos).add(fromIndex_0.v).subtract(offset_6).toInt();
            var limit_4 = s_4.limit;
            while (pos_4 < limit_4) {
              var b_4 = data_4[pos_4];
              for (tmp$_2 = 0; tmp$_2 !== targetByteArray_1.length; ++tmp$_2) {
                var t_1 = targetByteArray_1[tmp$_2];
                if (b_4 === t_1)
                  return Kotlin.Long.fromInt(pos_4 - s_4.pos | 0).add(offset_6);
              }
              pos_4 = pos_4 + 1 | 0;
            }
            offset_6 = offset_6.add(Kotlin.Long.fromInt(s_4.limit - s_4.pos | 0));
            fromIndex_0.v = offset_6;
            s_4 = ensureNotNull(s_4.next);
          }
        }
        return L_1;
      }
    };
  }));
  var commonRangeEquals = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRangeEquals_k06rlq$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    return function ($receiver, offset, bytes, bytesOffset, byteCount) {
      if (offset.compareTo_11rb$(L0) < 0 || bytesOffset < 0 || byteCount < 0 || $receiver.size.subtract(offset).toNumber() < byteCount || (bytes.size - bytesOffset | 0) < byteCount) {
        return false;
      }for (var i = 0; i < byteCount; i++) {
        if ($receiver.get_s8cxhz$(offset.add(Kotlin.Long.fromInt(i))) !== bytes.get_za3lpa$(bytesOffset + i | 0)) {
          return false;
        }}
      return true;
    };
  }));
  var commonEquals = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonEquals_rql8ow$', wrapFunction(function () {
    var Buffer = _.okio.Buffer;
    var equals = Kotlin.equals;
    var L0 = Kotlin.Long.ZERO;
    var ensureNotNull = Kotlin.ensureNotNull;
    var until = Kotlin.kotlin.ranges.until_2p08ub$;
    var JsMath = Math;
    return function ($receiver, other) {
      var tmp$, tmp$_0, tmp$_1;
      if ($receiver === other)
        return true;
      if (!Kotlin.isType(other, Buffer))
        return false;
      if (!equals($receiver.size, other.size))
        return false;
      if (equals($receiver.size, L0))
        return true;
      var sa = ensureNotNull($receiver.head_8be2vx$);
      var sb = ensureNotNull(other.head_8be2vx$);
      var posA = sa.pos;
      var posB = sb.pos;
      var pos = L0;
      var count;
      while (pos.compareTo_11rb$($receiver.size) < 0) {
        var a = sa.limit - posA | 0;
        var b = sb.limit - posB | 0;
        count = Kotlin.Long.fromInt(JsMath.min(a, b));
        tmp$ = until(L0, count).iterator();
        while (tmp$.hasNext()) {
          var i = tmp$.next();
          if (sa.data[tmp$_0 = posA, posA = tmp$_0 + 1 | 0, tmp$_0] !== sb.data[tmp$_1 = posB, posB = tmp$_1 + 1 | 0, tmp$_1])
            return false;
        }
        if (posA === sa.limit) {
          sa = ensureNotNull(sa.next);
          posA = sa.pos;
        }if (posB === sb.limit) {
          sb = ensureNotNull(sb.next);
          posB = sb.pos;
        }pos = pos.add(count);
      }
      return true;
    };
  }));
  var commonHashCode = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonHashCode_cx6lq8$', wrapFunction(function () {
    var ensureNotNull = Kotlin.ensureNotNull;
    return function ($receiver) {
      var tmp$;
      tmp$ = $receiver.head_8be2vx$;
      if (tmp$ == null) {
        return 0;
      }var s = tmp$;
      var result = 1;
      do {
        var pos = s.pos;
        var limit = s.limit;
        while (pos < limit) {
          result = (31 * result | 0) + s.data[pos];
          pos = pos + 1 | 0;
        }
        s = ensureNotNull(s.next);
      }
       while (s !== $receiver.head_8be2vx$);
      return result;
    };
  }));
  var commonCopy = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonCopy_cx6lq8$', wrapFunction(function () {
    var Buffer_init = _.okio.Buffer;
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var ensureNotNull = Kotlin.ensureNotNull;
    return function ($receiver) {
      var result = new Buffer_init();
      if (equals($receiver.size, L0))
        return result;
      var head = ensureNotNull($receiver.head_8be2vx$);
      var headCopy = head.sharedCopy();
      result.head_8be2vx$ = headCopy;
      headCopy.prev = result.head_8be2vx$;
      headCopy.next = headCopy.prev;
      var s = head.next;
      while (s !== head) {
        ensureNotNull(headCopy.prev).push_uve4t5$(ensureNotNull(s).sharedCopy());
        s = s.next;
      }
      result.size = $receiver.size;
      return result;
    };
  }));
  var commonSnapshot = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonSnapshot_cx6lq8$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver) {
      if (!($receiver.size.toNumber() <= 2147483647)) {
        var message = 'size > Int.MAX_VALUE: ' + $receiver.size.toString();
        throw IllegalStateException_init(message.toString());
      }return $receiver.snapshot_za3lpa$($receiver.size.toInt());
    };
  }));
  var commonSnapshot_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonSnapshot_j847vm$', wrapFunction(function () {
    var ByteString = _.okio.ByteString;
    var L0 = Kotlin.Long.ZERO;
    var checkOffsetAndCount = _.okio.checkOffsetAndCount_e84ct6$;
    var ensureNotNull = Kotlin.ensureNotNull;
    var AssertionError_init = Kotlin.kotlin.AssertionError_init_pdl1vj$;
    var throwCCE = Kotlin.throwCCE;
    var SegmentedByteString_init = _.okio.SegmentedByteString;
    var JsMath = Math;
    return function ($receiver, byteCount) {
      var tmp$;
      if (byteCount === 0)
        return ByteString.Companion.EMPTY;
      checkOffsetAndCount($receiver.size, L0, Kotlin.Long.fromInt(byteCount));
      var offset = 0;
      var segmentCount = 0;
      var s = $receiver.head_8be2vx$;
      while (offset < byteCount) {
        if (ensureNotNull(s).limit === s.pos) {
          throw AssertionError_init('s.limit == s.pos');
        }offset = offset + (s.limit - s.pos) | 0;
        segmentCount = segmentCount + 1 | 0;
        s = s.next;
      }
      var segments = Kotlin.newArray(segmentCount, null);
      var directory = new Int32Array(segmentCount * 2 | 0);
      offset = 0;
      segmentCount = 0;
      s = $receiver.head_8be2vx$;
      while (offset < byteCount) {
        segments[segmentCount] = ensureNotNull(s).data;
        offset = offset + (s.limit - s.pos) | 0;
        var a = offset;
        directory[segmentCount] = JsMath.min(a, byteCount);
        directory[segmentCount + segments.length | 0] = s.pos;
        s.shared = true;
        segmentCount = segmentCount + 1 | 0;
        s = s.next;
      }
      return new SegmentedByteString_init(Kotlin.isArray(tmp$ = segments) ? tmp$ : throwCCE(), directory);
    };
  }));
  function commonReadUnsafe($receiver, unsafeCursor) {
    var unsafeCursor_0 = resolveDefaultParameter(unsafeCursor);
    if (!(unsafeCursor_0.buffer == null)) {
      var message = 'already attached to a buffer';
      throw IllegalStateException_init(message.toString());
    }unsafeCursor_0.buffer = $receiver;
    unsafeCursor_0.readWrite = false;
    return unsafeCursor_0;
  }
  function commonReadAndWriteUnsafe($receiver, unsafeCursor) {
    var unsafeCursor_0 = resolveDefaultParameter(unsafeCursor);
    if (!(unsafeCursor_0.buffer == null)) {
      var message = 'already attached to a buffer';
      throw IllegalStateException_init(message.toString());
    }unsafeCursor_0.buffer = $receiver;
    unsafeCursor_0.readWrite = true;
    return unsafeCursor_0;
  }
  var commonNext = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonNext_6osl3o$', wrapFunction(function () {
    var ensureNotNull = Kotlin.ensureNotNull;
    var equals = Kotlin.equals;
    var L_1 = Kotlin.Long.NEG_ONE;
    var L0 = Kotlin.Long.ZERO;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver) {
      if (!!equals($receiver.offset, ensureNotNull($receiver.buffer).size)) {
        var message = 'no more bytes';
        throw IllegalStateException_init(message.toString());
      }return equals($receiver.offset, L_1) ? $receiver.seek_s8cxhz$(L0) : $receiver.seek_s8cxhz$($receiver.offset.add(Kotlin.Long.fromInt($receiver.end - $receiver.start | 0)));
    };
  }));
  var commonSeek = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonSeek_1ijwtn$', wrapFunction(function () {
    var ArrayIndexOutOfBoundsException_init = _.okio.ArrayIndexOutOfBoundsException;
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    var L0 = Kotlin.Long.ZERO;
    var ensureNotNull = Kotlin.ensureNotNull;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, offset) {
      var value = $receiver.buffer;
      var checkNotNull$result;
      if (value == null) {
        var message = 'not attached to a buffer';
        throw IllegalStateException_init(message.toString());
      } else {
        checkNotNull$result = value;
      }
      var buffer = checkNotNull$result;
      if (offset.toNumber() < -1 || offset.compareTo_11rb$(buffer.size) > 0) {
        throw new ArrayIndexOutOfBoundsException_init('offset=' + offset.toString() + ' > size=' + buffer.size.toString());
      }if (equals(offset, L_1) || equals(offset, buffer.size)) {
        $receiver.segment_8be2vx$ = null;
        $receiver.offset = offset;
        $receiver.data = null;
        $receiver.start = -1;
        $receiver.end = -1;
        return -1;
      }var min = L0;
      var max = buffer.size;
      var head = buffer.head_8be2vx$;
      var tail = buffer.head_8be2vx$;
      if ($receiver.segment_8be2vx$ != null) {
        var segmentOffset = $receiver.offset.subtract(Kotlin.Long.fromInt($receiver.start - ensureNotNull($receiver.segment_8be2vx$).pos | 0));
        if (segmentOffset.compareTo_11rb$(offset) > 0) {
          max = segmentOffset;
          tail = $receiver.segment_8be2vx$;
        } else {
          min = segmentOffset;
          head = $receiver.segment_8be2vx$;
        }
      }var next;
      var nextOffset;
      if (max.subtract(offset).compareTo_11rb$(offset.subtract(min)) > 0) {
        next = head;
        nextOffset = min;
        while (offset.compareTo_11rb$(nextOffset.add(Kotlin.Long.fromInt(ensureNotNull(next).limit - next.pos | 0))) >= 0) {
          nextOffset = nextOffset.add(Kotlin.Long.fromInt(next.limit - next.pos | 0));
          next = next.next;
        }
      } else {
        next = tail;
        nextOffset = max;
        while (nextOffset.compareTo_11rb$(offset) > 0) {
          next = ensureNotNull(next).prev;
          nextOffset = nextOffset.subtract(Kotlin.Long.fromInt(ensureNotNull(next).limit - next.pos | 0));
        }
      }
      if ($receiver.readWrite && ensureNotNull(next).shared) {
        var unsharedNext = next.unsharedCopy();
        if (buffer.head_8be2vx$ === next) {
          buffer.head_8be2vx$ = unsharedNext;
        }next = next.push_uve4t5$(unsharedNext);
        ensureNotNull(next.prev).pop();
      }$receiver.segment_8be2vx$ = next;
      $receiver.offset = offset;
      $receiver.data = ensureNotNull(next).data;
      $receiver.start = next.pos + offset.subtract(nextOffset).toInt() | 0;
      $receiver.end = next.limit;
      return $receiver.end - $receiver.start | 0;
    };
  }));
  var commonResizeBuffer = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonResizeBuffer_1ijwtn$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var ensureNotNull = Kotlin.ensureNotNull;
    var okio = _.okio;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, newSize) {
      var value = $receiver.buffer;
      var checkNotNull$result;
      if (value == null) {
        var message = 'not attached to a buffer';
        throw IllegalStateException_init(message.toString());
      } else {
        checkNotNull$result = value;
      }
      var buffer = checkNotNull$result;
      if (!$receiver.readWrite) {
        var message_0 = 'resizeBuffer() only permitted for read/write buffers';
        throw IllegalStateException_init(message_0.toString());
      }var oldSize = buffer.size;
      if (newSize.compareTo_11rb$(oldSize) <= 0) {
        if (!(newSize.compareTo_11rb$(L0) >= 0)) {
          var message_1 = 'newSize < 0: ' + newSize.toString();
          throw IllegalArgumentException_init(message_1.toString());
        }var bytesToSubtract = oldSize.subtract(newSize);
        while (bytesToSubtract.compareTo_11rb$(L0) > 0) {
          var tail = ensureNotNull(buffer.head_8be2vx$).prev;
          var tailSize = ensureNotNull(tail).limit - tail.pos | 0;
          if (tailSize <= bytesToSubtract.toNumber()) {
            buffer.head_8be2vx$ = tail.pop();
            okio.SegmentPool.recycle_uve4t5$(tail);
            bytesToSubtract = bytesToSubtract.subtract(Kotlin.Long.fromInt(tailSize));
          } else {
            tail.limit = tail.limit - bytesToSubtract.toInt() | 0;
            break;
          }
        }
        $receiver.segment_8be2vx$ = null;
        $receiver.offset = newSize;
        $receiver.data = null;
        $receiver.start = -1;
        $receiver.end = -1;
      } else if (newSize.compareTo_11rb$(oldSize) > 0) {
        var needsToSeek = true;
        var bytesToAdd = newSize.subtract(oldSize);
        while (bytesToAdd.compareTo_11rb$(L0) > 0) {
          var tail_0 = buffer.writableSegment_kcn2v3$(1);
          var a = bytesToAdd;
          var b = Kotlin.Long.fromInt(8192 - tail_0.limit | 0);
          var segmentBytesToAdd = (a.compareTo_11rb$(b) <= 0 ? a : b).toInt();
          tail_0.limit = tail_0.limit + segmentBytesToAdd | 0;
          bytesToAdd = bytesToAdd.subtract(Kotlin.Long.fromInt(segmentBytesToAdd));
          if (needsToSeek) {
            $receiver.segment_8be2vx$ = tail_0;
            $receiver.offset = oldSize;
            $receiver.data = tail_0.data;
            $receiver.start = tail_0.limit - segmentBytesToAdd | 0;
            $receiver.end = tail_0.limit;
            needsToSeek = false;
          }}
      }buffer.size = newSize;
      return oldSize;
    };
  }));
  var commonExpandBuffer = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonExpandBuffer_2c8yq2$', wrapFunction(function () {
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, minByteCount) {
      if (!(minByteCount > 0)) {
        var message = 'minByteCount <= 0: ' + minByteCount;
        throw IllegalArgumentException_init(message.toString());
      }if (!(minByteCount <= 8192)) {
        var message_0 = 'minByteCount > Segment.SIZE: ' + minByteCount;
        throw IllegalArgumentException_init(message_0.toString());
      }var value = $receiver.buffer;
      var checkNotNull$result;
      if (value == null) {
        var message_1 = 'not attached to a buffer';
        throw IllegalStateException_init(message_1.toString());
      } else {
        checkNotNull$result = value;
      }
      var buffer = checkNotNull$result;
      if (!$receiver.readWrite) {
        var message_2 = 'expandBuffer() only permitted for read/write buffers';
        throw IllegalStateException_init(message_2.toString());
      }var oldSize = buffer.size;
      var tail = buffer.writableSegment_kcn2v3$(minByteCount);
      var result = 8192 - tail.limit | 0;
      tail.limit = 8192;
      buffer.size = oldSize.add(Kotlin.Long.fromInt(result));
      $receiver.segment_8be2vx$ = tail;
      $receiver.offset = oldSize;
      $receiver.data = tail.data;
      $receiver.start = 8192 - result | 0;
      $receiver.end = 8192;
      return Kotlin.Long.fromInt(result);
    };
  }));
  var commonClose = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonClose_6osl3o$', wrapFunction(function () {
    var L_1 = Kotlin.Long.NEG_ONE;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver) {
      if (!($receiver.buffer != null)) {
        var message = 'not attached to a buffer';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer = null;
      $receiver.segment_8be2vx$ = null;
      $receiver.offset = L_1;
      $receiver.data = null;
      $receiver.start = -1;
      $receiver.end = -1;
    };
  }));
  var commonUtf8 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonUtf8_gp9naf$', wrapFunction(function () {
    var toUtf8String = _.okio.toUtf8String_jln3ri$;
    return function ($receiver) {
      var result = $receiver.utf8_8be2vx$;
      if (result == null) {
        result = toUtf8String($receiver.internalArray());
        $receiver.utf8_8be2vx$ = result;
      }return result;
    };
  }));
  var commonBase64 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonBase64_gp9naf$', wrapFunction(function () {
    var encodeBase64 = _.okio.encodeBase64_q2fl5a$;
    return function ($receiver) {
      return encodeBase64($receiver.data_8be2vx$);
    };
  }));
  var commonBase64Url = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonBase64Url_gp9naf$', wrapFunction(function () {
    var okio = _.okio;
    var encodeBase64 = _.okio.encodeBase64_q2fl5a$;
    return function ($receiver) {
      return encodeBase64($receiver.data_8be2vx$, okio.BASE64_URL_SAFE_8be2vx$);
    };
  }));
  var HEX_DIGIT_CHARS;
  var commonHex = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonHex_gp9naf$', wrapFunction(function () {
    var internal = _.okio.internal;
    var concatToString = Kotlin.kotlin.text.concatToString_355ntz$;
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      var result = Kotlin.charArray($receiver.data_8be2vx$.length * 2 | 0);
      var c = 0;
      tmp$ = $receiver.data_8be2vx$;
      for (tmp$_0 = 0; tmp$_0 !== tmp$.length; ++tmp$_0) {
        var b = tmp$[tmp$_0];
        result[tmp$_1 = c, c = tmp$_1 + 1 | 0, tmp$_1] = internal.HEX_DIGIT_CHARS_8be2vx$[b >> 4 & 15];
        result[tmp$_2 = c, c = tmp$_2 + 1 | 0, tmp$_2] = internal.HEX_DIGIT_CHARS_8be2vx$[b & 15];
      }
      return concatToString(result);
    };
  }));
  var commonToAsciiLowercase = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonToAsciiLowercase_gp9naf$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var ByteString_init = _.okio.ByteString;
    return function ($receiver) {
      var tmp$;
      var i = 0;
      while (i < $receiver.data_8be2vx$.length) {
        var c = $receiver.data_8be2vx$[i];
        if (c < toByte(65) || c > toByte(90)) {
          i = i + 1 | 0;
          continue;
        }var lowercase = $receiver.data_8be2vx$.slice();
        lowercase[tmp$ = i, i = tmp$ + 1 | 0, tmp$] = toByte(c - -32);
        while (i < lowercase.length) {
          c = lowercase[i];
          if (c < toByte(65) || c > toByte(90)) {
            i = i + 1 | 0;
            continue;
          }lowercase[i] = toByte(c - -32);
          i = i + 1 | 0;
        }
        return new ByteString_init(lowercase);
      }
      return $receiver;
    };
  }));
  var commonToAsciiUppercase = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonToAsciiUppercase_gp9naf$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var ByteString_init = _.okio.ByteString;
    return function ($receiver) {
      var tmp$;
      var i = 0;
      while (i < $receiver.data_8be2vx$.length) {
        var c = $receiver.data_8be2vx$[i];
        if (c < toByte(97) || c > toByte(122)) {
          i = i + 1 | 0;
          continue;
        }var lowercase = $receiver.data_8be2vx$.slice();
        lowercase[tmp$ = i, i = tmp$ + 1 | 0, tmp$] = toByte(c - 32);
        while (i < lowercase.length) {
          c = lowercase[i];
          if (c < toByte(97) || c > toByte(122)) {
            i = i + 1 | 0;
            continue;
          }lowercase[i] = toByte(c - 32);
          i = i + 1 | 0;
        }
        return new ByteString_init(lowercase);
      }
      return $receiver;
    };
  }));
  var commonSubstring = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonSubstring_h0wzdx$', wrapFunction(function () {
    var resolveDefaultParameter = _.okio.resolveDefaultParameter_kvlz5j$;
    var copyOfRange = Kotlin.kotlin.collections.copyOfRange_ietg8x$;
    var ByteString_init = _.okio.ByteString;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, beginIndex, endIndex) {
      var endIndex_0 = resolveDefaultParameter($receiver, endIndex);
      if (!(beginIndex >= 0)) {
        var message = 'beginIndex < 0';
        throw IllegalArgumentException_init(message.toString());
      }if (!(endIndex_0 <= $receiver.data_8be2vx$.length)) {
        var message_0 = 'endIndex > length(' + $receiver.data_8be2vx$.length + ')';
        throw IllegalArgumentException_init(message_0.toString());
      }var subLen = endIndex_0 - beginIndex | 0;
      if (!(subLen >= 0)) {
        var message_1 = 'endIndex < beginIndex';
        throw IllegalArgumentException_init(message_1.toString());
      }if (beginIndex === 0 && endIndex_0 === $receiver.data_8be2vx$.length) {
        return $receiver;
      }return new ByteString_init(copyOfRange($receiver.data_8be2vx$, beginIndex, endIndex_0));
    };
  }));
  var commonGetByte = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonGetByte_kvlz5j$', function ($receiver, pos) {
    return $receiver.data_8be2vx$[pos];
  });
  var commonGetSize = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonGetSize_gp9naf$', function ($receiver) {
    return $receiver.data_8be2vx$.length;
  });
  var commonToByteArray = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonToByteArray_gp9naf$', function ($receiver) {
    return $receiver.data_8be2vx$.slice();
  });
  var commonInternalArray = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonInternalArray_gp9naf$', function ($receiver) {
    return $receiver.data_8be2vx$;
  });
  var commonRangeEquals_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRangeEquals_zi8eqq$', function ($receiver, offset, other, otherOffset, byteCount) {
    return other.rangeEquals_3fge6q$(otherOffset, $receiver.data_8be2vx$, offset, byteCount);
  });
  var commonRangeEquals_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRangeEquals_lwghk7$', wrapFunction(function () {
    var arrayRangeEquals = _.okio.arrayRangeEquals_lwkm2r$;
    return function ($receiver, offset, other, otherOffset, byteCount) {
      return offset >= 0 && offset <= ($receiver.data_8be2vx$.length - byteCount | 0) && otherOffset >= 0 && otherOffset <= (other.length - byteCount | 0) && arrayRangeEquals($receiver.data_8be2vx$, offset, other, otherOffset, byteCount);
    };
  }));
  var commonCopyInto = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonCopyInto_lwghk7$', wrapFunction(function () {
    var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
    return function ($receiver, offset, target, targetOffset, byteCount) {
      arrayCopy($receiver.data_8be2vx$, target, targetOffset, offset, offset + byteCount | 0);
    };
  }));
  var commonStartsWith = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonStartsWith_x3su66$', function ($receiver, prefix) {
    return $receiver.rangeEquals_kxw41n$(0, prefix, 0, prefix.size);
  });
  var commonStartsWith_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonStartsWith_754h9x$', function ($receiver, prefix) {
    return $receiver.rangeEquals_3fge6q$(0, prefix, 0, prefix.length);
  });
  var commonEndsWith = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonEndsWith_x3su66$', function ($receiver, suffix) {
    return $receiver.rangeEquals_kxw41n$($receiver.size - suffix.size | 0, suffix, 0, suffix.size);
  });
  var commonEndsWith_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonEndsWith_754h9x$', function ($receiver, suffix) {
    return $receiver.rangeEquals_3fge6q$($receiver.size - suffix.length | 0, suffix, 0, suffix.length);
  });
  var commonIndexOf_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonIndexOf_cpnqjn$', wrapFunction(function () {
    var arrayRangeEquals = _.okio.arrayRangeEquals_lwkm2r$;
    var JsMath = Math;
    return function ($receiver, other, fromIndex) {
      var limit = $receiver.data_8be2vx$.length - other.length | 0;
      for (var i = JsMath.max(fromIndex, 0); i <= limit; i++) {
        if (arrayRangeEquals($receiver.data_8be2vx$, i, other, 0, other.length)) {
          return i;
        }}
      return -1;
    };
  }));
  var commonLastIndexOf = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonLastIndexOf_cvng9c$', function ($receiver, other, fromIndex) {
    return $receiver.lastIndexOf_ir89t6$(other.internalArray(), fromIndex);
  });
  var commonLastIndexOf_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonLastIndexOf_cpnqjn$', wrapFunction(function () {
    var resolveDefaultParameter = _.okio.resolveDefaultParameter_kvlz5j$;
    var arrayRangeEquals = _.okio.arrayRangeEquals_lwkm2r$;
    var JsMath = Math;
    return function ($receiver, other, fromIndex) {
      var fromIndex_0 = resolveDefaultParameter($receiver, fromIndex);
      var limit = $receiver.data_8be2vx$.length - other.length | 0;
      for (var i = JsMath.min(fromIndex_0, limit); i >= 0; i--) {
        if (arrayRangeEquals($receiver.data_8be2vx$, i, other, 0, other.length)) {
          return i;
        }}
      return -1;
    };
  }));
  var commonEquals_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonEquals_7y1vpj$', wrapFunction(function () {
    var ByteString = _.okio.ByteString;
    return function ($receiver, other) {
      var tmp$;
      if (other === $receiver)
        tmp$ = true;
      else if (Kotlin.isType(other, ByteString))
        tmp$ = (other.size === $receiver.data_8be2vx$.length && other.rangeEquals_3fge6q$(0, $receiver.data_8be2vx$, 0, $receiver.data_8be2vx$.length));
      else
        tmp$ = false;
      return tmp$;
    };
  }));
  var commonHashCode_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonHashCode_gp9naf$', wrapFunction(function () {
    var contentHashCode = Kotlin.arrayHashCode;
    return function ($receiver) {
      var result = $receiver.hashCode_8be2vx$;
      if (result !== 0)
        return result;
      var $receiver_0 = contentHashCode($receiver.data_8be2vx$);
      $receiver.hashCode_8be2vx$ = $receiver_0;
      return $receiver_0;
    };
  }));
  var commonCompareTo = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonCompareTo_x3su66$', wrapFunction(function () {
    var JsMath = Math;
    return function ($receiver, other) {
      var sizeA = $receiver.size;
      var sizeB = other.size;
      var i = 0;
      var size = JsMath.min(sizeA, sizeB);
      while (i < size) {
        var byteA = $receiver.get_za3lpa$(i) & 255;
        var byteB = other.get_za3lpa$(i) & 255;
        if (byteA === byteB) {
          i = i + 1 | 0;
          continue;
        }return byteA < byteB ? -1 : 1;
      }
      if (sizeA === sizeB)
        return 0;
      return sizeA < sizeB ? -1 : 1;
    };
  }));
  var commonOf = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonOf_ma41of$', wrapFunction(function () {
    var ByteString_init = _.okio.ByteString;
    return function (data) {
      return new ByteString_init(data.slice());
    };
  }));
  var commonToByteString = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonToByteString_3krwv6$', wrapFunction(function () {
    var checkOffsetAndCount = _.okio.checkOffsetAndCount_e84ct6$;
    var copyOfRange = Kotlin.kotlin.collections.copyOfRange_ietg8x$;
    var ByteString_init = _.okio.ByteString;
    return function ($receiver, offset, byteCount) {
      checkOffsetAndCount(Kotlin.Long.fromInt($receiver.length), Kotlin.Long.fromInt(offset), Kotlin.Long.fromInt(byteCount));
      return new ByteString_init(copyOfRange($receiver, offset, offset + byteCount | 0));
    };
  }));
  var commonEncodeUtf8 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonEncodeUtf8_7efafi$', wrapFunction(function () {
    var asUtf8ToByteArray = _.okio.asUtf8ToByteArray_7efafi$;
    var ByteString_init = _.okio.ByteString;
    return function ($receiver) {
      var byteString = new ByteString_init(asUtf8ToByteArray($receiver));
      byteString.utf8_8be2vx$ = $receiver;
      return byteString;
    };
  }));
  var commonDecodeBase64 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonDecodeBase64_7efafi$', wrapFunction(function () {
    var decodeBase64ToArray = _.okio.decodeBase64ToArray_7efafi$;
    var ByteString_init = _.okio.ByteString;
    return function ($receiver) {
      var decoded = decodeBase64ToArray($receiver);
      return decoded != null ? new ByteString_init(decoded) : null;
    };
  }));
  var commonDecodeHex = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonDecodeHex_7efafi$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var ByteString_init = _.okio.ByteString;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver) {
      if (!($receiver.length % 2 === 0)) {
        var message = 'Unexpected hex string: ' + $receiver;
        throw IllegalArgumentException_init(message.toString());
      }var result = new Int8Array($receiver.length / 2 | 0);
      for (var i = 0; i !== result.length; ++i) {
        var d1 = decodeHexDigit($receiver.charCodeAt(i * 2 | 0)) << 4;
        var d2 = decodeHexDigit($receiver.charCodeAt((i * 2 | 0) + 1 | 0));
        result[i] = toByte(d1 + d2 | 0);
      }
      return new ByteString_init(result);
    };
  }));
  function commonWrite_4($receiver, buffer, offset, byteCount) {
    buffer.write_mj6st8$($receiver.data_8be2vx$, offset, byteCount);
  }
  function decodeHexDigit(c) {
    var tmp$;
    if ((new CharRange(48, 57)).contains_mef7kx$(c))
      tmp$ = c - 48;
    else if ((new CharRange(97, 102)).contains_mef7kx$(c))
      tmp$ = c - 97 + 10 | 0;
    else if ((new CharRange(65, 70)).contains_mef7kx$(c))
      tmp$ = c - 65 + 10 | 0;
    else
      throw IllegalArgumentException_init('Unexpected hex digit: ' + String.fromCharCode(c));
    return tmp$;
  }
  var commonToString = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonToString_gp9naf$', wrapFunction(function () {
    var replace = Kotlin.kotlin.text.replace_680rmw$;
    var resolveDefaultParameter = _.okio.resolveDefaultParameter_kvlz5j$;
    var copyOfRange = Kotlin.kotlin.collections.copyOfRange_ietg8x$;
    var ByteString_init = _.okio.ByteString;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver) {
      var tmp$, tmp$_0;
      if ($receiver.data_8be2vx$.length === 0)
        return '[size=0]';
      var i = codePointIndexToCharIndex($receiver.data_8be2vx$, 64);
      if (i === -1) {
        if ($receiver.data_8be2vx$.length <= 64) {
          tmp$ = '[hex=' + $receiver.hex() + ']';
        } else {
          var tmp$_1 = '[size=' + $receiver.data_8be2vx$.length + ' hex=';
          var commonSubstring$result;
          commonSubstring$break: do {
            var endIndex = resolveDefaultParameter($receiver, 64);
            if (!(0 >= 0)) {
              var message = 'beginIndex < 0';
              throw IllegalArgumentException_init(message.toString());
            }if (!(endIndex <= $receiver.data_8be2vx$.length)) {
              var message_0 = 'endIndex > length(' + $receiver.data_8be2vx$.length + ')';
              throw IllegalArgumentException_init(message_0.toString());
            }var subLen = endIndex - 0 | 0;
            if (!(subLen >= 0)) {
              var message_1 = 'endIndex < beginIndex';
              throw IllegalArgumentException_init(message_1.toString());
            }if (0 === 0 && endIndex === $receiver.data_8be2vx$.length) {
              commonSubstring$result = $receiver;
              break commonSubstring$break;
            }commonSubstring$result = new ByteString_init(copyOfRange($receiver.data_8be2vx$, 0, endIndex));
          }
           while (false);
          tmp$ = tmp$_1 + commonSubstring$result.hex() + '\u2026]';
        }
        return tmp$;
      }var text = $receiver.utf8();
      var safeText = replace(replace(replace(text.substring(0, i), '\\', '\\\\'), '\n', '\\n'), '\r', '\\r');
      if (i < text.length) {
        tmp$_0 = '[size=' + $receiver.data_8be2vx$.length + ' text=' + safeText + '\u2026]';
      } else {
        tmp$_0 = '[text=' + safeText + ']';
      }
      return tmp$_0;
    };
  }));
  function codePointIndexToCharIndex(s, codePointCount) {
    var charCount = {v: 0};
    var j = {v: 0};
    var tmp$;
    var index = 0;
    loop_label: while (index < s.length) {
      var b0 = s[index];
      if (b0 >= 0) {
        var tmp$_0;
        if ((tmp$_0 = j.v, j.v = tmp$_0 + 1 | 0, tmp$_0) === codePointCount) {
          return charCount.v;
        }var tmp$_1 = b0 !== 10 && b0 !== 13;
        if (tmp$_1) {
          tmp$_1 = 0 <= b0 && b0 <= 31 || (127 <= b0 && b0 <= 159);
        }if (tmp$_1 || b0 === 65533) {
          return -1;
        }charCount.v = charCount.v + (b0 < 65536 ? 1 : 2) | 0;
        index = index + 1 | 0;
        while (index < s.length && s[index] >= 0) {
          var c = s[tmp$ = index, index = tmp$ + 1 | 0, tmp$];
          var tmp$_2;
          if ((tmp$_2 = j.v, j.v = tmp$_2 + 1 | 0, tmp$_2) === codePointCount) {
            return charCount.v;
          }var tmp$_3 = c !== 10 && c !== 13;
          if (tmp$_3) {
            tmp$_3 = 0 <= c && c <= 31 || (127 <= c && c <= 159);
          }if (tmp$_3 || c === 65533) {
            return -1;
          }charCount.v = charCount.v + (c < 65536 ? 1 : 2) | 0;
        }
      } else {
        if (b0 >> 5 === -2) {
          var tmp$_4 = index;
          var beginIndex = index;
          var process2Utf8Bytes$result;
          process2Utf8Bytes$break: do {
            if (s.length <= (beginIndex + 1 | 0)) {
              var tmp$_5;
              if ((tmp$_5 = j.v, j.v = tmp$_5 + 1 | 0, tmp$_5) === codePointCount) {
                return charCount.v;
              }var tmp$_6 = 65533 !== 10 && 65533 !== 13;
              if (tmp$_6) {
                tmp$_6 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
              }if (tmp$_6 || 65533 === 65533) {
                return -1;
              }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
              process2Utf8Bytes$result = 1;
              break process2Utf8Bytes$break;
            }var b0_0 = s[beginIndex];
            var b1 = s[beginIndex + 1 | 0];
            if (!((b1 & 192) === 128)) {
              var tmp$_7;
              if ((tmp$_7 = j.v, j.v = tmp$_7 + 1 | 0, tmp$_7) === codePointCount) {
                return charCount.v;
              }var tmp$_8 = 65533 !== 10 && 65533 !== 13;
              if (tmp$_8) {
                tmp$_8 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
              }if (tmp$_8 || 65533 === 65533) {
                return -1;
              }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
              process2Utf8Bytes$result = 1;
              break process2Utf8Bytes$break;
            }var codePoint = 3968 ^ b1 ^ b0_0 << 6;
            if (codePoint < 128) {
              var tmp$_9;
              if ((tmp$_9 = j.v, j.v = tmp$_9 + 1 | 0, tmp$_9) === codePointCount) {
                return charCount.v;
              }var tmp$_10 = 65533 !== 10 && 65533 !== 13;
              if (tmp$_10) {
                tmp$_10 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
              }if (tmp$_10 || 65533 === 65533) {
                return -1;
              }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
            } else {
              var tmp$_11;
              if ((tmp$_11 = j.v, j.v = tmp$_11 + 1 | 0, tmp$_11) === codePointCount) {
                return charCount.v;
              }var tmp$_12 = codePoint !== 10 && codePoint !== 13;
              if (tmp$_12) {
                tmp$_12 = 0 <= codePoint && codePoint <= 31 || (127 <= codePoint && codePoint <= 159);
              }if (tmp$_12 || codePoint === 65533) {
                return -1;
              }charCount.v = charCount.v + (codePoint < 65536 ? 1 : 2) | 0;
            }
            process2Utf8Bytes$result = 2;
          }
           while (false);
          index = tmp$_4 + process2Utf8Bytes$result | 0;
        } else {
          if (b0 >> 4 === -2) {
            var tmp$_13 = index;
            var beginIndex_0 = index;
            var process3Utf8Bytes$result;
            process3Utf8Bytes$break: do {
              if (s.length <= (beginIndex_0 + 2 | 0)) {
                var tmp$_14;
                if ((tmp$_14 = j.v, j.v = tmp$_14 + 1 | 0, tmp$_14) === codePointCount) {
                  return charCount.v;
                }var tmp$_15 = 65533 !== 10 && 65533 !== 13;
                if (tmp$_15) {
                  tmp$_15 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                }if (tmp$_15 || 65533 === 65533) {
                  return -1;
                }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
                var tmp$_16 = s.length <= (beginIndex_0 + 1 | 0);
                if (!tmp$_16) {
                  tmp$_16 = !((s[beginIndex_0 + 1 | 0] & 192) === 128);
                }if (tmp$_16) {
                  process3Utf8Bytes$result = 1;
                  break process3Utf8Bytes$break;
                } else {
                  process3Utf8Bytes$result = 2;
                  break process3Utf8Bytes$break;
                }
              }var b0_1 = s[beginIndex_0];
              var b1_0 = s[beginIndex_0 + 1 | 0];
              if (!((b1_0 & 192) === 128)) {
                var tmp$_17;
                if ((tmp$_17 = j.v, j.v = tmp$_17 + 1 | 0, tmp$_17) === codePointCount) {
                  return charCount.v;
                }var tmp$_18 = 65533 !== 10 && 65533 !== 13;
                if (tmp$_18) {
                  tmp$_18 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                }if (tmp$_18 || 65533 === 65533) {
                  return -1;
                }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
                process3Utf8Bytes$result = 1;
                break process3Utf8Bytes$break;
              }var b2 = s[beginIndex_0 + 2 | 0];
              if (!((b2 & 192) === 128)) {
                var tmp$_19;
                if ((tmp$_19 = j.v, j.v = tmp$_19 + 1 | 0, tmp$_19) === codePointCount) {
                  return charCount.v;
                }var tmp$_20 = 65533 !== 10 && 65533 !== 13;
                if (tmp$_20) {
                  tmp$_20 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                }if (tmp$_20 || 65533 === 65533) {
                  return -1;
                }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
                process3Utf8Bytes$result = 2;
                break process3Utf8Bytes$break;
              }var codePoint_0 = -123008 ^ b2 ^ b1_0 << 6 ^ b0_1 << 12;
              if (codePoint_0 < 2048) {
                var tmp$_21;
                if ((tmp$_21 = j.v, j.v = tmp$_21 + 1 | 0, tmp$_21) === codePointCount) {
                  return charCount.v;
                }var tmp$_22 = 65533 !== 10 && 65533 !== 13;
                if (tmp$_22) {
                  tmp$_22 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                }if (tmp$_22 || 65533 === 65533) {
                  return -1;
                }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
              } else if (55296 <= codePoint_0 && codePoint_0 <= 57343) {
                var tmp$_23;
                if ((tmp$_23 = j.v, j.v = tmp$_23 + 1 | 0, tmp$_23) === codePointCount) {
                  return charCount.v;
                }var tmp$_24 = 65533 !== 10 && 65533 !== 13;
                if (tmp$_24) {
                  tmp$_24 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                }if (tmp$_24 || 65533 === 65533) {
                  return -1;
                }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
              } else {
                var tmp$_25;
                if ((tmp$_25 = j.v, j.v = tmp$_25 + 1 | 0, tmp$_25) === codePointCount) {
                  return charCount.v;
                }var tmp$_26 = codePoint_0 !== 10 && codePoint_0 !== 13;
                if (tmp$_26) {
                  tmp$_26 = 0 <= codePoint_0 && codePoint_0 <= 31 || (127 <= codePoint_0 && codePoint_0 <= 159);
                }if (tmp$_26 || codePoint_0 === 65533) {
                  return -1;
                }charCount.v = charCount.v + (codePoint_0 < 65536 ? 1 : 2) | 0;
              }
              process3Utf8Bytes$result = 3;
            }
             while (false);
            index = tmp$_13 + process3Utf8Bytes$result | 0;
          } else {
            if (b0 >> 3 === -2) {
              var tmp$_27 = index;
              var beginIndex_1 = index;
              var process4Utf8Bytes$result;
              process4Utf8Bytes$break: do {
                if (s.length <= (beginIndex_1 + 3 | 0)) {
                  var tmp$_28;
                  if ((tmp$_28 = j.v, j.v = tmp$_28 + 1 | 0, tmp$_28) === codePointCount) {
                    return charCount.v;
                  }var tmp$_29 = 65533 !== 10 && 65533 !== 13;
                  if (tmp$_29) {
                    tmp$_29 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                  }if (tmp$_29 || 65533 === 65533) {
                    return -1;
                  }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
                  var tmp$_30 = s.length <= (beginIndex_1 + 1 | 0);
                  if (!tmp$_30) {
                    tmp$_30 = !((s[beginIndex_1 + 1 | 0] & 192) === 128);
                  }if (tmp$_30) {
                    process4Utf8Bytes$result = 1;
                    break process4Utf8Bytes$break;
                  } else {
                    var tmp$_31 = s.length <= (beginIndex_1 + 2 | 0);
                    if (!tmp$_31) {
                      tmp$_31 = !((s[beginIndex_1 + 2 | 0] & 192) === 128);
                    }if (tmp$_31) {
                      process4Utf8Bytes$result = 2;
                      break process4Utf8Bytes$break;
                    } else {
                      process4Utf8Bytes$result = 3;
                      break process4Utf8Bytes$break;
                    }
                  }
                }var b0_2 = s[beginIndex_1];
                var b1_1 = s[beginIndex_1 + 1 | 0];
                if (!((b1_1 & 192) === 128)) {
                  var tmp$_32;
                  if ((tmp$_32 = j.v, j.v = tmp$_32 + 1 | 0, tmp$_32) === codePointCount) {
                    return charCount.v;
                  }var tmp$_33 = 65533 !== 10 && 65533 !== 13;
                  if (tmp$_33) {
                    tmp$_33 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                  }if (tmp$_33 || 65533 === 65533) {
                    return -1;
                  }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
                  process4Utf8Bytes$result = 1;
                  break process4Utf8Bytes$break;
                }var b2_0 = s[beginIndex_1 + 2 | 0];
                if (!((b2_0 & 192) === 128)) {
                  var tmp$_34;
                  if ((tmp$_34 = j.v, j.v = tmp$_34 + 1 | 0, tmp$_34) === codePointCount) {
                    return charCount.v;
                  }var tmp$_35 = 65533 !== 10 && 65533 !== 13;
                  if (tmp$_35) {
                    tmp$_35 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                  }if (tmp$_35 || 65533 === 65533) {
                    return -1;
                  }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
                  process4Utf8Bytes$result = 2;
                  break process4Utf8Bytes$break;
                }var b3 = s[beginIndex_1 + 3 | 0];
                if (!((b3 & 192) === 128)) {
                  var tmp$_36;
                  if ((tmp$_36 = j.v, j.v = tmp$_36 + 1 | 0, tmp$_36) === codePointCount) {
                    return charCount.v;
                  }var tmp$_37 = 65533 !== 10 && 65533 !== 13;
                  if (tmp$_37) {
                    tmp$_37 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                  }if (tmp$_37 || 65533 === 65533) {
                    return -1;
                  }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
                  process4Utf8Bytes$result = 3;
                  break process4Utf8Bytes$break;
                }var codePoint_1 = 3678080 ^ b3 ^ b2_0 << 6 ^ b1_1 << 12 ^ b0_2 << 18;
                if (codePoint_1 > 1114111) {
                  var tmp$_38;
                  if ((tmp$_38 = j.v, j.v = tmp$_38 + 1 | 0, tmp$_38) === codePointCount) {
                    return charCount.v;
                  }var tmp$_39 = 65533 !== 10 && 65533 !== 13;
                  if (tmp$_39) {
                    tmp$_39 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                  }if (tmp$_39 || 65533 === 65533) {
                    return -1;
                  }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
                } else if (55296 <= codePoint_1 && codePoint_1 <= 57343) {
                  var tmp$_40;
                  if ((tmp$_40 = j.v, j.v = tmp$_40 + 1 | 0, tmp$_40) === codePointCount) {
                    return charCount.v;
                  }var tmp$_41 = 65533 !== 10 && 65533 !== 13;
                  if (tmp$_41) {
                    tmp$_41 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                  }if (tmp$_41 || 65533 === 65533) {
                    return -1;
                  }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
                } else if (codePoint_1 < 65536) {
                  var tmp$_42;
                  if ((tmp$_42 = j.v, j.v = tmp$_42 + 1 | 0, tmp$_42) === codePointCount) {
                    return charCount.v;
                  }var tmp$_43 = 65533 !== 10 && 65533 !== 13;
                  if (tmp$_43) {
                    tmp$_43 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
                  }if (tmp$_43 || 65533 === 65533) {
                    return -1;
                  }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
                } else {
                  var tmp$_44;
                  if ((tmp$_44 = j.v, j.v = tmp$_44 + 1 | 0, tmp$_44) === codePointCount) {
                    return charCount.v;
                  }var tmp$_45 = codePoint_1 !== 10 && codePoint_1 !== 13;
                  if (tmp$_45) {
                    tmp$_45 = 0 <= codePoint_1 && codePoint_1 <= 31 || (127 <= codePoint_1 && codePoint_1 <= 159);
                  }if (tmp$_45 || codePoint_1 === 65533) {
                    return -1;
                  }charCount.v = charCount.v + (codePoint_1 < 65536 ? 1 : 2) | 0;
                }
                process4Utf8Bytes$result = 4;
              }
               while (false);
              index = tmp$_27 + process4Utf8Bytes$result | 0;
            } else {
              var tmp$_46;
              if ((tmp$_46 = j.v, j.v = tmp$_46 + 1 | 0, tmp$_46) === codePointCount) {
                return charCount.v;
              }var tmp$_47 = 65533 !== 10 && 65533 !== 13;
              if (tmp$_47) {
                tmp$_47 = 0 <= 65533 && 65533 <= 31 || (127 <= 65533 && 65533 <= 159);
              }if (tmp$_47 || 65533 === 65533) {
                return -1;
              }charCount.v = charCount.v + (65533 < 65536 ? 1 : 2) | 0;
              index = index + 1 | 0;
            }
          }
        }
      }
    }
    return charCount.v;
  }
  function commonMetadata($receiver, path) {
    var tmp$;
    tmp$ = $receiver.metadataOrNull_awoskx$(path);
    if (tmp$ == null) {
      throw new FileNotFoundException('no such file: ' + path);
    }return tmp$;
  }
  function commonExists($receiver, path) {
    return $receiver.metadataOrNull_awoskx$(path) != null;
  }
  function commonCreateDirectories($receiver, dir, mustCreate) {
    var tmp$;
    var directories = ArrayDeque_init();
    var path = dir;
    while (path != null && !$receiver.exists_awoskx$(path)) {
      directories.addFirst_11rb$(path);
      path = path.parent;
    }
    if (mustCreate && directories.isEmpty())
      throw IOException_init(dir.toString() + ' already exist.');
    tmp$ = directories.iterator();
    while (tmp$.hasNext()) {
      var toCreate = tmp$.next();
      $receiver.createDirectory_1apv92$(toCreate);
    }
  }
  function commonCopy_0($receiver, source, target) {
    var $receiver_0 = $receiver.source_awoskx$(source);
    var result = null;
    var thrown = null;
    try {
      var $receiver_1 = buffer_0($receiver.sink_1apv92$(target));
      var result_0 = null;
      var thrown_0 = null;
      try {
        result_0 = $receiver_1.writeAll_sby9nd$($receiver_0);
      } catch (t) {
        if (Kotlin.isType(t, Throwable)) {
          thrown_0 = t;
        } else
          throw t;
      }
      try {
        $receiver_1 != null ? ($receiver_1.close(), Unit) : null;
      } catch (t_0) {
        if (Kotlin.isType(t_0, Throwable)) {
          if (thrown_0 == null)
            thrown_0 = t_0;
          else
            addSuppressed(thrown_0, t_0);
        } else
          throw t_0;
      }
      if (thrown_0 != null)
        throw thrown_0;
      result = ensureNotNull(result_0);
    } catch (t_1) {
      if (Kotlin.isType(t_1, Throwable)) {
        thrown = t_1;
      } else
        throw t_1;
    }
    try {
      $receiver_0 != null ? ($receiver_0.close(), Unit) : null;
    } catch (t_2) {
      if (Kotlin.isType(t_2, Throwable)) {
        if (thrown == null)
          thrown = t_2;
        else
          addSuppressed(thrown, t_2);
      } else
        throw t_2;
    }
    if (thrown != null)
      throw thrown;
    ensureNotNull(result);
  }
  function Coroutine$commonDeleteRecursively$lambda(this$commonDeleteRecursively_0, closure$fileOrDirectory_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$commonDeleteRecursively = this$commonDeleteRecursively_0;
    this.local$closure$fileOrDirectory = closure$fileOrDirectory_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$commonDeleteRecursively$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$commonDeleteRecursively$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$commonDeleteRecursively$lambda.prototype.constructor = Coroutine$commonDeleteRecursively$lambda;
  Coroutine$commonDeleteRecursively$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = collectRecursively(this.local$$receiver, this.local$this$commonDeleteRecursively, ArrayDeque_init(), this.local$closure$fileOrDirectory, false, true, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function commonDeleteRecursively$lambda(this$commonDeleteRecursively_0, closure$fileOrDirectory_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$commonDeleteRecursively$lambda(this$commonDeleteRecursively_0, closure$fileOrDirectory_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function commonDeleteRecursively($receiver, fileOrDirectory, mustExist) {
    var sequence_0 = sequence(commonDeleteRecursively$lambda($receiver, fileOrDirectory));
    var iterator = sequence_0.iterator();
    while (iterator.hasNext()) {
      var toDelete = iterator.next();
      $receiver.delete_1apv92$(toDelete, mustExist && !iterator.hasNext());
    }
  }
  function Coroutine$commonListRecursively$lambda(closure$dir_0, this$commonListRecursively_0, closure$followSymlinks_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$dir = closure$dir_0;
    this.local$this$commonListRecursively = this$commonListRecursively_0;
    this.local$closure$followSymlinks = closure$followSymlinks_0;
    this.local$tmp$ = void 0;
    this.local$stack = void 0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$commonListRecursively$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$commonListRecursively$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$commonListRecursively$lambda.prototype.constructor = Coroutine$commonListRecursively$lambda;
  Coroutine$commonListRecursively$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$stack = ArrayDeque_init();
            this.local$stack.addLast_11rb$(this.local$closure$dir);
            this.local$tmp$ = this.local$this$commonListRecursively.list_awoskx$(this.local$closure$dir).iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            var child = this.local$tmp$.next();
            this.state_0 = 3;
            this.result_0 = collectRecursively(this.local$$receiver, this.local$this$commonListRecursively, this.local$stack, child, this.local$closure$followSymlinks, false, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 2;
            continue;
          case 4:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function commonListRecursively$lambda(closure$dir_0, this$commonListRecursively_0, closure$followSymlinks_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$commonListRecursively$lambda(closure$dir_0, this$commonListRecursively_0, closure$followSymlinks_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function commonListRecursively($receiver, dir, followSymlinks) {
    return sequence(commonListRecursively$lambda(dir, $receiver, followSymlinks));
  }
  function Coroutine$collectRecursively($receiver_0, fileSystem_0, stack_0, path_0, followSymlinks_0, postorder_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 13;
    this.local$tmp$_1 = void 0;
    this.local$$receiver = $receiver_0;
    this.local$fileSystem = fileSystem_0;
    this.local$stack = stack_0;
    this.local$path = path_0;
    this.local$followSymlinks = followSymlinks_0;
    this.local$postorder = postorder_0;
  }
  Coroutine$collectRecursively.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$collectRecursively.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collectRecursively.prototype.constructor = Coroutine$collectRecursively;
  Coroutine$collectRecursively.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$, tmp$_0;
            if (!this.local$postorder) {
              this.state_0 = 1;
              this.result_0 = this.local$$receiver.yield_11rb$(this.local$path, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 2;
              continue;
            }

          case 1:
            this.state_0 = 2;
            continue;
          case 2:
            var children = (tmp$ = this.local$fileSystem.listOrNull_awoskx$(this.local$path)) != null ? tmp$ : emptyList();
            if (!children.isEmpty()) {
              var symlinkPath = this.local$path;
              var symlinkCount = 0;
              while (true) {
                if (this.local$followSymlinks && this.local$stack.contains_11rb$(symlinkPath))
                  throw IOException_init('symlink cycle at ' + this.local$path);
                tmp$_0 = symlinkTarget(this.local$fileSystem, symlinkPath);
                if (tmp$_0 == null) {
                  break;
                }symlinkPath = tmp$_0;
                symlinkCount = symlinkCount + 1 | 0;
              }
              if (this.local$followSymlinks || symlinkCount === 0) {
                this.local$stack.addLast_11rb$(symlinkPath);
                this.exceptionState_0 = 11;
                this.local$tmp$_1 = children.iterator();
                this.state_0 = 3;
                continue;
              } else {
                this.state_0 = 7;
                continue;
              }
            } else {
              this.state_0 = 8;
              continue;
            }

          case 3:
            if (!this.local$tmp$_1.hasNext()) {
              this.state_0 = 5;
              continue;
            }
            var child = this.local$tmp$_1.next();
            this.state_0 = 4;
            this.result_0 = collectRecursively(this.local$$receiver, this.local$fileSystem, this.local$stack, child, this.local$followSymlinks, this.local$postorder, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            this.state_0 = 3;
            continue;
          case 5:
            this.exceptionState_0 = 13;
            this.finallyPath_0 = [6];
            this.state_0 = 12;
            continue;
          case 6:
            this.state_0 = 7;
            continue;
          case 7:
            this.state_0 = 8;
            continue;
          case 8:
            if (this.local$postorder) {
              this.state_0 = 9;
              this.result_0 = this.local$$receiver.yield_11rb$(this.local$path, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 10;
              continue;
            }

          case 9:
            this.state_0 = 10;
            continue;
          case 10:
            return;
          case 11:
            this.finallyPath_0 = [13];
            this.state_0 = 12;
            continue;
          case 12:
            this.exceptionState_0 = 13;
            this.local$stack.removeLast();
            this.state_0 = this.finallyPath_0.shift();
            continue;
          case 13:
            throw this.exception_0;
          default:this.state_0 = 13;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 13) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function collectRecursively($receiver_0, fileSystem_0, stack_0, path_0, followSymlinks_0, postorder_0, continuation_0, suspended) {
    var instance = new Coroutine$collectRecursively($receiver_0, fileSystem_0, stack_0, path_0, followSymlinks_0, postorder_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function symlinkTarget($receiver, path) {
    var tmp$;
    tmp$ = $receiver.metadata_awoskx$(path).symlinkTarget;
    if (tmp$ == null) {
      return null;
    }var target = tmp$;
    return ensureNotNull(path.parent).div_awoskx$(target);
  }
  var SLASH;
  var BACKSLASH;
  var ANY_SLASH;
  var DOT;
  var DOT_DOT;
  var commonRoot = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRoot_wel18l$', wrapFunction(function () {
    var Path_init = _.okio.Path;
    return function ($receiver) {
      var tmp$;
      var rootLength_0 = rootLength($receiver);
      if (rootLength_0 === -1)
        tmp$ = null;
      else
        tmp$ = new Path_init($receiver.bytes_8be2vx$.substring_vux9f0$(0, rootLength_0));
      return tmp$;
    };
  }));
  var commonSegments = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonSegments_wel18l$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
    var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
    var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
    return function ($receiver) {
      var tmp$;
      var result = ArrayList_init();
      var segmentStart = rootLength($receiver);
      if (segmentStart === -1) {
        segmentStart = 0;
      } else if (segmentStart < $receiver.bytes_8be2vx$.size && $receiver.bytes_8be2vx$.get_za3lpa$(segmentStart) === toByte(92)) {
        segmentStart = segmentStart + 1 | 0;
      }tmp$ = $receiver.bytes_8be2vx$.size;
      for (var i = segmentStart; i < tmp$; i++) {
        if ($receiver.bytes_8be2vx$.get_za3lpa$(i) === toByte(47) || $receiver.bytes_8be2vx$.get_za3lpa$(i) === toByte(92)) {
          var element = $receiver.bytes_8be2vx$.substring_vux9f0$(segmentStart, i);
          result.add_11rb$(element);
          segmentStart = i + 1 | 0;
        }}
      if (segmentStart < $receiver.bytes_8be2vx$.size) {
        var element_0 = $receiver.bytes_8be2vx$.substring_vux9f0$(segmentStart, $receiver.bytes_8be2vx$.size);
        result.add_11rb$(element_0);
      }var destination = ArrayList_init_0(collectionSizeOrDefault(result, 10));
      var tmp$_0;
      tmp$_0 = result.iterator();
      while (tmp$_0.hasNext()) {
        var item = tmp$_0.next();
        destination.add_11rb$(item.utf8());
      }
      return destination;
    };
  }));
  var commonSegmentsBytes = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonSegmentsBytes_wel18l$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
    return function ($receiver) {
      var tmp$;
      var result = ArrayList_init();
      var segmentStart = rootLength($receiver);
      if (segmentStart === -1) {
        segmentStart = 0;
      } else if (segmentStart < $receiver.bytes_8be2vx$.size && $receiver.bytes_8be2vx$.get_za3lpa$(segmentStart) === toByte(92)) {
        segmentStart = segmentStart + 1 | 0;
      }tmp$ = $receiver.bytes_8be2vx$.size;
      for (var i = segmentStart; i < tmp$; i++) {
        if ($receiver.bytes_8be2vx$.get_za3lpa$(i) === toByte(47) || $receiver.bytes_8be2vx$.get_za3lpa$(i) === toByte(92)) {
          var element = $receiver.bytes_8be2vx$.substring_vux9f0$(segmentStart, i);
          result.add_11rb$(element);
          segmentStart = i + 1 | 0;
        }}
      if (segmentStart < $receiver.bytes_8be2vx$.size) {
        var element_0 = $receiver.bytes_8be2vx$.substring_vux9f0$(segmentStart, $receiver.bytes_8be2vx$.size);
        result.add_11rb$(element_0);
      }return result;
    };
  }));
  function rootLength($receiver) {
    if ($receiver.bytes_8be2vx$.size === 0)
      return -1;
    if ($receiver.bytes_8be2vx$.get_za3lpa$(0) === toByte(47))
      return 1;
    if ($receiver.bytes_8be2vx$.get_za3lpa$(0) === toByte(92)) {
      if ($receiver.bytes_8be2vx$.size > 2 && $receiver.bytes_8be2vx$.get_za3lpa$(1) === toByte(92)) {
        var uncRootEnd = $receiver.bytes_8be2vx$.indexOf_598ac7$(BACKSLASH, 2);
        if (uncRootEnd === -1)
          uncRootEnd = $receiver.bytes_8be2vx$.size;
        return uncRootEnd;
      }return 1;
    }if ($receiver.bytes_8be2vx$.size > 2 && $receiver.bytes_8be2vx$.get_za3lpa$(1) === toByte(58) && $receiver.bytes_8be2vx$.get_za3lpa$(2) === toByte(92)) {
      var c = toChar($receiver.bytes_8be2vx$.get_za3lpa$(0));
      if (!(new CharRange(97, 122)).contains_mef7kx$(c) && !(new CharRange(65, 90)).contains_mef7kx$(c))
        return -1;
      return 3;
    }return -1;
  }
  var commonIsAbsolute = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonIsAbsolute_wel18l$', function ($receiver) {
    return rootLength($receiver) !== -1;
  });
  var commonIsRelative = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonIsRelative_wel18l$', function ($receiver) {
    return rootLength($receiver) === -1;
  });
  var commonVolumeLetter = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonVolumeLetter_wel18l$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var toChar = Kotlin.toChar;
    var CharRange = Kotlin.kotlin.ranges.CharRange;
    return function ($receiver) {
      if ($receiver.bytes_8be2vx$.indexOf_598ac7$(SLASH) !== -1)
        return null;
      if ($receiver.bytes_8be2vx$.size < 2)
        return null;
      if ($receiver.bytes_8be2vx$.get_za3lpa$(1) !== toByte(58))
        return null;
      var c = toChar($receiver.bytes_8be2vx$.get_za3lpa$(0));
      if (!(new CharRange(97, 122)).contains_mef7kx$(c) && !(new CharRange(65, 90)).contains_mef7kx$(c))
        return null;
      return c;
    };
  }));
  function get_indexOfLastSlash($receiver) {
    var lastSlash = $receiver.bytes_8be2vx$.lastIndexOf_598ac7$(SLASH);
    if (lastSlash !== -1)
      return lastSlash;
    return $receiver.bytes_8be2vx$.lastIndexOf_598ac7$(BACKSLASH);
  }
  var commonNameBytes = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonNameBytes_wel18l$', wrapFunction(function () {
    var ByteString = _.okio.ByteString;
    var unboxChar = Kotlin.unboxChar;
    return function ($receiver) {
      var tmp$;
      var lastSlash = get_indexOfLastSlash($receiver);
      if (lastSlash !== -1)
        tmp$ = $receiver.bytes_8be2vx$.substring_vux9f0$(lastSlash + 1 | 0);
      else if (unboxChar($receiver.volumeLetter) != null && $receiver.bytes_8be2vx$.size === 2)
        tmp$ = ByteString.Companion.EMPTY;
      else
        tmp$ = $receiver.bytes_8be2vx$;
      return tmp$;
    };
  }));
  var commonName = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonName_wel18l$', function ($receiver) {
    return $receiver.nameBytes.utf8();
  });
  var commonParent = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonParent_wel18l$', wrapFunction(function () {
    var Path_init = _.okio.Path;
    var unboxChar = Kotlin.unboxChar;
    return function ($receiver) {
      var tmp$, tmp$_0, tmp$_1;
      if (((tmp$ = $receiver.bytes_8be2vx$) != null ? tmp$.equals(DOT) : null) || ((tmp$_0 = $receiver.bytes_8be2vx$) != null ? tmp$_0.equals(SLASH) : null) || ((tmp$_1 = $receiver.bytes_8be2vx$) != null ? tmp$_1.equals(BACKSLASH) : null) || lastSegmentIsDotDot($receiver)) {
        return null;
      }var lastSlash = get_indexOfLastSlash($receiver);
      if (lastSlash === 2 && unboxChar($receiver.volumeLetter) != null) {
        if ($receiver.bytes_8be2vx$.size === 3)
          return null;
        return new Path_init($receiver.bytes_8be2vx$.substring_vux9f0$(void 0, 3));
      } else if (lastSlash === 1 && $receiver.bytes_8be2vx$.startsWith_9ovubf$(BACKSLASH))
        return null;
      else if (lastSlash === -1 && unboxChar($receiver.volumeLetter) != null) {
        if ($receiver.bytes_8be2vx$.size === 2)
          return null;
        return new Path_init($receiver.bytes_8be2vx$.substring_vux9f0$(void 0, 2));
      } else if (lastSlash === -1)
        return new Path_init(DOT);
      else if (lastSlash === 0)
        return new Path_init($receiver.bytes_8be2vx$.substring_vux9f0$(void 0, 1));
      else {
        return new Path_init($receiver.bytes_8be2vx$.substring_vux9f0$(void 0, lastSlash));
      }
    };
  }));
  function lastSegmentIsDotDot($receiver) {
    if ($receiver.bytes_8be2vx$.endsWith_9ovubf$(DOT_DOT)) {
      if ($receiver.bytes_8be2vx$.size === 2)
        return true;
      if ($receiver.bytes_8be2vx$.rangeEquals_kxw41n$($receiver.bytes_8be2vx$.size - 3 | 0, SLASH, 0, 1))
        return true;
      if ($receiver.bytes_8be2vx$.rangeEquals_kxw41n$($receiver.bytes_8be2vx$.size - 3 | 0, BACKSLASH, 0, 1))
        return true;
    }return false;
  }
  var commonIsRoot = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonIsRoot_wel18l$', function ($receiver) {
    return rootLength($receiver) === $receiver.bytes_8be2vx$.size;
  });
  var commonResolve = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonResolve_pbki4k$', wrapFunction(function () {
    var Buffer_init = _.okio.Buffer;
    var toPath = _.okio.internal.toPath_2g9twb$;
    var commonResolve = _.okio.internal.commonResolve_j0uknj$;
    return function ($receiver, child, normalize) {
      return commonResolve($receiver, toPath((new Buffer_init()).writeUtf8_61zpoe$(child), false), normalize);
    };
  }));
  var commonResolve_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonResolve_juuqqr$', wrapFunction(function () {
    var Buffer_init = _.okio.Buffer;
    var toPath = _.okio.internal.toPath_2g9twb$;
    var commonResolve = _.okio.internal.commonResolve_j0uknj$;
    return function ($receiver, child, normalize) {
      return commonResolve($receiver, toPath((new Buffer_init()).write_9ovubf$(child), false), normalize);
    };
  }));
  var commonResolve_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonResolve_vx86u$', wrapFunction(function () {
    var toPath = _.okio.internal.toPath_2g9twb$;
    var commonResolve = _.okio.internal.commonResolve_j0uknj$;
    return function ($receiver, child, normalize) {
      return commonResolve($receiver, toPath(child, false), normalize);
    };
  }));
  function commonResolve_2($receiver, child, normalize) {
    var tmp$, tmp$_0;
    if (child.isAbsolute || unboxChar(child.volumeLetter) != null)
      return child;
    var slash = (tmp$_0 = (tmp$ = get_slash($receiver)) != null ? tmp$ : get_slash(child)) != null ? tmp$_0 : toSlash(Path$Companion_getInstance().DIRECTORY_SEPARATOR);
    var buffer = new Buffer();
    buffer.write_9ovubf$($receiver.bytes_8be2vx$);
    if (buffer.size.toNumber() > 0) {
      buffer.write_9ovubf$(slash);
    }buffer.write_9ovubf$(child.bytes_8be2vx$);
    return toPath(buffer, normalize);
  }
  var commonRelativeTo = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRelativeTo_uzi73e$', wrapFunction(function () {
    var equals = Kotlin.equals;
    var Path = _.okio.Path;
    var Buffer_init = _.okio.Buffer;
    var toPath = _.okio.internal.toPath_2g9twb$;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    var JsMath = Math;
    return function ($receiver, other) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
      if (!equals($receiver.root, other.root)) {
        var message = 'Paths of different roots cannot be relative to each other: ' + $receiver + ' and ' + other;
        throw IllegalArgumentException_init(message.toString());
      }var thisSegments = $receiver.segmentsBytes;
      var otherSegments = other.segmentsBytes;
      var firstNewSegmentIndex = 0;
      var a = thisSegments.size;
      var b = otherSegments.size;
      var minSegmentsSize = JsMath.min(a, b);
      while (firstNewSegmentIndex < minSegmentsSize && ((tmp$ = thisSegments.get_za3lpa$(firstNewSegmentIndex)) != null ? tmp$.equals(otherSegments.get_za3lpa$(firstNewSegmentIndex)) : null)) {
        firstNewSegmentIndex = firstNewSegmentIndex + 1 | 0;
      }
      if (firstNewSegmentIndex === minSegmentsSize && $receiver.bytes_8be2vx$.size === other.bytes_8be2vx$.size) {
        return Path.Companion.toPath_f4dhtg$('.');
      }if (!(otherSegments.subList_vux9f0$(firstNewSegmentIndex, otherSegments.size).indexOf_11rb$(DOT_DOT) === -1)) {
        var message_0 = 'Impossible relative path to resolve: ' + $receiver + ' and ' + other;
        throw IllegalArgumentException_init(message_0.toString());
      }var buffer = new Buffer_init();
      var slash = (tmp$_1 = (tmp$_0 = get_slash(other)) != null ? tmp$_0 : get_slash($receiver)) != null ? tmp$_1 : toSlash(Path.Companion.DIRECTORY_SEPARATOR);
      tmp$_2 = otherSegments.size;
      for (var i = firstNewSegmentIndex; i < tmp$_2; i++) {
        buffer.write_9ovubf$(DOT_DOT);
        buffer.write_9ovubf$(slash);
      }
      tmp$_3 = thisSegments.size;
      for (var i_0 = firstNewSegmentIndex; i_0 < tmp$_3; i_0++) {
        buffer.write_9ovubf$(thisSegments.get_za3lpa$(i_0));
        buffer.write_9ovubf$(slash);
      }
      return toPath(buffer, false);
    };
  }));
  var commonNormalized = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonNormalized_wel18l$', wrapFunction(function () {
    var Path = _.okio.Path;
    return function ($receiver) {
      return Path.Companion.toPath_f4dhtg$($receiver.toString(), true);
    };
  }));
  function get_slash($receiver) {
    var tmp$;
    if ($receiver.bytes_8be2vx$.indexOf_598ac7$(SLASH) !== -1)
      tmp$ = SLASH;
    else if ($receiver.bytes_8be2vx$.indexOf_598ac7$(BACKSLASH) !== -1)
      tmp$ = BACKSLASH;
    else
      tmp$ = null;
    return tmp$;
  }
  var commonCompareTo_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonCompareTo_uzi73e$', function ($receiver, other) {
    return $receiver.bytes_8be2vx$.compareTo_11rb$(other.bytes_8be2vx$);
  });
  var commonEquals_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonEquals_e4b6or$', wrapFunction(function () {
    var Path = _.okio.Path;
    return function ($receiver, other) {
      var tmp$;
      return Kotlin.isType(other, Path) && ((tmp$ = other.bytes_8be2vx$) != null ? tmp$.equals($receiver.bytes_8be2vx$) : null);
    };
  }));
  var commonHashCode_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonHashCode_wel18l$', function ($receiver) {
    return $receiver.bytes_8be2vx$.hashCode();
  });
  var commonToString_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonToString_wel18l$', function ($receiver) {
    return $receiver.bytes_8be2vx$.utf8();
  });
  function commonToPath($receiver, normalize) {
    return toPath((new Buffer()).writeUtf8_61zpoe$($receiver), normalize);
  }
  function toPath($receiver, normalize) {
    var tmp$, tmp$_0, tmp$_1;
    var slash = null;
    var result = new Buffer();
    var leadingSlashCount = 0;
    while ($receiver.rangeEquals_2rh7jy$(L0, SLASH) || $receiver.rangeEquals_2rh7jy$(L0, BACKSLASH)) {
      var byte = $receiver.readByte();
      slash = slash != null ? slash : toSlash_0(byte);
      leadingSlashCount = leadingSlashCount + 1 | 0;
    }
    var windowsUncPath = leadingSlashCount >= 2 && equals(slash, BACKSLASH);
    if (windowsUncPath) {
      result.write_9ovubf$(ensureNotNull(slash));
      result.write_9ovubf$(slash);
    } else if (leadingSlashCount > 0) {
      result.write_9ovubf$(ensureNotNull(slash));
    } else {
      var limit = $receiver.indexOfElement_9ovubf$(ANY_SLASH);
      if (slash == null) {
        if (equals(limit, L_1))
          tmp$ = toSlash(Path$Companion_getInstance().DIRECTORY_SEPARATOR);
        else
          tmp$ = toSlash_0($receiver.get_s8cxhz$(limit));
        slash = tmp$;
      }slash = slash;
      if (startsWithVolumeLetterAndColon($receiver, slash)) {
        if (equals(limit, L2)) {
          result.write_u27jpl$($receiver, L3);
        } else {
          result.write_u27jpl$($receiver, L2);
        }
      }}
    var absolute = result.size.toNumber() > 0;
    var canonicalParts = ArrayList_init();
    while (!$receiver.exhausted()) {
      var limit_0 = $receiver.indexOfElement_9ovubf$(ANY_SLASH);
      var part;
      if (equals(limit_0, L_1)) {
        part = $receiver.readByteString();
      } else {
        part = $receiver.readByteString_s8cxhz$(limit_0);
        $receiver.readByte();
      }
      if (part != null ? part.equals(DOT_DOT) : null) {
        if (!absolute || !canonicalParts.isEmpty())
          if (!normalize || (!absolute && (canonicalParts.isEmpty() || ((tmp$_0 = last(canonicalParts)) != null ? tmp$_0.equals(DOT_DOT) : null)))) {
            canonicalParts.add_11rb$(part);
          } else if (!windowsUncPath || canonicalParts.size !== 1) {
            removeLastOrNull(canonicalParts);
          }} else if (!(part != null ? part.equals(DOT) : null) && !(part != null ? part.equals(ByteString$Companion_getInstance().EMPTY) : null)) {
        canonicalParts.add_11rb$(part);
      }}
    tmp$_1 = canonicalParts.size;
    for (var i = 0; i < tmp$_1; i++) {
      if (i > 0)
        result.write_9ovubf$(slash);
      result.write_9ovubf$(canonicalParts.get_za3lpa$(i));
    }
    if (equals(result.size, L0)) {
      result.write_9ovubf$(DOT);
    }return new Path(result.readByteString());
  }
  function toSlash($receiver) {
    var tmp$;
    switch ($receiver) {
      case '/':
        tmp$ = SLASH;
        break;
      case '\\':
        tmp$ = BACKSLASH;
        break;
      default:throw IllegalArgumentException_init('not a directory separator: ' + $receiver);
    }
    return tmp$;
  }
  function toSlash_0($receiver) {
    var tmp$;
    switch ($receiver) {
      case 47:
        tmp$ = SLASH;
        break;
      case 92:
        tmp$ = BACKSLASH;
        break;
      default:throw IllegalArgumentException_init('not a directory separator: ' + $receiver);
    }
    return tmp$;
  }
  function startsWithVolumeLetterAndColon($receiver, slash) {
    if (!(slash != null ? slash.equals(BACKSLASH) : null))
      return false;
    if ($receiver.size.toNumber() < 2)
      return false;
    if ($receiver.get_s8cxhz$(L1) !== toByte(58))
      return false;
    var b = toChar($receiver.get_s8cxhz$(L0));
    return (new CharRange(97, 122)).contains_mef7kx$(b) || (new CharRange(65, 90)).contains_mef7kx$(b);
  }
  var commonWrite_5 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_oe5psp$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, source, byteCount) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.write_u27jpl$(source, byteCount);
      $receiver.emitCompleteSegments();
    };
  }));
  var commonWrite_6 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_8i7jl7$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, byteString) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.write_9ovubf$(byteString);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWrite_7 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_uf7j3f$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, byteString, offset, byteCount) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.write_e1lsqj$(byteString, offset, byteCount);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteUtf8_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteUtf8_thum0i$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, string) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeUtf8_61zpoe$(string);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteUtf8_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteUtf8_5sel9u$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, string, beginIndex, endIndex) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeUtf8_3m52m6$(string, beginIndex, endIndex);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteUtf8CodePoint_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteUtf8CodePoint_ahms5u$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, codePoint) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeUtf8CodePoint_za3lpa$(codePoint);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWrite_8 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_ijfca4$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, source) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.write_fqrh44$(source);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWrite_9 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_x14430$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, source, offset, byteCount) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.write_mj6st8$(source, offset, byteCount);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteAll_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteAll_u2hfd5$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var L8192 = Kotlin.Long.fromInt(8192);
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    return function ($receiver, source) {
      var totalBytesRead = L0;
      while (true) {
        var readCount = source.read_u27jpl$($receiver.buffer, L8192);
        if (equals(readCount, L_1))
          break;
        totalBytesRead = totalBytesRead.add(readCount);
        $receiver.emitCompleteSegments();
      }
      return totalBytesRead;
    };
  }));
  var commonWrite_10 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_46hzck$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    var EOFException_init = _.okio.EOFException;
    return function ($receiver, source, byteCount) {
      var byteCount_0 = byteCount;
      while (byteCount_0.compareTo_11rb$(L0) > 0) {
        var read = source.read_u27jpl$($receiver.buffer, byteCount_0);
        if (equals(read, L_1))
          throw new EOFException_init();
        byteCount_0 = byteCount_0.subtract(read);
        $receiver.emitCompleteSegments();
      }
      return $receiver;
    };
  }));
  var commonWriteByte_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteByte_ahms5u$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, b) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeByte_za3lpa$(b);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteShort_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteShort_ahms5u$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, s) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeShort_za3lpa$(s);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteShortLe = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteShortLe_ahms5u$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, s) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeShortLe_za3lpa$(s);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteInt_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteInt_ahms5u$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, i) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeInt_za3lpa$(i);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteIntLe = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteIntLe_ahms5u$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, i) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeIntLe_za3lpa$(i);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteLong_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteLong_tyw37r$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, v) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeLong_s8cxhz$(v);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteLongLe = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteLongLe_tyw37r$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, v) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeLongLe_s8cxhz$(v);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteDecimalLong_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteDecimalLong_tyw37r$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, v) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeDecimalLong_s8cxhz$(v);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonWriteHexadecimalUnsignedLong_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWriteHexadecimalUnsignedLong_tyw37r$', wrapFunction(function () {
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, v) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }$receiver.buffer.writeHexadecimalUnsignedLong_s8cxhz$(v);
      return $receiver.emitCompleteSegments();
    };
  }));
  var commonEmitCompleteSegments = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonEmitCompleteSegments_ps9l80$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }var byteCount = $receiver.buffer.completeSegmentByteCount();
      if (byteCount.compareTo_11rb$(L0) > 0)
        $receiver.sink.write_u27jpl$($receiver.buffer, byteCount);
      return $receiver;
    };
  }));
  var commonEmit = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonEmit_ps9l80$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }var byteCount = $receiver.buffer.size;
      if (byteCount.compareTo_11rb$(L0) > 0)
        $receiver.sink.write_u27jpl$($receiver.buffer, byteCount);
      return $receiver;
    };
  }));
  var commonFlush = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonFlush_ps9l80$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }if ($receiver.buffer.size.compareTo_11rb$(L0) > 0) {
        $receiver.sink.write_u27jpl$($receiver.buffer, $receiver.buffer.size);
      }$receiver.sink.flush();
    };
  }));
  var commonClose_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonClose_ps9l80$', wrapFunction(function () {
    var Throwable = Error;
    return function ($receiver) {
      if ($receiver.closed)
        return;
      var thrown = null;
      try {
        if ($receiver.buffer.size.toNumber() > 0) {
          $receiver.sink.write_u27jpl$($receiver.buffer, $receiver.buffer.size);
        }} catch (e) {
        if (Kotlin.isType(e, Throwable)) {
          thrown = e;
        } else
          throw e;
      }
      try {
        $receiver.sink.close();
      } catch (e) {
        if (Kotlin.isType(e, Throwable)) {
          if (thrown == null)
            thrown = e;
        } else
          throw e;
      }
      $receiver.closed = true;
      if (thrown != null)
        throw thrown;
    };
  }));
  var commonTimeout = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonTimeout_ps9l80$', function ($receiver) {
    return $receiver.sink.timeout();
  });
  var commonToString_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonToString_ps9l80$', function ($receiver) {
    return 'buffer(' + $receiver.sink + ')';
  });
  var commonRead_2 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRead_omy7q7$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var L8192 = Kotlin.Long.fromInt(8192);
    var L_1 = Kotlin.Long.NEG_ONE;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, sink, byteCount) {
      if (!(byteCount.compareTo_11rb$(L0) >= 0)) {
        var message = 'byteCount < 0: ' + byteCount.toString();
        throw IllegalArgumentException_init(message.toString());
      }if (!!$receiver.closed) {
        var message_0 = 'closed';
        throw IllegalStateException_init(message_0.toString());
      }if (equals($receiver.buffer.size, L0)) {
        var read = $receiver.source.read_u27jpl$($receiver.buffer, L8192);
        if (equals(read, L_1))
          return L_1;
      }var b = $receiver.buffer.size;
      var toRead = byteCount.compareTo_11rb$(b) <= 0 ? byteCount : b;
      return $receiver.buffer.read_u27jpl$(sink, toRead);
    };
  }));
  var commonExhausted = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonExhausted_7a1qe0$', wrapFunction(function () {
    var L8192 = Kotlin.Long.fromInt(8192);
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }return $receiver.buffer.exhausted() && equals($receiver.source.read_u27jpl$($receiver.buffer, L8192), L_1);
    };
  }));
  var commonRequire = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRequire_ogm69$', wrapFunction(function () {
    var EOFException_init = _.okio.EOFException;
    return function ($receiver, byteCount) {
      if (!$receiver.request_s8cxhz$(byteCount))
        throw new EOFException_init();
    };
  }));
  var commonRequest = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRequest_ogm69$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var L8192 = Kotlin.Long.fromInt(8192);
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, byteCount) {
      if (!(byteCount.compareTo_11rb$(L0) >= 0)) {
        var message = 'byteCount < 0: ' + byteCount.toString();
        throw IllegalArgumentException_init(message.toString());
      }if (!!$receiver.closed) {
        var message_0 = 'closed';
        throw IllegalStateException_init(message_0.toString());
      }while ($receiver.buffer.size.compareTo_11rb$(byteCount) < 0) {
        if (equals($receiver.source.read_u27jpl$($receiver.buffer, L8192), L_1))
          return false;
      }
      return true;
    };
  }));
  var commonReadByte_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadByte_7a1qe0$', wrapFunction(function () {
    var L1 = Kotlin.Long.ONE;
    return function ($receiver) {
      $receiver.require_s8cxhz$(L1);
      return $receiver.buffer.readByte();
    };
  }));
  var commonReadByteString_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadByteString_7a1qe0$', function ($receiver) {
    $receiver.buffer.writeAll_sby9nd$($receiver.source);
    return $receiver.buffer.readByteString();
  });
  var commonReadByteString_2 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadByteString_ogm69$', function ($receiver, byteCount) {
    $receiver.require_s8cxhz$(byteCount);
    return $receiver.buffer.readByteString_s8cxhz$(byteCount);
  });
  var commonSelect_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonSelect_uqsvy2$', wrapFunction(function () {
    var selectPrefix = _.okio.internal.selectPrefix_x1lq7p$;
    var L8192 = Kotlin.Long.fromInt(8192);
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, options) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }while (true) {
        var index = selectPrefix($receiver.buffer, options, true);
        switch (index) {
          case -1:
            return -1;
          case -2:
            if (equals($receiver.source.read_u27jpl$($receiver.buffer, L8192), L_1))
              return -1;
            break;
          default:var selectedSize = options.byteStrings_8be2vx$[index].size;
            $receiver.buffer.skip_s8cxhz$(Kotlin.Long.fromInt(selectedSize));
            return index;
        }
      }
    };
  }));
  var commonReadByteArray_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadByteArray_7a1qe0$', function ($receiver) {
    $receiver.buffer.writeAll_sby9nd$($receiver.source);
    return $receiver.buffer.readByteArray();
  });
  var commonReadByteArray_2 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadByteArray_ogm69$', function ($receiver, byteCount) {
    $receiver.require_s8cxhz$(byteCount);
    return $receiver.buffer.readByteArray_s8cxhz$(byteCount);
  });
  var commonReadFully_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadFully_pw2w7g$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var AssertionError_init = Kotlin.kotlin.AssertionError_init;
    var EOFException = _.okio.EOFException;
    return function ($receiver, sink) {
      try {
        $receiver.require_s8cxhz$(Kotlin.Long.fromInt(sink.length));
      } catch (e) {
        if (Kotlin.isType(e, EOFException)) {
          var offset = 0;
          while ($receiver.buffer.size.compareTo_11rb$(L0) > 0) {
            var read = $receiver.buffer.read_mj6st8$(sink, offset, $receiver.buffer.size.toInt());
            if (read === -1)
              throw AssertionError_init();
            offset = offset + read | 0;
          }
          throw e;
        } else
          throw e;
      }
      $receiver.buffer.readFully_fqrh44$(sink);
    };
  }));
  var commonRead_3 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRead_xcweno$', wrapFunction(function () {
    var checkOffsetAndCount = _.okio.checkOffsetAndCount_e84ct6$;
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var L8192 = Kotlin.Long.fromInt(8192);
    var L_1 = Kotlin.Long.NEG_ONE;
    return function ($receiver, sink, offset, byteCount) {
      checkOffsetAndCount(Kotlin.Long.fromInt(sink.length), Kotlin.Long.fromInt(offset), Kotlin.Long.fromInt(byteCount));
      if (equals($receiver.buffer.size, L0)) {
        var read = $receiver.source.read_u27jpl$($receiver.buffer, L8192);
        if (equals(read, L_1))
          return -1;
      }var b = $receiver.buffer.size;
      var a = Kotlin.Long.fromInt(byteCount);
      var toRead = (a.compareTo_11rb$(b) <= 0 ? a : b).toInt();
      return $receiver.buffer.read_mj6st8$(sink, offset, toRead);
    };
  }));
  var commonReadFully_2 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadFully_omy7q7$', wrapFunction(function () {
    var EOFException = _.okio.EOFException;
    return function ($receiver, sink, byteCount) {
      try {
        $receiver.require_s8cxhz$(byteCount);
      } catch (e) {
        if (Kotlin.isType(e, EOFException)) {
          sink.writeAll_sby9nd$($receiver.buffer);
          throw e;
        } else
          throw e;
      }
      $receiver.buffer.readFully_u27jpl$(sink, byteCount);
    };
  }));
  var commonReadAll_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadAll_6a6yuv$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var L8192 = Kotlin.Long.fromInt(8192);
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    return function ($receiver, sink) {
      var totalBytesWritten = L0;
      while (!equals($receiver.source.read_u27jpl$($receiver.buffer, L8192), L_1)) {
        var emitByteCount = $receiver.buffer.completeSegmentByteCount();
        if (emitByteCount.compareTo_11rb$(L0) > 0) {
          totalBytesWritten = totalBytesWritten.add(emitByteCount);
          sink.write_u27jpl$($receiver.buffer, emitByteCount);
        }}
      if ($receiver.buffer.size.compareTo_11rb$(L0) > 0) {
        totalBytesWritten = totalBytesWritten.add($receiver.buffer.size);
        sink.write_u27jpl$($receiver.buffer, $receiver.buffer.size);
      }return totalBytesWritten;
    };
  }));
  var commonReadUtf8_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadUtf8_7a1qe0$', function ($receiver) {
    $receiver.buffer.writeAll_sby9nd$($receiver.source);
    return $receiver.buffer.readUtf8();
  });
  var commonReadUtf8_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadUtf8_ogm69$', function ($receiver, byteCount) {
    $receiver.require_s8cxhz$(byteCount);
    return $receiver.buffer.readUtf8_s8cxhz$(byteCount);
  });
  var commonReadUtf8Line_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadUtf8Line_7a1qe0$', wrapFunction(function () {
    var toByte = Kotlin.toByte;
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    var L0 = Kotlin.Long.ZERO;
    var readUtf8Line = _.okio.internal.readUtf8Line_rqsa21$;
    return function ($receiver) {
      var tmp$;
      var newline = $receiver.indexOf_s8j3t7$(toByte(10));
      if (equals(newline, L_1)) {
        if (!equals($receiver.buffer.size, L0)) {
          tmp$ = $receiver.readUtf8_s8cxhz$($receiver.buffer.size);
        } else {
          tmp$ = null;
        }
      } else {
        tmp$ = readUtf8Line($receiver.buffer, newline);
      }
      return tmp$;
    };
  }));
  var commonReadUtf8LineStrict_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadUtf8LineStrict_ogm69$', wrapFunction(function () {
    var Long$Companion$MAX_VALUE = Kotlin.Long.MAX_VALUE;
    var equals = Kotlin.equals;
    var toByte = Kotlin.toByte;
    var L0 = Kotlin.Long.ZERO;
    var L_1 = Kotlin.Long.NEG_ONE;
    var readUtf8Line = _.okio.internal.readUtf8Line_rqsa21$;
    var Buffer_init = _.okio.Buffer;
    var toString = Kotlin.toString;
    var EOFException_init = _.okio.EOFException;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function ($receiver, limit) {
      if (!(limit.toNumber() >= 0)) {
        var message = 'limit < 0: ' + limit.toString();
        throw IllegalArgumentException_init(message.toString());
      }var scanLength = equals(limit, Long$Companion$MAX_VALUE) ? Long$Companion$MAX_VALUE : limit.add(Kotlin.Long.fromInt(1));
      var newline = $receiver.indexOf_mfonpt$(toByte(10), L0, scanLength);
      if (!equals(newline, L_1))
        return readUtf8Line($receiver.buffer, newline);
      if (scanLength.compareTo_11rb$(Long$Companion$MAX_VALUE) < 0 && $receiver.request_s8cxhz$(scanLength) && $receiver.buffer.get_s8cxhz$(scanLength.subtract(Kotlin.Long.fromInt(1))) === toByte(13) && $receiver.request_s8cxhz$(scanLength.add(Kotlin.Long.fromInt(1))) && $receiver.buffer.get_s8cxhz$(scanLength) === toByte(10)) {
        return readUtf8Line($receiver.buffer, scanLength);
      }var data = new Buffer_init();
      var tmp$ = $receiver.buffer;
      var tmp$_0 = L0;
      var b = $receiver.buffer.size;
      var a = Kotlin.Long.fromInt(32);
      tmp$.copyTo_ins7gm$(data, tmp$_0, a.compareTo_11rb$(b) <= 0 ? a : b);
      var a_0 = $receiver.buffer.size;
      throw new EOFException_init('\\n not found: limit=' + toString(a_0.compareTo_11rb$(limit) <= 0 ? a_0 : limit) + ' content=' + data.readByteString().hex() + String.fromCharCode(8230));
    };
  }));
  var commonReadUtf8CodePoint_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadUtf8CodePoint_7a1qe0$', wrapFunction(function () {
    var L1 = Kotlin.Long.ONE;
    var L0 = Kotlin.Long.ZERO;
    var L2 = Kotlin.Long.fromInt(2);
    var L3 = Kotlin.Long.fromInt(3);
    var L4 = Kotlin.Long.fromInt(4);
    return function ($receiver) {
      $receiver.require_s8cxhz$(L1);
      var b0 = $receiver.buffer.get_s8cxhz$(L0);
      if ((b0 & 224) === 192)
        $receiver.require_s8cxhz$(L2);
      else if ((b0 & 240) === 224)
        $receiver.require_s8cxhz$(L3);
      else if ((b0 & 248) === 240)
        $receiver.require_s8cxhz$(L4);
      return $receiver.buffer.readUtf8CodePoint();
    };
  }));
  var commonReadShort_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadShort_7a1qe0$', wrapFunction(function () {
    var L2 = Kotlin.Long.fromInt(2);
    return function ($receiver) {
      $receiver.require_s8cxhz$(L2);
      return $receiver.buffer.readShort();
    };
  }));
  var commonReadShortLe = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadShortLe_7a1qe0$', wrapFunction(function () {
    var L2 = Kotlin.Long.fromInt(2);
    return function ($receiver) {
      $receiver.require_s8cxhz$(L2);
      return $receiver.buffer.readShortLe();
    };
  }));
  var commonReadInt_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadInt_7a1qe0$', wrapFunction(function () {
    var L4 = Kotlin.Long.fromInt(4);
    return function ($receiver) {
      $receiver.require_s8cxhz$(L4);
      return $receiver.buffer.readInt();
    };
  }));
  var commonReadIntLe = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadIntLe_7a1qe0$', wrapFunction(function () {
    var L4 = Kotlin.Long.fromInt(4);
    return function ($receiver) {
      $receiver.require_s8cxhz$(L4);
      return $receiver.buffer.readIntLe();
    };
  }));
  var commonReadLong_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadLong_7a1qe0$', wrapFunction(function () {
    var L8 = Kotlin.Long.fromInt(8);
    return function ($receiver) {
      $receiver.require_s8cxhz$(L8);
      return $receiver.buffer.readLong();
    };
  }));
  var commonReadLongLe = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadLongLe_7a1qe0$', wrapFunction(function () {
    var L8 = Kotlin.Long.fromInt(8);
    return function ($receiver) {
      $receiver.require_s8cxhz$(L8);
      return $receiver.buffer.readLongLe();
    };
  }));
  var commonReadDecimalLong_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadDecimalLong_7a1qe0$', wrapFunction(function () {
    var L1 = Kotlin.Long.ONE;
    var L0 = Kotlin.Long.ZERO;
    var toByte = Kotlin.toByte;
    var equals = Kotlin.equals;
    var NumberFormatException_init = Kotlin.kotlin.NumberFormatException;
    var toString = Kotlin.kotlin.text.toString_dqglrj$;
    return function ($receiver) {
      $receiver.require_s8cxhz$(L1);
      var pos = L0;
      while ($receiver.request_s8cxhz$(pos.add(Kotlin.Long.fromInt(1)))) {
        var b = $receiver.buffer.get_s8cxhz$(pos);
        if ((b < toByte(48) || b > toByte(57)) && (!equals(pos, L0) || b !== toByte(45))) {
          if (equals(pos, L0)) {
            throw new NumberFormatException_init("Expected a digit or '-' but was 0x" + toString(b, 16));
          }break;
        }pos = pos.inc();
      }
      return $receiver.buffer.readDecimalLong();
    };
  }));
  var commonReadHexadecimalUnsignedLong_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonReadHexadecimalUnsignedLong_7a1qe0$', wrapFunction(function () {
    var L1 = Kotlin.Long.ONE;
    var toByte = Kotlin.toByte;
    var NumberFormatException_init = Kotlin.kotlin.NumberFormatException;
    var toString = Kotlin.kotlin.text.toString_dqglrj$;
    return function ($receiver) {
      $receiver.require_s8cxhz$(L1);
      var pos = 0;
      while ($receiver.request_s8cxhz$(Kotlin.Long.fromInt(pos + 1 | 0))) {
        var b = $receiver.buffer.get_s8cxhz$(Kotlin.Long.fromInt(pos));
        if ((b < toByte(48) || b > toByte(57)) && (b < toByte(97) || b > toByte(102)) && (b < toByte(65) || b > toByte(70))) {
          if (pos === 0) {
            throw new NumberFormatException_init('Expected leading [0-9a-fA-F] character but was 0x' + toString(b, 16));
          }break;
        }pos = pos + 1 | 0;
      }
      return $receiver.buffer.readHexadecimalUnsignedLong();
    };
  }));
  var commonSkip_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonSkip_ogm69$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var equals = Kotlin.equals;
    var L8192 = Kotlin.Long.fromInt(8192);
    var L_1 = Kotlin.Long.NEG_ONE;
    var EOFException_init = _.okio.EOFException;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, byteCount) {
      var byteCount_0 = byteCount;
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }while (byteCount_0.toNumber() > 0) {
        if (equals($receiver.buffer.size, L0) && equals($receiver.source.read_u27jpl$($receiver.buffer, L8192), L_1)) {
          throw new EOFException_init();
        }var a = byteCount_0;
        var b = $receiver.buffer.size;
        var toSkip = a.compareTo_11rb$(b) <= 0 ? a : b;
        $receiver.buffer.skip_s8cxhz$(toSkip);
        byteCount_0 = byteCount_0.subtract(toSkip);
      }
    };
  }));
  var commonIndexOf_2 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonIndexOf_z1p6tj$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    var L8192 = Kotlin.Long.fromInt(8192);
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    function commonIndexOf$lambda(closure$fromIndex, closure$toIndex) {
      return function () {
        return 'fromIndex=' + closure$fromIndex.v.toString() + ' toIndex=' + closure$toIndex.toString();
      };
    }
    return function ($receiver, b, fromIndex, toIndex) {
      var tmp$;
      var fromIndex_0 = {v: fromIndex};
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }tmp$ = fromIndex_0.v;
      if (!(L0.lessThanOrEqual(tmp$) && tmp$.lessThanOrEqual(toIndex))) {
        var message_0 = commonIndexOf$lambda(fromIndex_0, toIndex)();
        throw IllegalArgumentException_init(message_0.toString());
      }while (fromIndex_0.v.compareTo_11rb$(toIndex) < 0) {
        var result = $receiver.buffer.indexOf_mfonpt$(b, fromIndex_0.v, toIndex);
        if (!equals(result, L_1))
          return result;
        var lastBufferSize = $receiver.buffer.size;
        if (lastBufferSize.compareTo_11rb$(toIndex) >= 0 || equals($receiver.source.read_u27jpl$($receiver.buffer, L8192), L_1))
          return L_1;
        var a = fromIndex_0.v;
        fromIndex_0.v = a.compareTo_11rb$(lastBufferSize) >= 0 ? a : lastBufferSize;
      }
      return L_1;
    };
  }));
  var commonIndexOf_3 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonIndexOf_n1qd3u$', wrapFunction(function () {
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    var L8192 = Kotlin.Long.fromInt(8192);
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, bytes, fromIndex) {
      var fromIndex_0 = fromIndex;
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }while (true) {
        var result = $receiver.buffer.indexOf_kvuuwu$(bytes, fromIndex_0);
        if (!equals(result, L_1))
          return result;
        var lastBufferSize = $receiver.buffer.size;
        if (equals($receiver.source.read_u27jpl$($receiver.buffer, L8192), L_1))
          return L_1;
        var a = fromIndex_0;
        var b = lastBufferSize.subtract(Kotlin.Long.fromInt(bytes.size)).add(Kotlin.Long.fromInt(1));
        fromIndex_0 = a.compareTo_11rb$(b) >= 0 ? a : b;
      }
    };
  }));
  var commonIndexOfElement_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonIndexOfElement_n1qd3u$', wrapFunction(function () {
    var L_1 = Kotlin.Long.NEG_ONE;
    var equals = Kotlin.equals;
    var L8192 = Kotlin.Long.fromInt(8192);
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, targetBytes, fromIndex) {
      var fromIndex_0 = fromIndex;
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }while (true) {
        var result = $receiver.buffer.indexOfElement_kvuuwu$(targetBytes, fromIndex_0);
        if (!equals(result, L_1))
          return result;
        var lastBufferSize = $receiver.buffer.size;
        if (equals($receiver.source.read_u27jpl$($receiver.buffer, L8192), L_1))
          return L_1;
        var a = fromIndex_0;
        fromIndex_0 = a.compareTo_11rb$(lastBufferSize) >= 0 ? a : lastBufferSize;
      }
    };
  }));
  var commonRangeEquals_2 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRangeEquals_4ww1sq$', wrapFunction(function () {
    var L0 = Kotlin.Long.ZERO;
    var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
    return function ($receiver, offset, bytes, bytesOffset, byteCount) {
      if (!!$receiver.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }if (offset.compareTo_11rb$(L0) < 0 || bytesOffset < 0 || byteCount < 0 || (bytes.size - bytesOffset | 0) < byteCount) {
        return false;
      }for (var i = 0; i < byteCount; i++) {
        var bufferOffset = offset.add(Kotlin.Long.fromInt(i));
        if (!$receiver.request_s8cxhz$(bufferOffset.add(Kotlin.Long.fromInt(1))))
          return false;
        if ($receiver.buffer.get_s8cxhz$(bufferOffset) !== bytes.get_za3lpa$(bytesOffset + i | 0))
          return false;
      }
      return true;
    };
  }));
  var commonPeek = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonPeek_7a1qe0$', wrapFunction(function () {
    var PeekSource_init = _.okio.PeekSource;
    var buffer = _.okio.buffer_px5ndk$;
    return function ($receiver) {
      return buffer(new PeekSource_init($receiver));
    };
  }));
  var commonClose_1 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonClose_7a1qe0$', function ($receiver) {
    if ($receiver.closed)
      return;
    $receiver.closed = true;
    $receiver.source.close();
    $receiver.buffer.clear();
  });
  var commonTimeout_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonTimeout_7a1qe0$', function ($receiver) {
    return $receiver.source.timeout();
  });
  var commonToString_2 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonToString_7a1qe0$', function ($receiver) {
    return 'buffer(' + $receiver.source + ')';
  });
  function binarySearch_0($receiver, value, fromIndex, toIndex) {
    var left = fromIndex;
    var right = toIndex - 1 | 0;
    while (left <= right) {
      var mid = left + right >>> 1;
      var midVal = $receiver[mid];
      if (midVal < value)
        left = mid + 1 | 0;
      else if (midVal > value)
        right = mid - 1 | 0;
      else
        return mid;
    }
    return (-left | 0) - 1 | 0;
  }
  function segment($receiver, pos) {
    var i = binarySearch_0($receiver.directory_8be2vx$, pos + 1 | 0, 0, $receiver.segments_8be2vx$.length);
    return i >= 0 ? i : ~i;
  }
  var forEachSegment = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.forEachSegment_enn6vc$', function ($receiver, action) {
    var segmentCount = $receiver.segments_8be2vx$.length;
    var s = 0;
    var pos = 0;
    while (s < segmentCount) {
      var segmentPos = $receiver.directory_8be2vx$[segmentCount + s | 0];
      var nextSegmentOffset = $receiver.directory_8be2vx$[s];
      action($receiver.segments_8be2vx$[s], segmentPos, nextSegmentOffset - pos | 0);
      pos = nextSegmentOffset;
      s = s + 1 | 0;
    }
  });
  var forEachSegment_0 = wrapFunction(function () {
    var JsMath = Math;
    return function ($receiver, beginIndex, endIndex, action) {
      var s = segment($receiver, beginIndex);
      var pos = beginIndex;
      while (pos < endIndex) {
        var segmentOffset = s === 0 ? 0 : $receiver.directory_8be2vx$[s - 1 | 0];
        var segmentSize = $receiver.directory_8be2vx$[s] - segmentOffset | 0;
        var segmentPos = $receiver.directory_8be2vx$[$receiver.segments_8be2vx$.length + s | 0];
        var b = segmentOffset + segmentSize | 0;
        var byteCount = JsMath.min(endIndex, b) - pos | 0;
        var offset = segmentPos + (pos - segmentOffset) | 0;
        action($receiver.segments_8be2vx$[s], offset, byteCount);
        pos = pos + byteCount | 0;
        s = s + 1 | 0;
      }
    };
  });
  var commonSubstring_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonSubstring_weypk7$', wrapFunction(function () {
    var resolveDefaultParameter = _.okio.resolveDefaultParameter_kvlz5j$;
    var ByteString = _.okio.ByteString;
    var segment = _.okio.internal.segment_eyoskr$;
    var copyOfRange = Kotlin.kotlin.collections.copyOfRange_5f8l3u$;
    var SegmentedByteString_init = _.okio.SegmentedByteString;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    var JsMath = Math;
    return function ($receiver, beginIndex, endIndex) {
      var tmp$;
      var endIndex_0 = resolveDefaultParameter($receiver, endIndex);
      if (!(beginIndex >= 0)) {
        var message = 'beginIndex=' + beginIndex + ' < 0';
        throw IllegalArgumentException_init(message.toString());
      }if (!(endIndex_0 <= $receiver.size)) {
        var message_0 = 'endIndex=' + endIndex_0 + ' > length(' + $receiver.size + ')';
        throw IllegalArgumentException_init(message_0.toString());
      }var subLen = endIndex_0 - beginIndex | 0;
      if (!(subLen >= 0)) {
        var message_1 = 'endIndex=' + endIndex_0 + ' < beginIndex=' + beginIndex;
        throw IllegalArgumentException_init(message_1.toString());
      }if (beginIndex === 0 && endIndex_0 === $receiver.size)
        return $receiver;
      else if (beginIndex === endIndex_0)
        return ByteString.Companion.EMPTY;
      var beginSegment = segment($receiver, beginIndex);
      var endSegment = segment($receiver, endIndex_0 - 1 | 0);
      var newSegments = copyOfRange($receiver.segments_8be2vx$, beginSegment, endSegment + 1 | 0);
      var newDirectory = new Int32Array(newSegments.length * 2 | 0);
      var index = 0;
      for (var s = beginSegment; s <= endSegment; s++) {
        var a = $receiver.directory_8be2vx$[s] - beginIndex | 0;
        newDirectory[index] = JsMath.min(a, subLen);
        newDirectory[(tmp$ = index, index = tmp$ + 1 | 0, tmp$) + newSegments.length | 0] = $receiver.directory_8be2vx$[s + $receiver.segments_8be2vx$.length | 0];
      }
      var segmentOffset = beginSegment === 0 ? 0 : $receiver.directory_8be2vx$[beginSegment - 1 | 0];
      newDirectory[newSegments.length] = newDirectory[newSegments.length] + (beginIndex - segmentOffset) | 0;
      return new SegmentedByteString_init(newSegments, newDirectory);
    };
  }));
  var commonInternalGet = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonInternalGet_eyoskr$', wrapFunction(function () {
    var L1 = Kotlin.Long.ONE;
    var checkOffsetAndCount = _.okio.checkOffsetAndCount_e84ct6$;
    var segment = _.okio.internal.segment_eyoskr$;
    return function ($receiver, pos) {
      checkOffsetAndCount(Kotlin.Long.fromInt($receiver.directory_8be2vx$[$receiver.segments_8be2vx$.length - 1 | 0]), Kotlin.Long.fromInt(pos), L1);
      var segment_0 = segment($receiver, pos);
      var segmentOffset = segment_0 === 0 ? 0 : $receiver.directory_8be2vx$[segment_0 - 1 | 0];
      var segmentPos = $receiver.directory_8be2vx$[segment_0 + $receiver.segments_8be2vx$.length | 0];
      return $receiver.segments_8be2vx$[segment_0][pos - segmentOffset + segmentPos | 0];
    };
  }));
  var commonGetSize_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonGetSize_q6z9o3$', function ($receiver) {
    return $receiver.directory_8be2vx$[$receiver.segments_8be2vx$.length - 1 | 0];
  });
  var commonToByteArray_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonToByteArray_q6z9o3$', wrapFunction(function () {
    var Unit = Kotlin.kotlin.Unit;
    var wrapFunction = Kotlin.wrapFunction;
    var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
    var commonToByteArray$lambda = wrapFunction(function () {
      var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
      return function (closure$result, closure$resultPos) {
        return function (data, offset, byteCount) {
          arrayCopy(data, closure$result, closure$resultPos.v, offset, offset + byteCount | 0);
          closure$resultPos.v = closure$resultPos.v + byteCount | 0;
          return Unit;
        };
      };
    });
    return function ($receiver) {
      var result = new Int8Array($receiver.size);
      var resultPos = {v: 0};
      var segmentCount = $receiver.segments_8be2vx$.length;
      var s = 0;
      var pos = 0;
      while (s < segmentCount) {
        var segmentPos = $receiver.directory_8be2vx$[segmentCount + s | 0];
        var nextSegmentOffset = $receiver.directory_8be2vx$[s];
        var byteCount = nextSegmentOffset - pos | 0;
        arrayCopy($receiver.segments_8be2vx$[s], result, resultPos.v, segmentPos, segmentPos + byteCount | 0);
        resultPos.v = resultPos.v + byteCount | 0;
        pos = nextSegmentOffset;
        s = s + 1 | 0;
      }
      return result;
    };
  }));
  var commonWrite_11 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonWrite_xhbhaf$', wrapFunction(function () {
    var Segment_init = _.okio.Segment_init_iyithg$;
    var ensureNotNull = Kotlin.ensureNotNull;
    var JsMath = Math;
    return function ($receiver, buffer, offset, byteCount) {
      var endIndex = offset + byteCount | 0;
      var s = segment($receiver, offset);
      var pos = offset;
      while (pos < endIndex) {
        var segmentOffset = s === 0 ? 0 : $receiver.directory_8be2vx$[s - 1 | 0];
        var segmentSize = $receiver.directory_8be2vx$[s] - segmentOffset | 0;
        var segmentPos = $receiver.directory_8be2vx$[$receiver.segments_8be2vx$.length + s | 0];
        var b = segmentOffset + segmentSize | 0;
        var byteCount_0 = JsMath.min(endIndex, b) - pos | 0;
        var offset_0 = segmentPos + (pos - segmentOffset) | 0;
        var segment_0 = Segment_init($receiver.segments_8be2vx$[s], offset_0, offset_0 + byteCount_0 | 0, true, false);
        if (buffer.head_8be2vx$ == null) {
          segment_0.prev = segment_0;
          segment_0.next = segment_0.prev;
          buffer.head_8be2vx$ = segment_0.next;
        } else {
          ensureNotNull(ensureNotNull(buffer.head_8be2vx$).prev).push_uve4t5$(segment_0);
        }
        pos = pos + byteCount_0 | 0;
        s = s + 1 | 0;
      }
      buffer.size = buffer.size.add(Kotlin.Long.fromInt(byteCount));
    };
  }));
  var commonRangeEquals_3 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRangeEquals_4are8i$', wrapFunction(function () {
    var JsMath = Math;
    return function ($receiver, offset, other, otherOffset, byteCount) {
      if (offset < 0 || offset > ($receiver.size - byteCount | 0))
        return false;
      var otherOffset_0 = {v: otherOffset};
      var endIndex = offset + byteCount | 0;
      var s = segment($receiver, offset);
      var pos = offset;
      while (pos < endIndex) {
        var segmentOffset = s === 0 ? 0 : $receiver.directory_8be2vx$[s - 1 | 0];
        var segmentSize = $receiver.directory_8be2vx$[s] - segmentOffset | 0;
        var segmentPos = $receiver.directory_8be2vx$[$receiver.segments_8be2vx$.length + s | 0];
        var b = segmentOffset + segmentSize | 0;
        var byteCount_0 = JsMath.min(endIndex, b) - pos | 0;
        var offset_0 = segmentPos + (pos - segmentOffset) | 0;
        if (!other.rangeEquals_3fge6q$(otherOffset_0.v, $receiver.segments_8be2vx$[s], offset_0, byteCount_0))
          return false;
        otherOffset_0.v = otherOffset_0.v + byteCount_0 | 0;
        pos = pos + byteCount_0 | 0;
        s = s + 1 | 0;
      }
      return true;
    };
  }));
  var commonRangeEquals_4 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonRangeEquals_4jgj6t$', wrapFunction(function () {
    var arrayRangeEquals = _.okio.arrayRangeEquals_lwkm2r$;
    var JsMath = Math;
    return function ($receiver, offset, other, otherOffset, byteCount) {
      if (offset < 0 || offset > ($receiver.size - byteCount | 0) || otherOffset < 0 || otherOffset > (other.length - byteCount | 0)) {
        return false;
      }var otherOffset_0 = {v: otherOffset};
      var endIndex = offset + byteCount | 0;
      var s = segment($receiver, offset);
      var pos = offset;
      while (pos < endIndex) {
        var segmentOffset = s === 0 ? 0 : $receiver.directory_8be2vx$[s - 1 | 0];
        var segmentSize = $receiver.directory_8be2vx$[s] - segmentOffset | 0;
        var segmentPos = $receiver.directory_8be2vx$[$receiver.segments_8be2vx$.length + s | 0];
        var b = segmentOffset + segmentSize | 0;
        var byteCount_0 = JsMath.min(endIndex, b) - pos | 0;
        var offset_0 = segmentPos + (pos - segmentOffset) | 0;
        if (!arrayRangeEquals($receiver.segments_8be2vx$[s], offset_0, other, otherOffset_0.v, byteCount_0))
          return false;
        otherOffset_0.v = otherOffset_0.v + byteCount_0 | 0;
        pos = pos + byteCount_0 | 0;
        s = s + 1 | 0;
      }
      return true;
    };
  }));
  var commonCopyInto_0 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonCopyInto_4jgj6t$', wrapFunction(function () {
    var checkOffsetAndCount = _.okio.checkOffsetAndCount_e84ct6$;
    var Unit = Kotlin.kotlin.Unit;
    var wrapFunction = Kotlin.wrapFunction;
    var JsMath = Math;
    var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
    var commonCopyInto$lambda = wrapFunction(function () {
      var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
      return function (closure$target, closure$targetOffset) {
        return function (data, offset, byteCount) {
          arrayCopy(data, closure$target, closure$targetOffset.v, offset, offset + byteCount | 0);
          closure$targetOffset.v = closure$targetOffset.v + byteCount | 0;
          return Unit;
        };
      };
    });
    return function ($receiver, offset, target, targetOffset, byteCount) {
      checkOffsetAndCount(Kotlin.Long.fromInt($receiver.size), Kotlin.Long.fromInt(offset), Kotlin.Long.fromInt(byteCount));
      checkOffsetAndCount(Kotlin.Long.fromInt(target.length), Kotlin.Long.fromInt(targetOffset), Kotlin.Long.fromInt(byteCount));
      var targetOffset_0 = {v: targetOffset};
      var endIndex = offset + byteCount | 0;
      var s = segment($receiver, offset);
      var pos = offset;
      while (pos < endIndex) {
        var segmentOffset = s === 0 ? 0 : $receiver.directory_8be2vx$[s - 1 | 0];
        var segmentSize = $receiver.directory_8be2vx$[s] - segmentOffset | 0;
        var segmentPos = $receiver.directory_8be2vx$[$receiver.segments_8be2vx$.length + s | 0];
        var b = segmentOffset + segmentSize | 0;
        var byteCount_0 = JsMath.min(endIndex, b) - pos | 0;
        var offset_0 = segmentPos + (pos - segmentOffset) | 0;
        arrayCopy($receiver.segments_8be2vx$[s], target, targetOffset_0.v, offset_0, offset_0 + byteCount_0 | 0);
        targetOffset_0.v = targetOffset_0.v + byteCount_0 | 0;
        pos = pos + byteCount_0 | 0;
        s = s + 1 | 0;
      }
    };
  }));
  var commonEquals_2 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonEquals_xcao8d$', wrapFunction(function () {
    var ByteString = _.okio.ByteString;
    return function ($receiver, other) {
      var tmp$;
      if (other === $receiver)
        tmp$ = true;
      else if (Kotlin.isType(other, ByteString))
        tmp$ = (other.size === $receiver.size && $receiver.rangeEquals_kxw41n$(0, other, 0, $receiver.size));
      else
        tmp$ = false;
      return tmp$;
    };
  }));
  var commonHashCode_2 = defineInlineFunction('okio-parent-okio-js-legacy.okio.internal.commonHashCode_q6z9o3$', function ($receiver) {
    var result = {v: $receiver.hashCode_8be2vx$};
    if (result.v !== 0)
      return result.v;
    result.v = 1;
    var segmentCount = $receiver.segments_8be2vx$.length;
    var s = 0;
    var pos = 0;
    while (s < segmentCount) {
      var segmentPos = $receiver.directory_8be2vx$[segmentCount + s | 0];
      var nextSegmentOffset = $receiver.directory_8be2vx$[s];
      var data = $receiver.segments_8be2vx$[s];
      var i = segmentPos;
      var limit = segmentPos + (nextSegmentOffset - pos | 0) | 0;
      while (i < limit) {
        result.v = (31 * result.v | 0) + data[i];
        i = i + 1 | 0;
      }
      pos = nextSegmentOffset;
      s = s + 1 | 0;
    }
    $receiver.hashCode_8be2vx$ = result.v;
    return result.v;
  });
  function commonToUtf8String($receiver, beginIndex, endIndex) {
    if (beginIndex === void 0)
      beginIndex = 0;
    if (endIndex === void 0)
      endIndex = $receiver.length;
    if (beginIndex < 0 || endIndex > $receiver.length || beginIndex > endIndex) {
      throw new ArrayIndexOutOfBoundsException('size=' + $receiver.length + ' beginIndex=' + beginIndex + ' endIndex=' + endIndex);
    }var chars = Kotlin.charArray(endIndex - beginIndex | 0);
    var length = {v: 0};
    var tmp$;
    var index = beginIndex;
    loop_label: while (index < endIndex) {
      var b0 = $receiver[index];
      if (b0 >= 0) {
        var c = toBoxedChar(toChar(b0));
        var tmp$_0;
        chars[tmp$_0 = length.v, length.v = tmp$_0 + 1 | 0, tmp$_0] = unboxChar(c);
        index = index + 1 | 0;
        while (index < endIndex && $receiver[index] >= 0) {
          var c_0 = toBoxedChar(toChar($receiver[tmp$ = index, index = tmp$ + 1 | 0, tmp$]));
          var tmp$_1;
          chars[tmp$_1 = length.v, length.v = tmp$_1 + 1 | 0, tmp$_1] = unboxChar(c_0);
        }
      } else {
        if (b0 >> 5 === -2) {
          var tmp$_2 = index;
          var beginIndex_0 = index;
          var process2Utf8Bytes$result;
          process2Utf8Bytes$break: do {
            if (endIndex <= (beginIndex_0 + 1 | 0)) {
              var c_1 = toBoxedChar(toChar(65533));
              var tmp$_3;
              chars[tmp$_3 = length.v, length.v = tmp$_3 + 1 | 0, tmp$_3] = unboxChar(c_1);
              process2Utf8Bytes$result = 1;
              break process2Utf8Bytes$break;
            }var b0_0 = $receiver[beginIndex_0];
            var b1 = $receiver[beginIndex_0 + 1 | 0];
            if (!((b1 & 192) === 128)) {
              var c_2 = toBoxedChar(toChar(65533));
              var tmp$_4;
              chars[tmp$_4 = length.v, length.v = tmp$_4 + 1 | 0, tmp$_4] = unboxChar(c_2);
              process2Utf8Bytes$result = 1;
              break process2Utf8Bytes$break;
            }var codePoint = 3968 ^ b1 ^ b0_0 << 6;
            if (codePoint < 128) {
              var c_3 = toBoxedChar(toChar(65533));
              var tmp$_5;
              chars[tmp$_5 = length.v, length.v = tmp$_5 + 1 | 0, tmp$_5] = unboxChar(c_3);
            } else {
              var c_4 = toBoxedChar(toChar(codePoint));
              var tmp$_6;
              chars[tmp$_6 = length.v, length.v = tmp$_6 + 1 | 0, tmp$_6] = unboxChar(c_4);
            }
            process2Utf8Bytes$result = 2;
          }
           while (false);
          index = tmp$_2 + process2Utf8Bytes$result | 0;
        } else {
          if (b0 >> 4 === -2) {
            var tmp$_7 = index;
            var beginIndex_1 = index;
            var process3Utf8Bytes$result;
            process3Utf8Bytes$break: do {
              if (endIndex <= (beginIndex_1 + 2 | 0)) {
                var c_5 = toBoxedChar(toChar(65533));
                var tmp$_8;
                chars[tmp$_8 = length.v, length.v = tmp$_8 + 1 | 0, tmp$_8] = unboxChar(c_5);
                var tmp$_9 = endIndex <= (beginIndex_1 + 1 | 0);
                if (!tmp$_9) {
                  tmp$_9 = !(($receiver[beginIndex_1 + 1 | 0] & 192) === 128);
                }if (tmp$_9) {
                  process3Utf8Bytes$result = 1;
                  break process3Utf8Bytes$break;
                } else {
                  process3Utf8Bytes$result = 2;
                  break process3Utf8Bytes$break;
                }
              }var b0_1 = $receiver[beginIndex_1];
              var b1_0 = $receiver[beginIndex_1 + 1 | 0];
              if (!((b1_0 & 192) === 128)) {
                var c_6 = toBoxedChar(toChar(65533));
                var tmp$_10;
                chars[tmp$_10 = length.v, length.v = tmp$_10 + 1 | 0, tmp$_10] = unboxChar(c_6);
                process3Utf8Bytes$result = 1;
                break process3Utf8Bytes$break;
              }var b2 = $receiver[beginIndex_1 + 2 | 0];
              if (!((b2 & 192) === 128)) {
                var c_7 = toBoxedChar(toChar(65533));
                var tmp$_11;
                chars[tmp$_11 = length.v, length.v = tmp$_11 + 1 | 0, tmp$_11] = unboxChar(c_7);
                process3Utf8Bytes$result = 2;
                break process3Utf8Bytes$break;
              }var codePoint_0 = -123008 ^ b2 ^ b1_0 << 6 ^ b0_1 << 12;
              if (codePoint_0 < 2048) {
                var c_8 = toBoxedChar(toChar(65533));
                var tmp$_12;
                chars[tmp$_12 = length.v, length.v = tmp$_12 + 1 | 0, tmp$_12] = unboxChar(c_8);
              } else if (55296 <= codePoint_0 && codePoint_0 <= 57343) {
                var c_9 = toBoxedChar(toChar(65533));
                var tmp$_13;
                chars[tmp$_13 = length.v, length.v = tmp$_13 + 1 | 0, tmp$_13] = unboxChar(c_9);
              } else {
                var c_10 = toBoxedChar(toChar(codePoint_0));
                var tmp$_14;
                chars[tmp$_14 = length.v, length.v = tmp$_14 + 1 | 0, tmp$_14] = unboxChar(c_10);
              }
              process3Utf8Bytes$result = 3;
            }
             while (false);
            index = tmp$_7 + process3Utf8Bytes$result | 0;
          } else {
            if (b0 >> 3 === -2) {
              var tmp$_15 = index;
              var beginIndex_2 = index;
              var process4Utf8Bytes$result;
              process4Utf8Bytes$break: do {
                if (endIndex <= (beginIndex_2 + 3 | 0)) {
                  if (65533 !== 65533) {
                    var c_11 = toBoxedChar(toChar((65533 >>> 10) + 55232 | 0));
                    var tmp$_16;
                    chars[tmp$_16 = length.v, length.v = tmp$_16 + 1 | 0, tmp$_16] = unboxChar(c_11);
                    var c_12 = toBoxedChar(toChar((65533 & 1023) + 56320 | 0));
                    var tmp$_17;
                    chars[tmp$_17 = length.v, length.v = tmp$_17 + 1 | 0, tmp$_17] = unboxChar(c_12);
                  } else {
                    var c_13 = toBoxedChar(package$okio.REPLACEMENT_CHARACTER_8be2vx$);
                    var tmp$_18;
                    chars[tmp$_18 = length.v, length.v = tmp$_18 + 1 | 0, tmp$_18] = unboxChar(c_13);
                  }
                  var tmp$_19 = endIndex <= (beginIndex_2 + 1 | 0);
                  if (!tmp$_19) {
                    tmp$_19 = !(($receiver[beginIndex_2 + 1 | 0] & 192) === 128);
                  }if (tmp$_19) {
                    process4Utf8Bytes$result = 1;
                    break process4Utf8Bytes$break;
                  } else {
                    var tmp$_20 = endIndex <= (beginIndex_2 + 2 | 0);
                    if (!tmp$_20) {
                      tmp$_20 = !(($receiver[beginIndex_2 + 2 | 0] & 192) === 128);
                    }if (tmp$_20) {
                      process4Utf8Bytes$result = 2;
                      break process4Utf8Bytes$break;
                    } else {
                      process4Utf8Bytes$result = 3;
                      break process4Utf8Bytes$break;
                    }
                  }
                }var b0_2 = $receiver[beginIndex_2];
                var b1_1 = $receiver[beginIndex_2 + 1 | 0];
                if (!((b1_1 & 192) === 128)) {
                  if (65533 !== 65533) {
                    var c_14 = toBoxedChar(toChar((65533 >>> 10) + 55232 | 0));
                    var tmp$_21;
                    chars[tmp$_21 = length.v, length.v = tmp$_21 + 1 | 0, tmp$_21] = unboxChar(c_14);
                    var c_15 = toBoxedChar(toChar((65533 & 1023) + 56320 | 0));
                    var tmp$_22;
                    chars[tmp$_22 = length.v, length.v = tmp$_22 + 1 | 0, tmp$_22] = unboxChar(c_15);
                  } else {
                    var c_16 = toBoxedChar(package$okio.REPLACEMENT_CHARACTER_8be2vx$);
                    var tmp$_23;
                    chars[tmp$_23 = length.v, length.v = tmp$_23 + 1 | 0, tmp$_23] = unboxChar(c_16);
                  }
                  process4Utf8Bytes$result = 1;
                  break process4Utf8Bytes$break;
                }var b2_0 = $receiver[beginIndex_2 + 2 | 0];
                if (!((b2_0 & 192) === 128)) {
                  if (65533 !== 65533) {
                    var c_17 = toBoxedChar(toChar((65533 >>> 10) + 55232 | 0));
                    var tmp$_24;
                    chars[tmp$_24 = length.v, length.v = tmp$_24 + 1 | 0, tmp$_24] = unboxChar(c_17);
                    var c_18 = toBoxedChar(toChar((65533 & 1023) + 56320 | 0));
                    var tmp$_25;
                    chars[tmp$_25 = length.v, length.v = tmp$_25 + 1 | 0, tmp$_25] = unboxChar(c_18);
                  } else {
                    var c_19 = toBoxedChar(package$okio.REPLACEMENT_CHARACTER_8be2vx$);
                    var tmp$_26;
                    chars[tmp$_26 = length.v, length.v = tmp$_26 + 1 | 0, tmp$_26] = unboxChar(c_19);
                  }
                  process4Utf8Bytes$result = 2;
                  break process4Utf8Bytes$break;
                }var b3 = $receiver[beginIndex_2 + 3 | 0];
                if (!((b3 & 192) === 128)) {
                  if (65533 !== 65533) {
                    var c_20 = toBoxedChar(toChar((65533 >>> 10) + 55232 | 0));
                    var tmp$_27;
                    chars[tmp$_27 = length.v, length.v = tmp$_27 + 1 | 0, tmp$_27] = unboxChar(c_20);
                    var c_21 = toBoxedChar(toChar((65533 & 1023) + 56320 | 0));
                    var tmp$_28;
                    chars[tmp$_28 = length.v, length.v = tmp$_28 + 1 | 0, tmp$_28] = unboxChar(c_21);
                  } else {
                    var c_22 = toBoxedChar(package$okio.REPLACEMENT_CHARACTER_8be2vx$);
                    var tmp$_29;
                    chars[tmp$_29 = length.v, length.v = tmp$_29 + 1 | 0, tmp$_29] = unboxChar(c_22);
                  }
                  process4Utf8Bytes$result = 3;
                  break process4Utf8Bytes$break;
                }var codePoint_1 = 3678080 ^ b3 ^ b2_0 << 6 ^ b1_1 << 12 ^ b0_2 << 18;
                if (codePoint_1 > 1114111) {
                  if (65533 !== 65533) {
                    var c_23 = toBoxedChar(toChar((65533 >>> 10) + 55232 | 0));
                    var tmp$_30;
                    chars[tmp$_30 = length.v, length.v = tmp$_30 + 1 | 0, tmp$_30] = unboxChar(c_23);
                    var c_24 = toBoxedChar(toChar((65533 & 1023) + 56320 | 0));
                    var tmp$_31;
                    chars[tmp$_31 = length.v, length.v = tmp$_31 + 1 | 0, tmp$_31] = unboxChar(c_24);
                  } else {
                    var c_25 = toBoxedChar(package$okio.REPLACEMENT_CHARACTER_8be2vx$);
                    var tmp$_32;
                    chars[tmp$_32 = length.v, length.v = tmp$_32 + 1 | 0, tmp$_32] = unboxChar(c_25);
                  }
                } else if (55296 <= codePoint_1 && codePoint_1 <= 57343) {
                  if (65533 !== 65533) {
                    var c_26 = toBoxedChar(toChar((65533 >>> 10) + 55232 | 0));
                    var tmp$_33;
                    chars[tmp$_33 = length.v, length.v = tmp$_33 + 1 | 0, tmp$_33] = unboxChar(c_26);
                    var c_27 = toBoxedChar(toChar((65533 & 1023) + 56320 | 0));
                    var tmp$_34;
                    chars[tmp$_34 = length.v, length.v = tmp$_34 + 1 | 0, tmp$_34] = unboxChar(c_27);
                  } else {
                    var c_28 = toBoxedChar(package$okio.REPLACEMENT_CHARACTER_8be2vx$);
                    var tmp$_35;
                    chars[tmp$_35 = length.v, length.v = tmp$_35 + 1 | 0, tmp$_35] = unboxChar(c_28);
                  }
                } else if (codePoint_1 < 65536) {
                  if (65533 !== 65533) {
                    var c_29 = toBoxedChar(toChar((65533 >>> 10) + 55232 | 0));
                    var tmp$_36;
                    chars[tmp$_36 = length.v, length.v = tmp$_36 + 1 | 0, tmp$_36] = unboxChar(c_29);
                    var c_30 = toBoxedChar(toChar((65533 & 1023) + 56320 | 0));
                    var tmp$_37;
                    chars[tmp$_37 = length.v, length.v = tmp$_37 + 1 | 0, tmp$_37] = unboxChar(c_30);
                  } else {
                    var c_31 = toBoxedChar(package$okio.REPLACEMENT_CHARACTER_8be2vx$);
                    var tmp$_38;
                    chars[tmp$_38 = length.v, length.v = tmp$_38 + 1 | 0, tmp$_38] = unboxChar(c_31);
                  }
                } else {
                  if (codePoint_1 !== 65533) {
                    var c_32 = toBoxedChar(toChar((codePoint_1 >>> 10) + 55232 | 0));
                    var tmp$_39;
                    chars[tmp$_39 = length.v, length.v = tmp$_39 + 1 | 0, tmp$_39] = unboxChar(c_32);
                    var c_33 = toBoxedChar(toChar((codePoint_1 & 1023) + 56320 | 0));
                    var tmp$_40;
                    chars[tmp$_40 = length.v, length.v = tmp$_40 + 1 | 0, tmp$_40] = unboxChar(c_33);
                  } else {
                    var c_34 = toBoxedChar(package$okio.REPLACEMENT_CHARACTER_8be2vx$);
                    var tmp$_41;
                    chars[tmp$_41 = length.v, length.v = tmp$_41 + 1 | 0, tmp$_41] = unboxChar(c_34);
                  }
                }
                process4Utf8Bytes$result = 4;
              }
               while (false);
              index = tmp$_15 + process4Utf8Bytes$result | 0;
            } else {
              var c_35 = toBoxedChar(package$okio.REPLACEMENT_CHARACTER_8be2vx$);
              var tmp$_42;
              chars[tmp$_42 = length.v, length.v = tmp$_42 + 1 | 0, tmp$_42] = unboxChar(c_35);
              index = index + 1 | 0;
            }
          }
        }
      }
    }
    return concatToString_0(chars, 0, length.v);
  }
  function commonAsUtf8ToByteArray($receiver) {
    var tmp$;
    var bytes = new Int8Array(4 * $receiver.length | 0);
    tmp$ = $receiver.length;
    for (var index = 0; index < tmp$; index++) {
      var b0 = $receiver.charCodeAt(index);
      if (b0 >= 128) {
        var size = {v: index};
        var endIndex = $receiver.length;
        var tmp$_0;
        var index_0 = index;
        while (index_0 < endIndex) {
          var c = $receiver.charCodeAt(index_0);
          if (c < 128) {
            var c_0 = toByte(c | 0);
            var tmp$_1;
            bytes[tmp$_1 = size.v, size.v = tmp$_1 + 1 | 0, tmp$_1] = c_0;
            index_0 = index_0 + 1 | 0;
            while (index_0 < endIndex && $receiver.charCodeAt(index_0) < 128) {
              var c_1 = toByte($receiver.charCodeAt((tmp$_0 = index_0, index_0 = tmp$_0 + 1 | 0, tmp$_0)) | 0);
              var tmp$_2;
              bytes[tmp$_2 = size.v, size.v = tmp$_2 + 1 | 0, tmp$_2] = c_1;
            }
          } else if (c < 2048) {
            var c_2 = toByte((c | 0) >> 6 | 192);
            var tmp$_3;
            bytes[tmp$_3 = size.v, size.v = tmp$_3 + 1 | 0, tmp$_3] = c_2;
            var c_3 = toByte((c | 0) & 63 | 128);
            var tmp$_4;
            bytes[tmp$_4 = size.v, size.v = tmp$_4 + 1 | 0, tmp$_4] = c_3;
            index_0 = index_0 + 1 | 0;
          } else if (!(new CharRange(55296, 57343)).contains_mef7kx$(c)) {
            var c_4 = toByte((c | 0) >> 12 | 224);
            var tmp$_5;
            bytes[tmp$_5 = size.v, size.v = tmp$_5 + 1 | 0, tmp$_5] = c_4;
            var c_5 = toByte((c | 0) >> 6 & 63 | 128);
            var tmp$_6;
            bytes[tmp$_6 = size.v, size.v = tmp$_6 + 1 | 0, tmp$_6] = c_5;
            var c_6 = toByte((c | 0) & 63 | 128);
            var tmp$_7;
            bytes[tmp$_7 = size.v, size.v = tmp$_7 + 1 | 0, tmp$_7] = c_6;
            index_0 = index_0 + 1 | 0;
          } else {
            if (c > 56319 || endIndex <= (index_0 + 1 | 0) || !(new CharRange(56320, 57343)).contains_mef7kx$($receiver.charCodeAt(index_0 + 1 | 0))) {
              var c_7 = package$okio.REPLACEMENT_BYTE_8be2vx$;
              var tmp$_8;
              bytes[tmp$_8 = size.v, size.v = tmp$_8 + 1 | 0, tmp$_8] = c_7;
              index_0 = index_0 + 1 | 0;
            } else {
              var codePoint = ((c | 0) << 10) + ($receiver.charCodeAt(index_0 + 1 | 0) | 0) + -56613888 | 0;
              var c_8 = toByte(codePoint >> 18 | 240);
              var tmp$_9;
              bytes[tmp$_9 = size.v, size.v = tmp$_9 + 1 | 0, tmp$_9] = c_8;
              var c_9 = toByte(codePoint >> 12 & 63 | 128);
              var tmp$_10;
              bytes[tmp$_10 = size.v, size.v = tmp$_10 + 1 | 0, tmp$_10] = c_9;
              var c_10 = toByte(codePoint >> 6 & 63 | 128);
              var tmp$_11;
              bytes[tmp$_11 = size.v, size.v = tmp$_11 + 1 | 0, tmp$_11] = c_10;
              var c_11 = toByte(codePoint & 63 | 128);
              var tmp$_12;
              bytes[tmp$_12 = size.v, size.v = tmp$_12 + 1 | 0, tmp$_12] = c_11;
              index_0 = index_0 + 2 | 0;
            }
          }
        }
        return copyOf(bytes, size.v);
      }bytes[index] = toByte(b0 | 0);
    }
    return copyOf(bytes, $receiver.length);
  }
  function HashFunction() {
  }
  HashFunction.prototype.update_mj6st8$ = function (input, offset, byteCount, callback$default) {
    if (offset === void 0)
      offset = 0;
    if (byteCount === void 0)
      byteCount = input.length;
    callback$default ? callback$default(input, offset, byteCount) : this.update_mj6st8$$default(input, offset, byteCount);
  };
  HashFunction.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'HashFunction',
    interfaces: []
  };
  function Hmac(hashFunction, outerKey) {
    Hmac$Companion_getInstance();
    this.hashFunction_0 = hashFunction;
    this.outerKey_0 = outerKey;
  }
  Hmac.prototype.update_mj6st8$$default = function (input, offset, byteCount) {
    this.hashFunction_0.update_mj6st8$(input, offset, byteCount);
  };
  Hmac.prototype.digest = function () {
    var digest = this.hashFunction_0.digest();
    this.hashFunction_0.update_mj6st8$(this.outerKey_0);
    this.hashFunction_0.update_mj6st8$(digest);
    return this.hashFunction_0.digest();
  };
  function Hmac$Companion() {
    Hmac$Companion_instance = this;
    this.IPAD_0 = 54;
    this.OPAD_0 = 92;
  }
  Hmac$Companion.prototype.sha1_9ovubf$ = function (key) {
    return this.create_0(key, new Sha1(), 64);
  };
  Hmac$Companion.prototype.sha256_9ovubf$ = function (key) {
    return this.create_0(key, new Sha256(), 64);
  };
  Hmac$Companion.prototype.sha512_9ovubf$ = function (key) {
    return this.create_0(key, new Sha512(), 128);
  };
  Hmac$Companion.prototype.create_0 = function (key, hashFunction, blockLength) {
    var tmp$;
    var keySize = key.size;
    if (keySize === 0)
      throw IllegalArgumentException_init('Empty key');
    else if (keySize === blockLength)
      tmp$ = key.data_8be2vx$;
    else if (keySize < blockLength)
      tmp$ = copyOf(key.data_8be2vx$, blockLength);
    else {
      hashFunction.update_mj6st8$(key.data_8be2vx$);
      tmp$ = copyOf(hashFunction.digest(), blockLength);
    }
    var paddedKey = tmp$;
    var array = new Int8Array(blockLength);
    var tmp$_0;
    tmp$_0 = array.length - 1 | 0;
    for (var i = 0; i <= tmp$_0; i++) {
      array[i] = toByte(paddedKey[i] ^ this.IPAD_0);
    }
    var innerKey = array;
    var array_0 = new Int8Array(blockLength);
    var tmp$_1;
    tmp$_1 = array_0.length - 1 | 0;
    for (var i_0 = 0; i_0 <= tmp$_1; i_0++) {
      array_0[i_0] = toByte(paddedKey[i_0] ^ this.OPAD_0);
    }
    var outerKey = array_0;
    hashFunction.update_mj6st8$(innerKey);
    return new Hmac(hashFunction, outerKey);
  };
  Hmac$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Hmac$Companion_instance = null;
  function Hmac$Companion_getInstance() {
    if (Hmac$Companion_instance === null) {
      new Hmac$Companion();
    }return Hmac$Companion_instance;
  }
  Hmac.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Hmac',
    interfaces: [HashFunction]
  };
  function Md5() {
    Md5$Companion_getInstance();
    this.messageLength_0 = L0;
    this.unprocessed_0 = new Int8Array(64);
    this.unprocessedLimit_0 = 0;
    this.words_0 = new Int32Array(16);
    this.h0_0 = 1732584193;
    this.h1_0 = -271733879;
    this.h2_0 = -1732584194;
    this.h3_0 = 271733878;
  }
  Md5.prototype.update_mj6st8$$default = function (input, offset, byteCount) {
    this.messageLength_0 = this.messageLength_0.add(Kotlin.Long.fromInt(byteCount));
    var pos = offset;
    var limit = pos + byteCount | 0;
    var unprocessed = this.unprocessed_0;
    var unprocessedLimit = this.unprocessedLimit_0;
    if (unprocessedLimit > 0) {
      if ((unprocessedLimit + byteCount | 0) < 64) {
        arrayCopy(input, unprocessed, unprocessedLimit, pos, limit);
        this.unprocessedLimit_0 = unprocessedLimit + byteCount | 0;
        return;
      }var consumeByteCount = 64 - unprocessedLimit | 0;
      arrayCopy(input, unprocessed, unprocessedLimit, pos, pos + consumeByteCount | 0);
      this.processChunk_0(unprocessed, 0);
      this.unprocessedLimit_0 = 0;
      pos = pos + consumeByteCount | 0;
    }while (pos < limit) {
      var nextPos = pos + 64 | 0;
      if (nextPos > limit) {
        arrayCopy(input, unprocessed, 0, pos, limit);
        this.unprocessedLimit_0 = limit - pos | 0;
        return;
      }this.processChunk_0(input, pos);
      pos = nextPos;
    }
  };
  Md5.prototype.processChunk_0 = function (input, pos) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var words = this.words_0;
    var pos_0 = pos;
    for (var w = 0; w < 16; w++) {
      words[w] = input[tmp$ = pos_0, pos_0 = tmp$ + 1 | 0, tmp$] & 255 | (input[tmp$_0 = pos_0, pos_0 = tmp$_0 + 1 | 0, tmp$_0] & 255) << 8 | (input[tmp$_1 = pos_0, pos_0 = tmp$_1 + 1 | 0, tmp$_1] & 255) << 16 | (input[tmp$_2 = pos_0, pos_0 = tmp$_2 + 1 | 0, tmp$_2] & 255) << 24;
    }
    this.hash_0(words);
  };
  Md5.prototype.hash_0 = function (words) {
    var localK = Md5$Companion_getInstance().k_0;
    var localS = Md5$Companion_getInstance().s_0;
    var a = this.h0_0;
    var b = this.h1_0;
    var c = this.h2_0;
    var d = this.h3_0;
    for (var i = 0; i < 16; i++) {
      var g = i;
      var f = (b & c | ~b & d) + a + localK[i] + words[g] | 0;
      a = d;
      d = c;
      c = b;
      var tmp$ = b;
      var bitCount = localS[i];
      b = tmp$ + (f << bitCount | f >>> 32 - bitCount) | 0;
    }
    for (var i_0 = 16; i_0 < 32; i_0++) {
      var g_0 = ((5 * i_0 | 0) + 1 | 0) % 16;
      var f_0 = (d & b | ~d & c) + a + localK[i_0] + words[g_0] | 0;
      a = d;
      d = c;
      c = b;
      var tmp$_0 = b;
      var bitCount_0 = localS[i_0];
      b = tmp$_0 + (f_0 << bitCount_0 | f_0 >>> 32 - bitCount_0) | 0;
    }
    for (var i_1 = 32; i_1 < 48; i_1++) {
      var g_1 = ((3 * i_1 | 0) + 5 | 0) % 16;
      var f_1 = (b ^ c ^ d) + a + localK[i_1] + words[g_1] | 0;
      a = d;
      d = c;
      c = b;
      var tmp$_1 = b;
      var bitCount_1 = localS[i_1];
      b = tmp$_1 + (f_1 << bitCount_1 | f_1 >>> 32 - bitCount_1) | 0;
    }
    for (var i_2 = 48; i_2 < 64; i_2++) {
      var g_2 = (7 * i_2 | 0) % 16;
      var f_2 = (c ^ (b | ~d)) + a + localK[i_2] + words[g_2] | 0;
      a = d;
      d = c;
      c = b;
      var tmp$_2 = b;
      var bitCount_2 = localS[i_2];
      b = tmp$_2 + (f_2 << bitCount_2 | f_2 >>> 32 - bitCount_2) | 0;
    }
    this.h0_0 = this.h0_0 + a | 0;
    this.h1_0 = this.h1_0 + b | 0;
    this.h2_0 = this.h2_0 + c | 0;
    this.h3_0 = this.h3_0 + d | 0;
  };
  Md5.prototype.digest = function () {
    var tmp$;
    var messageLengthBits = this.messageLength_0.multiply(Kotlin.Long.fromInt(8));
    this.unprocessed_0[tmp$ = this.unprocessedLimit_0, this.unprocessedLimit_0 = tmp$ + 1 | 0, tmp$] = toByte(128);
    if (this.unprocessedLimit_0 > 56) {
      fill(this.unprocessed_0, 0, this.unprocessedLimit_0, 64);
      this.processChunk_0(this.unprocessed_0, 0);
      fill(this.unprocessed_0, 0, 0, this.unprocessedLimit_0);
    } else {
      fill(this.unprocessed_0, 0, this.unprocessedLimit_0, 56);
    }
    this.unprocessed_0[56] = toByte(messageLengthBits.toInt());
    this.unprocessed_0[57] = toByte(messageLengthBits.shiftRightUnsigned(8).toInt());
    this.unprocessed_0[58] = toByte(messageLengthBits.shiftRightUnsigned(16).toInt());
    this.unprocessed_0[59] = toByte(messageLengthBits.shiftRightUnsigned(24).toInt());
    this.unprocessed_0[60] = toByte(messageLengthBits.shiftRightUnsigned(32).toInt());
    this.unprocessed_0[61] = toByte(messageLengthBits.shiftRightUnsigned(40).toInt());
    this.unprocessed_0[62] = toByte(messageLengthBits.shiftRightUnsigned(48).toInt());
    this.unprocessed_0[63] = toByte(messageLengthBits.shiftRightUnsigned(56).toInt());
    this.processChunk_0(this.unprocessed_0, 0);
    var a = this.h0_0;
    var b = this.h1_0;
    var c = this.h2_0;
    var d = this.h3_0;
    return new Int8Array([toByte(a), toByte(a >> 8), toByte(a >> 16), toByte(a >> 24), toByte(b), toByte(b >> 8), toByte(b >> 16), toByte(b >> 24), toByte(c), toByte(c >> 8), toByte(c >> 16), toByte(c >> 24), toByte(d), toByte(d >> 8), toByte(d >> 16), toByte(d >> 24)]);
  };
  function Md5$Companion() {
    Md5$Companion_instance = this;
    this.s_0 = new Int32Array([7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21]);
    this.k_0 = new Int32Array([-680876936, -389564586, 606105819, -1044525330, -176418897, 1200080426, -1473231341, -45705983, 1770035416, -1958414417, -42063, -1990404162, 1804603682, -40341101, -1502002290, 1236535329, -165796510, -1069501632, 643717713, -373897302, -701558691, 38016083, -660478335, -405537848, 568446438, -1019803690, -187363961, 1163531501, -1444681467, -51403784, 1735328473, -1926607734, -378558, -2022574463, 1839030562, -35309556, -1530992060, 1272893353, -155497632, -1094730640, 681279174, -358537222, -722521979, 76029189, -640364487, -421815835, 530742520, -995338651, -198630844, 1126891415, -1416354905, -57434055, 1700485571, -1894986606, -1051523, -2054922799, 1873313359, -30611744, -1560198380, 1309151649, -145523070, -1120210379, 718787259, -343485551]);
  }
  Md5$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Md5$Companion_instance = null;
  function Md5$Companion_getInstance() {
    if (Md5$Companion_instance === null) {
      new Md5$Companion();
    }return Md5$Companion_instance;
  }
  Md5.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Md5',
    interfaces: [HashFunction]
  };
  function Sha1() {
    this.messageLength_0 = L0;
    this.unprocessed_0 = new Int8Array(64);
    this.unprocessedLimit_0 = 0;
    this.words_0 = new Int32Array(80);
    this.h0_0 = 1732584193;
    this.h1_0 = -271733879;
    this.h2_0 = -1732584194;
    this.h3_0 = 271733878;
    this.h4_0 = -1009589776;
  }
  Sha1.prototype.update_mj6st8$$default = function (input, offset, byteCount) {
    this.messageLength_0 = this.messageLength_0.add(Kotlin.Long.fromInt(byteCount));
    var pos = offset;
    var limit = pos + byteCount | 0;
    var unprocessed = this.unprocessed_0;
    var unprocessedLimit = this.unprocessedLimit_0;
    if (unprocessedLimit > 0) {
      if ((unprocessedLimit + byteCount | 0) < 64) {
        arrayCopy(input, unprocessed, unprocessedLimit, pos, limit);
        this.unprocessedLimit_0 = unprocessedLimit + byteCount | 0;
        return;
      }var consumeByteCount = 64 - unprocessedLimit | 0;
      arrayCopy(input, unprocessed, unprocessedLimit, pos, pos + consumeByteCount | 0);
      this.processChunk_0(unprocessed, 0);
      this.unprocessedLimit_0 = 0;
      pos = pos + consumeByteCount | 0;
    }while (pos < limit) {
      var nextPos = pos + 64 | 0;
      if (nextPos > limit) {
        arrayCopy(input, unprocessed, 0, pos, limit);
        this.unprocessedLimit_0 = limit - pos | 0;
        return;
      }this.processChunk_0(input, pos);
      pos = nextPos;
    }
  };
  Sha1.prototype.processChunk_0 = function (input, pos) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    var words = this.words_0;
    var pos_0 = pos;
    for (var w = 0; w < 16; w++) {
      words[w] = (input[tmp$ = pos_0, pos_0 = tmp$ + 1 | 0, tmp$] & 255) << 24 | (input[tmp$_0 = pos_0, pos_0 = tmp$_0 + 1 | 0, tmp$_0] & 255) << 16 | (input[tmp$_1 = pos_0, pos_0 = tmp$_1 + 1 | 0, tmp$_1] & 255) << 8 | input[tmp$_2 = pos_0, pos_0 = tmp$_2 + 1 | 0, tmp$_2] & 255;
    }
    for (var w_0 = 16; w_0 < 80; w_0++) {
      var $receiver = words[w_0 - 3 | 0] ^ words[w_0 - 8 | 0] ^ words[w_0 - 14 | 0] ^ words[w_0 - 16 | 0];
      words[w_0] = $receiver << 1 | $receiver >>> 32 - 1;
    }
    var a = this.h0_0;
    var b = this.h1_0;
    var c = this.h2_0;
    var d = this.h3_0;
    var e = this.h4_0;
    for (var i = 0; i < 80; i++) {
      if (i < 20) {
        var f = d ^ b & (c ^ d);
        var k = 1518500249;
        var $receiver_0 = a;
        tmp$_3 = ($receiver_0 << 5 | $receiver_0 >>> 32 - 5) + f + e + k + words[i] | 0;
      } else if (i < 40) {
        var f_0 = b ^ c ^ d;
        var k_0 = 1859775393;
        var $receiver_1 = a;
        tmp$_3 = ($receiver_1 << 5 | $receiver_1 >>> 32 - 5) + f_0 + e + k_0 + words[i] | 0;
      } else if (i < 60) {
        var f_1 = b & c | b & d | c & d;
        var k_1 = -1894007588;
        var $receiver_2 = a;
        tmp$_3 = ($receiver_2 << 5 | $receiver_2 >>> 32 - 5) + f_1 + e + k_1 + words[i] | 0;
      } else {
        var f_2 = b ^ c ^ d;
        var k_2 = -899497514;
        var $receiver_3 = a;
        tmp$_3 = ($receiver_3 << 5 | $receiver_3 >>> 32 - 5) + f_2 + e + k_2 + words[i] | 0;
      }
      var a2 = tmp$_3;
      e = d;
      d = c;
      var $receiver_4 = b;
      c = $receiver_4 << 30 | $receiver_4 >>> 32 - 30;
      b = a;
      a = a2;
    }
    this.h0_0 = this.h0_0 + a | 0;
    this.h1_0 = this.h1_0 + b | 0;
    this.h2_0 = this.h2_0 + c | 0;
    this.h3_0 = this.h3_0 + d | 0;
    this.h4_0 = this.h4_0 + e | 0;
  };
  Sha1.prototype.digest = function () {
    var tmp$;
    var unprocessed = this.unprocessed_0;
    var unprocessedLimit = this.unprocessedLimit_0;
    var messageLengthBits = this.messageLength_0.multiply(Kotlin.Long.fromInt(8));
    unprocessed[tmp$ = unprocessedLimit, unprocessedLimit = tmp$ + 1 | 0, tmp$] = toByte(128);
    if (unprocessedLimit > 56) {
      fill(unprocessed, 0, unprocessedLimit, 64);
      this.processChunk_0(unprocessed, 0);
      fill(unprocessed, 0, 0, unprocessedLimit);
    } else {
      fill(unprocessed, 0, unprocessedLimit, 56);
    }
    unprocessed[56] = toByte(messageLengthBits.shiftRightUnsigned(56).toInt());
    unprocessed[57] = toByte(messageLengthBits.shiftRightUnsigned(48).toInt());
    unprocessed[58] = toByte(messageLengthBits.shiftRightUnsigned(40).toInt());
    unprocessed[59] = toByte(messageLengthBits.shiftRightUnsigned(32).toInt());
    unprocessed[60] = toByte(messageLengthBits.shiftRightUnsigned(24).toInt());
    unprocessed[61] = toByte(messageLengthBits.shiftRightUnsigned(16).toInt());
    unprocessed[62] = toByte(messageLengthBits.shiftRightUnsigned(8).toInt());
    unprocessed[63] = toByte(messageLengthBits.toInt());
    this.processChunk_0(unprocessed, 0);
    var a = this.h0_0;
    var b = this.h1_0;
    var c = this.h2_0;
    var d = this.h3_0;
    var e = this.h4_0;
    this.reset_0();
    return new Int8Array([toByte(a >> 24), toByte(a >> 16), toByte(a >> 8), toByte(a), toByte(b >> 24), toByte(b >> 16), toByte(b >> 8), toByte(b), toByte(c >> 24), toByte(c >> 16), toByte(c >> 8), toByte(c), toByte(d >> 24), toByte(d >> 16), toByte(d >> 8), toByte(d), toByte(e >> 24), toByte(e >> 16), toByte(e >> 8), toByte(e)]);
  };
  Sha1.prototype.reset_0 = function () {
    this.messageLength_0 = L0;
    fill(this.unprocessed_0, 0);
    this.unprocessedLimit_0 = 0;
    fill_0(this.words_0, 0);
    this.h0_0 = 1732584193;
    this.h1_0 = -271733879;
    this.h2_0 = -1732584194;
    this.h3_0 = 271733878;
    this.h4_0 = -1009589776;
  };
  Sha1.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Sha1',
    interfaces: [HashFunction]
  };
  function Sha256() {
    Sha256$Companion_getInstance();
    this.messageLength_0 = L0;
    this.unprocessed_0 = new Int8Array(64);
    this.unprocessedLimit_0 = 0;
    this.words_0 = new Int32Array(64);
    this.h0_0 = 1779033703;
    this.h1_0 = -1150833019;
    this.h2_0 = 1013904242;
    this.h3_0 = -1521486534;
    this.h4_0 = 1359893119;
    this.h5_0 = -1694144372;
    this.h6_0 = 528734635;
    this.h7_0 = 1541459225;
  }
  Sha256.prototype.update_mj6st8$$default = function (input, offset, byteCount) {
    this.messageLength_0 = this.messageLength_0.add(Kotlin.Long.fromInt(byteCount));
    var pos = offset;
    var limit = pos + byteCount | 0;
    var unprocessed = this.unprocessed_0;
    var unprocessedLimit = this.unprocessedLimit_0;
    if (unprocessedLimit > 0) {
      if ((unprocessedLimit + byteCount | 0) < 64) {
        arrayCopy(input, unprocessed, unprocessedLimit, pos, limit);
        this.unprocessedLimit_0 = unprocessedLimit + byteCount | 0;
        return;
      }var consumeByteCount = 64 - unprocessedLimit | 0;
      arrayCopy(input, unprocessed, unprocessedLimit, pos, pos + consumeByteCount | 0);
      this.processChunk_0(unprocessed, 0);
      this.unprocessedLimit_0 = 0;
      pos = pos + consumeByteCount | 0;
    }while (pos < limit) {
      var nextPos = pos + 64 | 0;
      if (nextPos > limit) {
        arrayCopy(input, unprocessed, 0, pos, limit);
        this.unprocessedLimit_0 = limit - pos | 0;
        return;
      }this.processChunk_0(input, pos);
      pos = nextPos;
    }
  };
  Sha256.prototype.processChunk_0 = function (input, pos) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var words = this.words_0;
    var pos_0 = pos;
    for (var w = 0; w < 16; w++) {
      words[w] = (input[tmp$ = pos_0, pos_0 = tmp$ + 1 | 0, tmp$] & 255) << 24 | (input[tmp$_0 = pos_0, pos_0 = tmp$_0 + 1 | 0, tmp$_0] & 255) << 16 | (input[tmp$_1 = pos_0, pos_0 = tmp$_1 + 1 | 0, tmp$_1] & 255) << 8 | input[tmp$_2 = pos_0, pos_0 = tmp$_2 + 1 | 0, tmp$_2] & 255;
    }
    for (var w_0 = 16; w_0 < 64; w_0++) {
      var w15 = words[w_0 - 15 | 0];
      var s0 = (w15 >>> 7 | w15 << 25) ^ (w15 >>> 18 | w15 << 14) ^ w15 >>> 3;
      var w2 = words[w_0 - 2 | 0];
      var s1 = (w2 >>> 17 | w2 << 15) ^ (w2 >>> 19 | w2 << 13) ^ w2 >>> 10;
      var w16 = words[w_0 - 16 | 0];
      var w7 = words[w_0 - 7 | 0];
      words[w_0] = w16 + s0 + w7 + s1 | 0;
    }
    this.hash_0(words);
  };
  Sha256.prototype.hash_0 = function (words) {
    var localK = Sha256$Companion_getInstance().k_0;
    var a = this.h0_0;
    var b = this.h1_0;
    var c = this.h2_0;
    var d = this.h3_0;
    var e = this.h4_0;
    var f = this.h5_0;
    var g = this.h6_0;
    var h = this.h7_0;
    for (var i = 0; i < 64; i++) {
      var s0 = (a >>> 2 | a << 30) ^ (a >>> 13 | a << 19) ^ (a >>> 22 | a << 10);
      var s1 = (e >>> 6 | e << 26) ^ (e >>> 11 | e << 21) ^ (e >>> 25 | e << 7);
      var ch = e & f ^ ~e & g;
      var maj = a & b ^ a & c ^ b & c;
      var t1 = h + s1 + ch + localK[i] + words[i] | 0;
      var t2 = s0 + maj | 0;
      h = g;
      g = f;
      f = e;
      e = d + t1 | 0;
      d = c;
      c = b;
      b = a;
      a = t1 + t2 | 0;
    }
    this.h0_0 = this.h0_0 + a | 0;
    this.h1_0 = this.h1_0 + b | 0;
    this.h2_0 = this.h2_0 + c | 0;
    this.h3_0 = this.h3_0 + d | 0;
    this.h4_0 = this.h4_0 + e | 0;
    this.h5_0 = this.h5_0 + f | 0;
    this.h6_0 = this.h6_0 + g | 0;
    this.h7_0 = this.h7_0 + h | 0;
  };
  Sha256.prototype.digest = function () {
    var tmp$;
    var unprocessed = this.unprocessed_0;
    var unprocessedLimit = this.unprocessedLimit_0;
    var messageLengthBits = this.messageLength_0.multiply(Kotlin.Long.fromInt(8));
    unprocessed[tmp$ = unprocessedLimit, unprocessedLimit = tmp$ + 1 | 0, tmp$] = toByte(128);
    if (unprocessedLimit > 56) {
      fill(unprocessed, 0, unprocessedLimit, 64);
      this.processChunk_0(unprocessed, 0);
      fill(unprocessed, 0, 0, unprocessedLimit);
    } else {
      fill(unprocessed, 0, unprocessedLimit, 56);
    }
    unprocessed[56] = toByte(messageLengthBits.shiftRightUnsigned(56).toInt());
    unprocessed[57] = toByte(messageLengthBits.shiftRightUnsigned(48).toInt());
    unprocessed[58] = toByte(messageLengthBits.shiftRightUnsigned(40).toInt());
    unprocessed[59] = toByte(messageLengthBits.shiftRightUnsigned(32).toInt());
    unprocessed[60] = toByte(messageLengthBits.shiftRightUnsigned(24).toInt());
    unprocessed[61] = toByte(messageLengthBits.shiftRightUnsigned(16).toInt());
    unprocessed[62] = toByte(messageLengthBits.shiftRightUnsigned(8).toInt());
    unprocessed[63] = toByte(messageLengthBits.toInt());
    this.processChunk_0(unprocessed, 0);
    var a = this.h0_0;
    var b = this.h1_0;
    var c = this.h2_0;
    var d = this.h3_0;
    var e = this.h4_0;
    var f = this.h5_0;
    var g = this.h6_0;
    var h = this.h7_0;
    this.reset_0();
    return new Int8Array([toByte(a >> 24), toByte(a >> 16), toByte(a >> 8), toByte(a), toByte(b >> 24), toByte(b >> 16), toByte(b >> 8), toByte(b), toByte(c >> 24), toByte(c >> 16), toByte(c >> 8), toByte(c), toByte(d >> 24), toByte(d >> 16), toByte(d >> 8), toByte(d), toByte(e >> 24), toByte(e >> 16), toByte(e >> 8), toByte(e), toByte(f >> 24), toByte(f >> 16), toByte(f >> 8), toByte(f), toByte(g >> 24), toByte(g >> 16), toByte(g >> 8), toByte(g), toByte(h >> 24), toByte(h >> 16), toByte(h >> 8), toByte(h)]);
  };
  Sha256.prototype.reset_0 = function () {
    this.messageLength_0 = L0;
    fill(this.unprocessed_0, 0);
    this.unprocessedLimit_0 = 0;
    fill_0(this.words_0, 0);
    this.h0_0 = 1779033703;
    this.h1_0 = -1150833019;
    this.h2_0 = 1013904242;
    this.h3_0 = -1521486534;
    this.h4_0 = 1359893119;
    this.h5_0 = -1694144372;
    this.h6_0 = 528734635;
    this.h7_0 = 1541459225;
  };
  function Sha256$Companion() {
    Sha256$Companion_instance = this;
    this.k_0 = new Int32Array([1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998]);
  }
  Sha256$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Sha256$Companion_instance = null;
  function Sha256$Companion_getInstance() {
    if (Sha256$Companion_instance === null) {
      new Sha256$Companion();
    }return Sha256$Companion_instance;
  }
  Sha256.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Sha256',
    interfaces: [HashFunction]
  };
  function Sha512() {
    Sha512$Companion_getInstance();
    this.messageLength_0 = L0;
    this.unprocessed_0 = new Int8Array(128);
    this.unprocessedLimit_0 = 0;
    this.words_0 = Kotlin.longArray(80);
    this.h0_0 = L7640891576956012808;
    this.h1_0 = L_4942790177534073029;
    this.h2_0 = L4354685564936845355;
    this.h3_0 = L_6534734903238641935;
    this.h4_0 = L5840696475078001361;
    this.h5_0 = L_7276294671716946913;
    this.h6_0 = L2270897969802886507;
    this.h7_0 = L6620516959819538809;
  }
  Sha512.prototype.update_mj6st8$$default = function (input, offset, byteCount) {
    this.messageLength_0 = this.messageLength_0.add(Kotlin.Long.fromInt(byteCount));
    var pos = offset;
    var limit = pos + byteCount | 0;
    var unprocessed = this.unprocessed_0;
    var unprocessedLimit = this.unprocessedLimit_0;
    if (unprocessedLimit > 0) {
      if ((unprocessedLimit + byteCount | 0) < 128) {
        arrayCopy(input, unprocessed, unprocessedLimit, pos, limit);
        this.unprocessedLimit_0 = unprocessedLimit + byteCount | 0;
        return;
      }var consumeByteCount = 128 - unprocessedLimit | 0;
      arrayCopy(input, unprocessed, unprocessedLimit, pos, pos + consumeByteCount | 0);
      this.processChunk_0(unprocessed, 0);
      this.unprocessedLimit_0 = 0;
      pos = pos + consumeByteCount | 0;
    }while (pos < limit) {
      var nextPos = pos + 128 | 0;
      if (nextPos > limit) {
        arrayCopy(input, unprocessed, 0, pos, limit);
        this.unprocessedLimit_0 = limit - pos | 0;
        return;
      }this.processChunk_0(input, pos);
      pos = nextPos;
    }
  };
  Sha512.prototype.processChunk_0 = function (input, pos) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6;
    var words = this.words_0;
    var pos_0 = pos;
    for (var w = 0; w < 16; w++) {
      words[w] = Kotlin.Long.fromInt(input[tmp$ = pos_0, pos_0 = tmp$ + 1 | 0, tmp$]).and(L255).shiftLeft(56).or(Kotlin.Long.fromInt(input[tmp$_0 = pos_0, pos_0 = tmp$_0 + 1 | 0, tmp$_0]).and(L255).shiftLeft(48)).or(Kotlin.Long.fromInt(input[tmp$_1 = pos_0, pos_0 = tmp$_1 + 1 | 0, tmp$_1]).and(L255).shiftLeft(40)).or(Kotlin.Long.fromInt(input[tmp$_2 = pos_0, pos_0 = tmp$_2 + 1 | 0, tmp$_2]).and(L255).shiftLeft(32)).or(Kotlin.Long.fromInt(input[tmp$_3 = pos_0, pos_0 = tmp$_3 + 1 | 0, tmp$_3]).and(L255).shiftLeft(24)).or(Kotlin.Long.fromInt(input[tmp$_4 = pos_0, pos_0 = tmp$_4 + 1 | 0, tmp$_4]).and(L255).shiftLeft(16)).or(Kotlin.Long.fromInt(input[tmp$_5 = pos_0, pos_0 = tmp$_5 + 1 | 0, tmp$_5]).and(L255).shiftLeft(8)).or(Kotlin.Long.fromInt(input[tmp$_6 = pos_0, pos_0 = tmp$_6 + 1 | 0, tmp$_6]).and(L255));
    }
    for (var i = 16; i < 80; i++) {
      var w15 = words[i - 15 | 0];
      var s0 = w15.shiftRightUnsigned(1).or(w15.shiftLeft(64 - 1 | 0)).xor(w15.shiftRightUnsigned(8).or(w15.shiftLeft(64 - 8 | 0))).xor(w15.shiftRightUnsigned(7));
      var w2 = words[i - 2 | 0];
      var s1 = w2.shiftRightUnsigned(19).or(w2.shiftLeft(64 - 19 | 0)).xor(w2.shiftRightUnsigned(61).or(w2.shiftLeft(64 - 61 | 0))).xor(w2.shiftRightUnsigned(6));
      var w16 = words[i - 16 | 0];
      var w7 = words[i - 7 | 0];
      words[i] = w16.add(s0).add(w7).add(s1);
    }
    this.hash_0(words);
  };
  Sha512.prototype.hash_0 = function (words) {
    var localK = Sha512$Companion_getInstance().k_0;
    var a = this.h0_0;
    var b = this.h1_0;
    var c = this.h2_0;
    var d = this.h3_0;
    var e = this.h4_0;
    var f = this.h5_0;
    var g = this.h6_0;
    var h = this.h7_0;
    for (var i = 0; i < 80; i++) {
      var $receiver = a;
      var $receiver_0 = a;
      var $receiver_1 = a;
      var s0 = $receiver.shiftRightUnsigned(28).or($receiver.shiftLeft(64 - 28 | 0)).xor($receiver_0.shiftRightUnsigned(34).or($receiver_0.shiftLeft(64 - 34 | 0))).xor($receiver_1.shiftRightUnsigned(39).or($receiver_1.shiftLeft(64 - 39 | 0)));
      var $receiver_2 = e;
      var $receiver_3 = e;
      var $receiver_4 = e;
      var s1 = $receiver_2.shiftRightUnsigned(14).or($receiver_2.shiftLeft(64 - 14 | 0)).xor($receiver_3.shiftRightUnsigned(18).or($receiver_3.shiftLeft(64 - 18 | 0))).xor($receiver_4.shiftRightUnsigned(41).or($receiver_4.shiftLeft(64 - 41 | 0)));
      var ch = e.and(f).xor(e.inv().and(g));
      var maj = a.and(b).xor(a.and(c)).xor(b.and(c));
      var t1 = h.add(s1).add(ch).add(localK[i]).add(words[i]);
      var t2 = s0.add(maj);
      h = g;
      g = f;
      f = e;
      e = d.add(t1);
      d = c;
      c = b;
      b = a;
      a = t1.add(t2);
    }
    this.h0_0 = this.h0_0.add(a);
    this.h1_0 = this.h1_0.add(b);
    this.h2_0 = this.h2_0.add(c);
    this.h3_0 = this.h3_0.add(d);
    this.h4_0 = this.h4_0.add(e);
    this.h5_0 = this.h5_0.add(f);
    this.h6_0 = this.h6_0.add(g);
    this.h7_0 = this.h7_0.add(h);
  };
  Sha512.prototype.digest = function () {
    var tmp$;
    var unprocessed = this.unprocessed_0;
    var unprocessedLimit = this.unprocessedLimit_0;
    var messageLengthBits = this.messageLength_0.multiply(Kotlin.Long.fromInt(8));
    unprocessed[tmp$ = unprocessedLimit, unprocessedLimit = tmp$ + 1 | 0, tmp$] = toByte(128);
    if (unprocessedLimit > 112) {
      fill(unprocessed, 0, unprocessedLimit, 128);
      this.processChunk_0(unprocessed, 0);
      fill(unprocessed, 0, 0, unprocessedLimit);
    } else {
      fill(unprocessed, 0, unprocessedLimit, 120);
    }
    unprocessed[120] = toByte(messageLengthBits.shiftRightUnsigned(56).toInt());
    unprocessed[121] = toByte(messageLengthBits.shiftRightUnsigned(48).toInt());
    unprocessed[122] = toByte(messageLengthBits.shiftRightUnsigned(40).toInt());
    unprocessed[123] = toByte(messageLengthBits.shiftRightUnsigned(32).toInt());
    unprocessed[124] = toByte(messageLengthBits.shiftRightUnsigned(24).toInt());
    unprocessed[125] = toByte(messageLengthBits.shiftRightUnsigned(16).toInt());
    unprocessed[126] = toByte(messageLengthBits.shiftRightUnsigned(8).toInt());
    unprocessed[127] = toByte(messageLengthBits.toInt());
    this.processChunk_0(unprocessed, 0);
    var a = this.h0_0;
    var b = this.h1_0;
    var c = this.h2_0;
    var d = this.h3_0;
    var e = this.h4_0;
    var f = this.h5_0;
    var g = this.h6_0;
    var h = this.h7_0;
    this.reset_0();
    return new Int8Array([toByte(a.shiftRight(56).toInt()), toByte(a.shiftRight(48).toInt()), toByte(a.shiftRight(40).toInt()), toByte(a.shiftRight(32).toInt()), toByte(a.shiftRight(24).toInt()), toByte(a.shiftRight(16).toInt()), toByte(a.shiftRight(8).toInt()), toByte(a.toInt()), toByte(b.shiftRight(56).toInt()), toByte(b.shiftRight(48).toInt()), toByte(b.shiftRight(40).toInt()), toByte(b.shiftRight(32).toInt()), toByte(b.shiftRight(24).toInt()), toByte(b.shiftRight(16).toInt()), toByte(b.shiftRight(8).toInt()), toByte(b.toInt()), toByte(c.shiftRight(56).toInt()), toByte(c.shiftRight(48).toInt()), toByte(c.shiftRight(40).toInt()), toByte(c.shiftRight(32).toInt()), toByte(c.shiftRight(24).toInt()), toByte(c.shiftRight(16).toInt()), toByte(c.shiftRight(8).toInt()), toByte(c.toInt()), toByte(d.shiftRight(56).toInt()), toByte(d.shiftRight(48).toInt()), toByte(d.shiftRight(40).toInt()), toByte(d.shiftRight(32).toInt()), toByte(d.shiftRight(24).toInt()), toByte(d.shiftRight(16).toInt()), toByte(d.shiftRight(8).toInt()), toByte(d.toInt()), toByte(e.shiftRight(56).toInt()), toByte(e.shiftRight(48).toInt()), toByte(e.shiftRight(40).toInt()), toByte(e.shiftRight(32).toInt()), toByte(e.shiftRight(24).toInt()), toByte(e.shiftRight(16).toInt()), toByte(e.shiftRight(8).toInt()), toByte(e.toInt()), toByte(f.shiftRight(56).toInt()), toByte(f.shiftRight(48).toInt()), toByte(f.shiftRight(40).toInt()), toByte(f.shiftRight(32).toInt()), toByte(f.shiftRight(24).toInt()), toByte(f.shiftRight(16).toInt()), toByte(f.shiftRight(8).toInt()), toByte(f.toInt()), toByte(g.shiftRight(56).toInt()), toByte(g.shiftRight(48).toInt()), toByte(g.shiftRight(40).toInt()), toByte(g.shiftRight(32).toInt()), toByte(g.shiftRight(24).toInt()), toByte(g.shiftRight(16).toInt()), toByte(g.shiftRight(8).toInt()), toByte(g.toInt()), toByte(h.shiftRight(56).toInt()), toByte(h.shiftRight(48).toInt()), toByte(h.shiftRight(40).toInt()), toByte(h.shiftRight(32).toInt()), toByte(h.shiftRight(24).toInt()), toByte(h.shiftRight(16).toInt()), toByte(h.shiftRight(8).toInt()), toByte(h.toInt())]);
  };
  Sha512.prototype.reset_0 = function () {
    this.messageLength_0 = L0;
    fill(this.unprocessed_0, 0);
    this.unprocessedLimit_0 = 0;
    fill_1(this.words_0, L0);
    this.h0_0 = L7640891576956012808;
    this.h1_0 = L_4942790177534073029;
    this.h2_0 = L4354685564936845355;
    this.h3_0 = L_6534734903238641935;
    this.h4_0 = L5840696475078001361;
    this.h5_0 = L_7276294671716946913;
    this.h6_0 = L2270897969802886507;
    this.h7_0 = L6620516959819538809;
  };
  function Sha512$Companion() {
    Sha512$Companion_instance = this;
    this.k_0 = Kotlin.longArrayOf(L4794697086780616226, L8158064640168781261, L_5349999486874862801, L_1606136188198331460, L4131703408338449720, L6480981068601479193, L_7908458776815382629, L_6116909921290321640, L_2880145864133508542, L1334009975649890238, L2608012711638119052, L6128411473006802146, L8268148722764581231, L_9160688886553864527, L_7215885187991268811, L_4495734319001033068, L_1973867731355612462, L_1171420211273849373, L1135362057144423861, L2597628984639134821, L3308224258029322869, L5365058923640841347, L6679025012923562964, L8573033837759648693, L_7476448914759557205, L_6327057829258317296, L_5763719355590565569, L_4658551843659510044, L_4116276920077217854, L_3051310485924567259, L489312712824947311, L1452737877330783856, L2861767655752347644, L3322285676063803686, L5560940570517711597, L5996557281743188959, L7280758554555802590, L8532644243296465576, L_9096487096722542874, L_7894198246740708037, L_6719396339535248540, L_6333637450476146687, L_4446306890439682159, L_4076793802049405392, L_3345356375505022440, L_2983346525034927856, L_860691631967231958, L1182934255886127544, L1847814050463011016, L2177327727835720531, L2830643537854262169, L3796741975233480872, L4115178125766777443, L5681478168544905931, L6601373596472566643, L7507060721942968483, L8399075790359081724, L8693463985226723168, L_8878714635349349518, L_8302665154208450068, L_8016688836872298968, L_6606660893046293015, L_4685533653050689259, L_4147400797238176981, L_3880063495543823972, L_3348786107499101689, L_1523767162380948706, L_757361751448694408, L500013540394364858, L748580250866718886, L1242879168328830382, L1977374033974150939, L2944078676154940804, L3659926193048069267, L4368137639120453308, L4836135668995329356, L5532061633213252278, L6448918945643986474, L6902733635092675308, L7801388544844847127);
  }
  Sha512$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Sha512$Companion_instance = null;
  function Sha512$Companion_getInstance() {
    if (Sha512$Companion_instance === null) {
      new Sha512$Companion();
    }return Sha512$Companion_instance;
  }
  Sha512.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Sha512',
    interfaces: [HashFunction]
  };
  function get_PLATFORM_DIRECTORY_SEPARATOR() {
    var tmp$, tmp$_0, tmp$_1;
    return (tmp$_1 = typeof (tmp$_0 = (tmp$ = get_path()) != null ? tmp$.sep : null) === 'string' ? tmp$_0 : null) != null ? tmp$_1 : '/';
  }
  function get_os() {
    var tmp$;
    try {
      tmp$ = require('os');
    } catch (t) {
      if (Kotlin.isType(t, Throwable)) {
        tmp$ = null;
      } else
        throw t;
    }
    return tmp$;
  }
  function get_path() {
    var tmp$;
    try {
      tmp$ = require('path');
    } catch (t) {
      if (Kotlin.isType(t, Throwable)) {
        tmp$ = null;
      } else
        throw t;
    }
    return tmp$;
  }
  function get_tmpdir() {
    var tmp$, tmp$_0, tmp$_1;
    return (tmp$_1 = typeof (tmp$_0 = (tmp$ = get_os()) != null ? tmp$.tmpdir() : null) === 'string' ? tmp$_0 : null) != null ? tmp$_1 : '/tmp';
  }
  function FileSystem() {
    FileSystem$Companion_getInstance();
  }
  FileSystem.prototype.metadata_awoskx$ = function (path) {
    return commonMetadata(this, path);
  };
  FileSystem.prototype.exists_awoskx$ = function (path) {
    return commonExists(this, path);
  };
  FileSystem.prototype.listRecursively_1apv92$$default = function (dir, followSymlinks) {
    return commonListRecursively(this, dir, followSymlinks);
  };
  FileSystem.prototype.listRecursively_1apv92$ = function (dir, followSymlinks, callback$default) {
    if (followSymlinks === void 0)
      followSymlinks = false;
    return callback$default ? callback$default(dir, followSymlinks) : this.listRecursively_1apv92$$default(dir, followSymlinks);
  };
  FileSystem.prototype.openReadWrite_5ehyq9$ = function (file, mustCreate, mustExist, callback$default) {
    if (mustCreate === void 0)
      mustCreate = false;
    if (mustExist === void 0)
      mustExist = false;
    return callback$default ? callback$default(file, mustCreate, mustExist) : this.openReadWrite_5ehyq9$$default(file, mustCreate, mustExist);
  };
  FileSystem.prototype.read_pjn3ap$ = defineInlineFunction('okio-parent-okio-js-legacy.okio.FileSystem.read_pjn3ap$', wrapFunction(function () {
    var buffer = _.okio.buffer_px5ndk$;
    var Throwable = Error;
    var Unit = Kotlin.kotlin.Unit;
    var addSuppressed = Kotlin.kotlin.addSuppressed_oh0dqn$;
    var ensureNotNull = Kotlin.ensureNotNull;
    return function (file, readerAction) {
      var $receiver = buffer(this.source_awoskx$(file));
      var result = null;
      var thrown = null;
      try {
        result = readerAction($receiver);
      } catch (t) {
        if (Kotlin.isType(t, Throwable)) {
          thrown = t;
        } else
          throw t;
      }
      try {
        $receiver != null ? ($receiver.close(), Unit) : null;
      } catch (t_0) {
        if (Kotlin.isType(t_0, Throwable)) {
          if (thrown == null)
            thrown = t_0;
          else
            addSuppressed(thrown, t_0);
        } else
          throw t_0;
      }
      if (thrown != null)
        throw thrown;
      return ensureNotNull(result);
    };
  }));
  FileSystem.prototype.sink_1apv92$ = function (file, mustCreate, callback$default) {
    if (mustCreate === void 0)
      mustCreate = false;
    return callback$default ? callback$default(file, mustCreate) : this.sink_1apv92$$default(file, mustCreate);
  };
  FileSystem.prototype.write_2n71l8$ = defineInlineFunction('okio-parent-okio-js-legacy.okio.FileSystem.write_2n71l8$', wrapFunction(function () {
    var buffer = _.okio.buffer_gyfaj4$;
    var Throwable = Error;
    var Unit = Kotlin.kotlin.Unit;
    var addSuppressed = Kotlin.kotlin.addSuppressed_oh0dqn$;
    var ensureNotNull = Kotlin.ensureNotNull;
    return function (file, mustCreate, writerAction) {
      if (mustCreate === void 0)
        mustCreate = false;
      var $receiver = buffer(this.sink_1apv92$(file, mustCreate));
      var result = null;
      var thrown = null;
      try {
        result = writerAction($receiver);
      } catch (t) {
        if (Kotlin.isType(t, Throwable)) {
          thrown = t;
        } else
          throw t;
      }
      try {
        $receiver != null ? ($receiver.close(), Unit) : null;
      } catch (t_0) {
        if (Kotlin.isType(t_0, Throwable)) {
          if (thrown == null)
            thrown = t_0;
          else
            addSuppressed(thrown, t_0);
        } else
          throw t_0;
      }
      if (thrown != null)
        throw thrown;
      return ensureNotNull(result);
    };
  }));
  FileSystem.prototype.appendingSink_1apv92$ = function (file, mustExist, callback$default) {
    if (mustExist === void 0)
      mustExist = false;
    return callback$default ? callback$default(file, mustExist) : this.appendingSink_1apv92$$default(file, mustExist);
  };
  FileSystem.prototype.createDirectory_1apv92$ = function (dir, mustCreate, callback$default) {
    if (mustCreate === void 0)
      mustCreate = false;
    callback$default ? callback$default(dir, mustCreate) : this.createDirectory_1apv92$$default(dir, mustCreate);
  };
  FileSystem.prototype.createDirectories_1apv92$ = function (dir, mustCreate) {
    if (mustCreate === void 0)
      mustCreate = false;
    commonCreateDirectories(this, dir, mustCreate);
  };
  FileSystem.prototype.copy_vhmyk6$ = function (source, target) {
    commonCopy_0(this, source, target);
  };
  FileSystem.prototype.delete_1apv92$ = function (path, mustExist, callback$default) {
    if (mustExist === void 0)
      mustExist = false;
    callback$default ? callback$default(path, mustExist) : this.delete_1apv92$$default(path, mustExist);
  };
  FileSystem.prototype.deleteRecursively_1apv92$$default = function (fileOrDirectory, mustExist) {
    commonDeleteRecursively(this, fileOrDirectory, mustExist);
  };
  FileSystem.prototype.deleteRecursively_1apv92$ = function (fileOrDirectory, mustExist, callback$default) {
    if (mustExist === void 0)
      mustExist = false;
    callback$default ? callback$default(fileOrDirectory, mustExist) : this.deleteRecursively_1apv92$$default(fileOrDirectory, mustExist);
  };
  function FileSystem$Companion() {
    FileSystem$Companion_instance = this;
    this.SYSTEM_TEMPORARY_DIRECTORY = Path$Companion_getInstance().toPath_f4dhtg$(get_tmpdir());
  }
  FileSystem$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FileSystem$Companion_instance = null;
  function FileSystem$Companion_getInstance() {
    if (FileSystem$Companion_instance === null) {
      new FileSystem$Companion();
    }return FileSystem$Companion_instance;
  }
  FileSystem.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileSystem',
    interfaces: []
  };
  function toUtf8String($receiver) {
    return commonToUtf8String($receiver);
  }
  function asUtf8ToByteArray($receiver) {
    return commonAsUtf8ToByteArray($receiver);
  }
  function ArrayIndexOutOfBoundsException(message) {
    IndexOutOfBoundsException.call(this, message);
    this.name = 'ArrayIndexOutOfBoundsException';
  }
  ArrayIndexOutOfBoundsException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ArrayIndexOutOfBoundsException',
    interfaces: [IndexOutOfBoundsException]
  };
  var synchronized = defineInlineFunction('okio-parent-okio-js-legacy.okio.synchronized_4sv92k$', function (lock, block) {
    return block();
  });
  function IOException(message, cause) {
    Exception.call(this, message, cause);
    this.name = 'IOException';
  }
  IOException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IOException',
    interfaces: [Exception]
  };
  function IOException_init(message, $this) {
    if (message === void 0)
      message = null;
    $this = $this || Object.create(IOException.prototype);
    IOException.call($this, message, null);
    return $this;
  }
  function EOFException(message) {
    if (message === void 0)
      message = null;
    IOException_init(message, this);
    this.name = 'EOFException';
  }
  EOFException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EOFException',
    interfaces: [IOException]
  };
  function FileNotFoundException(message) {
    if (message === void 0)
      message = null;
    IOException_init(message, this);
    this.name = 'FileNotFoundException';
  }
  FileNotFoundException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileNotFoundException',
    interfaces: [IOException]
  };
  function Closeable() {
  }
  Closeable.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Closeable',
    interfaces: []
  };
  function Buffer() {
    this.head_8be2vx$ = null;
    this.size_feyg1j$_0 = L0;
  }
  Object.defineProperty(Buffer.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.size_feyg1j$_0;
    },
    set: function (size) {
      this.size_feyg1j$_0 = size;
    }
  });
  Object.defineProperty(Buffer.prototype, 'buffer', {
    configurable: true,
    get: function () {
      return this;
    }
  });
  Buffer.prototype.emitCompleteSegments = function () {
    return this;
  };
  Buffer.prototype.emit = function () {
    return this;
  };
  Buffer.prototype.exhausted = function () {
    return equals(this.size, L0);
  };
  Buffer.prototype.require_s8cxhz$ = function (byteCount) {
    if (this.size.compareTo_11rb$(byteCount) < 0)
      throw new EOFException(null);
  };
  Buffer.prototype.request_s8cxhz$ = function (byteCount) {
    return this.size.compareTo_11rb$(byteCount) >= 0;
  };
  Buffer.prototype.peek = function () {
    return buffer(new PeekSource(this));
  };
  Buffer.prototype.copyTo_ins7gm$ = function (out, offset, byteCount) {
    if (offset === void 0)
      offset = L0;
    var commonCopyTo$result;
    commonCopyTo$break: do {
      var offset_0 = offset;
      var byteCount_0 = byteCount;
      checkOffsetAndCount(this.size, offset_0, byteCount_0);
      if (equals(byteCount_0, L0)) {
        commonCopyTo$result = this;
        break commonCopyTo$break;
      }out.size = out.size.add(byteCount_0);
      var s = this.head_8be2vx$;
      while (offset_0.toNumber() >= (ensureNotNull(s).limit - s.pos | 0)) {
        offset_0 = offset_0.subtract(Kotlin.Long.fromInt(s.limit - s.pos | 0));
        s = s.next;
      }
      while (byteCount_0.compareTo_11rb$(L0) > 0) {
        var copy = ensureNotNull(s).sharedCopy();
        copy.pos = copy.pos + offset_0.toInt() | 0;
        var a = copy.pos + byteCount_0.toInt() | 0;
        var b = copy.limit;
        copy.limit = JsMath.min(a, b);
        if (out.head_8be2vx$ == null) {
          copy.prev = copy;
          copy.next = copy.prev;
          out.head_8be2vx$ = copy.next;
        } else {
          ensureNotNull(ensureNotNull(out.head_8be2vx$).prev).push_uve4t5$(copy);
        }
        byteCount_0 = byteCount_0.subtract(Kotlin.Long.fromInt(copy.limit - copy.pos | 0));
        offset_0 = L0;
        s = s.next;
      }
      commonCopyTo$result = this;
    }
     while (false);
    return commonCopyTo$result;
  };
  Buffer.prototype.copyTo_u27jpl$ = function (out, offset) {
    if (offset === void 0)
      offset = L0;
    return this.copyTo_ins7gm$(out, offset, this.size.subtract(offset));
  };
  Buffer.prototype.get_s8cxhz$ = function (pos) {
    var commonGet$result;
    commonGet$break: do {
      checkOffsetAndCount(this.size, pos, L1);
      var tmp$;
      tmp$ = this.head_8be2vx$;
      if (tmp$ == null) {
        var offset = L_1;
        commonGet$result = ensureNotNull(null).data[Kotlin.Long.fromInt(null.pos).add(pos).subtract(offset).toInt()];
        break commonGet$break;
      }var s = tmp$;
      if (this.size.subtract(pos).compareTo_11rb$(pos) < 0) {
        var offset_0 = this.size;
        while (offset_0.compareTo_11rb$(pos) > 0) {
          s = ensureNotNull(s.prev);
          offset_0 = offset_0.subtract(Kotlin.Long.fromInt(s.limit - s.pos | 0));
        }
        var s_0 = s;
        var offset_1 = offset_0;
        commonGet$result = ensureNotNull(s_0).data[Kotlin.Long.fromInt(s_0.pos).add(pos).subtract(offset_1).toInt()];
      } else {
        var offset_2 = L0;
        while (true) {
          var nextOffset = offset_2.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
          if (nextOffset.compareTo_11rb$(pos) > 0)
            break;
          s = ensureNotNull(s.next);
          offset_2 = nextOffset;
        }
        var s_1 = s;
        var offset_3 = offset_2;
        commonGet$result = ensureNotNull(s_1).data[Kotlin.Long.fromInt(s_1.pos).add(pos).subtract(offset_3).toInt()];
      }
    }
     while (false);
    return commonGet$result;
  };
  Buffer.prototype.completeSegmentByteCount = function () {
    var commonCompleteSegmentByteCount$result;
    commonCompleteSegmentByteCount$break: do {
      var result = this.size;
      if (equals(result, L0)) {
        commonCompleteSegmentByteCount$result = L0;
        break commonCompleteSegmentByteCount$break;
      }var tail = ensureNotNull(ensureNotNull(this.head_8be2vx$).prev);
      if (tail.limit < 8192 && tail.owner) {
        result = result.subtract(Kotlin.Long.fromInt(tail.limit - tail.pos | 0));
      }commonCompleteSegmentByteCount$result = result;
    }
     while (false);
    return commonCompleteSegmentByteCount$result;
  };
  Buffer.prototype.readByte = function () {
    var tmp$;
    if (equals(this.size, L0))
      throw new EOFException();
    var segment = ensureNotNull(this.head_8be2vx$);
    var pos = segment.pos;
    var limit = segment.limit;
    var data = segment.data;
    var b = data[tmp$ = pos, pos = tmp$ + 1 | 0, tmp$];
    this.size = this.size.subtract(L1);
    if (pos === limit) {
      this.head_8be2vx$ = segment.pop();
      package$okio.SegmentPool.recycle_uve4t5$(segment);
    } else {
      segment.pos = pos;
    }
    return b;
  };
  Buffer.prototype.readShort = function () {
    var commonReadShort$result;
    commonReadShort$break: do {
      var tmp$, tmp$_0;
      if (this.size.compareTo_11rb$(L2) < 0)
        throw new EOFException();
      var segment = ensureNotNull(this.head_8be2vx$);
      var pos = segment.pos;
      var limit = segment.limit;
      if ((limit - pos | 0) < 2) {
        var s = (this.readByte() & 255) << 8 | this.readByte() & 255;
        commonReadShort$result = toShort(s);
        break commonReadShort$break;
      }var data = segment.data;
      var s_0 = (data[tmp$ = pos, pos = tmp$ + 1 | 0, tmp$] & 255) << 8 | data[tmp$_0 = pos, pos = tmp$_0 + 1 | 0, tmp$_0] & 255;
      this.size = this.size.subtract(L2);
      if (pos === limit) {
        this.head_8be2vx$ = segment.pop();
        package$okio.SegmentPool.recycle_uve4t5$(segment);
      } else {
        segment.pos = pos;
      }
      commonReadShort$result = toShort(s_0);
    }
     while (false);
    return commonReadShort$result;
  };
  Buffer.prototype.readInt = function () {
    var commonReadInt$result;
    commonReadInt$break: do {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      if (this.size.compareTo_11rb$(L4) < 0)
        throw new EOFException();
      var segment = ensureNotNull(this.head_8be2vx$);
      var pos = segment.pos;
      var limit = segment.limit;
      if ((limit - pos | 0) < L4.toNumber()) {
        commonReadInt$result = (this.readByte() & 255) << 24 | (this.readByte() & 255) << 16 | (this.readByte() & 255) << 8 | this.readByte() & 255;
        break commonReadInt$break;
      }var data = segment.data;
      var i = (data[tmp$ = pos, pos = tmp$ + 1 | 0, tmp$] & 255) << 24 | (data[tmp$_0 = pos, pos = tmp$_0 + 1 | 0, tmp$_0] & 255) << 16 | (data[tmp$_1 = pos, pos = tmp$_1 + 1 | 0, tmp$_1] & 255) << 8 | data[tmp$_2 = pos, pos = tmp$_2 + 1 | 0, tmp$_2] & 255;
      this.size = this.size.subtract(L4);
      if (pos === limit) {
        this.head_8be2vx$ = segment.pop();
        package$okio.SegmentPool.recycle_uve4t5$(segment);
      } else {
        segment.pos = pos;
      }
      commonReadInt$result = i;
    }
     while (false);
    return commonReadInt$result;
  };
  Buffer.prototype.readLong = function () {
    var commonReadLong$result;
    commonReadLong$break: do {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8, tmp$_9, tmp$_10, tmp$_11, tmp$_12, tmp$_13;
      if (this.size.compareTo_11rb$(L8) < 0)
        throw new EOFException();
      var segment = ensureNotNull(this.head_8be2vx$);
      var pos = segment.pos;
      var limit = segment.limit;
      if ((limit - pos | 0) < L8.toNumber()) {
        var $receiver = this.readInt();
        var other = L4294967295;
        var tmp$_14 = Kotlin.Long.fromInt($receiver).and(other).shiftLeft(32);
        var $receiver_0 = this.readInt();
        var other_0 = L4294967295;
        commonReadLong$result = tmp$_14.or(Kotlin.Long.fromInt($receiver_0).and(other_0));
        break commonReadLong$break;
      }var data = segment.data;
      var $receiver_1 = data[tmp$ = pos, pos = tmp$ + 1 | 0, tmp$];
      var other_1 = L255;
      tmp$_1 = Kotlin.Long.fromInt($receiver_1).and(other_1).shiftLeft(56);
      var $receiver_2 = data[tmp$_0 = pos, pos = tmp$_0 + 1 | 0, tmp$_0];
      var other_2 = L255;
      tmp$_3 = tmp$_1.or(Kotlin.Long.fromInt($receiver_2).and(other_2).shiftLeft(48));
      var $receiver_3 = data[tmp$_2 = pos, pos = tmp$_2 + 1 | 0, tmp$_2];
      var other_3 = L255;
      tmp$_5 = tmp$_3.or(Kotlin.Long.fromInt($receiver_3).and(other_3).shiftLeft(40));
      var $receiver_4 = data[tmp$_4 = pos, pos = tmp$_4 + 1 | 0, tmp$_4];
      var other_4 = L255;
      tmp$_7 = tmp$_5.or(Kotlin.Long.fromInt($receiver_4).and(other_4).shiftLeft(32));
      var $receiver_5 = data[tmp$_6 = pos, pos = tmp$_6 + 1 | 0, tmp$_6];
      var other_5 = L255;
      tmp$_9 = tmp$_7.or(Kotlin.Long.fromInt($receiver_5).and(other_5).shiftLeft(24));
      var $receiver_6 = data[tmp$_8 = pos, pos = tmp$_8 + 1 | 0, tmp$_8];
      var other_6 = L255;
      tmp$_11 = tmp$_9.or(Kotlin.Long.fromInt($receiver_6).and(other_6).shiftLeft(16));
      var $receiver_7 = data[tmp$_10 = pos, pos = tmp$_10 + 1 | 0, tmp$_10];
      var other_7 = L255;
      tmp$_13 = tmp$_11.or(Kotlin.Long.fromInt($receiver_7).and(other_7).shiftLeft(8));
      var $receiver_8 = data[tmp$_12 = pos, pos = tmp$_12 + 1 | 0, tmp$_12];
      var other_8 = L255;
      var v = tmp$_13.or(Kotlin.Long.fromInt($receiver_8).and(other_8));
      this.size = this.size.subtract(L8);
      if (pos === limit) {
        this.head_8be2vx$ = segment.pop();
        package$okio.SegmentPool.recycle_uve4t5$(segment);
      } else {
        segment.pos = pos;
      }
      commonReadLong$result = v;
    }
     while (false);
    return commonReadLong$result;
  };
  Buffer.prototype.readShortLe = function () {
    return reverseBytes(this.readShort());
  };
  Buffer.prototype.readIntLe = function () {
    return reverseBytes_0(this.readInt());
  };
  Buffer.prototype.readLongLe = function () {
    return reverseBytes_1(this.readLong());
  };
  Buffer.prototype.readDecimalLong = function () {
    if (equals(this.size, L0))
      throw new EOFException();
    var value = L0;
    var seen = 0;
    var negative = false;
    var done = false;
    var overflowDigit = OVERFLOW_DIGIT_START;
    do {
      var segment = ensureNotNull(this.head_8be2vx$);
      var data = segment.data;
      var pos = segment.pos;
      var limit = segment.limit;
      while (pos < limit) {
        var b = data[pos];
        if (b >= toByte(48) && b <= toByte(57)) {
          var digit = toByte(48) - b;
          if (value.compareTo_11rb$(OVERFLOW_ZONE) < 0 || (equals(value, OVERFLOW_ZONE) && digit < overflowDigit.toNumber())) {
            var buffer = (new Buffer()).writeDecimalLong_s8cxhz$(value).writeByte_za3lpa$(b);
            if (!negative)
              buffer.readByte();
            throw new NumberFormatException_init('Number too large: ' + buffer.readUtf8());
          }value = value.multiply(L10);
          value = value.add(Kotlin.Long.fromInt(digit));
        } else if (b === toByte(45) && seen === 0) {
          negative = true;
          overflowDigit = overflowDigit.subtract(Kotlin.Long.fromInt(1));
        } else {
          done = true;
          break;
        }
        pos = pos + 1 | 0;
        seen = seen + 1 | 0;
      }
      if (pos === limit) {
        this.head_8be2vx$ = segment.pop();
        package$okio.SegmentPool.recycle_uve4t5$(segment);
      } else {
        segment.pos = pos;
      }
    }
     while (!done && this.head_8be2vx$ != null);
    this.size = this.size.subtract(Kotlin.Long.fromInt(seen));
    var minimumSeen = negative ? 2 : 1;
    if (seen < minimumSeen) {
      if (equals(this.size, L0))
        throw new EOFException();
      var expected = negative ? 'Expected a digit' : "Expected a digit or '-'";
      throw new NumberFormatException_init(expected + ' but was 0x' + toHexString(this.get_s8cxhz$(L0)));
    }return negative ? value : value.unaryMinus();
  };
  Buffer.prototype.readHexadecimalUnsignedLong = function () {
    if (equals(this.size, L0))
      throw new EOFException();
    var value = L0;
    var seen = 0;
    var done = false;
    do {
      var segment = ensureNotNull(this.head_8be2vx$);
      var data = segment.data;
      var pos = segment.pos;
      var limit = segment.limit;
      while (pos < limit) {
        var digit;
        var b = data[pos];
        if (b >= toByte(48) && b <= toByte(57)) {
          digit = b - toByte(48);
        } else if (b >= toByte(97) && b <= toByte(102)) {
          digit = b - toByte(97) + 10 | 0;
        } else if (b >= toByte(65) && b <= toByte(70)) {
          digit = b - toByte(65) + 10 | 0;
        } else {
          if (seen === 0) {
            throw new NumberFormatException_init('Expected leading [0-9a-fA-F] character but was 0x' + toHexString(b));
          }done = true;
          break;
        }
        if (!equals(value.and(L_1152921504606846976), L0)) {
          var buffer = (new Buffer()).writeHexadecimalUnsignedLong_s8cxhz$(value).writeByte_za3lpa$(b);
          throw new NumberFormatException_init('Number too large: ' + buffer.readUtf8());
        }value = value.shiftLeft(4);
        value = value.or(Kotlin.Long.fromInt(digit));
        pos = pos + 1 | 0;
        seen = seen + 1 | 0;
      }
      if (pos === limit) {
        this.head_8be2vx$ = segment.pop();
        package$okio.SegmentPool.recycle_uve4t5$(segment);
      } else {
        segment.pos = pos;
      }
    }
     while (!done && this.head_8be2vx$ != null);
    this.size = this.size.subtract(Kotlin.Long.fromInt(seen));
    return value;
  };
  Buffer.prototype.readByteString = function () {
    return this.readByteString_s8cxhz$(this.size);
  };
  Buffer.prototype.readByteString_s8cxhz$ = function (byteCount) {
    var commonReadByteString$result;
    if (!(byteCount.toNumber() >= 0 && byteCount.toNumber() <= 2147483647)) {
      var message = 'byteCount: ' + byteCount.toString();
      throw IllegalArgumentException_init(message.toString());
    }if (this.size.compareTo_11rb$(byteCount) < 0)
      throw new EOFException();
    if (byteCount.toNumber() >= 4096) {
      var $receiver = this.snapshot_za3lpa$(byteCount.toInt());
      this.skip_s8cxhz$(byteCount);
      commonReadByteString$result = $receiver;
    } else {
      commonReadByteString$result = new ByteString(this.readByteArray_s8cxhz$(byteCount));
    }
    return commonReadByteString$result;
  };
  Buffer.prototype.readFully_u27jpl$ = function (sink, byteCount) {
    if (this.size.compareTo_11rb$(byteCount) < 0) {
      sink.write_u27jpl$(this, this.size);
      throw new EOFException();
    }sink.write_u27jpl$(this, byteCount);
  };
  Buffer.prototype.readAll_awqvbz$ = function (sink) {
    var byteCount = this.size;
    if (byteCount.compareTo_11rb$(L0) > 0) {
      sink.write_u27jpl$(this, byteCount);
    }return byteCount;
  };
  Buffer.prototype.readUtf8 = function () {
    return this.readUtf8_s8cxhz$(this.size);
  };
  Buffer.prototype.readUtf8_s8cxhz$ = function (byteCount) {
    var commonReadUtf8$result;
    commonReadUtf8$break: do {
      if (!(byteCount.toNumber() >= 0 && byteCount.toNumber() <= 2147483647)) {
        var message = 'byteCount: ' + byteCount.toString();
        throw IllegalArgumentException_init(message.toString());
      }if (this.size.compareTo_11rb$(byteCount) < 0)
        throw new EOFException();
      if (equals(byteCount, L0)) {
        commonReadUtf8$result = '';
        break commonReadUtf8$break;
      }var s = ensureNotNull(this.head_8be2vx$);
      if (Kotlin.Long.fromInt(s.pos).add(byteCount).toNumber() > s.limit) {
        commonReadUtf8$result = commonToUtf8String(this.readByteArray_s8cxhz$(byteCount));
        break commonReadUtf8$break;
      }var result = commonToUtf8String(s.data, s.pos, s.pos + byteCount.toInt() | 0);
      s.pos = s.pos + byteCount.toInt() | 0;
      this.size = this.size.subtract(byteCount);
      if (s.pos === s.limit) {
        this.head_8be2vx$ = s.pop();
        package$okio.SegmentPool.recycle_uve4t5$(s);
      }commonReadUtf8$result = result;
    }
     while (false);
    return commonReadUtf8$result;
  };
  Buffer.prototype.readUtf8Line = function () {
    var tmp$;
    var newline = this.indexOf_s8j3t7$(toByte(10));
    if (!equals(newline, L_1))
      tmp$ = readUtf8Line(this, newline);
    else if (!equals(this.size, L0))
      tmp$ = this.readUtf8_s8cxhz$(this.size);
    else
      tmp$ = null;
    return tmp$;
  };
  Buffer.prototype.readUtf8LineStrict = function () {
    return this.readUtf8LineStrict_s8cxhz$(Long$Companion$MAX_VALUE);
  };
  Buffer.prototype.readUtf8LineStrict_s8cxhz$ = function (limit) {
    var commonReadUtf8LineStrict$result;
    commonReadUtf8LineStrict$break: do {
      if (!(limit.compareTo_11rb$(L0) >= 0)) {
        var message = 'limit < 0: ' + limit.toString();
        throw IllegalArgumentException_init(message.toString());
      }var scanLength = equals(limit, Long$Companion$MAX_VALUE) ? Long$Companion$MAX_VALUE : limit.add(L1);
      var newline = this.indexOf_mfonpt$(toByte(10), L0, scanLength);
      if (!equals(newline, L_1)) {
        commonReadUtf8LineStrict$result = readUtf8Line(this, newline);
        break commonReadUtf8LineStrict$break;
      }if (scanLength.compareTo_11rb$(this.size) < 0 && this.get_s8cxhz$(scanLength.subtract(Kotlin.Long.fromInt(1))) === toByte(13) && this.get_s8cxhz$(scanLength) === toByte(10)) {
        commonReadUtf8LineStrict$result = readUtf8Line(this, scanLength);
        break commonReadUtf8LineStrict$break;
      }var data = new Buffer();
      var tmp$ = L0;
      var b = this.size;
      var a = Kotlin.Long.fromInt(32);
      this.copyTo_ins7gm$(data, tmp$, a.compareTo_11rb$(b) <= 0 ? a : b);
      var a_0 = this.size;
      throw new EOFException('\\' + 'n not found: limit=' + (a_0.compareTo_11rb$(limit) <= 0 ? a_0 : limit).toString() + ' content=' + data.readByteString().hex() + String.fromCharCode(8230));
    }
     while (false);
    return commonReadUtf8LineStrict$result;
  };
  Buffer.prototype.readUtf8CodePoint = function () {
    var commonReadUtf8CodePoint$result;
    commonReadUtf8CodePoint$break: do {
      var tmp$, tmp$_0;
      if (equals(this.size, L0))
        throw new EOFException();
      var b0 = this.get_s8cxhz$(L0);
      var codePoint;
      var byteCount;
      var min;
      if ((b0 & 128) === 0) {
        codePoint = b0 & 127;
        byteCount = 1;
        min = 0;
      } else {
        if ((b0 & 224) === 192) {
          codePoint = b0 & 31;
          byteCount = 2;
          min = 128;
        } else {
          if ((b0 & 240) === 224) {
            codePoint = b0 & 15;
            byteCount = 3;
            min = 2048;
          } else {
            if ((b0 & 248) === 240) {
              codePoint = b0 & 7;
              byteCount = 4;
              min = 65536;
            } else {
              this.skip_s8cxhz$(L1);
              commonReadUtf8CodePoint$result = 65533;
              break commonReadUtf8CodePoint$break;
            }
          }
        }
      }
      if (this.size.toNumber() < byteCount) {
        throw new EOFException('size < ' + byteCount + ': ' + this.size.toString() + ' (to read code point prefixed 0x' + toHexString(b0) + ')');
      }tmp$ = byteCount;
      for (var i = 1; i < tmp$; i++) {
        var b = this.get_s8cxhz$(Kotlin.Long.fromInt(i));
        if ((b & 192) === 128) {
          codePoint = codePoint << 6;
          codePoint = codePoint | b & 63;
        } else {
          this.skip_s8cxhz$(Kotlin.Long.fromInt(i));
          commonReadUtf8CodePoint$result = 65533;
          break commonReadUtf8CodePoint$break;
        }
      }
      this.skip_s8cxhz$(Kotlin.Long.fromInt(byteCount));
      if (codePoint > 1114111)
        tmp$_0 = 65533;
      else if (55296 <= codePoint && codePoint <= 57343)
        tmp$_0 = 65533;
      else if (codePoint < min)
        tmp$_0 = 65533;
      else
        tmp$_0 = codePoint;
      commonReadUtf8CodePoint$result = tmp$_0;
    }
     while (false);
    return commonReadUtf8CodePoint$result;
  };
  Buffer.prototype.select_d5ae7i$ = function (options) {
    var commonSelect$result;
    commonSelect$break: do {
      var index = selectPrefix(this, options);
      if (index === -1) {
        commonSelect$result = -1;
        break commonSelect$break;
      }var selectedSize = options.byteStrings_8be2vx$[index].size;
      this.skip_s8cxhz$(Kotlin.Long.fromInt(selectedSize));
      commonSelect$result = index;
    }
     while (false);
    return commonSelect$result;
  };
  Buffer.prototype.readByteArray = function () {
    return this.readByteArray_s8cxhz$(this.size);
  };
  Buffer.prototype.readByteArray_s8cxhz$ = function (byteCount) {
    if (!(byteCount.toNumber() >= 0 && byteCount.toNumber() <= 2147483647)) {
      var message = 'byteCount: ' + byteCount.toString();
      throw IllegalArgumentException_init(message.toString());
    }if (this.size.compareTo_11rb$(byteCount) < 0)
      throw new EOFException();
    var result = new Int8Array(byteCount.toInt());
    this.readFully_fqrh44$(result);
    return result;
  };
  Buffer.prototype.read_fqrh44$ = function (sink) {
    return this.read_mj6st8$(sink, 0, sink.length);
  };
  Buffer.prototype.readFully_fqrh44$ = function (sink) {
    var offset = 0;
    while (offset < sink.length) {
      var read = this.read_mj6st8$(sink, offset, sink.length - offset | 0);
      if (read === -1)
        throw new EOFException();
      offset = offset + read | 0;
    }
  };
  Buffer.prototype.read_mj6st8$ = function (sink, offset, byteCount) {
    var commonRead$result;
    commonRead$break: do {
      var tmp$;
      checkOffsetAndCount(Kotlin.Long.fromInt(sink.length), Kotlin.Long.fromInt(offset), Kotlin.Long.fromInt(byteCount));
      tmp$ = this.head_8be2vx$;
      if (tmp$ == null) {
        commonRead$result = -1;
        break commonRead$break;
      }var s = tmp$;
      var b = s.limit - s.pos | 0;
      var toCopy = JsMath.min(byteCount, b);
      arrayCopy(s.data, sink, offset, s.pos, s.pos + toCopy | 0);
      s.pos = s.pos + toCopy | 0;
      this.size = this.size.subtract(Kotlin.Long.fromInt(toCopy));
      if (s.pos === s.limit) {
        this.head_8be2vx$ = s.pop();
        package$okio.SegmentPool.recycle_uve4t5$(s);
      }commonRead$result = toCopy;
    }
     while (false);
    return commonRead$result;
  };
  Buffer.prototype.clear = function () {
    this.skip_s8cxhz$(this.size);
  };
  Buffer.prototype.skip_s8cxhz$ = function (byteCount) {
    var tmp$;
    var byteCount_0 = byteCount;
    while (byteCount_0.toNumber() > 0) {
      tmp$ = this.head_8be2vx$;
      if (tmp$ == null) {
        throw new EOFException();
      }var head = tmp$;
      var a = byteCount_0;
      var b = Kotlin.Long.fromInt(head.limit - head.pos | 0);
      var toSkip = (a.compareTo_11rb$(b) <= 0 ? a : b).toInt();
      this.size = this.size.subtract(Kotlin.Long.fromInt(toSkip));
      byteCount_0 = byteCount_0.subtract(Kotlin.Long.fromInt(toSkip));
      head.pos = head.pos + toSkip | 0;
      if (head.pos === head.limit) {
        this.head_8be2vx$ = head.pop();
        package$okio.SegmentPool.recycle_uve4t5$(head);
      }}
  };
  Buffer.prototype.write_9ovubf$ = function (byteString) {
    byteString.write_zfhfyk$(this, 0, byteString.size);
    return this;
  };
  Buffer.prototype.write_e1lsqj$ = function (byteString, offset, byteCount) {
    byteString.write_zfhfyk$(this, offset, byteCount);
    return this;
  };
  Buffer.prototype.writableSegment_kcn2v3$ = function (minimumCapacity) {
    var commonWritableSegment$result;
    commonWritableSegment$break: do {
      if (!(minimumCapacity >= 1 && minimumCapacity <= 8192)) {
        var message = 'unexpected capacity';
        throw IllegalArgumentException_init(message.toString());
      }if (this.head_8be2vx$ == null) {
        var result = package$okio.SegmentPool.take();
        this.head_8be2vx$ = result;
        result.prev = result;
        result.next = result;
        commonWritableSegment$result = result;
        break commonWritableSegment$break;
      }var tail = ensureNotNull(this.head_8be2vx$).prev;
      if ((ensureNotNull(tail).limit + minimumCapacity | 0) > 8192 || !tail.owner) {
        tail = tail.push_uve4t5$(package$okio.SegmentPool.take());
      }commonWritableSegment$result = tail;
    }
     while (false);
    return commonWritableSegment$result;
  };
  Buffer.prototype.writeUtf8_61zpoe$ = function (string) {
    return this.writeUtf8_3m52m6$(string, 0, string.length);
  };
  Buffer.prototype.writeUtf8_3m52m6$ = function (string, beginIndex, endIndex) {
    var tmp$, tmp$_0;
    if (!(beginIndex >= 0)) {
      var message = 'beginIndex < 0: ' + beginIndex;
      throw IllegalArgumentException_init(message.toString());
    }if (!(endIndex >= beginIndex)) {
      var message_0 = 'endIndex < beginIndex: ' + endIndex + ' < ' + beginIndex;
      throw IllegalArgumentException_init(message_0.toString());
    }if (!(endIndex <= string.length)) {
      var message_1 = 'endIndex > string.length: ' + endIndex + ' > ' + string.length;
      throw IllegalArgumentException_init(message_1.toString());
    }var i = beginIndex;
    while (i < endIndex) {
      var c = string.charCodeAt(i) | 0;
      if (c < 128) {
        var tail = this.writableSegment_kcn2v3$(1);
        var data = tail.data;
        var segmentOffset = tail.limit - i | 0;
        var b = 8192 - segmentOffset | 0;
        var runLimit = JsMath.min(endIndex, b);
        data[segmentOffset + (tmp$ = i, i = tmp$ + 1 | 0, tmp$) | 0] = toByte(c);
        while (i < runLimit) {
          c = string.charCodeAt(i) | 0;
          if (c >= 128)
            break;
          data[segmentOffset + (tmp$_0 = i, i = tmp$_0 + 1 | 0, tmp$_0) | 0] = toByte(c);
        }
        var runSize = i + segmentOffset - tail.limit | 0;
        tail.limit = tail.limit + runSize | 0;
        this.size = this.size.add(Kotlin.Long.fromInt(runSize));
      } else if (c < 2048) {
        var tail_0 = this.writableSegment_kcn2v3$(2);
        tail_0.data[tail_0.limit] = toByte(c >> 6 | 192);
        tail_0.data[tail_0.limit + 1 | 0] = toByte(c & 63 | 128);
        tail_0.limit = tail_0.limit + 2 | 0;
        this.size = this.size.add(L2);
        i = i + 1 | 0;
      } else if (c < 55296 || c > 57343) {
        var tail_1 = this.writableSegment_kcn2v3$(3);
        tail_1.data[tail_1.limit] = toByte(c >> 12 | 224);
        tail_1.data[tail_1.limit + 1 | 0] = toByte(c >> 6 & 63 | 128);
        tail_1.data[tail_1.limit + 2 | 0] = toByte(c & 63 | 128);
        tail_1.limit = tail_1.limit + 3 | 0;
        this.size = this.size.add(L3);
        i = i + 1 | 0;
      } else {
        var low = (i + 1 | 0) < endIndex ? string.charCodeAt(i + 1 | 0) | 0 : 0;
        if (c > 56319 || !(56320 <= low && low <= 57343)) {
          this.writeByte_za3lpa$(63);
          i = i + 1 | 0;
        } else {
          var codePoint = 65536 + ((c & 1023) << 10 | low & 1023) | 0;
          var tail_2 = this.writableSegment_kcn2v3$(4);
          tail_2.data[tail_2.limit] = toByte(codePoint >> 18 | 240);
          tail_2.data[tail_2.limit + 1 | 0] = toByte(codePoint >> 12 & 63 | 128);
          tail_2.data[tail_2.limit + 2 | 0] = toByte(codePoint >> 6 & 63 | 128);
          tail_2.data[tail_2.limit + 3 | 0] = toByte(codePoint & 63 | 128);
          tail_2.limit = tail_2.limit + 4 | 0;
          this.size = this.size.add(L4);
          i = i + 2 | 0;
        }
      }
    }
    return this;
  };
  Buffer.prototype.writeUtf8CodePoint_za3lpa$ = function (codePoint) {
    if (codePoint < 128)
      this.writeByte_za3lpa$(codePoint);
    else if (codePoint < 2048) {
      var tail = this.writableSegment_kcn2v3$(2);
      tail.data[tail.limit] = toByte(codePoint >> 6 | 192);
      tail.data[tail.limit + 1 | 0] = toByte(codePoint & 63 | 128);
      tail.limit = tail.limit + 2 | 0;
      this.size = this.size.add(L2);
    } else if (55296 <= codePoint && codePoint <= 57343)
      this.writeByte_za3lpa$(63);
    else if (codePoint < 65536) {
      var tail_0 = this.writableSegment_kcn2v3$(3);
      tail_0.data[tail_0.limit] = toByte(codePoint >> 12 | 224);
      tail_0.data[tail_0.limit + 1 | 0] = toByte(codePoint >> 6 & 63 | 128);
      tail_0.data[tail_0.limit + 2 | 0] = toByte(codePoint & 63 | 128);
      tail_0.limit = tail_0.limit + 3 | 0;
      this.size = this.size.add(L3);
    } else if (codePoint <= 1114111) {
      var tail_1 = this.writableSegment_kcn2v3$(4);
      tail_1.data[tail_1.limit] = toByte(codePoint >> 18 | 240);
      tail_1.data[tail_1.limit + 1 | 0] = toByte(codePoint >> 12 & 63 | 128);
      tail_1.data[tail_1.limit + 2 | 0] = toByte(codePoint >> 6 & 63 | 128);
      tail_1.data[tail_1.limit + 3 | 0] = toByte(codePoint & 63 | 128);
      tail_1.limit = tail_1.limit + 4 | 0;
      this.size = this.size.add(L4);
    } else {
      throw IllegalArgumentException_init('Unexpected code point: 0x' + toHexString_0(codePoint));
    }
    return this;
  };
  Buffer.prototype.write_fqrh44$ = function (source) {
    return this.write_mj6st8$(source, 0, source.length);
  };
  Buffer.prototype.write_mj6st8$ = function (source, offset, byteCount) {
    var offset_0 = offset;
    checkOffsetAndCount(Kotlin.Long.fromInt(source.length), Kotlin.Long.fromInt(offset_0), Kotlin.Long.fromInt(byteCount));
    var limit = offset_0 + byteCount | 0;
    while (offset_0 < limit) {
      var tail = this.writableSegment_kcn2v3$(1);
      var a = limit - offset_0 | 0;
      var b = 8192 - tail.limit | 0;
      var toCopy = JsMath.min(a, b);
      arrayCopy(source, tail.data, tail.limit, offset_0, offset_0 + toCopy | 0);
      offset_0 = offset_0 + toCopy | 0;
      tail.limit = tail.limit + toCopy | 0;
    }
    this.size = this.size.add(Kotlin.Long.fromInt(byteCount));
    return this;
  };
  Buffer.prototype.writeAll_sby9nd$ = function (source) {
    var totalBytesRead = L0;
    while (true) {
      var readCount = source.read_u27jpl$(this, L8192);
      if (equals(readCount, L_1))
        break;
      totalBytesRead = totalBytesRead.add(readCount);
    }
    return totalBytesRead;
  };
  Buffer.prototype.write_9ujt9g$ = function (source, byteCount) {
    var byteCount_0 = byteCount;
    while (byteCount_0.compareTo_11rb$(L0) > 0) {
      var read = source.read_u27jpl$(this, byteCount_0);
      if (equals(read, L_1))
        throw new EOFException();
      byteCount_0 = byteCount_0.subtract(read);
    }
    return this;
  };
  Buffer.prototype.writeByte_za3lpa$ = function (b) {
    var tmp$;
    var tail = this.writableSegment_kcn2v3$(1);
    tail.data[tmp$ = tail.limit, tail.limit = tmp$ + 1 | 0, tmp$] = toByte(b);
    this.size = this.size.add(L1);
    return this;
  };
  Buffer.prototype.writeShort_za3lpa$ = function (s) {
    var tmp$, tmp$_0;
    var tail = this.writableSegment_kcn2v3$(2);
    var data = tail.data;
    var limit = tail.limit;
    data[tmp$ = limit, limit = tmp$ + 1 | 0, tmp$] = toByte(s >>> 8 & 255);
    data[tmp$_0 = limit, limit = tmp$_0 + 1 | 0, tmp$_0] = toByte(s & 255);
    tail.limit = limit;
    this.size = this.size.add(L2);
    return this;
  };
  Buffer.prototype.writeShortLe_za3lpa$ = function (s) {
    return this.writeShort_za3lpa$(reverseBytes(toShort(s)));
  };
  Buffer.prototype.writeInt_za3lpa$ = function (i) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var tail = this.writableSegment_kcn2v3$(4);
    var data = tail.data;
    var limit = tail.limit;
    data[tmp$ = limit, limit = tmp$ + 1 | 0, tmp$] = toByte(i >>> 24 & 255);
    data[tmp$_0 = limit, limit = tmp$_0 + 1 | 0, tmp$_0] = toByte(i >>> 16 & 255);
    data[tmp$_1 = limit, limit = tmp$_1 + 1 | 0, tmp$_1] = toByte(i >>> 8 & 255);
    data[tmp$_2 = limit, limit = tmp$_2 + 1 | 0, tmp$_2] = toByte(i & 255);
    tail.limit = limit;
    this.size = this.size.add(L4);
    return this;
  };
  Buffer.prototype.writeIntLe_za3lpa$ = function (i) {
    return this.writeInt_za3lpa$(reverseBytes_0(i));
  };
  Buffer.prototype.writeLong_s8cxhz$ = function (v) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6;
    var tail = this.writableSegment_kcn2v3$(8);
    var data = tail.data;
    var limit = tail.limit;
    data[tmp$ = limit, limit = tmp$ + 1 | 0, tmp$] = toByte(v.shiftRightUnsigned(56).and(L255).toInt());
    data[tmp$_0 = limit, limit = tmp$_0 + 1 | 0, tmp$_0] = toByte(v.shiftRightUnsigned(48).and(L255).toInt());
    data[tmp$_1 = limit, limit = tmp$_1 + 1 | 0, tmp$_1] = toByte(v.shiftRightUnsigned(40).and(L255).toInt());
    data[tmp$_2 = limit, limit = tmp$_2 + 1 | 0, tmp$_2] = toByte(v.shiftRightUnsigned(32).and(L255).toInt());
    data[tmp$_3 = limit, limit = tmp$_3 + 1 | 0, tmp$_3] = toByte(v.shiftRightUnsigned(24).and(L255).toInt());
    data[tmp$_4 = limit, limit = tmp$_4 + 1 | 0, tmp$_4] = toByte(v.shiftRightUnsigned(16).and(L255).toInt());
    data[tmp$_5 = limit, limit = tmp$_5 + 1 | 0, tmp$_5] = toByte(v.shiftRightUnsigned(8).and(L255).toInt());
    data[tmp$_6 = limit, limit = tmp$_6 + 1 | 0, tmp$_6] = toByte(v.and(L255).toInt());
    tail.limit = limit;
    this.size = this.size.add(L8);
    return this;
  };
  Buffer.prototype.writeLongLe_s8cxhz$ = function (v) {
    return this.writeLong_s8cxhz$(reverseBytes_1(v));
  };
  Buffer.prototype.writeDecimalLong_s8cxhz$ = function (v) {
    var commonWriteDecimalLong$result;
    commonWriteDecimalLong$break: do {
      var v_0 = v;
      if (equals(v_0, L0)) {
        commonWriteDecimalLong$result = this.writeByte_za3lpa$(48);
        break commonWriteDecimalLong$break;
      }var negative = false;
      if (v_0.compareTo_11rb$(L0) < 0) {
        v_0 = v_0.unaryMinus();
        if (v_0.compareTo_11rb$(L0) < 0) {
          commonWriteDecimalLong$result = this.writeUtf8_61zpoe$('-9223372036854775808');
          break commonWriteDecimalLong$break;
        }negative = true;
      }var width = v_0.compareTo_11rb$(L100000000) < 0 ? v_0.compareTo_11rb$(L10000) < 0 ? v_0.compareTo_11rb$(L100) < 0 ? v_0.compareTo_11rb$(L10) < 0 ? 1 : 2 : v_0.compareTo_11rb$(L1000) < 0 ? 3 : 4 : v_0.compareTo_11rb$(L1000000) < 0 ? v_0.compareTo_11rb$(L100000) < 0 ? 5 : 6 : v_0.compareTo_11rb$(L10000000) < 0 ? 7 : 8 : v_0.compareTo_11rb$(L1000000000000) < 0 ? v_0.compareTo_11rb$(L10000000000) < 0 ? v_0.compareTo_11rb$(L1000000000) < 0 ? 9 : 10 : v_0.compareTo_11rb$(L100000000000) < 0 ? 11 : 12 : v_0.compareTo_11rb$(L1000000000000000) < 0 ? v_0.compareTo_11rb$(L10000000000000) < 0 ? 13 : v_0.compareTo_11rb$(L100000000000000) < 0 ? 14 : 15 : v_0.compareTo_11rb$(L100000000000000000) < 0 ? v_0.compareTo_11rb$(L10000000000000000) < 0 ? 16 : 17 : v_0.compareTo_11rb$(L1000000000000000000) < 0 ? 18 : 19;
      if (negative) {
        width = width + 1 | 0;
      }var tail = this.writableSegment_kcn2v3$(width);
      var data = tail.data;
      var pos = tail.limit + width | 0;
      while (!equals(v_0, L0)) {
        var digit = v_0.modulo(Kotlin.Long.fromInt(10)).toInt();
        data[pos = pos - 1 | 0, pos] = package$internal.HEX_DIGIT_BYTES_8be2vx$[digit];
        v_0 = v_0.div(Kotlin.Long.fromInt(10));
      }
      if (negative) {
        data[pos = pos - 1 | 0, pos] = toByte(45);
      }tail.limit = tail.limit + width | 0;
      this.size = this.size.add(Kotlin.Long.fromInt(width));
      commonWriteDecimalLong$result = this;
    }
     while (false);
    return commonWriteDecimalLong$result;
  };
  Buffer.prototype.writeHexadecimalUnsignedLong_s8cxhz$ = function (v) {
    var commonWriteHexadecimalUnsignedLong$result;
    commonWriteHexadecimalUnsignedLong$break: do {
      var v_0 = v;
      if (equals(v_0, L0)) {
        commonWriteHexadecimalUnsignedLong$result = this.writeByte_za3lpa$(48);
        break commonWriteHexadecimalUnsignedLong$break;
      }var x = v_0;
      x = x.or(x.shiftRightUnsigned(1));
      x = x.or(x.shiftRightUnsigned(2));
      x = x.or(x.shiftRightUnsigned(4));
      x = x.or(x.shiftRightUnsigned(8));
      x = x.or(x.shiftRightUnsigned(16));
      x = x.or(x.shiftRightUnsigned(32));
      x = x.subtract(x.shiftRightUnsigned(1).and(L6148914691236517205));
      x = x.shiftRightUnsigned(2).and(L3689348814741910323).add(x.and(L3689348814741910323));
      x = x.shiftRightUnsigned(4).add(x).and(L1085102592571150095);
      x = x.add(x.shiftRightUnsigned(8));
      x = x.add(x.shiftRightUnsigned(16));
      x = x.and(L63).add(x.shiftRightUnsigned(32).and(L63));
      var width = x.add(Kotlin.Long.fromInt(3)).div(Kotlin.Long.fromInt(4)).toInt();
      var tail = this.writableSegment_kcn2v3$(width);
      var data = tail.data;
      var pos = tail.limit + width - 1 | 0;
      var start = tail.limit;
      while (pos >= start) {
        data[pos] = package$internal.HEX_DIGIT_BYTES_8be2vx$[v_0.and(L15).toInt()];
        v_0 = v_0.shiftRightUnsigned(4);
        pos = pos - 1 | 0;
      }
      tail.limit = tail.limit + width | 0;
      this.size = this.size.add(Kotlin.Long.fromInt(width));
      commonWriteHexadecimalUnsignedLong$result = this;
    }
     while (false);
    return commonWriteHexadecimalUnsignedLong$result;
  };
  Buffer.prototype.write_u27jpl$ = function (source, byteCount) {
    commonWrite$break: do {
      var byteCount_0 = byteCount;
      if (!(source !== this)) {
        var message = 'source == this';
        throw IllegalArgumentException_init(message.toString());
      }checkOffsetAndCount(source.size, L0, byteCount_0);
      while (byteCount_0.compareTo_11rb$(L0) > 0) {
        if (byteCount_0.toNumber() < (ensureNotNull(source.head_8be2vx$).limit - ensureNotNull(source.head_8be2vx$).pos | 0)) {
          var tail = this.head_8be2vx$ != null ? ensureNotNull(this.head_8be2vx$).prev : null;
          if (tail != null && tail.owner && byteCount_0.add(Kotlin.Long.fromInt(tail.limit)).subtract(Kotlin.Long.fromInt(tail.shared ? 0 : tail.pos)).toNumber() <= 8192) {
            ensureNotNull(source.head_8be2vx$).writeTo_l53ny1$(tail, byteCount_0.toInt());
            source.size = source.size.subtract(byteCount_0);
            this.size = this.size.add(byteCount_0);
            break commonWrite$break;
          } else {
            source.head_8be2vx$ = ensureNotNull(source.head_8be2vx$).split_za3lpa$(byteCount_0.toInt());
          }
        }var segmentToMove = source.head_8be2vx$;
        var movedByteCount = Kotlin.Long.fromInt(ensureNotNull(segmentToMove).limit - segmentToMove.pos | 0);
        source.head_8be2vx$ = segmentToMove.pop();
        if (this.head_8be2vx$ == null) {
          this.head_8be2vx$ = segmentToMove;
          segmentToMove.prev = segmentToMove;
          segmentToMove.next = segmentToMove.prev;
        } else {
          var tail_0 = ensureNotNull(this.head_8be2vx$).prev;
          tail_0 = ensureNotNull(tail_0).push_uve4t5$(segmentToMove);
          tail_0.compact();
        }
        source.size = source.size.subtract(movedByteCount);
        this.size = this.size.add(movedByteCount);
        byteCount_0 = byteCount_0.subtract(movedByteCount);
      }
    }
     while (false);
  };
  Buffer.prototype.read_u27jpl$ = function (sink, byteCount) {
    var commonRead$result;
    commonRead$break: do {
      var byteCount_0 = {v: byteCount};
      if (!(byteCount_0.v.compareTo_11rb$(L0) >= 0)) {
        var message = 'byteCount < 0: ' + byteCount_0.v.toString();
        throw IllegalArgumentException_init(message.toString());
      }if (equals(this.size, L0)) {
        commonRead$result = L_1;
        break commonRead$break;
      }if (byteCount_0.v.compareTo_11rb$(this.size) > 0)
        byteCount_0.v = this.size;
      sink.write_u27jpl$(this, byteCount_0.v);
      commonRead$result = byteCount_0.v;
    }
     while (false);
    return commonRead$result;
  };
  Buffer.prototype.indexOf_s8j3t7$ = function (b) {
    return this.indexOf_mfonpt$(b, L0, Long$Companion$MAX_VALUE);
  };
  Buffer.prototype.indexOf_5gjupe$ = function (b, fromIndex) {
    return this.indexOf_mfonpt$(b, fromIndex, Long$Companion$MAX_VALUE);
  };
  Buffer.prototype.indexOf_mfonpt$ = function (b, fromIndex, toIndex) {
    var commonIndexOf$result;
    commonIndexOf$break: do {
      var fromIndex_0 = {v: fromIndex};
      var toIndex_0 = {v: toIndex};
      if (!Kotlin.Long.fromInt(0).rangeTo(toIndex_0.v).contains_mef7kx$(fromIndex_0.v)) {
        var message = 'size=' + this.size.toString() + ' fromIndex=' + fromIndex_0.v.toString() + ' toIndex=' + toIndex_0.v.toString();
        throw IllegalArgumentException_init(message.toString());
      }if (toIndex_0.v.compareTo_11rb$(this.size) > 0)
        toIndex_0.v = this.size;
      if (equals(fromIndex_0.v, toIndex_0.v)) {
        commonIndexOf$result = L_1;
        break commonIndexOf$break;
      }var fromIndex_1 = fromIndex_0.v;
      var tmp$;
      tmp$ = this.head_8be2vx$;
      if (tmp$ == null) {
        var offset = L_1;
        if (null == null) {
          commonIndexOf$result = L_1;
          break commonIndexOf$break;
        }var s = null;
        var offset_0 = offset;
        while (offset_0.compareTo_11rb$(toIndex_0.v) < 0) {
          var data = s.data;
          var a = Kotlin.Long.fromInt(s.limit);
          var b_0 = Kotlin.Long.fromInt(s.pos).add(toIndex_0.v).subtract(offset_0);
          var limit = (a.compareTo_11rb$(b_0) <= 0 ? a : b_0).toInt();
          var pos = Kotlin.Long.fromInt(s.pos).add(fromIndex_0.v).subtract(offset_0).toInt();
          while (pos < limit) {
            if (data[pos] === b) {
              commonIndexOf$result = Kotlin.Long.fromInt(pos - s.pos | 0).add(offset_0);
              break commonIndexOf$break;
            }pos = pos + 1 | 0;
          }
          offset_0 = offset_0.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
          fromIndex_0.v = offset_0;
          s = ensureNotNull(s.next);
        }
        commonIndexOf$result = L_1;
        break commonIndexOf$break;
      }var s_0 = tmp$;
      if (this.size.subtract(fromIndex_1).compareTo_11rb$(fromIndex_1) < 0) {
        var offset_1 = this.size;
        while (offset_1.compareTo_11rb$(fromIndex_1) > 0) {
          s_0 = ensureNotNull(s_0.prev);
          offset_1 = offset_1.subtract(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
        }
        var s_1 = s_0;
        var offset_2 = offset_1;
        if (s_1 == null) {
          commonIndexOf$result = L_1;
          break commonIndexOf$break;
        }var s_2 = s_1;
        var offset_3 = offset_2;
        while (offset_3.compareTo_11rb$(toIndex_0.v) < 0) {
          var data_0 = s_2.data;
          var a_0 = Kotlin.Long.fromInt(s_2.limit);
          var b_1 = Kotlin.Long.fromInt(s_2.pos).add(toIndex_0.v).subtract(offset_3);
          var limit_0 = (a_0.compareTo_11rb$(b_1) <= 0 ? a_0 : b_1).toInt();
          var pos_0 = Kotlin.Long.fromInt(s_2.pos).add(fromIndex_0.v).subtract(offset_3).toInt();
          while (pos_0 < limit_0) {
            if (data_0[pos_0] === b) {
              commonIndexOf$result = Kotlin.Long.fromInt(pos_0 - s_2.pos | 0).add(offset_3);
              break commonIndexOf$break;
            }pos_0 = pos_0 + 1 | 0;
          }
          offset_3 = offset_3.add(Kotlin.Long.fromInt(s_2.limit - s_2.pos | 0));
          fromIndex_0.v = offset_3;
          s_2 = ensureNotNull(s_2.next);
        }
        commonIndexOf$result = L_1;
      } else {
        var offset_4 = L0;
        while (true) {
          var nextOffset = offset_4.add(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
          if (nextOffset.compareTo_11rb$(fromIndex_1) > 0)
            break;
          s_0 = ensureNotNull(s_0.next);
          offset_4 = nextOffset;
        }
        var s_3 = s_0;
        var offset_5 = offset_4;
        if (s_3 == null) {
          commonIndexOf$result = L_1;
          break commonIndexOf$break;
        }var s_4 = s_3;
        var offset_6 = offset_5;
        while (offset_6.compareTo_11rb$(toIndex_0.v) < 0) {
          var data_1 = s_4.data;
          var a_1 = Kotlin.Long.fromInt(s_4.limit);
          var b_2 = Kotlin.Long.fromInt(s_4.pos).add(toIndex_0.v).subtract(offset_6);
          var limit_1 = (a_1.compareTo_11rb$(b_2) <= 0 ? a_1 : b_2).toInt();
          var pos_1 = Kotlin.Long.fromInt(s_4.pos).add(fromIndex_0.v).subtract(offset_6).toInt();
          while (pos_1 < limit_1) {
            if (data_1[pos_1] === b) {
              commonIndexOf$result = Kotlin.Long.fromInt(pos_1 - s_4.pos | 0).add(offset_6);
              break commonIndexOf$break;
            }pos_1 = pos_1 + 1 | 0;
          }
          offset_6 = offset_6.add(Kotlin.Long.fromInt(s_4.limit - s_4.pos | 0));
          fromIndex_0.v = offset_6;
          s_4 = ensureNotNull(s_4.next);
        }
        commonIndexOf$result = L_1;
      }
    }
     while (false);
    return commonIndexOf$result;
  };
  Buffer.prototype.indexOf_9ovubf$ = function (bytes) {
    return this.indexOf_kvuuwu$(bytes, L0);
  };
  Buffer.prototype.indexOf_kvuuwu$ = function (bytes, fromIndex) {
    var commonIndexOf$result;
    commonIndexOf$break: do {
      var fromIndex_0 = {v: fromIndex};
      if (!(bytes.size > 0)) {
        var message = 'bytes is empty';
        throw IllegalArgumentException_init(message.toString());
      }if (!(fromIndex_0.v.compareTo_11rb$(L0) >= 0)) {
        var message_0 = 'fromIndex < 0: ' + fromIndex_0.v.toString();
        throw IllegalArgumentException_init(message_0.toString());
      }var fromIndex_1 = fromIndex_0.v;
      var tmp$;
      tmp$ = this.head_8be2vx$;
      if (tmp$ == null) {
        var offset = L_1;
        if (null == null) {
          commonIndexOf$result = L_1;
          break commonIndexOf$break;
        }var s = null;
        var offset_0 = offset;
        var targetByteArray = bytes.internalArray();
        var b0 = targetByteArray[0];
        var bytesSize = bytes.size;
        var resultLimit = this.size.subtract(Kotlin.Long.fromInt(bytesSize)).add(L1);
        while (offset_0.compareTo_11rb$(resultLimit) < 0) {
          var data = s.data;
          var a = s.limit;
          var b = Kotlin.Long.fromInt(s.pos).add(resultLimit).subtract(offset_0);
          var a_0 = Kotlin.Long.fromInt(a);
          var segmentLimit = (a_0.compareTo_11rb$(b) <= 0 ? a_0 : b).toInt();
          for (var pos = Kotlin.Long.fromInt(s.pos).add(fromIndex_0.v).subtract(offset_0).toInt(); pos < segmentLimit; pos++) {
            if (data[pos] === b0 && rangeEquals(s, pos + 1 | 0, targetByteArray, 1, bytesSize)) {
              commonIndexOf$result = Kotlin.Long.fromInt(pos - s.pos | 0).add(offset_0);
              break commonIndexOf$break;
            }}
          offset_0 = offset_0.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
          fromIndex_0.v = offset_0;
          s = ensureNotNull(s.next);
        }
        commonIndexOf$result = L_1;
        break commonIndexOf$break;
      }var s_0 = tmp$;
      if (this.size.subtract(fromIndex_1).compareTo_11rb$(fromIndex_1) < 0) {
        var offset_1 = this.size;
        while (offset_1.compareTo_11rb$(fromIndex_1) > 0) {
          s_0 = ensureNotNull(s_0.prev);
          offset_1 = offset_1.subtract(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
        }
        var s_1 = s_0;
        var offset_2 = offset_1;
        if (s_1 == null) {
          commonIndexOf$result = L_1;
          break commonIndexOf$break;
        }var s_2 = s_1;
        var offset_3 = offset_2;
        var targetByteArray_0 = bytes.internalArray();
        var b0_0 = targetByteArray_0[0];
        var bytesSize_0 = bytes.size;
        var resultLimit_0 = this.size.subtract(Kotlin.Long.fromInt(bytesSize_0)).add(L1);
        while (offset_3.compareTo_11rb$(resultLimit_0) < 0) {
          var data_0 = s_2.data;
          var a_1 = s_2.limit;
          var b_0 = Kotlin.Long.fromInt(s_2.pos).add(resultLimit_0).subtract(offset_3);
          var a_2 = Kotlin.Long.fromInt(a_1);
          var segmentLimit_0 = (a_2.compareTo_11rb$(b_0) <= 0 ? a_2 : b_0).toInt();
          for (var pos_0 = Kotlin.Long.fromInt(s_2.pos).add(fromIndex_0.v).subtract(offset_3).toInt(); pos_0 < segmentLimit_0; pos_0++) {
            if (data_0[pos_0] === b0_0 && rangeEquals(s_2, pos_0 + 1 | 0, targetByteArray_0, 1, bytesSize_0)) {
              commonIndexOf$result = Kotlin.Long.fromInt(pos_0 - s_2.pos | 0).add(offset_3);
              break commonIndexOf$break;
            }}
          offset_3 = offset_3.add(Kotlin.Long.fromInt(s_2.limit - s_2.pos | 0));
          fromIndex_0.v = offset_3;
          s_2 = ensureNotNull(s_2.next);
        }
        commonIndexOf$result = L_1;
      } else {
        var offset_4 = L0;
        while (true) {
          var nextOffset = offset_4.add(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
          if (nextOffset.compareTo_11rb$(fromIndex_1) > 0)
            break;
          s_0 = ensureNotNull(s_0.next);
          offset_4 = nextOffset;
        }
        var s_3 = s_0;
        var offset_5 = offset_4;
        if (s_3 == null) {
          commonIndexOf$result = L_1;
          break commonIndexOf$break;
        }var s_4 = s_3;
        var offset_6 = offset_5;
        var targetByteArray_1 = bytes.internalArray();
        var b0_1 = targetByteArray_1[0];
        var bytesSize_1 = bytes.size;
        var resultLimit_1 = this.size.subtract(Kotlin.Long.fromInt(bytesSize_1)).add(L1);
        while (offset_6.compareTo_11rb$(resultLimit_1) < 0) {
          var data_1 = s_4.data;
          var a_3 = s_4.limit;
          var b_1 = Kotlin.Long.fromInt(s_4.pos).add(resultLimit_1).subtract(offset_6);
          var a_4 = Kotlin.Long.fromInt(a_3);
          var segmentLimit_1 = (a_4.compareTo_11rb$(b_1) <= 0 ? a_4 : b_1).toInt();
          for (var pos_1 = Kotlin.Long.fromInt(s_4.pos).add(fromIndex_0.v).subtract(offset_6).toInt(); pos_1 < segmentLimit_1; pos_1++) {
            if (data_1[pos_1] === b0_1 && rangeEquals(s_4, pos_1 + 1 | 0, targetByteArray_1, 1, bytesSize_1)) {
              commonIndexOf$result = Kotlin.Long.fromInt(pos_1 - s_4.pos | 0).add(offset_6);
              break commonIndexOf$break;
            }}
          offset_6 = offset_6.add(Kotlin.Long.fromInt(s_4.limit - s_4.pos | 0));
          fromIndex_0.v = offset_6;
          s_4 = ensureNotNull(s_4.next);
        }
        commonIndexOf$result = L_1;
      }
    }
     while (false);
    return commonIndexOf$result;
  };
  Buffer.prototype.indexOfElement_9ovubf$ = function (targetBytes) {
    return this.indexOfElement_kvuuwu$(targetBytes, L0);
  };
  Buffer.prototype.indexOfElement_kvuuwu$ = function (targetBytes, fromIndex) {
    var commonIndexOfElement$result;
    commonIndexOfElement$break: do {
      var fromIndex_0 = {v: fromIndex};
      if (!(fromIndex_0.v.compareTo_11rb$(L0) >= 0)) {
        var message = 'fromIndex < 0: ' + fromIndex_0.v.toString();
        throw IllegalArgumentException_init(message.toString());
      }var fromIndex_1 = fromIndex_0.v;
      var tmp$;
      tmp$ = this.head_8be2vx$;
      if (tmp$ == null) {
        var offset = L_1;
        var tmp$_0;
        if (null == null) {
          commonIndexOfElement$result = L_1;
          break commonIndexOfElement$break;
        }var s = null;
        var offset_0 = offset;
        if (targetBytes.size === 2) {
          var b0 = targetBytes.get_za3lpa$(0);
          var b1 = targetBytes.get_za3lpa$(1);
          while (offset_0.compareTo_11rb$(this.size) < 0) {
            var data = s.data;
            var pos = Kotlin.Long.fromInt(s.pos).add(fromIndex_0.v).subtract(offset_0).toInt();
            var limit = s.limit;
            while (pos < limit) {
              var b = data[pos];
              if (b === b0 || b === b1) {
                commonIndexOfElement$result = Kotlin.Long.fromInt(pos - s.pos | 0).add(offset_0);
                break commonIndexOfElement$break;
              }pos = pos + 1 | 0;
            }
            offset_0 = offset_0.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
            fromIndex_0.v = offset_0;
            s = ensureNotNull(s.next);
          }
        } else {
          var targetByteArray = targetBytes.internalArray();
          while (offset_0.compareTo_11rb$(this.size) < 0) {
            var data_0 = s.data;
            var pos_0 = Kotlin.Long.fromInt(s.pos).add(fromIndex_0.v).subtract(offset_0).toInt();
            var limit_0 = s.limit;
            while (pos_0 < limit_0) {
              var b_0 = data_0[pos_0];
              for (tmp$_0 = 0; tmp$_0 !== targetByteArray.length; ++tmp$_0) {
                var t = targetByteArray[tmp$_0];
                if (b_0 === t) {
                  commonIndexOfElement$result = Kotlin.Long.fromInt(pos_0 - s.pos | 0).add(offset_0);
                  break commonIndexOfElement$break;
                }}
              pos_0 = pos_0 + 1 | 0;
            }
            offset_0 = offset_0.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
            fromIndex_0.v = offset_0;
            s = ensureNotNull(s.next);
          }
        }
        commonIndexOfElement$result = L_1;
        break commonIndexOfElement$break;
      }var s_0 = tmp$;
      if (this.size.subtract(fromIndex_1).compareTo_11rb$(fromIndex_1) < 0) {
        var offset_1 = this.size;
        while (offset_1.compareTo_11rb$(fromIndex_1) > 0) {
          s_0 = ensureNotNull(s_0.prev);
          offset_1 = offset_1.subtract(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
        }
        var s_1 = s_0;
        var offset_2 = offset_1;
        var tmp$_1;
        if (s_1 == null) {
          commonIndexOfElement$result = L_1;
          break commonIndexOfElement$break;
        }var s_2 = s_1;
        var offset_3 = offset_2;
        if (targetBytes.size === 2) {
          var b0_0 = targetBytes.get_za3lpa$(0);
          var b1_0 = targetBytes.get_za3lpa$(1);
          while (offset_3.compareTo_11rb$(this.size) < 0) {
            var data_1 = s_2.data;
            var pos_1 = Kotlin.Long.fromInt(s_2.pos).add(fromIndex_0.v).subtract(offset_3).toInt();
            var limit_1 = s_2.limit;
            while (pos_1 < limit_1) {
              var b_1 = data_1[pos_1];
              if (b_1 === b0_0 || b_1 === b1_0) {
                commonIndexOfElement$result = Kotlin.Long.fromInt(pos_1 - s_2.pos | 0).add(offset_3);
                break commonIndexOfElement$break;
              }pos_1 = pos_1 + 1 | 0;
            }
            offset_3 = offset_3.add(Kotlin.Long.fromInt(s_2.limit - s_2.pos | 0));
            fromIndex_0.v = offset_3;
            s_2 = ensureNotNull(s_2.next);
          }
        } else {
          var targetByteArray_0 = targetBytes.internalArray();
          while (offset_3.compareTo_11rb$(this.size) < 0) {
            var data_2 = s_2.data;
            var pos_2 = Kotlin.Long.fromInt(s_2.pos).add(fromIndex_0.v).subtract(offset_3).toInt();
            var limit_2 = s_2.limit;
            while (pos_2 < limit_2) {
              var b_2 = data_2[pos_2];
              for (tmp$_1 = 0; tmp$_1 !== targetByteArray_0.length; ++tmp$_1) {
                var t_0 = targetByteArray_0[tmp$_1];
                if (b_2 === t_0) {
                  commonIndexOfElement$result = Kotlin.Long.fromInt(pos_2 - s_2.pos | 0).add(offset_3);
                  break commonIndexOfElement$break;
                }}
              pos_2 = pos_2 + 1 | 0;
            }
            offset_3 = offset_3.add(Kotlin.Long.fromInt(s_2.limit - s_2.pos | 0));
            fromIndex_0.v = offset_3;
            s_2 = ensureNotNull(s_2.next);
          }
        }
        commonIndexOfElement$result = L_1;
      } else {
        var offset_4 = L0;
        while (true) {
          var nextOffset = offset_4.add(Kotlin.Long.fromInt(s_0.limit - s_0.pos | 0));
          if (nextOffset.compareTo_11rb$(fromIndex_1) > 0)
            break;
          s_0 = ensureNotNull(s_0.next);
          offset_4 = nextOffset;
        }
        var s_3 = s_0;
        var offset_5 = offset_4;
        var tmp$_2;
        if (s_3 == null) {
          commonIndexOfElement$result = L_1;
          break commonIndexOfElement$break;
        }var s_4 = s_3;
        var offset_6 = offset_5;
        if (targetBytes.size === 2) {
          var b0_1 = targetBytes.get_za3lpa$(0);
          var b1_1 = targetBytes.get_za3lpa$(1);
          while (offset_6.compareTo_11rb$(this.size) < 0) {
            var data_3 = s_4.data;
            var pos_3 = Kotlin.Long.fromInt(s_4.pos).add(fromIndex_0.v).subtract(offset_6).toInt();
            var limit_3 = s_4.limit;
            while (pos_3 < limit_3) {
              var b_3 = data_3[pos_3];
              if (b_3 === b0_1 || b_3 === b1_1) {
                commonIndexOfElement$result = Kotlin.Long.fromInt(pos_3 - s_4.pos | 0).add(offset_6);
                break commonIndexOfElement$break;
              }pos_3 = pos_3 + 1 | 0;
            }
            offset_6 = offset_6.add(Kotlin.Long.fromInt(s_4.limit - s_4.pos | 0));
            fromIndex_0.v = offset_6;
            s_4 = ensureNotNull(s_4.next);
          }
        } else {
          var targetByteArray_1 = targetBytes.internalArray();
          while (offset_6.compareTo_11rb$(this.size) < 0) {
            var data_4 = s_4.data;
            var pos_4 = Kotlin.Long.fromInt(s_4.pos).add(fromIndex_0.v).subtract(offset_6).toInt();
            var limit_4 = s_4.limit;
            while (pos_4 < limit_4) {
              var b_4 = data_4[pos_4];
              for (tmp$_2 = 0; tmp$_2 !== targetByteArray_1.length; ++tmp$_2) {
                var t_1 = targetByteArray_1[tmp$_2];
                if (b_4 === t_1) {
                  commonIndexOfElement$result = Kotlin.Long.fromInt(pos_4 - s_4.pos | 0).add(offset_6);
                  break commonIndexOfElement$break;
                }}
              pos_4 = pos_4 + 1 | 0;
            }
            offset_6 = offset_6.add(Kotlin.Long.fromInt(s_4.limit - s_4.pos | 0));
            fromIndex_0.v = offset_6;
            s_4 = ensureNotNull(s_4.next);
          }
        }
        commonIndexOfElement$result = L_1;
      }
    }
     while (false);
    return commonIndexOfElement$result;
  };
  Buffer.prototype.rangeEquals_2rh7jy$ = function (offset, bytes) {
    return this.rangeEquals_k1jc8u$(offset, bytes, 0, bytes.size);
  };
  Buffer.prototype.rangeEquals_k1jc8u$ = function (offset, bytes, bytesOffset, byteCount) {
    var commonRangeEquals$result;
    commonRangeEquals$break: do {
      if (offset.compareTo_11rb$(L0) < 0 || bytesOffset < 0 || byteCount < 0 || this.size.subtract(offset).toNumber() < byteCount || (bytes.size - bytesOffset | 0) < byteCount) {
        commonRangeEquals$result = false;
        break commonRangeEquals$break;
      }for (var i = 0; i < byteCount; i++) {
        if (this.get_s8cxhz$(offset.add(Kotlin.Long.fromInt(i))) !== bytes.get_za3lpa$(bytesOffset + i | 0)) {
          commonRangeEquals$result = false;
          break commonRangeEquals$break;
        }}
      commonRangeEquals$result = true;
    }
     while (false);
    return commonRangeEquals$result;
  };
  Buffer.prototype.flush = function () {
  };
  Buffer.prototype.close = function () {
  };
  Buffer.prototype.timeout = function () {
    return Timeout$Companion_getInstance().NONE;
  };
  Buffer.prototype.equals = function (other) {
    var commonEquals$result;
    commonEquals$break: do {
      var tmp$, tmp$_0, tmp$_1;
      if (this === other) {
        commonEquals$result = true;
        break commonEquals$break;
      }if (!Kotlin.isType(other, Buffer)) {
        commonEquals$result = false;
        break commonEquals$break;
      }if (!equals(this.size, other.size)) {
        commonEquals$result = false;
        break commonEquals$break;
      }if (equals(this.size, L0)) {
        commonEquals$result = true;
        break commonEquals$break;
      }var sa = ensureNotNull(this.head_8be2vx$);
      var sb = ensureNotNull(other.head_8be2vx$);
      var posA = sa.pos;
      var posB = sb.pos;
      var pos = L0;
      var count;
      while (pos.compareTo_11rb$(this.size) < 0) {
        var a = sa.limit - posA | 0;
        var b = sb.limit - posB | 0;
        count = Kotlin.Long.fromInt(JsMath.min(a, b));
        tmp$ = until(L0, count).iterator();
        while (tmp$.hasNext()) {
          var i = tmp$.next();
          if (sa.data[tmp$_0 = posA, posA = tmp$_0 + 1 | 0, tmp$_0] !== sb.data[tmp$_1 = posB, posB = tmp$_1 + 1 | 0, tmp$_1]) {
            commonEquals$result = false;
            break commonEquals$break;
          }}
        if (posA === sa.limit) {
          sa = ensureNotNull(sa.next);
          posA = sa.pos;
        }if (posB === sb.limit) {
          sb = ensureNotNull(sb.next);
          posB = sb.pos;
        }pos = pos.add(count);
      }
      commonEquals$result = true;
    }
     while (false);
    return commonEquals$result;
  };
  Buffer.prototype.hashCode = function () {
    var commonHashCode$result;
    commonHashCode$break: do {
      var tmp$;
      tmp$ = this.head_8be2vx$;
      if (tmp$ == null) {
        commonHashCode$result = 0;
        break commonHashCode$break;
      }var s = tmp$;
      var result = 1;
      do {
        var pos = s.pos;
        var limit = s.limit;
        while (pos < limit) {
          result = (31 * result | 0) + s.data[pos];
          pos = pos + 1 | 0;
        }
        s = ensureNotNull(s.next);
      }
       while (s !== this.head_8be2vx$);
      commonHashCode$result = result;
    }
     while (false);
    return commonHashCode$result;
  };
  Buffer.prototype.toString = function () {
    return this.snapshot().toString();
  };
  Buffer.prototype.copy = function () {
    var commonCopy$result;
    commonCopy$break: do {
      var result = new Buffer();
      if (equals(this.size, L0)) {
        commonCopy$result = result;
        break commonCopy$break;
      }var head = ensureNotNull(this.head_8be2vx$);
      var headCopy = head.sharedCopy();
      result.head_8be2vx$ = headCopy;
      headCopy.prev = result.head_8be2vx$;
      headCopy.next = headCopy.prev;
      var s = head.next;
      while (s !== head) {
        ensureNotNull(headCopy.prev).push_uve4t5$(ensureNotNull(s).sharedCopy());
        s = s.next;
      }
      result.size = this.size;
      commonCopy$result = result;
    }
     while (false);
    return commonCopy$result;
  };
  Buffer.prototype.snapshot = function () {
    if (!(this.size.toNumber() <= 2147483647)) {
      var message = 'size > Int.MAX_VALUE: ' + this.size.toString();
      throw IllegalStateException_init(message.toString());
    }return this.snapshot_za3lpa$(this.size.toInt());
  };
  Buffer.prototype.snapshot_za3lpa$ = function (byteCount) {
    var commonSnapshot$result;
    commonSnapshot$break: do {
      var tmp$;
      if (byteCount === 0) {
        commonSnapshot$result = ByteString.Companion.EMPTY;
        break commonSnapshot$break;
      }checkOffsetAndCount(this.size, L0, Kotlin.Long.fromInt(byteCount));
      var offset = 0;
      var segmentCount = 0;
      var s = this.head_8be2vx$;
      while (offset < byteCount) {
        if (ensureNotNull(s).limit === s.pos) {
          throw AssertionError_init('s.limit == s.pos');
        }offset = offset + (s.limit - s.pos) | 0;
        segmentCount = segmentCount + 1 | 0;
        s = s.next;
      }
      var segments = Kotlin.newArray(segmentCount, null);
      var directory = new Int32Array(segmentCount * 2 | 0);
      offset = 0;
      segmentCount = 0;
      s = this.head_8be2vx$;
      while (offset < byteCount) {
        segments[segmentCount] = ensureNotNull(s).data;
        offset = offset + (s.limit - s.pos) | 0;
        var a = offset;
        directory[segmentCount] = JsMath.min(a, byteCount);
        directory[segmentCount + segments.length | 0] = s.pos;
        s.shared = true;
        segmentCount = segmentCount + 1 | 0;
        s = s.next;
      }
      commonSnapshot$result = new SegmentedByteString(Kotlin.isArray(tmp$ = segments) ? tmp$ : throwCCE(), directory);
    }
     while (false);
    return commonSnapshot$result;
  };
  Buffer.prototype.md5 = function () {
    return this.digest_0(new Md5());
  };
  Buffer.prototype.sha1 = function () {
    return this.digest_0(new Sha1());
  };
  Buffer.prototype.sha256 = function () {
    return this.digest_0(new Sha256());
  };
  Buffer.prototype.sha512 = function () {
    return this.digest_0(new Sha512());
  };
  Buffer.prototype.hmacSha1_9ovubf$ = function (key) {
    return this.digest_0(Hmac$Companion_getInstance().sha1_9ovubf$(key));
  };
  Buffer.prototype.hmacSha256_9ovubf$ = function (key) {
    return this.digest_0(Hmac$Companion_getInstance().sha256_9ovubf$(key));
  };
  Buffer.prototype.hmacSha512_9ovubf$ = function (key) {
    return this.digest_0(Hmac$Companion_getInstance().sha512_9ovubf$(key));
  };
  function Buffer$digest$lambda(closure$hash) {
    return function (segment) {
      closure$hash.update_mj6st8$(segment.data, segment.pos, segment.limit - segment.pos | 0);
      return Unit;
    };
  }
  Buffer.prototype.digest_0 = function (hash) {
    this.forEachSegment_0(Buffer$digest$lambda(hash));
    return new ByteString(hash.digest());
  };
  Buffer.prototype.forEachSegment_0 = function (action) {
    var tmp$;
    if ((tmp$ = this.head_8be2vx$) != null) {
      var segment = tmp$;
      do {
        if (segment != null) {
          action(segment);
        }segment = segment != null ? segment.next : null;
      }
       while (segment !== tmp$);
    }};
  Buffer.prototype.readUnsafe_ykzice$ = function (unsafeCursor) {
    if (unsafeCursor === void 0)
      unsafeCursor = DEFAULT__new_UnsafeCursor;
    return commonReadUnsafe(this, unsafeCursor);
  };
  Buffer.prototype.readAndWriteUnsafe_ykzice$ = function (unsafeCursor) {
    if (unsafeCursor === void 0)
      unsafeCursor = DEFAULT__new_UnsafeCursor;
    return commonReadAndWriteUnsafe(this, unsafeCursor);
  };
  function Buffer$UnsafeCursor() {
    this.buffer = null;
    this.readWrite = false;
    this.segment_8be2vx$ = null;
    this.offset = L_1;
    this.data = null;
    this.start = -1;
    this.end = -1;
  }
  Buffer$UnsafeCursor.prototype.next = function () {
    if (!!equals(this.offset, ensureNotNull(this.buffer).size)) {
      var message = 'no more bytes';
      throw IllegalStateException_init(message.toString());
    }return equals(this.offset, L_1) ? this.seek_s8cxhz$(L0) : this.seek_s8cxhz$(this.offset.add(Kotlin.Long.fromInt(this.end - this.start | 0)));
  };
  Buffer$UnsafeCursor.prototype.seek_s8cxhz$ = function (offset) {
    var commonSeek$result;
    commonSeek$break: do {
      var value = this.buffer;
      var checkNotNull$result;
      if (value == null) {
        var message = 'not attached to a buffer';
        throw IllegalStateException_init(message.toString());
      } else {
        checkNotNull$result = value;
      }
      var buffer = checkNotNull$result;
      if (offset.toNumber() < -1 || offset.compareTo_11rb$(buffer.size) > 0) {
        throw new ArrayIndexOutOfBoundsException('offset=' + offset.toString() + ' > size=' + buffer.size.toString());
      }if (equals(offset, L_1) || equals(offset, buffer.size)) {
        this.segment_8be2vx$ = null;
        this.offset = offset;
        this.data = null;
        this.start = -1;
        this.end = -1;
        commonSeek$result = -1;
        break commonSeek$break;
      }var min = L0;
      var max = buffer.size;
      var head = buffer.head_8be2vx$;
      var tail = buffer.head_8be2vx$;
      if (this.segment_8be2vx$ != null) {
        var segmentOffset = this.offset.subtract(Kotlin.Long.fromInt(this.start - ensureNotNull(this.segment_8be2vx$).pos | 0));
        if (segmentOffset.compareTo_11rb$(offset) > 0) {
          max = segmentOffset;
          tail = this.segment_8be2vx$;
        } else {
          min = segmentOffset;
          head = this.segment_8be2vx$;
        }
      }var next;
      var nextOffset;
      if (max.subtract(offset).compareTo_11rb$(offset.subtract(min)) > 0) {
        next = head;
        nextOffset = min;
        while (offset.compareTo_11rb$(nextOffset.add(Kotlin.Long.fromInt(ensureNotNull(next).limit - next.pos | 0))) >= 0) {
          nextOffset = nextOffset.add(Kotlin.Long.fromInt(next.limit - next.pos | 0));
          next = next.next;
        }
      } else {
        next = tail;
        nextOffset = max;
        while (nextOffset.compareTo_11rb$(offset) > 0) {
          next = ensureNotNull(next).prev;
          nextOffset = nextOffset.subtract(Kotlin.Long.fromInt(ensureNotNull(next).limit - next.pos | 0));
        }
      }
      if (this.readWrite && ensureNotNull(next).shared) {
        var unsharedNext = next.unsharedCopy();
        if (buffer.head_8be2vx$ === next) {
          buffer.head_8be2vx$ = unsharedNext;
        }next = next.push_uve4t5$(unsharedNext);
        ensureNotNull(next.prev).pop();
      }this.segment_8be2vx$ = next;
      this.offset = offset;
      this.data = ensureNotNull(next).data;
      this.start = next.pos + offset.subtract(nextOffset).toInt() | 0;
      this.end = next.limit;
      commonSeek$result = this.end - this.start | 0;
    }
     while (false);
    return commonSeek$result;
  };
  Buffer$UnsafeCursor.prototype.resizeBuffer_s8cxhz$ = function (newSize) {
    var value = this.buffer;
    var checkNotNull$result;
    if (value == null) {
      var message = 'not attached to a buffer';
      throw IllegalStateException_init(message.toString());
    } else {
      checkNotNull$result = value;
    }
    var buffer = checkNotNull$result;
    if (!this.readWrite) {
      var message_0 = 'resizeBuffer() only permitted for read/write buffers';
      throw IllegalStateException_init(message_0.toString());
    }var oldSize = buffer.size;
    if (newSize.compareTo_11rb$(oldSize) <= 0) {
      if (!(newSize.compareTo_11rb$(L0) >= 0)) {
        var message_1 = 'newSize < 0: ' + newSize.toString();
        throw IllegalArgumentException_init(message_1.toString());
      }var bytesToSubtract = oldSize.subtract(newSize);
      while (bytesToSubtract.compareTo_11rb$(L0) > 0) {
        var tail = ensureNotNull(buffer.head_8be2vx$).prev;
        var tailSize = ensureNotNull(tail).limit - tail.pos | 0;
        if (tailSize <= bytesToSubtract.toNumber()) {
          buffer.head_8be2vx$ = tail.pop();
          package$okio.SegmentPool.recycle_uve4t5$(tail);
          bytesToSubtract = bytesToSubtract.subtract(Kotlin.Long.fromInt(tailSize));
        } else {
          tail.limit = tail.limit - bytesToSubtract.toInt() | 0;
          break;
        }
      }
      this.segment_8be2vx$ = null;
      this.offset = newSize;
      this.data = null;
      this.start = -1;
      this.end = -1;
    } else if (newSize.compareTo_11rb$(oldSize) > 0) {
      var needsToSeek = true;
      var bytesToAdd = newSize.subtract(oldSize);
      while (bytesToAdd.compareTo_11rb$(L0) > 0) {
        var tail_0 = buffer.writableSegment_kcn2v3$(1);
        var a = bytesToAdd;
        var b = Kotlin.Long.fromInt(8192 - tail_0.limit | 0);
        var segmentBytesToAdd = (a.compareTo_11rb$(b) <= 0 ? a : b).toInt();
        tail_0.limit = tail_0.limit + segmentBytesToAdd | 0;
        bytesToAdd = bytesToAdd.subtract(Kotlin.Long.fromInt(segmentBytesToAdd));
        if (needsToSeek) {
          this.segment_8be2vx$ = tail_0;
          this.offset = oldSize;
          this.data = tail_0.data;
          this.start = tail_0.limit - segmentBytesToAdd | 0;
          this.end = tail_0.limit;
          needsToSeek = false;
        }}
    }buffer.size = newSize;
    return oldSize;
  };
  Buffer$UnsafeCursor.prototype.expandBuffer_za3lpa$ = function (minByteCount) {
    if (!(minByteCount > 0)) {
      var message = 'minByteCount <= 0: ' + minByteCount;
      throw IllegalArgumentException_init(message.toString());
    }if (!(minByteCount <= 8192)) {
      var message_0 = 'minByteCount > Segment.SIZE: ' + minByteCount;
      throw IllegalArgumentException_init(message_0.toString());
    }var value = this.buffer;
    var checkNotNull$result;
    if (value == null) {
      var message_1 = 'not attached to a buffer';
      throw IllegalStateException_init(message_1.toString());
    } else {
      checkNotNull$result = value;
    }
    var buffer = checkNotNull$result;
    if (!this.readWrite) {
      var message_2 = 'expandBuffer() only permitted for read/write buffers';
      throw IllegalStateException_init(message_2.toString());
    }var oldSize = buffer.size;
    var tail = buffer.writableSegment_kcn2v3$(minByteCount);
    var result = 8192 - tail.limit | 0;
    tail.limit = 8192;
    buffer.size = oldSize.add(Kotlin.Long.fromInt(result));
    this.segment_8be2vx$ = tail;
    this.offset = oldSize;
    this.data = tail.data;
    this.start = 8192 - result | 0;
    this.end = 8192;
    return Kotlin.Long.fromInt(result);
  };
  Buffer$UnsafeCursor.prototype.close = function () {
    if (!(this.buffer != null)) {
      var message = 'not attached to a buffer';
      throw IllegalStateException_init(message.toString());
    }this.buffer = null;
    this.segment_8be2vx$ = null;
    this.offset = L_1;
    this.data = null;
    this.start = -1;
    this.end = -1;
  };
  Buffer$UnsafeCursor.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnsafeCursor',
    interfaces: []
  };
  Buffer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Buffer',
    interfaces: [BufferedSink, BufferedSource]
  };
  function BufferedSink() {
  }
  BufferedSink.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'BufferedSink',
    interfaces: [Sink]
  };
  function BufferedSource() {
  }
  BufferedSource.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'BufferedSource',
    interfaces: [Source]
  };
  function ByteString(data) {
    ByteString$Companion_getInstance();
    this.data_8be2vx$ = data;
    this.hashCode_8be2vx$_k36dyi$_0 = 0;
    this.utf8_8be2vx$_7f6fpw$_0 = null;
  }
  Object.defineProperty(ByteString.prototype, 'hashCode_8be2vx$', {
    configurable: true,
    get: function () {
      return this.hashCode_8be2vx$_k36dyi$_0;
    },
    set: function (value) {
    }
  });
  Object.defineProperty(ByteString.prototype, 'utf8_8be2vx$', {
    configurable: true,
    get: function () {
      return this.utf8_8be2vx$_7f6fpw$_0;
    },
    set: function (value) {
    }
  });
  ByteString.prototype.utf8 = function () {
    var result = this.utf8_8be2vx$;
    if (result == null) {
      result = toUtf8String(this.internalArray());
      this.utf8_8be2vx$ = result;
    }return result;
  };
  ByteString.prototype.base64 = function () {
    return encodeBase64(this.data_8be2vx$);
  };
  ByteString.prototype.base64Url = function () {
    return encodeBase64(this.data_8be2vx$, package$okio.BASE64_URL_SAFE_8be2vx$);
  };
  ByteString.prototype.hex = function () {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var result = Kotlin.charArray(this.data_8be2vx$.length * 2 | 0);
    var c = 0;
    tmp$ = this.data_8be2vx$;
    for (tmp$_0 = 0; tmp$_0 !== tmp$.length; ++tmp$_0) {
      var b = tmp$[tmp$_0];
      result[tmp$_1 = c, c = tmp$_1 + 1 | 0, tmp$_1] = package$internal.HEX_DIGIT_CHARS_8be2vx$[b >> 4 & 15];
      result[tmp$_2 = c, c = tmp$_2 + 1 | 0, tmp$_2] = package$internal.HEX_DIGIT_CHARS_8be2vx$[b & 15];
    }
    return concatToString(result);
  };
  ByteString.prototype.md5 = function () {
    return this.digest_8td9e3$(new Md5());
  };
  ByteString.prototype.sha1 = function () {
    return this.digest_8td9e3$(new Sha1());
  };
  ByteString.prototype.sha256 = function () {
    return this.digest_8td9e3$(new Sha256());
  };
  ByteString.prototype.sha512 = function () {
    return this.digest_8td9e3$(new Sha512());
  };
  ByteString.prototype.hmacSha1_9ovubf$ = function (key) {
    return this.digest_8td9e3$(Hmac$Companion_getInstance().sha1_9ovubf$(key));
  };
  ByteString.prototype.hmacSha256_9ovubf$ = function (key) {
    return this.digest_8td9e3$(Hmac$Companion_getInstance().sha256_9ovubf$(key));
  };
  ByteString.prototype.hmacSha512_9ovubf$ = function (key) {
    return this.digest_8td9e3$(Hmac$Companion_getInstance().sha512_9ovubf$(key));
  };
  ByteString.prototype.digest_8td9e3$ = function (hashFunction) {
    hashFunction.update_mj6st8$(this.data_8be2vx$, 0, this.size);
    var digestBytes = hashFunction.digest();
    return new ByteString(digestBytes);
  };
  ByteString.prototype.toAsciiLowercase = function () {
    var commonToAsciiLowercase$result;
    commonToAsciiLowercase$break: do {
      var tmp$;
      var i = 0;
      while (i < this.data_8be2vx$.length) {
        var c = this.data_8be2vx$[i];
        if (c < toByte(65) || c > toByte(90)) {
          i = i + 1 | 0;
          continue;
        }var lowercase = this.data_8be2vx$.slice();
        lowercase[tmp$ = i, i = tmp$ + 1 | 0, tmp$] = toByte(c - -32);
        while (i < lowercase.length) {
          c = lowercase[i];
          if (c < toByte(65) || c > toByte(90)) {
            i = i + 1 | 0;
            continue;
          }lowercase[i] = toByte(c - -32);
          i = i + 1 | 0;
        }
        commonToAsciiLowercase$result = new ByteString(lowercase);
        break commonToAsciiLowercase$break;
      }
      commonToAsciiLowercase$result = this;
    }
     while (false);
    return commonToAsciiLowercase$result;
  };
  ByteString.prototype.toAsciiUppercase = function () {
    var commonToAsciiUppercase$result;
    commonToAsciiUppercase$break: do {
      var tmp$;
      var i = 0;
      while (i < this.data_8be2vx$.length) {
        var c = this.data_8be2vx$[i];
        if (c < toByte(97) || c > toByte(122)) {
          i = i + 1 | 0;
          continue;
        }var lowercase = this.data_8be2vx$.slice();
        lowercase[tmp$ = i, i = tmp$ + 1 | 0, tmp$] = toByte(c - 32);
        while (i < lowercase.length) {
          c = lowercase[i];
          if (c < toByte(97) || c > toByte(122)) {
            i = i + 1 | 0;
            continue;
          }lowercase[i] = toByte(c - 32);
          i = i + 1 | 0;
        }
        commonToAsciiUppercase$result = new ByteString(lowercase);
        break commonToAsciiUppercase$break;
      }
      commonToAsciiUppercase$result = this;
    }
     while (false);
    return commonToAsciiUppercase$result;
  };
  ByteString.prototype.substring_vux9f0$$default = function (beginIndex, endIndex) {
    var commonSubstring$result;
    commonSubstring$break: do {
      var endIndex_0 = resolveDefaultParameter_0(this, endIndex);
      if (!(beginIndex >= 0)) {
        var message = 'beginIndex < 0';
        throw IllegalArgumentException_init(message.toString());
      }if (!(endIndex_0 <= this.data_8be2vx$.length)) {
        var message_0 = 'endIndex > length(' + this.data_8be2vx$.length + ')';
        throw IllegalArgumentException_init(message_0.toString());
      }var subLen = endIndex_0 - beginIndex | 0;
      if (!(subLen >= 0)) {
        var message_1 = 'endIndex < beginIndex';
        throw IllegalArgumentException_init(message_1.toString());
      }if (beginIndex === 0 && endIndex_0 === this.data_8be2vx$.length) {
        commonSubstring$result = this;
        break commonSubstring$break;
      }commonSubstring$result = new ByteString(copyOfRange(this.data_8be2vx$, beginIndex, endIndex_0));
    }
     while (false);
    return commonSubstring$result;
  };
  ByteString.prototype.substring_vux9f0$ = function (beginIndex, endIndex, callback$default) {
    if (beginIndex === void 0)
      beginIndex = 0;
    if (endIndex === void 0)
      endIndex = DEFAULT__ByteString_size;
    return callback$default ? callback$default(beginIndex, endIndex) : this.substring_vux9f0$$default(beginIndex, endIndex);
  };
  ByteString.prototype.internalGet_za3lpa$ = function (pos) {
    if (pos >= this.size || pos < 0)
      throw new ArrayIndexOutOfBoundsException('size=' + this.size + ' pos=' + pos);
    return this.data_8be2vx$[pos];
  };
  ByteString.prototype.get_za3lpa$ = function (index) {
    return this.internalGet_za3lpa$(index);
  };
  Object.defineProperty(ByteString.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.getSize();
    }
  });
  ByteString.prototype.getSize = function () {
    return this.data_8be2vx$.length;
  };
  ByteString.prototype.toByteArray = function () {
    return this.data_8be2vx$.slice();
  };
  ByteString.prototype.internalArray = function () {
    return this.data_8be2vx$;
  };
  ByteString.prototype.write_zfhfyk$ = function (buffer, offset, byteCount) {
    commonWrite_4(this, buffer, offset, byteCount);
  };
  ByteString.prototype.rangeEquals_kxw41n$ = function (offset, other, otherOffset, byteCount) {
    return other.rangeEquals_3fge6q$(otherOffset, this.data_8be2vx$, offset, byteCount);
  };
  ByteString.prototype.rangeEquals_3fge6q$ = function (offset, other, otherOffset, byteCount) {
    return offset >= 0 && offset <= (this.data_8be2vx$.length - byteCount | 0) && otherOffset >= 0 && otherOffset <= (other.length - byteCount | 0) && arrayRangeEquals(this.data_8be2vx$, offset, other, otherOffset, byteCount);
  };
  ByteString.prototype.copyInto_3fge6q$$default = function (offset, target, targetOffset, byteCount) {
    arrayCopy(this.data_8be2vx$, target, targetOffset, offset, offset + byteCount | 0);
  };
  ByteString.prototype.copyInto_3fge6q$ = function (offset, target, targetOffset, byteCount, callback$default) {
    if (offset === void 0)
      offset = 0;
    if (targetOffset === void 0)
      targetOffset = 0;
    callback$default ? callback$default(offset, target, targetOffset, byteCount) : this.copyInto_3fge6q$$default(offset, target, targetOffset, byteCount);
  };
  ByteString.prototype.startsWith_9ovubf$ = function (prefix) {
    return this.rangeEquals_kxw41n$(0, prefix, 0, prefix.size);
  };
  ByteString.prototype.startsWith_fqrh44$ = function (prefix) {
    return this.rangeEquals_3fge6q$(0, prefix, 0, prefix.length);
  };
  ByteString.prototype.endsWith_9ovubf$ = function (suffix) {
    return this.rangeEquals_kxw41n$(this.size - suffix.size | 0, suffix, 0, suffix.size);
  };
  ByteString.prototype.endsWith_fqrh44$ = function (suffix) {
    return this.rangeEquals_3fge6q$(this.size - suffix.length | 0, suffix, 0, suffix.length);
  };
  ByteString.prototype.indexOf_598ac7$ = function (other, fromIndex) {
    if (fromIndex === void 0)
      fromIndex = 0;
    return this.indexOf_ir89t6$(other.internalArray(), fromIndex);
  };
  ByteString.prototype.indexOf_ir89t6$$default = function (other, fromIndex) {
    var commonIndexOf$result;
    commonIndexOf$break: do {
      var limit = this.data_8be2vx$.length - other.length | 0;
      for (var i = JsMath.max(fromIndex, 0); i <= limit; i++) {
        if (arrayRangeEquals(this.data_8be2vx$, i, other, 0, other.length)) {
          commonIndexOf$result = i;
          break commonIndexOf$break;
        }}
      commonIndexOf$result = -1;
    }
     while (false);
    return commonIndexOf$result;
  };
  ByteString.prototype.indexOf_ir89t6$ = function (other, fromIndex, callback$default) {
    if (fromIndex === void 0)
      fromIndex = 0;
    return callback$default ? callback$default(other, fromIndex) : this.indexOf_ir89t6$$default(other, fromIndex);
  };
  ByteString.prototype.lastIndexOf_598ac7$ = function (other, fromIndex) {
    if (fromIndex === void 0)
      fromIndex = DEFAULT__ByteString_size;
    return this.lastIndexOf_ir89t6$(other.internalArray(), fromIndex);
  };
  ByteString.prototype.lastIndexOf_ir89t6$$default = function (other, fromIndex) {
    var commonLastIndexOf$result;
    commonLastIndexOf$break: do {
      var fromIndex_0 = resolveDefaultParameter_0(this, fromIndex);
      var limit = this.data_8be2vx$.length - other.length | 0;
      for (var i = JsMath.min(fromIndex_0, limit); i >= 0; i--) {
        if (arrayRangeEquals(this.data_8be2vx$, i, other, 0, other.length)) {
          commonLastIndexOf$result = i;
          break commonLastIndexOf$break;
        }}
      commonLastIndexOf$result = -1;
    }
     while (false);
    return commonLastIndexOf$result;
  };
  ByteString.prototype.lastIndexOf_ir89t6$ = function (other, fromIndex, callback$default) {
    if (fromIndex === void 0)
      fromIndex = DEFAULT__ByteString_size;
    return callback$default ? callback$default(other, fromIndex) : this.lastIndexOf_ir89t6$$default(other, fromIndex);
  };
  ByteString.prototype.equals = function (other) {
    var tmp$;
    if (other === this)
      tmp$ = true;
    else if (Kotlin.isType(other, ByteString))
      tmp$ = (other.size === this.data_8be2vx$.length && other.rangeEquals_3fge6q$(0, this.data_8be2vx$, 0, this.data_8be2vx$.length));
    else
      tmp$ = false;
    return tmp$;
  };
  ByteString.prototype.hashCode = function () {
    var commonHashCode$result;
    commonHashCode$break: do {
      var result = this.hashCode_8be2vx$;
      if (result !== 0) {
        commonHashCode$result = result;
        break commonHashCode$break;
      }var $receiver = contentHashCode(this.data_8be2vx$);
      this.hashCode_8be2vx$ = $receiver;
      commonHashCode$result = $receiver;
    }
     while (false);
    return commonHashCode$result;
  };
  ByteString.prototype.compareTo_11rb$ = function (other) {
    var commonCompareTo$result;
    commonCompareTo$break: do {
      var sizeA = this.size;
      var sizeB = other.size;
      var i = 0;
      var size = JsMath.min(sizeA, sizeB);
      while (i < size) {
        var byteA = this.get_za3lpa$(i) & 255;
        var byteB = other.get_za3lpa$(i) & 255;
        if (byteA === byteB) {
          i = i + 1 | 0;
          continue;
        }commonCompareTo$result = byteA < byteB ? -1 : 1;
        break commonCompareTo$break;
      }
      if (sizeA === sizeB) {
        commonCompareTo$result = 0;
        break commonCompareTo$break;
      }commonCompareTo$result = sizeA < sizeB ? -1 : 1;
    }
     while (false);
    return commonCompareTo$result;
  };
  ByteString.prototype.toString = function () {
    var commonToString$result;
    commonToString$break: do {
      var tmp$, tmp$_0;
      if (this.data_8be2vx$.length === 0) {
        commonToString$result = '[size=0]';
        break commonToString$break;
      }var i = codePointIndexToCharIndex(this.data_8be2vx$, 64);
      if (i === -1) {
        if (this.data_8be2vx$.length <= 64) {
          tmp$ = '[hex=' + this.hex() + ']';
        } else {
          var tmp$_1 = '[size=' + this.data_8be2vx$.length + ' hex=';
          var commonSubstring$result;
          commonSubstring$break: do {
            var endIndex = resolveDefaultParameter_0(this, 64);
            if (!(0 >= 0)) {
              var message = 'beginIndex < 0';
              throw IllegalArgumentException_init(message.toString());
            }if (!(endIndex <= this.data_8be2vx$.length)) {
              var message_0 = 'endIndex > length(' + this.data_8be2vx$.length + ')';
              throw IllegalArgumentException_init(message_0.toString());
            }var subLen = endIndex - 0 | 0;
            if (!(subLen >= 0)) {
              var message_1 = 'endIndex < beginIndex';
              throw IllegalArgumentException_init(message_1.toString());
            }if (0 === 0 && endIndex === this.data_8be2vx$.length) {
              commonSubstring$result = this;
              break commonSubstring$break;
            }commonSubstring$result = new ByteString(copyOfRange(this.data_8be2vx$, 0, endIndex));
          }
           while (false);
          tmp$ = tmp$_1 + commonSubstring$result.hex() + '\u2026]';
        }
        commonToString$result = tmp$;
        break commonToString$break;
      }var text = this.utf8();
      var safeText = replace(replace(replace(text.substring(0, i), '\\', '\\\\'), '\n', '\\n'), '\r', '\\r');
      if (i < text.length) {
        tmp$_0 = '[size=' + this.data_8be2vx$.length + ' text=' + safeText + '\u2026]';
      } else {
        tmp$_0 = '[text=' + safeText + ']';
      }
      commonToString$result = tmp$_0;
    }
     while (false);
    return commonToString$result;
  };
  function ByteString$Companion() {
    ByteString$Companion_instance = this;
    this.EMPTY = new ByteString(new Int8Array([]));
  }
  ByteString$Companion.prototype.of_wcry4u$ = function (data) {
    return new ByteString(data.slice());
  };
  ByteString$Companion.prototype.toByteString_ietg8x$ = function ($receiver, offset, byteCount) {
    if (offset === void 0)
      offset = 0;
    if (byteCount === void 0)
      byteCount = this.length;
    checkOffsetAndCount(Kotlin.Long.fromInt($receiver.length), Kotlin.Long.fromInt(offset), Kotlin.Long.fromInt(byteCount));
    return new ByteString(copyOfRange($receiver, offset, offset + byteCount | 0));
  };
  ByteString$Companion.prototype.encodeUtf8_pdl1vz$ = function ($receiver) {
    var byteString = new ByteString(asUtf8ToByteArray($receiver));
    byteString.utf8_8be2vx$ = $receiver;
    return byteString;
  };
  ByteString$Companion.prototype.decodeBase64_pdl1vz$ = function ($receiver) {
    var decoded = decodeBase64ToArray($receiver);
    return decoded != null ? new ByteString(decoded) : null;
  };
  ByteString$Companion.prototype.decodeHex_pdl1vz$ = function ($receiver) {
    if (!($receiver.length % 2 === 0)) {
      var message = 'Unexpected hex string: ' + $receiver;
      throw IllegalArgumentException_init(message.toString());
    }var result = new Int8Array($receiver.length / 2 | 0);
    for (var i = 0; i !== result.length; ++i) {
      var d1 = decodeHexDigit($receiver.charCodeAt(i * 2 | 0)) << 4;
      var d2 = decodeHexDigit($receiver.charCodeAt((i * 2 | 0) + 1 | 0));
      result[i] = toByte(d1 + d2 | 0);
    }
    return new ByteString(result);
  };
  ByteString$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ByteString$Companion_instance = null;
  function ByteString$Companion_getInstance() {
    if (ByteString$Companion_instance === null) {
      new ByteString$Companion();
    }return ByteString$Companion_instance;
  }
  ByteString.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ByteString',
    interfaces: [Comparable]
  };
  function HashingSink(sink, hashFunction) {
    HashingSink$Companion_getInstance();
    this.sink_0 = sink;
    this.hashFunction_0 = hashFunction;
  }
  HashingSink.prototype.write_u27jpl$ = function (source, byteCount) {
    checkOffsetAndCount(source.size, L0, byteCount);
    var hashedCount = L0;
    var s = ensureNotNull(source.head_8be2vx$);
    while (hashedCount.compareTo_11rb$(byteCount) < 0) {
      var a = byteCount.subtract(hashedCount);
      var b = Kotlin.Long.fromInt(s.limit - s.pos | 0);
      var toHash = (a.compareTo_11rb$(b) <= 0 ? a : b).toInt();
      this.hashFunction_0.update_mj6st8$(s.data, s.pos, toHash);
      hashedCount = hashedCount.add(Kotlin.Long.fromInt(toHash));
      s = ensureNotNull(s.next);
    }
    this.sink_0.write_u27jpl$(source, byteCount);
  };
  HashingSink.prototype.flush = function () {
    this.sink_0.flush();
  };
  HashingSink.prototype.timeout = function () {
    return this.sink_0.timeout();
  };
  HashingSink.prototype.close = function () {
    this.sink_0.close();
  };
  Object.defineProperty(HashingSink.prototype, 'hash', {
    configurable: true,
    get: function () {
      var result = this.hashFunction_0.digest();
      return new ByteString(result);
    }
  });
  function HashingSink$Companion() {
    HashingSink$Companion_instance = this;
  }
  HashingSink$Companion.prototype.md5_awqvbz$ = function (sink) {
    return new HashingSink(sink, new Md5());
  };
  HashingSink$Companion.prototype.sha1_awqvbz$ = function (sink) {
    return new HashingSink(sink, new Sha1());
  };
  HashingSink$Companion.prototype.sha256_awqvbz$ = function (sink) {
    return new HashingSink(sink, new Sha256());
  };
  HashingSink$Companion.prototype.sha512_awqvbz$ = function (sink) {
    return new HashingSink(sink, new Sha512());
  };
  HashingSink$Companion.prototype.hmacSha1_4jy6rs$ = function (sink, key) {
    return new HashingSink(sink, Hmac$Companion_getInstance().sha1_9ovubf$(key));
  };
  HashingSink$Companion.prototype.hmacSha256_4jy6rs$ = function (sink, key) {
    return new HashingSink(sink, Hmac$Companion_getInstance().sha256_9ovubf$(key));
  };
  HashingSink$Companion.prototype.hmacSha512_4jy6rs$ = function (sink, key) {
    return new HashingSink(sink, Hmac$Companion_getInstance().sha512_9ovubf$(key));
  };
  HashingSink$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var HashingSink$Companion_instance = null;
  function HashingSink$Companion_getInstance() {
    if (HashingSink$Companion_instance === null) {
      new HashingSink$Companion();
    }return HashingSink$Companion_instance;
  }
  HashingSink.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'HashingSink',
    interfaces: [Sink]
  };
  function HashingSource(source, hashFunction) {
    HashingSource$Companion_getInstance();
    this.source_0 = source;
    this.hashFunction_0 = hashFunction;
  }
  HashingSource.prototype.read_u27jpl$ = function (sink, byteCount) {
    var result = this.source_0.read_u27jpl$(sink, byteCount);
    if (!equals(result, L_1)) {
      var start = sink.size.subtract(result);
      var offset = sink.size;
      var s = ensureNotNull(sink.head_8be2vx$);
      while (offset.compareTo_11rb$(start) > 0) {
        s = ensureNotNull(s.prev);
        offset = offset.subtract(Kotlin.Long.fromInt(s.limit - s.pos | 0));
      }
      while (offset.compareTo_11rb$(sink.size) < 0) {
        var pos = Kotlin.Long.fromInt(s.pos).add(start).subtract(offset).toInt();
        this.hashFunction_0.update_mj6st8$(s.data, pos, s.limit - pos | 0);
        offset = offset.add(Kotlin.Long.fromInt(s.limit - s.pos | 0));
        start = offset;
        s = ensureNotNull(s.next);
      }
    }return result;
  };
  HashingSource.prototype.timeout = function () {
    return this.source_0.timeout();
  };
  HashingSource.prototype.close = function () {
    this.source_0.close();
  };
  Object.defineProperty(HashingSource.prototype, 'hash', {
    configurable: true,
    get: function () {
      var result = this.hashFunction_0.digest();
      return new ByteString(result);
    }
  });
  function HashingSource$Companion() {
    HashingSource$Companion_instance = this;
  }
  HashingSource$Companion.prototype.md5_sby9nd$ = function (source) {
    return new HashingSource(source, new Md5());
  };
  HashingSource$Companion.prototype.sha1_sby9nd$ = function (source) {
    return new HashingSource(source, new Sha1());
  };
  HashingSource$Companion.prototype.sha256_sby9nd$ = function (source) {
    return new HashingSource(source, new Sha256());
  };
  HashingSource$Companion.prototype.sha512_sby9nd$ = function (source) {
    return new HashingSource(source, new Sha512());
  };
  HashingSource$Companion.prototype.hmacSha1_vhhqdc$ = function (source, key) {
    return new HashingSource(source, Hmac$Companion_getInstance().sha1_9ovubf$(key));
  };
  HashingSource$Companion.prototype.hmacSha256_vhhqdc$ = function (source, key) {
    return new HashingSource(source, Hmac$Companion_getInstance().sha256_9ovubf$(key));
  };
  HashingSource$Companion.prototype.hmacSha512_vhhqdc$ = function (source, key) {
    return new HashingSource(source, Hmac$Companion_getInstance().sha512_9ovubf$(key));
  };
  HashingSource$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var HashingSource$Companion_instance = null;
  function HashingSource$Companion_getInstance() {
    if (HashingSource$Companion_instance === null) {
      new HashingSource$Companion();
    }return HashingSource$Companion_instance;
  }
  HashingSource.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'HashingSource',
    interfaces: [Source]
  };
  function Path(bytes) {
    Path$Companion_getInstance();
    this.bytes_8be2vx$ = bytes;
  }
  Object.defineProperty(Path.prototype, 'root', {
    configurable: true,
    get: function () {
      var tmp$;
      var rootLength_0 = rootLength(this);
      if (rootLength_0 === -1)
        tmp$ = null;
      else
        tmp$ = new Path(this.bytes_8be2vx$.substring_vux9f0$(0, rootLength_0));
      return tmp$;
    }
  });
  Object.defineProperty(Path.prototype, 'segments', {
    configurable: true,
    get: function () {
      var tmp$;
      var result = ArrayList_init();
      var segmentStart = rootLength(this);
      if (segmentStart === -1) {
        segmentStart = 0;
      } else if (segmentStart < this.bytes_8be2vx$.size && this.bytes_8be2vx$.get_za3lpa$(segmentStart) === toByte(92)) {
        segmentStart = segmentStart + 1 | 0;
      }tmp$ = this.bytes_8be2vx$.size;
      for (var i = segmentStart; i < tmp$; i++) {
        if (this.bytes_8be2vx$.get_za3lpa$(i) === toByte(47) || this.bytes_8be2vx$.get_za3lpa$(i) === toByte(92)) {
          var element = this.bytes_8be2vx$.substring_vux9f0$(segmentStart, i);
          result.add_11rb$(element);
          segmentStart = i + 1 | 0;
        }}
      if (segmentStart < this.bytes_8be2vx$.size) {
        var element_0 = this.bytes_8be2vx$.substring_vux9f0$(segmentStart, this.bytes_8be2vx$.size);
        result.add_11rb$(element_0);
      }var destination = ArrayList_init_0(collectionSizeOrDefault(result, 10));
      var tmp$_0;
      tmp$_0 = result.iterator();
      while (tmp$_0.hasNext()) {
        var item = tmp$_0.next();
        destination.add_11rb$(item.utf8());
      }
      return destination;
    }
  });
  Object.defineProperty(Path.prototype, 'segmentsBytes', {
    configurable: true,
    get: function () {
      var tmp$;
      var result = ArrayList_init();
      var segmentStart = rootLength(this);
      if (segmentStart === -1) {
        segmentStart = 0;
      } else if (segmentStart < this.bytes_8be2vx$.size && this.bytes_8be2vx$.get_za3lpa$(segmentStart) === toByte(92)) {
        segmentStart = segmentStart + 1 | 0;
      }tmp$ = this.bytes_8be2vx$.size;
      for (var i = segmentStart; i < tmp$; i++) {
        if (this.bytes_8be2vx$.get_za3lpa$(i) === toByte(47) || this.bytes_8be2vx$.get_za3lpa$(i) === toByte(92)) {
          var element = this.bytes_8be2vx$.substring_vux9f0$(segmentStart, i);
          result.add_11rb$(element);
          segmentStart = i + 1 | 0;
        }}
      if (segmentStart < this.bytes_8be2vx$.size) {
        var element_0 = this.bytes_8be2vx$.substring_vux9f0$(segmentStart, this.bytes_8be2vx$.size);
        result.add_11rb$(element_0);
      }return result;
    }
  });
  Object.defineProperty(Path.prototype, 'isAbsolute', {
    configurable: true,
    get: function () {
      return rootLength(this) !== -1;
    }
  });
  Object.defineProperty(Path.prototype, 'isRelative', {
    configurable: true,
    get: function () {
      return rootLength(this) === -1;
    }
  });
  Object.defineProperty(Path.prototype, 'volumeLetter', {
    configurable: true,
    get: function () {
      var commonVolumeLetter$result;
      commonVolumeLetter$break: do {
        if (this.bytes_8be2vx$.indexOf_598ac7$(SLASH) !== -1) {
          commonVolumeLetter$result = null;
          break commonVolumeLetter$break;
        }if (this.bytes_8be2vx$.size < 2) {
          commonVolumeLetter$result = null;
          break commonVolumeLetter$break;
        }if (this.bytes_8be2vx$.get_za3lpa$(1) !== toByte(58)) {
          commonVolumeLetter$result = null;
          break commonVolumeLetter$break;
        }var c = toChar(this.bytes_8be2vx$.get_za3lpa$(0));
        if (!(new CharRange(97, 122)).contains_mef7kx$(c) && !(new CharRange(65, 90)).contains_mef7kx$(c)) {
          commonVolumeLetter$result = null;
          break commonVolumeLetter$break;
        }commonVolumeLetter$result = c;
      }
       while (false);
      return toBoxedChar(commonVolumeLetter$result);
    }
  });
  Object.defineProperty(Path.prototype, 'nameBytes', {
    configurable: true,
    get: function () {
      var tmp$;
      var lastSlash = get_indexOfLastSlash(this);
      if (lastSlash !== -1)
        tmp$ = this.bytes_8be2vx$.substring_vux9f0$(lastSlash + 1 | 0);
      else if (unboxChar(this.volumeLetter) != null && this.bytes_8be2vx$.size === 2)
        tmp$ = ByteString.Companion.EMPTY;
      else
        tmp$ = this.bytes_8be2vx$;
      return tmp$;
    }
  });
  Object.defineProperty(Path.prototype, 'name', {
    configurable: true,
    get: function () {
      return this.nameBytes.utf8();
    }
  });
  Object.defineProperty(Path.prototype, 'parent', {
    configurable: true,
    get: function () {
      var commonParent$result;
      commonParent$break: do {
        var tmp$, tmp$_0, tmp$_1;
        if (((tmp$ = this.bytes_8be2vx$) != null ? tmp$.equals(DOT) : null) || ((tmp$_0 = this.bytes_8be2vx$) != null ? tmp$_0.equals(SLASH) : null) || ((tmp$_1 = this.bytes_8be2vx$) != null ? tmp$_1.equals(BACKSLASH) : null) || lastSegmentIsDotDot(this)) {
          commonParent$result = null;
          break commonParent$break;
        }var lastSlash = get_indexOfLastSlash(this);
        if (lastSlash === 2 && unboxChar(this.volumeLetter) != null) {
          if (this.bytes_8be2vx$.size === 3) {
            commonParent$result = null;
            break commonParent$break;
          }commonParent$result = new Path(this.bytes_8be2vx$.substring_vux9f0$(void 0, 3));
        } else if (lastSlash === 1 && this.bytes_8be2vx$.startsWith_9ovubf$(BACKSLASH)) {
          commonParent$result = null;
        } else if (lastSlash === -1 && unboxChar(this.volumeLetter) != null) {
          if (this.bytes_8be2vx$.size === 2) {
            commonParent$result = null;
            break commonParent$break;
          }commonParent$result = new Path(this.bytes_8be2vx$.substring_vux9f0$(void 0, 2));
        } else if (lastSlash === -1) {
          commonParent$result = new Path(DOT);
        } else if (lastSlash === 0) {
          commonParent$result = new Path(this.bytes_8be2vx$.substring_vux9f0$(void 0, 1));
        } else {
          commonParent$result = new Path(this.bytes_8be2vx$.substring_vux9f0$(void 0, lastSlash));
        }
      }
       while (false);
      return commonParent$result;
    }
  });
  Object.defineProperty(Path.prototype, 'isRoot', {
    configurable: true,
    get: function () {
      return rootLength(this) === this.bytes_8be2vx$.size;
    }
  });
  Path.prototype.div_61zpoe$ = function (child) {
    return commonResolve_2(this, toPath((new Buffer()).writeUtf8_61zpoe$(child), false), false);
  };
  Path.prototype.div_9ovubf$ = function (child) {
    return commonResolve_2(this, toPath((new Buffer()).write_9ovubf$(child), false), false);
  };
  Path.prototype.div_awoskx$ = function (child) {
    return commonResolve_2(this, child, false);
  };
  Path.prototype.resolve_ivxn3r$ = function (child, normalize) {
    if (normalize === void 0)
      normalize = false;
    return commonResolve_2(this, toPath((new Buffer()).writeUtf8_61zpoe$(child), false), normalize);
  };
  Path.prototype.resolve_rovk7y$ = function (child, normalize) {
    if (normalize === void 0)
      normalize = false;
    return commonResolve_2(this, toPath((new Buffer()).write_9ovubf$(child), false), normalize);
  };
  Path.prototype.resolve_1apv92$ = function (child, normalize) {
    if (normalize === void 0)
      normalize = false;
    return commonResolve_2(this, child, normalize);
  };
  Path.prototype.relativeTo_awoskx$ = function (other) {
    var commonRelativeTo$result;
    commonRelativeTo$break: do {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
      if (!equals(this.root, other.root)) {
        var message = 'Paths of different roots cannot be relative to each other: ' + this + ' and ' + other;
        throw IllegalArgumentException_init(message.toString());
      }var thisSegments = this.segmentsBytes;
      var otherSegments = other.segmentsBytes;
      var firstNewSegmentIndex = 0;
      var a = thisSegments.size;
      var b = otherSegments.size;
      var minSegmentsSize = JsMath.min(a, b);
      while (firstNewSegmentIndex < minSegmentsSize && ((tmp$ = thisSegments.get_za3lpa$(firstNewSegmentIndex)) != null ? tmp$.equals(otherSegments.get_za3lpa$(firstNewSegmentIndex)) : null)) {
        firstNewSegmentIndex = firstNewSegmentIndex + 1 | 0;
      }
      if (firstNewSegmentIndex === minSegmentsSize && this.bytes_8be2vx$.size === other.bytes_8be2vx$.size) {
        commonRelativeTo$result = Path.Companion.toPath_f4dhtg$('.');
        break commonRelativeTo$break;
      }if (!(otherSegments.subList_vux9f0$(firstNewSegmentIndex, otherSegments.size).indexOf_11rb$(DOT_DOT) === -1)) {
        var message_0 = 'Impossible relative path to resolve: ' + this + ' and ' + other;
        throw IllegalArgumentException_init(message_0.toString());
      }var buffer = new Buffer();
      var slash = (tmp$_1 = (tmp$_0 = get_slash(other)) != null ? tmp$_0 : get_slash(this)) != null ? tmp$_1 : toSlash(Path.Companion.DIRECTORY_SEPARATOR);
      tmp$_2 = otherSegments.size;
      for (var i = firstNewSegmentIndex; i < tmp$_2; i++) {
        buffer.write_9ovubf$(DOT_DOT);
        buffer.write_9ovubf$(slash);
      }
      tmp$_3 = thisSegments.size;
      for (var i_0 = firstNewSegmentIndex; i_0 < tmp$_3; i_0++) {
        buffer.write_9ovubf$(thisSegments.get_za3lpa$(i_0));
        buffer.write_9ovubf$(slash);
      }
      commonRelativeTo$result = toPath(buffer, false);
    }
     while (false);
    return commonRelativeTo$result;
  };
  Path.prototype.normalized = function () {
    return Path.Companion.toPath_f4dhtg$(this.toString(), true);
  };
  Path.prototype.compareTo_11rb$ = function (other) {
    return this.bytes_8be2vx$.compareTo_11rb$(other.bytes_8be2vx$);
  };
  Path.prototype.equals = function (other) {
    var tmp$;
    return Kotlin.isType(other, Path) && ((tmp$ = other.bytes_8be2vx$) != null ? tmp$.equals(this.bytes_8be2vx$) : null);
  };
  Path.prototype.hashCode = function () {
    return this.bytes_8be2vx$.hashCode();
  };
  Path.prototype.toString = function () {
    return this.bytes_8be2vx$.utf8();
  };
  function Path$Companion() {
    Path$Companion_instance = this;
    this.DIRECTORY_SEPARATOR = get_PLATFORM_DIRECTORY_SEPARATOR();
  }
  Path$Companion.prototype.toPath_f4dhtg$ = function ($receiver, normalize) {
    if (normalize === void 0)
      normalize = false;
    return commonToPath($receiver, normalize);
  };
  Path$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Path$Companion_instance = null;
  function Path$Companion_getInstance() {
    if (Path$Companion_instance === null) {
      new Path$Companion();
    }return Path$Companion_instance;
  }
  Path.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Path',
    interfaces: [Comparable]
  };
  function RealBufferedSink(sink) {
    this.sink = sink;
    this.closed = false;
    this.buffer_t0ykyg$_0 = new Buffer();
  }
  Object.defineProperty(RealBufferedSink.prototype, 'buffer', {
    configurable: true,
    get: function () {
      return this.buffer_t0ykyg$_0;
    }
  });
  RealBufferedSink.prototype.write_u27jpl$ = function (source, byteCount) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.write_u27jpl$(source, byteCount);
    this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.write_9ovubf$ = function (byteString) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.write_9ovubf$(byteString);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.write_e1lsqj$ = function (byteString, offset, byteCount) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.write_e1lsqj$(byteString, offset, byteCount);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeUtf8_61zpoe$ = function (string) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeUtf8_61zpoe$(string);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeUtf8_3m52m6$ = function (string, beginIndex, endIndex) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeUtf8_3m52m6$(string, beginIndex, endIndex);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeUtf8CodePoint_za3lpa$ = function (codePoint) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeUtf8CodePoint_za3lpa$(codePoint);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.write_fqrh44$ = function (source) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.write_fqrh44$(source);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.write_mj6st8$ = function (source, offset, byteCount) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.write_mj6st8$(source, offset, byteCount);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeAll_sby9nd$ = function (source) {
    var totalBytesRead = L0;
    while (true) {
      var readCount = source.read_u27jpl$(this.buffer, L8192);
      if (equals(readCount, L_1))
        break;
      totalBytesRead = totalBytesRead.add(readCount);
      this.emitCompleteSegments();
    }
    return totalBytesRead;
  };
  RealBufferedSink.prototype.write_9ujt9g$ = function (source, byteCount) {
    var byteCount_0 = byteCount;
    while (byteCount_0.compareTo_11rb$(L0) > 0) {
      var read = source.read_u27jpl$(this.buffer, byteCount_0);
      if (equals(read, L_1))
        throw new EOFException();
      byteCount_0 = byteCount_0.subtract(read);
      this.emitCompleteSegments();
    }
    return this;
  };
  RealBufferedSink.prototype.writeByte_za3lpa$ = function (b) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeByte_za3lpa$(b);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeShort_za3lpa$ = function (s) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeShort_za3lpa$(s);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeShortLe_za3lpa$ = function (s) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeShortLe_za3lpa$(s);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeInt_za3lpa$ = function (i) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeInt_za3lpa$(i);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeIntLe_za3lpa$ = function (i) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeIntLe_za3lpa$(i);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeLong_s8cxhz$ = function (v) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeLong_s8cxhz$(v);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeLongLe_s8cxhz$ = function (v) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeLongLe_s8cxhz$(v);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeDecimalLong_s8cxhz$ = function (v) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeDecimalLong_s8cxhz$(v);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.writeHexadecimalUnsignedLong_s8cxhz$ = function (v) {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }this.buffer.writeHexadecimalUnsignedLong_s8cxhz$(v);
    return this.emitCompleteSegments();
  };
  RealBufferedSink.prototype.emitCompleteSegments = function () {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }var byteCount = this.buffer.completeSegmentByteCount();
    if (byteCount.compareTo_11rb$(L0) > 0)
      this.sink.write_u27jpl$(this.buffer, byteCount);
    return this;
  };
  RealBufferedSink.prototype.emit = function () {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }var byteCount = this.buffer.size;
    if (byteCount.compareTo_11rb$(L0) > 0)
      this.sink.write_u27jpl$(this.buffer, byteCount);
    return this;
  };
  RealBufferedSink.prototype.flush = function () {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }if (this.buffer.size.compareTo_11rb$(L0) > 0) {
      this.sink.write_u27jpl$(this.buffer, this.buffer.size);
    }this.sink.flush();
  };
  RealBufferedSink.prototype.close = function () {
    commonClose$break: do {
      if (this.closed)
        break commonClose$break;
      var thrown = null;
      try {
        if (this.buffer.size.toNumber() > 0) {
          this.sink.write_u27jpl$(this.buffer, this.buffer.size);
        }} catch (e) {
        if (Kotlin.isType(e, Throwable)) {
          thrown = e;
        } else
          throw e;
      }
      try {
        this.sink.close();
      } catch (e_0) {
        if (Kotlin.isType(e_0, Throwable)) {
          if (thrown == null)
            thrown = e_0;
        } else
          throw e_0;
      }
      this.closed = true;
      if (thrown != null)
        throw thrown;
    }
     while (false);
  };
  RealBufferedSink.prototype.timeout = function () {
    return this.sink.timeout();
  };
  RealBufferedSink.prototype.toString = function () {
    return 'buffer(' + this.sink + ')';
  };
  RealBufferedSink.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealBufferedSink',
    interfaces: [BufferedSink]
  };
  function RealBufferedSource(source) {
    this.source = source;
    this.closed = false;
    this.buffer_4j4w9c$_0 = new Buffer();
  }
  Object.defineProperty(RealBufferedSource.prototype, 'buffer', {
    configurable: true,
    get: function () {
      return this.buffer_4j4w9c$_0;
    }
  });
  RealBufferedSource.prototype.read_u27jpl$ = function (sink, byteCount) {
    var commonRead$result;
    commonRead$break: do {
      if (!(byteCount.compareTo_11rb$(L0) >= 0)) {
        var message = 'byteCount < 0: ' + byteCount.toString();
        throw IllegalArgumentException_init(message.toString());
      }if (!!this.closed) {
        var message_0 = 'closed';
        throw IllegalStateException_init(message_0.toString());
      }if (equals(this.buffer.size, L0)) {
        var read = this.source.read_u27jpl$(this.buffer, L8192);
        if (equals(read, L_1)) {
          commonRead$result = L_1;
          break commonRead$break;
        }}var b = this.buffer.size;
      var toRead = byteCount.compareTo_11rb$(b) <= 0 ? byteCount : b;
      commonRead$result = this.buffer.read_u27jpl$(sink, toRead);
    }
     while (false);
    return commonRead$result;
  };
  RealBufferedSource.prototype.exhausted = function () {
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }return this.buffer.exhausted() && equals(this.source.read_u27jpl$(this.buffer, L8192), L_1);
  };
  RealBufferedSource.prototype.require_s8cxhz$ = function (byteCount) {
    if (!this.request_s8cxhz$(byteCount))
      throw new EOFException();
  };
  RealBufferedSource.prototype.request_s8cxhz$ = function (byteCount) {
    var commonRequest$result;
    commonRequest$break: do {
      if (!(byteCount.compareTo_11rb$(L0) >= 0)) {
        var message = 'byteCount < 0: ' + byteCount.toString();
        throw IllegalArgumentException_init(message.toString());
      }if (!!this.closed) {
        var message_0 = 'closed';
        throw IllegalStateException_init(message_0.toString());
      }while (this.buffer.size.compareTo_11rb$(byteCount) < 0) {
        if (equals(this.source.read_u27jpl$(this.buffer, L8192), L_1)) {
          commonRequest$result = false;
          break commonRequest$break;
        }}
      commonRequest$result = true;
    }
     while (false);
    return commonRequest$result;
  };
  RealBufferedSource.prototype.readByte = function () {
    this.require_s8cxhz$(L1);
    return this.buffer.readByte();
  };
  RealBufferedSource.prototype.readByteString = function () {
    this.buffer.writeAll_sby9nd$(this.source);
    return this.buffer.readByteString();
  };
  RealBufferedSource.prototype.readByteString_s8cxhz$ = function (byteCount) {
    this.require_s8cxhz$(byteCount);
    return this.buffer.readByteString_s8cxhz$(byteCount);
  };
  RealBufferedSource.prototype.select_d5ae7i$ = function (options) {
    var commonSelect$result;
    commonSelect$break: do {
      if (!!this.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }while (true) {
        var index = selectPrefix(this.buffer, options, true);
        switch (index) {
          case -1:
            commonSelect$result = -1;
            break commonSelect$break;
          case -2:
            if (equals(this.source.read_u27jpl$(this.buffer, L8192), L_1)) {
              commonSelect$result = -1;
              break commonSelect$break;
            }
            break;
          default:var selectedSize = options.byteStrings_8be2vx$[index].size;
            this.buffer.skip_s8cxhz$(Kotlin.Long.fromInt(selectedSize));
            commonSelect$result = index;
            break commonSelect$break;
        }
      }
    }
     while (false);
    return commonSelect$result;
  };
  RealBufferedSource.prototype.readByteArray = function () {
    this.buffer.writeAll_sby9nd$(this.source);
    return this.buffer.readByteArray();
  };
  RealBufferedSource.prototype.readByteArray_s8cxhz$ = function (byteCount) {
    this.require_s8cxhz$(byteCount);
    return this.buffer.readByteArray_s8cxhz$(byteCount);
  };
  RealBufferedSource.prototype.read_fqrh44$ = function (sink) {
    return this.read_mj6st8$(sink, 0, sink.length);
  };
  RealBufferedSource.prototype.readFully_fqrh44$ = function (sink) {
    try {
      this.require_s8cxhz$(Kotlin.Long.fromInt(sink.length));
    } catch (e) {
      if (Kotlin.isType(e, EOFException)) {
        var offset = 0;
        while (this.buffer.size.compareTo_11rb$(L0) > 0) {
          var read = this.buffer.read_mj6st8$(sink, offset, this.buffer.size.toInt());
          if (read === -1)
            throw AssertionError_init_0();
          offset = offset + read | 0;
        }
        throw e;
      } else
        throw e;
    }
    this.buffer.readFully_fqrh44$(sink);
  };
  RealBufferedSource.prototype.read_mj6st8$ = function (sink, offset, byteCount) {
    var commonRead$result;
    commonRead$break: do {
      checkOffsetAndCount(Kotlin.Long.fromInt(sink.length), Kotlin.Long.fromInt(offset), Kotlin.Long.fromInt(byteCount));
      if (equals(this.buffer.size, L0)) {
        var read = this.source.read_u27jpl$(this.buffer, L8192);
        if (equals(read, L_1)) {
          commonRead$result = -1;
          break commonRead$break;
        }}var b = this.buffer.size;
      var a = Kotlin.Long.fromInt(byteCount);
      var toRead = (a.compareTo_11rb$(b) <= 0 ? a : b).toInt();
      commonRead$result = this.buffer.read_mj6st8$(sink, offset, toRead);
    }
     while (false);
    return commonRead$result;
  };
  RealBufferedSource.prototype.readFully_u27jpl$ = function (sink, byteCount) {
    try {
      this.require_s8cxhz$(byteCount);
    } catch (e) {
      if (Kotlin.isType(e, EOFException)) {
        sink.writeAll_sby9nd$(this.buffer);
        throw e;
      } else
        throw e;
    }
    this.buffer.readFully_u27jpl$(sink, byteCount);
  };
  RealBufferedSource.prototype.readAll_awqvbz$ = function (sink) {
    var totalBytesWritten = L0;
    while (!equals(this.source.read_u27jpl$(this.buffer, L8192), L_1)) {
      var emitByteCount = this.buffer.completeSegmentByteCount();
      if (emitByteCount.compareTo_11rb$(L0) > 0) {
        totalBytesWritten = totalBytesWritten.add(emitByteCount);
        sink.write_u27jpl$(this.buffer, emitByteCount);
      }}
    if (this.buffer.size.compareTo_11rb$(L0) > 0) {
      totalBytesWritten = totalBytesWritten.add(this.buffer.size);
      sink.write_u27jpl$(this.buffer, this.buffer.size);
    }return totalBytesWritten;
  };
  RealBufferedSource.prototype.readUtf8 = function () {
    this.buffer.writeAll_sby9nd$(this.source);
    return this.buffer.readUtf8();
  };
  RealBufferedSource.prototype.readUtf8_s8cxhz$ = function (byteCount) {
    this.require_s8cxhz$(byteCount);
    return this.buffer.readUtf8_s8cxhz$(byteCount);
  };
  RealBufferedSource.prototype.readUtf8Line = function () {
    var tmp$;
    var newline = this.indexOf_s8j3t7$(toByte(10));
    if (equals(newline, L_1)) {
      if (!equals(this.buffer.size, L0)) {
        tmp$ = this.readUtf8_s8cxhz$(this.buffer.size);
      } else {
        tmp$ = null;
      }
    } else {
      tmp$ = readUtf8Line(this.buffer, newline);
    }
    return tmp$;
  };
  RealBufferedSource.prototype.readUtf8LineStrict = function () {
    return this.readUtf8LineStrict_s8cxhz$(Long$Companion$MAX_VALUE);
  };
  RealBufferedSource.prototype.readUtf8LineStrict_s8cxhz$ = function (limit) {
    var commonReadUtf8LineStrict$result;
    commonReadUtf8LineStrict$break: do {
      if (!(limit.toNumber() >= 0)) {
        var message = 'limit < 0: ' + limit.toString();
        throw IllegalArgumentException_init(message.toString());
      }var scanLength = equals(limit, Long$Companion$MAX_VALUE) ? Long$Companion$MAX_VALUE : limit.add(Kotlin.Long.fromInt(1));
      var newline = this.indexOf_mfonpt$(toByte(10), L0, scanLength);
      if (!equals(newline, L_1)) {
        commonReadUtf8LineStrict$result = readUtf8Line(this.buffer, newline);
        break commonReadUtf8LineStrict$break;
      }if (scanLength.compareTo_11rb$(Long$Companion$MAX_VALUE) < 0 && this.request_s8cxhz$(scanLength) && this.buffer.get_s8cxhz$(scanLength.subtract(Kotlin.Long.fromInt(1))) === toByte(13) && this.request_s8cxhz$(scanLength.add(Kotlin.Long.fromInt(1))) && this.buffer.get_s8cxhz$(scanLength) === toByte(10)) {
        commonReadUtf8LineStrict$result = readUtf8Line(this.buffer, scanLength);
        break commonReadUtf8LineStrict$break;
      }var data = new Buffer();
      var tmp$ = this.buffer;
      var tmp$_0 = L0;
      var b = this.buffer.size;
      var a = Kotlin.Long.fromInt(32);
      tmp$.copyTo_ins7gm$(data, tmp$_0, a.compareTo_11rb$(b) <= 0 ? a : b);
      var a_0 = this.buffer.size;
      throw new EOFException('\\n not found: limit=' + toString(a_0.compareTo_11rb$(limit) <= 0 ? a_0 : limit) + ' content=' + data.readByteString().hex() + String.fromCharCode(8230));
    }
     while (false);
    return commonReadUtf8LineStrict$result;
  };
  RealBufferedSource.prototype.readUtf8CodePoint = function () {
    this.require_s8cxhz$(L1);
    var b0 = this.buffer.get_s8cxhz$(L0);
    if ((b0 & 224) === 192)
      this.require_s8cxhz$(L2);
    else if ((b0 & 240) === 224)
      this.require_s8cxhz$(L3);
    else if ((b0 & 248) === 240)
      this.require_s8cxhz$(L4);
    return this.buffer.readUtf8CodePoint();
  };
  RealBufferedSource.prototype.readShort = function () {
    this.require_s8cxhz$(L2);
    return this.buffer.readShort();
  };
  RealBufferedSource.prototype.readShortLe = function () {
    this.require_s8cxhz$(L2);
    return this.buffer.readShortLe();
  };
  RealBufferedSource.prototype.readInt = function () {
    this.require_s8cxhz$(L4);
    return this.buffer.readInt();
  };
  RealBufferedSource.prototype.readIntLe = function () {
    this.require_s8cxhz$(L4);
    return this.buffer.readIntLe();
  };
  RealBufferedSource.prototype.readLong = function () {
    this.require_s8cxhz$(L8);
    return this.buffer.readLong();
  };
  RealBufferedSource.prototype.readLongLe = function () {
    this.require_s8cxhz$(L8);
    return this.buffer.readLongLe();
  };
  RealBufferedSource.prototype.readDecimalLong = function () {
    this.require_s8cxhz$(L1);
    var pos = L0;
    while (this.request_s8cxhz$(pos.add(Kotlin.Long.fromInt(1)))) {
      var b = this.buffer.get_s8cxhz$(pos);
      if ((b < toByte(48) || b > toByte(57)) && (!equals(pos, L0) || b !== toByte(45))) {
        if (equals(pos, L0)) {
          throw new NumberFormatException_init("Expected a digit or '-' but was 0x" + toString_0(b, 16));
        }break;
      }pos = pos.inc();
    }
    return this.buffer.readDecimalLong();
  };
  RealBufferedSource.prototype.readHexadecimalUnsignedLong = function () {
    this.require_s8cxhz$(L1);
    var pos = 0;
    while (this.request_s8cxhz$(Kotlin.Long.fromInt(pos + 1 | 0))) {
      var b = this.buffer.get_s8cxhz$(Kotlin.Long.fromInt(pos));
      if ((b < toByte(48) || b > toByte(57)) && (b < toByte(97) || b > toByte(102)) && (b < toByte(65) || b > toByte(70))) {
        if (pos === 0) {
          throw new NumberFormatException_init('Expected leading [0-9a-fA-F] character but was 0x' + toString_0(b, 16));
        }break;
      }pos = pos + 1 | 0;
    }
    return this.buffer.readHexadecimalUnsignedLong();
  };
  RealBufferedSource.prototype.skip_s8cxhz$ = function (byteCount) {
    var byteCount_0 = byteCount;
    if (!!this.closed) {
      var message = 'closed';
      throw IllegalStateException_init(message.toString());
    }while (byteCount_0.toNumber() > 0) {
      if (equals(this.buffer.size, L0) && equals(this.source.read_u27jpl$(this.buffer, L8192), L_1)) {
        throw new EOFException();
      }var a = byteCount_0;
      var b = this.buffer.size;
      var toSkip = a.compareTo_11rb$(b) <= 0 ? a : b;
      this.buffer.skip_s8cxhz$(toSkip);
      byteCount_0 = byteCount_0.subtract(toSkip);
    }
  };
  RealBufferedSource.prototype.indexOf_s8j3t7$ = function (b) {
    return this.indexOf_mfonpt$(b, L0, Long$Companion$MAX_VALUE);
  };
  RealBufferedSource.prototype.indexOf_5gjupe$ = function (b, fromIndex) {
    return this.indexOf_mfonpt$(b, fromIndex, Long$Companion$MAX_VALUE);
  };
  RealBufferedSource.prototype.indexOf_mfonpt$ = function (b, fromIndex, toIndex) {
    var commonIndexOf$result;
    commonIndexOf$break: do {
      var tmp$;
      var fromIndex_0 = {v: fromIndex};
      if (!!this.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }tmp$ = fromIndex_0.v;
      if (!(L0.lessThanOrEqual(tmp$) && tmp$.lessThanOrEqual(toIndex))) {
        var message_0 = 'fromIndex=' + fromIndex_0.v.toString() + ' toIndex=' + toIndex.toString();
        throw IllegalArgumentException_init(message_0.toString());
      }while (fromIndex_0.v.compareTo_11rb$(toIndex) < 0) {
        var result = this.buffer.indexOf_mfonpt$(b, fromIndex_0.v, toIndex);
        if (!equals(result, L_1)) {
          commonIndexOf$result = result;
          break commonIndexOf$break;
        }var lastBufferSize = this.buffer.size;
        if (lastBufferSize.compareTo_11rb$(toIndex) >= 0 || equals(this.source.read_u27jpl$(this.buffer, L8192), L_1)) {
          commonIndexOf$result = L_1;
          break commonIndexOf$break;
        }var a = fromIndex_0.v;
        fromIndex_0.v = a.compareTo_11rb$(lastBufferSize) >= 0 ? a : lastBufferSize;
      }
      commonIndexOf$result = L_1;
    }
     while (false);
    return commonIndexOf$result;
  };
  RealBufferedSource.prototype.indexOf_9ovubf$ = function (bytes) {
    return this.indexOf_kvuuwu$(bytes, L0);
  };
  RealBufferedSource.prototype.indexOf_kvuuwu$ = function (bytes, fromIndex) {
    var commonIndexOf$result;
    commonIndexOf$break: do {
      var fromIndex_0 = fromIndex;
      if (!!this.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }while (true) {
        var result = this.buffer.indexOf_kvuuwu$(bytes, fromIndex_0);
        if (!equals(result, L_1)) {
          commonIndexOf$result = result;
          break commonIndexOf$break;
        }var lastBufferSize = this.buffer.size;
        if (equals(this.source.read_u27jpl$(this.buffer, L8192), L_1)) {
          commonIndexOf$result = L_1;
          break commonIndexOf$break;
        }var a = fromIndex_0;
        var b = lastBufferSize.subtract(Kotlin.Long.fromInt(bytes.size)).add(Kotlin.Long.fromInt(1));
        fromIndex_0 = a.compareTo_11rb$(b) >= 0 ? a : b;
      }
    }
     while (false);
    return commonIndexOf$result;
  };
  RealBufferedSource.prototype.indexOfElement_9ovubf$ = function (targetBytes) {
    return this.indexOfElement_kvuuwu$(targetBytes, L0);
  };
  RealBufferedSource.prototype.indexOfElement_kvuuwu$ = function (targetBytes, fromIndex) {
    var commonIndexOfElement$result;
    commonIndexOfElement$break: do {
      var fromIndex_0 = fromIndex;
      if (!!this.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }while (true) {
        var result = this.buffer.indexOfElement_kvuuwu$(targetBytes, fromIndex_0);
        if (!equals(result, L_1)) {
          commonIndexOfElement$result = result;
          break commonIndexOfElement$break;
        }var lastBufferSize = this.buffer.size;
        if (equals(this.source.read_u27jpl$(this.buffer, L8192), L_1)) {
          commonIndexOfElement$result = L_1;
          break commonIndexOfElement$break;
        }var a = fromIndex_0;
        fromIndex_0 = a.compareTo_11rb$(lastBufferSize) >= 0 ? a : lastBufferSize;
      }
    }
     while (false);
    return commonIndexOfElement$result;
  };
  RealBufferedSource.prototype.rangeEquals_2rh7jy$ = function (offset, bytes) {
    return this.rangeEquals_k1jc8u$(offset, bytes, 0, bytes.size);
  };
  RealBufferedSource.prototype.rangeEquals_k1jc8u$ = function (offset, bytes, bytesOffset, byteCount) {
    var commonRangeEquals$result;
    commonRangeEquals$break: do {
      if (!!this.closed) {
        var message = 'closed';
        throw IllegalStateException_init(message.toString());
      }if (offset.compareTo_11rb$(L0) < 0 || bytesOffset < 0 || byteCount < 0 || (bytes.size - bytesOffset | 0) < byteCount) {
        commonRangeEquals$result = false;
        break commonRangeEquals$break;
      }for (var i = 0; i < byteCount; i++) {
        var bufferOffset = offset.add(Kotlin.Long.fromInt(i));
        if (!this.request_s8cxhz$(bufferOffset.add(Kotlin.Long.fromInt(1)))) {
          commonRangeEquals$result = false;
          break commonRangeEquals$break;
        }if (this.buffer.get_s8cxhz$(bufferOffset) !== bytes.get_za3lpa$(bytesOffset + i | 0)) {
          commonRangeEquals$result = false;
          break commonRangeEquals$break;
        }}
      commonRangeEquals$result = true;
    }
     while (false);
    return commonRangeEquals$result;
  };
  RealBufferedSource.prototype.peek = function () {
    return buffer(new PeekSource(this));
  };
  RealBufferedSource.prototype.close = function () {
    commonClose$break: do {
      if (this.closed)
        break commonClose$break;
      this.closed = true;
      this.source.close();
      this.buffer.clear();
    }
     while (false);
  };
  RealBufferedSource.prototype.timeout = function () {
    return this.source.timeout();
  };
  RealBufferedSource.prototype.toString = function () {
    return 'buffer(' + this.source + ')';
  };
  RealBufferedSource.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RealBufferedSource',
    interfaces: [BufferedSource]
  };
  function SegmentPool() {
    SegmentPool_instance = this;
    this.MAX_SIZE = 0;
    this.byteCount = 0;
  }
  SegmentPool.prototype.take = function () {
    return Segment_init();
  };
  SegmentPool.prototype.recycle_uve4t5$ = function (segment) {
  };
  SegmentPool.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'SegmentPool',
    interfaces: []
  };
  var SegmentPool_instance = null;
  function SegmentPool_getInstance() {
    if (SegmentPool_instance === null) {
      new SegmentPool();
    }return SegmentPool_instance;
  }
  var commonToByteArray$lambda = wrapFunction(function () {
    var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
    return function (closure$result, closure$resultPos) {
      return function (data, offset, byteCount) {
        arrayCopy(data, closure$result, closure$resultPos.v, offset, offset + byteCount | 0);
        closure$resultPos.v = closure$resultPos.v + byteCount | 0;
        return Unit;
      };
    };
  });
  var commonCopyInto$lambda = wrapFunction(function () {
    var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
    return function (closure$target, closure$targetOffset) {
      return function (data, offset, byteCount) {
        arrayCopy(data, closure$target, closure$targetOffset.v, offset, offset + byteCount | 0);
        closure$targetOffset.v = closure$targetOffset.v + byteCount | 0;
        return Unit;
      };
    };
  });
  function SegmentedByteString(segments, directory) {
    ByteString.call(this, ByteString$Companion_getInstance().EMPTY.data_8be2vx$);
    this.segments_8be2vx$ = segments;
    this.directory_8be2vx$ = directory;
  }
  SegmentedByteString.prototype.base64 = function () {
    return this.toByteString_0().base64();
  };
  SegmentedByteString.prototype.hex = function () {
    return this.toByteString_0().hex();
  };
  SegmentedByteString.prototype.toAsciiLowercase = function () {
    return this.toByteString_0().toAsciiLowercase();
  };
  SegmentedByteString.prototype.toAsciiUppercase = function () {
    return this.toByteString_0().toAsciiUppercase();
  };
  SegmentedByteString.prototype.base64Url = function () {
    return this.toByteString_0().base64Url();
  };
  SegmentedByteString.prototype.substring_vux9f0$$default = function (beginIndex, endIndex) {
    var commonSubstring$result;
    commonSubstring$break: do {
      var tmp$;
      var endIndex_0 = resolveDefaultParameter_0(this, endIndex);
      if (!(beginIndex >= 0)) {
        var message = 'beginIndex=' + beginIndex + ' < 0';
        throw IllegalArgumentException_init(message.toString());
      }if (!(endIndex_0 <= this.size)) {
        var message_0 = 'endIndex=' + endIndex_0 + ' > length(' + this.size + ')';
        throw IllegalArgumentException_init(message_0.toString());
      }var subLen = endIndex_0 - beginIndex | 0;
      if (!(subLen >= 0)) {
        var message_1 = 'endIndex=' + endIndex_0 + ' < beginIndex=' + beginIndex;
        throw IllegalArgumentException_init(message_1.toString());
      }if (beginIndex === 0 && endIndex_0 === this.size) {
        commonSubstring$result = this;
        break commonSubstring$break;
      } else if (beginIndex === endIndex_0) {
        commonSubstring$result = ByteString.Companion.EMPTY;
        break commonSubstring$break;
      }var beginSegment = segment(this, beginIndex);
      var endSegment = segment(this, endIndex_0 - 1 | 0);
      var newSegments = copyOfRange_0(this.segments_8be2vx$, beginSegment, endSegment + 1 | 0);
      var newDirectory = new Int32Array(newSegments.length * 2 | 0);
      var index = 0;
      for (var s = beginSegment; s <= endSegment; s++) {
        var a = this.directory_8be2vx$[s] - beginIndex | 0;
        newDirectory[index] = JsMath.min(a, subLen);
        newDirectory[(tmp$ = index, index = tmp$ + 1 | 0, tmp$) + newSegments.length | 0] = this.directory_8be2vx$[s + this.segments_8be2vx$.length | 0];
      }
      var segmentOffset = beginSegment === 0 ? 0 : this.directory_8be2vx$[beginSegment - 1 | 0];
      newDirectory[newSegments.length] = newDirectory[newSegments.length] + (beginIndex - segmentOffset) | 0;
      commonSubstring$result = new SegmentedByteString(newSegments, newDirectory);
    }
     while (false);
    return commonSubstring$result;
  };
  SegmentedByteString.prototype.internalGet_za3lpa$ = function (pos) {
    checkOffsetAndCount(Kotlin.Long.fromInt(this.directory_8be2vx$[this.segments_8be2vx$.length - 1 | 0]), Kotlin.Long.fromInt(pos), L1);
    var segment_0 = segment(this, pos);
    var segmentOffset = segment_0 === 0 ? 0 : this.directory_8be2vx$[segment_0 - 1 | 0];
    var segmentPos = this.directory_8be2vx$[segment_0 + this.segments_8be2vx$.length | 0];
    return this.segments_8be2vx$[segment_0][pos - segmentOffset + segmentPos | 0];
  };
  SegmentedByteString.prototype.getSize = function () {
    return this.directory_8be2vx$[this.segments_8be2vx$.length - 1 | 0];
  };
  SegmentedByteString.prototype.toByteArray = function () {
    var result = new Int8Array(this.size);
    var resultPos = {v: 0};
    var segmentCount = this.segments_8be2vx$.length;
    var s = 0;
    var pos = 0;
    while (s < segmentCount) {
      var segmentPos = this.directory_8be2vx$[segmentCount + s | 0];
      var nextSegmentOffset = this.directory_8be2vx$[s];
      var byteCount = nextSegmentOffset - pos | 0;
      arrayCopy(this.segments_8be2vx$[s], result, resultPos.v, segmentPos, segmentPos + byteCount | 0);
      resultPos.v = resultPos.v + byteCount | 0;
      pos = nextSegmentOffset;
      s = s + 1 | 0;
    }
    return result;
  };
  SegmentedByteString.prototype.write_zfhfyk$ = function (buffer, offset, byteCount) {
    var endIndex = offset + byteCount | 0;
    var s = segment(this, offset);
    var pos = offset;
    while (pos < endIndex) {
      var segmentOffset = s === 0 ? 0 : this.directory_8be2vx$[s - 1 | 0];
      var segmentSize = this.directory_8be2vx$[s] - segmentOffset | 0;
      var segmentPos = this.directory_8be2vx$[this.segments_8be2vx$.length + s | 0];
      var b = segmentOffset + segmentSize | 0;
      var byteCount_0 = JsMath.min(endIndex, b) - pos | 0;
      var offset_0 = segmentPos + (pos - segmentOffset) | 0;
      var segment_0 = Segment_init_0(this.segments_8be2vx$[s], offset_0, offset_0 + byteCount_0 | 0, true, false);
      if (buffer.head_8be2vx$ == null) {
        segment_0.prev = segment_0;
        segment_0.next = segment_0.prev;
        buffer.head_8be2vx$ = segment_0.next;
      } else {
        ensureNotNull(ensureNotNull(buffer.head_8be2vx$).prev).push_uve4t5$(segment_0);
      }
      pos = pos + byteCount_0 | 0;
      s = s + 1 | 0;
    }
    buffer.size = buffer.size.add(Kotlin.Long.fromInt(byteCount));
  };
  SegmentedByteString.prototype.rangeEquals_kxw41n$ = function (offset, other, otherOffset, byteCount) {
    var commonRangeEquals$result;
    commonRangeEquals$break: do {
      if (offset < 0 || offset > (this.size - byteCount | 0)) {
        commonRangeEquals$result = false;
        break commonRangeEquals$break;
      }var otherOffset_0 = {v: otherOffset};
      var endIndex = offset + byteCount | 0;
      var s = segment(this, offset);
      var pos = offset;
      while (pos < endIndex) {
        var segmentOffset = s === 0 ? 0 : this.directory_8be2vx$[s - 1 | 0];
        var segmentSize = this.directory_8be2vx$[s] - segmentOffset | 0;
        var segmentPos = this.directory_8be2vx$[this.segments_8be2vx$.length + s | 0];
        var b = segmentOffset + segmentSize | 0;
        var byteCount_0 = JsMath.min(endIndex, b) - pos | 0;
        var offset_0 = segmentPos + (pos - segmentOffset) | 0;
        if (!other.rangeEquals_3fge6q$(otherOffset_0.v, this.segments_8be2vx$[s], offset_0, byteCount_0)) {
          commonRangeEquals$result = false;
          break commonRangeEquals$break;
        }otherOffset_0.v = otherOffset_0.v + byteCount_0 | 0;
        pos = pos + byteCount_0 | 0;
        s = s + 1 | 0;
      }
      commonRangeEquals$result = true;
    }
     while (false);
    return commonRangeEquals$result;
  };
  SegmentedByteString.prototype.rangeEquals_3fge6q$ = function (offset, other, otherOffset, byteCount) {
    var commonRangeEquals$result;
    commonRangeEquals$break: do {
      if (offset < 0 || offset > (this.size - byteCount | 0) || otherOffset < 0 || otherOffset > (other.length - byteCount | 0)) {
        commonRangeEquals$result = false;
        break commonRangeEquals$break;
      }var otherOffset_0 = {v: otherOffset};
      var endIndex = offset + byteCount | 0;
      var s = segment(this, offset);
      var pos = offset;
      while (pos < endIndex) {
        var segmentOffset = s === 0 ? 0 : this.directory_8be2vx$[s - 1 | 0];
        var segmentSize = this.directory_8be2vx$[s] - segmentOffset | 0;
        var segmentPos = this.directory_8be2vx$[this.segments_8be2vx$.length + s | 0];
        var b = segmentOffset + segmentSize | 0;
        var byteCount_0 = JsMath.min(endIndex, b) - pos | 0;
        var offset_0 = segmentPos + (pos - segmentOffset) | 0;
        if (!arrayRangeEquals(this.segments_8be2vx$[s], offset_0, other, otherOffset_0.v, byteCount_0)) {
          commonRangeEquals$result = false;
          break commonRangeEquals$break;
        }otherOffset_0.v = otherOffset_0.v + byteCount_0 | 0;
        pos = pos + byteCount_0 | 0;
        s = s + 1 | 0;
      }
      commonRangeEquals$result = true;
    }
     while (false);
    return commonRangeEquals$result;
  };
  SegmentedByteString.prototype.copyInto_3fge6q$$default = function (offset, target, targetOffset, byteCount) {
    checkOffsetAndCount(Kotlin.Long.fromInt(this.size), Kotlin.Long.fromInt(offset), Kotlin.Long.fromInt(byteCount));
    checkOffsetAndCount(Kotlin.Long.fromInt(target.length), Kotlin.Long.fromInt(targetOffset), Kotlin.Long.fromInt(byteCount));
    var targetOffset_0 = {v: targetOffset};
    var endIndex = offset + byteCount | 0;
    var s = segment(this, offset);
    var pos = offset;
    while (pos < endIndex) {
      var segmentOffset = s === 0 ? 0 : this.directory_8be2vx$[s - 1 | 0];
      var segmentSize = this.directory_8be2vx$[s] - segmentOffset | 0;
      var segmentPos = this.directory_8be2vx$[this.segments_8be2vx$.length + s | 0];
      var b = segmentOffset + segmentSize | 0;
      var byteCount_0 = JsMath.min(endIndex, b) - pos | 0;
      var offset_0 = segmentPos + (pos - segmentOffset) | 0;
      arrayCopy(this.segments_8be2vx$[s], target, targetOffset_0.v, offset_0, offset_0 + byteCount_0 | 0);
      targetOffset_0.v = targetOffset_0.v + byteCount_0 | 0;
      pos = pos + byteCount_0 | 0;
      s = s + 1 | 0;
    }
  };
  SegmentedByteString.prototype.indexOf_ir89t6$$default = function (other, fromIndex) {
    return this.toByteString_0().indexOf_ir89t6$(other, fromIndex);
  };
  SegmentedByteString.prototype.lastIndexOf_ir89t6$$default = function (other, fromIndex) {
    return this.toByteString_0().lastIndexOf_ir89t6$(other, fromIndex);
  };
  SegmentedByteString.prototype.digest_8td9e3$ = function (hashFunction) {
    var segmentCount = this.segments_8be2vx$.length;
    var s = 0;
    var pos = 0;
    while (s < segmentCount) {
      var segmentPos = this.directory_8be2vx$[segmentCount + s | 0];
      var nextSegmentOffset = this.directory_8be2vx$[s];
      hashFunction.update_mj6st8$(this.segments_8be2vx$[s], segmentPos, nextSegmentOffset - pos | 0);
      pos = nextSegmentOffset;
      s = s + 1 | 0;
    }
    var digestBytes = hashFunction.digest();
    return new ByteString(digestBytes);
  };
  SegmentedByteString.prototype.toByteString_0 = function () {
    return new ByteString(this.toByteArray());
  };
  SegmentedByteString.prototype.internalArray = function () {
    return this.toByteArray();
  };
  SegmentedByteString.prototype.equals = function (other) {
    var tmp$;
    if (other === this)
      tmp$ = true;
    else if (Kotlin.isType(other, ByteString))
      tmp$ = (other.size === this.size && this.rangeEquals_kxw41n$(0, other, 0, this.size));
    else
      tmp$ = false;
    return tmp$;
  };
  SegmentedByteString.prototype.hashCode = function () {
    var commonHashCode$result;
    commonHashCode$break: do {
      var result = {v: this.hashCode_8be2vx$};
      if (result.v !== 0) {
        commonHashCode$result = result.v;
        break commonHashCode$break;
      }result.v = 1;
      var segmentCount = this.segments_8be2vx$.length;
      var s = 0;
      var pos = 0;
      while (s < segmentCount) {
        var segmentPos = this.directory_8be2vx$[segmentCount + s | 0];
        var nextSegmentOffset = this.directory_8be2vx$[s];
        var data = this.segments_8be2vx$[s];
        var i = segmentPos;
        var limit = segmentPos + (nextSegmentOffset - pos | 0) | 0;
        while (i < limit) {
          result.v = (31 * result.v | 0) + data[i];
          i = i + 1 | 0;
        }
        pos = nextSegmentOffset;
        s = s + 1 | 0;
      }
      this.hashCode_8be2vx$ = result.v;
      commonHashCode$result = result.v;
    }
     while (false);
    return commonHashCode$result;
  };
  SegmentedByteString.prototype.toString = function () {
    return this.toByteString_0().toString();
  };
  SegmentedByteString.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SegmentedByteString',
    interfaces: [ByteString]
  };
  function Sink() {
  }
  Sink.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Sink',
    interfaces: [Closeable]
  };
  function Timeout() {
    Timeout$Companion_getInstance();
  }
  function Timeout$Companion() {
    Timeout$Companion_instance = this;
    this.NONE = new Timeout();
  }
  Timeout$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Timeout$Companion_instance = null;
  function Timeout$Companion_getInstance() {
    if (Timeout$Companion_instance === null) {
      new Timeout$Companion();
    }return Timeout$Companion_instance;
  }
  Timeout.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Timeout',
    interfaces: []
  };
  var package$okio = _.okio || (_.okio = {});
  Object.defineProperty(package$okio, 'BASE64_8be2vx$', {
    get: function () {
      return BASE64;
    }
  });
  Object.defineProperty(package$okio, 'BASE64_URL_SAFE_8be2vx$', {
    get: function () {
      return BASE64_URL_SAFE;
    }
  });
  package$okio.decodeBase64ToArray_7efafi$ = decodeBase64ToArray;
  package$okio.encodeBase64_q2fl5a$ = encodeBase64;
  package$okio.checkOffsetAndCount_e84ct6$ = checkOffsetAndCount;
  package$okio.reverseBytes_ybd44d$ = reverseBytes;
  package$okio.reverseBytes_8e50z4$ = reverseBytes_0;
  package$okio.reverseBytes_nzsbcz$ = reverseBytes_1;
  package$okio.leftRotate_b6l1hq$ = leftRotate;
  package$okio.rightRotate_raukh1$ = rightRotate;
  package$okio.shr_g525uh$ = shr;
  package$okio.shl_g525uh$ = shl;
  package$okio.and_g525uh$ = and;
  package$okio.and_354l1u$ = and_0;
  package$okio.xor_34yeqm$ = xor;
  package$okio.and_8hhx95$ = and_1;
  package$okio.minOf_plstum$ = minOf;
  package$okio.minOf_22xunw$ = minOf_0;
  package$okio.arrayRangeEquals_lwkm2r$ = arrayRangeEquals;
  $$importsForInline$$['okio-parent-okio-js-legacy'] = _;
  package$okio.toHexString_nugvp3$ = toHexString;
  package$okio.toHexString_8e50z4$ = toHexString_0;
  package$okio.toHexString_nzsbcz$ = toHexString_1;
  Object.defineProperty(package$okio, 'DEFAULT__new_UnsafeCursor_8be2vx$', {
    get: function () {
      return DEFAULT__new_UnsafeCursor;
    }
  });
  package$okio.resolveDefaultParameter_mp3vb9$ = resolveDefaultParameter;
  Object.defineProperty(package$okio, 'DEFAULT__ByteString_size_8be2vx$', {
    get: function () {
      return DEFAULT__ByteString_size;
    }
  });
  package$okio.resolveDefaultParameter_kvlz5j$ = resolveDefaultParameter_0;
  package$okio.ExperimentalFileSystem = ExperimentalFileSystem;
  package$okio.FileHandle = FileHandle;
  package$okio.FileMetadata = FileMetadata;
  package$okio.ForwardingFileSystem = ForwardingFileSystem;
  package$okio.buffer_px5ndk$ = buffer;
  package$okio.buffer_gyfaj4$ = buffer_0;
  package$okio.blackholeSink = blackholeSink;
  package$okio.use_iztsfq$ = use;
  Object.defineProperty(Options, 'Companion', {
    get: Options$Companion_getInstance
  });
  package$okio.Options = Options;
  package$okio.PeekSource = PeekSource;
  Object.defineProperty(Segment, 'Companion', {
    get: Segment$Companion_getInstance
  });
  package$okio.Segment_init = Segment_init;
  package$okio.Segment_init_iyithg$ = Segment_init_0;
  package$okio.Segment = Segment;
  package$okio.Source = Source;
  package$okio.utf8Size_qgyqat$ = utf8Size;
  Object.defineProperty(package$okio, 'REPLACEMENT_BYTE_8be2vx$', {
    get: function () {
      return REPLACEMENT_BYTE;
    }
  });
  Object.defineProperty(package$okio, 'REPLACEMENT_CHARACTER_8be2vx$', {
    get: function () {
      return REPLACEMENT_CHARACTER;
    }
  });
  Object.defineProperty(package$okio, 'REPLACEMENT_CODE_POINT_8be2vx$', {
    get: function () {
      return REPLACEMENT_CODE_POINT;
    }
  });
  package$okio.isIsoControl_kcn2v3$ = isIsoControl;
  package$okio.isUtf8Continuation_8e99oo$ = isUtf8Continuation;
  package$okio.processUtf8Bytes_cepy5y$ = processUtf8Bytes;
  package$okio.process2Utf8Bytes_nbe8nt$ = process2Utf8Bytes;
  package$okio.process3Utf8Bytes_nbe8nt$ = process3Utf8Bytes;
  package$okio.process4Utf8Bytes_nbe8nt$ = process4Utf8Bytes;
  package$okio.processUtf8CodePoints_nbe8nt$ = processUtf8CodePoints;
  Object.defineProperty(package$okio, 'HIGH_SURROGATE_HEADER_8be2vx$', {
    get: function () {
      return HIGH_SURROGATE_HEADER;
    }
  });
  Object.defineProperty(package$okio, 'LOG_SURROGATE_HEADER_8be2vx$', {
    get: function () {
      return LOG_SURROGATE_HEADER;
    }
  });
  package$okio.processUtf16Chars_2iasp0$ = processUtf16Chars;
  Object.defineProperty(package$okio, 'MASK_2BYTES_8be2vx$', {
    get: function () {
      return MASK_2BYTES;
    }
  });
  Object.defineProperty(package$okio, 'MASK_3BYTES_8be2vx$', {
    get: function () {
      return MASK_3BYTES;
    }
  });
  Object.defineProperty(package$okio, 'MASK_4BYTES_8be2vx$', {
    get: function () {
      return MASK_4BYTES;
    }
  });
  var package$internal = package$okio.internal || (package$okio.internal = {});
  Object.defineProperty(package$internal, 'HEX_DIGIT_BYTES_8be2vx$', {
    get: function () {
      return HEX_DIGIT_BYTES;
    }
  });
  Object.defineProperty(package$internal, 'SEGMENTING_THRESHOLD_8be2vx$', {
    get: function () {
      return SEGMENTING_THRESHOLD;
    }
  });
  package$internal.rangeEquals_kfbcqu$ = rangeEquals;
  package$internal.readUtf8Line_rqsa21$ = readUtf8Line;
  package$internal.seek_r6jk9a$ = seek;
  package$internal.selectPrefix_x1lq7p$ = selectPrefix;
  package$internal.commonCopyTo_23acee$ = commonCopyTo;
  package$internal.commonCompleteSegmentByteCount_cx6lq8$ = commonCompleteSegmentByteCount;
  package$internal.commonReadByte_cx6lq8$ = commonReadByte;
  package$internal.commonReadShort_cx6lq8$ = commonReadShort;
  package$internal.commonReadInt_cx6lq8$ = commonReadInt;
  package$internal.commonReadLong_cx6lq8$ = commonReadLong;
  package$internal.commonGet_rqsa21$ = commonGet;
  package$internal.commonClear_cx6lq8$ = commonClear;
  package$internal.commonSkip_rqsa21$ = commonSkip;
  package$internal.commonWrite_q97ol7$ = commonWrite;
  package$internal.commonWriteDecimalLong_rqsa21$ = commonWriteDecimalLong;
  package$internal.commonWriteHexadecimalUnsignedLong_rqsa21$ = commonWriteHexadecimalUnsignedLong;
  package$internal.commonWritableSegment_j847vm$ = commonWritableSegment;
  package$internal.commonWrite_ezk82s$ = commonWrite_0;
  package$internal.commonWrite_p3n3ms$ = commonWrite_1;
  package$internal.commonReadByteArray_cx6lq8$ = commonReadByteArray;
  package$internal.commonReadByteArray_rqsa21$ = commonReadByteArray_0;
  package$internal.commonRead_ezk82s$ = commonRead;
  package$internal.commonReadFully_ezk82s$ = commonReadFully;
  package$internal.commonRead_p3n3ms$ = commonRead_0;
  Object.defineProperty(package$internal, 'OVERFLOW_ZONE_8be2vx$', {
    get: function () {
      return OVERFLOW_ZONE;
    }
  });
  Object.defineProperty(package$internal, 'OVERFLOW_DIGIT_START_8be2vx$', {
    get: function () {
      return OVERFLOW_DIGIT_START;
    }
  });
  package$internal.commonReadDecimalLong_cx6lq8$ = commonReadDecimalLong;
  package$internal.commonReadHexadecimalUnsignedLong_cx6lq8$ = commonReadHexadecimalUnsignedLong;
  package$internal.commonReadByteString_cx6lq8$ = commonReadByteString;
  package$internal.commonReadByteString_rqsa21$ = commonReadByteString_0;
  package$internal.commonSelect_hdhslu$ = commonSelect;
  package$internal.commonReadFully_ow212v$ = commonReadFully_0;
  package$internal.commonReadAll_skqbtt$ = commonReadAll;
  package$internal.commonToUtf8String_ietg8x$ = commonToUtf8String;
  package$internal.commonReadUtf8_rqsa21$ = commonReadUtf8;
  package$internal.commonReadUtf8Line_cx6lq8$ = commonReadUtf8Line;
  package$internal.commonReadUtf8LineStrict_rqsa21$ = commonReadUtf8LineStrict;
  package$internal.commonReadUtf8CodePoint_cx6lq8$ = commonReadUtf8CodePoint;
  package$internal.commonWriteUtf8_cycsg2$ = commonWriteUtf8;
  package$internal.commonWriteUtf8CodePoint_j847vm$ = commonWriteUtf8CodePoint;
  package$internal.commonWriteAll_rn6xwn$ = commonWriteAll;
  package$internal.commonWrite_pxeag4$ = commonWrite_2;
  package$internal.commonWriteByte_j847vm$ = commonWriteByte;
  package$internal.commonWriteShort_j847vm$ = commonWriteShort;
  package$internal.commonWriteInt_j847vm$ = commonWriteInt;
  package$internal.commonWriteLong_rqsa21$ = commonWriteLong;
  package$internal.commonWrite_ow212v$ = commonWrite_3;
  package$internal.commonRead_ow212v$ = commonRead_1;
  package$internal.commonIndexOf_w0xj73$ = commonIndexOf;
  package$internal.commonIndexOf_qcxvni$ = commonIndexOf_0;
  package$internal.commonIndexOfElement_qcxvni$ = commonIndexOfElement;
  package$internal.commonRangeEquals_k06rlq$ = commonRangeEquals;
  package$okio.Buffer = Buffer;
  package$internal.commonEquals_rql8ow$ = commonEquals;
  package$internal.commonHashCode_cx6lq8$ = commonHashCode;
  package$internal.commonCopy_cx6lq8$ = commonCopy;
  package$internal.commonSnapshot_cx6lq8$ = commonSnapshot;
  package$okio.ByteString = ByteString;
  package$internal.commonSnapshot_j847vm$ = commonSnapshot_0;
  package$internal.commonReadUnsafe_z7o4pu$ = commonReadUnsafe;
  package$internal.commonReadAndWriteUnsafe_z7o4pu$ = commonReadAndWriteUnsafe;
  package$internal.commonNext_6osl3o$ = commonNext;
  package$internal.commonSeek_1ijwtn$ = commonSeek;
  package$internal.commonResizeBuffer_1ijwtn$ = commonResizeBuffer;
  package$internal.commonExpandBuffer_2c8yq2$ = commonExpandBuffer;
  package$internal.commonClose_6osl3o$ = commonClose;
  package$okio.toUtf8String_jln3ri$ = toUtf8String;
  package$internal.commonUtf8_gp9naf$ = commonUtf8;
  package$internal.commonBase64_gp9naf$ = commonBase64;
  package$internal.commonBase64Url_gp9naf$ = commonBase64Url;
  Object.defineProperty(package$internal, 'HEX_DIGIT_CHARS_8be2vx$', {
    get: function () {
      return HEX_DIGIT_CHARS;
    }
  });
  package$internal.commonHex_gp9naf$ = commonHex;
  package$internal.commonToAsciiLowercase_gp9naf$ = commonToAsciiLowercase;
  package$internal.commonToAsciiUppercase_gp9naf$ = commonToAsciiUppercase;
  package$internal.commonSubstring_h0wzdx$ = commonSubstring;
  package$internal.commonGetByte_kvlz5j$ = commonGetByte;
  package$internal.commonGetSize_gp9naf$ = commonGetSize;
  package$internal.commonToByteArray_gp9naf$ = commonToByteArray;
  package$internal.commonInternalArray_gp9naf$ = commonInternalArray;
  package$internal.commonRangeEquals_zi8eqq$ = commonRangeEquals_0;
  package$internal.commonRangeEquals_lwghk7$ = commonRangeEquals_1;
  package$internal.commonCopyInto_lwghk7$ = commonCopyInto;
  package$internal.commonStartsWith_x3su66$ = commonStartsWith;
  package$internal.commonStartsWith_754h9x$ = commonStartsWith_0;
  package$internal.commonEndsWith_x3su66$ = commonEndsWith;
  package$internal.commonEndsWith_754h9x$ = commonEndsWith_0;
  package$internal.commonIndexOf_cpnqjn$ = commonIndexOf_1;
  package$internal.commonLastIndexOf_cvng9c$ = commonLastIndexOf;
  package$internal.commonLastIndexOf_cpnqjn$ = commonLastIndexOf_0;
  package$internal.commonEquals_7y1vpj$ = commonEquals_0;
  package$internal.commonHashCode_gp9naf$ = commonHashCode_0;
  package$internal.commonCompareTo_x3su66$ = commonCompareTo;
  package$internal.commonOf_ma41of$ = commonOf;
  package$internal.commonToByteString_3krwv6$ = commonToByteString;
  package$okio.asUtf8ToByteArray_7efafi$ = asUtf8ToByteArray;
  package$internal.commonEncodeUtf8_7efafi$ = commonEncodeUtf8;
  package$internal.commonDecodeBase64_7efafi$ = commonDecodeBase64;
  package$internal.commonDecodeHex_7efafi$ = commonDecodeHex;
  package$internal.commonWrite_kux0p1$ = commonWrite_4;
  package$internal.commonToString_gp9naf$ = commonToString;
  package$internal.commonMetadata_lqjqmc$ = commonMetadata;
  package$internal.commonExists_lqjqmc$ = commonExists;
  package$internal.commonCreateDirectories_72dzkb$ = commonCreateDirectories;
  package$internal.commonCopy_c2k8e9$ = commonCopy_0;
  package$internal.commonDeleteRecursively_72dzkb$ = commonDeleteRecursively;
  package$internal.commonListRecursively_72dzkb$ = commonListRecursively;
  package$internal.collectRecursively_s9zwbk$ = collectRecursively;
  package$internal.symlinkTarget_lqjqmc$ = symlinkTarget;
  package$internal.commonRoot_wel18l$ = commonRoot;
  package$internal.commonSegmentsBytes_wel18l$ = commonSegmentsBytes;
  package$internal.commonSegments_wel18l$ = commonSegments;
  package$internal.commonIsAbsolute_wel18l$ = commonIsAbsolute;
  package$internal.commonIsRelative_wel18l$ = commonIsRelative;
  package$internal.commonVolumeLetter_wel18l$ = commonVolumeLetter;
  package$internal.commonNameBytes_wel18l$ = commonNameBytes;
  package$internal.commonName_wel18l$ = commonName;
  package$internal.commonParent_wel18l$ = commonParent;
  package$internal.commonIsRoot_wel18l$ = commonIsRoot;
  package$internal.commonResolve_vx86u$ = commonResolve_1;
  package$internal.commonResolve_pbki4k$ = commonResolve;
  package$internal.commonResolve_juuqqr$ = commonResolve_0;
  package$internal.toPath_2g9twb$ = toPath;
  package$internal.commonResolve_j0uknj$ = commonResolve_2;
  package$okio.Path = Path;
  package$internal.commonRelativeTo_uzi73e$ = commonRelativeTo;
  package$internal.commonNormalized_wel18l$ = commonNormalized;
  package$internal.commonCompareTo_uzi73e$ = commonCompareTo_0;
  package$internal.commonEquals_e4b6or$ = commonEquals_1;
  package$internal.commonHashCode_wel18l$ = commonHashCode_1;
  package$internal.commonToString_wel18l$ = commonToString_0;
  package$internal.commonToPath_f4dhtg$ = commonToPath;
  package$internal.commonWrite_oe5psp$ = commonWrite_5;
  package$internal.commonWrite_8i7jl7$ = commonWrite_6;
  package$internal.commonWrite_uf7j3f$ = commonWrite_7;
  package$internal.commonWriteUtf8_thum0i$ = commonWriteUtf8_0;
  package$internal.commonWriteUtf8_5sel9u$ = commonWriteUtf8_1;
  package$internal.commonWriteUtf8CodePoint_ahms5u$ = commonWriteUtf8CodePoint_0;
  package$internal.commonWrite_ijfca4$ = commonWrite_8;
  package$internal.commonWrite_x14430$ = commonWrite_9;
  package$internal.commonWriteAll_u2hfd5$ = commonWriteAll_0;
  package$internal.commonWrite_46hzck$ = commonWrite_10;
  package$internal.commonWriteByte_ahms5u$ = commonWriteByte_0;
  package$internal.commonWriteShort_ahms5u$ = commonWriteShort_0;
  package$internal.commonWriteShortLe_ahms5u$ = commonWriteShortLe;
  package$internal.commonWriteInt_ahms5u$ = commonWriteInt_0;
  package$internal.commonWriteIntLe_ahms5u$ = commonWriteIntLe;
  package$internal.commonWriteLong_tyw37r$ = commonWriteLong_0;
  package$internal.commonWriteLongLe_tyw37r$ = commonWriteLongLe;
  package$internal.commonWriteDecimalLong_tyw37r$ = commonWriteDecimalLong_0;
  package$internal.commonWriteHexadecimalUnsignedLong_tyw37r$ = commonWriteHexadecimalUnsignedLong_0;
  package$internal.commonEmitCompleteSegments_ps9l80$ = commonEmitCompleteSegments;
  package$internal.commonEmit_ps9l80$ = commonEmit;
  package$internal.commonFlush_ps9l80$ = commonFlush;
  package$internal.commonClose_ps9l80$ = commonClose_0;
  package$internal.commonTimeout_ps9l80$ = commonTimeout;
  package$internal.commonToString_ps9l80$ = commonToString_1;
  package$internal.commonRead_omy7q7$ = commonRead_2;
  package$internal.commonExhausted_7a1qe0$ = commonExhausted;
  package$internal.commonRequire_ogm69$ = commonRequire;
  package$internal.commonRequest_ogm69$ = commonRequest;
  package$internal.commonReadByte_7a1qe0$ = commonReadByte_0;
  package$internal.commonReadByteString_7a1qe0$ = commonReadByteString_1;
  package$internal.commonReadByteString_ogm69$ = commonReadByteString_2;
  package$internal.commonSelect_uqsvy2$ = commonSelect_0;
  package$internal.commonReadByteArray_7a1qe0$ = commonReadByteArray_1;
  package$internal.commonReadByteArray_ogm69$ = commonReadByteArray_2;
  package$okio.EOFException = EOFException;
  package$internal.commonReadFully_pw2w7g$ = commonReadFully_1;
  package$internal.commonRead_xcweno$ = commonRead_3;
  package$internal.commonReadFully_omy7q7$ = commonReadFully_2;
  package$internal.commonReadAll_6a6yuv$ = commonReadAll_0;
  package$internal.commonReadUtf8_7a1qe0$ = commonReadUtf8_0;
  package$internal.commonReadUtf8_ogm69$ = commonReadUtf8_1;
  package$internal.commonReadUtf8Line_7a1qe0$ = commonReadUtf8Line_0;
  package$internal.commonReadUtf8LineStrict_ogm69$ = commonReadUtf8LineStrict_0;
  package$internal.commonReadUtf8CodePoint_7a1qe0$ = commonReadUtf8CodePoint_0;
  package$internal.commonReadShort_7a1qe0$ = commonReadShort_0;
  package$internal.commonReadShortLe_7a1qe0$ = commonReadShortLe;
  package$internal.commonReadInt_7a1qe0$ = commonReadInt_0;
  package$internal.commonReadIntLe_7a1qe0$ = commonReadIntLe;
  package$internal.commonReadLong_7a1qe0$ = commonReadLong_0;
  package$internal.commonReadLongLe_7a1qe0$ = commonReadLongLe;
  package$internal.commonReadDecimalLong_7a1qe0$ = commonReadDecimalLong_0;
  package$internal.commonReadHexadecimalUnsignedLong_7a1qe0$ = commonReadHexadecimalUnsignedLong_0;
  package$internal.commonSkip_ogm69$ = commonSkip_0;
  package$internal.commonIndexOf_z1p6tj$ = commonIndexOf_2;
  package$internal.commonIndexOf_n1qd3u$ = commonIndexOf_3;
  package$internal.commonIndexOfElement_n1qd3u$ = commonIndexOfElement_0;
  package$internal.commonRangeEquals_4ww1sq$ = commonRangeEquals_2;
  package$internal.commonPeek_7a1qe0$ = commonPeek;
  package$internal.commonClose_7a1qe0$ = commonClose_1;
  package$internal.commonTimeout_7a1qe0$ = commonTimeout_0;
  package$internal.commonToString_7a1qe0$ = commonToString_2;
  package$internal.binarySearch_ubynyh$ = binarySearch_0;
  package$internal.segment_eyoskr$ = segment;
  package$internal.forEachSegment_enn6vc$ = forEachSegment;
  package$internal.commonSubstring_weypk7$ = commonSubstring_0;
  package$internal.commonInternalGet_eyoskr$ = commonInternalGet;
  package$internal.commonGetSize_q6z9o3$ = commonGetSize_0;
  package$internal.commonToByteArray_q6z9o3$ = commonToByteArray_0;
  package$internal.commonWrite_xhbhaf$ = commonWrite_11;
  package$internal.commonRangeEquals_4are8i$ = commonRangeEquals_3;
  package$internal.commonRangeEquals_4jgj6t$ = commonRangeEquals_4;
  package$internal.commonCopyInto_4jgj6t$ = commonCopyInto_0;
  package$internal.commonEquals_xcao8d$ = commonEquals_2;
  package$internal.commonHashCode_q6z9o3$ = commonHashCode_2;
  package$internal.commonAsUtf8ToByteArray_pdl1vz$ = commonAsUtf8ToByteArray;
  package$internal.HashFunction = HashFunction;
  Object.defineProperty(Hmac, 'Companion', {
    get: Hmac$Companion_getInstance
  });
  package$internal.Hmac = Hmac;
  Object.defineProperty(Md5, 'Companion', {
    get: Md5$Companion_getInstance
  });
  package$internal.Md5 = Md5;
  package$internal.Sha1 = Sha1;
  Object.defineProperty(Sha256, 'Companion', {
    get: Sha256$Companion_getInstance
  });
  package$internal.Sha256 = Sha256;
  Object.defineProperty(Sha512, 'Companion', {
    get: Sha512$Companion_getInstance
  });
  package$internal.Sha512 = Sha512;
  Object.defineProperty(package$okio, 'PLATFORM_DIRECTORY_SEPARATOR_8be2vx$', {
    get: get_PLATFORM_DIRECTORY_SEPARATOR
  });
  Object.defineProperty(package$okio, 'tmpdir_8be2vx$', {
    get: get_tmpdir
  });
  Object.defineProperty(FileSystem, 'Companion', {
    get: FileSystem$Companion_getInstance
  });
  package$okio.FileSystem = FileSystem;
  package$okio.ArrayIndexOutOfBoundsException = ArrayIndexOutOfBoundsException;
  package$okio.synchronized_4sv92k$ = synchronized;
  package$okio.IOException_init_pdl1vj$ = IOException_init;
  package$okio.IOException = IOException;
  package$okio.FileNotFoundException = FileNotFoundException;
  package$okio.Closeable = Closeable;
  Buffer.UnsafeCursor = Buffer$UnsafeCursor;
  package$okio.BufferedSink = BufferedSink;
  package$okio.BufferedSource = BufferedSource;
  Object.defineProperty(ByteString, 'Companion', {
    get: ByteString$Companion_getInstance
  });
  Object.defineProperty(HashingSink, 'Companion', {
    get: HashingSink$Companion_getInstance
  });
  package$okio.HashingSink = HashingSink;
  Object.defineProperty(HashingSource, 'Companion', {
    get: HashingSource$Companion_getInstance
  });
  package$okio.HashingSource = HashingSource;
  Object.defineProperty(Path, 'Companion', {
    get: Path$Companion_getInstance
  });
  package$okio.RealBufferedSink = RealBufferedSink;
  package$okio.RealBufferedSource = RealBufferedSource;
  Object.defineProperty(package$okio, 'SegmentPool', {
    get: SegmentPool_getInstance
  });
  package$okio.SegmentedByteString = SegmentedByteString;
  package$okio.Sink = Sink;
  Object.defineProperty(Timeout, 'Companion', {
    get: Timeout$Companion_getInstance
  });
  package$okio.Timeout = Timeout;
  Hmac.prototype.update_mj6st8$ = HashFunction.prototype.update_mj6st8$;
  Md5.prototype.update_mj6st8$ = HashFunction.prototype.update_mj6st8$;
  Sha1.prototype.update_mj6st8$ = HashFunction.prototype.update_mj6st8$;
  Sha256.prototype.update_mj6st8$ = HashFunction.prototype.update_mj6st8$;
  Sha512.prototype.update_mj6st8$ = HashFunction.prototype.update_mj6st8$;
  BASE64 = ByteString$Companion_getInstance().encodeUtf8_pdl1vz$('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/').data_8be2vx$;
  BASE64_URL_SAFE = ByteString$Companion_getInstance().encodeUtf8_pdl1vz$('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_').data_8be2vx$;
  DEFAULT__new_UnsafeCursor = new Buffer$UnsafeCursor();
  DEFAULT__ByteString_size = -1234567890;
  REPLACEMENT_BYTE = toByte(63);
  REPLACEMENT_CHARACTER = 65533;
  REPLACEMENT_CODE_POINT = 65533;
  HIGH_SURROGATE_HEADER = 55232;
  LOG_SURROGATE_HEADER = 56320;
  MASK_2BYTES = 3968;
  MASK_3BYTES = -123008;
  MASK_4BYTES = 3678080;
  HEX_DIGIT_BYTES = asUtf8ToByteArray('0123456789abcdef');
  SEGMENTING_THRESHOLD = 4096;
  OVERFLOW_ZONE = L_922337203685477580;
  OVERFLOW_DIGIT_START = L_7;
  HEX_DIGIT_CHARS = Kotlin.charArrayOf(48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102);
  SLASH = ByteString$Companion_getInstance().encodeUtf8_pdl1vz$('/');
  BACKSLASH = ByteString$Companion_getInstance().encodeUtf8_pdl1vz$('\\');
  ANY_SLASH = ByteString$Companion_getInstance().encodeUtf8_pdl1vz$('/\\');
  DOT = ByteString$Companion_getInstance().encodeUtf8_pdl1vz$('.');
  DOT_DOT = ByteString$Companion_getInstance().encodeUtf8_pdl1vz$('..');
  Kotlin.defineModule('okio-parent-okio-js-legacy', _);
  return _;
}));

//# sourceMappingURL=okio-parent-okio-js-legacy.js.map
