/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ExperimentalFileSystem;
import okio.FileHandle;
import okio.FileMetadata;
import okio.JvmSystemFileSystem;
import okio.NioSystemFileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import okio.internal.ResourceFileSystem;
import okio.internal._FileSystemKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H&J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H&J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0006H&J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H&J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H&J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00192\u0006\u0010\u0011\u001a\u00020\u0006H&J\u0018\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\u0006H&J \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u001d\u001a\u00020\bH\u0016J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u0006J\u0012\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000e\u001a\u00020\u0006H&J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H&J$\u0010#\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010$\u001a\u00020\b2\b\b\u0002\u0010\u0007\u001a\u00020\bH&J8\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u0002H&0(\u00a2\u0006\u0002\b*H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u001a\u0010,\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010$\u001a\u00020\bH&J\u0010\u0010\u000b\u001a\u00020-2\u0006\u0010\u0005\u001a\u00020\u0006H&JB\u0010.\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010$\u001a\u00020\b2\u0017\u0010/\u001a\u0013\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u0002H&0(\u00a2\u0006\u0002\b*H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00063"}, d2={"Lokio/FileSystem;", "", "()V", "appendingSink", "Lokio/Sink;", "file", "Lokio/Path;", "mustExist", "", "atomicMove", "", "source", "target", "canonicalize", "path", "copy", "createDirectories", "dir", "createDirectory", "createSymlink", "delete", "deleteRecursively", "fileOrDirectory", "exists", "list", "", "listOrNull", "listRecursively", "Lkotlin/sequences/Sequence;", "followSymlinks", "metadata", "Lokio/FileMetadata;", "metadataOrNull", "openReadOnly", "Lokio/FileHandle;", "openReadWrite", "mustCreate", "read", "T", "readerAction", "Lkotlin/Function1;", "Lokio/BufferedSource;", "Lkotlin/ExtensionFunctionType;", "(Lokio/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "sink", "Lokio/Source;", "write", "writerAction", "Lokio/BufferedSink;", "(Lokio/Path;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "okio"})
@ExperimentalFileSystem
public abstract class FileSystem {
    @NotNull
    public static final Companion Companion;
    @JvmField
    @NotNull
    public static final FileSystem SYSTEM;
    @JvmField
    @NotNull
    public static final Path SYSTEM_TEMPORARY_DIRECTORY;
    @JvmField
    @NotNull
    public static final FileSystem RESOURCES;

    @NotNull
    public abstract Path canonicalize(@NotNull Path var1) throws IOException;

    @NotNull
    public final FileMetadata metadata(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return _FileSystemKt.commonMetadata(this, path);
    }

    @Nullable
    public abstract FileMetadata metadataOrNull(@NotNull Path var1) throws IOException;

    public final boolean exists(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return _FileSystemKt.commonExists(this, path);
    }

    @NotNull
    public abstract List<Path> list(@NotNull Path var1) throws IOException;

    @Nullable
    public abstract List<Path> listOrNull(@NotNull Path var1);

    @NotNull
    public Sequence<Path> listRecursively(@NotNull Path dir, boolean followSymlinks) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return _FileSystemKt.commonListRecursively(this, dir, followSymlinks);
    }

    public static /* synthetic */ Sequence listRecursively$default(FileSystem fileSystem, Path path, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: listRecursively");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return fileSystem.listRecursively(path, bl);
    }

    @NotNull
    public abstract FileHandle openReadOnly(@NotNull Path var1) throws IOException;

    @NotNull
    public abstract FileHandle openReadWrite(@NotNull Path var1, boolean var2, boolean var3) throws IOException;

    public static /* synthetic */ FileHandle openReadWrite$default(FileSystem fileSystem, Path path, boolean bl, boolean bl2, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openReadWrite");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return fileSystem.openReadWrite(path, bl, bl2);
    }

    @NotNull
    public abstract Source source(@NotNull Path var1) throws IOException;

    public final <T> T read(@NotNull Path file, @NotNull Function1<? super BufferedSource, ? extends T> readerAction) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(readerAction, (String)"readerAction");
        boolean $i$f$read = false;
        Closeable $this$use$iv = Okio.buffer(this.source(file));
        boolean $i$f$use = false;
        Object result$iv = null;
        Throwable thrown$iv = null;
        try {
            BufferedSource it = (BufferedSource)$this$use$iv;
            boolean bl = false;
            result$iv = readerAction.invoke((Object)it);
        }
        catch (Throwable t$iv) {
            thrown$iv = t$iv;
        }
        try {
            Closeable t$iv = $this$use$iv;
            if (t$iv != null) {
                t$iv.close();
            }
        }
        catch (Throwable t$iv) {
            if (thrown$iv == null) {
                thrown$iv = t$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
        }
        if (thrown$iv != null) {
            throw thrown$iv;
        }
        Object object = result$iv;
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    @NotNull
    public abstract Sink sink(@NotNull Path var1, boolean var2) throws IOException;

    public static /* synthetic */ Sink sink$default(FileSystem fileSystem, Path path, boolean bl, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sink");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return fileSystem.sink(path, bl);
    }

    public final <T> T write(@NotNull Path file, boolean mustCreate, @NotNull Function1<? super BufferedSink, ? extends T> writerAction) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(writerAction, (String)"writerAction");
        boolean $i$f$write = false;
        Closeable $this$use$iv = Okio.buffer(this.sink(file, mustCreate));
        boolean $i$f$use = false;
        Object result$iv = null;
        Throwable thrown$iv = null;
        try {
            BufferedSink it = (BufferedSink)$this$use$iv;
            boolean bl = false;
            result$iv = writerAction.invoke((Object)it);
        }
        catch (Throwable t$iv) {
            thrown$iv = t$iv;
        }
        try {
            Closeable t$iv = $this$use$iv;
            if (t$iv != null) {
                t$iv.close();
            }
        }
        catch (Throwable t$iv) {
            if (thrown$iv == null) {
                thrown$iv = t$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
        }
        if (thrown$iv != null) {
            throw thrown$iv;
        }
        Object object = result$iv;
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    public static /* synthetic */ Object write$default(FileSystem this_, Path file, boolean mustCreate, Function1 writerAction, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n & 2) != 0) {
            mustCreate = false;
        }
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)writerAction, (String)"writerAction");
        boolean $i$f$write = false;
        Closeable $this$use$iv = Okio.buffer(this_.sink(file, mustCreate));
        boolean $i$f$use = false;
        Object result$iv = null;
        Throwable thrown$iv = null;
        try {
            BufferedSink it = (BufferedSink)$this$use$iv;
            boolean bl = false;
            result$iv = writerAction.invoke((Object)it);
        }
        catch (Throwable t$iv) {
            thrown$iv = t$iv;
        }
        try {
            Closeable t$iv = $this$use$iv;
            if (t$iv != null) {
                t$iv.close();
            }
        }
        catch (Throwable t$iv) {
            if (thrown$iv == null) {
                thrown$iv = t$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
        }
        if (thrown$iv != null) {
            throw thrown$iv;
        }
        Object object2 = result$iv;
        Intrinsics.checkNotNull((Object)object2);
        return object2;
    }

    @NotNull
    public abstract Sink appendingSink(@NotNull Path var1, boolean var2) throws IOException;

    public static /* synthetic */ Sink appendingSink$default(FileSystem fileSystem, Path path, boolean bl, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: appendingSink");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return fileSystem.appendingSink(path, bl);
    }

    public abstract void createDirectory(@NotNull Path var1) throws IOException;

    public final void createDirectories(@NotNull Path dir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        _FileSystemKt.commonCreateDirectories(this, dir);
    }

    public abstract void atomicMove(@NotNull Path var1, @NotNull Path var2) throws IOException;

    public void copy(@NotNull Path source2, @NotNull Path target) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        _FileSystemKt.commonCopy(this, source2, target);
    }

    public abstract void delete(@NotNull Path var1) throws IOException;

    public void deleteRecursively(@NotNull Path fileOrDirectory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileOrDirectory, (String)"fileOrDirectory");
        _FileSystemKt.commonDeleteRecursively(this, fileOrDirectory);
    }

    public abstract void createSymlink(@NotNull Path var1, @NotNull Path var2) throws IOException;

    static {
        JvmSystemFileSystem jvmSystemFileSystem;
        Companion = new Companion(null);
        Object object = Companion;
        boolean bl = false;
        boolean bl2 = false;
        Companion $this$SYSTEM_u24lambda_u2d2 = object;
        boolean bl3 = false;
        try {
            Class.forName("java.nio.file.Files");
            jvmSystemFileSystem = new NioSystemFileSystem();
        }
        catch (ClassNotFoundException e) {
            jvmSystemFileSystem = new JvmSystemFileSystem();
        }
        SYSTEM = jvmSystemFileSystem;
        object = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProperty(\"java.io.tmpdir\")");
        SYSTEM_TEMPORARY_DIRECTORY = Path.Companion.get((String)object);
        object = ResourceFileSystem.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ResourceFileSystem::class.java.classLoader");
        RESOURCES = new ResourceFileSystem((ClassLoader)object, false);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lokio/FileSystem$Companion;", "", "()V", "RESOURCES", "Lokio/FileSystem;", "SYSTEM", "SYSTEM_TEMPORARY_DIRECTORY", "Lokio/Path;", "okio"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

