//[okio](../../../index.md)/[okio](../index.md)/[Timeout](index.md)

# Timeout

[common]\
open class [Timeout](index.md)

A policy on how much time to spend on a task before giving up. When a task times out, it is left in an unspecified state and should be abandoned. For example, if reading from a source times out, that source should be closed and the read should be retried later. If writing to a sink times out, the same rules apply: close the sink and retry later.

###  Timeouts and Deadlines

This class offers two complementary controls to define a timeout policy.

**Timeouts** specify the maximum time to wait for a single operation to complete. Timeouts are typically used to detect problems like network partitions. For example, if a remote peer doesn't return *any* data for ten seconds, we may assume that the peer is unavailable.

**Deadlines** specify the maximum time to spend on a job, composed of one or more operations. Use deadlines to set an upper bound on the time invested on a job. For example, a battery-conscious app may limit how much time it spends pre-loading content.

[jvm]\
open class [Timeout](index.md)

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, jvm]<br>[common, jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [clearDeadline](clear-deadline.md) | [jvm]<br>open fun [clearDeadline](clear-deadline.md)(): [Timeout](index.md)<br>Clears the deadline. |
| [clearTimeout](clear-timeout.md) | [jvm]<br>open fun [clearTimeout](clear-timeout.md)(): [Timeout](index.md)<br>Clears the timeout. Operating system timeouts may still apply. |
| [deadline](deadline.md) | [jvm]<br>fun [deadline](deadline.md)(duration: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](index.md)<br>Set a deadline of now plus duration time. |
| [deadlineNanoTime](deadline-nano-time.md) | [jvm]<br>open fun [deadlineNanoTime](deadline-nano-time.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.<br>[jvm]<br>open fun [deadlineNanoTime](deadline-nano-time.md)(deadlineNanoTime: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Timeout](index.md)<br>Sets the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached. All operations must complete before this time. Use a deadline to set a maximum bound on the time spent on a sequence of operations. |
| [hasDeadline](has-deadline.md) | [jvm]<br>open fun [hasDeadline](has-deadline.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if a deadline is enabled. |
| [intersectWith](intersect-with.md) | [jvm]<br>inline fun &lt;[T](intersect-with.md)&gt; [intersectWith](intersect-with.md)(other: [Timeout](index.md), block: () -&gt; [T](intersect-with.md)): [T](intersect-with.md)<br>Applies the minimum intersection between this timeout and other, run block, then finally rollback this timeout's values. |
| [throwIfReached](throw-if-reached.md) | [jvm]<br>open fun [throwIfReached](throw-if-reached.md)()<br>Throws an [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if the deadline has been reached or if the current thread has been interrupted. This method doesn't detect timeouts; that should be implemented to asynchronously abort an in-progress operation. |
| [timeout](timeout.md) | [jvm]<br>open fun [timeout](timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](index.md)<br>Wait at most timeout time before aborting an operation. Using a per-operation timeout means that as long as forward progress is being made, no sequence of operations will fail. |
| [timeoutNanos](timeout-nanos.md) | [jvm]<br>open fun [timeoutNanos](timeout-nanos.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the timeout in nanoseconds, or 0 for no timeout. |
| [waitUntilNotified](wait-until-notified.md) | [jvm]<br>fun [waitUntilNotified](wait-until-notified.md)(monitor: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))<br>Waits on monitor until it is notified. Throws [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if either the thread is interrupted or if this timeout elapses before monitor is notified. The caller must be synchronized on monitor. |

## Inheritors

| Name |
|---|
| [AsyncTimeout](../-async-timeout/index.md) |
| [ForwardingTimeout](../-forwarding-timeout/index.md) |
