//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[indexOfElement](index-of-element.md)

# indexOfElement

[common]\
abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)

Equivalent to [indexOfElement(targetBytes, 0)](index-of-element.md).

[jvm, nonJvm]\
[jvm, nonJvm]\
abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)

[jvm, nonJvm]\
abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)

[common]\
abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)

Returns the first index in this buffer that is at or after fromIndex and that contains any of the bytes in targetBytes. This expands the buffer as necessary until a target byte is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found.

ByteString ANY_VOWEL = ByteString.encodeUtf8("AEOIUaeoiu");\
\
Buffer buffer = new Buffer();\
buffer.writeUtf8("Dr. Alan Grant");\
\
assertEquals(4,  buffer.indexOfElement(ANY_VOWEL));    // 'A' in 'Alan'.\
assertEquals(11, buffer.indexOfElement(ANY_VOWEL, 9)); // 'a' in 'Grant'.
