//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)

# readHexadecimalUnsignedLong

[common]\
abstract fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)

Reads a long form this source in hexadecimal form (i.e., as a string in base 16). This will iterate until a non-hexadecimal character is found.

Buffer buffer = new Buffer()\
    .writeUtf8("ffff CAFEBABE 10");\
\
assertEquals(65535L, buffer.readHexadecimalUnsignedLong());\
assertEquals(' ', buffer.readByte());\
assertEquals(0xcafebabeL, buffer.readHexadecimalUnsignedLong());\
assertEquals(' ', buffer.readByte());\
assertEquals(0x10L, buffer.readHexadecimalUnsignedLong());

## Throws

| | |
|---|---|
| NumberFormatException | if the found hexadecimal does not fit into a long or hexadecimal was not found. |

[jvm, nonJvm]\
[jvm, nonJvm]\
abstract fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)

## Throws

| | |
|---|---|
| NumberFormatException | if the found hexadecimal does not fit into a long or hexadecimal was not found. |
