//[okio](../../../index.md)/[okio](../index.md)/[DeflaterSink](index.md)

# DeflaterSink

[jvm]\
class [DeflaterSink](index.md) : [Sink](../-sink/index.md)

A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source.

###  Sync flush

Aggressive flushing of this stream may result in reduced compression. Each call to [flush](flush.md) immediately compresses all currently-buffered data; this early compression may be less effective than compression performed without flushing.

This is equivalent to using [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) with the sync flush option. This class does not offer any partial flush mechanism. For best performance, only call [flush](flush.md) when application behavior requires it.

## Constructors

| | |
|---|---|
| [DeflaterSink](-deflater-sink.md) | [jvm]<br>fun [DeflaterSink](-deflater-sink.md)(sink: [Sink](../-sink/index.md), deflater: [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)) |

## Functions

| Name | Summary |
|---|---|
| [close](close.md) | [jvm]<br>open override fun [close](close.md)() |
| [flush](flush.md) | [jvm]<br>open override fun [flush](flush.md)() |
| [timeout](timeout.md) | [jvm]<br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md) |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [write](write.md) | [jvm]<br>open override fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
