//[okio](../../../index.md)/[okio](../index.md)/[FileSystem](index.md)/[canonicalize](canonicalize.md)

# canonicalize

[common]\
abstract fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md)

Resolves [path](canonicalize.md) against the current working directory and symlinks in this file system. The returned path identifies the same file as [path](canonicalize.md), but with an absolute path that does not include any symbolic links.

This is similar to File.getCanonicalFile() on the JVM and realpath on POSIX. Unlike File.getCanonicalFile(), this throws if the file doesn't exist.

## Throws

| | |
|---|---|
| [okio.IOException](../-i-o-exception/index.md) | if [path](canonicalize.md) cannot be resolved. This will occur if the file doesn't exist,     if the current working directory doesn't exist or is inaccessible, or if another failure     occurs while resolving the path. |

[js, jvm, native]\
[js, native]\
abstract fun [canonicalize](canonicalize.md)(path: Path): Path

[jvm]\
abstract fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md)

## Throws

| | |
|---|---|
| [okio.IOException](../-i-o-exception/index.md) | if [path](canonicalize.md) cannot be resolved. This will occur if the file doesn't exist,     if the current working directory doesn't exist or is inaccessible, or if another failure     occurs while resolving the path. |
