//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[readIntLe](read-int-le.md)

# readIntLe

[common]\
expect abstract fun [readIntLe](read-int-le.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)

Removes four bytes from this source and returns a little-endian int.

```java
Buffer buffer = new Buffer()
    .writeByte(0xff)
    .writeByte(0xff)
    .writeByte(0xff)
    .writeByte(0x7f)
    .writeByte(0x0f)
    .writeByte(0x00)
    .writeByte(0x00)
    .writeByte(0x00);
assertEquals(8, buffer.size());

assertEquals(2147483647, buffer.readIntLe());
assertEquals(4, buffer.size());

assertEquals(15, buffer.readIntLe());
assertEquals(0, buffer.size());
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual abstract fun [readIntLe](read-int-le.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)