//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[readUtf8Line](read-utf8-line.md)

# readUtf8Line

[common]\
expect abstract fun [readUtf8Line](read-utf8-line.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)?

Removes and returns characters up to but not including the next line break. A line break is either `"\n"` or `"\r\n"`; these characters are not included in the result.

```java
Buffer buffer = new Buffer()
    .writeUtf8("I'm a hacker!\n")
    .writeUtf8("That's what I said: you're a nerd.\n")
    .writeUtf8("I prefer to be called a hacker!\n");
assertEquals(81, buffer.size());

assertEquals("I'm a hacker!", buffer.readUtf8Line());
assertEquals(67, buffer.size());

assertEquals("That's what I said: you're a nerd.", buffer.readUtf8Line());
assertEquals(32, buffer.size());

assertEquals("I prefer to be called a hacker!", buffer.readUtf8Line());
assertEquals(0, buffer.size());

assertEquals(null, buffer.readUtf8Line());
assertEquals(0, buffer.size());
```

**On the end of the stream this method returns null,** just like java.io.BufferedReader. If the source doesn't end with a line break then an implicit line break is assumed. Null is returned once the source is exhausted. Use this for human-generated data, where a trailing line break is optional.

[jvm, nonJvm]\
[jvm, nonJvm]\
actual abstract fun [readUtf8Line](read-utf8-line.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)?