//[okio](../../../index.md)/[okio](../index.md)/[ByteString](index.md)

# ByteString

[common]\
open class [ByteString](index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[ByteString](index.md)&gt; 

An immutable sequence of bytes.

Byte strings compare lexicographically as a sequence of **unsigned** bytes. That is, the byte string ff sorts after 00. This is counter to the sort order of the corresponding bytes, where -1 sorts before 0.

**Full disclosure:** this class provides untrusted input and output streams with raw access to the underlying byte array. A hostile stream implementation could keep a reference to the mutable byte string, violating the immutable guarantee of this class. For this reason a byte string's immutability guarantee cannot be relied upon for security in applets and other environments that run both trusted and untrusted code in the same process.

[jvm]\
open class [ByteString](index.md) : [Serializable](https://docs.oracle.com/javase/8/docs/api/java/io/Serializable.html), [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[ByteString](index.md)&gt;

[nonJvm]\
open class [ByteString](index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[ByteString](index.md)&gt;

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, jvm, nonJvm]<br>[common, jvm, nonJvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [asByteBuffer](as-byte-buffer.md) | [jvm]<br>open fun [asByteBuffer](as-byte-buffer.md)(): [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)<br>Returns a ByteBuffer view of the bytes in this ByteString. |
| [base64](base64.md) | [common]<br>fun [base64](base64.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns this byte string encoded as [Base64](http://www.ietf.org/rfc/rfc2045.txt). In violation of the RFC, the returned string does not wrap lines at 76 columns.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open fun [base64](base64.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [base64Url](base64-url.md) | [common]<br>fun [base64Url](base64-url.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns this byte string encoded as [URL-safe Base64](http://www.ietf.org/rfc/rfc4648.txt).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open fun [base64Url](base64-url.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [compareTo](compare-to.md) | [common, jvm, nonJvm]<br>[common, jvm, nonJvm]<br>open operator override fun [compareTo](compare-to.md)(other: [ByteString](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [copyInto](copy-into.md) | [common]<br>fun [copyInto](copy-into.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, target: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), targetOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))<br>Copies bytes of this in [offset..offset+byteCount] to other in [targetOffset..targetOffset+byteCount].<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open fun [copyInto](copy-into.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, target: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), targetOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)) |
| [endsWith](ends-with.md) | [common, jvm, nonJvm]<br>[common, jvm, nonJvm]<br>fun [endsWith](ends-with.md)(suffix: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[common, jvm, nonJvm]<br>fun [endsWith](ends-with.md)(suffix: [ByteString](index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [equals](equals.md) | [common, jvm, nonJvm]<br>[common, jvm, nonJvm]<br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [get](get.md) | [common]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "getByte")<br>operator fun [get](get.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>Returns the byte at index.<br>[jvm, nonJvm]<br>[jvm]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "getByte")<br>operator fun [get](get.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>[nonJvm]<br>operator fun [get](get.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html) |
| [hashCode](hash-code.md) | [common, jvm, nonJvm]<br>[common, jvm, nonJvm]<br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [hex](hex.md) | [common]<br>fun [hex](hex.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns this byte string encoded in hexadecimal.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open fun [hex](hex.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [hmacSha1](hmac-sha1.md) | [common, jvm, nonJvm]<br>[common, nonJvm]<br>fun [hmacSha1](hmac-sha1.md)(key: [ByteString](index.md)): [ByteString](index.md)<br>[jvm]<br>open fun [hmacSha1](hmac-sha1.md)(key: [ByteString](index.md)): [ByteString](index.md)<br>Returns the 160-bit SHA-1 HMAC of this byte string. |
| [hmacSha256](hmac-sha256.md) | [common, jvm, nonJvm]<br>[common, nonJvm]<br>fun [hmacSha256](hmac-sha256.md)(key: [ByteString](index.md)): [ByteString](index.md)<br>[jvm]<br>open fun [hmacSha256](hmac-sha256.md)(key: [ByteString](index.md)): [ByteString](index.md)<br>Returns the 256-bit SHA-256 HMAC of this byte string. |
| [hmacSha512](hmac-sha512.md) | [common, jvm, nonJvm]<br>[common, nonJvm]<br>fun [hmacSha512](hmac-sha512.md)(key: [ByteString](index.md)): [ByteString](index.md)<br>[jvm]<br>open fun [hmacSha512](hmac-sha512.md)(key: [ByteString](index.md)): [ByteString](index.md)<br>Returns the 512-bit SHA-512 HMAC of this byte string. |
| [indexOf](index-of.md) | [common, jvm, nonJvm]<br>[common]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [indexOf](index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>open fun [indexOf](index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open fun [indexOf](index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common, jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [indexOf](index-of.md)(other: [ByteString](index.md), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>fun [indexOf](index-of.md)(other: [ByteString](index.md), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [lastIndexOf](last-index-of.md) | [common, jvm, nonJvm]<br>[common]<br>fun [lastIndexOf](last-index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>open fun [lastIndexOf](last-index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open fun [lastIndexOf](last-index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common, nonJvm]<br>fun [lastIndexOf](last-index-of.md)(other: [ByteString](index.md), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [lastIndexOf](last-index-of.md)(other: [ByteString](index.md), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [md5](md5.md) | [common]<br>fun [md5](md5.md)(): [ByteString](index.md)<br>Returns the 128-bit MD5 hash of this byte string.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>fun [md5](md5.md)(): [ByteString](index.md) |
| [rangeEquals](range-equals.md) | [common]<br>fun [rangeEquals](range-equals.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), otherOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>fun [rangeEquals](range-equals.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), other: [ByteString](index.md), otherOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the bytes of this in [offset..offset+byteCount) equal the bytes of other in [otherOffset..otherOffset+byteCount). Returns false if either range is out of bounds.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open fun [rangeEquals](range-equals.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), otherOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[jvm, nonJvm]<br>open fun [rangeEquals](range-equals.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), other: [ByteString](index.md), otherOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [sha1](sha1.md) | [common]<br>fun [sha1](sha1.md)(): [ByteString](index.md)<br>Returns the 160-bit SHA-1 hash of this byte string.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>fun [sha1](sha1.md)(): [ByteString](index.md) |
| [sha256](sha256.md) | [common]<br>fun [sha256](sha256.md)(): [ByteString](index.md)<br>Returns the 256-bit SHA-256 hash of this byte string.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>fun [sha256](sha256.md)(): [ByteString](index.md) |
| [sha512](sha512.md) | [common]<br>fun [sha512](sha512.md)(): [ByteString](index.md)<br>Returns the 512-bit SHA-512 hash of this byte string.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>fun [sha512](sha512.md)(): [ByteString](index.md) |
| [startsWith](starts-with.md) | [common, jvm, nonJvm]<br>[common, jvm, nonJvm]<br>fun [startsWith](starts-with.md)(prefix: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[common, jvm, nonJvm]<br>fun [startsWith](starts-with.md)(prefix: [ByteString](index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [string](string.md) | [jvm]<br>open fun [string](string.md)(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Constructs a new String by decoding the bytes using charset. |
| [substring](substring.md) | [common]<br>fun [substring](substring.md)(beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [ByteString](index.md)<br>Returns a byte string that is a substring of this byte string, beginning at the specified beginIndex and ends at the specified endIndex. Returns this byte string if beginIndex is 0 and endIndex is the length of this byte string.<br>[jvm, nonJvm]<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>open fun [substring](substring.md)(beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [ByteString](index.md)<br>[nonJvm]<br>open fun [substring](substring.md)(beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [ByteString](index.md) |
| [toAsciiLowercase](to-ascii-lowercase.md) | [common]<br>fun [toAsciiLowercase](to-ascii-lowercase.md)(): [ByteString](index.md)<br>Returns a byte string equal to this byte string, but with the bytes 'A' through 'Z' replaced with the corresponding byte in 'a' through 'z'. Returns this byte string if it contains no bytes in 'A' through 'Z'.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open fun [toAsciiLowercase](to-ascii-lowercase.md)(): [ByteString](index.md) |
| [toAsciiUppercase](to-ascii-uppercase.md) | [common]<br>fun [toAsciiUppercase](to-ascii-uppercase.md)(): [ByteString](index.md)<br>Returns a byte string equal to this byte string, but with the bytes 'a' through 'z' replaced with the corresponding byte in 'A' through 'Z'. Returns this byte string if it contains no bytes in 'a' through 'z'.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open fun [toAsciiUppercase](to-ascii-uppercase.md)(): [ByteString](index.md) |
| [toByteArray](to-byte-array.md) | [common]<br>fun [toByteArray](to-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Returns a byte array containing a copy of the bytes in this ByteString.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open fun [toByteArray](to-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html) |
| [toString](to-string.md) | [common, nonJvm]<br>[common, nonJvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable string that describes the contents of this byte string. Typically this is a string like [text=Hello] or [hex=0000ffff].<br>[jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [utf8](utf8.md) | [common]<br>fun [utf8](utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Constructs a new String by decoding the bytes as UTF-8.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>open fun [utf8](utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [write](write.md) | [jvm]<br>open fun [write](write.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html))<br>Writes the contents of this byte string to out. |

## Properties

| Name | Summary |
|---|---|
| [size](size.md) | [common]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "size")<br>val [size](size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns the number of bytes in this ByteString.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "size")<br>val [size](size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>val [size](size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
