//[okio](../../../index.md)/[okio](../index.md)/[FileSystem](index.md)/[createDirectory](create-directory.md)

# createDirectory

[jvm]\
fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md))

[common]\
abstract fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)

Creates a directory at the path identified by [dir](create-directory.md).

## Parameters

common

| | |
|---|---|
| mustCreate | true to throw an [IOException](../-i-o-exception/index.md) if the directory already exists. |

js

| | |
|---|---|
| mustCreate | true to throw an IOException if the directory already exists. |

jvm

| | |
|---|---|
| mustCreate | true to throw an [IOException](../-i-o-exception/index.md) if the directory already exists. |

native

## Throws

| | |
|---|---|
| [okio.IOException](../-i-o-exception/index.md) | if [dir](create-directory.md)'s parent does not exist, is not a directory, or cannot be written.     A directory cannot be created if the current process doesn't have access, if there's a loop     of symbolic links, or if any name is too long. |

[js, jvm, native]\
[js, native]\
abstract fun [createDirectory](create-directory.md)(dir: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)

[jvm]\
abstract fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)

## Parameters

common

| | |
|---|---|
| mustCreate | true to throw an [IOException](../-i-o-exception/index.md) if the directory already exists. |

js

| | |
|---|---|
| mustCreate | true to throw an IOException if the directory already exists. |

jvm

| | |
|---|---|
| mustCreate | true to throw an [IOException](../-i-o-exception/index.md) if the directory already exists. |

native

## Throws

| | |
|---|---|
| [okio.IOException](../-i-o-exception/index.md) | if [dir](create-directory.md)'s parent does not exist, is not a directory, or cannot be written.     A directory cannot be created if the current process doesn't have access, if there's a loop     of symbolic links, or if any name is too long. |
