//[okio](../../../index.md)/[okio](../index.md)/[AsyncTimeout](index.md)

# AsyncTimeout

[jvm]\
open class [AsyncTimeout](index.md) : [Timeout](../-timeout/index.md)

This timeout uses a background thread to take action exactly when the timeout occurs. Use this to implement timeouts where they aren't supported natively, such as to sockets that are blocked on writing.

Subclasses should override timedOut to take action when a timeout occurs. This method will be invoked by the shared watchdog thread so it should not do any long-running operations. Otherwise we risk starving other timeouts from being triggered.

Use [sink](sink.md) and [source](source.md) to apply this timeout to a stream. The returned value will apply the timeout to each operation on the wrapped stream.

Callers should call [enter](enter.md) before doing work that is subject to timeouts, and [exit](exit.md) afterwards. The return value of [exit](exit.md) indicates whether a timeout was triggered. Note that the call to timedOut is asynchronous, and may be called after [exit](exit.md).

## Constructors

| | |
|---|---|
| [AsyncTimeout](-async-timeout.md) | [jvm]<br>fun [AsyncTimeout](-async-timeout.md)() |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [awaitSignal](../-timeout/await-signal.md) | [jvm]<br>fun [awaitSignal](../-timeout/await-signal.md)(condition: [Condition](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/locks/Condition.html))<br>Waits on `monitor` until it is signaled. Throws [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if either the thread is interrupted or if this timeout elapses before `monitor` is signaled. The caller must hold the lock that monitor is bound to. |
| [clearDeadline](../-timeout/clear-deadline.md) | [jvm]<br>open fun [clearDeadline](../-timeout/clear-deadline.md)(): [Timeout](../-timeout/index.md)<br>Clears the deadline. |
| [clearTimeout](../-timeout/clear-timeout.md) | [jvm]<br>open fun [clearTimeout](../-timeout/clear-timeout.md)(): [Timeout](../-timeout/index.md)<br>Clears the timeout. Operating system timeouts may still apply. |
| [deadline](../-timeout/deadline.md) | [jvm]<br>fun [deadline](../-timeout/deadline.md)(duration: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)<br>Set a deadline of now plus `duration` time. |
| [deadlineNanoTime](../-timeout/deadline-nano-time.md) | [jvm]<br>open fun [deadlineNanoTime](../-timeout/deadline-nano-time.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.<br>[jvm]<br>open fun [deadlineNanoTime](../-timeout/deadline-nano-time.md)(deadlineNanoTime: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Timeout](../-timeout/index.md)<br>Sets the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached. All operations must complete before this time. Use a deadline to set a maximum bound on the time spent on a sequence of operations. |
| [enter](enter.md) | [jvm]<br>fun [enter](enter.md)() |
| [exit](exit.md) | [jvm]<br>fun [exit](exit.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the timeout occurred. |
| [hasDeadline](../-timeout/has-deadline.md) | [jvm]<br>open fun [hasDeadline](../-timeout/has-deadline.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if a deadline is enabled. |
| [intersectWith](../-timeout/intersect-with.md) | [jvm]<br>inline fun &lt;[T](../-timeout/intersect-with.md)&gt; [intersectWith](../-timeout/intersect-with.md)(other: [Timeout](../-timeout/index.md), block: () -&gt; [T](../-timeout/intersect-with.md)): [T](../-timeout/intersect-with.md)<br>Applies the minimum intersection between this timeout and `other`, run `block`, then finally rollback this timeout's values. |
| [sink](sink.md) | [jvm]<br>fun [sink](sink.md)(sink: [Sink](../-sink/index.md)): [Sink](../-sink/index.md)<br>Returns a new sink that delegates to [sink](sink.md), using this to implement timeouts. This works best if timedOut is overridden to interrupt [sink](sink.md)'s current operation. |
| [source](source.md) | [jvm]<br>fun [source](source.md)(source: [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053)): [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053)<br>Returns a new source that delegates to [source](source.md), using this to implement timeouts. This works best if timedOut is overridden to interrupt [source](source.md)'s current operation. |
| [throwIfReached](../-timeout/throw-if-reached.md) | [jvm]<br>open fun [throwIfReached](../-timeout/throw-if-reached.md)()<br>Throws an [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if the deadline has been reached or if the current thread has been interrupted. This method doesn't detect timeouts; that should be implemented to asynchronously abort an in-progress operation. |
| [timeout](../-timeout/timeout.md) | [jvm]<br>open fun [timeout](../-timeout/timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)<br>Wait at most `timeout` time before aborting an operation. Using a per-operation timeout means that as long as forward progress is being made, no sequence of operations will fail. |
| [timeoutNanos](../-timeout/timeout-nanos.md) | [jvm]<br>open fun [timeoutNanos](../-timeout/timeout-nanos.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the timeout in nanoseconds, or `0` for no timeout. |
| [waitUntilNotified](../-timeout/wait-until-notified.md) | [jvm]<br>fun [waitUntilNotified](../-timeout/wait-until-notified.md)(monitor: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))<br>Waits on `monitor` until it is notified. Throws [InterruptedIOException](https://docs.oracle.com/javase/8/docs/api/java/io/InterruptedIOException.html) if either the thread is interrupted or if this timeout elapses before `monitor` is notified. The caller must be synchronized on `monitor`. |
| [withTimeout](with-timeout.md) | [jvm]<br>inline fun &lt;[T](with-timeout.md)&gt; [withTimeout](with-timeout.md)(block: () -&gt; [T](with-timeout.md)): [T](with-timeout.md)<br>Surrounds [block](with-timeout.md) with calls to [enter](enter.md) and [exit](exit.md), throwing an exception from newTimeoutException if a timeout occurred. |
