//[okio](../../../index.md)/[okio](../index.md)/[FileSystem](index.md)/[appendingSink](appending-sink.md)

# appendingSink

[jvm, js, native]\
[jvm]\
fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)

[js, native]\
actual abstract fun [appendingSink](appending-sink.md)(file: Path, mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): Sink

[jvm]\
actual abstract fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Sink](../-sink/index.md)

[common]\
expect abstract fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [Sink](../-sink/index.md)

Returns a sink that appends bytes to the end of [file](appending-sink.md), creating it if it doesn't already exist.

## Parameters

common

| | |
|---|---|
| mustExist | true to throw an [IOException](../-i-o-exception/index.md) instead of creating a new file. This is     equivalent to `r+` on POSIX and `OPEN_EXISTING` on Windows. |

## Throws

| | |
|---|---|
| [okio.IOException](../-i-o-exception/index.md) | if [file](appending-sink.md) cannot be written. A file cannot be written if its enclosing     directory does not exist, if the current process doesn't have access to [file](appending-sink.md), if there's     a loop of symbolic links, or if any name is too long. |
