//[okio](../../index.md)/[okio](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md) | [common, nonJvm, jvm]<br>[common]<br>expect class [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IndexOutOfBoundsException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-index-out-of-bounds-exception/index.html)<br>[nonJvm]<br>actual open class [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IndexOutOfBoundsException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-index-out-of-bounds-exception/index.html)<br>[jvm]<br>actual typealias [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md) = [ArrayIndexOutOfBoundsException](https://docs.oracle.com/javase/8/docs/api/java/lang/ArrayIndexOutOfBoundsException.html) |
| [AsyncTimeout](-async-timeout/index.md) | [jvm]<br>open class [AsyncTimeout](-async-timeout/index.md) : [Timeout](-timeout/index.md)<br>This timeout uses a background thread to take action exactly when the timeout occurs. Use this to implement timeouts where they aren't supported natively, such as to sockets that are blocked on writing. |
| [Buffer](-buffer/index.md) | [common]<br>expect class [Buffer](-buffer/index.md) : [BufferedSource](-buffered-source/index.md), [BufferedSink](-buffered-sink/index.md)<br>A collection of bytes in memory.<br>[jvm, nonJvm]<br>[jvm]<br>actual class [Buffer](-buffer/index.md) : [BufferedSource](-buffered-source/index.md), [BufferedSink](-buffered-sink/index.md), [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html), [ByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ByteChannel.html)<br>[nonJvm]<br>actual class [Buffer](-buffer/index.md) : [BufferedSource](-buffered-source/index.md), [BufferedSink](-buffered-sink/index.md) |
| [BufferedSink](-buffered-sink/index.md) | [common]<br>expect interface [BufferedSink](-buffered-sink/index.md) : [Sink](-sink/index.md)<br>A sink that keeps a buffer internally so that callers can do small writes without a performance penalty.<br>[jvm, nonJvm]<br>[jvm]<br>actual interface [BufferedSink](-buffered-sink/index.md) : [Sink](-sink/index.md), [WritableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/WritableByteChannel.html)<br>[nonJvm]<br>actual interface [BufferedSink](-buffered-sink/index.md) : [Sink](-sink/index.md) |
| [BufferedSource](-buffered-source/index.md) | [common]<br>expect interface [BufferedSource](-buffered-source/index.md) : [Source](-source/index.md)<br>A source that keeps a buffer internally so that callers can do small reads without a performance penalty. It also allows clients to read ahead, buffering as much as necessary before consuming input.<br>[jvm, nonJvm]<br>[jvm]<br>actual interface [BufferedSource](-buffered-source/index.md) : [Source](-source/index.md#1331753033%2FMain%2F1033915053), [ReadableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ReadableByteChannel.html)<br>[nonJvm]<br>actual interface [BufferedSource](-buffered-source/index.md) : [Source](-source/index.md) |
| [ByteString](-byte-string/index.md) | [common]<br>expect open class [ByteString](-byte-string/index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[ByteString](-byte-string/index.md)&gt; <br>An immutable sequence of bytes.<br>[apple, jvm, nonApple]<br>[apple, nonApple]<br>actual open class [ByteString](-byte-string/index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[ByteString](-byte-string/index.md)&gt; <br>[jvm]<br>actual open class [ByteString](-byte-string/index.md) : [Serializable](https://docs.oracle.com/javase/8/docs/api/java/io/Serializable.html), [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[ByteString](-byte-string/index.md)&gt; |
| [CipherSink](-cipher-sink/index.md) | [jvm]<br>class [CipherSink](-cipher-sink/index.md)(sink: [BufferedSink](-buffered-sink/index.md), val cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)) : [Sink](-sink/index.md) |
| [CipherSource](-cipher-source/index.md) | [jvm]<br>class [CipherSource](-cipher-source/index.md)(source: [BufferedSource](-buffered-source/index.md), val cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)) : [Source](-source/index.md#1331753033%2FMain%2F1033915053) |
| [Closeable](-closeable/index.md) | [common, nonJvm, jvm]<br>[common]<br>expect interface [Closeable](-closeable/index.md)<br>[nonJvm]<br>actual interface [Closeable](-closeable/index.md)<br>[jvm]<br>actual typealias [Closeable](-closeable/index.md) = [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html) |
| [DeflaterSink](-deflater-sink/index.md) | [jvm]<br>class [DeflaterSink](-deflater-sink/index.md) : [Sink](-sink/index.md)<br>A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source. |
| [EOFException](-e-o-f-exception/index.md) | [common, nonJvm, jvm]<br>[common]<br>expect open class [EOFException](-e-o-f-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null) : [IOException](-i-o-exception/index.md)<br>[nonJvm]<br>actual open class [EOFException](-e-o-f-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IOException](-i-o-exception/index.md)<br>[jvm]<br>actual typealias [EOFException](-e-o-f-exception/index.md) = [EOFException](https://docs.oracle.com/javase/8/docs/api/java/io/EOFException.html) |
| [FileHandle](-file-handle/index.md) | [common]<br>abstract class [FileHandle](-file-handle/index.md)(val readWrite: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) : [Closeable](-closeable/index.md)<br>An open file for reading and writing; using either streaming and random access. |
| [FileMetadata](-file-metadata/index.md) | [common]<br>class [FileMetadata](-file-metadata/index.md)(val isRegularFile: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, val isDirectory: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, val symlinkTarget: [Path](-path/index.md)? = null, val size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)? = null, val createdAtMillis: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)? = null, val lastModifiedAtMillis: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)? = null, val lastAccessedAtMillis: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)? = null, extras: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;, [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; = mapOf())<br>Description of a file or another object referenced by a path. |
| [FileNotFoundException](-file-not-found-exception/index.md) | [common, nonJvm, jvm]<br>[common]<br>expect class [FileNotFoundException](-file-not-found-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null) : [IOException](-i-o-exception/index.md)<br>[nonJvm]<br>actual open class [FileNotFoundException](-file-not-found-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IOException](-i-o-exception/index.md)<br>[jvm]<br>actual typealias [FileNotFoundException](-file-not-found-exception/index.md) = [FileNotFoundException](https://docs.oracle.com/javase/8/docs/api/java/io/FileNotFoundException.html) |
| [FileSystem](-file-system/index.md) | [common]<br>expect abstract class [FileSystem](-file-system/index.md)<br>Read and write access to a hierarchical collection of files, addressed by [paths](-path/index.md). This is a natural interface to the current computer's local file system.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual abstract class [FileSystem](-file-system/index.md) |
| [ForwardingFileSystem](-forwarding-file-system/index.md) | [common]<br>abstract class [ForwardingFileSystem](-forwarding-file-system/index.md)(val delegate: [FileSystem](-file-system/index.md)) : [FileSystem](-file-system/index.md)<br>A [FileSystem](-file-system/index.md) that forwards calls to another, intended for subclassing. |
| [ForwardingSink](-forwarding-sink/index.md) | [jvm]<br>abstract class [ForwardingSink](-forwarding-sink/index.md)(val delegate: [Sink](-sink/index.md)) : [Sink](-sink/index.md)<br>A [Sink](-sink/index.md) which forwards calls to another. Useful for subclassing. |
| [ForwardingSource](-forwarding-source/index.md) | [common]<br>expect abstract class [ForwardingSource](-forwarding-source/index.md)(delegate: [Source](-source/index.md)) : [Source](-source/index.md)<br>A [Source](-source/index.md) which forwards calls to another. Useful for subclassing.<br>[jvm, nonJvm]<br>[jvm]<br>actual abstract class [ForwardingSource](-forwarding-source/index.md)(val delegate: [Source](-source/index.md#1331753033%2FMain%2F1033915053)) : [Source](-source/index.md#1331753033%2FMain%2F1033915053)<br>[nonJvm]<br>actual abstract class [ForwardingSource](-forwarding-source/index.md)(val delegate: [Source](-source/index.md)) : [Source](-source/index.md) |
| [ForwardingTimeout](-forwarding-timeout/index.md) | [jvm]<br>open class [ForwardingTimeout](-forwarding-timeout/index.md)(var delegate: [Timeout](-timeout/index.md)) : [Timeout](-timeout/index.md)<br>A [Timeout](-timeout/index.md) which forwards calls to another. Useful for subclassing. |
| [GzipSink](-gzip-sink/index.md) | [jvm]<br>class [GzipSink](-gzip-sink/index.md)(sink: [Sink](-sink/index.md)) : [Sink](-sink/index.md)<br>A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink. |
| [GzipSource](-gzip-source/index.md) | [jvm]<br>class [GzipSource](-gzip-source/index.md)(source: [Source](-source/index.md#1331753033%2FMain%2F1033915053)) : [Source](-source/index.md#1331753033%2FMain%2F1033915053)<br>A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to decompress data read from another source. |
| [HashingSink](-hashing-sink/index.md) | [common, jvm]<br>[common]<br>expect class [HashingSink](-hashing-sink/index.md) : [Sink](-sink/index.md)<br>[jvm]<br>actual class [HashingSink](-hashing-sink/index.md) : [ForwardingSink](-forwarding-sink/index.md), [Sink](-sink/index.md)<br>A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](-hashing-sink/hash.md) to compute the final hash value.<br>[nonJvm]<br>actual class [HashingSink](-hashing-sink/index.md) : [Sink](-sink/index.md) |
| [HashingSource](-hashing-source/index.md) | [common, jvm]<br>[common]<br>expect class [HashingSource](-hashing-source/index.md) : [Source](-source/index.md)<br>[jvm]<br>actual class [HashingSource](-hashing-source/index.md) : [ForwardingSource](-forwarding-source/index.md), [Source](-source/index.md#1331753033%2FMain%2F1033915053)<br>A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](-hashing-source/hash.md) to compute the final hash value.<br>[nonJvm]<br>actual class [HashingSource](-hashing-source/index.md) : [Source](-source/index.md) |
| [InflaterSource](-inflater-source/index.md) | [jvm]<br>class [InflaterSource](-inflater-source/index.md) : [Source](-source/index.md#1331753033%2FMain%2F1033915053)<br>A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from another source. |
| [IOException](-i-o-exception/index.md) | [common, nonJvm, jvm]<br>[common]<br>expect open class [IOException](-i-o-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, cause: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)?) : [Exception](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)<br>[nonJvm]<br>actual open class [IOException](-i-o-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, cause: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)?) : [Exception](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)<br>[jvm]<br>actual typealias [IOException](-i-o-exception/index.md) = [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html) |
| [Lock](-lock/index.md) | [common, nonJvm, jvm]<br>[common]<br>expect class [Lock](-lock/index.md)<br>[nonJvm]<br>actual class [Lock](-lock/index.md)<br>[jvm]<br>actual typealias [Lock](-lock/index.md) = [ReentrantLock](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/locks/ReentrantLock.html) |
| [Options](-options/index.md) | [common]<br>class [Options](-options/index.md) : [AbstractList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-abstract-list/index.html)&lt;[ByteString](-byte-string/index.md)&gt; , [RandomAccess](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-random-access/index.html)<br>An indexed set of values that may be read with [BufferedSource.select](-buffered-source/select.md). |
| [Path](-path/index.md) | [common]<br>expect class [Path](-path/index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[Path](-path/index.md)&gt; <br>A hierarchical address on a file system. A path is an identifier only; a [FileSystem](-file-system/index.md) is required to access the file that a path refers to, if any.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual class [Path](-path/index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[Path](-path/index.md)&gt; |
| [Pipe](-pipe/index.md) | [jvm]<br>class [Pipe](-pipe/index.md)(maxBufferSize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>A source and a sink that are attached. The sink's output is the source's input. Typically each is accessed by its own thread: a producer thread writes data to the sink and a consumer thread reads data from the source. |
| [ProtocolException](-protocol-exception/index.md) | [common, nonJvm, jvm]<br>[common]<br>expect class [ProtocolException](-protocol-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : [IOException](-i-o-exception/index.md)<br>[nonJvm]<br>actual class [ProtocolException](-protocol-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : [IOException](-i-o-exception/index.md)<br>[jvm]<br>actual typealias [ProtocolException](-protocol-exception/index.md) = [ProtocolException](https://docs.oracle.com/javase/8/docs/api/java/net/ProtocolException.html) |
| [Sink](-sink/index.md) | [common]<br>expect interface [Sink](-sink/index.md) : [Closeable](-closeable/index.md)<br>Receives a stream of bytes. Use this interface to write data wherever it's needed: to the network, storage, or a buffer in memory. Sinks may be layered to transform received data, such as to compress, encrypt, throttle, or add protocol framing.<br>[jvm, nonJvm]<br>[jvm]<br>actual interface [Sink](-sink/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html), [Flushable](https://docs.oracle.com/javase/8/docs/api/java/io/Flushable.html)<br>[nonJvm]<br>actual interface [Sink](-sink/index.md) : [Closeable](-closeable/index.md) |
| [Source](-source/index.md) | [common]<br>interface [Source](-source/index.md) : [Closeable](-closeable/index.md)<br>Supplies a stream of bytes. Use this interface to read data from wherever it's located: from the network, storage, or a buffer in memory. Sources may be layered to transform supplied data, such as to decompress, decrypt, or remove protocol framing. |
| [Throttler](-throttler/index.md) | [jvm]<br>class [Throttler](-throttler/index.md)<br>Enables limiting of Source and Sink throughput. Attach to this throttler via [source](-throttler/source.md) and [sink](-throttler/sink.md) and set the desired throughput via [bytesPerSecond](-throttler/bytes-per-second.md). Multiple Sources and Sinks can be attached to a single Throttler and they will be throttled as a group, where their combined throughput will not exceed the desired throughput. The same Source or Sink can be attached to multiple Throttlers and its throughput will not exceed the desired throughput of any of the Throttlers. |
| [Timeout](-timeout/index.md) | [common]<br>expect open class [Timeout](-timeout/index.md)<br>A policy on how much time to spend on a task before giving up. When a task times out, it is left in an unspecified state and should be abandoned. For example, if reading from a source times out, that source should be closed and the read should be retried later. If writing to a sink times out, the same rules apply: close the sink and retry later.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open class [Timeout](-timeout/index.md) |

## Properties

| Name | Summary |
|---|---|
| [Okio](-okio.md) | [jvm]<br>val [Okio](-okio.md): -DeprecatedOkio |
| [Utf8](-utf8.md) | [jvm]<br>val [Utf8](-utf8.md): -DeprecatedUtf8 |

## Functions

| Name | Summary |
|---|---|
| [appendingSink](appending-sink.md) | [jvm]<br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[appendingSink](appending-sink.md)(): [Sink](-sink/index.md)<br>Returns a sink that writes to `file`. |
| [asResourceFileSystem](as-resource-file-system.md) | [jvm]<br>fun [ClassLoader](https://docs.oracle.com/javase/8/docs/api/java/lang/ClassLoader.html).[asResourceFileSystem](as-resource-file-system.md)(): [FileSystem](-file-system/index.md) |
| [blackholeSink](blackhole-sink.md) | [common]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;blackhole&quot;)<br>fun [blackholeSink](blackhole-sink.md)(): [Sink](-sink/index.md)<br>Returns a sink that writes nowhere. |
| [buffer](buffer.md) | [common]<br>fun [Sink](-sink/index.md).[buffer](buffer.md)(): [BufferedSink](-buffered-sink/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data.<br>[common]<br>fun [Source](-source/index.md).[buffer](buffer.md)(): [BufferedSource](-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [cipherSink](cipher-sink.md) | [jvm]<br>fun [Sink](-sink/index.md).[cipherSink](cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](-cipher-sink/index.md)<br>Returns a sink that uses [cipher](cipher-sink.md) to encrypt or decrypt this. |
| [cipherSource](cipher-source.md) | [jvm]<br>fun [Source](-source/index.md#1331753033%2FMain%2F1033915053).[cipherSource](cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](-cipher-source/index.md)<br>Returns a source that uses [cipher](cipher-source.md) to encrypt or decrypt this. |
| [deflate](deflate.md) | [jvm]<br>inline fun [Sink](-sink/index.md).[deflate](deflate.md)(deflater: [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) = Deflater()): [DeflaterSink](-deflater-sink/index.md)<br>Returns an [DeflaterSink](-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](-sink/index.md) while writing. |
| [gzip](gzip.md) | [jvm]<br>inline fun [Sink](-sink/index.md).[gzip](gzip.md)(): [GzipSink](-gzip-sink/index.md)<br>Returns a [GzipSink](-gzip-sink/index.md) that gzip-compresses to this [Sink](-sink/index.md) while writing.<br>[jvm]<br>inline fun [Source](-source/index.md#1331753033%2FMain%2F1033915053).[gzip](gzip.md)(): [GzipSource](-gzip-source/index.md)<br>Returns a [GzipSource](-gzip-source/index.md) that gzip-decompresses this [Source](-source/index.md#1331753033%2FMain%2F1033915053) while reading. |
| [hashingSink](hashing-sink.md) | [jvm]<br>fun [Sink](-sink/index.md).[hashingSink](hashing-sink.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSink](-hashing-sink/index.md)<br>Returns a sink that uses [digest](hashing-sink.md) to hash this.<br>[jvm]<br>fun [Sink](-sink/index.md).[hashingSink](hashing-sink.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSink](-hashing-sink/index.md)<br>Returns a sink that uses [mac](hashing-sink.md) to hash this. |
| [hashingSource](hashing-source.md) | [jvm]<br>fun [Source](-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](hashing-source.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSource](-hashing-source/index.md)<br>Returns a source that uses [digest](hashing-source.md) to hash this.<br>[jvm]<br>fun [Source](-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](hashing-source.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSource](-hashing-source/index.md)<br>Returns a source that uses [mac](hashing-source.md) to hash this. |
| [inflate](inflate.md) | [jvm]<br>inline fun [Source](-source/index.md#1331753033%2FMain%2F1033915053).[inflate](inflate.md)(inflater: [Inflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html) = Inflater()): [InflaterSource](-inflater-source/index.md)<br>Returns an [InflaterSource](-inflater-source/index.md) that DEFLATE-decompresses this [Source](-source/index.md#1331753033%2FMain%2F1033915053) while reading. |
| [openZip](open-zip.md) | [jvm]<br>fun [FileSystem](-file-system/index.md).[openZip](open-zip.md)(zipPath: [Path](-path/index.md)): [FileSystem](-file-system/index.md) |
| [sink](sink.md) | [jvm]<br>fun [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html).[sink](sink.md)(): [Sink](-sink/index.md)<br>Returns a sink that writes to `out`.<br>[jvm]<br>fun [Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html).[sink](sink.md)(): [Sink](-sink/index.md)<br>Returns a sink that writes to `socket`. Prefer this over [sink](sink.md) because this method honors timeouts. When the socket write times out, the socket is asynchronously closed by a watchdog thread.<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[sink](sink.md)(append: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [Sink](-sink/index.md)<br>Returns a sink that writes to `file`.<br>[jvm]<br>fun [Path](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html).[sink](sink.md)(vararg options: [OpenOption](https://docs.oracle.com/javase/8/docs/api/java/nio/file/OpenOption.html)): [Sink](-sink/index.md)<br>Returns a sink that writes to `path`. |
| [source](source.md) | [jvm]<br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[source](source.md)(): [Source](-source/index.md#1331753033%2FMain%2F1033915053)<br>Returns a source that reads from `file`.<br>[jvm]<br>fun [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html).[source](source.md)(): [Source](-source/index.md#1331753033%2FMain%2F1033915053)<br>Returns a source that reads from `in`.<br>[jvm]<br>fun [Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html).[source](source.md)(): [Source](-source/index.md#1331753033%2FMain%2F1033915053)<br>Returns a source that reads from `socket`. Prefer this over [source](source.md) because this method honors timeouts. When the socket read times out, the socket is asynchronously closed by a watchdog thread.<br>[jvm]<br>fun [Path](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html).[source](source.md)(vararg options: [OpenOption](https://docs.oracle.com/javase/8/docs/api/java/nio/file/OpenOption.html)): [Source](-source/index.md#1331753033%2FMain%2F1033915053)<br>Returns a source that reads from `path`. |
| [use](use.md) | [common]<br>inline fun &lt;[T](use.md) : [Closeable](-closeable/index.md)?, [R](use.md)&gt; [T](use.md).[use](use.md)(block: ([T](use.md)) -&gt; [R](use.md)): [R](use.md)<br>Execute [block](use.md) then close this. This will be closed even if [block](use.md) throws. |
| [utf8Size](utf8-size.md) | [common]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;size&quot;)<br>fun [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).[utf8Size](utf8-size.md)(beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = length): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the number of bytes used to encode the slice of `string` as UTF-8 when using [BufferedSink.writeUtf8](-buffered-sink/write-utf8.md). |
| [withLock](with-lock.md) | [common, nonJvm]<br>[common]<br>expect inline fun &lt;[T](with-lock.md)&gt; [Lock](-lock/index.md).[withLock](with-lock.md)(action: () -&gt; [T](with-lock.md)): [T](with-lock.md)<br>[nonJvm]<br>actual inline fun &lt;[T](with-lock.md)&gt; [Lock](-lock/index.md).[withLock](with-lock.md)(action: () -&gt; [T](with-lock.md)): [T](with-lock.md) |
