/*
 * Decompiled with CFR 0.152.
 */
package okio.zipfilesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.Cursor;
import okio.ExperimentalFileSystem;
import okio.FileMetadata;
import okio.FileSystem;
import okio.InflaterSource;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import okio.zipfilesystem.FixedLengthSource;
import okio.zipfilesystem.ZipEntry;
import okio.zipfilesystem.ZipKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lokio/zipfilesystem/ZipFileSystem;", "Lokio/FileSystem;", "zipPath", "Lokio/Path;", "fileSystem", "entries", "", "Lokio/zipfilesystem/ZipEntry;", "comment", "", "(Lokio/Path;Lokio/FileSystem;Ljava/util/Map;Ljava/lang/String;)V", "appendingSink", "Lokio/Sink;", "file", "atomicMove", "", "source", "target", "canonicalize", "path", "createDirectory", "dir", "delete", "list", "", "metadataOrNull", "Lokio/FileMetadata;", "sink", "Lokio/Source;", "Companion", "okio-zipfilesystem"})
@ExperimentalFileSystem
public final class ZipFileSystem
extends FileSystem {
    private final Path zipPath;
    private final FileSystem fileSystem;
    private final Map<Path, ZipEntry> entries;
    private final String comment;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Path canonicalize(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Path.Companion.get("/").resolve(path);
    }

    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.canonicalize(path);
        ZipEntry zipEntry = this.entries.get(canonicalPath);
        if (zipEntry == null) {
            return null;
        }
        ZipEntry entry = zipEntry;
        FileMetadata basicMetadata = new FileMetadata(!entry.isDirectory(), entry.isDirectory(), entry.isDirectory() ? null : Long.valueOf(entry.getSize()), null, entry.getLastModifiedAtMillis(), null);
        if (entry.getOffset() == -1L) {
            return basicMetadata;
        }
        BufferedSource source = Okio.buffer((Source)this.fileSystem.source(this.zipPath));
        Cursor cursor = source.cursor();
        Intrinsics.checkNotNull((Object)cursor);
        Cursor cursor2 = cursor;
        cursor2.seek(entry.getOffset());
        return ZipKt.readLocalHeader(source, basicMetadata);
    }

    @NotNull
    public List<Path> list(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Path canonicalDir = this.canonicalize(dir);
        ZipEntry zipEntry = this.entries.get(canonicalDir);
        if (zipEntry == null) {
            throw (Throwable)new IOException("not a directory: " + dir);
        }
        ZipEntry entry = zipEntry;
        return CollectionsKt.toList((Iterable)entry.getChildren());
    }

    @NotNull
    public Source source(@NotNull Path path) throws IOException {
        Source source;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path canonicalPath = this.canonicalize(path);
        ZipEntry zipEntry = this.entries.get(canonicalPath);
        if (zipEntry == null) {
            throw (Throwable)new FileNotFoundException("no such file: " + path);
        }
        ZipEntry entry = zipEntry;
        BufferedSource source2 = Okio.buffer((Source)this.fileSystem.source(this.zipPath));
        Cursor cursor = source2.cursor();
        Intrinsics.checkNotNull((Object)cursor);
        Cursor cursor2 = cursor;
        cursor2.seek(entry.getOffset());
        ZipKt.skipLocalHeader(source2);
        switch (entry.getCompressionMethod()) {
            case 0: {
                source = (Source)new FixedLengthSource((Source)source2, entry.getSize(), true);
                break;
            }
            default: {
                InflaterSource inflaterSource = new InflaterSource((Source)new FixedLengthSource((Source)source2, entry.getCompressedSize(), true), new Inflater(true));
                source = (Source)new FixedLengthSource((Source)inflaterSource, entry.getSize(), false);
            }
        }
        return source;
    }

    @NotNull
    public Sink sink(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw (Throwable)new IOException("zip file systems are read-only");
    }

    @NotNull
    public Sink appendingSink(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        throw (Throwable)new IOException("zip file systems are read-only");
    }

    public void createDirectory(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        throw (Throwable)new IOException("zip file systems are read-only");
    }

    public void atomicMove(@NotNull Path source, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        throw (Throwable)new IOException("zip file systems are read-only");
    }

    public void delete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        throw (Throwable)new IOException("zip file systems are read-only");
    }

    public ZipFileSystem(@NotNull Path zipPath, @NotNull FileSystem fileSystem, @NotNull Map<Path, ZipEntry> entries, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.zipPath = zipPath;
        this.fileSystem = fileSystem;
        this.entries = entries;
        this.comment = comment;
    }

    @JvmStatic
    @ExperimentalFileSystem
    @JvmName(name="open")
    @NotNull
    public static final ZipFileSystem open(@NotNull FileSystem $this$openZip, @NotNull Path zipPath) throws IOException {
        return Companion.open($this$openZip, zipPath);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lokio/zipfilesystem/ZipFileSystem$Companion;", "", "()V", "openZip", "Lokio/zipfilesystem/ZipFileSystem;", "Lokio/FileSystem;", "zipPath", "Lokio/Path;", "open", "okio-zipfilesystem"})
    public static final class Companion {
        @JvmStatic
        @ExperimentalFileSystem
        @JvmName(name="open")
        @NotNull
        public final ZipFileSystem open(@NotNull FileSystem $this$openZip, @NotNull Path zipPath) throws IOException {
            Intrinsics.checkNotNullParameter((Object)$this$openZip, (String)"$this$openZip");
            Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
            return ZipKt.open(zipPath, $this$openZip);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

