/*
 * Decompiled with CFR 0.152.
 */
package okio.zipfilesystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Cursor;
import okio.ExperimentalFileSystem;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import okio.zipfilesystem.EocdRecord;
import okio.zipfilesystem.ZipEntry;
import okio.zipfilesystem.ZipFileSystem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\"\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0003\u001a\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0001\u001a\f\u0010!\u001a\u00020\u0015*\u00020\"H\u0001\u001a\f\u0010#\u001a\u00020$*\u00020\"H\u0002\u001a.\u0010%\u001a\u00020&*\u00020\"2\u0006\u0010'\u001a\u00020\u00012\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020&0)H\u0002\u001a\u0014\u0010*\u001a\u00020+*\u00020\"2\u0006\u0010,\u001a\u00020+H\u0001\u001a\u0018\u0010-\u001a\u0004\u0018\u00010+*\u00020\"2\b\u0010,\u001a\u0004\u0018\u00010+H\u0003\u001a\u0014\u0010.\u001a\u00020$*\u00020\"2\u0006\u0010/\u001a\u00020$H\u0002\u001a\f\u00100\u001a\u00020&*\u00020\"H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00061"}, d2={"BIT_FLAG_ENCRYPTED", "", "BIT_FLAG_UNSUPPORTED_MASK", "CENTRAL_FILE_HEADER_SIGNATURE", "COMPRESSION_METHOD_DEFLATED", "COMPRESSION_METHOD_STORED", "END_OF_CENTRAL_DIRECTORY_SIGNATURE", "HEADER_ID_EXTENDED_TIMESTAMP", "HEADER_ID_ZIP64_EXTENDED_INFO", "LOCAL_FILE_HEADER_SIGNATURE", "MAX_ZIP_ENTRY_AND_ARCHIVE_SIZE", "", "ZIP64_EOCD_RECORD_SIGNATURE", "ZIP64_LOCATOR_SIGNATURE", "hex", "", "getHex", "(I)Ljava/lang/String;", "buildIndex", "", "Lokio/Path;", "Lokio/zipfilesystem/ZipEntry;", "entries", "", "dosDateTimeToEpochMillis", "date", "time", "(II)Ljava/lang/Long;", "open", "Lokio/zipfilesystem/ZipFileSystem;", "zipPath", "fileSystem", "Lokio/FileSystem;", "readEntry", "Lokio/BufferedSource;", "readEocdRecord", "Lokio/zipfilesystem/EocdRecord;", "readExtra", "", "extraSize", "block", "Lkotlin/Function2;", "readLocalHeader", "Lokio/FileMetadata;", "basicMetadata", "readOrSkipLocalHeader", "readZip64EocdRecord", "regularRecord", "skipLocalHeader", "okio-zipfilesystem"})
public final class ZipKt {
    private static final int LOCAL_FILE_HEADER_SIGNATURE = 67324752;
    private static final int CENTRAL_FILE_HEADER_SIGNATURE = 33639248;
    private static final int END_OF_CENTRAL_DIRECTORY_SIGNATURE = 101010256;
    private static final int ZIP64_LOCATOR_SIGNATURE = 117853008;
    private static final int ZIP64_EOCD_RECORD_SIGNATURE = 101075792;
    public static final int COMPRESSION_METHOD_DEFLATED = 8;
    public static final int COMPRESSION_METHOD_STORED = 0;
    private static final int BIT_FLAG_ENCRYPTED = 1;
    private static final int BIT_FLAG_UNSUPPORTED_MASK = 1;
    private static final long MAX_ZIP_ENTRY_AND_ARCHIVE_SIZE = 0xFFFFFFFFL;
    private static final int HEADER_ID_ZIP64_EXTENDED_INFO = 1;
    private static final int HEADER_ID_EXTENDED_TIMESTAMP = 21589;

    /*
     * WARNING - void declaration
     */
    @ExperimentalFileSystem
    @NotNull
    public static final ZipFileSystem open(@NotNull Path zipPath, @NotNull FileSystem fileSystem) throws IOException {
        long eocdOffset;
        long scanOffset;
        Cursor cursor;
        BufferedSource source;
        block11: {
            Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            source = Okio.buffer((Source)fileSystem.source(zipPath));
            Cursor cursor2 = source.cursor();
            if (cursor2 == null) {
                throw (Throwable)new IOException("cannot open zip: file doesn't implement a random-access cursor");
            }
            cursor = cursor2;
            int firstFileSignature = source.readIntLe();
            if (firstFileSignature != 67324752) {
                if (firstFileSignature == 101010256) {
                    throw (Throwable)new IOException("unsupported zip: empty");
                }
                throw (Throwable)new IOException("not a zip: expected " + ZipKt.getHex(67324752) + " but was " + ZipKt.getHex(firstFileSignature));
            }
            scanOffset = cursor.size() - (long)22;
            if (scanOffset < 0L) {
                throw (Throwable)new IOException("not a zip: size=" + cursor.size());
            }
            long l = scanOffset - 65536L;
            long l2 = 0L;
            boolean bl = false;
            long stopOffset = Math.max(l, l2);
            eocdOffset = 0L;
            do {
                cursor.seek(scanOffset);
                if (source.readIntLe() == 101010256) break block11;
            } while ((scanOffset = (l2 = scanOffset) + -1L) >= stopOffset);
            throw (Throwable)new IOException("not a zip: end of central directory signature not found");
        }
        eocdOffset = scanOffset;
        EocdRecord record = ZipKt.readEocdRecord(source);
        String comment = source.readUtf8((long)record.getCommentByteCount());
        long zip64LocatorOffset = eocdOffset - (long)20;
        if (zip64LocatorOffset > 0L) {
            cursor.seek(zip64LocatorOffset);
            if (source.readIntLe() == 117853008) {
                int diskWithCentralDir = source.readIntLe();
                long zip64EocdRecordOffset22 = source.readLongLe();
                int numDisks = source.readIntLe();
                if (numDisks != 1 || diskWithCentralDir != 0) {
                    throw (Throwable)new IOException("unsupported zip: spanned");
                }
                cursor.seek(zip64EocdRecordOffset22);
                int zip64EocdSignature = source.readIntLe();
                if (zip64EocdSignature != 101075792) {
                    throw (Throwable)new IOException("bad zip: expected " + ZipKt.getHex(101075792) + " but was " + ZipKt.getHex(zip64EocdSignature));
                }
                record = ZipKt.readZip64EocdRecord(source, record);
            }
        }
        cursor.seek(record.getCentralDirectoryOffset());
        boolean zip64EocdRecordOffset22 = false;
        List entries = new ArrayList();
        long zip64EocdRecordOffset22 = 0L;
        long l = record.getEntryCount();
        while (zip64EocdRecordOffset22 < l) {
            void i;
            ZipEntry newEntry = ZipKt.readEntry(source);
            if (newEntry.getOffset() >= record.getCentralDirectoryOffset()) {
                throw (Throwable)new IOException("bad zip: local file header offset >= central directory offset");
            }
            Collection collection = entries;
            boolean bl = false;
            collection.add(newEntry);
            ++i;
        }
        Map<Path, ZipEntry> index = ZipKt.buildIndex(entries);
        return new ZipFileSystem(zipPath, fileSystem, index, comment);
    }

    @ExperimentalFileSystem
    private static final Map<Path, ZipEntry> buildIndex(List<ZipEntry> entries) {
        boolean bl = false;
        Map result = new LinkedHashMap();
        Iterable $this$sortedBy$iv = entries;
        boolean $i$f$sortedBy = false;
        boolean bl2 = false;
        block0: for (ZipEntry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ZipEntry it = (ZipEntry)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)it.getCanonicalPath();
                it = (ZipEntry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Path path = it.getCanonicalPath();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)path));
            }
        })) {
            if (result.put(entry.getCanonicalPath(), entry) != null) {
                throw (Throwable)new IOException("bad zip: duplicate path: " + entry.getCanonicalPath());
            }
            ZipEntry child = entry;
            while (true) {
                boolean bl3;
                Path path;
                Collection collection;
                Path parentPath;
                if (child.getCanonicalPath().parent() == null) {
                    continue block0;
                }
                ZipEntry parentEntry = (ZipEntry)result.get(parentPath);
                if (parentEntry != null) {
                    collection = parentEntry.getChildren();
                    path = child.getCanonicalPath();
                    bl3 = false;
                    collection.add(path);
                    continue block0;
                }
                parentEntry = new ZipEntry(parentPath, true, null, 0L, 0L, 0L, 0, null, 0L, 508, null);
                result.put(parentPath, parentEntry);
                collection = parentEntry.getChildren();
                path = child.getCanonicalPath();
                bl3 = false;
                collection.add(path);
                child = parentEntry;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalFileSystem
    @NotNull
    public static final ZipEntry readEntry(@NotNull BufferedSource $this$readEntry) throws IOException {
        void hasZip64Extra;
        void offset;
        void compressedSize;
        void size;
        Intrinsics.checkNotNullParameter((Object)$this$readEntry, (String)"$this$readEntry");
        int signature = $this$readEntry.readIntLe();
        if (signature != 33639248) {
            throw (Throwable)new IOException("bad zip: expected " + ZipKt.getHex(33639248) + " but was " + ZipKt.getHex(signature));
        }
        $this$readEntry.skip(4L);
        int bitFlag = $this$readEntry.readShortLe() & 0xFFFF;
        if ((bitFlag & 1) != 0) {
            throw (Throwable)new IOException("unsupported zip: general purpose bit flag=" + ZipKt.getHex(bitFlag));
        }
        int compressionMethod = $this$readEntry.readShortLe() & 0xFFFF;
        int time = $this$readEntry.readShortLe() & 0xFFFF;
        int date = $this$readEntry.readShortLe() & 0xFFFF;
        Long lastModifiedAtMillis = ZipKt.dosDateTimeToEpochMillis(date, time);
        long crc = (long)$this$readEntry.readIntLe() & 0xFFFFFFFFL;
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = (long)$this$readEntry.readIntLe() & 0xFFFFFFFFL;
        Ref.LongRef longRef2 = new Ref.LongRef();
        longRef2.element = (long)$this$readEntry.readIntLe() & 0xFFFFFFFFL;
        int nameSize = $this$readEntry.readShortLe() & 0xFFFF;
        int extraSize = $this$readEntry.readShortLe() & 0xFFFF;
        int commentByteCount = $this$readEntry.readShortLe() & 0xFFFF;
        $this$readEntry.skip(8L);
        Ref.LongRef longRef3 = new Ref.LongRef();
        longRef3.element = (long)$this$readEntry.readIntLe() & 0xFFFFFFFFL;
        String name = $this$readEntry.readUtf8((long)nameSize);
        if (StringsKt.contains$default((CharSequence)name, (char)'\u0000', (boolean)false, (int)2, null)) {
            throw (Throwable)new IOException("bad zip: filename contains 0x00");
        }
        BufferedSource bufferedSource = $this$readEntry;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSource $this$run = bufferedSource;
        boolean bl3 = false;
        long result = 0L;
        if (size.element == 0xFFFFFFFFL) {
            result += (long)8;
        }
        if (compressedSize.element == 0xFFFFFFFFL) {
            result += (long)8;
        }
        if (offset.element == 0xFFFFFFFFL) {
            result += (long)8;
        }
        long requiredZip64ExtraSize = result;
        bufferedSource = new Ref.BooleanRef();
        bufferedSource.element = false;
        ZipKt.readExtra($this$readEntry, extraSize, (Function2<? super Integer, ? super Long, Unit>)((Function2)new Function2<Integer, Long, Unit>($this$readEntry, (Ref.BooleanRef)hasZip64Extra, requiredZip64ExtraSize, (Ref.LongRef)size, (Ref.LongRef)compressedSize, (Ref.LongRef)offset){
            final /* synthetic */ BufferedSource $this_readEntry;
            final /* synthetic */ Ref.BooleanRef $hasZip64Extra;
            final /* synthetic */ long $requiredZip64ExtraSize;
            final /* synthetic */ Ref.LongRef $size;
            final /* synthetic */ Ref.LongRef $compressedSize;
            final /* synthetic */ Ref.LongRef $offset;

            public final void invoke(int headerId, long dataSize) {
                switch (headerId) {
                    case 1: {
                        if (this.$hasZip64Extra.element) {
                            throw (Throwable)new IOException("bad zip: zip64 extra repeated");
                        }
                        this.$hasZip64Extra.element = true;
                        if (dataSize < this.$requiredZip64ExtraSize) {
                            throw (Throwable)new IOException("bad zip: zip64 extra too short");
                        }
                        this.$size.element = this.$size.element == 0xFFFFFFFFL ? this.$this_readEntry.readLongLe() : this.$size.element;
                        this.$compressedSize.element = this.$compressedSize.element == 0xFFFFFFFFL ? this.$this_readEntry.readLongLe() : 0L;
                        this.$offset.element = this.$offset.element == 0xFFFFFFFFL ? this.$this_readEntry.readLongLe() : 0L;
                        break;
                    }
                }
            }
            {
                this.$this_readEntry = bufferedSource;
                this.$hasZip64Extra = booleanRef;
                this.$requiredZip64ExtraSize = l;
                this.$size = longRef;
                this.$compressedSize = longRef2;
                this.$offset = longRef3;
                super(2);
            }
        }));
        if (requiredZip64ExtraSize > 0L && !hasZip64Extra.element) {
            throw (Throwable)new IOException("bad zip: zip64 extra required but absent");
        }
        String comment = $this$readEntry.readUtf8((long)commentByteCount);
        Path canonicalPath = Path.Companion.get("/").resolve(name);
        boolean isDirectory = StringsKt.endsWith$default((String)name, (String)"/", (boolean)false, (int)2, null);
        return new ZipEntry(canonicalPath, isDirectory, comment, crc, compressedSize.element, size.element, compressionMethod, lastModifiedAtMillis, offset.element);
    }

    private static final EocdRecord readEocdRecord(BufferedSource $this$readEocdRecord) throws IOException {
        long totalEntryCount;
        int diskNumber = $this$readEocdRecord.readShortLe() & 0xFFFF;
        int diskWithCentralDir = $this$readEocdRecord.readShortLe() & 0xFFFF;
        long entryCount = $this$readEocdRecord.readShortLe() & 0xFFFF;
        if (entryCount != (totalEntryCount = (long)($this$readEocdRecord.readShortLe() & 0xFFFF)) || diskNumber != 0 || diskWithCentralDir != 0) {
            throw (Throwable)new IOException("unsupported zip: spanned");
        }
        $this$readEocdRecord.skip(4L);
        long centralDirectoryOffset = (long)$this$readEocdRecord.readIntLe() & 0xFFFFFFFFL;
        int commentByteCount = $this$readEocdRecord.readShortLe() & 0xFFFF;
        return new EocdRecord(entryCount, centralDirectoryOffset, commentByteCount);
    }

    private static final EocdRecord readZip64EocdRecord(BufferedSource $this$readZip64EocdRecord, EocdRecord regularRecord) throws IOException {
        $this$readZip64EocdRecord.skip(12L);
        int diskNumber = $this$readZip64EocdRecord.readIntLe();
        int diskWithCentralDirStart = $this$readZip64EocdRecord.readIntLe();
        long entryCount = $this$readZip64EocdRecord.readLongLe();
        long totalEntryCount = $this$readZip64EocdRecord.readLongLe();
        if (entryCount != totalEntryCount || diskNumber != 0 || diskWithCentralDirStart != 0) {
            throw (Throwable)new IOException("unsupported zip: spanned");
        }
        $this$readZip64EocdRecord.skip(8L);
        long centralDirectoryOffset = $this$readZip64EocdRecord.readLongLe();
        return new EocdRecord(entryCount, centralDirectoryOffset, regularRecord.getCommentByteCount());
    }

    private static final void readExtra(BufferedSource $this$readExtra, int extraSize, Function2<? super Integer, ? super Long, Unit> block) {
        long dataSize;
        for (long remaining = (long)extraSize; remaining != 0L; remaining -= dataSize) {
            if (remaining < (long)4) {
                throw (Throwable)new IOException("bad zip: truncated header in extra field");
            }
            int headerId = $this$readExtra.readShortLe() & 0xFFFF;
            dataSize = (long)$this$readExtra.readShortLe() & 0xFFFFL;
            if ((remaining -= (long)4) < dataSize) {
                throw (Throwable)new IOException("bad zip: truncated value in extra field");
            }
            $this$readExtra.require(dataSize);
            long sizeBefore = $this$readExtra.getBuffer().size();
            block.invoke((Object)headerId, (Object)dataSize);
            long fieldRemaining = dataSize + $this$readExtra.getBuffer().size() - sizeBefore;
            if (fieldRemaining < 0L) {
                throw (Throwable)new IOException("unsupported zip: too many bytes processed for " + headerId);
            }
            if (fieldRemaining <= 0L) continue;
            $this$readExtra.getBuffer().skip(fieldRemaining);
        }
    }

    @ExperimentalFileSystem
    public static final void skipLocalHeader(@NotNull BufferedSource $this$skipLocalHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$skipLocalHeader, (String)"$this$skipLocalHeader");
        ZipKt.readOrSkipLocalHeader($this$skipLocalHeader, null);
    }

    @ExperimentalFileSystem
    @NotNull
    public static final FileMetadata readLocalHeader(@NotNull BufferedSource $this$readLocalHeader, @NotNull FileMetadata basicMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$readLocalHeader, (String)"$this$readLocalHeader");
        Intrinsics.checkNotNullParameter((Object)basicMetadata, (String)"basicMetadata");
        FileMetadata fileMetadata = ZipKt.readOrSkipLocalHeader($this$readLocalHeader, basicMetadata);
        Intrinsics.checkNotNull((Object)fileMetadata);
        return fileMetadata;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalFileSystem
    private static final FileMetadata readOrSkipLocalHeader(BufferedSource $this$readOrSkipLocalHeader, FileMetadata basicMetadata) {
        void createdAtMillis;
        void lastAccessedAtMillis;
        void lastModifiedAtMillis;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        FileMetadata fileMetadata = basicMetadata;
        objectRef.element = fileMetadata != null ? fileMetadata.getLastModifiedAtMillis() : null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = null;
        int signature = $this$readOrSkipLocalHeader.readIntLe();
        if (signature != 67324752) {
            throw (Throwable)new IOException("bad zip: expected " + ZipKt.getHex(67324752) + " but was " + ZipKt.getHex(signature));
        }
        $this$readOrSkipLocalHeader.skip(2L);
        int bitFlag = $this$readOrSkipLocalHeader.readShortLe() & 0xFFFF;
        if ((bitFlag & 1) != 0) {
            throw (Throwable)new IOException("unsupported zip: general purpose bit flag=" + ZipKt.getHex(bitFlag));
        }
        $this$readOrSkipLocalHeader.skip(18L);
        long fileNameLength = (long)$this$readOrSkipLocalHeader.readShortLe() & 0xFFFFL;
        int extraSize = $this$readOrSkipLocalHeader.readShortLe() & 0xFFFF;
        $this$readOrSkipLocalHeader.skip(fileNameLength);
        if (basicMetadata == null) {
            $this$readOrSkipLocalHeader.skip((long)extraSize);
            return null;
        }
        ZipKt.readExtra($this$readOrSkipLocalHeader, extraSize, (Function2<? super Integer, ? super Long, Unit>)((Function2)new Function2<Integer, Long, Unit>($this$readOrSkipLocalHeader, (Ref.ObjectRef)lastModifiedAtMillis, (Ref.ObjectRef)lastAccessedAtMillis, (Ref.ObjectRef)createdAtMillis){
            final /* synthetic */ BufferedSource $this_readOrSkipLocalHeader;
            final /* synthetic */ Ref.ObjectRef $lastModifiedAtMillis;
            final /* synthetic */ Ref.ObjectRef $lastAccessedAtMillis;
            final /* synthetic */ Ref.ObjectRef $createdAtMillis;

            public final void invoke(int headerId, long dataSize) {
                switch (headerId) {
                    case 21589: {
                        long requiredSize;
                        if (dataSize < 1L) {
                            throw (Throwable)new IOException("bad zip: extended timestamp extra too short");
                        }
                        int flags = this.$this_readOrSkipLocalHeader.readByte() & 0xFF;
                        boolean hasLastModifiedAtMillis = (flags & 1) == 1;
                        boolean hasLastAccessedAtMillis = (flags & 2) == 2;
                        boolean hasCreatedAtMillis = (flags & 4) == 4;
                        BufferedSource bufferedSource = this.$this_readOrSkipLocalHeader;
                        boolean bl = false;
                        boolean bl2 = false;
                        BufferedSource $this$run = bufferedSource;
                        boolean bl3 = false;
                        long result = 1L;
                        if (hasLastModifiedAtMillis) {
                            result += 4L;
                        }
                        if (hasLastAccessedAtMillis) {
                            result += 4L;
                        }
                        if (hasCreatedAtMillis) {
                            result += 4L;
                        }
                        if (dataSize < (requiredSize = result)) {
                            throw (Throwable)new IOException("bad zip: extended timestamp extra too short");
                        }
                        if (hasLastModifiedAtMillis) {
                            this.$lastModifiedAtMillis.element = (long)this.$this_readOrSkipLocalHeader.readIntLe() * 1000L;
                        }
                        if (hasLastAccessedAtMillis) {
                            this.$lastAccessedAtMillis.element = (long)this.$this_readOrSkipLocalHeader.readIntLe() * 1000L;
                        }
                        if (!hasCreatedAtMillis) break;
                        this.$createdAtMillis.element = (long)this.$this_readOrSkipLocalHeader.readIntLe() * 1000L;
                        break;
                    }
                }
            }
            {
                this.$this_readOrSkipLocalHeader = bufferedSource;
                this.$lastModifiedAtMillis = objectRef;
                this.$lastAccessedAtMillis = objectRef2;
                this.$createdAtMillis = objectRef3;
                super(2);
            }
        }));
        return new FileMetadata(basicMetadata.isRegularFile(), basicMetadata.isDirectory(), basicMetadata.getSize(), (Long)createdAtMillis.element, (Long)lastModifiedAtMillis.element, (Long)lastAccessedAtMillis.element);
    }

    private static final Long dosDateTimeToEpochMillis(int date, int time) {
        if (time == -1) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(14, 0);
        int year = 1980 + (date >> 9 & 0x7F);
        int month = date >> 5 & 0xF;
        int day = date & 0x1F;
        int hour = time >> 11 & 0x1F;
        int minute = time >> 5 & 0x3F;
        int second = (time & 0x1F) << 1;
        cal.set(year, month - 1, day, hour, minute, second);
        Date date2 = cal.getTime();
        Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"cal.time");
        return date2.getTime();
    }

    private static final String getHex(int $this$hex) {
        StringBuilder stringBuilder = new StringBuilder().append("0x");
        int n = $this$hex;
        int n2 = 16;
        boolean bl = false;
        String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        return stringBuilder.append(string).toString();
    }
}

