/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.pagerduty.incidents;

import com.squareup.pagerduty.incidents.EventService;
import com.squareup.pagerduty.incidents.NotifyResult;
import com.squareup.pagerduty.incidents.Resolution;
import com.squareup.pagerduty.incidents.Trigger;
import com.squareup.pagerduty.incidents.Util;
import retrofit.Endpoints;
import retrofit.RestAdapter;

public abstract class PagerDuty {
    public static final String HOST = "https://events.pagerduty.com";

    public static PagerDuty create(String apiKey) {
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(Endpoints.newFixedEndpoint((String)HOST)).build();
        return PagerDuty.create(apiKey, restAdapter);
    }

    public static PagerDuty create(String apiKey, RestAdapter restAdapter) {
        Util.checkStringArgument(apiKey, "apiKey");
        Util.checkNotNull(restAdapter, "restAdapter");
        return PagerDuty.realPagerDuty(apiKey, (EventService)restAdapter.create(EventService.class));
    }

    static PagerDuty realPagerDuty(final String apiKey, final EventService service) {
        return new PagerDuty(){

            @Override
            public NotifyResult notify(Trigger trigger) {
                return service.notify(trigger.withApiKey(apiKey));
            }

            @Override
            public NotifyResult notify(Resolution resolution) {
                return service.notify(resolution.withApiKey(apiKey));
            }
        };
    }

    public abstract NotifyResult notify(Trigger var1);

    public abstract NotifyResult notify(Resolution var1);
}

