/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.pagerduty.incidents;

import com.squareup.pagerduty.incidents.NotifyResult;
import com.squareup.pagerduty.incidents.PagerDuty;
import com.squareup.pagerduty.incidents.Resolution;
import com.squareup.pagerduty.incidents.Trigger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public final class FakePagerDuty
extends PagerDuty {
    private final Map<String, String> openIncidents = new LinkedHashMap<String, String>();
    private final Map<String, String> closedIncidents = new LinkedHashMap<String, String>();
    private final Random random;

    public FakePagerDuty() {
        this(new Random());
    }

    public FakePagerDuty(Random random) {
        this.random = random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyResult notify(Trigger trigger) {
        String incidentKey = trigger.incident_key;
        if (incidentKey == null) {
            incidentKey = "incident-" + this.random.nextLong();
        }
        FakePagerDuty fakePagerDuty = this;
        synchronized (fakePagerDuty) {
            this.closedIncidents.remove(incidentKey);
            if (!this.openIncidents.containsKey(incidentKey)) {
                this.openIncidents.put(incidentKey, trigger.description);
            }
        }
        return new NotifyResult("success", "Event recorded", incidentKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyResult notify(Resolution resolution) {
        String incidentKey = resolution.incident_key;
        FakePagerDuty fakePagerDuty = this;
        synchronized (fakePagerDuty) {
            String description = this.openIncidents.remove(incidentKey);
            if (description != null) {
                this.closedIncidents.put(incidentKey, description);
            }
        }
        return new NotifyResult("success", "Event recorded", incidentKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> openIncidents() {
        FakePagerDuty fakePagerDuty = this;
        synchronized (fakePagerDuty) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.openIncidents));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> closedIncidents() {
        FakePagerDuty fakePagerDuty = this;
        synchronized (fakePagerDuty) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.closedIncidents));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIncidents() {
        FakePagerDuty fakePagerDuty = this;
        synchronized (fakePagerDuty) {
            this.openIncidents.clear();
            this.closedIncidents.clear();
        }
    }
}

