/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.pagerduty.incidents;

import com.squareup.pagerduty.incidents.EventService;
import com.squareup.pagerduty.incidents.NotifyResult;
import com.squareup.pagerduty.incidents.Resolution;
import com.squareup.pagerduty.incidents.Trigger;
import com.squareup.pagerduty.incidents.Util;
import java.io.IOException;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public abstract class PagerDuty {
    public static final String HOST = "https://events.pagerduty.com";

    public static PagerDuty create(String apiKey) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(HOST).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        return PagerDuty.create(apiKey, retrofit);
    }

    public static PagerDuty create(String apiKey, Retrofit retrofit) {
        Util.checkStringArgument(apiKey, "apiKey");
        Util.checkNotNull(retrofit, "retrofit");
        return PagerDuty.realPagerDuty(apiKey, (EventService)retrofit.create(EventService.class));
    }

    static PagerDuty realPagerDuty(final String apiKey, final EventService service) {
        return new PagerDuty(){

            @Override
            public NotifyResult notify(Trigger trigger) throws IOException {
                return (NotifyResult)service.notify(trigger.withApiKey(apiKey)).execute().body();
            }

            @Override
            public NotifyResult notify(Resolution resolution) throws IOException {
                return (NotifyResult)service.notify(resolution.withApiKey(apiKey)).execute().body();
            }
        };
    }

    public abstract NotifyResult notify(Trigger var1) throws IOException;

    public abstract NotifyResult notify(Resolution var1) throws IOException;
}

