/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.pagerduty.incidents;

import com.squareup.pagerduty.incidents.Event;
import com.squareup.pagerduty.incidents.Util;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Resolution
extends Event {
    private Resolution(String incidentKey, String description, Map<String, String> details) {
        super(null, incidentKey, "resolve", description, null, null, details);
    }

    public static final class Builder {
        private final String incidentKey;
        private String description;
        private Map<String, String> details = new LinkedHashMap<String, String>();

        public Builder(String incidentKey) {
            this.incidentKey = Util.checkStringArgument(incidentKey, "incidentKey");
        }

        public Builder withDescription(String description) {
            this.description = Util.checkStringArgument(description, "description");
            return this;
        }

        public Builder addDetails(String name, String value) {
            this.details.put(Util.checkStringArgument(name, "name"), value);
            return this;
        }

        public Builder addDetails(Map<String, String> details) {
            Util.checkNotNull(details, "details");
            this.details.putAll(details);
            return this;
        }

        public Resolution build() {
            return new Resolution(this.incidentKey, this.description, this.details);
        }
    }
}

