/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.pagerduty.incidents;

import com.squareup.pagerduty.incidents.Event;
import com.squareup.pagerduty.incidents.Util;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Trigger
extends Event {
    private static final int MAX_DESCRIPTION_LENGTH = 1024;

    private Trigger(String incidentKey, String description, String client, String clientUrl, Map<String, String> details) {
        super(null, incidentKey, "trigger", description, client, clientUrl, details);
    }

    public static final class Builder {
        private final String description;
        private String incidentKey;
        private String client;
        private String clientUrl;
        private Map<String, String> details = new LinkedHashMap<String, String>();

        public Builder(String description) {
            Util.checkStringArgument(description, "description");
            Util.checkArgument(description.length() <= 1024, "'description' length must be 1024 or less. Was: " + description.length());
            this.description = description;
        }

        public Builder withIncidentKey(String incidentKey) {
            this.incidentKey = Util.checkStringArgument(incidentKey, "incidentKey");
            return this;
        }

        public Builder client(String client) {
            this.client = Util.checkStringArgument(client, "client");
            return this;
        }

        public Builder clientUrl(String clientUrl) {
            this.clientUrl = Util.checkStringArgument(clientUrl, "clientUrl");
            return this;
        }

        public Builder addDetails(String name, String value) {
            this.details.put(Util.checkStringArgument(name, "name"), value);
            return this;
        }

        public Builder addDetails(Map<String, String> details) {
            Util.checkNotNull(details, "details");
            this.details.putAll(details);
            return this;
        }

        public Trigger build() {
            return new Trigger(this.incidentKey, this.description, this.client, this.clientUrl, this.details);
        }
    }
}

