/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import com.android.layoutlib.bridge.Bridge;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class PropertyValuesHolder_Delegate {
    private static Class[] FLOAT_VARIANTS = new Class[]{Float.TYPE, Float.class, Double.TYPE, Integer.TYPE, Double.class, Integer.class};
    private static Class[] INTEGER_VARIANTS = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Double.TYPE, Float.class, Double.class};
    private static final Object sMethodIndexLock = new Object();
    private static final Map<Long, Method> ID_TO_METHOD = new HashMap<Long, Method>();
    private static final Map<String, Long> METHOD_NAME_TO_ID = new HashMap<String, Long>();
    private static long sNextId = 1L;

    PropertyValuesHolder_Delegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long registerMethod(Class<?> targetClass, String methodName, Class[] types, int nArgs) {
        String methodIndexName = String.format("%1$s.%2$s#%3$d", targetClass.getSimpleName(), methodName, nArgs);
        Object object = sMethodIndexLock;
        synchronized (object) {
            Long methodId = METHOD_NAME_TO_ID.get(methodIndexName);
            if (methodId != null) {
                return methodId;
            }
            Class[] args = new Class[nArgs];
            Method method = null;
            for (Class typeVariant : types) {
                for (int i = 0; i < nArgs; ++i) {
                    args[i] = typeVariant;
                }
                try {
                    method = targetClass.getDeclaredMethod(methodName, args);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (method != null) {
                methodId = sNextId++;
                ID_TO_METHOD.put(methodId, method);
                METHOD_NAME_TO_ID.put(methodIndexName, methodId);
                return methodId;
            }
        }
        return 0L;
    }

    private static void callMethod(Object target, long methodID, Object ... args) {
        Method method = ID_TO_METHOD.get(methodID);
        assert (method != null);
        try {
            method.setAccessible(true);
            method.invoke(target, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Bridge.getLog().error(null, "Unable to update property during animation", (Throwable)e, null);
        }
    }

    @LayoutlibDelegate
    static long nGetIntMethod(Class<?> targetClass, String methodName) {
        return PropertyValuesHolder_Delegate.nGetMultipleIntMethod(targetClass, methodName, 1);
    }

    @LayoutlibDelegate
    static long nGetFloatMethod(Class<?> targetClass, String methodName) {
        return PropertyValuesHolder_Delegate.nGetMultipleFloatMethod(targetClass, methodName, 1);
    }

    @LayoutlibDelegate
    static long nGetMultipleIntMethod(Class<?> targetClass, String methodName, int numParams) {
        return PropertyValuesHolder_Delegate.registerMethod(targetClass, methodName, INTEGER_VARIANTS, numParams);
    }

    @LayoutlibDelegate
    static long nGetMultipleFloatMethod(Class<?> targetClass, String methodName, int numParams) {
        return PropertyValuesHolder_Delegate.registerMethod(targetClass, methodName, FLOAT_VARIANTS, numParams);
    }

    @LayoutlibDelegate
    static void nCallIntMethod(Object target, long methodID, int arg) {
        PropertyValuesHolder_Delegate.callMethod(target, methodID, arg);
    }

    @LayoutlibDelegate
    static void nCallFloatMethod(Object target, long methodID, float arg) {
        PropertyValuesHolder_Delegate.callMethod(target, methodID, Float.valueOf(arg));
    }

    @LayoutlibDelegate
    static void nCallTwoIntMethod(Object target, long methodID, int arg1, int arg2) {
        PropertyValuesHolder_Delegate.callMethod(target, methodID, arg1, arg2);
    }

    @LayoutlibDelegate
    static void nCallFourIntMethod(Object target, long methodID, int arg1, int arg2, int arg3, int arg4) {
        PropertyValuesHolder_Delegate.callMethod(target, methodID, arg1, arg2, arg3, arg4);
    }

    @LayoutlibDelegate
    static void nCallMultipleIntMethod(Object target, long methodID, int[] args) {
        assert (args != null);
        Object[] params = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            params[i] = args;
        }
        PropertyValuesHolder_Delegate.callMethod(target, methodID, params);
    }

    @LayoutlibDelegate
    static void nCallTwoFloatMethod(Object target, long methodID, float arg1, float arg2) {
        PropertyValuesHolder_Delegate.callMethod(target, methodID, Float.valueOf(arg1), Float.valueOf(arg2));
    }

    @LayoutlibDelegate
    static void nCallFourFloatMethod(Object target, long methodID, float arg1, float arg2, float arg3, float arg4) {
        PropertyValuesHolder_Delegate.callMethod(target, methodID, Float.valueOf(arg1), Float.valueOf(arg2), Float.valueOf(arg3), Float.valueOf(arg4));
    }

    @LayoutlibDelegate
    static void nCallMultipleFloatMethod(Object target, long methodID, float[] args) {
        assert (args != null);
        Object[] params = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            params[i] = args;
        }
        PropertyValuesHolder_Delegate.callMethod(target, methodID, params);
    }
}

