/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.GraphicsEnvironment;
import android.os.Trace;
import android.os._Original_Build;
import android.util.ArrayMap;
import com.android.internal.os.ClassLoaderFactory;
import dalvik.system.PathClassLoader;
import java.util.Collection;

public class ApplicationLoaders {
    private final ArrayMap<String, ClassLoader> mLoaders = new ArrayMap();
    private static final ApplicationLoaders gApplicationLoaders = new ApplicationLoaders();

    public static ApplicationLoaders getDefault() {
        return gApplicationLoaders;
    }

    ClassLoader getClassLoader(String zip, int targetSdkVersion, boolean isBundled, String librarySearchPath, String libraryPermittedPath, ClassLoader parent, String classLoaderName) {
        return this.getClassLoader(zip, targetSdkVersion, isBundled, librarySearchPath, libraryPermittedPath, parent, zip, classLoaderName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader(String zip, int targetSdkVersion, boolean isBundled, String librarySearchPath, String libraryPermittedPath, ClassLoader parent, String cacheKey, String classLoaderName) {
        ClassLoader baseParent = ClassLoader.getSystemClassLoader().getParent();
        ArrayMap<String, ClassLoader> arrayMap = this.mLoaders;
        synchronized (arrayMap) {
            if (parent == null) {
                parent = baseParent;
            }
            if (parent == baseParent) {
                ClassLoader loader = this.mLoaders.get(cacheKey);
                if (loader != null) {
                    return loader;
                }
                Trace.traceBegin(64L, zip);
                ClassLoader classloader = ClassLoaderFactory.createClassLoader(zip, librarySearchPath, libraryPermittedPath, parent, targetSdkVersion, isBundled, classLoaderName);
                Trace.traceEnd(64L);
                Trace.traceBegin(64L, "setLayerPaths");
                GraphicsEnvironment.getInstance().setLayerPaths(classloader, librarySearchPath, libraryPermittedPath);
                Trace.traceEnd(64L);
                this.mLoaders.put(cacheKey, classloader);
                return classloader;
            }
            Trace.traceBegin(64L, zip);
            ClassLoader loader = ClassLoaderFactory.createClassLoader(zip, null, parent, classLoaderName);
            Trace.traceEnd(64L);
            return loader;
        }
    }

    public ClassLoader createAndCacheWebViewClassLoader(String packagePath, String libsPath, String cacheKey) {
        return this.getClassLoader(packagePath, _Original_Build.VERSION.SDK_INT, false, libsPath, null, null, cacheKey, null);
    }

    void addPath(ClassLoader classLoader, String dexPath) {
        if (!(classLoader instanceof PathClassLoader)) {
            throw new IllegalStateException("class loader is not a PathClassLoader");
        }
        PathClassLoader baseDexClassLoader = (PathClassLoader)classLoader;
        baseDexClassLoader.addDexPath(dexPath);
    }

    void addNative(ClassLoader classLoader, Collection<String> libPaths) {
        if (!(classLoader instanceof PathClassLoader)) {
            throw new IllegalStateException("class loader is not a PathClassLoader");
        }
        PathClassLoader baseDexClassLoader = (PathClassLoader)classLoader;
        baseDexClassLoader.addNativePath(libPaths);
    }
}

