/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHearingAid;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BluetoothHearingAid
implements BluetoothProfile {
    private static final String TAG = "BluetoothHearingAid";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.hearingaid.profile.action.CONNECTION_STATE_CHANGED";
    public static final String ACTION_PLAYING_STATE_CHANGED = "android.bluetooth.hearingaid.profile.action.PLAYING_STATE_CHANGED";
    public static final String ACTION_ACTIVE_DEVICE_CHANGED = "android.bluetooth.hearingaid.profile.action.ACTIVE_DEVICE_CHANGED";
    public static final int STATE_PLAYING = 10;
    public static final int STATE_NOT_PLAYING = 11;
    public static final int SIDE_LEFT = 0;
    public static final int SIDE_RIGHT = 1;
    public static final int MODE_MONAURAL = 0;
    public static final int MODE_BINAURAL = 1;
    public static final long HI_SYNC_ID_INVALID = 0L;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private final ReentrantReadWriteLock mServiceLock = new ReentrantReadWriteLock();
    @GuardedBy(value="mServiceLock")
    private IBluetoothHearingAid mService;
    private BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothStateChange(boolean up) {
            if (!up) {
                try {
                    BluetoothHearingAid.this.mServiceLock.writeLock().lock();
                    BluetoothHearingAid.this.mService = null;
                    BluetoothHearingAid.this.mContext.unbindService(BluetoothHearingAid.this.mConnection);
                }
                catch (Exception re) {
                    Log.e(BluetoothHearingAid.TAG, "", re);
                }
                finally {
                    BluetoothHearingAid.this.mServiceLock.writeLock().unlock();
                }
            } else {
                try {
                    BluetoothHearingAid.this.mServiceLock.readLock().lock();
                    if (BluetoothHearingAid.this.mService == null) {
                        BluetoothHearingAid.this.doBind();
                    }
                }
                catch (Exception re) {
                    Log.e(BluetoothHearingAid.TAG, "", re);
                }
                finally {
                    BluetoothHearingAid.this.mServiceLock.readLock().unlock();
                }
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            try {
                BluetoothHearingAid.this.mServiceLock.writeLock().lock();
                BluetoothHearingAid.this.mService = IBluetoothHearingAid.Stub.asInterface(Binder.allowBlocking(service));
            }
            finally {
                BluetoothHearingAid.this.mServiceLock.writeLock().unlock();
            }
            if (BluetoothHearingAid.this.mServiceListener != null) {
                BluetoothHearingAid.this.mServiceListener.onServiceConnected(21, BluetoothHearingAid.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            try {
                BluetoothHearingAid.this.mServiceLock.writeLock().lock();
                BluetoothHearingAid.this.mService = null;
            }
            finally {
                BluetoothHearingAid.this.mServiceLock.writeLock().unlock();
            }
            if (BluetoothHearingAid.this.mServiceListener != null) {
                BluetoothHearingAid.this.mServiceListener.onServiceDisconnected(21);
            }
        }
    };

    BluetoothHearingAid(Context context, BluetoothProfile.ServiceListener l) {
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        this.doBind();
    }

    void doBind() {
        Intent intent = new Intent(IBluetoothHearingAid.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth Hearing Aid Service with " + intent);
            return;
        }
    }

    void close() {
        this.mServiceListener = null;
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e(TAG, "", e);
            }
        }
        try {
            this.mServiceLock.writeLock().lock();
            if (this.mService != null) {
                this.mService = null;
                this.mContext.unbindService(this.mConnection);
            }
        }
        catch (Exception re) {
            Log.e(TAG, "", re);
        }
        finally {
            this.mServiceLock.writeLock().unlock();
        }
    }

    public void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                boolean bl = this.mService.connect(device);
                return bl;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnect(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                boolean bl = this.mService.disconnect(device);
                return bl;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                List<BluetoothDevice> list = this.mService.getConnectedDevices();
                return list;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                List<BluetoothDevice> list = this.mService.getDevicesMatchingConnectionStates(states);
                return list;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectionState(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getConnectionState(device);
                return n;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setActiveDevice(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && (device == null || this.isValidDevice(device))) {
                this.mService.setActiveDevice(device);
                boolean bl = true;
                return bl;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    public List<BluetoothDevice> getActiveDevices() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                List<BluetoothDevice> list = this.mService.getActiveDevices();
                return list;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPriority(BluetoothDevice device, int priority) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                if (priority != 0 && priority != 100) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.mService.setPriority(device, priority);
                return bl;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPriority(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getPriority(device);
                return n;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
            case 10: {
                return "playing";
            }
            case 11: {
                return "not playing";
            }
        }
        return "<unknown state " + state + ">";
    }

    public int getVolume() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                int n = this.mService.getVolume();
                return n;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    public void adjustVolume(int direction) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            this.mService.adjustVolume(direction);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    public void setVolume(int volume) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            this.mService.setVolume(volume);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHiSyncId(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
                long l = 0L;
                return l;
            }
            if (!this.isEnabled() || !this.isValidDevice(device)) {
                long l = 0L;
                return l;
            }
            long l = this.mService.getHiSyncId(device);
            return l;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            long l = 0L;
            return l;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeviceSide(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getDeviceSide(device);
                return n;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeviceMode(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getDeviceMode(device);
                return n;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private boolean isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }
}

