/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.StringBlock;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;

public class ApkAssets {
    @GuardedBy(value="this")
    private final long mNativePtr;
    @GuardedBy(value="this")
    private StringBlock mStringBlock;

    public static ApkAssets loadFromPath(String path) throws IOException {
        return new ApkAssets(path, false, false, false);
    }

    public static ApkAssets loadFromPath(String path, boolean system) throws IOException {
        return new ApkAssets(path, system, false, false);
    }

    public static ApkAssets loadFromPath(String path, boolean system, boolean forceSharedLibrary) throws IOException {
        return new ApkAssets(path, system, forceSharedLibrary, false);
    }

    public static ApkAssets loadFromFd(FileDescriptor fd, String friendlyName, boolean system, boolean forceSharedLibrary) throws IOException {
        return new ApkAssets(fd, friendlyName, system, forceSharedLibrary);
    }

    public static ApkAssets loadOverlayFromPath(String idmapPath, boolean system) throws IOException {
        return new ApkAssets(idmapPath, system, false, true);
    }

    private ApkAssets(String path, boolean system, boolean forceSharedLib, boolean overlay) throws IOException {
        Preconditions.checkNotNull(path, "path");
        this.mNativePtr = ApkAssets.nativeLoad(path, system, forceSharedLib, overlay);
        this.mStringBlock = new StringBlock(ApkAssets.nativeGetStringBlock(this.mNativePtr), true);
    }

    private ApkAssets(FileDescriptor fd, String friendlyName, boolean system, boolean forceSharedLib) throws IOException {
        Preconditions.checkNotNull(fd, "fd");
        Preconditions.checkNotNull(friendlyName, "friendlyName");
        this.mNativePtr = ApkAssets.nativeLoadFromFd(fd, friendlyName, system, forceSharedLib);
        this.mStringBlock = new StringBlock(ApkAssets.nativeGetStringBlock(this.mNativePtr), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAssetPath() {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return ApkAssets.nativeGetAssetPath(this.mNativePtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence getStringFromPool(int idx) {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return this.mStringBlock.get(idx);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlResourceParser openXml(String fileName) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            long nativeXmlPtr = ApkAssets.nativeOpenXml(this.mNativePtr, fileName);
            try (XmlBlock block = new XmlBlock(null, nativeXmlPtr);){
                XmlResourceParser parser = block.newParser();
                if (parser == null) {
                    throw new AssertionError((Object)"block.newParser() returned a null parser");
                }
                XmlResourceParser xmlResourceParser = parser;
                return xmlResourceParser;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpToDate() {
        ApkAssets apkAssets = this;
        synchronized (apkAssets) {
            return ApkAssets.nativeIsUpToDate(this.mNativePtr);
        }
    }

    public String toString() {
        return "ApkAssets{path=" + this.getAssetPath() + "}";
    }

    protected void finalize() throws Throwable {
        ApkAssets.nativeDestroy(this.mNativePtr);
    }

    private static long nativeLoad(String string2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeLoad(Ljava/lang/String;ZZZ)J", true, null);
    }

    private static long nativeLoadFromFd(FileDescriptor fileDescriptor, String string2, boolean bl, boolean bl2) throws IOException {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeLoadFromFd(Ljava/io/FileDescriptor;Ljava/lang/String;ZZ)J", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.content.res.ApkAssets#nativeDestroy(J)V", true, null);
    }

    private static String nativeGetAssetPath(long l) {
        return (String)OverrideMethod.invokeA("android.content.res.ApkAssets#nativeGetAssetPath(J)Ljava/lang/String;", true, null);
    }

    private static long nativeGetStringBlock(long l) {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeGetStringBlock(J)J", true, null);
    }

    private static boolean nativeIsUpToDate(long l) {
        return OverrideMethod.invokeI("android.content.res.ApkAssets#nativeIsUpToDate(J)Z", true, null) != 0;
    }

    private static long nativeOpenXml(long l, String string2) throws IOException {
        return OverrideMethod.invokeL("android.content.res.ApkAssets#nativeOpenXml(JLjava/lang/String;)J", true, null);
    }
}

