/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.res.Resources;
import android.os.StatFs;
import android.os.SystemProperties;
import com.android.tools.layoutlib.create.OverrideMethod;

public class SQLiteGlobal {
    private static final String TAG = "SQLiteGlobal";
    private static final Object sLock = new Object();
    private static int sDefaultPageSize;

    private static int nativeReleaseMemory() {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteGlobal#nativeReleaseMemory()I", true, null);
    }

    private SQLiteGlobal() {
    }

    public static int releaseMemory() {
        return SQLiteGlobal.nativeReleaseMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDefaultPageSize() {
        Object object = sLock;
        synchronized (object) {
            if (sDefaultPageSize == 0) {
                sDefaultPageSize = new StatFs("/data").getBlockSize();
            }
            return SystemProperties.getInt("debug.sqlite.pagesize", sDefaultPageSize);
        }
    }

    public static String getDefaultJournalMode() {
        return SystemProperties.get("debug.sqlite.journalmode", Resources.getSystem().getString(17039769));
    }

    public static boolean isCompatibilityWalSupported() {
        return SystemProperties.getBoolean("debug.sqlite.compatibility_wal_supported", Resources.getSystem().getBoolean(17957093));
    }

    public static int getJournalSizeLimit() {
        return SystemProperties.getInt("debug.sqlite.journalsizelimit", Resources.getSystem().getInteger(17694937));
    }

    public static String getDefaultSyncMode() {
        return SystemProperties.get("debug.sqlite.syncmode", Resources.getSystem().getString(17039770));
    }

    public static String getWALSyncMode() {
        return SystemProperties.get("debug.sqlite.wal.syncmode", Resources.getSystem().getString(17039771));
    }

    public static int getWALAutoCheckpoint() {
        int value = SystemProperties.getInt("debug.sqlite.wal.autocheckpoint", Resources.getSystem().getInteger(17694938));
        return Math.max(1, value);
    }

    public static int getWALConnectionPoolSize() {
        int value = SystemProperties.getInt("debug.sqlite.wal.poolsize", Resources.getSystem().getInteger(17694935));
        return Math.max(2, value);
    }

    public static int getIdleConnectionTimeout() {
        return SystemProperties.getInt("debug.sqlite.idle_connection_timeout", Resources.getSystem().getInteger(17694936));
    }
}

