/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Rect;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.ninepatch.NinePatchChunk;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public final class NinePatch_Delegate {
    private static final DelegateManager<NinePatch_Delegate> sManager = new DelegateManager<NinePatch_Delegate>(NinePatch_Delegate.class);
    private static final Map<byte[], SoftReference<NinePatchChunk>> sChunkCache = new HashMap<byte[], SoftReference<NinePatchChunk>>();
    private byte[] chunk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(NinePatchChunk chunk) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(chunk);
        }
        catch (IOException e) {
            Bridge.getLog().error(null, "Failed to serialize NinePatchChunk.", (Throwable)e, null);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
        byte[] array2 = baos.toByteArray();
        sChunkCache.put(array2, new SoftReference<NinePatchChunk>(chunk));
        return array2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NinePatchChunk getChunk(byte[] array2) {
        SoftReference<NinePatchChunk> chunkRef = sChunkCache.get(array2);
        NinePatchChunk chunk = chunkRef.get();
        if (chunk == null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(array2);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(bais);
                chunk = (NinePatchChunk)ois.readObject();
                if (chunk != null) {
                    sChunkCache.put(array2, new SoftReference<NinePatchChunk>(chunk));
                }
            }
            catch (IOException e) {
                Bridge.getLog().error("broken", "Failed to deserialize NinePatchChunk content.", (Throwable)e, null);
                NinePatchChunk ninePatchChunk = null;
                return ninePatchChunk;
            }
            catch (ClassNotFoundException e) {
                Bridge.getLog().error("broken", "Failed to deserialize NinePatchChunk class.", (Throwable)e, null);
                NinePatchChunk ninePatchChunk = null;
                return ninePatchChunk;
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return chunk;
    }

    @LayoutlibDelegate
    static boolean isNinePatchChunk(byte[] chunk) {
        NinePatchChunk chunkObject = NinePatch_Delegate.getChunk(chunk);
        return chunkObject != null;
    }

    @LayoutlibDelegate
    static long validateNinePatchChunk(byte[] chunk) {
        NinePatch_Delegate newDelegate = new NinePatch_Delegate();
        newDelegate.chunk = chunk;
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static void nativeFinalize(long nativeNinePatch) {
        NinePatch_Delegate delegate = sManager.getDelegate(nativeNinePatch);
        if (delegate != null && delegate.chunk != null) {
            sChunkCache.remove(delegate.chunk);
        }
        sManager.removeJavaReferenceFor(nativeNinePatch);
    }

    @LayoutlibDelegate
    static long nativeGetTransparentRegion(Bitmap bitmap, long chunk, Rect location) {
        return 0L;
    }

    static byte[] getChunk(long nativeNinePatch) {
        NinePatch_Delegate delegate = sManager.getDelegate(nativeNinePatch);
        if (delegate != null) {
            return delegate.chunk;
        }
        return null;
    }
}

