/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.VectorDrawable_Delegate;
import com.android.internal.view.animation.NativeInterpolatorFactoryHelper_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.ArrayList;
import java.util.function.Consumer;

public class AnimatedVectorDrawable_Delegate {
    private static DelegateManager<AnimatorSetHolder> sAnimatorSets = new DelegateManager<AnimatorSetHolder>(AnimatorSetHolder.class);
    private static DelegateManager<PropertySetter> sHolders = new DelegateManager<PropertySetter>(PropertySetter.class);

    @LayoutlibDelegate
    static long nCreateAnimatorSet() {
        return sAnimatorSets.addNewDelegate(new AnimatorSetHolder());
    }

    @LayoutlibDelegate
    static void nSetVectorDrawableTarget(long animatorPtr, long vectorDrawablePtr) {
    }

    @LayoutlibDelegate
    static void nAddAnimator(long setPtr, long propertyValuesHolder, long nativeInterpolator, long startDelay, long duration, int repeatCount, int repeatMode) {
        PropertySetter holder = sHolders.getDelegate(propertyValuesHolder);
        if (holder == null || holder.getValues() == null) {
            return;
        }
        ObjectAnimator animator2 = new ObjectAnimator();
        animator2.setValues(holder.getValues());
        animator2.setInterpolator(NativeInterpolatorFactoryHelper_Delegate.getDelegate(nativeInterpolator));
        animator2.setStartDelay(startDelay);
        animator2.setDuration(duration);
        animator2.setRepeatCount(repeatCount);
        animator2.setRepeatMode(repeatMode);
        animator2.setTarget(holder);
        animator2.setPropertyName(holder.getValues().getPropertyName());
        AnimatorSetHolder set = sAnimatorSets.getDelegate(setPtr);
        assert (set != null);
        set.addAnimator(animator2);
    }

    @LayoutlibDelegate
    static long nCreateGroupPropertyHolder(long nativePtr, int propertyId, float startValue, float endValue) {
        VectorDrawable_Delegate.VGroup_Delegate group = (VectorDrawable_Delegate.VGroup_Delegate)VectorDrawable_Delegate.VNativeObject.getDelegate(nativePtr);
        Consumer<Float> setter = group.getPropertySetter(propertyId);
        return sHolders.addNewDelegate(FloatPropertySetter.of(setter, new float[]{startValue, endValue}));
    }

    @LayoutlibDelegate
    static long nCreatePathDataPropertyHolder(long nativePtr, long startValuePtr, long endValuePtr) {
        Bridge.getLog().fidelityWarning("unsupported", "AnimatedVectorDrawable path animations are not supported.", null, null);
        return 0L;
    }

    @LayoutlibDelegate
    static long nCreatePathColorPropertyHolder(long nativePtr, int propertyId, int startValue, int endValue) {
        VectorDrawable_Delegate.VFullPath_Delegate path = (VectorDrawable_Delegate.VFullPath_Delegate)VectorDrawable_Delegate.VNativeObject.getDelegate(nativePtr);
        Consumer<Integer> setter = path.getIntPropertySetter(propertyId);
        return sHolders.addNewDelegate(IntPropertySetter.of(setter, new int[]{startValue, endValue}));
    }

    @LayoutlibDelegate
    static long nCreatePathPropertyHolder(long nativePtr, int propertyId, float startValue, float endValue) {
        VectorDrawable_Delegate.VFullPath_Delegate path = (VectorDrawable_Delegate.VFullPath_Delegate)VectorDrawable_Delegate.VNativeObject.getDelegate(nativePtr);
        Consumer<Float> setter = path.getFloatPropertySetter(propertyId);
        return sHolders.addNewDelegate(FloatPropertySetter.of(setter, new float[]{startValue, endValue}));
    }

    @LayoutlibDelegate
    static long nCreateRootAlphaPropertyHolder(long nativePtr, float startValue, float endValue) {
        VectorDrawable_Delegate.VPathRenderer_Delegate renderer = (VectorDrawable_Delegate.VPathRenderer_Delegate)VectorDrawable_Delegate.VNativeObject.getDelegate(nativePtr);
        return sHolders.addNewDelegate(FloatPropertySetter.of(renderer::setRootAlpha, new float[]{startValue, endValue}));
    }

    @LayoutlibDelegate
    static void nSetPropertyHolderData(long nativePtr, float[] data, int length) {
        PropertySetter setter = sHolders.getDelegate(nativePtr);
        assert (setter != null);
        setter.setValues(data);
    }

    @LayoutlibDelegate
    static void nSetPropertyHolderData(long nativePtr, int[] data, int length) {
        PropertySetter setter = sHolders.getDelegate(nativePtr);
        assert (setter != null);
        setter.setValues(data);
    }

    @LayoutlibDelegate
    static void nStart(long animatorSetPtr, AnimatedVectorDrawable.VectorDrawableAnimatorRT set, int id2) {
        AnimatorSetHolder animatorSet = sAnimatorSets.getDelegate(animatorSetPtr);
        assert (animatorSet != null);
        animatorSet.start();
    }

    @LayoutlibDelegate
    static void nReverse(long animatorSetPtr, AnimatedVectorDrawable.VectorDrawableAnimatorRT set, int id2) {
        AnimatorSetHolder animatorSet = sAnimatorSets.getDelegate(animatorSetPtr);
        assert (animatorSet != null);
        animatorSet.reverse();
    }

    @LayoutlibDelegate
    static void nEnd(long animatorSetPtr) {
        AnimatorSetHolder animatorSet = sAnimatorSets.getDelegate(animatorSetPtr);
        assert (animatorSet != null);
        animatorSet.end();
    }

    @LayoutlibDelegate
    static void nReset(long animatorSetPtr) {
        AnimatorSetHolder animatorSet = sAnimatorSets.getDelegate(animatorSetPtr);
        assert (animatorSet != null);
        animatorSet.end();
        animatorSet.start();
    }

    private static class FloatPropertySetter
    extends PropertySetter<Float> {
        private FloatPropertySetter(Consumer<Float> valueSetter) {
            super(valueSetter);
        }

        private static PropertySetter of(Consumer<Float> valueSetter, float ... values) {
            FloatPropertySetter setter = new FloatPropertySetter(valueSetter);
            setter.setValues(values);
            return setter;
        }

        @Override
        public void setFloatValue(Float value) {
            this.mValueSetter.accept(value);
        }
    }

    private static class IntPropertySetter
    extends PropertySetter<Integer> {
        private IntPropertySetter(Consumer<Integer> valueSetter) {
            super(valueSetter);
        }

        private static PropertySetter of(Consumer<Integer> valueSetter, int ... values) {
            IntPropertySetter setter = new IntPropertySetter(valueSetter);
            setter.setValues(values);
            return setter;
        }

        @Override
        public void setIntValue(Integer value) {
            this.mValueSetter.accept(value);
        }
    }

    private static class PropertySetter<T> {
        final Consumer<T> mValueSetter;
        private PropertyValuesHolder mValues;

        private PropertySetter(Consumer<T> valueSetter) {
            this.mValueSetter = valueSetter;
        }

        public void setIntValue(Integer value) {
        }

        public void setFloatValue(Float value) {
        }

        void setValues(float ... values) {
            this.mValues = PropertyValuesHolder.ofFloat("floatValue", values);
        }

        PropertyValuesHolder getValues() {
            return this.mValues;
        }

        void setValues(int ... values) {
            this.mValues = PropertyValuesHolder.ofInt("intValue", values);
        }
    }

    private static class AnimatorSetHolder {
        private ArrayList<Animator> mAnimators = new ArrayList();
        private AnimatorSet mAnimatorSet = null;

        private AnimatorSetHolder() {
        }

        private void addAnimator(Animator animator2) {
            this.mAnimators.add(animator2);
        }

        private void ensureAnimatorSet() {
            if (this.mAnimatorSet == null) {
                this.mAnimatorSet = new AnimatorSet();
                this.mAnimatorSet.playTogether(this.mAnimators);
            }
        }

        private void start() {
            this.ensureAnimatorSet();
            this.mAnimatorSet.start();
        }

        private void end() {
            this.mAnimatorSet.end();
        }

        private void reset() {
            this.end();
            this.start();
        }

        private void reverse() {
            this.mAnimatorSet.reverse();
        }
    }
}

