/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.Sensor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SensorAdditionalInfo {
    public final Sensor sensor;
    public final int type;
    public final int serial;
    public final float[] floatValues;
    public final int[] intValues;
    public static final int TYPE_FRAME_BEGIN = 0;
    public static final int TYPE_FRAME_END = 1;
    public static final int TYPE_UNTRACKED_DELAY = 65536;
    public static final int TYPE_INTERNAL_TEMPERATURE = 65537;
    public static final int TYPE_VEC3_CALIBRATION = 65538;
    public static final int TYPE_SENSOR_PLACEMENT = 65539;
    public static final int TYPE_SAMPLING = 65540;
    public static final int TYPE_LOCAL_GEOMAGNETIC_FIELD = 196608;
    public static final int TYPE_LOCAL_GRAVITY = 196609;
    public static final int TYPE_DOCK_STATE = 196610;
    public static final int TYPE_HIGH_PERFORMANCE_MODE = 196611;
    public static final int TYPE_MAGNETIC_FIELD_CALIBRATION = 196612;
    public static final int TYPE_CUSTOM_INFO = 0x10000000;
    public static final int TYPE_DEBUG_INFO = 0x40000000;

    SensorAdditionalInfo(Sensor aSensor, int aType, int aSerial, int[] aIntValues, float[] aFloatValues) {
        this.sensor = aSensor;
        this.type = aType;
        this.serial = aSerial;
        this.intValues = aIntValues;
        this.floatValues = aFloatValues;
    }

    public static SensorAdditionalInfo createLocalGeomagneticField(float strength, float declination, float inclination) {
        if (strength < 10.0f || strength > 100.0f || declination < 0.0f || (double)declination > Math.PI || (double)inclination < -1.5707963267948966 || (double)inclination > 1.5707963267948966) {
            throw new IllegalArgumentException("Geomagnetic field info out of range");
        }
        return new SensorAdditionalInfo(null, 196608, 0, null, new float[]{strength, declination, inclination});
    }

    public static SensorAdditionalInfo createCustomInfo(Sensor aSensor, int type, float[] data) {
        if (type < 0x10000000 || type >= 0x40000000 || aSensor == null) {
            throw new IllegalArgumentException("invalid parameter(s): type: " + type + "; sensor: " + aSensor);
        }
        return new SensorAdditionalInfo(aSensor, type, 0, null, data);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdditionalInfoType {
    }
}

