/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.Camera;
import com.android.internal.util.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SizeAreaComparator
implements Comparator<Camera.Size> {
    @Override
    public int compare(Camera.Size size, Camera.Size size2) {
        Preconditions.checkNotNull(size, "size must not be null");
        Preconditions.checkNotNull(size2, "size2 must not be null");
        if (size.equals(size2)) {
            return 0;
        }
        long width = size.width;
        long area = width * (long)size.height;
        long width2 = size2.width;
        long area2 = width2 * (long)size2.height;
        if (area == area2) {
            return width > width2 ? 1 : -1;
        }
        return area > area2 ? 1 : -1;
    }

    public static Camera.Size findLargestByArea(List<Camera.Size> sizes) {
        Preconditions.checkNotNull(sizes, "sizes must not be null");
        return Collections.max(sizes, new SizeAreaComparator());
    }
}

