/*
 * Decompiled with CFR 0.152.
 */
package android.icu.number;

import android.icu.impl.StandardPlural;
import android.icu.impl.number.CompactData;
import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.MicroProps;
import android.icu.impl.number.MicroPropsGenerator;
import android.icu.impl.number.MutablePatternModifier;
import android.icu.impl.number.PatternStringParser;
import android.icu.number.Notation;
import android.icu.number.Rounder;
import android.icu.text.CompactDecimalFormat;
import android.icu.text.PluralRules;
import android.icu.util.ULocale;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CompactNotation
extends Notation {
    final CompactDecimalFormat.CompactStyle compactStyle;
    final Map<String, Map<String, String>> compactCustomData;

    CompactNotation(CompactDecimalFormat.CompactStyle compactStyle) {
        this.compactCustomData = null;
        this.compactStyle = compactStyle;
    }

    CompactNotation(Map<String, Map<String, String>> compactCustomData) {
        this.compactStyle = null;
        this.compactCustomData = compactCustomData;
    }

    MicroPropsGenerator withLocaleData(ULocale locale, String nsName, CompactData.CompactType compactType, PluralRules rules, MutablePatternModifier buildReference, MicroPropsGenerator parent) {
        return new CompactHandler(this, locale, nsName, compactType, rules, buildReference, parent);
    }

    private static class CompactHandler
    implements MicroPropsGenerator {
        final PluralRules rules;
        final MicroPropsGenerator parent;
        final Map<String, CompactModInfo> precomputedMods;
        final CompactData data;

        private CompactHandler(CompactNotation notation, ULocale locale, String nsName, CompactData.CompactType compactType, PluralRules rules, MutablePatternModifier buildReference, MicroPropsGenerator parent) {
            this.rules = rules;
            this.parent = parent;
            this.data = new CompactData();
            if (notation.compactStyle != null) {
                this.data.populate(locale, nsName, notation.compactStyle, compactType);
            } else {
                this.data.populate(notation.compactCustomData);
            }
            if (buildReference != null) {
                this.precomputedMods = new HashMap<String, CompactModInfo>();
                this.precomputeAllModifiers(buildReference);
            } else {
                this.precomputedMods = null;
            }
        }

        private void precomputeAllModifiers(MutablePatternModifier buildReference) {
            HashSet<String> allPatterns = new HashSet<String>();
            this.data.getUniquePatterns(allPatterns);
            for (String patternString : allPatterns) {
                CompactModInfo info = new CompactModInfo();
                PatternStringParser.ParsedPatternInfo patternInfo = PatternStringParser.parseToPatternInfo(patternString);
                buildReference.setPatternInfo(patternInfo);
                info.mod = buildReference.createImmutable();
                info.numDigits = patternInfo.positive.integerTotal;
                this.precomputedMods.put(patternString, info);
            }
        }

        @Override
        public MicroProps processQuantity(DecimalQuantity quantity) {
            int magnitude;
            MicroProps micros = this.parent.processQuantity(quantity);
            assert (micros.rounding != null);
            if (quantity.isZero()) {
                magnitude = 0;
                micros.rounding.apply(quantity);
            } else {
                int multiplier = micros.rounding.chooseMultiplierAndApply(quantity, this.data);
                magnitude = quantity.isZero() ? 0 : quantity.getMagnitude();
                magnitude -= multiplier;
            }
            StandardPlural plural = quantity.getStandardPlural(this.rules);
            String patternString = this.data.getPattern(magnitude, plural);
            int numDigits = -1;
            if (patternString != null) {
                if (this.precomputedMods != null) {
                    CompactModInfo info = this.precomputedMods.get(patternString);
                    info.mod.applyToMicros(micros, quantity);
                    numDigits = info.numDigits;
                } else {
                    assert (micros.modMiddle instanceof MutablePatternModifier);
                    PatternStringParser.ParsedPatternInfo patternInfo = PatternStringParser.parseToPatternInfo(patternString);
                    ((MutablePatternModifier)micros.modMiddle).setPatternInfo(patternInfo);
                    numDigits = patternInfo.positive.integerTotal;
                }
            }
            micros.rounding = Rounder.constructPassThrough();
            return micros;
        }

        private static class CompactModInfo {
            public MutablePatternModifier.ImmutablePatternModifier mod;
            public int numDigits;

            private CompactModInfo() {
            }
        }
    }
}

