/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.R;
import android.app.ActivityManager;
import android.app.Dialog;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.graphics.Region;
import android.inputmethodservice.AbstractInputMethodService;
import android.inputmethodservice.ExtractEditText;
import android.inputmethodservice.SoftInputWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.Layout;
import android.text.Spannable;
import android.text.method.MovementMethod;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class InputMethodService
extends AbstractInputMethodService {
    static final String TAG = "InputMethodService";
    static final boolean DEBUG = false;
    public static final int BACK_DISPOSITION_DEFAULT = 0;
    @Deprecated
    public static final int BACK_DISPOSITION_WILL_NOT_DISMISS = 1;
    @Deprecated
    public static final int BACK_DISPOSITION_WILL_DISMISS = 2;
    public static final int BACK_DISPOSITION_ADJUST_NOTHING = 3;
    public static final int IME_ACTIVE = 1;
    public static final int IME_VISIBLE = 2;
    private static final int BACK_DISPOSITION_MIN = 0;
    private static final int BACK_DISPOSITION_MAX = 3;
    InputMethodManager mImm;
    int mTheme = 0;
    LayoutInflater mInflater;
    TypedArray mThemeAttrs;
    View mRootView;
    SoftInputWindow mWindow;
    boolean mInitialized;
    boolean mWindowCreated;
    boolean mWindowAdded;
    boolean mWindowVisible;
    boolean mWindowWasVisible;
    boolean mInShowWindow;
    ViewGroup mFullscreenArea;
    FrameLayout mExtractFrame;
    FrameLayout mCandidatesFrame;
    FrameLayout mInputFrame;
    IBinder mToken;
    InputBinding mInputBinding;
    InputConnection mInputConnection;
    boolean mInputStarted;
    boolean mInputViewStarted;
    boolean mCandidatesViewStarted;
    InputConnection mStartedInputConnection;
    EditorInfo mInputEditorInfo;
    private IBinder mStartInputToken;
    int mShowInputFlags;
    boolean mShowInputRequested;
    boolean mLastShowInputRequested;
    int mCandidatesVisibility;
    CompletionInfo[] mCurCompletions;
    boolean mFullscreenApplied;
    boolean mIsFullscreen;
    View mExtractView;
    boolean mExtractViewHidden;
    ExtractEditText mExtractEditText;
    ViewGroup mExtractAccessories;
    View mExtractAction;
    ExtractedText mExtractedText;
    int mExtractedToken;
    View mInputView;
    boolean mIsInputViewShown;
    int mStatusIcon;
    int mBackDisposition;
    boolean mShouldClearInsetOfPreviousIme;
    final Insets mTmpInsets = new Insets();
    final int[] mTmpLocation = new int[2];
    final ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer = info -> {
        if (this.isExtractViewShown()) {
            View decor = this.getWindow().getWindow().getDecorView();
            info.contentInsets.top = info.visibleInsets.top = decor.getHeight();
            info.touchableRegion.setEmpty();
            info.setTouchableInsets(0);
        } else {
            this.onComputeInsets(this.mTmpInsets);
            info.contentInsets.top = this.mTmpInsets.contentTopInsets;
            info.visibleInsets.top = this.mTmpInsets.visibleTopInsets;
            info.touchableRegion.set(this.mTmpInsets.touchableRegion);
            info.setTouchableInsets(this.mTmpInsets.touchableInsets);
        }
    };
    final View.OnClickListener mActionClickListener = v -> {
        EditorInfo ei = this.getCurrentInputEditorInfo();
        InputConnection ic = this.getCurrentInputConnection();
        if (ei != null && ic != null) {
            if (ei.actionId != 0) {
                ic.performEditorAction(ei.actionId);
            } else if ((ei.imeOptions & 0xFF) != 1) {
                ic.performEditorAction(ei.imeOptions & 0xFF);
            }
        }
    };
    private SettingsObserver mSettingsObserver;
    static final int MOVEMENT_DOWN = -1;
    static final int MOVEMENT_UP = -2;

    @Override
    public void setTheme(int theme) {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        this.mTheme = theme;
    }

    @Deprecated
    public boolean enableHardwareAcceleration() {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        return ActivityManager.isHighEndGfx();
    }

    @Override
    public void onCreate() {
        this.mTheme = Resources.selectSystemTheme(this.mTheme, this.getApplicationInfo().targetSdkVersion, 16973908, 16973951, 16974142, 16974142);
        super.setTheme(this.mTheme);
        super.onCreate();
        this.mImm = (InputMethodManager)this.getSystemService("input_method");
        this.mSettingsObserver = SettingsObserver.createAndRegister(this);
        this.mShouldClearInsetOfPreviousIme = this.mImm.getInputMethodWindowVisibleHeight() > 0;
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        this.mWindow = new SoftInputWindow(this, "InputMethod", this.mTheme, null, null, this.mDispatcherState, 2011, 80, false);
        this.mWindow.getWindow().setFlags(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.initViews();
        this.mWindow.getWindow().setLayout(-1, -2);
    }

    public void onInitializeInterface() {
    }

    void initialize() {
        if (!this.mInitialized) {
            this.mInitialized = true;
            this.onInitializeInterface();
        }
    }

    void initViews() {
        this.mInitialized = false;
        this.mWindowCreated = false;
        this.mShowInputRequested = false;
        this.mShowInputFlags = 0;
        this.mThemeAttrs = this.obtainStyledAttributes(R.styleable.InputMethodService);
        this.mRootView = this.mInflater.inflate(17367155, null);
        this.mWindow.setContentView(this.mRootView);
        this.mRootView.getViewTreeObserver().removeOnComputeInternalInsetsListener(this.mInsetsComputer);
        this.mRootView.getViewTreeObserver().addOnComputeInternalInsetsListener(this.mInsetsComputer);
        if (Settings.Global.getInt(this.getContentResolver(), "fancy_ime_animations", 0) != 0) {
            this.mWindow.getWindow().setWindowAnimations(16974581);
        }
        this.mFullscreenArea = (ViewGroup)this.mRootView.findViewById(16908922);
        this.mExtractViewHidden = false;
        this.mExtractFrame = (FrameLayout)this.mRootView.findViewById(16908316);
        this.mExtractView = null;
        this.mExtractEditText = null;
        this.mExtractAccessories = null;
        this.mExtractAction = null;
        this.mFullscreenApplied = false;
        this.mCandidatesFrame = (FrameLayout)this.mRootView.findViewById(16908317);
        this.mInputFrame = (FrameLayout)this.mRootView.findViewById(16908318);
        this.mInputView = null;
        this.mIsInputViewShown = false;
        this.mExtractFrame.setVisibility(8);
        this.mCandidatesVisibility = this.getCandidatesHiddenVisibility();
        this.mCandidatesFrame.setVisibility(this.mCandidatesVisibility);
        this.mInputFrame.setVisibility(8);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mRootView.getViewTreeObserver().removeOnComputeInternalInsetsListener(this.mInsetsComputer);
        this.doFinishInput();
        if (this.mWindowAdded) {
            this.mWindow.getWindow().setWindowAnimations(0);
            this.mWindow.dismiss();
        }
        if (this.mSettingsObserver != null) {
            this.mSettingsObserver.unregister();
            this.mSettingsObserver = null;
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.resetStateForNewConfiguration();
    }

    private void resetStateForNewConfiguration() {
        boolean visible = this.mWindowVisible;
        int showFlags = this.mShowInputFlags;
        boolean showingInput = this.mShowInputRequested;
        CompletionInfo[] completions = this.mCurCompletions;
        this.initViews();
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        if (this.mInputStarted) {
            this.doStartInput(this.getCurrentInputConnection(), this.getCurrentInputEditorInfo(), true);
        }
        if (visible) {
            boolean showing;
            if (showingInput) {
                if (this.dispatchOnShowInputRequested(showFlags, true)) {
                    this.showWindow(true);
                    if (completions != null) {
                        this.mCurCompletions = completions;
                        this.onDisplayCompletions(completions);
                    }
                } else {
                    this.doHideWindow();
                }
            } else if (this.mCandidatesVisibility == 0) {
                this.showWindow(false);
            } else {
                this.doHideWindow();
            }
            this.mImm.setImeWindowStatus(this.mToken, this.mStartInputToken, 1 | ((showing = this.onEvaluateInputViewShown()) ? 2 : 0), this.mBackDisposition);
        }
    }

    @Override
    public AbstractInputMethodService.AbstractInputMethodImpl onCreateInputMethodInterface() {
        return new InputMethodImpl();
    }

    @Override
    public AbstractInputMethodService.AbstractInputMethodSessionImpl onCreateInputMethodSessionInterface() {
        return new InputMethodSessionImpl();
    }

    public LayoutInflater getLayoutInflater() {
        return this.mInflater;
    }

    public Dialog getWindow() {
        return this.mWindow;
    }

    public void setBackDisposition(int disposition) {
        if (disposition == this.mBackDisposition) {
            return;
        }
        if (disposition > 3 || disposition < 0) {
            Log.e(TAG, "Invalid back disposition value (" + disposition + ") specified.");
            return;
        }
        this.mBackDisposition = disposition;
        this.mImm.setImeWindowStatus(this.mToken, this.mStartInputToken, InputMethodService.mapToImeWindowStatus(this.isInputViewShown()), this.mBackDisposition);
    }

    public int getBackDisposition() {
        return this.mBackDisposition;
    }

    public int getMaxWidth() {
        WindowManager wm = (WindowManager)this.getSystemService("window");
        return wm.getDefaultDisplay().getWidth();
    }

    public InputBinding getCurrentInputBinding() {
        return this.mInputBinding;
    }

    public InputConnection getCurrentInputConnection() {
        InputConnection ic = this.mStartedInputConnection;
        if (ic != null) {
            return ic;
        }
        return this.mInputConnection;
    }

    public boolean switchToPreviousInputMethod() {
        return this.mImm.switchToPreviousInputMethodInternal(this.mToken);
    }

    public boolean switchToNextInputMethod(boolean onlyCurrentIme) {
        return this.mImm.switchToNextInputMethodInternal(this.mToken, onlyCurrentIme);
    }

    public boolean shouldOfferSwitchingToNextInputMethod() {
        return this.mImm.shouldOfferSwitchingToNextInputMethodInternal(this.mToken);
    }

    public boolean getCurrentInputStarted() {
        return this.mInputStarted;
    }

    public EditorInfo getCurrentInputEditorInfo() {
        return this.mInputEditorInfo;
    }

    public void updateFullscreenMode() {
        boolean changed;
        boolean isFullscreen = this.mShowInputRequested && this.onEvaluateFullscreenMode();
        boolean bl = changed = this.mLastShowInputRequested != this.mShowInputRequested;
        if (this.mIsFullscreen != isFullscreen || !this.mFullscreenApplied) {
            changed = true;
            this.mIsFullscreen = isFullscreen;
            if (this.mImm != null && this.mToken != null) {
                this.mImm.reportFullscreenMode(this.mToken, this.mIsFullscreen);
            }
            this.mFullscreenApplied = true;
            this.initialize();
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mFullscreenArea.getLayoutParams();
            if (isFullscreen) {
                this.mFullscreenArea.setBackgroundDrawable(this.mThemeAttrs.getDrawable(0));
                lp.height = 0;
                lp.weight = 1.0f;
            } else {
                this.mFullscreenArea.setBackgroundDrawable(null);
                lp.height = -2;
                lp.weight = 0.0f;
            }
            ((ViewGroup)this.mFullscreenArea.getParent()).updateViewLayout(this.mFullscreenArea, lp);
            if (isFullscreen) {
                View v;
                if (this.mExtractView == null && (v = this.onCreateExtractTextView()) != null) {
                    this.setExtractView(v);
                }
                this.startExtractingText(false);
            }
            this.updateExtractFrameVisibility();
        }
        if (changed) {
            this.onConfigureWindow(this.mWindow.getWindow(), isFullscreen, !this.mShowInputRequested);
            this.mLastShowInputRequested = this.mShowInputRequested;
        }
    }

    public void onConfigureWindow(Window win, boolean isFullscreen, boolean isCandidatesOnly) {
        int newHeight;
        int currentHeight = this.mWindow.getWindow().getAttributes().height;
        int n = newHeight = isFullscreen ? -1 : -2;
        if (!this.mIsInputViewShown || currentHeight != newHeight) {
            // empty if block
        }
        this.mWindow.getWindow().setLayout(-1, newHeight);
    }

    public boolean isFullscreenMode() {
        return this.mIsFullscreen;
    }

    public boolean onEvaluateFullscreenMode() {
        Configuration config = this.getResources().getConfiguration();
        if (config.orientation != 2) {
            return false;
        }
        return this.mInputEditorInfo == null || (this.mInputEditorInfo.imeOptions & 0x2000000) == 0;
    }

    public void setExtractViewShown(boolean shown) {
        if (this.mExtractViewHidden == shown) {
            this.mExtractViewHidden = !shown;
            this.updateExtractFrameVisibility();
        }
    }

    public boolean isExtractViewShown() {
        return this.mIsFullscreen && !this.mExtractViewHidden;
    }

    void updateExtractFrameVisibility() {
        int animRes;
        int vis;
        if (this.isFullscreenMode()) {
            vis = this.mExtractViewHidden ? 4 : 0;
            this.mExtractFrame.setVisibility(vis);
        } else {
            vis = 0;
            this.mExtractFrame.setVisibility(8);
        }
        this.updateCandidatesVisibility(this.mCandidatesVisibility == 0);
        if (this.mWindowWasVisible && this.mFullscreenArea.getVisibility() != vis && (animRes = this.mThemeAttrs.getResourceId(vis == 0 ? 1 : 2, 0)) != 0) {
            this.mFullscreenArea.startAnimation(AnimationUtils.loadAnimation(this, animRes));
        }
        this.mFullscreenArea.setVisibility(vis);
    }

    public void onComputeInsets(Insets outInsets) {
        View decor;
        int[] loc = this.mTmpLocation;
        if (this.mInputFrame.getVisibility() == 0) {
            this.mInputFrame.getLocationInWindow(loc);
        } else {
            decor = this.getWindow().getWindow().getDecorView();
            loc[1] = decor.getHeight();
        }
        if (this.isFullscreenMode()) {
            decor = this.getWindow().getWindow().getDecorView();
            outInsets.contentTopInsets = decor.getHeight();
        } else {
            outInsets.contentTopInsets = loc[1];
        }
        if (this.mCandidatesFrame.getVisibility() == 0) {
            this.mCandidatesFrame.getLocationInWindow(loc);
        }
        outInsets.visibleTopInsets = loc[1];
        outInsets.touchableInsets = 2;
        outInsets.touchableRegion.setEmpty();
    }

    public void updateInputViewShown() {
        boolean isShown;
        boolean bl = isShown = this.mShowInputRequested && this.onEvaluateInputViewShown();
        if (this.mIsInputViewShown != isShown && this.mWindowVisible) {
            this.mIsInputViewShown = isShown;
            this.mInputFrame.setVisibility(isShown ? 0 : 8);
            if (this.mInputView == null) {
                this.initialize();
                View v = this.onCreateInputView();
                if (v != null) {
                    this.setInputView(v);
                }
            }
        }
    }

    public boolean isShowInputRequested() {
        return this.mShowInputRequested;
    }

    public boolean isInputViewShown() {
        return this.mIsInputViewShown && this.mWindowVisible;
    }

    public boolean onEvaluateInputViewShown() {
        if (this.mSettingsObserver == null) {
            Log.w(TAG, "onEvaluateInputViewShown: mSettingsObserver must not be null here.");
            return false;
        }
        if (this.mSettingsObserver.shouldShowImeWithHardKeyboard()) {
            return true;
        }
        Configuration config = this.getResources().getConfiguration();
        return config.keyboard == 1 || config.hardKeyboardHidden == 2;
    }

    public void setCandidatesViewShown(boolean shown) {
        this.updateCandidatesVisibility(shown);
        if (!this.mShowInputRequested && this.mWindowVisible != shown) {
            if (shown) {
                this.showWindow(false);
            } else {
                this.doHideWindow();
            }
        }
    }

    void updateCandidatesVisibility(boolean shown) {
        int vis;
        int n = vis = shown ? 0 : this.getCandidatesHiddenVisibility();
        if (this.mCandidatesVisibility != vis) {
            this.mCandidatesFrame.setVisibility(vis);
            this.mCandidatesVisibility = vis;
        }
    }

    public int getCandidatesHiddenVisibility() {
        return this.isExtractViewShown() ? 8 : 4;
    }

    public void showStatusIcon(int iconResId) {
        this.mStatusIcon = iconResId;
        this.mImm.showStatusIconInternal(this.mToken, this.getPackageName(), iconResId);
    }

    public void hideStatusIcon() {
        this.mStatusIcon = 0;
        this.mImm.hideStatusIconInternal(this.mToken);
    }

    public void switchInputMethod(String id2) {
        this.mImm.setInputMethodInternal(this.mToken, id2);
    }

    public void switchInputMethod(String id2, InputMethodSubtype subtype) {
        this.mImm.setInputMethodAndSubtypeInternal(this.mToken, id2, subtype);
    }

    public void setExtractView(View view) {
        this.mExtractFrame.removeAllViews();
        this.mExtractFrame.addView(view, new FrameLayout.LayoutParams(-1, -1));
        this.mExtractView = view;
        if (view != null) {
            this.mExtractEditText = (ExtractEditText)view.findViewById(16908325);
            this.mExtractEditText.setIME(this);
            this.mExtractAction = view.findViewById(16908980);
            if (this.mExtractAction != null) {
                this.mExtractAccessories = (ViewGroup)view.findViewById(16908979);
            }
            this.startExtractingText(false);
        } else {
            this.mExtractEditText = null;
            this.mExtractAccessories = null;
            this.mExtractAction = null;
        }
    }

    public void setCandidatesView(View view) {
        this.mCandidatesFrame.removeAllViews();
        this.mCandidatesFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
    }

    public void setInputView(View view) {
        this.mInputFrame.removeAllViews();
        this.mInputFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
        this.mInputView = view;
    }

    public View onCreateExtractTextView() {
        return this.mInflater.inflate(17367156, null);
    }

    public View onCreateCandidatesView() {
        return null;
    }

    public View onCreateInputView() {
        return null;
    }

    public void onStartInputView(EditorInfo info, boolean restarting) {
    }

    public void onFinishInputView(boolean finishingInput) {
        InputConnection ic;
        if (!finishingInput && (ic = this.getCurrentInputConnection()) != null) {
            ic.finishComposingText();
        }
    }

    public void onStartCandidatesView(EditorInfo info, boolean restarting) {
    }

    public void onFinishCandidatesView(boolean finishingInput) {
        InputConnection ic;
        if (!finishingInput && (ic = this.getCurrentInputConnection()) != null) {
            ic.finishComposingText();
        }
    }

    public boolean onShowInputRequested(int flags, boolean configChange) {
        if (!this.onEvaluateInputViewShown()) {
            return false;
        }
        if ((flags & 1) == 0) {
            if (!configChange && this.onEvaluateFullscreenMode()) {
                return false;
            }
            if (!this.mSettingsObserver.shouldShowImeWithHardKeyboard() && this.getResources().getConfiguration().keyboard != 1) {
                return false;
            }
        }
        return true;
    }

    private boolean dispatchOnShowInputRequested(int flags, boolean configChange) {
        boolean result = this.onShowInputRequested(flags, configChange);
        this.mShowInputFlags = result ? flags : 0;
        return result;
    }

    public void showWindow(boolean showInput) {
        if (this.mInShowWindow) {
            Log.w(TAG, "Re-entrance in to showWindow");
            return;
        }
        try {
            this.mWindowWasVisible = this.mWindowVisible;
            this.mInShowWindow = true;
            this.showWindowInner(showInput);
        }
        catch (WindowManager.BadTokenException e) {
            this.mWindowVisible = false;
            this.mWindowAdded = false;
            throw e;
        }
        finally {
            this.mWindowWasVisible = true;
            this.mInShowWindow = false;
        }
    }

    void showWindowInner(boolean showInput) {
        int nextImeWindowStatus;
        boolean doShowInput = false;
        int previousImeWindowStatus = (this.mWindowVisible ? 1 : 0) | (this.isInputViewShown() ? 2 : 0);
        this.mWindowVisible = true;
        if (!this.mShowInputRequested && this.mInputStarted && showInput) {
            doShowInput = true;
            this.mShowInputRequested = true;
        }
        this.initialize();
        this.updateFullscreenMode();
        this.updateInputViewShown();
        if (!this.mWindowAdded || !this.mWindowCreated) {
            this.mWindowAdded = true;
            this.mWindowCreated = true;
            this.initialize();
            View v = this.onCreateCandidatesView();
            if (v != null) {
                this.setCandidatesView(v);
            }
        }
        if (this.mShowInputRequested) {
            if (!this.mInputViewStarted) {
                this.mInputViewStarted = true;
                this.onStartInputView(this.mInputEditorInfo, false);
            }
        } else if (!this.mCandidatesViewStarted) {
            this.mCandidatesViewStarted = true;
            this.onStartCandidatesView(this.mInputEditorInfo, false);
        }
        if (doShowInput) {
            this.startExtractingText(false);
        }
        if (previousImeWindowStatus != (nextImeWindowStatus = InputMethodService.mapToImeWindowStatus(this.isInputViewShown()))) {
            this.mImm.setImeWindowStatus(this.mToken, this.mStartInputToken, nextImeWindowStatus, this.mBackDisposition);
        }
        if ((previousImeWindowStatus & 1) == 0) {
            this.onWindowShown();
            this.mWindow.show();
            this.mShouldClearInsetOfPreviousIme = false;
        }
    }

    private void finishViews() {
        if (this.mInputViewStarted) {
            this.onFinishInputView(false);
        } else if (this.mCandidatesViewStarted) {
            this.onFinishCandidatesView(false);
        }
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
    }

    private void doHideWindow() {
        this.mImm.setImeWindowStatus(this.mToken, this.mStartInputToken, 0, this.mBackDisposition);
        this.hideWindow();
    }

    public void hideWindow() {
        this.finishViews();
        if (this.mWindowVisible) {
            this.mWindow.hide();
            this.mWindowVisible = false;
            this.onWindowHidden();
            this.mWindowWasVisible = false;
        }
        this.updateFullscreenMode();
    }

    public void onWindowShown() {
    }

    public void onWindowHidden() {
    }

    private void clearInsetOfPreviousIme() {
        if (!this.mShouldClearInsetOfPreviousIme) {
            return;
        }
        this.mImm.clearLastInputMethodWindowForTransition(this.mToken);
        this.mShouldClearInsetOfPreviousIme = false;
    }

    public void onBindInput() {
    }

    public void onUnbindInput() {
    }

    public void onStartInput(EditorInfo attribute, boolean restarting) {
    }

    void doFinishInput() {
        if (this.mInputViewStarted) {
            this.onFinishInputView(true);
        } else if (this.mCandidatesViewStarted) {
            this.onFinishCandidatesView(true);
        }
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        if (this.mInputStarted) {
            this.onFinishInput();
        }
        this.mInputStarted = false;
        this.mStartedInputConnection = null;
        this.mCurCompletions = null;
    }

    void doStartInput(InputConnection ic, EditorInfo attribute, boolean restarting) {
        if (!restarting) {
            this.doFinishInput();
        }
        this.mInputStarted = true;
        this.mStartedInputConnection = ic;
        this.mInputEditorInfo = attribute;
        this.initialize();
        this.onStartInput(attribute, restarting);
        if (this.mWindowVisible) {
            if (this.mShowInputRequested) {
                this.mInputViewStarted = true;
                this.onStartInputView(this.mInputEditorInfo, restarting);
                this.startExtractingText(true);
            } else if (this.mCandidatesVisibility == 0) {
                this.mCandidatesViewStarted = true;
                this.onStartCandidatesView(this.mInputEditorInfo, restarting);
            }
        }
    }

    public void onFinishInput() {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic != null) {
            ic.finishComposingText();
        }
    }

    public void onDisplayCompletions(CompletionInfo[] completions) {
    }

    public void onUpdateExtractedText(int token, ExtractedText text) {
        if (this.mExtractedToken != token) {
            return;
        }
        if (text != null && this.mExtractEditText != null) {
            this.mExtractedText = text;
            this.mExtractEditText.setExtractedText(text);
        }
    }

    public void onUpdateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
        ExtractEditText eet = this.mExtractEditText;
        if (eet != null && this.isFullscreenMode() && this.mExtractedText != null) {
            int off = this.mExtractedText.startOffset;
            eet.startInternalChanges();
            newSelEnd -= off;
            int len = eet.getText().length();
            if ((newSelStart -= off) < 0) {
                newSelStart = 0;
            } else if (newSelStart > len) {
                newSelStart = len;
            }
            if (newSelEnd < 0) {
                newSelEnd = 0;
            } else if (newSelEnd > len) {
                newSelEnd = len;
            }
            eet.setSelection(newSelStart, newSelEnd);
            eet.finishInternalChanges();
        }
    }

    public void onViewClicked(boolean focusChanged) {
    }

    @Deprecated
    public void onUpdateCursor(Rect newCursor) {
    }

    public void onUpdateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
    }

    public void requestHideSelf(int flags) {
        this.mImm.hideSoftInputFromInputMethodInternal(this.mToken, flags);
    }

    public void requestShowSelf(int flags) {
        this.mImm.showSoftInputFromInputMethodInternal(this.mToken, flags);
    }

    private boolean handleBack(boolean doIt) {
        if (this.mShowInputRequested) {
            if (doIt) {
                this.requestHideSelf(0);
            }
            return true;
        }
        if (this.mWindowVisible) {
            if (this.mCandidatesVisibility == 0) {
                if (doIt) {
                    this.setCandidatesViewShown(false);
                }
            } else if (doIt) {
                this.doHideWindow();
            }
            return true;
        }
        return false;
    }

    private ExtractEditText getExtractEditTextIfVisible() {
        if (!this.isExtractViewShown() || !this.isInputViewShown()) {
            return null;
        }
        return this.mExtractEditText;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (event.getKeyCode() == 4) {
            ExtractEditText eet = this.getExtractEditTextIfVisible();
            if (eet != null && eet.handleBackInTextActionModeIfNeeded(event)) {
                return true;
            }
            if (this.handleBack(false)) {
                event.startTracking();
                return true;
            }
            return false;
        }
        return this.doMovementKey(keyCode, event, -1);
    }

    @Override
    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int count, KeyEvent event) {
        return this.doMovementKey(keyCode, event, count);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (event.getKeyCode() == 4) {
            ExtractEditText eet = this.getExtractEditTextIfVisible();
            if (eet != null && eet.handleBackInTextActionModeIfNeeded(event)) {
                return true;
            }
            if (event.isTracking() && !event.isCanceled()) {
                return this.handleBack(true);
            }
        }
        return this.doMovementKey(keyCode, event, -2);
    }

    @Override
    public boolean onTrackballEvent(MotionEvent event) {
        return false;
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        return false;
    }

    public void onAppPrivateCommand(String action, Bundle data) {
    }

    private void onToggleSoftInput(int showFlags, int hideFlags) {
        if (this.isInputViewShown()) {
            this.requestHideSelf(hideFlags);
        } else {
            this.requestShowSelf(showFlags);
        }
    }

    void reportExtractedMovement(int keyCode, int count) {
        int dx = 0;
        int dy = 0;
        switch (keyCode) {
            case 21: {
                dx = -count;
                break;
            }
            case 22: {
                dx = count;
                break;
            }
            case 19: {
                dy = -count;
                break;
            }
            case 20: {
                dy = count;
            }
        }
        this.onExtractedCursorMovement(dx, dy);
    }

    boolean doMovementKey(int keyCode, KeyEvent event, int count) {
        ExtractEditText eet = this.getExtractEditTextIfVisible();
        if (eet != null) {
            MovementMethod movement = eet.getMovementMethod();
            Layout layout2 = eet.getLayout();
            if (movement != null && layout2 != null) {
                if (count == -1) {
                    if (movement.onKeyDown(eet, eet.getText(), keyCode, event)) {
                        this.reportExtractedMovement(keyCode, 1);
                        return true;
                    }
                } else if (count == -2) {
                    if (movement.onKeyUp(eet, eet.getText(), keyCode, event)) {
                        return true;
                    }
                } else if (movement.onKeyOther(eet, eet.getText(), event)) {
                    this.reportExtractedMovement(keyCode, count);
                } else {
                    KeyEvent down = KeyEvent.changeAction(event, 0);
                    if (movement.onKeyDown(eet, eet.getText(), keyCode, down)) {
                        KeyEvent up = KeyEvent.changeAction(event, 1);
                        movement.onKeyUp(eet, eet.getText(), keyCode, up);
                        while (--count > 0) {
                            movement.onKeyDown(eet, eet.getText(), keyCode, down);
                            movement.onKeyUp(eet, eet.getText(), keyCode, up);
                        }
                        this.reportExtractedMovement(keyCode, count);
                    }
                }
            }
            switch (keyCode) {
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    return true;
                }
            }
        }
        return false;
    }

    public void sendDownUpKeyEvents(int keyEventCode) {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic == null) {
            return;
        }
        long eventTime = SystemClock.uptimeMillis();
        ic.sendKeyEvent(new KeyEvent(eventTime, eventTime, 0, keyEventCode, 0, 0, -1, 0, 6));
        ic.sendKeyEvent(new KeyEvent(eventTime, SystemClock.uptimeMillis(), 1, keyEventCode, 0, 0, -1, 0, 6));
    }

    public boolean sendDefaultEditorAction(boolean fromEnterKey) {
        EditorInfo ei = this.getCurrentInputEditorInfo();
        if (!(ei == null || fromEnterKey && (ei.imeOptions & 0x40000000) != 0 || (ei.imeOptions & 0xFF) == 1)) {
            InputConnection ic = this.getCurrentInputConnection();
            if (ic != null) {
                ic.performEditorAction(ei.imeOptions & 0xFF);
            }
            return true;
        }
        return false;
    }

    public void sendKeyChar(char charCode) {
        switch (charCode) {
            case '\n': {
                if (this.sendDefaultEditorAction(true)) break;
                this.sendDownUpKeyEvents(66);
                break;
            }
            default: {
                if (charCode >= '0' && charCode <= '9') {
                    this.sendDownUpKeyEvents(charCode - 48 + 7);
                    break;
                }
                InputConnection ic = this.getCurrentInputConnection();
                if (ic == null) break;
                ic.commitText(String.valueOf(charCode), 1);
            }
        }
    }

    public void onExtractedSelectionChanged(int start, int end) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            conn.setSelection(start, end);
        }
    }

    public void onExtractedDeleteText(int start, int end) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            conn.finishComposingText();
            conn.setSelection(start, start);
            conn.deleteSurroundingText(0, end - start);
        }
    }

    public void onExtractedReplaceText(int start, int end, CharSequence text) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            conn.setComposingRegion(start, end);
            conn.commitText(text, 1);
        }
    }

    public void onExtractedSetSpan(Object span, int start, int end, int flags) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            if (!conn.setSelection(start, end)) {
                return;
            }
            CharSequence text = conn.getSelectedText(1);
            if (text instanceof Spannable) {
                ((Spannable)text).setSpan(span, 0, text.length(), flags);
                conn.setComposingRegion(start, end);
                conn.commitText(text, 1);
            }
        }
    }

    public void onExtractedTextClicked() {
        if (this.mExtractEditText == null) {
            return;
        }
        if (this.mExtractEditText.hasVerticalScrollBar()) {
            this.setCandidatesViewShown(false);
        }
    }

    public void onExtractedCursorMovement(int dx, int dy) {
        if (this.mExtractEditText == null || dy == 0) {
            return;
        }
        if (this.mExtractEditText.hasVerticalScrollBar()) {
            this.setCandidatesViewShown(false);
        }
    }

    public boolean onExtractTextContextMenuItem(int id2) {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic != null) {
            ic.performContextMenuAction(id2);
        }
        return true;
    }

    public CharSequence getTextForImeAction(int imeOptions) {
        switch (imeOptions & 0xFF) {
            case 1: {
                return null;
            }
            case 2: {
                return this.getText(17040016);
            }
            case 3: {
                return this.getText(17040019);
            }
            case 4: {
                return this.getText(17040020);
            }
            case 5: {
                return this.getText(17040017);
            }
            case 6: {
                return this.getText(17040015);
            }
            case 7: {
                return this.getText(17040018);
            }
        }
        return this.getText(17040014);
    }

    private int getIconForImeAction(int imeOptions) {
        switch (imeOptions & 0xFF) {
            case 2: {
                return 17302389;
            }
            case 3: {
                return 17302393;
            }
            case 4: {
                return 17302394;
            }
            case 5: {
                return 17302390;
            }
            case 6: {
                return 17302388;
            }
            case 7: {
                return 17302391;
            }
        }
        return 17302392;
    }

    public void onUpdateExtractingVisibility(EditorInfo ei) {
        if (ei.inputType == 0 || (ei.imeOptions & 0x10000000) != 0) {
            this.setExtractViewShown(false);
            return;
        }
        this.setExtractViewShown(true);
    }

    public void onUpdateExtractingViews(EditorInfo ei) {
        boolean hasAction;
        if (!this.isExtractViewShown()) {
            return;
        }
        if (this.mExtractAccessories == null) {
            return;
        }
        boolean bl = hasAction = ei.actionLabel != null || (ei.imeOptions & 0xFF) != 1 && (ei.imeOptions & 0x20000000) == 0 && ei.inputType != 0;
        if (hasAction) {
            this.mExtractAccessories.setVisibility(0);
            if (this.mExtractAction != null) {
                if (this.mExtractAction instanceof ImageButton) {
                    ((ImageButton)this.mExtractAction).setImageResource(this.getIconForImeAction(ei.imeOptions));
                    if (ei.actionLabel != null) {
                        this.mExtractAction.setContentDescription(ei.actionLabel);
                    } else {
                        this.mExtractAction.setContentDescription(this.getTextForImeAction(ei.imeOptions));
                    }
                } else if (ei.actionLabel != null) {
                    ((TextView)this.mExtractAction).setText(ei.actionLabel);
                } else {
                    ((TextView)this.mExtractAction).setText(this.getTextForImeAction(ei.imeOptions));
                }
                this.mExtractAction.setOnClickListener(this.mActionClickListener);
            }
        } else {
            this.mExtractAccessories.setVisibility(8);
            if (this.mExtractAction != null) {
                this.mExtractAction.setOnClickListener(null);
            }
        }
    }

    public void onExtractingInputChanged(EditorInfo ei) {
        if (ei.inputType == 0) {
            this.requestHideSelf(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startExtractingText(boolean inputChanged) {
        ExtractEditText eet = this.mExtractEditText;
        if (eet != null && this.getCurrentInputStarted() && this.isFullscreenMode()) {
            ++this.mExtractedToken;
            ExtractedTextRequest req = new ExtractedTextRequest();
            req.token = this.mExtractedToken;
            req.flags = 1;
            req.hintMaxLines = 10;
            req.hintMaxChars = 10000;
            InputConnection ic = this.getCurrentInputConnection();
            ExtractedText extractedText = this.mExtractedText = ic == null ? null : ic.getExtractedText(req, 1);
            if (this.mExtractedText == null || ic == null) {
                Log.e(TAG, "Unexpected null in startExtractingText : mExtractedText = " + this.mExtractedText + ", input connection = " + ic);
            }
            EditorInfo ei = this.getCurrentInputEditorInfo();
            try {
                eet.startInternalChanges();
                this.onUpdateExtractingVisibility(ei);
                this.onUpdateExtractingViews(ei);
                int inputType = ei.inputType;
                if ((inputType & 0xF) == 1 && (inputType & 0x40000) != 0) {
                    inputType |= 0x20000;
                }
                eet.setInputType(inputType);
                eet.setHint(ei.hintText);
                if (this.mExtractedText != null) {
                    eet.setEnabled(true);
                    eet.setExtractedText(this.mExtractedText);
                } else {
                    eet.setEnabled(false);
                    eet.setText("");
                }
            }
            finally {
                eet.finishInternalChanges();
            }
            if (inputChanged) {
                this.onExtractingInputChanged(ei);
            }
        }
    }

    protected void onCurrentInputMethodSubtypeChanged(InputMethodSubtype newSubtype) {
    }

    public int getInputMethodWindowRecommendedHeight() {
        return this.mImm.getInputMethodWindowVisibleHeight();
    }

    @Override
    public void exposeContent(InputContentInfo inputContentInfo, InputConnection inputConnection) {
        if (inputConnection == null) {
            return;
        }
        if (this.getCurrentInputConnection() != inputConnection) {
            return;
        }
        this.mImm.exposeContent(this.mToken, inputContentInfo, this.getCurrentInputEditorInfo());
    }

    private static int mapToImeWindowStatus(boolean isInputViewShown) {
        return 1 | (isInputViewShown ? 2 : 0);
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        PrintWriterPrinter p = new PrintWriterPrinter(fout);
        p.println("Input method service state for " + this + ":");
        p.println("  mWindowCreated=" + this.mWindowCreated + " mWindowAdded=" + this.mWindowAdded);
        p.println("  mWindowVisible=" + this.mWindowVisible + " mWindowWasVisible=" + this.mWindowWasVisible + " mInShowWindow=" + this.mInShowWindow);
        p.println("  Configuration=" + this.getResources().getConfiguration());
        p.println("  mToken=" + this.mToken);
        p.println("  mInputBinding=" + this.mInputBinding);
        p.println("  mInputConnection=" + this.mInputConnection);
        p.println("  mStartedInputConnection=" + this.mStartedInputConnection);
        p.println("  mInputStarted=" + this.mInputStarted + " mInputViewStarted=" + this.mInputViewStarted + " mCandidatesViewStarted=" + this.mCandidatesViewStarted);
        p.println("  mStartInputToken=" + this.mStartInputToken);
        if (this.mInputEditorInfo != null) {
            p.println("  mInputEditorInfo:");
            this.mInputEditorInfo.dump(p, "    ");
        } else {
            p.println("  mInputEditorInfo: null");
        }
        p.println("  mShowInputRequested=" + this.mShowInputRequested + " mLastShowInputRequested=" + this.mLastShowInputRequested + " mShowInputFlags=0x" + Integer.toHexString(this.mShowInputFlags));
        p.println("  mCandidatesVisibility=" + this.mCandidatesVisibility + " mFullscreenApplied=" + this.mFullscreenApplied + " mIsFullscreen=" + this.mIsFullscreen + " mExtractViewHidden=" + this.mExtractViewHidden);
        if (this.mExtractedText != null) {
            p.println("  mExtractedText:");
            p.println("    text=" + this.mExtractedText.text.length() + " chars startOffset=" + this.mExtractedText.startOffset);
            p.println("    selectionStart=" + this.mExtractedText.selectionStart + " selectionEnd=" + this.mExtractedText.selectionEnd + " flags=0x" + Integer.toHexString(this.mExtractedText.flags));
        } else {
            p.println("  mExtractedText: null");
        }
        p.println("  mExtractedToken=" + this.mExtractedToken);
        p.println("  mIsInputViewShown=" + this.mIsInputViewShown + " mStatusIcon=" + this.mStatusIcon);
        p.println("Last computed insets:");
        p.println("  contentTopInsets=" + this.mTmpInsets.contentTopInsets + " visibleTopInsets=" + this.mTmpInsets.visibleTopInsets + " touchableInsets=" + this.mTmpInsets.touchableInsets + " touchableRegion=" + this.mTmpInsets.touchableRegion);
        p.println(" mShouldClearInsetOfPreviousIme=" + this.mShouldClearInsetOfPreviousIme);
        p.println(" mSettingsObserver=" + this.mSettingsObserver);
    }

    private static class SettingsObserver
    extends ContentObserver {
        private int mShowImeWithHardKeyboard = 0;
        private final InputMethodService mService;

        private SettingsObserver(InputMethodService service) {
            super(new Handler(service.getMainLooper()));
            this.mService = service;
        }

        public static SettingsObserver createAndRegister(InputMethodService service) {
            SettingsObserver observer = new SettingsObserver(service);
            service.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("show_ime_with_hard_keyboard"), false, observer);
            return observer;
        }

        void unregister() {
            this.mService.getContentResolver().unregisterContentObserver(this);
        }

        private boolean shouldShowImeWithHardKeyboard() {
            if (this.mShowImeWithHardKeyboard == 0) {
                this.mShowImeWithHardKeyboard = Settings.Secure.getInt(this.mService.getContentResolver(), "show_ime_with_hard_keyboard", 0) != 0 ? 2 : 1;
            }
            switch (this.mShowImeWithHardKeyboard) {
                case 2: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            Log.e(InputMethodService.TAG, "Unexpected mShowImeWithHardKeyboard=" + this.mShowImeWithHardKeyboard);
            return false;
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Uri showImeWithHardKeyboardUri = Settings.Secure.getUriFor("show_ime_with_hard_keyboard");
            if (showImeWithHardKeyboardUri.equals(uri)) {
                this.mShowImeWithHardKeyboard = Settings.Secure.getInt(this.mService.getContentResolver(), "show_ime_with_hard_keyboard", 0) != 0 ? 2 : 1;
                this.mService.resetStateForNewConfiguration();
            }
        }

        public String toString() {
            return "SettingsObserver{mShowImeWithHardKeyboard=" + this.mShowImeWithHardKeyboard + "}";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface ShowImeWithHardKeyboardType {
            public static final int UNKNOWN = 0;
            public static final int FALSE = 1;
            public static final int TRUE = 2;
        }
    }

    public static class Insets {
        public int contentTopInsets;
        public int visibleTopInsets;
        public final Region touchableRegion = new Region();
        public static final int TOUCHABLE_INSETS_FRAME = 0;
        public static final int TOUCHABLE_INSETS_CONTENT = 1;
        public static final int TOUCHABLE_INSETS_VISIBLE = 2;
        public static final int TOUCHABLE_INSETS_REGION = 3;
        public int touchableInsets;
    }

    public class InputMethodSessionImpl
    extends AbstractInputMethodService.AbstractInputMethodSessionImpl {
        @Override
        public void finishInput() {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.doFinishInput();
        }

        @Override
        public void displayCompletions(CompletionInfo[] completions) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.mCurCompletions = completions;
            InputMethodService.this.onDisplayCompletions(completions);
        }

        @Override
        public void updateExtractedText(int token, ExtractedText text) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateExtractedText(token, text);
        }

        @Override
        public void updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateSelection(oldSelStart, oldSelEnd, newSelStart, newSelEnd, candidatesStart, candidatesEnd);
        }

        @Override
        public void viewClicked(boolean focusChanged) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onViewClicked(focusChanged);
        }

        @Override
        public void updateCursor(Rect newCursor) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateCursor(newCursor);
        }

        @Override
        public void appPrivateCommand(String action, Bundle data) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onAppPrivateCommand(action, data);
        }

        @Override
        public void toggleSoftInput(int showFlags, int hideFlags) {
            InputMethodService.this.onToggleSoftInput(showFlags, hideFlags);
        }

        @Override
        public void updateCursorAnchorInfo(CursorAnchorInfo info) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateCursorAnchorInfo(info);
        }
    }

    public class InputMethodImpl
    extends AbstractInputMethodService.AbstractInputMethodImpl {
        @Override
        public void attachToken(IBinder token) {
            if (InputMethodService.this.mToken == null) {
                InputMethodService.this.mToken = token;
                InputMethodService.this.mWindow.setToken(token);
            }
        }

        @Override
        public void bindInput(InputBinding binding) {
            InputMethodService.this.mInputBinding = binding;
            InputMethodService.this.mInputConnection = binding.getConnection();
            if (InputMethodService.this.mImm != null && InputMethodService.this.mToken != null) {
                InputMethodService.this.mImm.reportFullscreenMode(InputMethodService.this.mToken, InputMethodService.this.mIsFullscreen);
            }
            InputMethodService.this.initialize();
            InputMethodService.this.onBindInput();
        }

        @Override
        public void unbindInput() {
            InputMethodService.this.onUnbindInput();
            InputMethodService.this.mInputBinding = null;
            InputMethodService.this.mInputConnection = null;
        }

        @Override
        public void startInput(InputConnection ic, EditorInfo attribute) {
            InputMethodService.this.doStartInput(ic, attribute, false);
        }

        @Override
        public void restartInput(InputConnection ic, EditorInfo attribute) {
            InputMethodService.this.doStartInput(ic, attribute, true);
        }

        @Override
        public void dispatchStartInputWithToken(InputConnection inputConnection, EditorInfo editorInfo, boolean restarting, IBinder startInputToken) {
            InputMethodService.this.mStartInputToken = startInputToken;
            super.dispatchStartInputWithToken(inputConnection, editorInfo, restarting, startInputToken);
        }

        @Override
        public void hideSoftInput(int flags, ResultReceiver resultReceiver) {
            boolean wasVis = InputMethodService.this.isInputViewShown();
            InputMethodService.this.mShowInputFlags = 0;
            InputMethodService.this.mShowInputRequested = false;
            InputMethodService.this.doHideWindow();
            InputMethodService.this.clearInsetOfPreviousIme();
            if (resultReceiver != null) {
                resultReceiver.send(wasVis != InputMethodService.this.isInputViewShown() ? 3 : (wasVis ? 0 : 1), null);
            }
        }

        @Override
        public void showSoftInput(int flags, ResultReceiver resultReceiver) {
            boolean wasVis = InputMethodService.this.isInputViewShown();
            if (InputMethodService.this.dispatchOnShowInputRequested(flags, false)) {
                try {
                    InputMethodService.this.showWindow(true);
                }
                catch (WindowManager.BadTokenException badTokenException) {
                    // empty catch block
                }
            }
            InputMethodService.this.clearInsetOfPreviousIme();
            InputMethodService.this.mImm.setImeWindowStatus(InputMethodService.this.mToken, InputMethodService.this.mStartInputToken, InputMethodService.mapToImeWindowStatus(InputMethodService.this.isInputViewShown()), InputMethodService.this.mBackDisposition);
            if (resultReceiver != null) {
                resultReceiver.send(wasVis != InputMethodService.this.isInputViewShown() ? 2 : (wasVis ? 0 : 1), null);
            }
        }

        @Override
        public void changeInputMethodSubtype(InputMethodSubtype subtype) {
            InputMethodService.this.onCurrentInputMethodSubtypeChanged(subtype);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BackDispositionMode {
    }
}

