/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioDevicePortConfig;
import android.media.AudioGain;
import android.media.AudioGainConfig;
import android.media.AudioHandle;
import android.media.AudioManager;
import android.media.AudioPort;
import android.media.AudioSystem;

public class AudioDevicePort
extends AudioPort {
    private final int mType;
    private final String mAddress;

    AudioDevicePort(AudioHandle handle, String deviceName, int[] samplingRates, int[] channelMasks, int[] channelIndexMasks, int[] formats, AudioGain[] gains, int type, String address) {
        super(handle, AudioManager.isInputDevice(type) ? 1 : 2, deviceName, samplingRates, channelMasks, channelIndexMasks, formats, gains);
        this.mType = type;
        this.mAddress = address;
    }

    public int type() {
        return this.mType;
    }

    public String address() {
        return this.mAddress;
    }

    @Override
    public AudioDevicePortConfig buildConfig(int samplingRate, int channelMask, int format, AudioGainConfig gain) {
        return new AudioDevicePortConfig(this, samplingRate, channelMask, format, gain);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof AudioDevicePort)) {
            return false;
        }
        AudioDevicePort other = (AudioDevicePort)o;
        if (this.mType != other.type()) {
            return false;
        }
        if (this.mAddress == null && other.address() != null) {
            return false;
        }
        if (!this.mAddress.equals(other.address())) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        String type = this.mRole == 1 ? AudioSystem.getInputDeviceName(this.mType) : AudioSystem.getOutputDeviceName(this.mType);
        return "{" + super.toString() + ", mType: " + type + ", mAddress: " + this.mAddress + "}";
    }
}

