/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.hardware.Camera;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRouting;
import android.media.CamcorderProfile;
import android.media.MediaCodec;
import android.media.MicrophoneInfo;
import android.media.NativeRoutingEventHandlerDelegate;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class MediaRecorder
implements AudioRouting {
    private static final String TAG = "MediaRecorder";
    private long mNativeContext;
    private Surface mSurface;
    private String mPath;
    private FileDescriptor mFd;
    private File mFile;
    private EventHandler mEventHandler;
    private OnErrorListener mOnErrorListener;
    private OnInfoListener mOnInfoListener;
    private int mChannelCount;
    public static final int MEDIA_RECORDER_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_RECORDER_INFO_UNKNOWN = 1;
    public static final int MEDIA_RECORDER_INFO_MAX_DURATION_REACHED = 800;
    public static final int MEDIA_RECORDER_INFO_MAX_FILESIZE_REACHED = 801;
    public static final int MEDIA_RECORDER_INFO_MAX_FILESIZE_APPROACHING = 802;
    public static final int MEDIA_RECORDER_INFO_NEXT_OUTPUT_FILE_STARTED = 803;
    public static final int MEDIA_RECORDER_TRACK_INFO_LIST_START = 1000;
    public static final int MEDIA_RECORDER_TRACK_INFO_COMPLETION_STATUS = 1000;
    public static final int MEDIA_RECORDER_TRACK_INFO_PROGRESS_IN_TIME = 1001;
    public static final int MEDIA_RECORDER_TRACK_INFO_TYPE = 1002;
    public static final int MEDIA_RECORDER_TRACK_INFO_DURATION_MS = 1003;
    public static final int MEDIA_RECORDER_TRACK_INFO_MAX_CHUNK_DUR_MS = 1004;
    public static final int MEDIA_RECORDER_TRACK_INFO_ENCODED_FRAMES = 1005;
    public static final int MEDIA_RECORDER_TRACK_INTER_CHUNK_TIME_MS = 1006;
    public static final int MEDIA_RECORDER_TRACK_INFO_INITIAL_DELAY_MS = 1007;
    public static final int MEDIA_RECORDER_TRACK_INFO_START_OFFSET_MS = 1008;
    public static final int MEDIA_RECORDER_TRACK_INFO_DATA_KBYTES = 1009;
    public static final int MEDIA_RECORDER_TRACK_INFO_LIST_END = 2000;
    private AudioDeviceInfo mPreferredDevice = null;
    @GuardedBy(value="mRoutingChangeListeners")
    private ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> mRoutingChangeListeners = new ArrayMap();

    public MediaRecorder() {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mChannelCount = 1;
        String packageName = ActivityThread.currentPackageName();
        this.native_setup(new WeakReference<MediaRecorder>(this), packageName, ActivityThread.currentOpPackageName());
    }

    @Deprecated
    public void setCamera(Camera camera) {
        OverrideMethod.invokeV("android.media.MediaRecorder#setCamera(Landroid/hardware/Camera;)V", true, this);
    }

    public Surface getSurface() {
        return (Surface)OverrideMethod.invokeA("android.media.MediaRecorder#getSurface()Landroid/view/Surface;", true, this);
    }

    public void setInputSurface(Surface surface) {
        if (!(surface instanceof MediaCodec.PersistentSurface)) {
            throw new IllegalArgumentException("not a PersistentSurface");
        }
        this.native_setInputSurface(surface);
    }

    private void native_setInputSurface(Surface surface) {
        OverrideMethod.invokeV("android.media.MediaRecorder#native_setInputSurface(Landroid/view/Surface;)V", true, this);
    }

    public void setPreviewDisplay(Surface sv) {
        this.mSurface = sv;
    }

    public static boolean isSystemOnlyAudioSource(int source) {
        switch (source) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    public static String toLogFriendlyAudioSource(int source) {
        switch (source) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "MIC";
            }
            case 2: {
                return "VOICE_UPLINK";
            }
            case 3: {
                return "VOICE_DOWNLINK";
            }
            case 4: {
                return "VOICE_CALL";
            }
            case 5: {
                return "CAMCORDER";
            }
            case 6: {
                return "VOICE_RECOGNITION";
            }
            case 7: {
                return "VOICE_COMMUNICATION";
            }
            case 8: {
                return "REMOTE_SUBMIX";
            }
            case 9: {
                return "UNPROCESSED";
            }
            case 1998: {
                return "RADIO_TUNER";
            }
            case 1999: {
                return "HOTWORD";
            }
            case -1: {
                return "AUDIO_SOURCE_INVALID";
            }
        }
        return "unknown source " + source;
    }

    public void setAudioSource(int n) throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#setAudioSource(I)V", true, this);
    }

    public static int getAudioSourceMax() {
        return 9;
    }

    public void setVideoSource(int n) throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#setVideoSource(I)V", true, this);
    }

    public void setProfile(CamcorderProfile profile) {
        this.setOutputFormat(profile.fileFormat);
        this.setVideoFrameRate(profile.videoFrameRate);
        this.setVideoSize(profile.videoFrameWidth, profile.videoFrameHeight);
        this.setVideoEncodingBitRate(profile.videoBitRate);
        this.setVideoEncoder(profile.videoCodec);
        if (profile.quality < 1000 || profile.quality > 1007) {
            this.setAudioEncodingBitRate(profile.audioBitRate);
            this.setAudioChannels(profile.audioChannels);
            this.setAudioSamplingRate(profile.audioSampleRate);
            this.setAudioEncoder(profile.audioCodec);
        }
    }

    public void setCaptureRate(double fps) {
        this.setParameter("time-lapse-enable=1");
        this.setParameter("time-lapse-fps=" + fps);
    }

    public void setOrientationHint(int degrees) {
        if (degrees != 0 && degrees != 90 && degrees != 180 && degrees != 270) {
            throw new IllegalArgumentException("Unsupported angle: " + degrees);
        }
        this.setParameter("video-param-rotation-angle-degrees=" + degrees);
    }

    public void setLocation(float latitude, float longitude) {
        int latitudex10000 = (int)((double)(latitude * 10000.0f) + 0.5);
        int longitudex10000 = (int)((double)(longitude * 10000.0f) + 0.5);
        if (latitudex10000 > 900000 || latitudex10000 < -900000) {
            String msg = "Latitude: " + latitude + " out of range.";
            throw new IllegalArgumentException(msg);
        }
        if (longitudex10000 > 1800000 || longitudex10000 < -1800000) {
            String msg = "Longitude: " + longitude + " out of range";
            throw new IllegalArgumentException(msg);
        }
        this.setParameter("param-geotag-latitude=" + latitudex10000);
        this.setParameter("param-geotag-longitude=" + longitudex10000);
    }

    public void setOutputFormat(int n) throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#setOutputFormat(I)V", true, this);
    }

    public void setVideoSize(int n, int n2) throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#setVideoSize(II)V", true, this);
    }

    public void setVideoFrameRate(int n) throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#setVideoFrameRate(I)V", true, this);
    }

    public void setMaxDuration(int n) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.media.MediaRecorder#setMaxDuration(I)V", true, this);
    }

    public void setMaxFileSize(long l) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.media.MediaRecorder#setMaxFileSize(J)V", true, this);
    }

    public void setAudioEncoder(int n) throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#setAudioEncoder(I)V", true, this);
    }

    public void setVideoEncoder(int n) throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#setVideoEncoder(I)V", true, this);
    }

    public void setAudioSamplingRate(int samplingRate) {
        if (samplingRate <= 0) {
            throw new IllegalArgumentException("Audio sampling rate is not positive");
        }
        this.setParameter("audio-param-sampling-rate=" + samplingRate);
    }

    public void setAudioChannels(int numChannels) {
        if (numChannels <= 0) {
            throw new IllegalArgumentException("Number of channels is not positive");
        }
        this.mChannelCount = numChannels;
        this.setParameter("audio-param-number-of-channels=" + numChannels);
    }

    public void setAudioEncodingBitRate(int bitRate) {
        if (bitRate <= 0) {
            throw new IllegalArgumentException("Audio encoding bit rate is not positive");
        }
        this.setParameter("audio-param-encoding-bitrate=" + bitRate);
    }

    public void setVideoEncodingBitRate(int bitRate) {
        if (bitRate <= 0) {
            throw new IllegalArgumentException("Video encoding bit rate is not positive");
        }
        this.setParameter("video-param-encoding-bitrate=" + bitRate);
    }

    public void setVideoEncodingProfileLevel(int profile, int level) {
        if (profile <= 0) {
            throw new IllegalArgumentException("Video encoding profile is not positive");
        }
        if (level <= 0) {
            throw new IllegalArgumentException("Video encoding level is not positive");
        }
        this.setParameter("video-param-encoder-profile=" + profile);
        this.setParameter("video-param-encoder-level=" + level);
    }

    public void setAuxiliaryOutputFile(FileDescriptor fd) {
        Log.w(TAG, "setAuxiliaryOutputFile(FileDescriptor) is no longer supported.");
    }

    public void setAuxiliaryOutputFile(String path) {
        Log.w(TAG, "setAuxiliaryOutputFile(String) is no longer supported.");
    }

    public void setOutputFile(FileDescriptor fd) throws IllegalStateException {
        this.mPath = null;
        this.mFile = null;
        this.mFd = fd;
    }

    public void setOutputFile(File file) {
        this.mPath = null;
        this.mFd = null;
        this.mFile = file;
    }

    public void setNextOutputFile(FileDescriptor fd) throws IOException {
        this._setNextOutputFile(fd);
    }

    public void setOutputFile(String path) throws IllegalStateException {
        this.mFd = null;
        this.mFile = null;
        this.mPath = path;
    }

    public void setNextOutputFile(File file) throws IOException {
        try (RandomAccessFile f = new RandomAccessFile(file, "rw");){
            this._setNextOutputFile(f.getFD());
        }
    }

    private void _setOutputFile(FileDescriptor fileDescriptor) throws IllegalStateException, IOException {
        OverrideMethod.invokeV("android.media.MediaRecorder#_setOutputFile(Ljava/io/FileDescriptor;)V", true, this);
    }

    private void _setNextOutputFile(FileDescriptor fileDescriptor) throws IllegalStateException, IOException {
        OverrideMethod.invokeV("android.media.MediaRecorder#_setNextOutputFile(Ljava/io/FileDescriptor;)V", true, this);
    }

    private void _prepare() throws IllegalStateException, IOException {
        OverrideMethod.invokeV("android.media.MediaRecorder#_prepare()V", true, this);
    }

    public void prepare() throws IllegalStateException, IOException {
        if (this.mPath != null) {
            try (RandomAccessFile file = new RandomAccessFile(this.mPath, "rw");){
                this._setOutputFile(file.getFD());
            }
        } else if (this.mFd != null) {
            this._setOutputFile(this.mFd);
        } else if (this.mFile != null) {
            try (RandomAccessFile file = new RandomAccessFile(this.mFile, "rw");){
                this._setOutputFile(file.getFD());
            }
        } else {
            throw new IOException("No valid output file");
        }
        this._prepare();
    }

    public void start() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#start()V", true, this);
    }

    public void stop() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#stop()V", true, this);
    }

    public void pause() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#pause()V", true, this);
    }

    public void resume() throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#resume()V", true, this);
    }

    public void reset() {
        this.native_reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
    }

    private void native_reset() {
        OverrideMethod.invokeV("android.media.MediaRecorder#native_reset()V", true, this);
    }

    public int getMaxAmplitude() throws IllegalStateException {
        return OverrideMethod.invokeI("android.media.MediaRecorder#getMaxAmplitude()I", true, this);
    }

    public void setOnErrorListener(OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public void setOnInfoListener(OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isSource()) {
            return false;
        }
        int preferredDeviceId = deviceInfo != null ? deviceInfo.getId() : 0;
        boolean status = this.native_setInputDevice(preferredDeviceId);
        if (status) {
            MediaRecorder mediaRecorder = this;
            synchronized (mediaRecorder) {
                this.mPreferredDevice = deviceInfo;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioDeviceInfo getPreferredDevice() {
        MediaRecorder mediaRecorder = this;
        synchronized (mediaRecorder) {
            return this.mPreferredDevice;
        }
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        int deviceId = this.native_getRoutedDeviceId();
        if (deviceId == 0) {
            return null;
        }
        AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(1);
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i].getId() != deviceId) continue;
            return devices[i];
        }
        return null;
    }

    @GuardedBy(value="mRoutingChangeListeners")
    private void enableNativeRoutingCallbacksLocked(boolean enabled) {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_enableDeviceCallback(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (listener != null && !this.mRoutingChangeListeners.containsKey(listener)) {
                this.enableNativeRoutingCallbacksLocked(true);
                this.mRoutingChangeListeners.put(listener, new NativeRoutingEventHandlerDelegate(this, listener, handler != null ? handler : this.mEventHandler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mRoutingChangeListeners.containsKey(listener)) {
                this.mRoutingChangeListeners.remove(listener);
                this.enableNativeRoutingCallbacksLocked(false);
            }
        }
    }

    private boolean native_setInputDevice(int n) {
        return OverrideMethod.invokeI("android.media.MediaRecorder#native_setInputDevice(I)Z", true, this) != 0;
    }

    private int native_getRoutedDeviceId() {
        return OverrideMethod.invokeI("android.media.MediaRecorder#native_getRoutedDeviceId()I", true, this);
    }

    private void native_enableDeviceCallback(boolean bl) {
        OverrideMethod.invokeV("android.media.MediaRecorder#native_enableDeviceCallback(Z)V", true, this);
    }

    public List<MicrophoneInfo> getActiveMicrophones() throws IOException {
        AudioDeviceInfo device;
        ArrayList<MicrophoneInfo> activeMicrophones = new ArrayList<MicrophoneInfo>();
        int status = this.native_getActiveMicrophones(activeMicrophones);
        if (status != 0) {
            if (status != -3) {
                Log.e(TAG, "getActiveMicrophones failed:" + status);
            }
            Log.i(TAG, "getActiveMicrophones failed, fallback on routed device info");
        }
        AudioManager.setPortIdForMicrophones(activeMicrophones);
        if (activeMicrophones.size() == 0 && (device = this.getRoutedDevice()) != null) {
            MicrophoneInfo microphone = AudioManager.microphoneInfoFromAudioDeviceInfo(device);
            ArrayList<Pair<Integer, Integer>> channelMapping = new ArrayList<Pair<Integer, Integer>>();
            for (int i = 0; i < this.mChannelCount; ++i) {
                channelMapping.add(new Pair<Integer, Integer>(i, 1));
            }
            microphone.setChannelMapping(channelMapping);
            activeMicrophones.add(microphone);
        }
        return activeMicrophones;
    }

    private int native_getActiveMicrophones(ArrayList<MicrophoneInfo> arrayList) {
        return OverrideMethod.invokeI("android.media.MediaRecorder#native_getActiveMicrophones(Ljava/util/ArrayList;)I", true, this);
    }

    private static void postEventFromNative(Object mediarecorder_ref, int what, int arg1, int arg2, Object obj) {
        MediaRecorder mr = (MediaRecorder)((WeakReference)mediarecorder_ref).get();
        if (mr == null) {
            return;
        }
        if (mr.mEventHandler != null) {
            Message m = mr.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mr.mEventHandler.sendMessage(m);
        }
    }

    public void release() {
        OverrideMethod.invokeV("android.media.MediaRecorder#release()V", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaRecorder#native_init()V", true, null);
    }

    private void native_setup(Object object, String string2, String string3) throws IllegalStateException {
        OverrideMethod.invokeV("android.media.MediaRecorder#native_setup(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaRecorder#native_finalize()V", true, this);
    }

    private void setParameter(String string2) {
        OverrideMethod.invokeV("android.media.MediaRecorder#setParameter(Ljava/lang/String;)V", true, this);
    }

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private PersistableBundle native_getMetrics() {
        return (PersistableBundle)OverrideMethod.invokeA("android.media.MediaRecorder#native_getMetrics()Landroid/os/PersistableBundle;", true, this);
    }

    protected void finalize() {
        this.native_finalize();
    }

    static {
        System.loadLibrary("media_jni");
        MediaRecorder.native_init();
    }

    public static class MetricsConstants {
        public static final String AUDIO_BITRATE = "android.media.mediarecorder.audio-bitrate";
        public static final String AUDIO_CHANNELS = "android.media.mediarecorder.audio-channels";
        public static final String AUDIO_SAMPLERATE = "android.media.mediarecorder.audio-samplerate";
        public static final String AUDIO_TIMESCALE = "android.media.mediarecorder.audio-timescale";
        public static final String CAPTURE_FPS = "android.media.mediarecorder.capture-fps";
        public static final String CAPTURE_FPS_ENABLE = "android.media.mediarecorder.capture-fpsenable";
        public static final String FRAMERATE = "android.media.mediarecorder.frame-rate";
        public static final String HEIGHT = "android.media.mediarecorder.height";
        public static final String MOVIE_TIMESCALE = "android.media.mediarecorder.movie-timescale";
        public static final String ROTATION = "android.media.mediarecorder.rotation";
        public static final String VIDEO_BITRATE = "android.media.mediarecorder.video-bitrate";
        public static final String VIDEO_IFRAME_INTERVAL = "android.media.mediarecorder.video-iframe-interval";
        public static final String VIDEO_LEVEL = "android.media.mediarecorder.video-encoder-level";
        public static final String VIDEO_PROFILE = "android.media.mediarecorder.video-encoder-profile";
        public static final String VIDEO_TIMESCALE = "android.media.mediarecorder.video-timescale";
        public static final String WIDTH = "android.media.mediarecorder.width";

        private MetricsConstants() {
        }
    }

    private class EventHandler
    extends Handler {
        private MediaRecorder mMediaRecorder;
        private static final int MEDIA_RECORDER_EVENT_LIST_START = 1;
        private static final int MEDIA_RECORDER_EVENT_ERROR = 1;
        private static final int MEDIA_RECORDER_EVENT_INFO = 2;
        private static final int MEDIA_RECORDER_EVENT_LIST_END = 99;
        private static final int MEDIA_RECORDER_TRACK_EVENT_LIST_START = 100;
        private static final int MEDIA_RECORDER_TRACK_EVENT_ERROR = 100;
        private static final int MEDIA_RECORDER_TRACK_EVENT_INFO = 101;
        private static final int MEDIA_RECORDER_TRACK_EVENT_LIST_END = 1000;
        private static final int MEDIA_RECORDER_AUDIO_ROUTING_CHANGED = 10000;

        public EventHandler(MediaRecorder mr, Looper looper) {
            super(looper);
            this.mMediaRecorder = mr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            if (this.mMediaRecorder.mNativeContext == 0L) {
                Log.w(MediaRecorder.TAG, "mediarecorder went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 1: 
                case 100: {
                    if (MediaRecorder.this.mOnErrorListener != null) {
                        MediaRecorder.this.mOnErrorListener.onError(this.mMediaRecorder, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 2: 
                case 101: {
                    if (MediaRecorder.this.mOnInfoListener != null) {
                        MediaRecorder.this.mOnInfoListener.onInfo(this.mMediaRecorder, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 10000: {
                    AudioManager.resetAudioPortGeneration();
                    ArrayMap arrayMap = MediaRecorder.this.mRoutingChangeListeners;
                    synchronized (arrayMap) {
                        for (NativeRoutingEventHandlerDelegate delegate : MediaRecorder.this.mRoutingChangeListeners.values()) {
                            delegate.notifyClient();
                        }
                    }
                    return;
                }
            }
            Log.e(MediaRecorder.TAG, "Unknown message type " + msg.what);
        }
    }

    public static interface OnInfoListener {
        public void onInfo(MediaRecorder var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public void onError(MediaRecorder var1, int var2, int var3);
    }

    public class VideoEncoder {
        public static final int DEFAULT = 0;
        public static final int H263 = 1;
        public static final int H264 = 2;
        public static final int MPEG_4_SP = 3;
        public static final int VP8 = 4;
        public static final int HEVC = 5;

        private VideoEncoder() {
        }
    }

    public class AudioEncoder {
        public static final int DEFAULT = 0;
        public static final int AMR_NB = 1;
        public static final int AMR_WB = 2;
        public static final int AAC = 3;
        public static final int HE_AAC = 4;
        public static final int AAC_ELD = 5;
        public static final int VORBIS = 6;

        private AudioEncoder() {
        }
    }

    public class OutputFormat {
        public static final int DEFAULT = 0;
        public static final int THREE_GPP = 1;
        public static final int MPEG_4 = 2;
        public static final int RAW_AMR = 3;
        public static final int AMR_NB = 3;
        public static final int AMR_WB = 4;
        public static final int AAC_ADIF = 5;
        public static final int AAC_ADTS = 6;
        public static final int OUTPUT_FORMAT_RTP_AVP = 7;
        public static final int MPEG_2_TS = 8;
        public static final int WEBM = 9;

        private OutputFormat() {
        }
    }

    public class VideoSource {
        public static final int DEFAULT = 0;
        public static final int CAMERA = 1;
        public static final int SURFACE = 2;

        private VideoSource() {
        }
    }

    public class AudioSource {
        public static final int AUDIO_SOURCE_INVALID = -1;
        public static final int DEFAULT = 0;
        public static final int MIC = 1;
        public static final int VOICE_UPLINK = 2;
        public static final int VOICE_DOWNLINK = 3;
        public static final int VOICE_CALL = 4;
        public static final int CAMCORDER = 5;
        public static final int VOICE_RECOGNITION = 6;
        public static final int VOICE_COMMUNICATION = 7;
        public static final int REMOTE_SUBMIX = 8;
        public static final int UNPROCESSED = 9;
        @SystemApi
        public static final int RADIO_TUNER = 1998;
        @SystemApi
        public static final int HOTWORD = 1999;

        private AudioSource() {
        }
    }
}

