/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkIdentity;
import android.net.NetworkStats;
import android.net.wifi.WifiInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.BackupUtils;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class NetworkTemplate
implements Parcelable {
    private static final String TAG = "NetworkTemplate";
    private static final int BACKUP_VERSION = 1;
    public static final int MATCH_MOBILE = 1;
    public static final int MATCH_WIFI = 4;
    public static final int MATCH_ETHERNET = 5;
    public static final int MATCH_MOBILE_WILDCARD = 6;
    public static final int MATCH_WIFI_WILDCARD = 7;
    public static final int MATCH_BLUETOOTH = 8;
    public static final int MATCH_PROXY = 9;
    private static boolean sForceAllNetworkTypes = false;
    private final int mMatchRule;
    private final String mSubscriberId;
    private final String[] mMatchSubscriberIds;
    private final String mNetworkId;
    private final int mMetered;
    private final int mRoaming;
    private final int mDefaultNetwork;
    public static final Parcelable.Creator<NetworkTemplate> CREATOR = new Parcelable.Creator<NetworkTemplate>(){

        @Override
        public NetworkTemplate createFromParcel(Parcel in) {
            return new NetworkTemplate(in);
        }

        public NetworkTemplate[] newArray(int size) {
            return new NetworkTemplate[size];
        }
    };

    private static boolean isKnownMatchRule(int rule) {
        switch (rule) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public static void forceAllNetworkTypes() {
        sForceAllNetworkTypes = true;
    }

    public static NetworkTemplate buildTemplateMobileAll(String subscriberId) {
        return new NetworkTemplate(1, subscriberId, null);
    }

    public static NetworkTemplate buildTemplateMobileWildcard() {
        return new NetworkTemplate(6, null, null);
    }

    public static NetworkTemplate buildTemplateWifiWildcard() {
        return new NetworkTemplate(7, null, null);
    }

    @Deprecated
    public static NetworkTemplate buildTemplateWifi() {
        return NetworkTemplate.buildTemplateWifiWildcard();
    }

    public static NetworkTemplate buildTemplateWifi(String networkId) {
        return new NetworkTemplate(4, null, networkId);
    }

    public static NetworkTemplate buildTemplateEthernet() {
        return new NetworkTemplate(5, null, null);
    }

    public static NetworkTemplate buildTemplateBluetooth() {
        return new NetworkTemplate(8, null, null);
    }

    public static NetworkTemplate buildTemplateProxy() {
        return new NetworkTemplate(9, null, null);
    }

    public NetworkTemplate(int matchRule, String subscriberId, String networkId) {
        this(matchRule, subscriberId, new String[]{subscriberId}, networkId);
    }

    public NetworkTemplate(int matchRule, String subscriberId, String[] matchSubscriberIds, String networkId) {
        this(matchRule, subscriberId, matchSubscriberIds, networkId, -1, -1, -1);
    }

    public NetworkTemplate(int matchRule, String subscriberId, String[] matchSubscriberIds, String networkId, int metered, int roaming, int defaultNetwork) {
        this.mMatchRule = matchRule;
        this.mSubscriberId = subscriberId;
        this.mMatchSubscriberIds = matchSubscriberIds;
        this.mNetworkId = networkId;
        this.mMetered = metered;
        this.mRoaming = roaming;
        this.mDefaultNetwork = defaultNetwork;
        if (!NetworkTemplate.isKnownMatchRule(matchRule)) {
            Log.e(TAG, "Unknown network template rule " + matchRule + " will not match any identity.");
        }
    }

    private NetworkTemplate(Parcel in) {
        this.mMatchRule = in.readInt();
        this.mSubscriberId = in.readString();
        this.mMatchSubscriberIds = in.createStringArray();
        this.mNetworkId = in.readString();
        this.mMetered = in.readInt();
        this.mRoaming = in.readInt();
        this.mDefaultNetwork = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMatchRule);
        dest.writeString(this.mSubscriberId);
        dest.writeStringArray(this.mMatchSubscriberIds);
        dest.writeString(this.mNetworkId);
        dest.writeInt(this.mMetered);
        dest.writeInt(this.mRoaming);
        dest.writeInt(this.mDefaultNetwork);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NetworkTemplate: ");
        builder.append("matchRule=").append(NetworkTemplate.getMatchRuleName(this.mMatchRule));
        if (this.mSubscriberId != null) {
            builder.append(", subscriberId=").append(NetworkIdentity.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mMatchSubscriberIds != null) {
            builder.append(", matchSubscriberIds=").append(Arrays.toString(NetworkIdentity.scrubSubscriberId(this.mMatchSubscriberIds)));
        }
        if (this.mNetworkId != null) {
            builder.append(", networkId=").append(this.mNetworkId);
        }
        if (this.mMetered != -1) {
            builder.append(", metered=").append(NetworkStats.meteredToString(this.mMetered));
        }
        if (this.mRoaming != -1) {
            builder.append(", roaming=").append(NetworkStats.roamingToString(this.mRoaming));
        }
        if (this.mDefaultNetwork != -1) {
            builder.append(", defaultNetwork=").append(NetworkStats.defaultNetworkToString(this.mDefaultNetwork));
        }
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.mMatchRule, this.mSubscriberId, this.mNetworkId, this.mMetered, this.mRoaming, this.mDefaultNetwork);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkTemplate) {
            NetworkTemplate other = (NetworkTemplate)obj;
            return this.mMatchRule == other.mMatchRule && Objects.equals(this.mSubscriberId, other.mSubscriberId) && Objects.equals(this.mNetworkId, other.mNetworkId) && this.mMetered == other.mMetered && this.mRoaming == other.mRoaming && this.mDefaultNetwork == other.mDefaultNetwork;
        }
        return false;
    }

    public boolean isMatchRuleMobile() {
        switch (this.mMatchRule) {
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isPersistable() {
        switch (this.mMatchRule) {
            case 6: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    public int getMatchRule() {
        return this.mMatchRule;
    }

    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public String getNetworkId() {
        return this.mNetworkId;
    }

    public boolean matches(NetworkIdentity ident) {
        if (!this.matchesMetered(ident)) {
            return false;
        }
        if (!this.matchesRoaming(ident)) {
            return false;
        }
        if (!this.matchesDefaultNetwork(ident)) {
            return false;
        }
        switch (this.mMatchRule) {
            case 1: {
                return this.matchesMobile(ident);
            }
            case 4: {
                return this.matchesWifi(ident);
            }
            case 5: {
                return this.matchesEthernet(ident);
            }
            case 6: {
                return this.matchesMobileWildcard(ident);
            }
            case 7: {
                return this.matchesWifiWildcard(ident);
            }
            case 8: {
                return this.matchesBluetooth(ident);
            }
            case 9: {
                return this.matchesProxy(ident);
            }
        }
        return false;
    }

    private boolean matchesMetered(NetworkIdentity ident) {
        return this.mMetered == -1 || this.mMetered == 1 && ident.mMetered || this.mMetered == 0 && !ident.mMetered;
    }

    private boolean matchesRoaming(NetworkIdentity ident) {
        return this.mRoaming == -1 || this.mRoaming == 1 && ident.mRoaming || this.mRoaming == 0 && !ident.mRoaming;
    }

    private boolean matchesDefaultNetwork(NetworkIdentity ident) {
        return this.mDefaultNetwork == -1 || this.mDefaultNetwork == 1 && ident.mDefaultNetwork || this.mDefaultNetwork == 0 && !ident.mDefaultNetwork;
    }

    public boolean matchesSubscriberId(String subscriberId) {
        return ArrayUtils.contains(this.mMatchSubscriberIds, subscriberId);
    }

    private boolean matchesMobile(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return (sForceAllNetworkTypes || ident.mType == 0 && ident.mMetered) && !ArrayUtils.isEmpty(this.mMatchSubscriberIds) && ArrayUtils.contains(this.mMatchSubscriberIds, ident.mSubscriberId);
    }

    private boolean matchesWifi(NetworkIdentity ident) {
        switch (ident.mType) {
            case 1: {
                return Objects.equals(WifiInfo.removeDoubleQuotes(this.mNetworkId), WifiInfo.removeDoubleQuotes(ident.mNetworkId));
            }
        }
        return false;
    }

    private boolean matchesEthernet(NetworkIdentity ident) {
        return ident.mType == 9;
    }

    private boolean matchesMobileWildcard(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return sForceAllNetworkTypes || ident.mType == 0 && ident.mMetered;
    }

    private boolean matchesWifiWildcard(NetworkIdentity ident) {
        switch (ident.mType) {
            case 1: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private boolean matchesBluetooth(NetworkIdentity ident) {
        return ident.mType == 7;
    }

    private boolean matchesProxy(NetworkIdentity ident) {
        return ident.mType == 16;
    }

    private static String getMatchRuleName(int matchRule) {
        switch (matchRule) {
            case 1: {
                return "MOBILE";
            }
            case 4: {
                return "WIFI";
            }
            case 5: {
                return "ETHERNET";
            }
            case 6: {
                return "MOBILE_WILDCARD";
            }
            case 7: {
                return "WIFI_WILDCARD";
            }
            case 8: {
                return "BLUETOOTH";
            }
            case 9: {
                return "PROXY";
            }
        }
        return "UNKNOWN(" + matchRule + ")";
    }

    public static NetworkTemplate normalize(NetworkTemplate template, String[] merged) {
        if (template.isMatchRuleMobile() && ArrayUtils.contains(merged, template.mSubscriberId)) {
            return new NetworkTemplate(template.mMatchRule, merged[0], merged, template.mNetworkId);
        }
        return template;
    }

    public byte[] getBytesForBackup() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(1);
        out.writeInt(this.mMatchRule);
        BackupUtils.writeString(out, this.mSubscriberId);
        BackupUtils.writeString(out, this.mNetworkId);
        return baos.toByteArray();
    }

    public static NetworkTemplate getNetworkTemplateFromBackup(DataInputStream in) throws IOException, BackupUtils.BadVersionException {
        int version = in.readInt();
        if (version < 1 || version > 1) {
            throw new BackupUtils.BadVersionException("Unknown Backup Serialization Version");
        }
        int matchRule = in.readInt();
        String subscriberId = BackupUtils.readString(in);
        String networkId = BackupUtils.readString(in);
        if (!NetworkTemplate.isKnownMatchRule(matchRule)) {
            throw new BackupUtils.BadVersionException("Restored network template contains unknown match rule " + matchRule);
        }
        return new NetworkTemplate(matchRule, subscriberId, networkId);
    }
}

