/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;

public class UidRange
implements Parcelable {
    public final int start;
    public final int stop;
    public static final Parcelable.Creator<UidRange> CREATOR = new Parcelable.Creator<UidRange>(){

        @Override
        public UidRange createFromParcel(Parcel in) {
            int start = in.readInt();
            int stop = in.readInt();
            return new UidRange(start, stop);
        }

        public UidRange[] newArray(int size) {
            return new UidRange[size];
        }
    };

    public UidRange(int startUid, int stopUid) {
        if (startUid < 0) {
            throw new IllegalArgumentException("Invalid start UID.");
        }
        if (stopUid < 0) {
            throw new IllegalArgumentException("Invalid stop UID.");
        }
        if (startUid > stopUid) {
            throw new IllegalArgumentException("Invalid UID range.");
        }
        this.start = startUid;
        this.stop = stopUid;
    }

    public static UidRange createForUser(int userId) {
        return new UidRange(userId * 100000, (userId + 1) * 100000 - 1);
    }

    public int getStartUser() {
        return this.start / 100000;
    }

    public boolean contains(int uid) {
        return this.start <= uid && uid <= this.stop;
    }

    public int count() {
        return 1 + this.stop - this.start;
    }

    public boolean containsRange(UidRange other) {
        return this.start <= other.start && other.stop <= this.stop;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.start;
        result = 31 * result + this.stop;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UidRange) {
            UidRange other = (UidRange)o;
            return this.start == other.start && this.stop == other.stop;
        }
        return false;
    }

    public String toString() {
        return this.start + "-" + this.stop;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.start);
        dest.writeInt(this.stop);
    }
}

