/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import libcore.io.Memory;

public class TlvBufferUtils {
    private TlvBufferUtils() {
    }

    public static boolean isValid(byte[] array2, int typeSize, int lengthSize) {
        if (typeSize < 0 || typeSize > 2) {
            throw new IllegalArgumentException("Invalid arguments - typeSize must be 0, 1, or 2: typeSize=" + typeSize);
        }
        if (lengthSize <= 0 || lengthSize > 2) {
            throw new IllegalArgumentException("Invalid arguments - lengthSize must be 1 or 2: lengthSize=" + lengthSize);
        }
        if (array2 == null) {
            return true;
        }
        int nextTlvIndex = 0;
        while (nextTlvIndex + typeSize + lengthSize <= array2.length) {
            nextTlvIndex += typeSize;
            if (lengthSize == 1) {
                nextTlvIndex += lengthSize + array2[nextTlvIndex];
                continue;
            }
            nextTlvIndex += lengthSize + Memory.peekShort(array2, nextTlvIndex, ByteOrder.BIG_ENDIAN);
        }
        return nextTlvIndex == array2.length;
    }

    public static class TlvIterable
    implements Iterable<TlvElement> {
        private int mTypeSize;
        private int mLengthSize;
        private byte[] mArray;
        private int mArrayLength;

        public TlvIterable(int typeSize, int lengthSize, byte[] array2) {
            if (typeSize < 0 || typeSize > 2 || lengthSize <= 0 || lengthSize > 2) {
                throw new IllegalArgumentException("Invalid sizes - typeSize=" + typeSize + ", lengthSize=" + lengthSize);
            }
            this.mTypeSize = typeSize;
            this.mLengthSize = lengthSize;
            this.mArray = array2;
            this.mArrayLength = array2 == null ? 0 : array2.length;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            boolean first = true;
            for (TlvElement tlv : this) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                builder.append(" (");
                if (this.mTypeSize != 0) {
                    builder.append("T=" + tlv.type + ",");
                }
                builder.append("L=" + tlv.length + ") ");
                if (tlv.length == 0) {
                    builder.append("<null>");
                } else if (tlv.length == 1) {
                    builder.append(tlv.getByte());
                } else if (tlv.length == 2) {
                    builder.append(tlv.getShort());
                } else if (tlv.length == 4) {
                    builder.append(tlv.getInt());
                } else {
                    builder.append("<bytes>");
                }
                if (tlv.length == 0) continue;
                builder.append(" (S='" + tlv.getString() + "')");
            }
            builder.append("]");
            return builder.toString();
        }

        public List<byte[]> toList() {
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (TlvElement tlv : this) {
                list.add(Arrays.copyOfRange(tlv.refArray, tlv.offset, tlv.offset + tlv.length));
            }
            return list;
        }

        @Override
        public Iterator<TlvElement> iterator() {
            return new Iterator<TlvElement>(){
                private int mOffset = 0;

                @Override
                public boolean hasNext() {
                    return this.mOffset < mArrayLength;
                }

                @Override
                public TlvElement next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    short type = 0;
                    if (mTypeSize == 1) {
                        type = mArray[this.mOffset];
                    } else if (mTypeSize == 2) {
                        type = Memory.peekShort(mArray, this.mOffset, ByteOrder.BIG_ENDIAN);
                    }
                    this.mOffset += mTypeSize;
                    short length = 0;
                    if (mLengthSize == 1) {
                        length = mArray[this.mOffset];
                    } else if (mLengthSize == 2) {
                        length = Memory.peekShort(mArray, this.mOffset, ByteOrder.BIG_ENDIAN);
                    }
                    this.mOffset += mLengthSize;
                    TlvElement tlv = new TlvElement(type, length, mArray, this.mOffset);
                    this.mOffset += length;
                    return tlv;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class TlvElement {
        public int type;
        public int length;
        public byte[] refArray;
        public int offset;

        private TlvElement(int type, int length, byte[] refArray, int offset) {
            this.type = type;
            this.length = length;
            this.refArray = refArray;
            this.offset = offset;
            if (offset + length > refArray.length) {
                throw new BufferOverflowException();
            }
        }

        public byte getByte() {
            if (this.length != 1) {
                throw new IllegalArgumentException("Accesing a byte from a TLV element of length " + this.length);
            }
            return this.refArray[this.offset];
        }

        public short getShort() {
            if (this.length != 2) {
                throw new IllegalArgumentException("Accesing a short from a TLV element of length " + this.length);
            }
            return Memory.peekShort(this.refArray, this.offset, ByteOrder.BIG_ENDIAN);
        }

        public int getInt() {
            if (this.length != 4) {
                throw new IllegalArgumentException("Accesing an int from a TLV element of length " + this.length);
            }
            return Memory.peekInt(this.refArray, this.offset, ByteOrder.BIG_ENDIAN);
        }

        public String getString() {
            return new String(this.refArray, this.offset, this.length);
        }
    }

    public static class TlvConstructor {
        private int mTypeSize;
        private int mLengthSize;
        private byte[] mArray;
        private int mArrayLength;
        private int mPosition;

        public TlvConstructor(int typeSize, int lengthSize) {
            if (typeSize < 0 || typeSize > 2 || lengthSize <= 0 || lengthSize > 2) {
                throw new IllegalArgumentException("Invalid sizes - typeSize=" + typeSize + ", lengthSize=" + lengthSize);
            }
            this.mTypeSize = typeSize;
            this.mLengthSize = lengthSize;
        }

        public TlvConstructor wrap(byte[] array2) {
            this.mArray = array2;
            this.mArrayLength = array2 == null ? 0 : array2.length;
            return this;
        }

        public TlvConstructor allocate(int capacity) {
            this.mArray = new byte[capacity];
            this.mArrayLength = capacity;
            return this;
        }

        public TlvConstructor allocateAndPut(List<byte[]> list) {
            if (list != null) {
                int size = 0;
                for (byte[] field : list) {
                    size += this.mTypeSize + this.mLengthSize;
                    if (field == null) continue;
                    size += field.length;
                }
                this.allocate(size);
                for (byte[] field : list) {
                    this.putByteArray(0, field);
                }
            }
            return this;
        }

        public TlvConstructor putByte(int type, byte b) {
            this.checkLength(1);
            this.addHeader(type, 1);
            this.mArray[this.mPosition++] = b;
            return this;
        }

        public TlvConstructor putByteArray(int type, byte[] array2, int offset, int length) {
            this.checkLength(length);
            this.addHeader(type, length);
            if (length != 0) {
                System.arraycopy(array2, offset, this.mArray, this.mPosition, length);
            }
            this.mPosition += length;
            return this;
        }

        public TlvConstructor putByteArray(int type, byte[] array2) {
            return this.putByteArray(type, array2, 0, array2 == null ? 0 : array2.length);
        }

        public TlvConstructor putZeroLengthElement(int type) {
            this.checkLength(0);
            this.addHeader(type, 0);
            return this;
        }

        public TlvConstructor putShort(int type, short data) {
            this.checkLength(2);
            this.addHeader(type, 2);
            Memory.pokeShort(this.mArray, this.mPosition, data, ByteOrder.BIG_ENDIAN);
            this.mPosition += 2;
            return this;
        }

        public TlvConstructor putInt(int type, int data) {
            this.checkLength(4);
            this.addHeader(type, 4);
            Memory.pokeInt(this.mArray, this.mPosition, data, ByteOrder.BIG_ENDIAN);
            this.mPosition += 4;
            return this;
        }

        public TlvConstructor putString(int type, String data) {
            byte[] bytes = null;
            int length = 0;
            if (data != null) {
                bytes = data.getBytes();
                length = bytes.length;
            }
            return this.putByteArray(type, bytes, 0, length);
        }

        public byte[] getArray() {
            return Arrays.copyOf(this.mArray, this.getActualLength());
        }

        private int getActualLength() {
            return this.mPosition;
        }

        private void checkLength(int dataLength) {
            if (this.mPosition + this.mTypeSize + this.mLengthSize + dataLength > this.mArrayLength) {
                throw new BufferOverflowException();
            }
        }

        private void addHeader(int type, int length) {
            if (this.mTypeSize == 1) {
                this.mArray[this.mPosition] = (byte)type;
            } else if (this.mTypeSize == 2) {
                Memory.pokeShort(this.mArray, this.mPosition, (short)type, ByteOrder.BIG_ENDIAN);
            }
            this.mPosition += this.mTypeSize;
            if (this.mLengthSize == 1) {
                this.mArray[this.mPosition] = (byte)length;
            } else if (this.mLengthSize == 2) {
                Memory.pokeShort(this.mArray, this.mPosition, (short)length, ByteOrder.BIG_ENDIAN);
            }
            this.mPosition += this.mLengthSize;
        }
    }
}

