/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2;

import android.graphics.drawable.Icon;
import android.net.Uri;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class OsuProvider
implements Parcelable {
    public static final int METHOD_OMA_DM = 0;
    public static final int METHOD_SOAP_XML_SPP = 1;
    private final WifiSsid mOsuSsid;
    private final String mFriendlyName;
    private final String mServiceDescription;
    private final Uri mServerUri;
    private final String mNetworkAccessIdentifier;
    private final List<Integer> mMethodList;
    private final Icon mIcon;
    public static final Parcelable.Creator<OsuProvider> CREATOR = new Parcelable.Creator<OsuProvider>(){

        @Override
        public OsuProvider createFromParcel(Parcel in) {
            WifiSsid osuSsid = (WifiSsid)in.readParcelable(null);
            String friendlyName = in.readString();
            String serviceDescription = in.readString();
            Uri serverUri = (Uri)in.readParcelable(null);
            String nai = in.readString();
            ArrayList<Integer> methodList = new ArrayList<Integer>();
            in.readList(methodList, null);
            Icon icon = (Icon)in.readParcelable(null);
            return new OsuProvider(osuSsid, friendlyName, serviceDescription, serverUri, nai, methodList, icon);
        }

        public OsuProvider[] newArray(int size) {
            return new OsuProvider[size];
        }
    };

    public OsuProvider(WifiSsid osuSsid, String friendlyName, String serviceDescription, Uri serverUri, String nai, List<Integer> methodList, Icon icon) {
        this.mOsuSsid = osuSsid;
        this.mFriendlyName = friendlyName;
        this.mServiceDescription = serviceDescription;
        this.mServerUri = serverUri;
        this.mNetworkAccessIdentifier = nai;
        this.mMethodList = methodList == null ? new ArrayList<Integer>() : new ArrayList<Integer>(methodList);
        this.mIcon = icon;
    }

    public OsuProvider(OsuProvider source) {
        if (source == null) {
            this.mOsuSsid = null;
            this.mFriendlyName = null;
            this.mServiceDescription = null;
            this.mServerUri = null;
            this.mNetworkAccessIdentifier = null;
            this.mMethodList = new ArrayList<Integer>();
            this.mIcon = null;
            return;
        }
        this.mOsuSsid = source.mOsuSsid;
        this.mFriendlyName = source.mFriendlyName;
        this.mServiceDescription = source.mServiceDescription;
        this.mServerUri = source.mServerUri;
        this.mNetworkAccessIdentifier = source.mNetworkAccessIdentifier;
        this.mMethodList = source.mMethodList == null ? new ArrayList<Integer>() : new ArrayList<Integer>(source.mMethodList);
        this.mIcon = source.mIcon;
    }

    public WifiSsid getOsuSsid() {
        return this.mOsuSsid;
    }

    public String getFriendlyName() {
        return this.mFriendlyName;
    }

    public String getServiceDescription() {
        return this.mServiceDescription;
    }

    public Uri getServerUri() {
        return this.mServerUri;
    }

    public String getNetworkAccessIdentifier() {
        return this.mNetworkAccessIdentifier;
    }

    public List<Integer> getMethodList() {
        return Collections.unmodifiableList(this.mMethodList);
    }

    public Icon getIcon() {
        return this.mIcon;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mOsuSsid, flags);
        dest.writeString(this.mFriendlyName);
        dest.writeString(this.mServiceDescription);
        dest.writeParcelable(this.mServerUri, flags);
        dest.writeString(this.mNetworkAccessIdentifier);
        dest.writeList(this.mMethodList);
        dest.writeParcelable(this.mIcon, flags);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof OsuProvider)) {
            return false;
        }
        OsuProvider that = (OsuProvider)thatObject;
        return (this.mOsuSsid == null ? that.mOsuSsid == null : this.mOsuSsid.equals(that.mOsuSsid)) && TextUtils.equals(this.mFriendlyName, that.mFriendlyName) && TextUtils.equals(this.mServiceDescription, that.mServiceDescription) && (this.mServerUri == null ? that.mServerUri == null : this.mServerUri.equals(that.mServerUri)) && TextUtils.equals(this.mNetworkAccessIdentifier, that.mNetworkAccessIdentifier) && (this.mMethodList == null ? that.mMethodList == null : this.mMethodList.equals(that.mMethodList)) && (this.mIcon == null ? that.mIcon == null : this.mIcon.sameAs(that.mIcon));
    }

    public int hashCode() {
        return Objects.hash(this.mOsuSsid, this.mFriendlyName, this.mServiceDescription, this.mServerUri, this.mNetworkAccessIdentifier, this.mMethodList, this.mIcon);
    }

    public String toString() {
        return "OsuProvider{mOsuSsid=" + this.mOsuSsid + " mFriendlyName=" + this.mFriendlyName + " mServiceDescription=" + this.mServiceDescription + " mServerUri=" + this.mServerUri + " mNetworkAccessIdentifier=" + this.mNetworkAccessIdentifier + " mMethodList=" + this.mMethodList + " mIcon=" + this.mIcon;
    }
}

